(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     60040,       1358]
NotebookOptionsPosition[     58992,       1320]
NotebookOutlinePosition[     59348,       1336]
CellTagsIndexPosition[     59305,       1333]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\:5408\:6d41\:578b\:8d85\:5e7e\:4f55\:95a2\:6570\:ff08\:52d5\:753b\:ff09\n",
 StyleBox[" Confluent hypergeometric functions (Animations)",
  FontSize->18]
}], "Subtitle",
 CellChangeTimes->{{3.7903677323391657`*^9, 3.7903677517768*^9}, {
  3.790367804239692*^9, 3.7903678345349455`*^9}, {3.963990272463924*^9, 
  3.9639902862888126`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "SpecialFunctions`KummerHypergeometric`"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.629361471337919*^9, 3.6293615011651716`*^9}, 
   3.669423874941815*^9},
 FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[{
 "\:78ba\:5b9a\:7279\:7570\:70b9\:306e\:5408\:6d41\:ff1a",
 StyleBox["Confluent of regular singularity",
  FontSize->14]
}], "Subsection",
 CellChangeTimes->{{3.790367844612563*^9, 3.79036791674709*^9}, {
  3.9639903545382233`*^9, 3.963990357334465*^9}, {3.9639903969031963`*^9, 
  3.963990409384654*^9}, {3.9639912503924475`*^9, 3.9639913619129305`*^9}, {
  3.963991436953205*^9, 3.9639914631188726`*^9}},
 FontSize->16],

Cell[TextData[{
 StyleBox["\:6ce8\:610f",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["\:ff1a\:3053\:306e\:52d5\:753b\:306f\:4f5c\:6210\:4e2d\:306b",
  FontColor->RGBColor[0.5, 0, 0.5]],
 StyleBox["\:7d045.0GB\:306e\:30e1\:30e2\:30ea\:30fc\:3092\:4f7f\:7528\:3059\
\:308b\:3002",
  FontColor->RGBColor[1, 0, 0]],
 "\n",
 StyleBox["Note",
  FontColor->RGBColor[1, 0, 0]],
 " : ",
 StyleBox["This movie ",
  FontColor->RGBColor[0.5, 0, 0.5]],
 StyleBox["uses 5.0GB memory",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" during creation.",
  FontColor->RGBColor[0.5, 0, 0.5]]
}], "Text",
 CellChangeTimes->{{3.7901985166538*^9, 3.7901987348825836`*^9}, {
   3.7901990805635905`*^9, 3.7901991759421577`*^9}, 3.7902017149090176`*^9, 
   3.790212764720835*^9, {3.790212806216908*^9, 3.790212853375791*^9}, {
   3.790212934409934*^9, 3.7902129459539537`*^9}, {3.790213118474657*^9, 
   3.7902132326668577`*^9}, {3.790369489408453*^9, 3.79036967004117*^9}, {
   3.790370237710567*^9, 3.7903702407837725`*^9}, {3.797108497944869*^9, 
   3.797108509801462*^9}, {3.805564481776891*^9, 3.805564483542101*^9}, {
   3.805564568881427*^9, 3.8055645706310744`*^9}, {3.8133679881791077`*^9, 
   3.813368008100308*^9}, {3.8133687592383084`*^9, 3.8133687606755347`*^9}, {
   3.825487368365831*^9, 3.825487384018417*^9}, {3.8337540717666492`*^9, 
   3.8337540748440504`*^9}, {3.8522721858095407`*^9, 
   3.8522721911676903`*^9}, {3.86398310543474*^9, 3.8639831116520147`*^9}, {
   3.887683759142175*^9, 3.8876837667653704`*^9}, {3.9185456557684174`*^9, 
   3.9185456719051075`*^9}, {3.963990663943632*^9, 3.9639906758939285`*^9}},
 FontFamily->"Times New Roman"],

Cell["\<\
\:3000PlotLabel \:5185\:306b\:3042\:308b\:30c6\:30ad\:30b9\:30c8\:306f\:3001\
\:597d\:307f\:306e\:30d5\:30a9\:30f3\:30c8\:306b\:5909\:66f4\:3057\:3066\:4e0b\
\:3055\:3044\:3002
\:3000Change the text in \[OpenCurlyDoubleQuote]PlotLabel\
\[CloseCurlyDoubleQuote] to your favorite font.\
\>", "Text",
 CellChangeTimes->{{3.7901985166538*^9, 3.7901987348825836`*^9}, {
   3.7901990805635905`*^9, 3.7901991759421577`*^9}, 3.7902017149090176`*^9}],

Cell[BoxData[
 RowBox[{"moveFrom2F1to1F1", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "=", "2.7"}], ",", 
      RowBox[{"\[Gamma]", "=", 
       RowBox[{"-", "3.4"}]}], ",", "f", ",", "g", ",", "bTable"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"\[Beta]_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"\[Beta]", "<", "\[Infinity]"}], ",", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", 
          RowBox[{"z", "/", "\[Beta]"}]}], "]"}], ",", 
        RowBox[{"Hypergeometric1F1", "[", 
         RowBox[{"\[Alpha]", ",", "\[Gamma]", ",", "z"}], "]"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x", "<", "n"}], ",", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "/", "n"}], ")"}], "2"]}], ",", 
        RowBox[{"1", "+", 
         RowBox[{"Exp", "[", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "/", "n"}], "-", "1"}], ")"}]}], "]"}]}]}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"bTable", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", "4", "}"}]}], "]"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"g", "[", 
            RowBox[{"3", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", "13.5", ",", "0.1"}], "]"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "6", "}"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DensityPlot", "[", 
        RowBox[{
         RowBox[{"Arg", "[", 
          RowBox[{"f", "[", 
           RowBox[{"\[Beta]", ",", 
            RowBox[{"x", "+", 
             RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "4"}], ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", "\[IndentingNewLine]", 
         RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
         StyleBox[
          RowBox[{"Exclusions", "\[Rule]", "None"}],
          FontColor->GrayLevel[0]], ",", "\[IndentingNewLine]", 
         RowBox[{"ColorFunction", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Hue", "[", 
             RowBox[{"#", 
              StyleBox["/",
               FontColor->GrayLevel[0]], 
              StyleBox[
               RowBox[{"(", 
                RowBox[{"2", " ", "Pi"}], ")"}],
               FontColor->GrayLevel[0]]}], "]"}], "&"}], ")"}]}], ",", 
         StyleBox[
          RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
          FontColor->GrayLevel[0]], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
         RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
         RowBox[{"FrameTicksStyle", "\[Rule]", "10"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRegion", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Framed", "[", 
           RowBox[{
            RowBox[{"Style", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"\[Beta]", "<", "\[Infinity]"}], ",", 
                   "\"\<\!\(\*SubscriptBox[\(\[InvisiblePrefixScriptBase]\), \
\(2\)]\)\!\(\*SubscriptBox[
StyleBox[\"F\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"], \"1\"]\)(\[Alpha],\[Beta];\[Gamma];z/\[Beta])\>\"", 
                   ",", "\"\<\!\(\*SubscriptBox[\(\[InvisiblePrefixScriptBase]\
\), \(1\)]\)\!\(\*SubscriptBox[
StyleBox[\"F\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"], \"1\"]\)(\[Alpha];\[Gamma];z)\>\""}], "]"}], ",", 
                 "\[IndentingNewLine]", "\"\<\!\(\*
StyleBox[\"\:3000\",
FontFamily->\"Courier New\",
FontSize->6]\)\!\(\*
StyleBox[\";\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\"\:3000\",
FontFamily->\"Courier New\",
FontSize->8]\)\!\(\*
StyleBox[\"\[Beta]\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->8]\)\!\(\*
StyleBox[\"=\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->6]\)\>\"", ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"IntegerQ", "[", "\[Beta]", "]"}], ",", "\[Beta]", 
                   ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "\[Beta]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"6", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], "}"}],
                "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"FrameMargins", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"FrameStyle", "\[Rule]", "None"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", "330"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Beta]", ",", "bTable"}], "}"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.929919901957844*^9, 3.92991990575379*^9}, {
   3.9299199673019543`*^9, 3.9299199675050297`*^9}, {3.9299220447138367`*^9, 
   3.9299221410975647`*^9}, {3.9299221786044717`*^9, 3.929922193179189*^9}, {
   3.929925440380336*^9, 3.929925466171194*^9}, 3.9299255106920395`*^9, 
   3.929926026548775*^9, 3.9299260600878315`*^9, {3.9299267446723514`*^9, 
   3.929926745078441*^9}, 3.929927216671509*^9, {3.9299307475183907`*^9, 
   3.9299307610152054`*^9}, 3.963990852034624*^9, 3.963991023400355*^9, {
   3.963991106082852*^9, 3.963991126468623*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240move_confluent1.gif\>\"", ",", "moveFrom2F1to1F1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "140"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.657338436484969*^9, 3.6573384377329717`*^9}, {
   3.6573385996924562`*^9, 3.6573386017672596`*^9}, {3.657338633419715*^9, 
   3.657338655696554*^9}, 3.6573387265362787`*^9, {3.657350124024101*^9, 
   3.657350127237706*^9}, {3.657352150746818*^9, 3.6573521509808187`*^9}, 
   3.65735224859019*^9, {3.6574196532174406`*^9, 3.6574196566338468`*^9}, {
   3.6574205201221647`*^9, 3.657420525847375*^9}, {3.6574222587232265`*^9, 
   3.6574222768972588`*^9}, {3.6574978824536204`*^9, 3.6574978952300425`*^9}, 
   3.65750146212833*^9, {3.657876415914661*^9, 3.657876434119893*^9}, {
   3.658968059773799*^9, 3.6589680672774124`*^9}, 3.6589681037346764`*^9, {
   3.658969436243965*^9, 3.6589694392547703`*^9}, 3.6590552182907352`*^9, 
   3.6590552571972036`*^9, 3.6590577484949417`*^9, 3.6707174614998217`*^9, {
   3.6707174962566833`*^9, 3.6707174992986884`*^9}, 3.670785961973773*^9, 
   3.910224283960535*^9, {3.9103047054724164`*^9, 3.9103047150014505`*^9}, {
   3.92991267566247*^9, 3.9299127295092735`*^9}, 3.9639907520633965`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.8196078431372549, 0.9372549019607843]],

Cell[TextData[{
 StyleBox["\:6ce8\:610f",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["\:ff1a\:3053\:306e\:52d5\:753b\:306f\:4f5c\:6210\:4e2d\:306b",
  FontColor->RGBColor[0.5, 0, 0.5]],
 StyleBox["\:7d0412.1GB\:306e\:30e1\:30e2\:30ea\:30fc\:3092\:4f7f\:7528\:3059\
\:308b\:3002",
  FontColor->RGBColor[1, 0, 0]],
 "\n",
 StyleBox["Note",
  FontColor->RGBColor[1, 0, 0]],
 " : ",
 StyleBox["This movie ",
  FontColor->RGBColor[0.5, 0, 0.5]],
 StyleBox["uses 12.1GB memory",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" during creation.",
  FontColor->RGBColor[0.5, 0, 0.5]]
}], "Text",
 CellChangeTimes->{{3.7901985166538*^9, 3.7901987348825836`*^9}, {
   3.7901990805635905`*^9, 3.7901991759421577`*^9}, 3.7902017149090176`*^9, 
   3.790212764720835*^9, {3.790212806216908*^9, 3.790212853375791*^9}, {
   3.790212934409934*^9, 3.7902129459539537`*^9}, {3.790213118474657*^9, 
   3.7902132326668577`*^9}, {3.790369489408453*^9, 3.79036967004117*^9}, {
   3.790370237710567*^9, 3.7903702407837725`*^9}, {3.797108497944869*^9, 
   3.797108509801462*^9}, {3.805564481776891*^9, 3.805564483542101*^9}, {
   3.805564568881427*^9, 3.8055645706310744`*^9}, {3.8133679881791077`*^9, 
   3.813368008100308*^9}, {3.8133687592383084`*^9, 3.8133687606755347`*^9}, {
   3.825487368365831*^9, 3.825487384018417*^9}, {3.8337540717666492`*^9, 
   3.8337540748440504`*^9}, {3.8522721858095407`*^9, 
   3.8522721911676903`*^9}, {3.86398310543474*^9, 3.8639831116520147`*^9}, {
   3.887683759142175*^9, 3.8876837667653704`*^9}, {3.9185456557684174`*^9, 
   3.9185456719051075`*^9}, {3.963990663943632*^9, 3.963990708323784*^9}},
 FontFamily->"Times New Roman"],

Cell["\<\
\:3000PlotLabel \:5185\:306b\:3042\:308b\:30c6\:30ad\:30b9\:30c8\:306f\:3001\
\:597d\:307f\:306e\:30d5\:30a9\:30f3\:30c8\:306b\:5909\:66f4\:3057\:3066\:4e0b\
\:3055\:3044\:3002
\:3000Change the text in \[OpenCurlyDoubleQuote]PlotLabel\
\[CloseCurlyDoubleQuote] to your favorite font.\
\>", "Text",
 CellChangeTimes->{{3.7901985166538*^9, 3.7901987348825836`*^9}, {
   3.7901990805635905`*^9, 3.7901991759421577`*^9}, 3.7902017149090176`*^9}],

Cell[BoxData[
 RowBox[{"moveFrom2F1to1F1Sph", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "=", "2.7"}], ",", 
      RowBox[{"\[Gamma]", "=", 
       RowBox[{"-", "3.4"}]}], ",", "f", ",", "g", ",", "bTable", ",", 
      RowBox[{"alen", "=", "1.25"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"\[Beta]_", ",", "z_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"\[Beta]", "<", "\[Infinity]"}], ",", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", 
          RowBox[{"z", "/", "\[Beta]"}]}], "]"}], ",", 
        RowBox[{"Hypergeometric1F1", "[", 
         RowBox[{"\[Alpha]", ",", "\[Gamma]", ",", "z"}], "]"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"x", "<", "n"}], ",", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "/", "n"}], ")"}], "2"]}], ",", 
        RowBox[{"1", "+", 
         RowBox[{"Exp", "[", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "/", "n"}], "-", "1"}], ")"}]}], "]"}]}]}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"bTable", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", "4", "}"}]}], "]"}], ",", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"g", "[", 
            RowBox[{"3", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", "13.6", ",", "0.2"}], "]"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"\[Infinity]", ",", 
          RowBox[{"{", "6", "}"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"SphericalPlot3D", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", 
             RowBox[{"2", " ", 
              RowBox[{"ArcCot", "[", "1100", "]"}]}], ",", "3.14159265358"}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Phi]", ",", "0", ",", 
             RowBox[{
              RowBox[{"2", " ", "\[Pi]"}], "+", "0.0000001"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ColorFunction", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Hue", "[", 
                 RowBox[{
                  RowBox[{"Arg", "[", 
                   RowBox[{"f", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    RowBox[{"#4", "/", "2"}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"#5", "*", "I"}], "]"}]}]}], "]"}], "]"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", " ", "\[Pi]"}], ")"}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Specularity", "[", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", "40"}], "]"}], 
                ",", 
                RowBox[{"Opacity", "[", "0.6", "]"}]}], "]"}], "&"}], ")"}]}],
            ",", "\[IndentingNewLine]", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", "None"}], ",", 
           RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
            RowBox[{"Specularity", "[", 
             RowBox[{"White", ",", "100"}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Thickness", "[", "0.0026", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", 
                 RowBox[{"-", "alen"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", 
                 RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"0.98", " ", "alen"}], ",", "0", ",", "0"}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
             "\[IndentingNewLine]", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", 
                 RowBox[{"0.97", " ", "alen"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{
                  RowBox[{"-", "0.98"}], " ", "alen"}], ",", "0"}], "}"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<\!\(\*
StyleBox[\"0\",
FontFamily->\"Courier New\"]\)\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", 
                RowBox[{
                 RowBox[{"-", "1.09"}], " ", "alen"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<\!\(\*
StyleBox[\"1\",
FontFamily->\"Courier New\"]\)\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1.04", " ", "alen"}], ",", "0", ",", "0"}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<\!\(\*
StyleBox[\"\[Infinity]\",
FontFamily->\"Courier New\"]\)\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", 
                RowBox[{"1.02", " ", "alen"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<\!\(\*
StyleBox[\"-\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\"i\",
FontFamily->\"Courier New\",
FontSize->14,
FontSlant->\"Italic\"]\)\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{
                 RowBox[{"-", "1.08"}], " ", "alen"}], ",", "0"}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"\[Beta]", "<", "\[Infinity]"}], ",", 
                    "\"\<\!\(\*SubscriptBox[\(\[InvisiblePrefixScriptBase]\), \
\(2\)]\)\!\(\*SubscriptBox[
StyleBox[\"F\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"], \"1\"]\)(\[Alpha],\[Beta];\[Gamma];z/\[Beta])\>\"", 
                    ",", "\"\<\!\(\*SubscriptBox[\(\
\[InvisiblePrefixScriptBase]\), \(1\)]\)\!\(\*SubscriptBox[
StyleBox[\"F\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"], \"1\"]\)(\[Alpha];\[Gamma];z)\>\""}], "]"}], ",", 
                   "\[IndentingNewLine]", "\"\<\!\(\*
StyleBox[\"\:3000\",
FontFamily->\"Courier New\",
FontSize->6]\)\!\(\*
StyleBox[\";\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\"\:3000\",
FontFamily->\"Courier New\",
FontSize->8]\)\!\(\*
StyleBox[\"\[Beta]\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->8]\)\!\(\*
StyleBox[\"=\",
FontFamily->\"Courier New\"]\)\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->6]\)\>\"", ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"IntegerQ", "[", "\[Beta]", "]"}], ",", "\[Beta]",
                     ",", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "\[Beta]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"6", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], "}"}],
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}], 
                ",", "13"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{"1.04", " ", "alen"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1.08"}], " ", "alen"}], ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1.09"}], " ", "alen"}], ",", 
              RowBox[{"1.02", " ", "alen"}]}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ViewPoint", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"2.12", ",", 
            RowBox[{"-", "2.12"}], ",", "1.56"}], "}"}]}], ",", 
         RowBox[{"ViewVertical", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
         RowBox[{"Axes", "\[Rule]", "False"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Beta]", ",", "bTable"}], "}"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.9299717773529124`*^9, 3.929971788881507*^9}, 
   3.929971906354089*^9, {3.929971939185177*^9, 3.929971988345582*^9}, {
   3.9299720806327114`*^9, 3.929972125794081*^9}, {3.929972184913624*^9, 
   3.9299722115011663`*^9}, {3.9299730059943953`*^9, 3.929973039361642*^9}, {
   3.929973193424505*^9, 3.929973247349424*^9}, 3.9299732851218176`*^9, {
   3.929973326893319*^9, 3.9299734160045705`*^9}, {3.929973456791936*^9, 
   3.9299735908855963`*^9}, 3.9299736313918047`*^9, {3.929973682098686*^9, 
   3.9299738868790507`*^9}, 3.9299739370860777`*^9, 3.929973986121507*^9, {
   3.9299740246906223`*^9, 3.9299740395777855`*^9}, 3.9299740723670025`*^9, {
   3.929974136789461*^9, 3.9299741656733418`*^9}, {3.92997419615061*^9, 
   3.929974348880554*^9}, 3.9299747216158457`*^9, {3.9299749650367312`*^9, 
   3.929975115548414*^9}, {3.9299752913191376`*^9, 3.9299753319815483`*^9}, {
   3.929975467574955*^9, 3.9299754794158955`*^9}, {3.9299755403078985`*^9, 
   3.9299756160402575`*^9}, {3.9299756487200947`*^9, 
   3.9299756997863016`*^9}, {3.929975899272931*^9, 3.929975908489503*^9}, {
   3.9299759402477493`*^9, 3.9299760057636747`*^9}, {3.9299761140977974`*^9, 
   3.9299761271728725`*^9}, 3.9299761692099285`*^9, {3.9299762038112*^9, 
   3.9299762693740654`*^9}, {3.929976315066517*^9, 3.929976318706286*^9}, {
   3.929976357025443*^9, 3.9299764024279428`*^9}, {3.9299764705370502`*^9, 
   3.929976475692093*^9}, {3.929976527679951*^9, 3.9299765314603205`*^9}, {
   3.9299765950079594`*^9, 3.929976817161083*^9}, 3.9299768872697215`*^9, {
   3.9299781061777387`*^9, 3.929978183559608*^9}, {3.9299782583858833`*^9, 
   3.9299782586045895`*^9}, {3.929978330837736*^9, 3.929978341632083*^9}, 
   3.9299789506461916`*^9, 3.9299790403127527`*^9, {3.929979495175351*^9, 
   3.9299796356425323`*^9}, {3.929980323669475*^9, 3.9299803623635716`*^9}, 
   3.9299803934344406`*^9, {3.9299805095479665`*^9, 3.9299805102040696`*^9}, {
   3.9299805507726927`*^9, 3.929980715296838*^9}, {3.929980757974358*^9, 
   3.9299807589116535`*^9}, {3.929980913453694*^9, 3.929980919905287*^9}, {
   3.929980955928158*^9, 3.9299809595366945`*^9}, {3.929981007931655*^9, 
   3.9299810102123613`*^9}, {3.929981172667472*^9, 3.9299812726930103`*^9}, 
   3.929981309543778*^9, 3.9299813742005777`*^9, 3.9299814697644925`*^9, {
   3.9299815038034153`*^9, 3.9299815226896334`*^9}, {3.929981560836952*^9, 
   3.929981573021634*^9}, 3.9299816038738165`*^9, {3.929981737211791*^9, 
   3.929981747928046*^9}, {3.9299817789832997`*^9, 3.9299820510448017`*^9}, 
   3.9299820943003306`*^9, {3.9299821337598705`*^9, 3.9299821352438974`*^9}, 
   3.929982215209605*^9, {3.929982257934007*^9, 3.929982291035658*^9}, {
   3.9639911371223726`*^9, 3.9639911464951534`*^9}, {3.9639912083086557`*^9, 
   3.9639912145415573`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240move_confluent2.gif\>\"", ",", "moveFrom2F1to1F1Sph", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "150"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.657338436484969*^9, 3.6573384377329717`*^9}, {
   3.6573385996924562`*^9, 3.6573386017672596`*^9}, {3.657338633419715*^9, 
   3.657338655696554*^9}, 3.6573387265362787`*^9, {3.657350124024101*^9, 
   3.657350127237706*^9}, {3.657352150746818*^9, 3.6573521509808187`*^9}, 
   3.65735224859019*^9, {3.6574196532174406`*^9, 3.6574196566338468`*^9}, {
   3.6574205201221647`*^9, 3.657420525847375*^9}, {3.6574222587232265`*^9, 
   3.6574222768972588`*^9}, {3.6574978824536204`*^9, 3.6574978952300425`*^9}, 
   3.65750146212833*^9, {3.657876415914661*^9, 3.657876434119893*^9}, {
   3.658968059773799*^9, 3.6589680672774124`*^9}, 3.6589681037346764`*^9, {
   3.658969436243965*^9, 3.6589694392547703`*^9}, 3.6590552182907352`*^9, 
   3.6590552571972036`*^9, 3.6590577484949417`*^9, 3.6707174614998217`*^9, {
   3.6707174962566833`*^9, 3.6707174992986884`*^9}, 3.670785961973773*^9, 
   3.910224283960535*^9, {3.9103047054724164`*^9, 3.9103047150014505`*^9}, {
   3.92991267566247*^9, 3.9299127295092735`*^9}, {3.9299266440764976`*^9, 
   3.929926653317189*^9}, 3.9299821526929555`*^9, 3.963990774053115*^9},
 Background->RGBColor[
  0.9019607843137255, 0.8196078431372549, 0.9372549019607843]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "\:7b2c1\:7a2e\:5408\:6d41\:578b\:8d85\:5e7e\:4f55\:95a2\:6570\:ff1a",
 StyleBox["Confluent hypergeometric f",
  FontFamily->"Arial",
  FontSize->14],
 StyleBox["unction of first kind",
  FontSize->14]
}], "Subsection",
 CellChangeTimes->{{3.790367844612563*^9, 3.79036791674709*^9}, {
   3.9103045408861723`*^9, 3.9103046129785995`*^9}, {3.910307581920992*^9, 
   3.9103076113983603`*^9}, 3.9639903698627577`*^9, {3.9639904339256845`*^9, 
   3.9639904577169294`*^9}},
 FontSize->16],

Cell[BoxData[
 RowBox[{"moveHypergeom1F1Den", "=", "\[IndentingNewLine]", 
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"GraphicsRow", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DensityPlot", "[", 
           RowBox[{
            RowBox[{"Arg", "[", 
             RowBox[{"Hypergeometric1F1", "[", 
              RowBox[{
               RowBox[{"2.4", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"-", "0.7"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{"x", "+", 
                RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"120", ",", "180"}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"#", 
                 StyleBox["/",
                  FontColor->GrayLevel[0]], 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"2", " ", "Pi"}], ")"}],
                  FontColor->GrayLevel[0]]}], "]"}], "&"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            StyleBox[
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
             FontColor->GrayLevel[0]], ",", 
            StyleBox[
             RowBox[{"Exclusions", "\[Rule]", "None"}],
             FontColor->GrayLevel[0]], ",", "\[IndentingNewLine]", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
            RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
            RowBox[{"FrameTicksStyle", "\[Rule]", "10"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotLabel", "\[Rule]", 
             RowBox[{"Framed", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[InvisiblePrefixScriptBase]\), \(1\
\)]\)\!\(\*SubscriptBox[
StyleBox[\"F\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"], \"1\"]\)(\[Alpha];\[Gamma];z)\>\"", ",", 
                 RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"FrameMargins", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"FrameStyle", "\[Rule]", "None"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ImageSize", "\[Rule]", "240"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"DensityPlot", "[", 
           RowBox[{
            RowBox[{"Arg", "[", 
             RowBox[{"Hypergeometric1F1Exp", "[", 
              RowBox[{
               RowBox[{"2.4", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"-", "0.7"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{"x", "+", 
                RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{
               RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
              RowBox[{"3", " ", "\[Pi]"}]}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"100", ",", "240"}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"#", 
                 StyleBox["/",
                  FontColor->GrayLevel[0]], 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"2", " ", "Pi"}], ")"}],
                  FontColor->GrayLevel[0]]}], "]"}], "&"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            StyleBox[
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
             FontColor->GrayLevel[0]], ",", 
            StyleBox[
             RowBox[{"Exclusions", "\[Rule]", "None"}],
             FontColor->GrayLevel[0]], ",", "\[IndentingNewLine]", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
            RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FrameTicks", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Range", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
                   RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
                 "None"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
            RowBox[{"FrameTicksStyle", "\[Rule]", "10"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotLabel", "\[Rule]", 
             RowBox[{"Framed", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[InvisiblePrefixScriptBase]\), \(1\
\)]\)\!\(\*SubscriptBox[
StyleBox[\"F\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"], \"1\"]\)(\[Alpha];\[Gamma];exp(z))\>\"", ",", 
                 RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"FrameMargins", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"FrameStyle", "\[Rule]", "None"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ImageSize", "\[Rule]", "180"}]}], "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Spacings", "\[Rule]", "0"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<\[Alpha]=2.4\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->6]\)exp(\!\(\*
StyleBox[\"i\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"]\)\[Pi]\[Theta])\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->8]\); \[Gamma]=-0.7\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->6]\)exp(\!\(\*
StyleBox[\"i\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"]\)\[Pi]\[Theta])\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->8]\), \[Theta]=\>\"", ",", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"N", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], "]"}], 
       "]"}], ",", "Top", ",", 
      RowBox[{"Spacings", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", 
      RowBox[{"1", "/", "50"}], ",", "2", ",", 
      RowBox[{"1", "/", "50"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.806545142800646*^9, 3.806545143378624*^9}, 
   3.8065451874152346`*^9, 3.8065452183767457`*^9, {3.806545475682397*^9, 
   3.806545480446911*^9}, {3.8065455906475987`*^9, 3.806545648665331*^9}, 
   3.8065458820953407`*^9, {3.8200942766863985`*^9, 3.8200942878556347`*^9}, {
   3.8200944745613737`*^9, 3.820094477185785*^9}, 3.820094555682788*^9, 
   3.8200946477391357`*^9, {3.8200964168710346`*^9, 3.820096424244309*^9}, {
   3.8292895134704866`*^9, 3.8292895526416965`*^9}, 3.8292895878834543`*^9, {
   3.8292896530712576`*^9, 3.829289751485671*^9}, {3.82928981087801*^9, 
   3.829289811237303*^9}, {3.8292898465415173`*^9, 3.8292898468227015`*^9}, {
   3.8292899573592386`*^9, 3.829289957640423*^9}, 3.829290534188527*^9, {
   3.8295131543743095`*^9, 3.829513177181432*^9}, {3.829513213579175*^9, 
   3.829513215875512*^9}, {3.8295132822973948`*^9, 3.829513308431922*^9}, {
   3.8295133391122255`*^9, 3.829513367792988*^9}, {3.8295134014569387`*^9, 
   3.829513435292785*^9}, {3.82951347051886*^9, 3.829513483812617*^9}, 
   3.8295159231190405`*^9, 3.8295161818407445`*^9, 3.829516230876399*^9, 
   3.8295162633375063`*^9, 3.8295163004069605`*^9, {3.829595793516797*^9, 
   3.82959582311925*^9}, {3.9608779745495424`*^9, 3.9608779946697435`*^9}, {
   3.960878068246105*^9, 3.960878100363508*^9}, {3.960878134304076*^9, 
   3.960878182730115*^9}, 3.9608782163002596`*^9, {3.960878269902647*^9, 
   3.960878353835558*^9}, {3.9608784719637527`*^9, 3.9608785464949055`*^9}, {
   3.960878681587431*^9, 3.960878704692035*^9}, 3.960878781908205*^9, {
   3.960878835161181*^9, 3.9608789521647134`*^9}, {3.960878991936575*^9, 
   3.9608790205079*^9}, {3.960879058123996*^9, 3.9608791158916044`*^9}, {
   3.960879241518116*^9, 3.960879367269594*^9}, 3.9608794288643975`*^9, {
   3.9608794885533895`*^9, 3.960879521764371*^9}, {3.9608797102665634`*^9, 
   3.9608797148279147`*^9}, {3.9608799769263906`*^9, 3.9608800089813423`*^9}, 
   3.9608800892279663`*^9, {3.960880146776808*^9, 3.9608802800577974`*^9}, 
   3.9608826939779787`*^9, {3.96088272506437*^9, 3.960882735515067*^9}, {
   3.960882769147685*^9, 3.960882871467249*^9}, {3.9608830410364475`*^9, 
   3.960883074544172*^9}, {3.960883148120509*^9, 3.9608831891732597`*^9}, 
   3.9608832237119904`*^9, {3.960883306083119*^9, 3.960883316424491*^9}, 
   3.960883354712226*^9, {3.9608833923439407`*^9, 3.960883392718858*^9}, {
   3.9608835450555706`*^9, 3.9608835510541487`*^9}, {3.9608835839994755`*^9, 
   3.96088358749865*^9}, {3.960883632159949*^9, 3.9608837277466955`*^9}, {
   3.960883812367331*^9, 3.960883816178939*^9}, 3.9608838801325502`*^9, {
   3.9608839378688846`*^9, 3.9608839527091103`*^9}, {3.960884044468608*^9, 
   3.960884047264851*^9}, 3.9608840891562204`*^9, 3.963991652035493*^9, {
   3.963991745372814*^9, 3.963991756557659*^9}, {3.9639917935957713`*^9, 
   3.9639918386632442`*^9}, 3.963992039490673*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240move_0010.gif\>\"", ",", "moveHypergeom1F1Den", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "140"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.657338436484969*^9, 3.6573384377329717`*^9}, {
   3.6573385996924562`*^9, 3.6573386017672596`*^9}, {3.657338633419715*^9, 
   3.657338655696554*^9}, 3.6573387265362787`*^9, {3.657350124024101*^9, 
   3.657350127237706*^9}, {3.657352150746818*^9, 3.6573521509808187`*^9}, 
   3.65735224859019*^9, {3.6574196532174406`*^9, 3.6574196566338468`*^9}, {
   3.6574205201221647`*^9, 3.657420525847375*^9}, {3.6574222587232265`*^9, 
   3.6574222768972588`*^9}, {3.6574978824536204`*^9, 3.6574978952300425`*^9}, 
   3.65750146212833*^9, {3.657876415914661*^9, 3.657876434119893*^9}, {
   3.6583533340841227`*^9, 3.658353337921729*^9}, {3.658353533866074*^9, 
   3.658353541244887*^9}, 3.6583542070828643`*^9, 3.658354411287223*^9, {
   3.674588731693192*^9, 3.6745887341735964`*^9}, {3.6745887973841076`*^9, 
   3.6745888233433533`*^9}, 3.6745938683527193`*^9, 3.7301045613792067`*^9, 
   3.791188595675892*^9, {3.7911886302927375`*^9, 3.7911886305583*^9}, 
   3.791188710351919*^9, {3.794540396468463*^9, 3.794540404122943*^9}, 
   3.7945411140352693`*^9, {3.7945433171752586`*^9, 3.794543319987097*^9}, 
   3.794543754370263*^9, 3.7945499093163013`*^9, 3.79524085429747*^9, {
   3.806545105325*^9, 3.806545129897399*^9}, {3.8065452060983906`*^9, 
   3.8065452068013535`*^9}, {3.8200943016648293`*^9, 3.820094305960721*^9}, {
   3.829289535137334*^9, 3.8292895405109873`*^9}, {3.8292898210006075`*^9, 
   3.8292898382153187`*^9}, 3.8292899645919166`*^9, 3.8292905371722045`*^9, 
   3.8293262366965413`*^9, 3.829412411369362*^9, 3.829516146021026*^9, {
   3.8295957421570816`*^9, 3.8295957482650537`*^9}, {3.829595801155659*^9, 
   3.82959581093462*^9}, {3.960878226657226*^9, 3.9608782339836097`*^9}},
 Background->RGBColor[
  0.9019607843137255, 0.8196078431372549, 0.9372549019607843]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "\:7b2c2\:7a2e\:5408\:6d41\:578b\:8d85\:5e7e\:4f55\:95a2\:6570\:ff1a",
 StyleBox["Confluent hypergeometric",
  FontFamily->"Arial",
  FontSize->14],
 StyleBox[" function of second kind",
  FontSize->14]
}], "Subsection",
 CellChangeTimes->{{3.790367844612563*^9, 3.7903679436103373`*^9}, 
   3.963990374705394*^9, 3.9639904675896287`*^9},
 FontSize->16],

Cell[BoxData[
 RowBox[{"moveHypergeomUDen", "=", "\[IndentingNewLine]", 
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"GraphicsRow", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DensityPlot", "[", 
           RowBox[{
            RowBox[{"Arg", "[", 
             RowBox[{"HypergeometricU", "[", 
              RowBox[{
               RowBox[{"2.4", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"-", "0.7"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{"x", "+", 
                RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"120", ",", "180"}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"#", 
                 StyleBox["/",
                  FontColor->GrayLevel[0]], 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"2", " ", "Pi"}], ")"}],
                  FontColor->GrayLevel[0]]}], "]"}], "&"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            StyleBox[
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
             FontColor->GrayLevel[0]], ",", 
            StyleBox[
             RowBox[{"Exclusions", "\[Rule]", "None"}],
             FontColor->GrayLevel[0]], ",", "\[IndentingNewLine]", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
            RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
            RowBox[{"FrameTicksStyle", "\[Rule]", "10"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotLabel", "\[Rule]", 
             RowBox[{"Framed", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*
StyleBox[\"U\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"]\)(\[Alpha];\[Gamma];z)\>\"", ",", 
                 RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"FrameMargins", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"FrameStyle", "\[Rule]", "None"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ImageSize", "\[Rule]", "240"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"DensityPlot", "[", 
           RowBox[{
            RowBox[{"Arg", "[", 
             RowBox[{"HypergeometricUExp", "[", 
              RowBox[{
               RowBox[{"2.4", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"-", "0.7"}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{"I", " ", "\[Pi]", " ", "\[Theta]"}], "]"}]}], ",", 
               RowBox[{"x", "+", 
                RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{
               RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
              RowBox[{"3", " ", "\[Pi]"}]}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"100", ",", "240"}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"#", 
                 StyleBox["/",
                  FontColor->GrayLevel[0]], 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"2", " ", "Pi"}], ")"}],
                  FontColor->GrayLevel[0]]}], "]"}], "&"}], ")"}]}], ",", 
            "\[IndentingNewLine]", 
            StyleBox[
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
             FontColor->GrayLevel[0]], ",", 
            StyleBox[
             RowBox[{"Exclusions", "\[Rule]", "None"}],
             FontColor->GrayLevel[0]], ",", "\[IndentingNewLine]", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
            RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"FrameTicks", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Range", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
                   RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
                 "None"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
            RowBox[{"FrameTicksStyle", "\[Rule]", "10"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotLabel", "\[Rule]", 
             RowBox[{"Framed", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*
StyleBox[\"U\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"]\)(\[Alpha];\[Gamma];exp(z))\>\"", ",", 
                 RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"FrameMargins", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"FrameStyle", "\[Rule]", "None"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ImageSize", "\[Rule]", "180"}]}], "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Spacings", "\[Rule]", "0"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<\[Alpha]=2.4\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->6]\)exp(\!\(\*
StyleBox[\"i\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"]\)\[Pi]\[Theta])\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->8]\); \[Gamma]=-0.7\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->6]\)exp(\!\(\*
StyleBox[\"i\",
FontFamily->\"Courier New\",
FontSlant->\"Italic\"]\)\[Pi]\[Theta])\!\(\*
StyleBox[\" \",
FontFamily->\"Courier New\",
FontSize->8]\), \[Theta]=\>\"", ",", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"N", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<CenturyOldst\>\""}]}], "]"}], 
       "]"}], ",", "Top", ",", 
      RowBox[{"Spacings", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", 
      RowBox[{"1", "/", "50"}], ",", "2", ",", 
      RowBox[{"1", "/", "50"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.806545142800646*^9, 3.806545143378624*^9}, 
   3.8065451874152346`*^9, 3.8065452183767457`*^9, {3.806545475682397*^9, 
   3.806545480446911*^9}, {3.8065455906475987`*^9, 3.806545648665331*^9}, 
   3.8065458820953407`*^9, {3.8200942766863985`*^9, 3.8200942878556347`*^9}, {
   3.8200944745613737`*^9, 3.820094477185785*^9}, 3.820094555682788*^9, 
   3.8200946477391357`*^9, {3.8200964168710346`*^9, 3.820096424244309*^9}, {
   3.8292895134704866`*^9, 3.8292895526416965`*^9}, 3.8292895878834543`*^9, {
   3.8292896530712576`*^9, 3.829289751485671*^9}, {3.82928981087801*^9, 
   3.829289811237303*^9}, {3.8292898465415173`*^9, 3.8292898468227015`*^9}, {
   3.8292899573592386`*^9, 3.829289957640423*^9}, 3.829290534188527*^9, {
   3.8295131543743095`*^9, 3.829513177181432*^9}, {3.829513213579175*^9, 
   3.829513215875512*^9}, {3.8295132822973948`*^9, 3.829513308431922*^9}, {
   3.8295133391122255`*^9, 3.829513367792988*^9}, {3.8295134014569387`*^9, 
   3.829513435292785*^9}, {3.82951347051886*^9, 3.829513483812617*^9}, 
   3.8295159231190405`*^9, 3.8295161818407445`*^9, 3.829516230876399*^9, 
   3.8295162633375063`*^9, 3.8295163004069605`*^9, {3.829595793516797*^9, 
   3.82959582311925*^9}, {3.9608779745495424`*^9, 3.9608779946697435`*^9}, {
   3.960878068246105*^9, 3.960878100363508*^9}, {3.960878134304076*^9, 
   3.960878182730115*^9}, 3.9608782163002596`*^9, {3.960878269902647*^9, 
   3.960878353835558*^9}, {3.9608784719637527`*^9, 3.9608785464949055`*^9}, {
   3.960878681587431*^9, 3.960878704692035*^9}, 3.960878781908205*^9, {
   3.960878835161181*^9, 3.9608789521647134`*^9}, {3.960878991936575*^9, 
   3.9608790205079*^9}, {3.960879058123996*^9, 3.9608791158916044`*^9}, {
   3.960879241518116*^9, 3.960879367269594*^9}, 3.9608794288643975`*^9, {
   3.9608794885533895`*^9, 3.960879521764371*^9}, {3.9608797102665634`*^9, 
   3.9608797148279147`*^9}, {3.9608799769263906`*^9, 3.9608800089813423`*^9}, 
   3.9608800892279663`*^9, {3.960880146776808*^9, 3.9608802800577974`*^9}, 
   3.9608826939779787`*^9, {3.96088272506437*^9, 3.960882735515067*^9}, {
   3.960882769147685*^9, 3.960882871467249*^9}, {3.9608830410364475`*^9, 
   3.960883074544172*^9}, {3.960883148120509*^9, 3.9608831891732597`*^9}, 
   3.9608832237119904`*^9, {3.960883306083119*^9, 3.960883316424491*^9}, 
   3.960883354712226*^9, {3.9608833923439407`*^9, 3.960883392718858*^9}, {
   3.9608835450555706`*^9, 3.9608835510541487`*^9}, {3.9608835839994755`*^9, 
   3.96088358749865*^9}, {3.960883632159949*^9, 3.9608837277466955`*^9}, {
   3.960883812367331*^9, 3.960883816178939*^9}, 3.9608838801325502`*^9, {
   3.9608839378688846`*^9, 3.9608839527091103`*^9}, {3.960884044468608*^9, 
   3.960884047264851*^9}, 3.9608840891562204`*^9, {3.9608844576798897`*^9, 
   3.9608844932652087`*^9}, {3.9639917074286337`*^9, 3.9639917313917456`*^9}, 
   3.963992061219906*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240move_0020.gif\>\"", ",", "moveHypergeomUDen", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "140"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.657338436484969*^9, 3.6573384377329717`*^9}, {
   3.6573385996924562`*^9, 3.6573386017672596`*^9}, {3.657338633419715*^9, 
   3.657338655696554*^9}, 3.6573387265362787`*^9, {3.657350124024101*^9, 
   3.657350127237706*^9}, {3.657352150746818*^9, 3.6573521509808187`*^9}, 
   3.65735224859019*^9, {3.6574196532174406`*^9, 3.6574196566338468`*^9}, {
   3.6574205201221647`*^9, 3.657420525847375*^9}, {3.6574222587232265`*^9, 
   3.6574222768972588`*^9}, {3.6574978824536204`*^9, 3.6574978952300425`*^9}, 
   3.65750146212833*^9, {3.657876415914661*^9, 3.657876434119893*^9}, {
   3.6583533340841227`*^9, 3.658353337921729*^9}, {3.658353533866074*^9, 
   3.658353541244887*^9}, 3.6583542070828643`*^9, 3.658354411287223*^9, {
   3.674588731693192*^9, 3.6745887341735964`*^9}, {3.6745887973841076`*^9, 
   3.6745888233433533`*^9}, 3.6745938683527193`*^9, 3.7301045613792067`*^9, 
   3.791188595675892*^9, {3.7911886302927375`*^9, 3.7911886305583*^9}, 
   3.791188710351919*^9, {3.794540396468463*^9, 3.794540404122943*^9}, 
   3.7945411140352693`*^9, {3.7945433171752586`*^9, 3.794543319987097*^9}, 
   3.794543754370263*^9, 3.7945499093163013`*^9, 3.79524085429747*^9, {
   3.806545105325*^9, 3.806545129897399*^9}, {3.8065452060983906`*^9, 
   3.8065452068013535`*^9}, {3.8200943016648293`*^9, 3.820094305960721*^9}, {
   3.829289535137334*^9, 3.8292895405109873`*^9}, {3.8292898210006075`*^9, 
   3.8292898382153187`*^9}, 3.8292899645919166`*^9, 3.8292905371722045`*^9, 
   3.8293262366965413`*^9, 3.829412411369362*^9, 3.829516146021026*^9, {
   3.8295957421570816`*^9, 3.8295957482650537`*^9}, {3.829595801155659*^9, 
   3.82959581093462*^9}, {3.960878226657226*^9, 3.9608782339836097`*^9}, {
   3.9608842318114786`*^9, 3.96088423616982*^9}},
 Background->RGBColor[
  0.9019607843137255, 0.8196078431372549, 0.9372549019607843]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1026, 790},
WindowMargins->{{Automatic, 103}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (2011\:5e743\:670821\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 356, 7, 108, "Subtitle"],
Cell[938, 31, 252, 6, 43, "Input"],
Cell[CellGroupData[{
Cell[1215, 41, 437, 9, 59, "Subsection"],
Cell[1655, 52, 1640, 33, 66, "Text"],
Cell[3298, 87, 451, 8, 66, "Text"],
Cell[3752, 97, 7409, 187, 591, "Input"],
Cell[11164, 286, 1319, 19, 67, "Input"],
Cell[12486, 307, 1640, 33, 66, "Text"],
Cell[14129, 342, 451, 8, 66, "Text"],
Cell[14583, 352, 13399, 311, 645, "Input"],
Cell[27985, 665, 1396, 20, 67, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[29418, 690, 500, 12, 45, "Subsection"],
Cell[29921, 704, 12422, 269, 935, "Input"],
Cell[42346, 975, 1980, 28, 67, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[44363, 1008, 370, 10, 45, "Subsection"],
Cell[44736, 1020, 12196, 265, 881, "Input"],
Cell[56935, 1287, 2029, 29, 67, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
