(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    138952,       2905]
NotebookOptionsPosition[    137445,       2859]
NotebookOutlinePosition[    137801,       2875]
CellTagsIndexPosition[    137758,       2872]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Kummer\:66f2\:9762",
 StyleBox["\:ff08Kummer surface\:ff09",
  FontSize->18]
}], "Subtitle",
 CellChangeTimes->{{3.790453314440241*^9, 3.790453314440241*^9}, 
   3.790453375233548*^9, {3.790453429011243*^9, 3.7904534457812724`*^9}, {
   3.7904589563653536`*^9, 3.790458966676972*^9}, {3.7904635600966415`*^9, 
   3.79046357675747*^9}, {3.790625848811887*^9, 3.7906258666895185`*^9}, {
   3.790625899574376*^9, 3.7906259185596094`*^9}, {3.790639763835931*^9, 
   3.790639794021984*^9}, {3.7906398443320723`*^9, 3.7906398491056805`*^9}, {
   3.79071314645372*^9, 3.7907131936906033`*^9}, {3.7907379125308247`*^9, 
   3.79073794421448*^9}, {3.790997118297472*^9, 3.790997148031124*^9}, {
   3.792443974276103*^9, 3.7924439979725447`*^9}, {3.7924444681417704`*^9, 
   3.792444528217476*^9}, {3.7924445911635866`*^9, 3.792444606139613*^9}, {
   3.793335332358374*^9, 3.79333536430723*^9}, {3.8133697950321784`*^9, 
   3.8133697985626054`*^9}, 3.8134375082554893`*^9, 3.813437540076204*^9, {
   3.8134377088494015`*^9, 3.813437865063057*^9}, {3.9662395204187946`*^9, 
   3.9662395645334244`*^9}}],

Cell["\<\
copyright (c)\:ff1aSouichiro - Ikebe
\:3000\:3000\:3000\:3000\:3000\:3000http://math-functions-1.watson.jp\
\>", "Text",
 CellChangeTimes->{{3.8134378866517467`*^9, 3.8134380285671396`*^9}},
 FontSize->16],

Cell[CellGroupData[{

Cell["Kummer\:66f2\:9762\:306816\:500b\:306e\:4e8c\:6b21\:66f2\:7dda", \
"Subsection",
 CellChangeTimes->{{3.7919383799675164`*^9, 3.791938420636299*^9}, {
   3.7925406892758727`*^9, 3.792540690806723*^9}, 3.792541282337391*^9, 
   3.792568199190987*^9, {3.7926128959688015`*^9, 3.792612908637776*^9}, {
   3.792613597361525*^9, 3.792613608108979*^9}, {3.7926220434181156`*^9, 
   3.7926220515099754`*^9}, {3.7926220943748283`*^9, 
   3.7926221282261887`*^9}, {3.792623679120697*^9, 3.7926236861346593`*^9}, {
   3.792742199792473*^9, 3.7927422197252607`*^9}, 3.793590937418809*^9, {
   3.8424035281402135`*^9, 3.842403541840135*^9}, {3.959540055253907*^9, 
   3.959540081419583*^9}, {3.9595404747638874`*^9, 3.9595404826526423`*^9}, {
   3.963177797148718*^9, 3.9631778934540815`*^9}, {3.966159411385903*^9, 
   3.966159452688693*^9}, 3.966239613987847*^9, 3.966239678163946*^9, {
   3.9662397219721365`*^9, 3.966239761806486*^9}},
 FontFamily->"Arial",
 FontSize->18,
 FontWeight->"Plain"],

Cell[TextData[{
 "\:3000Ivan Cheltsov",
 StyleBox[" ",
  FontSize->6],
 "\:306e\:8ad6\:6587\:ff62Kummer quartic double solids\:ff63 (Rendiconti del \
Circolo Matematico di Palermo Series 2, vol.72, pp.1993-2023) \:306b\:57fa\
\:3065\:304f\:3001Kummer\:66f2\:9762\:304a\:3088\:3073\:305d\:306e\:66f2\:9762\
\:4e0a\:306b\:3042\:308b16\:500b\:306e\:4e8c\:6b21\:66f2\:7dda\:306e\:65b9\
\:7a0b\:5f0f\:3002"
}], "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.9661801229281425`*^9, 
   3.966180199223225*^9}, {3.966180271487482*^9, 3.9661803835705147`*^9}, {
   3.9661945525023727`*^9, 3.966194672064705*^9}, 3.9662397967201543`*^9, 
   3.966239958775961*^9, {3.9662400337739916`*^9, 3.9662400998522077`*^9}, {
   3.9662401660085316`*^9, 3.966240267328433*^9}},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"KummerSurface", "[", 
     RowBox[{"t_", ",", 
      RowBox[{"{", 
       RowBox[{"x0_", ",", "x1_", ",", "x2_", ",", "x3_"}], "}"}]}], "]"}], ":=",
     "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["t", "2"]}], "-", "1"}]}], ",", 
        RowBox[{"b", "=", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["t", "2"]}], "-", "1"}]}], ",", 
        RowBox[{"c", "=", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["t", "2"]}], "-", "1"}]}], ",", 
        RowBox[{"d", "=", 
         RowBox[{
          SuperscriptBox["t", "3"], "+", 
          RowBox[{"3", " ", "t"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       SuperscriptBox["x0", "4"], "+", 
       SuperscriptBox["x1", "4"], "+", 
       SuperscriptBox["x2", "4"], "+", 
       SuperscriptBox["x3", "4"], "+", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x0", "2"], " ", 
           SuperscriptBox["x1", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["x2", "2"], " ", 
           SuperscriptBox["x3", "2"]}]}], ")"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x0", "2"], " ", 
           SuperscriptBox["x2", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["x1", "2"], " ", 
           SuperscriptBox["x3", "2"]}]}], ")"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x0", "2"], " ", 
           SuperscriptBox["x3", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["x1", "2"], " ", 
           SuperscriptBox["x2", "2"]}]}], ")"}]}], "+", 
       RowBox[{
       "2", " ", "d", "*", "x0", "*", "x1", "*", "x2", "*", "x3"}]}]}], 
     "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"KummerParameterABCD", "[", "t_", "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["t", "2"]}], "-", "1"}], ",", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["t", "2"]}], "-", "1"}], ",", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["t", "2"]}], "-", "1"}], ",", 
      RowBox[{
       SuperscriptBox["t", "3"], "+", 
       RowBox[{"3", " ", "t"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"KummerSurface16Tropes", "[", 
    RowBox[{"n_", ",", "t_", ",", 
     RowBox[{"{", 
      RowBox[{"x0_", ",", "x1_", ",", "x2_", ",", "x3_"}], "}"}]}], "]"}], ":=",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "coef", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"coef", "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1", ",", "t"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "t"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "t"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}], ",", "t"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "t", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", "t", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", 
             RowBox[{"-", "t"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "t"}], ",", "1"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"1", ",", "t", ",", "1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "t"}], ",", 
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "t"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "t", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"t", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "1", ",", 
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "}"}], "[", 
         RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Dot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}], ",", 
         "coef"}], "]"}]}]}], "]"}], "/;", "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"1", "<=", "n", "<=", "16"}]}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"KummerSurface16Conics", "[", 
   RowBox[{"n_", ",", "t_", ",", 
    RowBox[{"{", 
     RowBox[{"x0_", ",", "x1_", ",", "x2_", ",", "x3_"}], "}"}]}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "coef", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"coef", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
            "t", ",", "t"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "t", ",", 
            RowBox[{"-", "t"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "t"}], ",", "t"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "1", ",", 
            RowBox[{"-", "t"}], ",", 
            RowBox[{"-", "t"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "t", ",", "1", ",", 
            "0", ",", "0", ",", "t"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "t", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0", ",", 
            RowBox[{"-", "t"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
            RowBox[{"-", "t"}], ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "t"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "1", ",", "0", ",", 
            RowBox[{"-", "t"}], ",", "1", ",", "0", ",", "0", ",", 
            RowBox[{"-", "t"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "t", ",", "0", ",", 
            "1", ",", "0", ",", "t", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
            RowBox[{"-", "t"}], ",", "0", ",", "1", ",", "0", ",", 
            RowBox[{"-", "t"}], ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
            RowBox[{"-", "t"}], ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "t", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "t", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", 
            RowBox[{"-", "t"}], ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", "0", ",", 
            RowBox[{"-", "t"}], ",", 
            RowBox[{"-", "t"}], ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "t", ",", "t", ",", "0", ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", "0", ",", "t", ",", 
            RowBox[{"-", "t"}], ",", "0", ",", "1", ",", "0", ",", "0"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}], ",", "0", ",", 
            RowBox[{"-", "t"}], ",", "t", ",", "0", ",", "1", ",", "0", ",", 
            "0"}], "}"}]}], "}"}], "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Dot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x0", "^", "2"}], ",", 
          RowBox[{"x1", "^", "2"}], ",", 
          RowBox[{"x2", "^", "2"}], ",", 
          RowBox[{"x3", "^", "2"}], ",", 
          RowBox[{"x0", "*", "x1"}], ",", 
          RowBox[{"x0", "*", "x2"}], ",", 
          RowBox[{"x0", "*", "x3"}], ",", 
          RowBox[{"x1", "*", "x2"}], ",", 
          RowBox[{"x1", "*", "x3"}], ",", 
          RowBox[{"x2", "*", "x3"}]}], "}"}], ",", "coef"}], "]"}]}]}], "]"}],
    "/;", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"1", "<=", "n", "<=", "16"}]}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.9631732965377097`*^9, 3.96317340880805*^9}, {
   3.963173456968528*^9, 3.9631735200785856`*^9}, {3.9631735507900724`*^9, 
   3.9631735816890116`*^9}, {3.9631743760823116`*^9, 
   3.9631743792847095`*^9}, {3.9631744141202126`*^9, 
   3.9631744216184454`*^9}, {3.9631750337470074`*^9, 
   3.9631750376366816`*^9}, {3.96614513451867*^9, 3.966145176133882*^9}, {
   3.966145209032397*^9, 3.9661453463282456`*^9}, {3.9661453965439854`*^9, 
   3.966145559828258*^9}, {3.966145617033553*^9, 3.9661456731940403`*^9}, {
   3.966145733374757*^9, 3.96614575988418*^9}, {3.966145947058936*^9, 
   3.966146064906234*^9}, {3.9661461081929393`*^9, 3.9661461691661386`*^9}, {
   3.9661462620661793`*^9, 3.966146377795991*^9}, {3.9661464222247334`*^9, 
   3.9661467293252296`*^9}, 3.9661812289888606`*^9, {3.966183498055132*^9, 
   3.966183506459411*^9}, 3.966192186774888*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[TextData[{
 "\:3000\:540c\:8ad6\:6587\:306e26\:9801\:306b\:63b2\:8f09\:3055\:308c\:3066\
\:3044\:308b16\:500b\:306e\:4e8c\:6b21\:66f2\:7dda\:306e\:65b9\:7a0b\:5f0f\
\:3092\:3001",
 StyleBox["MeshFunctions",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->8],
 "\:306e\:6307\:5b9a\:5024\:3068\:3057\:3066\:4f7f\:7528\:3059\:308b\:3002\n\
\:3000\:3057\:304b\:3057\:3001Kummer\:66f2\:9762\:306e\:30b3\:30fc\:30c9\:5185\
\:3067\:4f7f\:7528\:3059\:308b\:3068\:3001\:4f59\:8a08\:306a\:30e1\:30c3\:30b7\
\:30e5\:3082\:5f15\:304b\:308c\:3066\:3057\:307e\:3046\:3002"
}], "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.9661797663713617`*^9, 
   3.966179777321886*^9}, {3.966179814016385*^9, 3.96617983807323*^9}, {
   3.9661798852965307`*^9, 3.9661799257870207`*^9}, 3.966193518637607*^9, 
   3.966236762055729*^9, {3.966240335229518*^9, 3.9662403466487093`*^9}},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"KummerSurface", "[", 
          RowBox[{"t", ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
          "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ContourStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.7", "]"}], ",", 
           RowBox[{"Specularity", "[", 
            RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
            "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"MeshFunctions", "\[Rule]", 
         StyleBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"KummerSurface16Conics", "[", 
             RowBox[{
              StyleBox["2",
               FontColor->RGBColor[1, 0, 0]], ",", "t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
             "]"}], "&"}], ")"}],
          Background->RGBColor[1, 1, 0]]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Mesh", "\[Rule]", 
         StyleBox[
          RowBox[{"{", 
           RowBox[{"{", "0", "}"}], "}"}],
          Background->RGBColor[1, 1, 0]]}], ",", 
        RowBox[{"MeshStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BoundaryStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"0.75", ",", "0.5"}], "]"}], ",", 
           RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"KummerSurface16Tropes", "[", 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], ",", "t", ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
          "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ContourStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.7", "]"}], ",", 
           RowBox[{"Specularity", "[", 
            RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
            "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"BoundaryStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"0.75", ",", "0.5"}], "]"}], ",", 
           RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5943309580912676`*^9, 3.5943309655636806`*^9}, {
   3.594331031255396*^9, 3.594331040131812*^9}, 3.5943311307991714`*^9, {
   3.5943311826536617`*^9, 3.59433118713087*^9}, {3.5943316457716756`*^9, 
   3.5943316823537397`*^9}, 3.594368821866786*^9, {3.5944162228354025`*^9, 
   3.5944162894631195`*^9}, {3.5944191793257957`*^9, 
   3.5944192234114733`*^9}, {3.594419277340768*^9, 3.5944195571272593`*^9}, {
   3.594419618887768*^9, 3.5944197151555367`*^9}, {3.5944197455911903`*^9, 
   3.594419820143721*^9}, {3.5998862539978275`*^9, 3.5998864608073907`*^9}, {
   3.599886713949035*^9, 3.5998867662715273`*^9}, {3.5998868095616035`*^9, 
   3.5998868989497604`*^9}, {3.599887010380756*^9, 3.5998870806588793`*^9}, {
   3.599887167909833*^9, 3.599887217237119*^9}, {3.5999093971408043`*^9, 
   3.599909410837628*^9}, 3.5999094519749002`*^9, {3.5999095850075345`*^9, 
   3.5999096032439666`*^9}, {3.5999098605352182`*^9, 3.59990991265491*^9}, 
   3.963173438550975*^9, {3.9631749835244894`*^9, 3.9631750208281593`*^9}, {
   3.9631755142857656`*^9, 3.9631756207449875`*^9}, {3.9631757709137173`*^9, 
   3.9631757737567573`*^9}, {3.9631758434433904`*^9, 3.963175855346859*^9}, {
   3.9661468605535116`*^9, 3.9661469177900543`*^9}, {3.966146964044772*^9, 
   3.9661470645872006`*^9}, {3.9661471608861666`*^9, 3.966147242507638*^9}, {
   3.9661472867627897`*^9, 3.966147300259618*^9}, {3.9661473434057245`*^9, 
   3.966147455754314*^9}, {3.966147486137797*^9, 3.966147544499078*^9}, {
   3.9661476855440674`*^9, 3.9661477358314013`*^9}, {3.9661482419213204`*^9, 
   3.9661482878324084`*^9}, {3.9661483371225157`*^9, 3.9661483952007513`*^9}, 
   3.9661489927520533`*^9, {3.9661495341716566`*^9, 3.9661495648206964`*^9}, {
   3.9661497513549747`*^9, 3.966149879074949*^9}, {3.966149910973734*^9, 
   3.9661499191280622`*^9}, {3.9661500154115133`*^9, 
   3.9661500622754602`*^9}, {3.9661501570344687`*^9, 
   3.9661501694377747`*^9}, {3.966150218254421*^9, 3.9661502320012217`*^9}, {
   3.966152305950246*^9, 3.966152341863678*^9}, {3.966152421661171*^9, 
   3.9661524352673483`*^9}, {3.9661540931876945`*^9, 
   3.9661541743405313`*^9}, {3.9661542786441255`*^9, 3.966154327741932*^9}, 
   3.966154488329181*^9, {3.9661569993706326`*^9, 3.9661570523737984`*^9}, {
   3.9661570840694757`*^9, 3.9661571931063766`*^9}, 3.966183740607458*^9, {
   3.966188902262845*^9, 3.9661889162595577`*^9}, {3.966236992970196*^9, 
   3.9662371202996416`*^9}, {3.966237154401*^9, 3.9662374115437136`*^9}, {
   3.966237465968381*^9, 3.9662374721544266`*^9}, {3.9662375081147923`*^9, 
   3.9662375141758285`*^9}, {3.966237579986129*^9, 3.966237634348389*^9}, 
   3.9662383031442833`*^9}],

Cell["\<\
\:3000Trope\:5e73\:9762\:306e\:30b3\:30fc\:30c9\:5185\:3067\:4f7f\:7528\:3059\
\:308c\:3070\:3001\:5fc5\:8981\:306a\:30e1\:30c3\:30b7\:30e5\:306e\:307f\:304c\
\:5f15\:304b\:308c\:308b\:3002\
\>", "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, {3.96615914254008*^9, 3.966159144867629*^9}, 
   3.9661799563267164`*^9},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"KummerSurface", "[", 
          RowBox[{"t", ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
          "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ContourStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.7", "]"}], ",", 
           RowBox[{"Specularity", "[", 
            RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
            "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"BoundaryStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"0.75", ",", "0.5"}], "]"}], ",", 
           RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"KummerSurface16Tropes", "[", 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], ",", "t", ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
          "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ContourStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.7", "]"}], ",", 
           RowBox[{"Specularity", "[", 
            RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
            "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"MeshFunctions", "\[Rule]", 
         StyleBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"KummerSurface16Conics", "[", 
             RowBox[{
              StyleBox["2",
               FontColor->RGBColor[1, 0, 0]], ",", "t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
             "]"}], "&"}], ")"}],
          Background->RGBColor[1, 1, 0]]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Mesh", "\[Rule]", 
         StyleBox[
          RowBox[{"{", 
           RowBox[{"{", "0", "}"}], "}"}],
          Background->RGBColor[1, 1, 0]]}], ",", 
        RowBox[{"MeshStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BoundaryStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"0.75", ",", "0.5"}], "]"}], ",", 
           RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5943309580912676`*^9, 3.5943309655636806`*^9}, {
   3.594331031255396*^9, 3.594331040131812*^9}, 3.5943311307991714`*^9, {
   3.5943311826536617`*^9, 3.59433118713087*^9}, {3.5943316457716756`*^9, 
   3.5943316823537397`*^9}, 3.594368821866786*^9, {3.5944162228354025`*^9, 
   3.5944162894631195`*^9}, {3.5944191793257957`*^9, 
   3.5944192234114733`*^9}, {3.594419277340768*^9, 3.5944195571272593`*^9}, {
   3.594419618887768*^9, 3.5944197151555367`*^9}, {3.5944197455911903`*^9, 
   3.594419820143721*^9}, {3.5998862539978275`*^9, 3.5998864608073907`*^9}, {
   3.599886713949035*^9, 3.5998867662715273`*^9}, {3.5998868095616035`*^9, 
   3.5998868989497604`*^9}, {3.599887010380756*^9, 3.5998870806588793`*^9}, {
   3.599887167909833*^9, 3.599887217237119*^9}, {3.5999093971408043`*^9, 
   3.599909410837628*^9}, 3.5999094519749002`*^9, {3.5999095850075345`*^9, 
   3.5999096032439666`*^9}, {3.5999098605352182`*^9, 3.59990991265491*^9}, 
   3.963173438550975*^9, {3.9631749835244894`*^9, 3.9631750208281593`*^9}, {
   3.9631755142857656`*^9, 3.9631756207449875`*^9}, {3.9631757709137173`*^9, 
   3.9631757737567573`*^9}, {3.9631758434433904`*^9, 3.963175855346859*^9}, {
   3.9661468605535116`*^9, 3.9661469177900543`*^9}, {3.966146964044772*^9, 
   3.9661470645872006`*^9}, {3.9661471608861666`*^9, 3.966147242507638*^9}, {
   3.9661472867627897`*^9, 3.966147300259618*^9}, {3.9661473434057245`*^9, 
   3.966147455754314*^9}, {3.966147486137797*^9, 3.966147544499078*^9}, {
   3.9661476855440674`*^9, 3.9661477358314013`*^9}, {3.9661482419213204`*^9, 
   3.9661482878324084`*^9}, {3.9661483371225157`*^9, 3.9661483952007513`*^9}, 
   3.9661489927520533`*^9, {3.9661495341716566`*^9, 3.9661495648206964`*^9}, {
   3.9661497513549747`*^9, 3.966149879074949*^9}, {3.966149910973734*^9, 
   3.9661499191280622`*^9}, {3.9661500154115133`*^9, 
   3.9661500622754602`*^9}, {3.9661501570344687`*^9, 
   3.9661501694377747`*^9}, {3.966150218254421*^9, 3.9661502320012217`*^9}, {
   3.966152305950246*^9, 3.966152341863678*^9}, {3.966152421661171*^9, 
   3.9661524352673483`*^9}, {3.9661540931876945`*^9, 
   3.9661541743405313`*^9}, {3.9661542786441255`*^9, 3.966154327741932*^9}, 
   3.966154488329181*^9, {3.9661569993706326`*^9, 3.9661570523737984`*^9}, {
   3.9661570840694757`*^9, 3.9661571931063766`*^9}, 3.966183740607458*^9, {
   3.966188902262845*^9, 3.9661889162595577`*^9}, {3.966236992970196*^9, 
   3.9662371202996416`*^9}, {3.966237154401*^9, 3.9662374115437136`*^9}, {
   3.966237465968381*^9, 3.9662374721544266`*^9}, {3.9662375081147923`*^9, 
   3.9662375141758285`*^9}, {3.966237579986129*^9, 3.966237634348389*^9}, {
   3.9662377224995317`*^9, 3.966237764130375*^9}, {3.966237798403534*^9, 
   3.9662378087761307`*^9}, 3.9662382989890175`*^9}],

Cell[TextData[{
 "\:3000\:3055\:3089\:306b\:3001Trope\:5e73\:9762\:306e",
 StyleBox[" ",
  FontSize->8],
 StyleBox["ContourStyle",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->8],
 "\:3068",
 StyleBox[" ",
  FontSize->10],
 StyleBox["BoundaryStyle",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->8],
 "\:3092",
 StyleBox[" ",
  FontSize->10],
 StyleBox["None",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->8],
 "\:3068\:6307\:5b9a\:3059\:308c\:3070\:3001\:610f\:56f3\:3057\:305f\:63cf\
\:753b\:306b\:306a\:308b\:3002"
}], "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, 3.9661896379040546`*^9},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"KummerSurface", "[", 
          RowBox[{"t", ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
          "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ContourStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Opacity", "[", "0.7", "]"}], ",", 
           RowBox[{"Specularity", "[", 
            RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
            "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"BoundaryStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"0.75", ",", "0.5"}], "]"}], ",", 
           RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"KummerSurface16Tropes", "[", 
          RowBox[{
           StyleBox["2",
            FontColor->RGBColor[1, 0, 0]], ",", "t", ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
          "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x1", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x3", ",", 
          RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
        RowBox[{"ContourStyle", "\[Rule]", 
         StyleBox["None",
          Background->RGBColor[1, 1, 0]]}], ",", "\[IndentingNewLine]", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
            "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"MeshFunctions", "\[Rule]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"KummerSurface16Conics", "[", 
            RowBox[{
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]], ",", "t", ",", 
             RowBox[{"{", 
              RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], "]"}],
            "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Mesh", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"{", "0", "}"}], "}"}]}], ",", 
        RowBox[{"MeshStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", 
           RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"BoundaryStyle", "\[Rule]", 
         StyleBox["None",
          Background->RGBColor[1, 1, 0]]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5943309580912676`*^9, 3.5943309655636806`*^9}, {
   3.594331031255396*^9, 3.594331040131812*^9}, 3.5943311307991714`*^9, {
   3.5943311826536617`*^9, 3.59433118713087*^9}, {3.5943316457716756`*^9, 
   3.5943316823537397`*^9}, 3.594368821866786*^9, {3.5944162228354025`*^9, 
   3.5944162894631195`*^9}, {3.5944191793257957`*^9, 
   3.5944192234114733`*^9}, {3.594419277340768*^9, 3.5944195571272593`*^9}, {
   3.594419618887768*^9, 3.5944197151555367`*^9}, {3.5944197455911903`*^9, 
   3.594419820143721*^9}, {3.5998862539978275`*^9, 3.5998864608073907`*^9}, {
   3.599886713949035*^9, 3.5998867662715273`*^9}, {3.5998868095616035`*^9, 
   3.5998868989497604`*^9}, {3.599887010380756*^9, 3.5998870806588793`*^9}, {
   3.599887167909833*^9, 3.599887217237119*^9}, {3.5999093971408043`*^9, 
   3.599909410837628*^9}, 3.5999094519749002`*^9, {3.5999095850075345`*^9, 
   3.5999096032439666`*^9}, {3.5999098605352182`*^9, 3.59990991265491*^9}, 
   3.963173438550975*^9, {3.9631749835244894`*^9, 3.9631750208281593`*^9}, {
   3.9631755142857656`*^9, 3.9631756207449875`*^9}, {3.9631757709137173`*^9, 
   3.9631757737567573`*^9}, {3.9631758434433904`*^9, 3.963175855346859*^9}, {
   3.9661468605535116`*^9, 3.9661469177900543`*^9}, {3.966146964044772*^9, 
   3.9661470645872006`*^9}, {3.9661471608861666`*^9, 3.966147242507638*^9}, {
   3.9661472867627897`*^9, 3.966147300259618*^9}, {3.9661473434057245`*^9, 
   3.966147455754314*^9}, {3.966147486137797*^9, 3.966147544499078*^9}, {
   3.9661476855440674`*^9, 3.9661477358314013`*^9}, {3.9661482419213204`*^9, 
   3.9661482878324084`*^9}, {3.9661483371225157`*^9, 3.9661483952007513`*^9}, 
   3.9661489927520533`*^9, {3.9661495341716566`*^9, 3.9661495648206964`*^9}, {
   3.9661497513549747`*^9, 3.966149879074949*^9}, {3.966149910973734*^9, 
   3.9661499191280622`*^9}, {3.9661500154115133`*^9, 
   3.9661500622754602`*^9}, {3.9661501570344687`*^9, 
   3.9661501694377747`*^9}, {3.966150218254421*^9, 3.9661502320012217`*^9}, {
   3.966152305950246*^9, 3.966152341863678*^9}, {3.966152421661171*^9, 
   3.9661524352673483`*^9}, {3.9661540931876945`*^9, 
   3.9661541743405313`*^9}, {3.9661542786441255`*^9, 3.966154327741932*^9}, 
   3.966154488329181*^9, {3.9661569993706326`*^9, 3.9661570523737984`*^9}, {
   3.9661570840694757`*^9, 3.9661571931063766`*^9}, 3.966183740607458*^9, {
   3.966188902262845*^9, 3.9661889162595577`*^9}, {3.966236992970196*^9, 
   3.9662371202996416`*^9}, {3.966237154401*^9, 3.9662374115437136`*^9}, {
   3.966237465968381*^9, 3.9662374721544266`*^9}, {3.9662375081147923`*^9, 
   3.9662375141758285`*^9}, {3.966237579986129*^9, 3.966237634348389*^9}, {
   3.9662377224995317`*^9, 3.966237764130375*^9}, {3.966237798403534*^9, 
   3.9662378087761307`*^9}, {3.966237868480878*^9, 3.9662378710895715`*^9}, {
   3.966237923514822*^9, 3.966237963052328*^9}, 3.966238013259287*^9, 
   3.966238294568183*^9}],

Cell["\:3000\:5b8c\:6210\:3057\:305f\:63cf\:753b\:3002", "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, {3.966189607645516*^9, 
   3.966189611925759*^9}},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.9662382867731047`*^9, {
   3.966238362802107*^9, 3.9662383654577627`*^9}}],

Cell[TextData[{
 "\:3000\:4ed6\:306e\:30d1\:30e9\:30e1\:30fc\:30bf\:30fc",
 StyleBox[" ",
  FontSize->10],
 StyleBox["t",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->10],
 "\:3067\:306e\:63cf\:753b\:4f8b\:3002"
}], "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, {3.966189607645516*^9, 
   3.966189611925759*^9}, {3.966191868082814*^9, 3.966191955234195*^9}},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", 
       StyleBox["0",
        FontColor->RGBColor[1, 0, 0]]}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.966238281383747*^9, {
   3.9662383405260935`*^9, 3.966238343822197*^9}}],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", 
       StyleBox["0.5",
        FontColor->RGBColor[1, 0, 0]]}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.966238281383747*^9, {
   3.9662383405260935`*^9, 3.966238343822197*^9}, {3.9662384536088905`*^9, 
   3.9662384540256834`*^9}}],

Cell[TextData[{
 "\:3000\:672c\:6765\:306a\:3089\:3070",
 StyleBox[" ",
  FontSize->10],
 StyleBox["t",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->4],
 StyleBox["=",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->4],
 StyleBox["1",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->8],
 "\:306e\:3068\:304d\:4e8c\:6b21\:66f2\:7dda\:306f0\:500b\:3068\:306a\:308b\
\:304c\:3001\:6975\:9650\:3068\:3057\:3066\:306e\:4e8c\:6b21\:66f2\:7dda\:304c\
\:63cf\:304b\:308c\:308b\:3002"
}], "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, {3.966189607645516*^9, 
   3.966189611925759*^9}, {3.966191868082814*^9, 3.966191955234195*^9}, {
   3.966193406304673*^9, 3.966193502985037*^9}, {3.966193543154357*^9, 
   3.9661936390693045`*^9}, 3.9662367915800486`*^9, 3.966240509454187*^9},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", 
       StyleBox["1",
        FontColor->RGBColor[1, 0, 0]]}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.966238281383747*^9, {
   3.9662383405260935`*^9, 3.966238343822197*^9}, {3.9662384536088905`*^9, 
   3.9662384717559214`*^9}}],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", 
       StyleBox["1.3",
        FontColor->RGBColor[1, 0, 0]]}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.966238281383747*^9, {
   3.9662383405260935`*^9, 3.966238343822197*^9}, {3.9662384536088905`*^9, 
   3.9662384895135665`*^9}}],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", 
       StyleBox["3",
        FontColor->RGBColor[1, 0, 0]]}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "4"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.966238281383747*^9, {
   3.9662383405260935`*^9, 3.966238343822197*^9}, {3.9662384536088905`*^9, 
   3.9662384895135665`*^9}, {3.966238519678357*^9, 3.9662385330033445`*^9}}],

Cell[TextData[{
 "\:3000",
 StyleBox["t",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->4],
 StyleBox["=",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->4],
 StyleBox["\[Infinity]",
  FontSize->14,
  FontWeight->"Bold"],
 StyleBox[" ",
  FontSize->8],
 "\:306b\:8fd1\:4ed8\:304f\:3068\:3001Kummer\:66f2\:9762\:306f",
 StyleBox[" ",
  FontSize->6],
 "Steiner\:306e\:30ed\:30fc\:30de\:66f2\:9762\:306b\:8fd1\:4ed8\:304f\:3002\
\:307e\:305f\:3001\:305d\:306e\:3068\:304d\:306e\:4e8c\:6b21\:66f2\:7dda\:306f\
4\:500b\:306e\:5186\:306e\:307f\:3068\:306a\:308b\:3002"
}], "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, {3.966189607645516*^9, 
   3.966189611925759*^9}, {3.966191868082814*^9, 3.966191955234195*^9}, {
   3.966193406304673*^9, 3.966193502985037*^9}, {3.966193543154357*^9, 
   3.9661936390693045`*^9}, {3.9661936956184807`*^9, 
   3.9661938453333254`*^9}, {3.966193949753411*^9, 3.9661939982420125`*^9}, 
   3.9662405461330624`*^9},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", 
       StyleBox["20",
        FontColor->RGBColor[1, 0, 0]]}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "20"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", 
             StyleBox["200",
              FontColor->RGBColor[1, 0, 0]]}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", 
             StyleBox["2",
              FontColor->RGBColor[1, 0, 0]]}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.966238281383747*^9, {
   3.9662383405260935`*^9, 3.966238343822197*^9}, {3.9662384536088905`*^9, 
   3.9662384895135665`*^9}, {3.966238519678357*^9, 3.96623858658447*^9}}],

Cell["\:3000\:4e8c\:6b21\:66f2\:7dda\:306e\:307f\:3092\:63cf\:753b\:3059\:308b\
\:3002", "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, {3.966189607645516*^9, 
   3.966189611925759*^9}, {3.966189668631216*^9, 3.966189720792346*^9}, {
   3.96619173302081*^9, 3.9661917976774845`*^9}, {3.9661942049278307`*^9, 
   3.9661942409662037`*^9}, 3.9662405865141745`*^9, {3.9662406197094975`*^9, 
   3.966240628801095*^9}},
 FontFamily->"Times New Roman",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"KummerSurface16Tropes", "[", 
            RowBox[{"n", ",", "t", ",", 
             RowBox[{"{", 
              RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}],
            "==", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"x1", ",", 
            RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", 
            RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3", ",", 
            RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
          RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
          RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"RegionFunction", "\[Rule]", 
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
             RowBox[{
              RowBox[{"Norm", "[", 
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
              "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"MeshFunctions", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"KummerSurface16Conics", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
              "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Mesh", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"{", "0", "}"}], "}"}]}], ",", 
          RowBox[{"MeshStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"Hue", "[", 
              RowBox[{"n", "/", "16"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966238130325509*^9, 3.966238133762204*^9}, {
   3.966238177501917*^9, 3.9662382022148914`*^9}, 3.9662382867731047`*^9, {
   3.966238362802107*^9, 3.9662383654577627`*^9}, {3.9662387548886967`*^9, 
   3.9662387840380535`*^9}, 3.966238848725977*^9, 3.966238903260062*^9, 
   3.9662389526547008`*^9, {3.966239023716155*^9, 3.9662390388844423`*^9}, {
   3.966239163495762*^9, 3.966239185068836*^9}, 3.9662405865141745`*^9}],

Cell["\:3010\:672c\:756a\:63cf\:753b\:3011", "Text",
 CellChangeTimes->{{3.7972917463518114`*^9, 3.7972918528895097`*^9}, {
   3.7972921189445553`*^9, 3.797292122959238*^9}, {3.7972921833670015`*^9, 
   3.797292239072751*^9}, {3.797292298715049*^9, 3.7972923155236244`*^9}, {
   3.7972923525150485`*^9, 3.797292460505471*^9}, {3.7972953156349926`*^9, 
   3.797295351220435*^9}, {3.797295385946703*^9, 3.797295551173756*^9}, {
   3.797295582557089*^9, 3.79729571065215*^9}, {3.7973823404996634`*^9, 
   3.7973824222072277`*^9}, {3.7973827536654234`*^9, 3.797382804575415*^9}, 
   3.7974539961378527`*^9, {3.7983614483884096`*^9, 3.798361472804553*^9}, 
   3.798361840057972*^9, {3.7983618940084496`*^9, 3.7983620155803556`*^9}, {
   3.798362439457983*^9, 3.7983624758088064`*^9}, {3.7983637839195523`*^9, 
   3.7983637974476266`*^9}, {3.79836382875275*^9, 3.7983638482481737`*^9}, {
   3.800210441474351*^9, 3.800210531296934*^9}, {3.800210570256503*^9, 
   3.800210579363759*^9}, {3.8002107817222958`*^9, 3.80021078330005*^9}, {
   3.8002108369749002`*^9, 3.8002108884627953`*^9}, {3.800237945354684*^9, 
   3.80023800006057*^9}, {3.8002393593433685`*^9, 3.800239378675542*^9}, {
   3.800294319805814*^9, 3.800294490062568*^9}, {3.8004387934053555`*^9, 
   3.80043899909126*^9}, {3.80046777667212*^9, 3.8004678009789257`*^9}, {
   3.800467864260889*^9, 3.8004679136086006`*^9}, 3.934735552301422*^9, {
   3.951290265230462*^9, 3.9512903442119265`*^9}, {3.9642924117958117`*^9, 
   3.964292473406328*^9}, {3.9642925049770374`*^9, 3.9642925605108657`*^9}, 
   3.9642926042662015`*^9, {3.9642926425384693`*^9, 3.964292664814455*^9}, {
   3.964292749106263*^9, 3.9642927515432014`*^9}, {3.96429279624953*^9, 
   3.964292814995123*^9}, {3.9642928671547365`*^9, 3.964292875059143*^9}, {
   3.9642929399657664`*^9, 3.9642929464642076`*^9}, 3.9643824568838854`*^9, {
   3.9643825229340343`*^9, 3.964382526245783*^9}, {3.964382589215352*^9, 
   3.9643826181673727`*^9}, {3.9643827866434174`*^9, 3.964382792095262*^9}, {
   3.9643828257591953`*^9, 3.9643828936651506`*^9}, {3.9643830817442536`*^9, 
   3.9643830916325283`*^9}, {3.9649865639529657`*^9, 3.964986579683672*^9}, {
   3.964992263121966*^9, 3.9649923993087196`*^9}, {3.9649924401353493`*^9, 
   3.964992650273507*^9}, {3.9655795990407267`*^9, 3.965579601821295*^9}, {
   3.9655796636192675`*^9, 3.965579690159938*^9}, {3.9655805043591623`*^9, 
   3.965580509264227*^9}, {3.96558056687572*^9, 3.9655806297515574`*^9}, {
   3.966157877266774*^9, 3.9661579723850746`*^9}, 3.966158007017561*^9, {
   3.966158063837315*^9, 3.966158085004215*^9}, {3.966158148536154*^9, 
   3.9661582152236032`*^9}, {3.96615825355834*^9, 3.9661583139035606`*^9}, {
   3.9661583499106903`*^9, 3.9661584087250195`*^9}, {3.9661584434355803`*^9, 
   3.9661584924485435`*^9}, 3.966158523050696*^9, {3.966158586848234*^9, 
   3.9661586520828924`*^9}, 3.9661588730236645`*^9, {3.966158945162985*^9, 
   3.966159018505121*^9}, {3.966159162144845*^9, 3.966159210180401*^9}, {
   3.9661799952238226`*^9, 3.9661800008474655`*^9}, {3.966189607645516*^9, 
   3.966189611925759*^9}, {3.966189668631216*^9, 3.966189720792346*^9}, {
   3.96619173302081*^9, 3.9661917976774845`*^9}, {3.9661942049278307`*^9, 
   3.9661942409662037`*^9}, 3.9662405865141745`*^9, {3.9662406197094975`*^9, 
   3.966240628801095*^9}, {3.966240754958969*^9, 3.966240765253393*^9}},
 FontFamily->"Times New Roman",
 FontSize->14,
 FontWeight->"Bold",
 FontColor->RGBColor[0.5019607843137255, 0., 0.5019607843137255]],

Cell[BoxData[
 RowBox[{"kummerS1", "=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2.0"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"KummerSurface", "[", 
        RowBox[{"t", ",", 
         RowBox[{"{", 
          RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}], "==",
        "0"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"x1", ",", 
        RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", 
        RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x3", ",", 
        RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotPoints", "\[Rule]", "160"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ContourStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Opacity", "[", "0.7", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"RegionFunction", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
          "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
      RowBox[{"BoundaryStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{"0.75", ",", "0.5"}], "]"}], ",", 
         RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Background", "\[Rule]", "Black"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5943309580912676`*^9, 3.5943309655636806`*^9}, {
   3.594331031255396*^9, 3.594331040131812*^9}, 3.5943311307991714`*^9, {
   3.5943311826536617`*^9, 3.59433118713087*^9}, {3.5943316457716756`*^9, 
   3.5943316823537397`*^9}, 3.594368821866786*^9, {3.5944162228354025`*^9, 
   3.5944162894631195`*^9}, {3.5944191793257957`*^9, 
   3.5944192234114733`*^9}, {3.594419277340768*^9, 3.5944195571272593`*^9}, {
   3.594419618887768*^9, 3.5944197151555367`*^9}, {3.5944197455911903`*^9, 
   3.594419820143721*^9}, {3.5998862539978275`*^9, 3.5998864608073907`*^9}, {
   3.599886713949035*^9, 3.5998867662715273`*^9}, {3.5998868095616035`*^9, 
   3.5998868989497604`*^9}, {3.599887010380756*^9, 3.5998870806588793`*^9}, {
   3.599887167909833*^9, 3.599887217237119*^9}, {3.5999093971408043`*^9, 
   3.599909410837628*^9}, 3.5999094519749002`*^9, {3.5999095850075345`*^9, 
   3.5999096032439666`*^9}, {3.5999098605352182`*^9, 3.59990991265491*^9}, 
   3.963173438550975*^9, {3.9631749835244894`*^9, 3.9631750208281593`*^9}, {
   3.9631755142857656`*^9, 3.9631756207449875`*^9}, {3.9631757709137173`*^9, 
   3.9631757737567573`*^9}, {3.9631758434433904`*^9, 3.963175855346859*^9}, {
   3.9661468605535116`*^9, 3.9661469177900543`*^9}, {3.966146964044772*^9, 
   3.9661470645872006`*^9}, {3.9661471608861666`*^9, 3.966147242507638*^9}, {
   3.9661472867627897`*^9, 3.966147300259618*^9}, {3.9661473434057245`*^9, 
   3.966147455754314*^9}, {3.966147486137797*^9, 3.966147544499078*^9}, {
   3.9661476855440674`*^9, 3.9661477358314013`*^9}, {3.9661482419213204`*^9, 
   3.9661482878324084`*^9}, {3.9661483371225157`*^9, 3.9661483952007513`*^9}, 
   3.9661489927520533`*^9, {3.9661495341716566`*^9, 3.9661495648206964`*^9}, {
   3.9661497513549747`*^9, 3.966149879074949*^9}, {3.966149910973734*^9, 
   3.9661499191280622`*^9}, {3.9661500154115133`*^9, 
   3.9661500622754602`*^9}, {3.9661501570344687`*^9, 
   3.9661501694377747`*^9}, {3.966150218254421*^9, 3.9661502320012217`*^9}, {
   3.966152305950246*^9, 3.966152341863678*^9}, {3.966152421661171*^9, 
   3.9661524352673483`*^9}, {3.9661540931876945`*^9, 
   3.9661541743405313`*^9}, {3.9661542786441255`*^9, 3.966154327741932*^9}, 
   3.966154488329181*^9, {3.9661569993706326`*^9, 3.9661570523737984`*^9}, {
   3.9661570840694757`*^9, 3.9661571931063766`*^9}, {3.9661575222231092`*^9, 
   3.9661575464830313`*^9}, {3.9661576416950593`*^9, 3.966157656457214*^9}, 
   3.966157698931569*^9, 3.9661588527003174`*^9, {3.9661592350495653`*^9, 
   3.9661593194672375`*^9}, {3.966183617714473*^9, 3.966183644864339*^9}, {
   3.966183822885026*^9, 3.9661839313907337`*^9}, {3.9661840387718477`*^9, 
   3.966184063812766*^9}, {3.966184101385315*^9, 3.9661841666668463`*^9}, {
   3.9661842065168543`*^9, 3.96618430707131*^9}, 3.9661889474397254`*^9, {
   3.966189020297639*^9, 3.9661890334351473`*^9}, {3.9661890811270485`*^9, 
   3.9661893187134705`*^9}, {3.9661893638903227`*^9, 3.966189468022088*^9}, 
   3.9661895254773717`*^9, {3.966208074011054*^9, 3.966208077041596*^9}, 
   3.966208119375389*^9, {3.9662081625175185`*^9, 3.9662081835906887`*^9}, 
   3.966208223315692*^9, {3.966208913758873*^9, 3.9662089325669556`*^9}, {
   3.966208987163457*^9, 3.96620908535198*^9}, {3.966209123468047*^9, 
   3.9662091237023673`*^9}, {3.9662091609904795`*^9, 3.966209191577009*^9}, 
   3.966209246564086*^9, {3.966209421413603*^9, 3.9662094686837397`*^9}, {
   3.966209723186413*^9, 3.9662097481493206`*^9}, 3.966209815539703*^9, {
   3.966209873869741*^9, 3.966209900379133*^9}, {3.966210069183202*^9, 
   3.9662100790090523`*^9}, {3.9662101249825845`*^9, 3.9662101267946978`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<360_kummersurface1.png\>\"", ",", "kummerS1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533954803186406*^9, 3.533954810206419*^9}, {
   3.547008887550027*^9, 3.547008913695673*^9}, 3.54700934450603*^9, {
   3.5999097634094477`*^9, 3.5999097798674765`*^9}, {3.5999104946763325`*^9, 
   3.599910593393306*^9}, {3.599941581735736*^9, 3.599941584871341*^9}, {
   3.9662093691602955`*^9, 3.9662093982628303`*^9}, {3.9662101883271027`*^9, 
   3.9662101888269863`*^9}, 3.96622061166475*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"kummerS2", "=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t", "=", "2.0"}], ",", 
      RowBox[{"x0", "=", 
       SqrtBox[
        RowBox[{"1", "/", "2"}]]}], ",", 
      RowBox[{"rMax", "=", "3.3"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"KummerSurface", "[", 
             RowBox[{"t", ",", 
              RowBox[{"{", 
               RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
             "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"x1", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotPoints", "\[Rule]", "160"}], ",", 
           RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ContourStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
              RowBox[{"Opacity", "[", "0.6", "]"}], ",", 
              RowBox[{"Specularity", "[", 
               RowBox[{"White", ",", "90"}], "]"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RegionFunction", "\[Rule]", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{"{", 
                 RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
               "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
           RowBox[{"BoundaryStyle", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ContourPlot3D", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"KummerSurface16Tropes", "[", 
              RowBox[{"n", ",", "t", ",", 
               RowBox[{"{", 
                RowBox[{"x0", ",", "x1", ",", "x2", ",", "x3"}], "}"}]}], 
              "]"}], "==", "0"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"x1", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x3", ",", 
              RowBox[{"-", "rMax"}], ",", "rMax"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotPoints", "\[Rule]", "160"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RegionFunction", "\[Rule]", 
             RowBox[{"Function", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"{", 
                  RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "<", 
                "rMax"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"KummerSurface16Conics", "[", 
                RowBox[{"n", ",", "t", ",", 
                 RowBox[{"{", 
                  RowBox[{"x0", ",", "#1", ",", "#2", ",", "#3"}], "}"}]}], 
                "]"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"{", "0", "}"}], "}"}]}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"Hue", "[", 
                RowBox[{"n", "/", "16"}], "]"}], ",", 
               RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", "None"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "1", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Background", "\[Rule]", "Black"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.30", ",", 
         RowBox[{"-", "2.60"}], ",", "1.70"}], "}"}]}], ",", 
      RowBox[{"ViewVertical", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
      RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5943309580912676`*^9, 3.5943309655636806`*^9}, {
   3.594331031255396*^9, 3.594331040131812*^9}, 3.5943311307991714`*^9, {
   3.5943311826536617`*^9, 3.59433118713087*^9}, {3.5943316457716756`*^9, 
   3.5943316823537397`*^9}, 3.594368821866786*^9, {3.5944162228354025`*^9, 
   3.5944162894631195`*^9}, {3.5944191793257957`*^9, 
   3.5944192234114733`*^9}, {3.594419277340768*^9, 3.5944195571272593`*^9}, {
   3.594419618887768*^9, 3.5944197151555367`*^9}, {3.5944197455911903`*^9, 
   3.594419820143721*^9}, {3.5998862539978275`*^9, 3.5998864608073907`*^9}, {
   3.599886713949035*^9, 3.5998867662715273`*^9}, {3.5998868095616035`*^9, 
   3.5998868989497604`*^9}, {3.599887010380756*^9, 3.5998870806588793`*^9}, {
   3.599887167909833*^9, 3.599887217237119*^9}, {3.5999093971408043`*^9, 
   3.599909410837628*^9}, 3.5999094519749002`*^9, {3.5999095850075345`*^9, 
   3.5999096032439666`*^9}, {3.5999098605352182`*^9, 3.59990991265491*^9}, 
   3.963173438550975*^9, {3.9631749835244894`*^9, 3.9631750208281593`*^9}, {
   3.9631755142857656`*^9, 3.9631756207449875`*^9}, {3.9631757709137173`*^9, 
   3.9631757737567573`*^9}, {3.9631758434433904`*^9, 3.963175855346859*^9}, {
   3.9661468605535116`*^9, 3.9661469177900543`*^9}, {3.966146964044772*^9, 
   3.9661470645872006`*^9}, {3.9661471608861666`*^9, 3.966147242507638*^9}, {
   3.9661472867627897`*^9, 3.966147300259618*^9}, {3.9661473434057245`*^9, 
   3.966147455754314*^9}, {3.966147486137797*^9, 3.966147544499078*^9}, {
   3.9661476855440674`*^9, 3.9661477358314013`*^9}, {3.9661482419213204`*^9, 
   3.9661482878324084`*^9}, {3.9661483371225157`*^9, 3.9661483952007513`*^9}, 
   3.9661489927520533`*^9, {3.9661495341716566`*^9, 3.9661495648206964`*^9}, {
   3.9661497513549747`*^9, 3.966149879074949*^9}, {3.966149910973734*^9, 
   3.9661499191280622`*^9}, {3.9661500154115133`*^9, 
   3.9661500622754602`*^9}, {3.9661501570344687`*^9, 
   3.9661501694377747`*^9}, {3.966150218254421*^9, 3.9661502320012217`*^9}, {
   3.966152305950246*^9, 3.966152341863678*^9}, {3.966152421661171*^9, 
   3.9661524352673483`*^9}, {3.9661540931876945`*^9, 
   3.9661541743405313`*^9}, {3.9661542786441255`*^9, 3.966154327741932*^9}, 
   3.966154488329181*^9, {3.9661569993706326`*^9, 3.9661570523737984`*^9}, {
   3.9661570840694757`*^9, 3.9661571931063766`*^9}, {3.9661575222231092`*^9, 
   3.9661575464830313`*^9}, {3.9661576416950593`*^9, 3.966157656457214*^9}, 
   3.966157698931569*^9, 3.9661588527003174`*^9, {3.9661592350495653`*^9, 
   3.9661593194672375`*^9}, {3.966183617714473*^9, 3.966183644864339*^9}, {
   3.966183822885026*^9, 3.9661839313907337`*^9}, {3.9661840387718477`*^9, 
   3.966184063812766*^9}, {3.966184101385315*^9, 3.9661841666668463`*^9}, {
   3.9661842065168543`*^9, 3.96618430707131*^9}, 3.9661889474397254`*^9, {
   3.966189020297639*^9, 3.9661890334351473`*^9}, {3.9661890811270485`*^9, 
   3.9661893187134705`*^9}, {3.9661893638903227`*^9, 3.966189468022088*^9}, 
   3.9661895254773717`*^9, {3.966208074011054*^9, 3.966208077041596*^9}, 
   3.966208119375389*^9, {3.9662081625175185`*^9, 3.9662081835906887`*^9}, 
   3.966208223315692*^9, {3.966208913758873*^9, 3.9662089325669556`*^9}, {
   3.966208987163457*^9, 3.96620908535198*^9}, {3.966209123468047*^9, 
   3.9662091237023673`*^9}, {3.9662091609904795`*^9, 3.966209191577009*^9}, 
   3.966209246564086*^9, {3.966209421413603*^9, 3.9662094686837397`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<360_kummersurface2.png\>\"", ",", "kummerS2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533954803186406*^9, 3.533954810206419*^9}, {
   3.547008887550027*^9, 3.547008913695673*^9}, 3.54700934450603*^9, {
   3.5999097634094477`*^9, 3.5999097798674765`*^9}, {3.5999104946763325`*^9, 
   3.599910593393306*^9}, {3.599941581735736*^9, 3.599941584871341*^9}, {
   3.9662093691602955`*^9, 3.966209413696669*^9}, {3.9662096813681474`*^9, 
   3.966209681868023*^9}, 3.9662206012609816`*^9},
 Background->GrayLevel[0.900008]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1095, 830},
WindowMargins->{{Automatic, 218}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (2011\:5e743\:670821\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 1108, 18, 74, "Subtitle"],
Cell[1690, 42, 215, 5, 80, "Text"],
Cell[CellGroupData[{
Cell[1930, 51, 991, 16, 62, "Subsection"],
Cell[2924, 69, 3584, 52, 66, "Text"],
Cell[6511, 123, 11964, 299, 862, "Input"],
Cell[18478, 424, 3691, 54, 66, "Text"],
Cell[22172, 480, 8369, 179, 608, "Input"],
Cell[30544, 661, 3205, 45, 41, "Text"],
Cell[33752, 708, 8469, 180, 608, "Input"],
Cell[42224, 890, 3660, 66, 41, "Text"],
Cell[45887, 958, 8148, 171, 581, "Input"],
Cell[54038, 1131, 3207, 43, 41, "Text"],
Cell[57248, 1176, 5776, 134, 635, "Input"],
Cell[63027, 1312, 3417, 52, 41, "Text"],
Cell[66447, 1366, 5830, 136, 635, "Input"],
Cell[72280, 1504, 5886, 137, 635, "Input"],
Cell[78169, 1643, 3833, 64, 41, "Text"],
Cell[82005, 1709, 5884, 137, 635, "Input"],
Cell[87892, 1848, 5886, 137, 635, "Input"],
Cell[93781, 1987, 5930, 137, 635, "Input"],
Cell[99714, 2126, 4002, 68, 70, "Text"],
Cell[103719, 2196, 6066, 141, 635, "Input"],
Cell[109788, 2339, 3466, 47, 41, "Text"],
Cell[113257, 2388, 3908, 91, 392, "Input"],
Cell[117168, 2481, 3504, 48, 45, "Text"],
Cell[120675, 2531, 6349, 118, 338, "Input"],
Cell[127027, 2651, 648, 11, 67, "Input"],
Cell[127678, 2664, 9089, 178, 608, "Input"],
Cell[136770, 2844, 647, 11, 67, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
