(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    158885,       3702]
NotebookOptionsPosition[    156866,       3644]
NotebookOutlinePosition[    157223,       3660]
CellTagsIndexPosition[    157180,       3657]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "q-\:30ac\:30f3\:30de\:95a2\:6570\:ff08Ver.8\:ff09\n",
 StyleBox[" q-Gamma functions\:ff08Ver.8\:ff09",
  FontSize->18]
}], "Subtitle",
 CellChangeTimes->{{3.790453314440241*^9, 3.790453314440241*^9}, 
   3.790453375233548*^9, {3.790453429011243*^9, 3.7904534457812724`*^9}, {
   3.7904589563653536`*^9, 3.790458966676972*^9}, {3.961312421286824*^9, 
   3.961312481413185*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "Graphics`MathematicalFunctionPlot`"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.5339528699182105`*^9, 3.5339528744110184`*^9}, 
   3.5529279523137803`*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "QSpecialFunctions`QElementaryFunction`"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{
  3.533952888497843*^9, 3.5470036577472415`*^9, 3.55202278173763*^9, {
   3.589140788101957*^9, 3.5891407986163754`*^9}, 3.644569946409751*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["\[Section]3",
  FontSize->14],
 " q-\:30d9\:30fc\:30bf\:95a2\:6570\:ff1a",
 StyleBox["q-Beta function",
  FontSize->14]
}], "Subsection",
 CellDingbat->None,
 CellChangeTimes->{{3.7904534690721135`*^9, 3.7904535022065716`*^9}, 
   3.790453579816708*^9, 3.790453610065161*^9, 3.790453686973296*^9, {
   3.7904589979238267`*^9, 3.7904590450047092`*^9}, {3.7904596665410013`*^9, 
   3.790459674887016*^9}, {3.790881198319935*^9, 3.79088121246916*^9}, {
   3.961312508812955*^9, 3.9613125376811857`*^9}},
 FontFamily->"Arial",
 FontSize->16,
 Background->RGBColor[
  0.4549019607843137, 0.6666666666666666, 0.8784313725490196]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "q"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontSize->6],
 StyleBox["(",
  FontSize->14],
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontSize->6],
 StyleBox["x",
  FontSize->15,
  FontSlant->"Italic"],
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontSize->6],
 StyleBox[", ",
  FontSize->15],
 StyleBox["y",
  FontSize->15,
  FontSlant->"Italic"],
 StyleBox[" ",
  FontFamily->"Times New Roman",
  FontSize->6],
 StyleBox[")",
  FontSize->14]
}], "Text",
 CellChangeTimes->{{3.790453826499941*^9, 3.7904538346743555`*^9}, 
   3.7904539149832964`*^9, {3.7904603641742263`*^9, 3.7904603732378426`*^9}, {
   3.790460884778341*^9, 3.7904609249952116`*^9}, {3.9613127372371016`*^9, 
   3.961312765714737*^9}},
 FontFamily->"Times New Roman",
 FontSize->16,
 Background->RGBColor[
  0.6901960784313725, 0.6901960784313725, 0.8666666666666667]],

Cell[BoxData[
 RowBox[{"p3QBeta1", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "=", "0.1"}], ",", 
      RowBox[{"p", "=", "50"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.7", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Plot", "-", "1"}], " ", ":", " ", 
          RowBox[{
           RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
           RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{"QBeta", "[", 
             RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                 ",", "\[IndentingNewLine]", "opc", ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
              ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#1", "&"}], ",", 
               RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ClippingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "0", "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
              "]"}]}]}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "2"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "m", ",", 
               RowBox[{"m", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"m", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"j", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"m", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "3"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "n", ",", 
               RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"n", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "4"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Plot3D", "[", 
              RowBox[{
               RowBox[{"QBeta", "[", 
                RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "m", ",", 
                 RowBox[{"m", "+", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "n", ",", 
                 RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
               RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
               RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"ColorFunction", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                    ",", "\[IndentingNewLine]", "opc", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
                 ")"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
               RowBox[{"MeshFunctions", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#1", "&"}], ",", 
                  RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"Mesh", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"m", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ClippingStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "0", "]"}], ",", "opc"}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"BoundaryStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
                 "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"m", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"2.53", ",", "0.87", ",", "2.08"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "None"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "40"}], ",", "40", ",", "20"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}]}], "}"}]}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.961257222320468*^9, 3.9612572430030756`*^9}, {
   3.96127367160937*^9, 3.9612736880898457`*^9}, {3.961273987484982*^9, 
   3.961274000841229*^9}, {3.961274075990218*^9, 3.961274120948328*^9}, {
   3.961274232172587*^9, 3.9612742401238337`*^9}, {3.9612743550815935`*^9, 
   3.961274369484466*^9}, {3.9612744967091465`*^9, 3.9612745031764007`*^9}, 
   3.9612747903491664`*^9, {3.961274890118245*^9, 3.9612749017248735`*^9}, {
   3.961274935363005*^9, 3.9612749549677105`*^9}, {3.9612754746970625`*^9, 
   3.961275497269845*^9}, {3.9612963391982536`*^9, 3.9612963592872505`*^9}, {
   3.961296664199461*^9, 3.9612966768683414`*^9}, {3.961312784522792*^9, 
   3.9613127965824647`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_0980.png\>\"", ",", "p3QBeta1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.961257345941526*^9, 
   3.96125734634768*^9}, {3.9612749813520927`*^9, 3.9612750109303055`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_0980.jpeg\>\"", ",", "p3QBeta1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.961257350049929*^9, 
   3.961257355142478*^9}, 3.9612749774780436`*^9, 3.961275029632456*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta2", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "=", "0.1"}], ",", 
      RowBox[{"p", "=", "50"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.7", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Plot", "-", "1"}], " ", ":", " ", 
          RowBox[{
           RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
           RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{"QBeta", "[", 
             RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                 ",", "\[IndentingNewLine]", "opc", ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
              ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#1", "&"}], ",", 
               RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ClippingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "0", "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
              "]"}]}]}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "2"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "m", ",", 
               RowBox[{"m", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"m", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"j", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"m", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "3"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "n", ",", 
               RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"n", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "4"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Plot3D", "[", 
              RowBox[{
               RowBox[{"QBeta", "[", 
                RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "m", ",", 
                 RowBox[{"m", "+", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "n", ",", 
                 RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
               RowBox[{"PlotPoints", "\[Rule]", "80"}], ",", 
               RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"ColorFunction", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                    ",", "\[IndentingNewLine]", "opc", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
                 ")"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
               RowBox[{"MeshFunctions", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#1", "&"}], ",", 
                  RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"Mesh", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"m", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ClippingStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "0", "]"}], ",", "opc"}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"BoundaryStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
                 "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"m", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.03", ",", 
          RowBox[{"-", "0.41"}], ",", "3.37"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "None"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "40"}], ",", "40", ",", "20"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}]}], "}"}]}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.961257222320468*^9, 3.9612572430030756`*^9}, {
   3.961257396195225*^9, 3.961257421142451*^9}, {3.9612581147561865`*^9, 
   3.961258117536783*^9}, 3.9612749740101075`*^9, {3.961275037646183*^9, 
   3.961275075402012*^9}, {3.9612761161390114`*^9, 3.9612761252774696`*^9}, {
   3.961297163155037*^9, 3.961297185805925*^9}, 3.961312807626717*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_0990.png\>\"", ",", "p3QBeta2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.629926486307401*^9, 
   3.629926494325815*^9}, {3.961257401928276*^9, 3.9612574024437838`*^9}, 
   3.9612751020676174`*^9, {3.96127514520817*^9, 3.961275150347579*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_0990.jpeg\>\"", ",", "p3QBeta2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.629926488616205*^9, 
   3.6299264966190195`*^9}, {3.9612574064740753`*^9, 3.9612574070052013`*^9}, 
   3.961275104035864*^9, 3.9612751578927746`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"dpQBeta1", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", "f_", "]"}], ":=", 
      RowBox[{"0.3", "+", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"0.2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Exp", "[", 
              RowBox[{"3", " ", "f"}], "]"}], "+", "1"}], "]"}]}]}], 
         ")"}]}]}]}], ";", "  ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "[", "f_", "]"}], ":=", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"20", "*", 
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"f", "/", "2"}], "]"}], "+", "1"}], "]"}], "3"]}]}], 
         ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DensityPlot", "[", 
      RowBox[{
       RowBox[{"QBeta", "[", 
        RowBox[{"x", ",", "y", ",", "0.1"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10000"}], ",", "10000"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "1000"}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"#", "/", "10"}], ",", 
            RowBox[{"s", "[", 
             RowBox[{"#", "/", "10"}], "]"}], ",", 
            RowBox[{"b", "[", 
             RowBox[{"#", "/", "10"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
        FontColor->GrayLevel[0]], ",", 
       StyleBox[
        RowBox[{"Exclusions", "\[Rule]", "None"}],
        FontColor->GrayLevel[0]], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", 
          StyleBox["\"\<y\>\"",
           FontColor->GrayLevel[0]]}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.6299491474702864`*^9, {3.6299492214456167`*^9, 3.6299493011461563`*^9}, {
   3.629949421796768*^9, 3.629949527876955*^9}, {3.6299495640846186`*^9, 
   3.6299495662842216`*^9}, 3.629949638543549*^9, 3.6299496848756304`*^9, {
   3.629949734124917*^9, 3.629949734483718*^9}, {3.6299497799265976`*^9, 
   3.6299497801293974`*^9}, {3.6299498369602976`*^9, 
   3.6299498390819016`*^9}, {3.6299503609128184`*^9, 3.629950395264079*^9}, {
   3.629950434732148*^9, 3.6299504499109745`*^9}, {3.6299510299355936`*^9, 
   3.6299510635692525`*^9}, {3.644570414544574*^9, 3.6445704264941945`*^9}, {
   3.961311564079795*^9, 3.961311592291958*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1000.png\>\"", ",", "dpQBeta1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.629926486307401*^9, 
   3.629926516150254*^9}, {3.6299510845980897`*^9, 3.62995110202332*^9}, 
   3.6445704440286255`*^9, {3.6445704770694838`*^9, 3.6445704930283117`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1000.jpeg\>\"", ",", "dpQBeta1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.629926488616205*^9, 
   3.6299265186774583`*^9}, {3.629951085892892*^9, 3.62995110777973*^9}, 
   3.6445704463530293`*^9, {3.644570479050687*^9, 3.644570497240319*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"dpQBeta2", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "b", ",", 
      RowBox[{"pr", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["10", "8"]}], ",", 
         SuperscriptBox["10", "8"]}], "}"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", "f_", "]"}], ":=", 
      RowBox[{"0.3", "+", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"0.2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Exp", "[", 
              RowBox[{"3", " ", "f"}], "]"}], "+", "1"}], "]"}]}]}], 
         ")"}]}]}]}], ";", "  ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "[", "f_", "]"}], ":=", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"20", "*", 
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"f", "/", "2"}], "]"}], "+", "1"}], "]"}], "3"]}]}], 
         ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DensityPlot", "[", 
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"QBeta", "[", 
         RowBox[{"x", ",", "y", ",", "0.1"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"ArcSinh", "[", "pr", "]"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "1000"}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"#", "/", "2"}], ",", 
            RowBox[{"s", "[", 
             RowBox[{"#", "/", "2"}], "]"}], ",", 
            RowBox[{"b", "[", 
             RowBox[{"#", "/", "2"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
        FontColor->GrayLevel[0]], ",", 
       StyleBox[
        RowBox[{"Exclusions", "\[Rule]", "None"}],
        FontColor->GrayLevel[0]], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", 
          StyleBox["\"\<y\>\"",
           FontColor->GrayLevel[0]]}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.6299517969569416`*^9, {3.6299518648326607`*^9, 3.6299518908067064`*^9}, {
   3.6299519549696193`*^9, 3.6299520207705345`*^9}, {3.6445704325314054`*^9, 
   3.6445704401130185`*^9}, {3.9613116280490303`*^9, 3.9613116476069374`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1010.png\>\"", ",", "dpQBeta2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.629926486307401*^9, 
   3.629926516150254*^9}, {3.6299510845980897`*^9, 3.62995110202332*^9}, {
   3.6299516544194913`*^9, 3.629951658615899*^9}, {3.6445704520938396`*^9, 
   3.6445705045567317`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1010.jpeg\>\"", ",", "dpQBeta2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.629926488616205*^9, 
   3.6299265186774583`*^9}, {3.629951085892892*^9, 3.62995110777973*^9}, {
   3.6299516553554935`*^9, 3.629951660285102*^9}, 3.6445704532950416`*^9, {
   3.644570484807097*^9, 3.6445705092055397`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta3", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "=", "0.5"}], ",", 
      RowBox[{"p", "=", "50"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.7", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Plot", "-", "1"}], " ", ":", " ", 
          RowBox[{
           RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
           RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{"QBeta", "[", 
             RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                 ",", "\[IndentingNewLine]", "opc", ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
              ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#1", "&"}], ",", 
               RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ClippingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "0", "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
              "]"}]}]}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "2"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "m", ",", 
               RowBox[{"m", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"40", ",", "200"}], "}"}]}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"m", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"j", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"m", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "3"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "n", ",", 
               RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"200", ",", "40"}], "}"}]}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"n", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "4"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Plot3D", "[", 
              RowBox[{
               RowBox[{"QBeta", "[", 
                RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "m", ",", 
                 RowBox[{"m", "+", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "n", ",", 
                 RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
               RowBox[{"PlotPoints", "\[Rule]", "40"}], ",", 
               RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"ColorFunction", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                    ",", "\[IndentingNewLine]", "opc", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
                 ")"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
               RowBox[{"MeshFunctions", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#1", "&"}], ",", 
                  RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"Mesh", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"m", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ClippingStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "0", "]"}], ",", "opc"}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"BoundaryStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
                 "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"m", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"2.53", ",", "0.87", ",", "2.08"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "None"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "40"}], ",", "40", ",", "20"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}]}], "}"}]}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.961257222320468*^9, 3.9612572430030756`*^9}, {
   3.96127367160937*^9, 3.9612736880898457`*^9}, {3.961273987484982*^9, 
   3.961274000841229*^9}, {3.961274075990218*^9, 3.961274120948328*^9}, {
   3.961274232172587*^9, 3.9612742401238337`*^9}, {3.9612743550815935`*^9, 
   3.961274369484466*^9}, {3.9612744967091465`*^9, 3.9612745031764007`*^9}, 
   3.9612747903491664`*^9, {3.961274890118245*^9, 3.9612749017248735`*^9}, {
   3.961274935363005*^9, 3.9612749549677105`*^9}, {3.961275282090041*^9, 
   3.9612752851518154`*^9}, 3.9613128217639723`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1020.png\>\"", ",", "p3QBeta3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.961257345941526*^9, 
   3.96125734634768*^9}, {3.9612749813520927`*^9, 3.9612750109303055`*^9}, {
   3.9612752537217894`*^9, 3.961275278575284*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1020.jpeg\>\"", ",", "p3QBeta3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.961257350049929*^9, 
   3.961257355142478*^9}, 3.9612749774780436`*^9, 3.961275029632456*^9, {
   3.961275256580456*^9, 3.9612752768569403`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta4", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "=", "0.5"}], ",", 
      RowBox[{"p", "=", "50"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.7", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Plot", "-", "1"}], " ", ":", " ", 
          RowBox[{
           RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
           RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{"QBeta", "[", 
             RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", "200"}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                 ",", "\[IndentingNewLine]", "opc", ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
              ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#1", "&"}], ",", 
               RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}], 
                "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ClippingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "0", "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
              "]"}]}]}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "2"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", ">=", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "m", ",", 
               RowBox[{"m", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"40", ",", "200"}], "}"}]}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"m", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"j", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"m", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "3"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"QBeta", "[", 
              RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", "n", ",", 
               RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"200", ",", "40"}], "}"}]}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "&"}], ",", 
                RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i", ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0.5", ",", "3.5", ",", "0.5"}], "}"}]}],
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"n", "+", "0.5"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"-", "4"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "4"}], " ", ":", " ", 
           RowBox[{
            RowBox[{"x", "<", "0"}], " ", "&&", " ", 
            RowBox[{"y", "<", "0"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Plot3D", "[", 
              RowBox[{
               RowBox[{"QBeta", "[", 
                RowBox[{"x", ",", "y", ",", "q"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "m", ",", 
                 RowBox[{"m", "+", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"y", ",", "n", ",", 
                 RowBox[{"n", "+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
               RowBox[{"PlotPoints", "\[Rule]", "40"}], ",", 
               RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"ColorFunction", "\[Rule]", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                    ",", "\[IndentingNewLine]", "opc", ",", 
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
                 ")"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
               RowBox[{"MeshFunctions", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"#1", "&"}], ",", 
                  RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"Mesh", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"m", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"n", "+", "0.5"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                     "}"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"ClippingStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "0", "]"}], ",", "opc"}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                    "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"BoundaryStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
                 "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"m", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", 
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.03", ",", 
          RowBox[{"-", "0.41"}], ",", "3.37"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "None"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "40"}], ",", "40", ",", "20"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "4"}], ",", "4", ",", 
                RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}]}], "}"}]}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.961257222320468*^9, 3.9612572430030756`*^9}, {
   3.961257396195225*^9, 3.961257421142451*^9}, {3.9612581147561865`*^9, 
   3.961258117536783*^9}, 3.9612749740101075`*^9, {3.961275037646183*^9, 
   3.961275075402012*^9}, {3.9612752622041235`*^9, 3.961275272217411*^9}, 
   3.9613128281687326`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1030.png\>\"", ",", "p3QBeta4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.629926486307401*^9, 
   3.629926494325815*^9}, {3.961257401928276*^9, 3.9612574024437838`*^9}, 
   3.9612751020676174`*^9, {3.96127514520817*^9, 3.961275150347579*^9}, {
   3.9612752308619256`*^9, 3.9612752315180187`*^9}, 3.9612752665468464`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1030.jpeg\>\"", ",", "p3QBeta4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.629926488616205*^9, 
   3.6299264966190195`*^9}, {3.9612574064740753`*^9, 3.9612574070052013`*^9}, 
   3.961275104035864*^9, 3.9612751578927746`*^9, {3.9612752338299713`*^9, 
   3.9612752347359715`*^9}, 3.9612752676247168`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"dpQBeta3", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", "f_", "]"}], ":=", 
      RowBox[{"0.3", "+", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"0.2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Exp", "[", 
              RowBox[{"3", " ", "f"}], "]"}], "+", "1"}], "]"}]}]}], 
         ")"}]}]}]}], ";", "  ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "[", "f_", "]"}], ":=", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"20", "*", 
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"f", "/", "2"}], "]"}], "+", "1"}], "]"}], "3"]}]}], 
         ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DensityPlot", "[", 
      RowBox[{
       RowBox[{"QBeta", "[", 
        RowBox[{"x", ",", "y", ",", "0.5"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10000"}], ",", "10000"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "1000"}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"#", "/", "10"}], ",", 
            RowBox[{"s", "[", 
             RowBox[{"#", "/", "10"}], "]"}], ",", 
            RowBox[{"b", "[", 
             RowBox[{"#", "/", "10"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
        FontColor->GrayLevel[0]], ",", 
       StyleBox[
        RowBox[{"Exclusions", "\[Rule]", "None"}],
        FontColor->GrayLevel[0]], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", 
          StyleBox["\"\<y\>\"",
           FontColor->GrayLevel[0]]}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.6299491474702864`*^9, {3.6299492214456167`*^9, 3.6299493011461563`*^9}, {
   3.629949421796768*^9, 3.629949527876955*^9}, {3.6299495640846186`*^9, 
   3.6299495662842216`*^9}, 3.629949638543549*^9, 3.6299496848756304`*^9, {
   3.629949734124917*^9, 3.629949734483718*^9}, {3.6299497799265976`*^9, 
   3.6299497801293974`*^9}, {3.6299498369602976`*^9, 
   3.6299498390819016`*^9}, {3.6299503609128184`*^9, 3.629950395264079*^9}, {
   3.629950434732148*^9, 3.6299504499109745`*^9}, {3.6299510299355936`*^9, 
   3.6299510635692525`*^9}, {3.644570414544574*^9, 3.6445704264941945`*^9}, 
   3.6445706646286125`*^9, 3.6445707020842786`*^9, {3.961311693988674*^9, 
   3.961311698019006*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1040.png\>\"", ",", "dpQBeta3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.629926486307401*^9, 
   3.629926516150254*^9}, {3.6299510845980897`*^9, 3.62995110202332*^9}, 
   3.6445704440286255`*^9, {3.6445704770694838`*^9, 3.6445704930283117`*^9}, {
   3.6445707036910815`*^9, 3.6445707334403334`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1040.jpeg\>\"", ",", "dpQBeta3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.629926488616205*^9, 
   3.6299265186774583`*^9}, {3.629951085892892*^9, 3.62995110777973*^9}, 
   3.6445704463530293`*^9, {3.644570479050687*^9, 3.644570497240319*^9}, 
   3.6445707047518835`*^9, 3.644570735249937*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"dpQBeta4", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "b", ",", 
      RowBox[{"pr", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["10", "8"]}], ",", 
         SuperscriptBox["10", "8"]}], "}"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", "f_", "]"}], ":=", 
      RowBox[{"0.3", "+", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"0.2", " ", 
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"Exp", "[", 
              RowBox[{"3", " ", "f"}], "]"}], "+", "1"}], "]"}]}]}], 
         ")"}]}]}]}], ";", "  ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"b", "[", "f_", "]"}], ":=", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "0.7"}], "+", 
          RowBox[{"20", "*", 
           SuperscriptBox[
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"f", "/", "2"}], "]"}], "+", "1"}], "]"}], "3"]}]}], 
         ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DensityPlot", "[", 
      RowBox[{
       RowBox[{"ArcSinh", "[", 
        RowBox[{"QBeta", "[", 
         RowBox[{"x", ",", "y", ",", "0.5"}], "]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"ArcSinh", "[", "pr", "]"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "1000"}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"#", "/", "2"}], ",", 
            RowBox[{"s", "[", 
             RowBox[{"#", "/", "2"}], "]"}], ",", 
            RowBox[{"b", "[", 
             RowBox[{"#", "/", "2"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       StyleBox[
        RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}],
        FontColor->GrayLevel[0]], ",", 
       StyleBox[
        RowBox[{"Exclusions", "\[Rule]", "None"}],
        FontColor->GrayLevel[0]], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", 
          StyleBox["\"\<y\>\"",
           FontColor->GrayLevel[0]]}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.6299517969569416`*^9, {3.6299518648326607`*^9, 3.6299518908067064`*^9}, {
   3.6299519549696193`*^9, 3.6299520207705345`*^9}, {3.6445704325314054`*^9, 
   3.6445704401130185`*^9}, 3.644570667062217*^9, 3.644570707060687*^9, 
   3.961311734729068*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1050.png\>\"", ",", "dpQBeta4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, {3.629926486307401*^9, 
   3.629926516150254*^9}, {3.6299510845980897`*^9, 3.62995110202332*^9}, {
   3.6299516544194913`*^9, 3.629951658615899*^9}, {3.6445704520938396`*^9, 
   3.6445705045567317`*^9}, {3.644570709915492*^9, 3.6445707371843405`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1050.jpeg\>\"", ",", "dpQBeta4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.629926488616205*^9, 
   3.6299265186774583`*^9}, {3.629951085892892*^9, 3.62995110777973*^9}, {
   3.6299516553554935`*^9, 3.629951660285102*^9}, 3.6445704532950416`*^9, {
   3.644570484807097*^9, 3.6445705092055397`*^9}, {3.6445707119122963`*^9, 
   3.6445707389471436`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta5", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Re",
      FontColor->GrayLevel[0]], 
     StyleBox["[",
      FontColor->GrayLevel[0]], 
     RowBox[{"QBeta", 
      StyleBox["[",
       FontColor->GrayLevel[0]], 
      StyleBox[
       RowBox[{
        RowBox[{"z", "+", 
         RowBox[{
          RowBox[{"1", "/", "2"}], " ", "I"}]}], ",", 
        RowBox[{
         RowBox[{"1", "/", "2"}], "+", 
         RowBox[{"w", " ", "I"}]}], ",", "0.1"}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], ",", "\[IndentingNewLine]", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.436"}], ",", "1.259"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.09"}], ",", 
       RowBox[{"-", "2.09"}], ",", "2.50"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
          RowBox[{"Rescale", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.436"}], ",", "1.259"}], "}"}]}], "]"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
    RowBox[{"MeshFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#1", "&"}], ",", 
       RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Mesh", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<z\>\"", ",", "\"\<w\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "9"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BoxStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoundaryStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6253015344558573`*^9, 3.6253016112703924`*^9}, {
   3.625301675776506*^9, 3.6253017735262775`*^9}, {3.625301810888343*^9, 
   3.6253018255211687`*^9}, {3.625301872024851*^9, 3.6253019003701005`*^9}, {
   3.6253019306809535`*^9, 3.6253019566393995`*^9}, {3.625301986731852*^9, 
   3.6253020144219007`*^9}, 3.625302057041176*^9, {3.6253020946528416`*^9, 
   3.6253021070392632`*^9}, {3.6253021630121613`*^9, 
   3.6253021918722124`*^9}, {3.625302239358696*^9, 3.6253022793571663`*^9}, {
   3.625302325970048*^9, 3.625302328778053*^9}, {3.625302426635826*^9, 
   3.625302545757635*^9}, {3.6253028118437023`*^9, 3.625302820142917*^9}, {
   3.62530287316741*^9, 3.6253028749146132`*^9}, {3.625303009810851*^9, 
   3.6253030276416817`*^9}, {3.625303566747429*^9, 3.625303651034377*^9}, 
   3.6253039052368236`*^9, {3.6253044220969315`*^9, 3.6253044251077366`*^9}, 
   3.625446032045142*^9, 3.6254460651796007`*^9, {3.6299256020994473`*^9, 
   3.62992564353312*^9}, {3.6299257106212387`*^9, 3.629925719809654*^9}, {
   3.6299258731579237`*^9, 3.6299259520940623`*^9}, {3.6299259980517435`*^9, 
   3.6299260195173807`*^9}, {3.629926054913843*^9, 3.6299260791718855`*^9}, {
   3.6299261509944115`*^9, 3.6299262210697346`*^9}, {3.629939410333975*^9, 
   3.6299394951825237`*^9}, 3.6299406110572844`*^9, 3.6299406557513623`*^9, {
   3.629942692988141*^9, 3.6299427892247105`*^9}, {3.6299429099065228`*^9, 
   3.629942917690936*^9}, {3.629943872997014*^9, 3.6299438862258377`*^9}, {
   3.6299460189507837`*^9, 3.62994602233599*^9}, 3.6299464879344077`*^9, 
   3.6299470601301684`*^9, {3.644570045915926*^9, 3.6445700530607386`*^9}, 
   3.6445701988429947`*^9, 3.6445708397857203`*^9, {3.6445709717775526`*^9, 
   3.644571048326887*^9}, {3.644571206667165*^9, 3.6445712470400357`*^9}, 
   3.6446050458869653`*^9, {3.644610217915657*^9, 3.644610269192947*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1060.png\>\"", ",", "p3QBeta5", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, 3.644570037928712*^9, {
   3.644570111139641*^9, 3.644570119329655*^9}, {3.6445708420477247`*^9, 
   3.6445708556509485`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1060.jpeg\>\"", ",", "p3QBeta5", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.644570129719273*^9, 
   3.644570136427285*^9}, {3.6445708441381283`*^9, 3.6445708608457575`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta6", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Re",
      FontColor->GrayLevel[0]], 
     StyleBox["[",
      FontColor->GrayLevel[0]], 
     RowBox[{"QBeta", 
      StyleBox["[",
       FontColor->GrayLevel[0]], 
      StyleBox[
       RowBox[{
        RowBox[{"z", "+", 
         RowBox[{
          RowBox[{"1", "/", "2"}], " ", "I"}]}], ",", 
        RowBox[{
         RowBox[{"1", "/", "2"}], "+", 
         RowBox[{"w", " ", "I"}]}], ",", "0.5"}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], ",", "\[IndentingNewLine]", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.495"}], ",", "3.746"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.09"}], ",", 
       RowBox[{"-", "2.09"}], ",", "2.50"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
          RowBox[{"Rescale", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3.495"}], ",", "3.746"}], "}"}]}], "]"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
    RowBox[{"MeshFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#1", "&"}], ",", 
       RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Mesh", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<z\>\"", ",", "\"\<w\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "9"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BoxStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoundaryStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6253015344558573`*^9, 3.6253016112703924`*^9}, {
   3.625301675776506*^9, 3.6253017735262775`*^9}, {3.625301810888343*^9, 
   3.6253018255211687`*^9}, {3.625301872024851*^9, 3.6253019003701005`*^9}, {
   3.6253019306809535`*^9, 3.6253019566393995`*^9}, {3.625301986731852*^9, 
   3.6253020144219007`*^9}, 3.625302057041176*^9, {3.6253020946528416`*^9, 
   3.6253021070392632`*^9}, {3.6253021630121613`*^9, 
   3.6253021918722124`*^9}, {3.625302239358696*^9, 3.6253022793571663`*^9}, {
   3.625302325970048*^9, 3.625302328778053*^9}, {3.625302426635826*^9, 
   3.625302545757635*^9}, {3.6253028118437023`*^9, 3.625302820142917*^9}, {
   3.62530287316741*^9, 3.6253028749146132`*^9}, {3.625303009810851*^9, 
   3.6253030276416817`*^9}, {3.625303566747429*^9, 3.625303651034377*^9}, 
   3.6253039052368236`*^9, {3.6253044220969315`*^9, 3.6253044251077366`*^9}, 
   3.625446032045142*^9, 3.6254460651796007`*^9, {3.6299256020994473`*^9, 
   3.62992564353312*^9}, {3.6299257106212387`*^9, 3.629925719809654*^9}, {
   3.6299258731579237`*^9, 3.6299259520940623`*^9}, {3.6299259980517435`*^9, 
   3.6299260195173807`*^9}, {3.629926054913843*^9, 3.6299260791718855`*^9}, {
   3.6299261509944115`*^9, 3.6299262210697346`*^9}, {3.629939410333975*^9, 
   3.6299394951825237`*^9}, 3.6299406110572844`*^9, 3.6299406557513623`*^9, {
   3.629942692988141*^9, 3.6299427892247105`*^9}, {3.6299429099065228`*^9, 
   3.629942917690936*^9}, {3.629943872997014*^9, 3.6299438862258377`*^9}, {
   3.6299460189507837`*^9, 3.62994602233599*^9}, 3.6299464879344077`*^9, 
   3.6299470601301684`*^9, {3.644570045915926*^9, 3.6445700530607386`*^9}, 
   3.6445701988429947`*^9, 3.6445708397857203`*^9, {3.6445709717775526`*^9, 
   3.644571048326887*^9}, {3.644571206667165*^9, 3.6445712470400357`*^9}, 
   3.644571330344182*^9, {3.644571364399042*^9, 3.6445713807634706`*^9}, 
   3.6446050477589684`*^9, {3.6446103082710156`*^9, 3.644610316897831*^9}, {
   3.644610617151558*^9, 3.6446106286487784`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1070.png\>\"", ",", "p3QBeta6", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, 3.644570037928712*^9, {
   3.644570111139641*^9, 3.644570119329655*^9}, {3.6445708420477247`*^9, 
   3.6445708556509485`*^9}, {3.6445713236673703`*^9, 3.6445713270369763`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1070.jpeg\>\"", ",", "p3QBeta6", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.644570129719273*^9, 
   3.644570136427285*^9}, {3.6445708441381283`*^9, 3.6445708608457575`*^9}, {
   3.6445713249621725`*^9, 3.6445713284565787`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta7", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Re",
      FontColor->GrayLevel[0]], 
     StyleBox["[",
      FontColor->GrayLevel[0]], 
     RowBox[{"QBeta", 
      StyleBox["[",
       FontColor->GrayLevel[0]], 
      StyleBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "+", 
         RowBox[{"z", " ", "I"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "+", 
         RowBox[{"w", " ", "I"}]}], ",", "0.1"}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], ",", "\[IndentingNewLine]", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.422"}], ",", "0"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1.09", ",", 
       RowBox[{"-", "2.09"}], ",", "2.50"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
          RowBox[{"Rescale", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2.422"}], ",", "0"}], "}"}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
    RowBox[{"MeshFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#1", "&"}], ",", 
       RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Mesh", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<z\>\"", ",", "\"\<w\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "9"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BoxStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoundaryStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Ambient\>\"", ",", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Directional\>\"", ",", "White", ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ImageScaled", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.4"}], ",", "1", ",", "1"}], "}"}], "]"}], ",", 
           RowBox[{"ImageScaled", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}]}], 
        "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6253015344558573`*^9, 3.6253016112703924`*^9}, {
   3.625301675776506*^9, 3.6253017735262775`*^9}, {3.625301810888343*^9, 
   3.6253018255211687`*^9}, {3.625301872024851*^9, 3.6253019003701005`*^9}, {
   3.6253019306809535`*^9, 3.6253019566393995`*^9}, {3.625301986731852*^9, 
   3.6253020144219007`*^9}, 3.625302057041176*^9, {3.6253020946528416`*^9, 
   3.6253021070392632`*^9}, {3.6253021630121613`*^9, 
   3.6253021918722124`*^9}, {3.625302239358696*^9, 3.6253022793571663`*^9}, {
   3.625302325970048*^9, 3.625302328778053*^9}, {3.625302426635826*^9, 
   3.625302545757635*^9}, {3.6253028118437023`*^9, 3.625302820142917*^9}, {
   3.62530287316741*^9, 3.6253028749146132`*^9}, {3.625303009810851*^9, 
   3.6253030276416817`*^9}, {3.625303566747429*^9, 3.625303651034377*^9}, 
   3.6253039052368236`*^9, {3.6253044220969315`*^9, 3.6253044251077366`*^9}, 
   3.625446032045142*^9, 3.6254460651796007`*^9, {3.6299256020994473`*^9, 
   3.62992564353312*^9}, {3.6299257106212387`*^9, 3.629925719809654*^9}, {
   3.6299258731579237`*^9, 3.6299259520940623`*^9}, {3.6299259980517435`*^9, 
   3.6299260195173807`*^9}, {3.629926054913843*^9, 3.6299260791718855`*^9}, {
   3.6299261509944115`*^9, 3.6299262210697346`*^9}, {3.629939410333975*^9, 
   3.6299394951825237`*^9}, 3.6299406110572844`*^9, 3.6299406557513623`*^9, {
   3.629942692988141*^9, 3.6299427892247105`*^9}, {3.6299429099065228`*^9, 
   3.629942917690936*^9}, {3.629943872997014*^9, 3.6299438862258377`*^9}, {
   3.6299460189507837`*^9, 3.62994602233599*^9}, 3.6299464879344077`*^9, 
   3.6299470601301684`*^9, {3.644570045915926*^9, 3.6445700530607386`*^9}, 
   3.6445701988429947`*^9, 3.6445708397857203`*^9, {3.6445709717775526`*^9, 
   3.644571048326887*^9}, {3.644571206667165*^9, 3.6445712470400357`*^9}, 
   3.644571330344182*^9, {3.644571364399042*^9, 3.6445713807634706`*^9}, {
   3.6445714270799522`*^9, 3.6445714653156195`*^9}, {3.6446104317296324`*^9, 
   3.6446104406840477`*^9}, {3.644633809162021*^9, 3.6446338121416264`*^9}, {
   3.6446338652441196`*^9, 3.64463388834776*^9}, {3.6446365154442368`*^9, 
   3.644636524617053*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1080.png\>\"", ",", "p3QBeta7", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, 3.644570037928712*^9, {
   3.644570111139641*^9, 3.644570119329655*^9}, {3.6445708420477247`*^9, 
   3.6445708556509485`*^9}, {3.6445713236673703`*^9, 
   3.6445713270369763`*^9}, {3.6445714186715374`*^9, 3.6445714238819466`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1080.jpeg\>\"", ",", "p3QBeta7", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.644570129719273*^9, 
   3.644570136427285*^9}, {3.6445708441381283`*^9, 3.6445708608457575`*^9}, {
   3.6445713249621725`*^9, 3.6445713284565787`*^9}, {3.64457142010674*^9, 
   3.644571425239149*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"p3QBeta8", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Re",
      FontColor->GrayLevel[0]], 
     StyleBox["[",
      FontColor->GrayLevel[0]], 
     RowBox[{"QBeta", 
      StyleBox["[",
       FontColor->GrayLevel[0]], 
      StyleBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "+", 
         RowBox[{"z", " ", "I"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], "+", 
         RowBox[{"w", " ", "I"}]}], ",", "0.5"}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], ",", "\[IndentingNewLine]", 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.917"}], ",", "0.031"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1.09", ",", 
       RowBox[{"-", "2.09"}], ",", "2.50"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
          RowBox[{"Rescale", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4.917"}], ",", "0.031"}], "}"}]}], "]"}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
    RowBox[{"MeshFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"#1", "&"}], ",", 
       RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Mesh", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Directive", "[", 
            RowBox[{
             RowBox[{"GrayLevel", "[", 
              RowBox[{"0", ",", "0.6"}], "]"}], ",", 
             RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<z\>\"", ",", "\"\<w\>\"", ",", "None"}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "9"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BoxStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BoundaryStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0004", "]"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6253015344558573`*^9, 3.6253016112703924`*^9}, {
   3.625301675776506*^9, 3.6253017735262775`*^9}, {3.625301810888343*^9, 
   3.6253018255211687`*^9}, {3.625301872024851*^9, 3.6253019003701005`*^9}, {
   3.6253019306809535`*^9, 3.6253019566393995`*^9}, {3.625301986731852*^9, 
   3.6253020144219007`*^9}, 3.625302057041176*^9, {3.6253020946528416`*^9, 
   3.6253021070392632`*^9}, {3.6253021630121613`*^9, 
   3.6253021918722124`*^9}, {3.625302239358696*^9, 3.6253022793571663`*^9}, {
   3.625302325970048*^9, 3.625302328778053*^9}, {3.625302426635826*^9, 
   3.625302545757635*^9}, {3.6253028118437023`*^9, 3.625302820142917*^9}, {
   3.62530287316741*^9, 3.6253028749146132`*^9}, {3.625303009810851*^9, 
   3.6253030276416817`*^9}, {3.625303566747429*^9, 3.625303651034377*^9}, 
   3.6253039052368236`*^9, {3.6253044220969315`*^9, 3.6253044251077366`*^9}, 
   3.625446032045142*^9, 3.6254460651796007`*^9, {3.6299256020994473`*^9, 
   3.62992564353312*^9}, {3.6299257106212387`*^9, 3.629925719809654*^9}, {
   3.6299258731579237`*^9, 3.6299259520940623`*^9}, {3.6299259980517435`*^9, 
   3.6299260195173807`*^9}, {3.629926054913843*^9, 3.6299260791718855`*^9}, {
   3.6299261509944115`*^9, 3.6299262210697346`*^9}, {3.629939410333975*^9, 
   3.6299394951825237`*^9}, 3.6299406110572844`*^9, 3.6299406557513623`*^9, {
   3.629942692988141*^9, 3.6299427892247105`*^9}, {3.6299429099065228`*^9, 
   3.629942917690936*^9}, {3.629943872997014*^9, 3.6299438862258377`*^9}, {
   3.6299460189507837`*^9, 3.62994602233599*^9}, 3.6299464879344077`*^9, 
   3.6299470601301684`*^9, {3.644570045915926*^9, 3.6445700530607386`*^9}, 
   3.6445701988429947`*^9, 3.6445708397857203`*^9, {3.6445709717775526`*^9, 
   3.644571048326887*^9}, {3.644571206667165*^9, 3.6445712470400357`*^9}, 
   3.644571330344182*^9, {3.644571364399042*^9, 3.6445713807634706`*^9}, {
   3.6445714270799522`*^9, 3.6445714653156195`*^9}, {3.644571513613304*^9, 
   3.6445715377933464`*^9}, {3.6446106618144364`*^9, 
   3.6446106715020533`*^9}, {3.644611139892876*^9, 3.644611151265296*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1090.png\>\"", ",", "p3QBeta8", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.6063513550076036`*^9, 3.625297492745756*^9, 3.6252981126928453`*^9, {
   3.625298470299474*^9, 3.6252985205783625`*^9}, {3.6252998082058244`*^9, 
   3.625299813478634*^9}, {3.6252999462816668`*^9, 3.625299952459278*^9}, {
   3.625300499035838*^9, 3.6253005060246506`*^9}, 3.6253007075458045`*^9, {
   3.625300901781746*^9, 3.6253009079281564`*^9}, {3.6253011284813437`*^9, 
   3.6253011585737963`*^9}, {3.625301493022185*^9, 3.62530151877783*^9}, 
   3.625302883900229*^9, {3.6253029411707306`*^9, 3.6253029413111305`*^9}, {
   3.6299262351721597`*^9, 3.6299262588374014`*^9}, 3.644570037928712*^9, {
   3.644570111139641*^9, 3.644570119329655*^9}, {3.6445708420477247`*^9, 
   3.6445708556509485`*^9}, {3.6445713236673703`*^9, 
   3.6445713270369763`*^9}, {3.6445714186715374`*^9, 
   3.6445714238819466`*^9}, {3.6445715058288903`*^9, 3.644571510009698*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<q020_1090.jpeg\>\"", ",", "p3QBeta8", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "512"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.60635135856441*^9, 3.6252974960685616`*^9, 3.62529811539165*^9, {
   3.6252984813442936`*^9, 3.625298523854368*^9}, {3.625299810623829*^9, 
   3.625299815912238*^9}, {3.6252999485124707`*^9, 3.6252999550488825`*^9}, {
   3.6253005021558437`*^9, 3.625300508333454*^9}, 3.625300710338209*^9, {
   3.6253009044805503`*^9, 3.6253009109077616`*^9}, {3.625301132490551*^9, 
   3.625301162692204*^9}, {3.625301508747012*^9, 3.625301521320635*^9}, 
   3.6253028860998325`*^9, {3.625302943791535*^9, 3.6253029439475355`*^9}, {
   3.629926244563376*^9, 3.6299262627374077`*^9}, {3.644570129719273*^9, 
   3.644570136427285*^9}, {3.6445708441381283`*^9, 3.6445708608457575`*^9}, {
   3.6445713249621725`*^9, 3.6445713284565787`*^9}, {3.64457142010674*^9, 
   3.644571425239149*^9}, {3.644571506952092*^9, 3.6445715113045*^9}},
 Background->GrayLevel[0.900008]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1026, 792},
WindowMargins->{{Automatic, 214}, {Automatic, -2}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (2011\:5e743\:670821\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 394, 8, 108, "Subtitle"],
Cell[976, 32, 221, 5, 43, "Input"],
Cell[1200, 39, 291, 6, 43, "Input"],
Cell[CellGroupData[{
Cell[1516, 49, 650, 16, 83, "Subsection"],
Cell[2169, 67, 978, 37, 75, "Text"],
Cell[3150, 106, 22658, 527, 1880, "Input"],
Cell[25811, 635, 922, 15, 67, "Input"],
Cell[26736, 652, 911, 15, 67, "Input"],
Cell[27650, 669, 22347, 523, 1880, "Input"],
Cell[50000, 1194, 994, 16, 67, "Input"],
Cell[50997, 1212, 967, 16, 67, "Input"],
Cell[51967, 1230, 3398, 85, 267, "Input"],
Cell[55368, 1317, 998, 16, 67, "Input"],
Cell[56369, 1335, 986, 16, 67, "Input"],
Cell[57358, 1353, 3172, 85, 268, "Input"],
Cell[60533, 1440, 1026, 17, 67, "Input"],
Cell[61562, 1459, 1040, 17, 67, "Input"],
Cell[62605, 1478, 22672, 529, 1880, "Input"],
Cell[85280, 2009, 974, 16, 67, "Input"],
Cell[86257, 2027, 963, 16, 67, "Input"],
Cell[87223, 2045, 22445, 527, 1880, "Input"],
Cell[109671, 2574, 1072, 17, 67, "Input"],
Cell[110746, 2593, 1045, 17, 67, "Input"],
Cell[111794, 2612, 3450, 86, 267, "Input"],
Cell[115247, 2700, 1052, 17, 67, "Input"],
Cell[116302, 2719, 1036, 17, 67, "Input"],
Cell[117341, 2738, 3192, 86, 268, "Input"],
Cell[120536, 2826, 1074, 17, 67, "Input"],
Cell[121613, 2845, 1094, 18, 67, "Input"],
Cell[122710, 2865, 6188, 148, 341, "Input"],
Cell[128901, 3015, 949, 16, 67, "Input"],
Cell[129853, 3033, 915, 15, 67, "Input"],
Cell[130771, 3050, 6316, 150, 341, "Input"],
Cell[137090, 3202, 999, 16, 67, "Input"],
Cell[138092, 3220, 969, 16, 67, "Input"],
Cell[139064, 3238, 7099, 171, 368, "Input"],
Cell[146166, 3411, 1053, 17, 67, "Input"],
Cell[147222, 3430, 1018, 17, 67, "Input"],
Cell[148243, 3449, 6422, 152, 341, "Input"],
Cell[154668, 3603, 1105, 18, 67, "Input"],
Cell[155776, 3623, 1062, 17, 67, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
