(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[  11544182,     181206]
NotebookOptionsPosition[  11498241,     180209]
NotebookOutlinePosition[  11498597,     180225]
CellTagsIndexPosition[  11498554,     180222]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\:5408\:6d41\:578b\:8d85\:5e7e\:4f55\:95a2\:6570\n",
 StyleBox[" Confluent hypergeometric functions",
  FontSize->18]
}], "Subtitle",
 CellChangeTimes->{{3.790453314440241*^9, 3.790453314440241*^9}, 
   3.790453375233548*^9, {3.790453429011243*^9, 3.7904534457812724`*^9}, {
   3.7904589563653536`*^9, 3.790458966676972*^9}, {3.7904635600966415`*^9, 
   3.79046357675747*^9}, {3.790625848811887*^9, 3.7906258666895185`*^9}, {
   3.790625899574376*^9, 3.7906259185596094`*^9}, {3.790639763835931*^9, 
   3.790639794021984*^9}, {3.7906398443320723`*^9, 3.7906398491056805`*^9}, {
   3.79071314645372*^9, 3.7907131936906033`*^9}, {3.7907379125308247`*^9, 
   3.79073794421448*^9}, {3.790997118297472*^9, 3.790997148031124*^9}, {
   3.792443974276103*^9, 3.7924439979725447`*^9}, {3.7924444681417704`*^9, 
   3.792444528217476*^9}, {3.7924445911635866`*^9, 3.792444606139613*^9}, {
   3.793335332358374*^9, 3.79333536430723*^9}, {3.8133697950321784`*^9, 
   3.8133697985626054`*^9}, {3.825488826200329*^9, 3.8254888512882085`*^9}, {
   3.8337552343220396`*^9, 3.8337552727192507`*^9}, {3.852264116396051*^9, 
   3.8522641500756397`*^9}, {3.863978583412247*^9, 3.8639786176239805`*^9}, {
   3.887678213850544*^9, 3.8876782317525563`*^9}, {3.918543525212899*^9, 
   3.9185435615481367`*^9}, {3.963986607312912*^9, 3.963986669907509*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "Graphics`MathematicalFunctionPlot`"}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.5339528699182105`*^9, 3.5339528744110184`*^9}, 
   3.5529279523137803`*^9, {3.795036521413636*^9, 3.7950365258032074`*^9}},
 FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "SpecialFunctions`KummerHypergeometric`", 
   RowBox[{"(*", " ", 
    RowBox[{"\[Section]1", ",", "\[Section]2", ",", "\[Section]3"}], " ", 
    "*)"}]}],
  FontColor->RGBColor[0, 0, 1]]], "Input",
 CellChangeTimes->{{3.632549042285489*^9, 3.6325491441380672`*^9}, 
   3.6325558518200893`*^9, 3.6329063974173093`*^9, {3.6351196911810884`*^9, 
   3.6351197033335104`*^9}, {3.6719269409147377`*^9, 
   3.6719269432547417`*^9}, {3.6719651466169395`*^9, 
   3.6719651523109493`*^9}, {3.6723720491401205`*^9, 3.6723720574237356`*^9}, 
   3.694675898470289*^9, {3.7005373953216934`*^9, 3.70053742728615*^9}, {
   3.700957034655281*^9, 3.700957049912108*^9}, 3.7417285584157286`*^9, {
   3.7469900192202654`*^9, 3.7469900325582886`*^9}, 3.7538294582439036`*^9, {
   3.755060033407484*^9, 3.7550600409110975`*^9}, {3.757413388224821*^9, 
   3.757413392967229*^9}, {3.7574135970779877`*^9, 3.7574136062352037`*^9}, {
   3.758442572807083*^9, 3.7584425805602965`*^9}, {3.763975430324682*^9, 
   3.763975447453512*^9}, {3.7639754777955656`*^9, 3.7639754863599806`*^9}, 
   3.7644499210761976`*^9, {3.76548777486078*^9, 3.7654877796343884`*^9}, {
   3.765487835139286*^9, 3.765487858445727*^9}, {3.7673906335115085`*^9, 
   3.7673906399699197`*^9}, {3.791432637664789*^9, 3.7914326646584024`*^9}, 
   3.791609101833467*^9, 3.79244813532462*^9, 3.79246729130468*^9, {
   3.8000660122109213`*^9, 3.80006603240925*^9}, {3.815100682462741*^9, 
   3.8151006866336637`*^9}, {3.8182163566308775`*^9, 
   3.8182163589897013`*^9}, {3.8190101721514406`*^9, 3.819010213438671*^9}, {
   3.8200304259470844`*^9, 3.820030429649331*^9}, 3.9286482907256413`*^9, {
   3.93105809111694*^9, 3.93105809430369*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["\[Section]1",
  FontSize->14],
 " \:5408\:6d41\:578b\:8d85\:5e7e\:4f55\:95a2\:6570\:ff1a",
 StyleBox["Confluent hypergeometric function",
  FontSize->14]
}], "Subsection",
 CellDingbat->None,
 CellChangeTimes->{{3.7904534690721135`*^9, 3.7904535022065716`*^9}, 
   3.790453579816708*^9, 3.790453610065161*^9, 3.790453686973296*^9, {
   3.7904589979238267`*^9, 3.7904590450047092`*^9}, {3.790459076329564*^9, 
   3.79045911937004*^9}, {3.790459187323759*^9, 3.7904592169326115`*^9}, {
   3.7904593177399883`*^9, 3.790459337380423*^9}, {3.7906259817085204`*^9, 
   3.790625995124544*^9}, {3.7906260251701965`*^9, 3.7906260558554506`*^9}, {
   3.7906329177659044`*^9, 3.7906329353939357`*^9}, {3.7906329727404013`*^9, 
   3.790633045420929*^9}, {3.790713241021086*^9, 3.7907132613479223`*^9}, {
   3.790738007971792*^9, 3.7907380224486175`*^9}, {3.790738093241542*^9, 
   3.790738101977557*^9}, {3.790880810737254*^9, 3.7908808264464817`*^9}, {
   3.790997185954791*^9, 3.79099724217729*^9}, {3.7909974013911695`*^9, 
   3.790997454696463*^9}, {3.792444206576111*^9, 3.7924442174025297`*^9}, {
   3.7933354034944987`*^9, 3.7933354192505264`*^9}, {3.825488883390066*^9, 
   3.8254889030729613`*^9}, {3.833755344439632*^9, 3.8337553558588223`*^9}, {
   3.8337553942872767`*^9, 3.8337554054252806`*^9}, {3.8522642113737416`*^9, 
   3.8522642338997*^9}, {3.8639786672529316`*^9, 3.863978692637512*^9}, {
   3.8876782667130604`*^9, 3.887678306625462*^9}, {3.918543604803583*^9, 
   3.9185436307193623`*^9}, {3.9639867031496067`*^9, 3.9639867355013604`*^9}},
 FontFamily->"Arial",
 FontSize->16,
 Background->RGBColor[
  0.4549019607843137, 0.6666666666666666, 0.8784313725490196]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["\[InvisiblePrefixScriptBase]", "1"],
     FontSize->14], 
    SubscriptBox[
     StyleBox[
      SubscriptBox[
       StyleBox["F",
        FontSize->17], 
       StyleBox["1",
        FontSize->10,
        FontSlant->"Plain"]],
      FontSize->17], 
     StyleBox["\[InvisiblePrefixScriptBase]",
      FontSize->14,
      FontSlant->"Plain"]]}], TraditionalForm]]],
 StyleBox["(",
  FontSize->15],
 StyleBox[" ",
  FontSize->6],
 "\[Alpha]",
 StyleBox[" ",
  FontSize->10],
 StyleBox[";",
  FontSize->14],
 " \[Gamma]",
 StyleBox[" ",
  FontSize->10],
 StyleBox[";",
  FontSize->14],
 " ",
 StyleBox["z",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSize->6],
 StyleBox[")",
  FontSize->15]
}], "Text",
 CellChangeTimes->{{3.5824915000966196`*^9, 3.5824915000966196`*^9}, {
   3.5824916032440004`*^9, 3.5824916032440004`*^9}, {3.582491668311715*^9, 
   3.582491668311715*^9}, {3.629673722761372*^9, 3.629673730826586*^9}, {
   3.6296737731494603`*^9, 3.6296738016663103`*^9}, {3.6301295823206177`*^9, 
   3.6301295823206177`*^9}, 3.630129633941108*^9, {3.63254916820891*^9, 
   3.6325491980517626`*^9}, {3.6325492349866276`*^9, 3.63254924234984*^9}, {
   3.6325492743766966`*^9, 3.632549276888301*^9}, {3.6329619039262304`*^9, 
   3.6329619379654903`*^9}, 3.633741294652232*^9, {3.6711637934061413`*^9, 
   3.671163823248994*^9}, 3.67116386672627*^9, 3.6711676417216325`*^9, {
   3.6743625517084985`*^9, 3.67436256392332*^9}, {3.675042378833744*^9, 
   3.6750423876009593`*^9}, 3.68698772003868*^9, {3.6869877654035597`*^9, 
   3.6869877678839636`*^9}, 3.6869878042476273`*^9, {3.686988219301957*^9, 
   3.686988219301957*^9}, 3.6870375495890017`*^9, {3.7096615756187935`*^9, 
   3.709661585696411*^9}, {3.7096616850217857`*^9, 3.7096616893273935`*^9}, 
   3.709661732445869*^9, 3.7096625799505606`*^9, {3.7096627317856274`*^9, 
   3.7096627317856274`*^9}, {3.7119169372200427`*^9, 3.711916962024086*^9}, {
   3.711950144289839*^9, 3.711950211603957*^9}, {3.711950314766938*^9, 
   3.7119503348129735`*^9}, {3.7119504161827164`*^9, 
   3.7119504277423368`*^9}, {3.7119504790196266`*^9, 3.7119504828884335`*^9}, 
   3.7119506827327867`*^9, {3.7326455616996984`*^9, 3.7326456756578984`*^9}, 
   3.740210188539296*^9, {3.740210227274164*^9, 3.7402102476322002`*^9}, {
   3.7402103047283*^9, 3.7402103578931932`*^9}, 3.740210757529096*^9, {
   3.7406316101931705`*^9, 3.7406316142023773`*^9}, 3.7444217570466595`*^9, {
   3.7445974660647497`*^9, 3.7445974660647497`*^9}, {3.7452071638624706`*^9, 
   3.745207220911771*^9}, {3.746990587619664*^9, 3.746990588664866*^9}, {
   3.7469906319549417`*^9, 3.7469906514081764`*^9}, {3.7469908105752563`*^9, 
   3.7469908294668894`*^9}, {3.7469911331838226`*^9, 3.746991138690632*^9}, {
   3.747188447227745*^9, 3.747188451470953*^9}, {3.747188500673439*^9, 
   3.747188511936659*^9}, 3.747188542075912*^9, {3.7471886169404435`*^9, 
   3.7471886301380663`*^9}, {3.7471892525791597`*^9, 3.7471892591935716`*^9}, 
   3.7471894078930326`*^9, {3.747203206756748*^9, 3.7472032546176324`*^9}, {
   3.753829594010942*^9, 3.7538296690314736`*^9}, {3.753829699545127*^9, 
   3.753829820117739*^9}, {3.753848069614362*^9, 3.7538480955884075`*^9}, {
   3.7538481267104626`*^9, 3.7538481267104626`*^9}, {3.764276527376436*^9, 
   3.764276652395056*^9}, 3.764276695529132*^9, {3.7914357429007196`*^9, 
   3.79143577433081*^9}, {3.800066753206977*^9, 3.800066776295285*^9}, {
   3.800066806350668*^9, 3.8000668381088424`*^9}, {3.8000671695150876`*^9, 
   3.800067212716776*^9}, {3.8067010446739044`*^9, 3.8067010446739044`*^9}, {
   3.8200295012217207`*^9, 3.8200295012217207`*^9}, {3.827873199008128*^9, 
   3.827873199008128*^9}, {3.848193531667981*^9, 3.848193531667981*^9}, {
   3.8530955499054956`*^9, 3.8530955558728085`*^9}, {3.853095598698382*^9, 
   3.8530956234425735`*^9}, {3.85309566105877*^9, 3.85309566105877*^9}, 
   3.85309686945766*^9, {3.8695302525076494`*^9, 3.869530286954235*^9}, {
   3.869530899794984*^9, 3.869530987587058*^9}, 3.869532050097499*^9, {
   3.928648407985051*^9, 3.9286484449295144`*^9}, {3.928648499416654*^9, 
   3.9286485676974573`*^9}, {3.928648602673667*^9, 3.9286486514590263`*^9}, {
   3.9286486896062975`*^9, 3.9286487005880527`*^9}, 3.928648837372279*^9},
 FontFamily->"Times New Roman",
 FontSize->16,
 Background->RGBColor[0.690196, 0.690196, 0.866667]],

Cell[BoxData[
 RowBox[{"glpConfHypergeomF1", "=", 
  RowBox[{
   StyleBox[
    RowBox[{"GridLines", 
     StyleBox["Plot",
      FontColor->GrayLevel[0]]}]], 
   StyleBox["[",
    FontColor->GrayLevel[0]], 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      StyleBox[
       RowBox[{
        RowBox[{"Hypergeometric1F1", "[", 
         RowBox[{"\[Alpha]", ",", "0.7", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}]}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "7"}], ",", "7"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7"}], ",", "7"}], "}"}]}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
    StyleBox[
     RowBox[{"AspectRatio", "\[Rule]", "1"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"\[Alpha]", "/", "11"}], ",", "1", ",", "0.8"}], "]"}], 
         ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Thickness", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Alpha]", "]"}], ",", "0.0024", ",", 
            "0.0012"}], "]"}], "]"}]}], "]"}], 
       StyleBox[",",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}],
        FontColor->GrayLevel[0]]}], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"GridLinesColor", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
       RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["FundamentalRectangle",
      FontWeight->"Bold"], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
    StyleBox[
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\>\"", ",", "\"\<y\>\""}], "}"}]}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.001", "]"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}]}], "}"}]}]}], 
   StyleBox["]",
    FontColor->GrayLevel[0]]}]}]], "Input",
 CellChangeTimes->{{3.9065974128486805`*^9, 3.9065974938140407`*^9}, {
   3.9065975242131386`*^9, 3.90659753036794*^9}, 3.9065977271816726`*^9, 
   3.9065978921117487`*^9, {3.9065979842150817`*^9, 3.906597984871173*^9}, {
   3.906598107935968*^9, 3.906598113028519*^9}, {3.90659841068647*^9, 
   3.906598425807948*^9}, 3.906598567305906*^9, {3.906598605772913*^9, 
   3.906598608397328*^9}, {3.9065986964464464`*^9, 3.9065986998049994`*^9}, {
   3.9065987482623806`*^9, 3.906598752120843*^9}, {3.906598854706271*^9, 
   3.9065988673439207`*^9}, {3.9065989332502623`*^9, 3.9065989387490387`*^9}, 
   3.9065993586241274`*^9, {3.9066610911487675`*^9, 3.9066610914143286`*^9}, {
   3.9341392942331424`*^9, 3.9341393192585354`*^9}, {3.9341393694980593`*^9, 
   3.9341394953575487`*^9}, {3.934139532916827*^9, 3.9341395381671057`*^9}, {
   3.9341395730170193`*^9, 3.9341395938558955`*^9}, {3.934139666417033*^9, 
   3.9341397600608053`*^9}, {3.9341398335970197`*^9, 
   3.9341398620746937`*^9}, {3.9341399100947094`*^9, 3.934139949710457*^9}, {
   3.934214326028593*^9, 3.934214327200164*^9}, {3.9342143581929097`*^9, 
   3.9342143635661135`*^9}, 3.9342145539322224`*^9, {3.939572805903493*^9, 
   3.9395728078248863`*^9}, {3.9395730926483445`*^9, 3.939573121469701*^9}, 
   3.957140125435748*^9, 3.9589401538797903`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0010.png\>\"", ",", "glpConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, 3.9395731528372993`*^9, 3.957140127544111*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"glpConfHypergeomF2", "=", 
  RowBox[{
   StyleBox[
    RowBox[{"GridLines", 
     StyleBox["Plot",
      FontColor->GrayLevel[0]]}]], 
   StyleBox["[",
    FontColor->GrayLevel[0]], 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      StyleBox[
       RowBox[{
        RowBox[{"Hypergeometric1F1", "[", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"-", "0.7"}], ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}]}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "8"}], ",", "4"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "6"}], "}"}]}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
    StyleBox[
     RowBox[{"AspectRatio", "\[Rule]", "1"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"\[Alpha]", "/", "11"}], ",", "1", ",", "0.8"}], "]"}], 
         ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Thickness", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Alpha]", "]"}], ",", "0.0024", ",", 
            "0.0012"}], "]"}], "]"}]}], "]"}], 
       StyleBox[",",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}],
        FontColor->GrayLevel[0]]}], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"GridLinesColor", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
       RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["FundamentalRectangle",
      FontWeight->"Bold"], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
    StyleBox[
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\>\"", ",", "\"\<y\>\""}], "}"}]}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.001", "]"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "8"}], ",", "4", ",", "2"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}]}], "}"}]}]}], 
   StyleBox["]",
    FontColor->GrayLevel[0]]}]}]], "Input",
 CellChangeTimes->{{3.9065974128486805`*^9, 3.9065974938140407`*^9}, {
   3.9065975242131386`*^9, 3.90659753036794*^9}, 3.9065977271816726`*^9, 
   3.9065978921117487`*^9, {3.9065979842150817`*^9, 3.906597984871173*^9}, {
   3.906598107935968*^9, 3.906598113028519*^9}, {3.90659841068647*^9, 
   3.906598425807948*^9}, 3.906598567305906*^9, {3.906598605772913*^9, 
   3.906598608397328*^9}, {3.9065986964464464`*^9, 3.9065986998049994`*^9}, {
   3.9065987482623806`*^9, 3.906598752120843*^9}, {3.906598854706271*^9, 
   3.9065988673439207`*^9}, {3.9065989332502623`*^9, 3.9065989387490387`*^9}, 
   3.9065993586241274`*^9, {3.9066610911487675`*^9, 3.9066610914143286`*^9}, {
   3.9341392942331424`*^9, 3.9341393192585354`*^9}, {3.9341393694980593`*^9, 
   3.9341394953575487`*^9}, {3.934139532916827*^9, 3.9341395381671057`*^9}, {
   3.9341395730170193`*^9, 3.9341395938558955`*^9}, {3.934139666417033*^9, 
   3.9341397600608053`*^9}, {3.9341398335970197`*^9, 
   3.9341398620746937`*^9}, {3.9341399100947094`*^9, 3.934139949710457*^9}, {
   3.934140150024379*^9, 3.9341401854055595`*^9}, {3.9342143438994107`*^9, 
   3.9342143454303036`*^9}, 3.934214491519023*^9, {3.9342147257306056`*^9, 
   3.934214742242366*^9}, {3.9395728125894203`*^9, 3.9395728169321404`*^9}, 
   3.9395731599918394`*^9, 3.9571401388429008`*^9, 3.9589401568478374`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0020.png\>\"", ",", "glpConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, 3.9395728549856677`*^9, 3.9395729014590807`*^9, 
   3.939573163475421*^9, 3.9571401406969433`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"glpConfHypergeomF3", "=", 
  RowBox[{
   StyleBox[
    RowBox[{"GridLines", 
     StyleBox["Plot",
      FontColor->GrayLevel[0]]}]], 
   StyleBox["[",
    FontColor->GrayLevel[0]], 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      StyleBox[
       RowBox[{
        RowBox[{"Hypergeometric1F1", "[", 
         RowBox[{"2.4", ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Gamma]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}]}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "4"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7"}], ",", "7"}], "}"}]}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
    StyleBox[
     RowBox[{"AspectRatio", "\[Rule]", "1"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"\[Gamma]", "/", "11"}], ",", "1", ",", "0.8"}], "]"}], 
         ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Thickness", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Gamma]", "]"}], ",", "0.0024", ",", 
            "0.0012"}], "]"}], "]"}]}], "]"}], 
       StyleBox[",",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"\[Gamma]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}],
        FontColor->GrayLevel[0]]}], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"GridLinesColor", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
       RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["FundamentalRectangle",
      FontWeight->"Bold"], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
    StyleBox[
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\>\"", ",", "\"\<y\>\""}], "}"}]}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.001", "]"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "4", ",", "2"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}]}], "}"}]}]}], 
   StyleBox["]",
    FontColor->GrayLevel[0]]}]}]], "Input",
 CellChangeTimes->{{3.9065974128486805`*^9, 3.9065974938140407`*^9}, {
   3.9065975242131386`*^9, 3.90659753036794*^9}, 3.9065977271816726`*^9, 
   3.9065978921117487`*^9, {3.9065979842150817`*^9, 3.906597984871173*^9}, {
   3.906598107935968*^9, 3.906598113028519*^9}, {3.90659841068647*^9, 
   3.906598425807948*^9}, 3.906598567305906*^9, {3.906598605772913*^9, 
   3.906598608397328*^9}, {3.9065986964464464`*^9, 3.9065986998049994`*^9}, {
   3.9065987482623806`*^9, 3.906598752120843*^9}, {3.906598854706271*^9, 
   3.9065988673439207`*^9}, {3.9065989332502623`*^9, 3.9065989387490387`*^9}, 
   3.9065993586241274`*^9, {3.9066610911487675`*^9, 3.9066610914143286`*^9}, {
   3.9341392942331424`*^9, 3.9341393192585354`*^9}, {3.9341393694980593`*^9, 
   3.9341394953575487`*^9}, {3.934139532916827*^9, 3.9341395381671057`*^9}, {
   3.9341395730170193`*^9, 3.9341395938558955`*^9}, {3.934139666417033*^9, 
   3.9341397600608053`*^9}, {3.9341398335970197`*^9, 
   3.9341398620746937`*^9}, {3.9341399100947094`*^9, 3.934139949710457*^9}, {
   3.934140237101777*^9, 3.9341402463459044`*^9}, {3.9341402793109784`*^9, 
   3.934140392894622*^9}, 3.9341404322604074`*^9, {3.9341407690052366`*^9, 
   3.934140880666565*^9}, {3.93421456350816*^9, 3.9342145833576813`*^9}, 
   3.9342146210207424`*^9, 3.93421467308667*^9, {3.939572829601028*^9, 
   3.9395728323347597`*^9}, {3.939572895522977*^9, 3.939572895741681*^9}, 
   3.93957317033315*^9, 3.9571401452118726`*^9, 3.958940160159554*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0030.png\>\"", ",", "glpConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, 3.9395728744654484`*^9, 3.9395729057549458`*^9, 
   3.939573173769867*^9, 3.95714014676873*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"glpConfHypergeomF4", "=", 
  RowBox[{
   StyleBox[
    RowBox[{"GridLines", 
     StyleBox["Plot",
      FontColor->GrayLevel[0]]}]], 
   StyleBox["[",
    FontColor->GrayLevel[0]], 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      StyleBox[
       RowBox[{
        RowBox[{"Hypergeometric1F1", "[", 
         RowBox[{
          RowBox[{"-", "2.4"}], ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Gamma]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}]}],
       FontColor->GrayLevel[0]], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}], 
     StyleBox["]",
      FontColor->GrayLevel[0]]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox[
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "15"}], ",", "15"}], "}"}]}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
    StyleBox[
     RowBox[{"AspectRatio", "\[Rule]", "1"}],
     FontColor->GrayLevel[0]], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"\[Gamma]", "/", "11"}], ",", "1", ",", "0.8"}], "]"}], 
         ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Thickness", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Gamma]", "]"}], ",", "0.0024", ",", 
            "0.0012"}], "]"}], "]"}]}], "]"}], 
       StyleBox[",",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"\[Gamma]", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", 
          RowBox[{"1", "/", "5"}]}], "}"}],
        FontColor->GrayLevel[0]]}], 
      StyleBox["]",
       FontColor->GrayLevel[0]]}]}], 
    StyleBox[",",
     FontColor->GrayLevel[0]], 
    StyleBox["\[IndentingNewLine]",
     FontColor->GrayLevel[0]], 
    RowBox[{"GridLinesColor", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
       RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["FundamentalRectangle",
      FontWeight->"Bold"], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5", ",", "2.5"}], "}"}]}], "}"}]}], ",", 
    StyleBox[
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"x\",
FontSlant->\"Italic\"]\)\>\"", ",", "\"\<y\>\""}], "}"}]}],
     FontColor->GrayLevel[0]], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.001", "]"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "15", ",", "5"}], "]"}], ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "15"}], ",", "15", ",", "5"}], "]"}]}], "}"}]}]}], 
   StyleBox["]",
    FontColor->GrayLevel[0]]}]}]], "Input",
 CellChangeTimes->{{3.9065974128486805`*^9, 3.9065974938140407`*^9}, {
   3.9065975242131386`*^9, 3.90659753036794*^9}, 3.9065977271816726`*^9, 
   3.9065978921117487`*^9, {3.9065979842150817`*^9, 3.906597984871173*^9}, {
   3.906598107935968*^9, 3.906598113028519*^9}, {3.90659841068647*^9, 
   3.906598425807948*^9}, 3.906598567305906*^9, {3.906598605772913*^9, 
   3.906598608397328*^9}, {3.9065986964464464`*^9, 3.9065986998049994`*^9}, {
   3.9065987482623806`*^9, 3.906598752120843*^9}, {3.906598854706271*^9, 
   3.9065988673439207`*^9}, {3.9065989332502623`*^9, 3.9065989387490387`*^9}, 
   3.9065993586241274`*^9, {3.9066610911487675`*^9, 3.9066610914143286`*^9}, {
   3.9341392942331424`*^9, 3.9341393192585354`*^9}, {3.9341393694980593`*^9, 
   3.9341394953575487`*^9}, {3.934139532916827*^9, 3.9341395381671057`*^9}, {
   3.9341395730170193`*^9, 3.9341395938558955`*^9}, {3.934139666417033*^9, 
   3.9341397600608053`*^9}, {3.9341398335970197`*^9, 
   3.9341398620746937`*^9}, {3.9341399100947094`*^9, 3.934139949710457*^9}, {
   3.934140237101777*^9, 3.9341402463459044`*^9}, {3.9341402793109784`*^9, 
   3.934140392894622*^9}, 3.9341404322604074`*^9, {3.9341406440032434`*^9, 
   3.9341406649358115`*^9}, {3.934140909097443*^9, 3.934140932576296*^9}, {
   3.9341409707548532`*^9, 3.9341409809087267`*^9}, {3.9342146327367163`*^9, 
   3.934214656090654*^9}, {3.9395728402391443`*^9, 3.939572842676071*^9}, {
   3.939572889430642*^9, 3.9395728896493683`*^9}, 3.939573179815318*^9, 
   3.957140151763355*^9, 3.9589401636899652`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0040.png\>\"", ",", "glpConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, {3.9395728835570545`*^9, 3.9395729099883156`*^9}, 
   3.939573183080165*^9, {3.956516691987017*^9, 3.9565167073896523`*^9}, 
   3.9571401539206085`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"p3ConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "5"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.8", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", "x", ",", 
             RowBox[{"Hypergeometric1F1", "[", 
              RowBox[{"\[Alpha]", ",", "2.2", ",", "x"}], "]"}]}], "}"}], ",",
            "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"-", "10"}], ",", "10", ",", "0.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "10"}], ",", "10", ",", "0.1"}], "}"}]}], "]"}], 
         ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.90"}], ",", "2.50", ",", "2.10"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
             RowBox[{"Rescale", "[", 
              RowBox[{"#3", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], ",", 
            "\[IndentingNewLine]", "opc", ",", 
            RowBox[{"Specularity", "[", 
             RowBox[{"White", ",", "50"}], "]"}]}], "]"}], "&"}], ")"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"MeshFunctions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "&"}], ",", 
          RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ClippingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "0", 
             "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "1", 
             "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Mesh", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", 
                 RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"-", "9"}], ",", "9"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", 
                 RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"-", "9"}], ",", "9"}], "}"}]}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<x\>\"", ",", "None"}], "}"}]}],
        ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4", ",", "2"}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"BoxStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BoundaryStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "]"}]}], "}"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "]"}]}], "}"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "}"}]}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6274601265819435`*^9, 3.627460138344364*^9}, {
   3.627460195799265*^9, 3.627460348799941*^9}, {3.627460419889266*^9, 
   3.627460451026921*^9}, 3.6274606860569334`*^9, {3.627460733403017*^9, 
   3.627460772340685*^9}, {3.6274608340699935`*^9, 3.627460836628398*^9}, 
   3.6914469451081066`*^9, {3.69918234609983*^9, 3.6991823802170897`*^9}, {
   3.73514770347698*^9, 3.7351477063941855`*^9}, 3.8543180030358667`*^9, {
   3.9395775208499537`*^9, 3.9395775270047517`*^9}, {3.9395777014567237`*^9, 
   3.9395778746346684`*^9}, 3.9395779674096684`*^9, {3.9395780067753487`*^9, 
   3.9395781709866247`*^9}, {3.9395782173975945`*^9, 
   3.9395782757900677`*^9}, {3.9395784239116497`*^9, 3.939578525825156*^9}, {
   3.939578587951122*^9, 3.9395785907785854`*^9}, {3.939578645078244*^9, 
   3.939578728418*^9}, {3.9395788252125673`*^9, 3.9395788506127977`*^9}, {
   3.939578989080144*^9, 3.939578992470005*^9}, {3.940401634696143*^9, 
   3.940401740733638*^9}, {3.9404018329306517`*^9, 3.9404019087019873`*^9}, {
   3.9528947488493924`*^9, 3.952894758659604*^9}, {3.956517101683529*^9, 
   3.9565171036830597`*^9}, {3.9565173903236647`*^9, 3.956517392276331*^9}, 
   3.9565188962796392`*^9, {3.9565191598945913`*^9, 3.956519194573923*^9}, {
   3.956521179509267*^9, 3.956521195989814*^9}, 3.9571402075767803`*^9, 
   3.963988162943183*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0050.png\>\"", ",", "p3ConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, {3.9395728835570545`*^9, 3.9395729099883156`*^9}, 
   3.939573183080165*^9, {3.956516691987017*^9, 3.9565167564250193`*^9}, 
   3.9571402110085955`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"conpConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "5"}], ",", "ticksLeft", ",", "ticksRight", ",", 
      "ticksBottom", ",", "ticksTop"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ticksLeft", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksRight", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksBottom", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksTop", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{"\[Alpha]", ",", "2.2", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"-", "50"}], "]"}], ",", 
          RowBox[{"Sinh", "[", "50", "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotPoints", "\[Rule]", "400"}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Contours", "\[Rule]", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sinh", "[", "#", "]"}], "&"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "50"}], ",", "50", ",", "0.25"}], "]"}]}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ContourStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.6"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
           RowBox[{"Rescale", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], "&"}], 
         ")"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"ClippingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "0", 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "1", 
           "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicksStyle", "\[Rule]", "8"}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.0009", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ticksLeft", ",", "ticksRight"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ticksBottom", ",", "ticksTop"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.15"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0002", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\[Alpha]", ",", 
                 RowBox[{"-", "10"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\[Alpha]", ",", "10"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Alpha]", ",", 
               RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "10"}], ",", "x"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"10", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.015", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.01", ",", "0.985"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.956517406335536*^9, 3.956517424331309*^9}, {
   3.9565180756159663`*^9, 3.9565180857073174`*^9}, {3.956518165672942*^9, 
   3.9565181675006504`*^9}, {3.9565182490440283`*^9, 
   3.9565182504811497`*^9}, {3.956518344177946*^9, 3.9565183686565695`*^9}, {
   3.956518498429121*^9, 3.9565184992726684`*^9}, 3.9565185472301693`*^9, {
   3.9565186288672543`*^9, 3.956518682011034*^9}, {3.9565187341550584`*^9, 
   3.9565187723335867`*^9}, {3.956518834959526*^9, 3.9565188487375355`*^9}, {
   3.956519054332699*^9, 3.9565190608155503`*^9}, {3.9565211996607876`*^9, 
   3.956521210095833*^9}, {3.957140219511839*^9, 3.9571402215035133`*^9}, 
   3.96398816948855*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0060.png\>\"", ",", "conpConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, 3.906596659531193*^9, {3.906598287112558*^9, 
   3.906598301937228*^9}, 3.906598717254052*^9, 3.9065990155121574`*^9, {
   3.906661029382049*^9, 3.9066610326781487`*^9}, 3.9102085302449045`*^9, {
   3.910208586721588*^9, 3.910208592173432*^9}, 3.910209252702484*^9, {
   3.9102093781574197`*^9, 3.9102093820940003`*^9}, {3.910209568801923*^9, 
   3.9102096039343557`*^9}, 3.9102097191138496`*^9, {3.9102118470896397`*^9, 
   3.9102119085127296`*^9}, {3.910211988290888*^9, 3.9102119987103558`*^9}, {
   3.9565173450374174`*^9, 3.9565173624395833`*^9}, 3.9571402244007893`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"p3ConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "25"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.8", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", "x", ",", 
             RowBox[{"Hypergeometric1F1", "[", 
              RowBox[{"\[Alpha]", ",", 
               RowBox[{"-", "2.2"}], ",", "x"}], "]"}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"-", "10"}], ",", "10", ",", "0.05"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "10"}], ",", "10", ",", "0.05"}], "}"}]}], "]"}], 
         ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.95"}], ",", 
          RowBox[{"-", "2.04"}], ",", "2.53"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
             RowBox[{"Rescale", "[", 
              RowBox[{"#3", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], ",", 
            "\[IndentingNewLine]", "opc", ",", 
            RowBox[{"Specularity", "[", 
             RowBox[{"White", ",", "50"}], "]"}]}], "]"}], "&"}], ")"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"MeshFunctions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "&"}], ",", 
          RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ClippingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "0", 
             "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "1", 
             "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Mesh", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", 
                 RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"-", "9"}], ",", "9"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", 
                 RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", 
              RowBox[{"-", "9"}], ",", "9"}], "}"}]}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<x\>\"", ",", "None"}], "}"}]}],
        ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "20"}], ",", "20", ",", "10"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"BoxStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BoundaryStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "5"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "5"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "}"}]}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6274601265819435`*^9, 3.627460138344364*^9}, {
   3.627460195799265*^9, 3.627460348799941*^9}, {3.627460419889266*^9, 
   3.627460451026921*^9}, 3.6274606860569334`*^9, {3.627460733403017*^9, 
   3.627460772340685*^9}, {3.6274608340699935`*^9, 3.627460836628398*^9}, 
   3.6914469451081066`*^9, {3.69918234609983*^9, 3.6991823802170897`*^9}, {
   3.73514770347698*^9, 3.7351477063941855`*^9}, 3.8543180030358667`*^9, {
   3.9395775208499537`*^9, 3.9395775270047517`*^9}, {3.9395777014567237`*^9, 
   3.9395778746346684`*^9}, 3.9395779674096684`*^9, {3.9395780067753487`*^9, 
   3.9395781709866247`*^9}, {3.9395782173975945`*^9, 
   3.9395782757900677`*^9}, {3.9395784239116497`*^9, 3.939578525825156*^9}, {
   3.939578587951122*^9, 3.9395785907785854`*^9}, {3.939578645078244*^9, 
   3.939578728418*^9}, {3.9395788252125673`*^9, 3.9395788506127977`*^9}, {
   3.939578989080144*^9, 3.939578992470005*^9}, {3.940401634696143*^9, 
   3.940401740733638*^9}, {3.9404018329306517`*^9, 3.9404019087019873`*^9}, {
   3.9404020136607513`*^9, 3.940402056885992*^9}, {3.9404020874256625`*^9, 
   3.9404020936586065`*^9}, {3.940402289166055*^9, 3.9404023560721226`*^9}, {
   3.9404024078099527`*^9, 3.9404024297110076`*^9}, {3.9404025034619727`*^9, 
   3.9404025393909993`*^9}, {3.9528947162164183`*^9, 
   3.9528947381331835`*^9}, {3.9565174675868177`*^9, 3.9565174781624346`*^9}, 
   3.95651926399516*^9, {3.9565193351545477`*^9, 3.9565193413562536`*^9}, {
   3.9565195079890237`*^9, 3.9565195100822754`*^9}, {3.956520208046959*^9, 
   3.956520232650566*^9}, {3.9565212137043743`*^9, 3.956521232715531*^9}, 
   3.9571402297105703`*^9, 3.9639881744873657`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0070.png\>\"", ",", "p3ConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, {3.9395728835570545`*^9, 3.9395729099883156`*^9}, 
   3.939573183080165*^9, {3.956516691987017*^9, 3.9565167564250193`*^9}, {
   3.956517453683798*^9, 3.956517457229843*^9}, 3.9571402331932793`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"conpConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "25"}], ",", "ticksLeft", ",", "ticksRight", ",", 
      "ticksBottom", ",", "ticksTop"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ticksLeft", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksRight", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksBottom", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksTop", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{"-", "2.2"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"-", "50"}], "]"}], ",", 
          RowBox[{"Sinh", "[", "50", "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotPoints", "\[Rule]", "400"}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Contours", "\[Rule]", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sinh", "[", "#", "]"}], "&"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "50"}], ",", "50", ",", "0.25"}], "]"}]}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ContourStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.6"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
           RowBox[{"Rescale", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], "&"}], 
         ")"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"ClippingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "0", 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "1", 
           "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicksStyle", "\[Rule]", "8"}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.0009", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ticksLeft", ",", "ticksRight"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ticksBottom", ",", "ticksTop"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.15"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0002", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\[Alpha]", ",", 
                 RowBox[{"-", "10"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\[Alpha]", ",", "10"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Alpha]", ",", 
               RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "10"}], ",", "x"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"10", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.015", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.01", ",", "0.985"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565175163097243`*^9, 3.956517517262619*^9}, {
   3.956519222458042*^9, 3.9565192388292046`*^9}, {3.9565212366364822`*^9, 
   3.9565212400575557`*^9}, 3.9571402365662394`*^9, 3.963988178986292*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0080.png\>\"", ",", "conpConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, 3.906596659531193*^9, {3.906598287112558*^9, 
   3.906598301937228*^9}, 3.906598717254052*^9, 3.9065990155121574`*^9, {
   3.906661029382049*^9, 3.9066610326781487`*^9}, 3.9102085302449045`*^9, {
   3.910208586721588*^9, 3.910208592173432*^9}, 3.910209252702484*^9, {
   3.9102093781574197`*^9, 3.9102093820940003`*^9}, {3.910209568801923*^9, 
   3.9102096039343557`*^9}, 3.9102097191138496`*^9, {3.9102118470896397`*^9, 
   3.9102119085127296`*^9}, {3.910211988290888*^9, 3.9102119987103558`*^9}, {
   3.9565173450374174`*^9, 3.9565173624395833`*^9}, {3.9565175017037773`*^9, 
   3.9565175064682846`*^9}, 3.957140238968816*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"p3ConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "50"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.8", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Plot", "-", "1"}], " ", ":", " ", 
          RowBox[{
           RowBox[{"-", "6"}], "<=", "\[Gamma]", "<", "0"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"Hypergeometric1F1", "[", 
              RowBox[{"4.4", ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Gamma]", ",", "n", ",", 
               RowBox[{"n", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"60", ",", "400"}], "}"}]}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"#2", "&"}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "}"}]}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"-", "6"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "2"}], " ", ":", " ", 
           RowBox[{"0", "<=", "\[Gamma]", "<", "6"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{"Hypergeometric1F1", "[", 
             RowBox[{"4.4", ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Gamma]", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"200", ",", "400"}], "}"}]}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                 ",", "\[IndentingNewLine]", "opc", ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
              ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#1", "&"}], ",", 
               RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"ClippingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "0", "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
              "]"}]}]}], "]"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.64", ",", 
          RowBox[{"-", "2.47"}], ",", "2.22"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Gamma]\>\"", ",", "\"\<x\>\"", ",", "None"}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "40"}], ",", "40", ",", "20"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "10"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "}"}]}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6253015344558573`*^9, 3.6253016112703924`*^9}, {
   3.625301675776506*^9, 3.6253017735262775`*^9}, {3.625301810888343*^9, 
   3.6253018255211687`*^9}, {3.625301872024851*^9, 3.6253019003701005`*^9}, {
   3.6253019306809535`*^9, 3.6253019566393995`*^9}, {3.625301986731852*^9, 
   3.6253020144219007`*^9}, 3.625302057041176*^9, {3.6253020946528416`*^9, 
   3.6253021070392632`*^9}, {3.6253021630121613`*^9, 
   3.6253021918722124`*^9}, {3.625302239358696*^9, 3.6253022793571663`*^9}, {
   3.625302325970048*^9, 3.625302328778053*^9}, {3.625302426635826*^9, 
   3.625302545757635*^9}, {3.6253028118437023`*^9, 3.625302820142917*^9}, {
   3.62530287316741*^9, 3.6253028749146132`*^9}, {3.625303009810851*^9, 
   3.6253030276416817`*^9}, {3.625303566747429*^9, 3.625303651034377*^9}, 
   3.6253039052368236`*^9, {3.625304052454282*^9, 3.6253040555898876`*^9}, {
   3.625304103715972*^9, 3.625304122248805*^9}, 3.6253042964231105`*^9, {
   3.62530471731185*^9, 3.6253047290430703`*^9}, {3.625446028316736*^9, 
   3.6254460582843885`*^9}, {3.641544654156429*^9, 3.6415446847168827`*^9}, {
   3.6415448700928082`*^9, 3.6415449514937515`*^9}, {3.64154499628143*^9, 
   3.6415450569967365`*^9}, {3.6415451163548408`*^9, 3.641545270217911*^9}, 
   3.641545530589569*^9, {3.6415456576705933`*^9, 3.6415457371215324`*^9}, 
   3.641574800794989*^9, 3.6415748857839384`*^9, {3.6415791679262753`*^9, 
   3.6415791695018787`*^9}, {3.6419406018134565`*^9, 3.6419406359151163`*^9}, 
   3.641940720077264*^9, 3.6419475393483133`*^9, {3.64220004517609*^9, 
   3.6422001353442483`*^9}, {3.6422002089763775`*^9, 
   3.6422002244360046`*^9}, {3.6422002578980637`*^9, 3.642200263108473*^9}, {
   3.6422002951509285`*^9, 3.6422002991913357`*^9}, {3.6422004909468727`*^9, 
   3.64220049514328*^9}, 3.6422007475277243`*^9, {3.642207178754227*^9, 
   3.642207189315446*^9}, {3.806703994464528*^9, 3.806704001478422*^9}, {
   3.806704056355685*^9, 3.8067041119782248`*^9}, {3.8067041507429686`*^9, 
   3.806704154041049*^9}, 3.806704187798808*^9, {3.80670422532463*^9, 
   3.806704228886269*^9}, {3.8067042628058176`*^9, 3.8067042803228564`*^9}, 
   3.8067050476929927`*^9, {3.806705889159841*^9, 3.8067058923309984`*^9}, {
   3.806708882830043*^9, 3.806708911135912*^9}, {3.806786979311401*^9, 
   3.806787001977966*^9}, {3.806787045795947*^9, 3.8067870485608435`*^9}, {
   3.8067873109059525`*^9, 3.8067873453198338`*^9}, {3.8067882930324683`*^9, 
   3.806788297453336*^9}, {3.8067885788184824`*^9, 3.8067886091863766`*^9}, {
   3.8067886417881813`*^9, 3.80678872234753*^9}, {3.8067887570186586`*^9, 
   3.8067887827561445`*^9}, 3.806788826277253*^9, 3.806788868267476*^9, {
   3.806788910195197*^9, 3.806788912788316*^9}, {3.8071508014769983`*^9, 
   3.8071508047887187`*^9}, 3.807151136866843*^9, 3.807151203839569*^9, {
   3.8071512435850277`*^9, 3.8071513518163123`*^9}, {3.807151392873164*^9, 
   3.8071513972315183`*^9}, {3.8071514287396936`*^9, 3.807151501677074*^9}, {
   3.807151539636358*^9, 3.8071516109320908`*^9}, {3.8071516493917866`*^9, 
   3.807151673964115*^9}, {3.807151708150198*^9, 3.807151730488662*^9}, {
   3.8071517677748346`*^9, 3.8071517885980263`*^9}, {3.8071524195644903`*^9, 
   3.807152438231966*^9}, {3.807153797383215*^9, 3.8071538326561413`*^9}, {
   3.807240920164612*^9, 3.8072409789164085`*^9}, {3.807241012549118*^9, 
   3.8072410162826147`*^9}, {3.8072410758935833`*^9, 3.807241083173119*^9}, {
   3.8072411241166363`*^9, 3.807241315368495*^9}, {3.8072413464080367`*^9, 
   3.8072414174069495`*^9}, {3.8072414515239196`*^9, 3.807241475299574*^9}, {
   3.8072415252565937`*^9, 3.807241587898092*^9}, 3.8072416370896177`*^9, {
   3.807241675830532*^9, 3.8072417614978666`*^9}, {3.8072419333950815`*^9, 
   3.807241952765525*^9}, 3.8072420510914097`*^9, 3.8072421800924387`*^9, 
   3.807242213194024*^9, {3.8072425451505413`*^9, 3.807242615557778*^9}, 
   3.807243259960881*^9, {3.8072441254566774`*^9, 3.807244239804792*^9}, 
   3.807244274999642*^9, {3.807244467704273*^9, 3.807244559401432*^9}, {
   3.8072446013446655`*^9, 3.8072446866527443`*^9}, {3.8072447364847364`*^9, 
   3.8072447637439685`*^9}, 3.807245274842724*^9, {3.8210575884710093`*^9, 
   3.8210576167299614`*^9}, 3.8210576500345592`*^9, {3.8210577125041666`*^9, 
   3.8210577172999287`*^9}, 3.821057756009528*^9, {3.8210578196194696`*^9, 
   3.821057833694268*^9}, {3.821057866936447*^9, 3.821057932686528*^9}, {
   3.82105802613315*^9, 3.8210580343968244`*^9}, 3.821058076668109*^9, {
   3.8210581104413447`*^9, 3.821058123375817*^9}, 3.821058182643027*^9, {
   3.8210582413479204`*^9, 3.8210582902425904`*^9}, {3.8210583595387297`*^9, 
   3.821058381830335*^9}, 3.8210584418786182`*^9, {3.8210584761517935`*^9, 
   3.821058488352007*^9}, {3.8210585233124924`*^9, 3.821058550743508*^9}, {
   3.82105860888603*^9, 3.821058636238943*^9}, 3.821058700614352*^9, 
   3.8210588458924856`*^9, 3.821059072201398*^9, {3.8210734218271446`*^9, 
   3.821073432309046*^9}, {3.8210735542695475`*^9, 3.8210735580499363`*^9}, 
   3.821075553372513*^9, {3.8278746048380694`*^9, 3.8278746313943386`*^9}, {
   3.8287488220709143`*^9, 3.8287488345509357`*^9}, {3.828748874050205*^9, 
   3.828748885734626*^9}, 3.8287489282291*^9, {3.8287490792217655`*^9, 
   3.828749082482171*^9}, {3.828749113947427*^9, 3.8287491776111383`*^9}, {
   3.8287492167984076`*^9, 3.828749244972057*^9}, {3.82874927503331*^9, 
   3.8287493561846523`*^9}, {3.828749447297613*^9, 3.828749492709293*^9}, {
   3.828749552644598*^9, 3.828749603937488*^9}, {3.828749634763142*^9, 
   3.8287496378675475`*^9}, {3.828749731077711*^9, 3.8287497842426047`*^9}, 
   3.8287498785915704`*^9, 3.82946145141483*^9, {3.8294614834541597`*^9, 
   3.8294615297852592`*^9}, {3.829461680843571*^9, 3.829461692778242*^9}, {
   3.8294617356744547`*^9, 3.829461826918645*^9}, {3.8294620643473387`*^9, 
   3.8294621128359675`*^9}, 3.8294622108598495`*^9, {3.829462256864679*^9, 
   3.8294623300349975`*^9}, {3.829462366104672*^9, 3.8294623802107396`*^9}, {
   3.8294624538184395`*^9, 3.8294625116955137`*^9}, {3.829462551420568*^9, 
   3.829462562574212*^9}, {3.829462681671254*^9, 3.829462725301649*^9}, 
   3.829462763027173*^9, {3.8294628112033715`*^9, 3.8294628116720095`*^9}, {
   3.829462859067143*^9, 3.8294628790720625`*^9}, {3.829462929732047*^9, 
   3.8294629343715863`*^9}, {3.829462993092182*^9, 3.8294630007622566`*^9}, {
   3.8294636759476056`*^9, 3.829463682524181*^9}, {3.829463988916354*^9, 
   3.82946399285293*^9}, {3.8294641251812897`*^9, 3.829464185542125*^9}, {
   3.8294644575623865`*^9, 3.829464481572372*^9}, 3.8547421727696342`*^9, 
   3.854742229350079*^9, {3.854742268140275*^9, 3.854742273826438*^9}, {
   3.8547423452159033`*^9, 3.8547423636803102`*^9}, {3.854742395647602*^9, 
   3.854742452920491*^9}, {3.8547425604506865`*^9, 3.8547425607318735`*^9}, {
   3.8547425951645975`*^9, 3.854742660914789*^9}, {3.8547427079256783`*^9, 
   3.8547427440734277`*^9}, {3.8547427920152826`*^9, 3.854742795639428*^9}, {
   3.854742866079006*^9, 3.854742866282056*^9}, {3.854742908662737*^9, 
   3.854742936069667*^9}, {3.8547429676716113`*^9, 3.8547430039432487`*^9}, 
   3.854743039452135*^9, {3.854743162190482*^9, 3.8547432089175377`*^9}, 
   3.854743649769946*^9, {3.854743701533106*^9, 3.854743714998661*^9}, 
   3.8547437598356123`*^9, {3.854750271948118*^9, 3.854750383997134*^9}, 
   3.8547518341477346`*^9, 3.855089017803909*^9, 3.8806555907852793`*^9, 
   3.8806556592223673`*^9, {3.8806557940189486`*^9, 3.8806557996269817`*^9}, {
   3.880656454452241*^9, 3.8806565356832542`*^9}, {3.88065656958153*^9, 
   3.880656573877398*^9}, {3.8806566264273443`*^9, 3.8806566544988856`*^9}, {
   3.8806567631453204`*^9, 3.880656817288887*^9}, {3.880660812053049*^9, 
   3.8806608237065735`*^9}, {3.880660908624188*^9, 3.8806609760146465`*^9}, 
   3.880661033344963*^9, {3.8806610996673717`*^9, 3.88066111760067*^9}, 
   3.880661154748212*^9, {3.8806612011748405`*^9, 3.8806612510381603`*^9}, {
   3.880661500138209*^9, 3.8806615131664343`*^9}, {3.880661566060268*^9, 
   3.8806616509154277`*^9}, {3.883108994033066*^9, 3.8831089959857645`*^9}, {
   3.952878275699746*^9, 3.952878296788571*^9}, {3.9528783325146027`*^9, 
   3.95287841983799*^9}, {3.952878487353442*^9, 3.9528785816282997`*^9}, {
   3.952878615776575*^9, 3.9528786274769945`*^9}, {3.952878659532015*^9, 
   3.9528786851353846`*^9}, 3.952878715362693*^9, {3.952878775254991*^9, 
   3.9528787819253044`*^9}, {3.9528788175888195`*^9, 3.952878941575489*^9}, {
   3.9528790221035576`*^9, 3.9528791103329525`*^9}, {3.9528791420755725`*^9, 
   3.9528791962035275`*^9}, {3.9528796096010103`*^9, 
   3.9528796231447277`*^9}, {3.9528796571055317`*^9, 3.95287973063525*^9}, {
   3.952879973906555*^9, 3.9528799827013474`*^9}, 3.9529077696688776`*^9, {
   3.956517727182108*^9, 3.9565178114123416`*^9}, 3.9565178478569183`*^9, 
   3.9565199539360514`*^9, {3.956520027887325*^9, 3.9565200306992006`*^9}, {
   3.9565201889589343`*^9, 3.956520191677049*^9}, {3.9565202421327095`*^9, 
   3.9565202706885056`*^9}, {3.9565212649735856`*^9, 3.9565213006370983`*^9}, 
   3.9571402659426947`*^9, 3.9639882012778945`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0090.png\>\"", ",", "p3ConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, {3.9395728835570545`*^9, 3.9395729099883156`*^9}, 
   3.939573183080165*^9, {3.956516691987017*^9, 3.9565167564250193`*^9}, {
   3.956517453683798*^9, 3.956517457229843*^9}, {3.956517534602311*^9, 
   3.956517541928712*^9}, 3.957140270856556*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"conpConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "50"}], ",", "ticksLeft", ",", "ticksRight", ",", 
      "ticksBottom", ",", "ticksTop"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ticksLeft", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksRight", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksBottom", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksTop", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{"4.4", ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Gamma]", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"-", "35"}], "]"}], ",", 
          RowBox[{"Sinh", "[", "35", "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Contours", "\[Rule]", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sinh", "[", "#", "]"}], "&"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "35"}], ",", "35", ",", "0.25"}], "]"}]}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ContourStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.6"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
           RowBox[{"Rescale", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], "&"}], 
         ")"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"ClippingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "0", 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "1", 
           "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Gamma]\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicksStyle", "\[Rule]", "8"}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.0009", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ticksLeft", ",", "ticksRight"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ticksBottom", ",", "ticksTop"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.15"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0002", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\[Gamma]", ",", 
                 RowBox[{"-", "6"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\[Gamma]", ",", "6"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Gamma]", ",", 
               RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "6"}], ",", "x"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}], "]"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.015", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.01", ",", "0.985"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9565175921825485`*^9, 3.9565175926199427`*^9}, {
   3.95651997197869*^9, 3.9565199824918537`*^9}, 3.9565200551621733`*^9, {
   3.956520099323722*^9, 3.9565201732126136`*^9}, {3.9565205966394033`*^9, 
   3.956520628069523*^9}, {3.956520785415578*^9, 3.9565208034113593`*^9}, {
   3.9565213724977903`*^9, 3.95652137754348*^9}, 3.957140274461938*^9, {
   3.957339422353585*^9, 3.957339425430994*^9}, 3.963988205198841*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0100.png\>\"", ",", "conpConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, 3.906596659531193*^9, {3.906598287112558*^9, 
   3.906598301937228*^9}, 3.906598717254052*^9, 3.9065990155121574`*^9, {
   3.906661029382049*^9, 3.9066610326781487`*^9}, 3.9102085302449045`*^9, {
   3.910208586721588*^9, 3.910208592173432*^9}, 3.910209252702484*^9, {
   3.9102093781574197`*^9, 3.9102093820940003`*^9}, {3.910209568801923*^9, 
   3.9102096039343557`*^9}, 3.9102097191138496`*^9, {3.9102118470896397`*^9, 
   3.9102119085127296`*^9}, {3.910211988290888*^9, 3.9102119987103558`*^9}, {
   3.9565173450374174`*^9, 3.9565173624395833`*^9}, {3.9565175017037773`*^9, 
   3.9565175064682846`*^9}, {3.9565175681413093`*^9, 3.9565175773422766`*^9}, 
   3.9571402772803802`*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"p3ConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "250"}], ",", "thick", ",", "opc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"thick", "=", 
      RowBox[{"Thickness", "[", "0.0004", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"opc", "=", 
      RowBox[{"Opacity", "[", "0.7", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"Join", "[", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"Plot", "-", "1"}], " ", ":", " ", 
          RowBox[{
           RowBox[{"-", "6"}], "<=", "\[Gamma]", "<", "0"}]}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Plot3D", "[", 
            RowBox[{
             RowBox[{"Hypergeometric1F1", "[", 
              RowBox[{
               RowBox[{"-", "4.4"}], ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Gamma]", ",", "n", ",", 
               RowBox[{"n", "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
             RowBox[{"PlotPoints", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"60", ",", "400"}], "}"}]}], ",", 
             RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ColorFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                  ",", "\[IndentingNewLine]", "opc", ",", 
                  RowBox[{"Specularity", "[", 
                   RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
               ")"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
             RowBox[{"MeshFunctions", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"#2", "&"}], "}"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"Mesh", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "}"}]}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"ClippingStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "0", "]"}], ",", "opc"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                   "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BoundaryStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
               "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"-", "6"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Plot", "-", "2"}], " ", ":", " ", 
           RowBox[{"0", "<=", "\[Gamma]", "<", "6"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Plot3D", "[", 
           RowBox[{
            RowBox[{"Hypergeometric1F1", "[", 
             RowBox[{
              RowBox[{"-", "4.4"}], ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Gamma]", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], ",", 
            RowBox[{"PlotPoints", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"200", ",", "400"}], "}"}]}], ",", 
            RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ColorFunction", "\[Rule]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  RowBox[{"Rescale", "[", 
                   RowBox[{"#3", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], 
                 ",", "\[IndentingNewLine]", "opc", ",", 
                 RowBox[{"Specularity", "[", 
                  RowBox[{"White", ",", "200"}], "]"}]}], "]"}], "&"}], 
              ")"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
            RowBox[{"MeshFunctions", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#1", "&"}], ",", 
               RowBox[{"#2", "&"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"Mesh", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"GrayLevel", "[", 
                    RowBox[{"0", ",", "0.6"}], "]"}], ",", "thick"}], "]"}]}],
                   "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", 
                   RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "}"}]}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"ClippingStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "0", "]"}], ",", "opc"}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
                  "1", "]"}], ",", "opc"}], "]"}]}], "}"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"BoundaryStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{
               RowBox[{"GrayLevel", "[", "0", "]"}], ",", "thick"}], 
              "]"}]}]}], "]"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Options", " ", "of", " ", "the", " ", "Show"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.86", ",", 
          RowBox[{"-", "2.48"}], ",", "2.10"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Gamma]\>\"", ",", "\"\<x\>\"", ",", "None"}], "}"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "6"}], ",", "6", ",", "2"}], "]"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "200"}], ",", "200", ",", "100"}], "]"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"AxesEdge", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FaceGrids", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "50"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "p"}], ",", "p", ",", "50"}], "]"}]}], "}"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}], ",", 
              RowBox[{"Range", "[", 
               RowBox[{
                RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "}"}]}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FaceGridsStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "thick"}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.02", ",", "0.98"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.6253015344558573`*^9, 3.6253016112703924`*^9}, {
   3.625301675776506*^9, 3.6253017735262775`*^9}, {3.625301810888343*^9, 
   3.6253018255211687`*^9}, {3.625301872024851*^9, 3.6253019003701005`*^9}, {
   3.6253019306809535`*^9, 3.6253019566393995`*^9}, {3.625301986731852*^9, 
   3.6253020144219007`*^9}, 3.625302057041176*^9, {3.6253020946528416`*^9, 
   3.6253021070392632`*^9}, {3.6253021630121613`*^9, 
   3.6253021918722124`*^9}, {3.625302239358696*^9, 3.6253022793571663`*^9}, {
   3.625302325970048*^9, 3.625302328778053*^9}, {3.625302426635826*^9, 
   3.625302545757635*^9}, {3.6253028118437023`*^9, 3.625302820142917*^9}, {
   3.62530287316741*^9, 3.6253028749146132`*^9}, {3.625303009810851*^9, 
   3.6253030276416817`*^9}, {3.625303566747429*^9, 3.625303651034377*^9}, 
   3.6253039052368236`*^9, {3.625304052454282*^9, 3.6253040555898876`*^9}, {
   3.625304103715972*^9, 3.625304122248805*^9}, 3.6253042964231105`*^9, {
   3.62530471731185*^9, 3.6253047290430703`*^9}, {3.625446028316736*^9, 
   3.6254460582843885`*^9}, {3.641544654156429*^9, 3.6415446847168827`*^9}, {
   3.6415448700928082`*^9, 3.6415449514937515`*^9}, {3.64154499628143*^9, 
   3.6415450569967365`*^9}, {3.6415451163548408`*^9, 3.641545270217911*^9}, 
   3.641545530589569*^9, {3.6415456576705933`*^9, 3.6415457371215324`*^9}, 
   3.641574800794989*^9, 3.6415748857839384`*^9, {3.6415791679262753`*^9, 
   3.6415791695018787`*^9}, {3.6419406018134565`*^9, 3.6419406359151163`*^9}, 
   3.641940720077264*^9, 3.6419475393483133`*^9, {3.64220004517609*^9, 
   3.6422001353442483`*^9}, {3.6422002089763775`*^9, 
   3.6422002244360046`*^9}, {3.6422002578980637`*^9, 3.642200263108473*^9}, {
   3.6422002951509285`*^9, 3.6422002991913357`*^9}, {3.6422004909468727`*^9, 
   3.64220049514328*^9}, 3.6422007475277243`*^9, {3.642207178754227*^9, 
   3.642207189315446*^9}, {3.806703994464528*^9, 3.806704001478422*^9}, {
   3.806704056355685*^9, 3.8067041119782248`*^9}, {3.8067041507429686`*^9, 
   3.806704154041049*^9}, 3.806704187798808*^9, {3.80670422532463*^9, 
   3.806704228886269*^9}, {3.8067042628058176`*^9, 3.8067042803228564`*^9}, 
   3.8067050476929927`*^9, {3.806705889159841*^9, 3.8067058923309984`*^9}, {
   3.806708882830043*^9, 3.806708911135912*^9}, {3.806786979311401*^9, 
   3.806787001977966*^9}, {3.806787045795947*^9, 3.8067870485608435`*^9}, {
   3.8067873109059525`*^9, 3.8067873453198338`*^9}, {3.8067882930324683`*^9, 
   3.806788297453336*^9}, {3.8067885788184824`*^9, 3.8067886091863766`*^9}, {
   3.8067886417881813`*^9, 3.80678872234753*^9}, {3.8067887570186586`*^9, 
   3.8067887827561445`*^9}, 3.806788826277253*^9, 3.806788868267476*^9, {
   3.806788910195197*^9, 3.806788912788316*^9}, {3.8071508014769983`*^9, 
   3.8071508047887187`*^9}, 3.807151136866843*^9, 3.807151203839569*^9, {
   3.8071512435850277`*^9, 3.8071513518163123`*^9}, {3.807151392873164*^9, 
   3.8071513972315183`*^9}, {3.8071514287396936`*^9, 3.807151501677074*^9}, {
   3.807151539636358*^9, 3.8071516109320908`*^9}, {3.8071516493917866`*^9, 
   3.807151673964115*^9}, {3.807151708150198*^9, 3.807151730488662*^9}, {
   3.8071517677748346`*^9, 3.8071517885980263`*^9}, {3.8071524195644903`*^9, 
   3.807152438231966*^9}, {3.807153797383215*^9, 3.8071538326561413`*^9}, {
   3.807240920164612*^9, 3.8072409789164085`*^9}, {3.807241012549118*^9, 
   3.8072410162826147`*^9}, {3.8072410758935833`*^9, 3.807241083173119*^9}, {
   3.8072411241166363`*^9, 3.807241315368495*^9}, {3.8072413464080367`*^9, 
   3.8072414174069495`*^9}, {3.8072414515239196`*^9, 3.807241475299574*^9}, {
   3.8072415252565937`*^9, 3.807241587898092*^9}, 3.8072416370896177`*^9, {
   3.807241675830532*^9, 3.8072417614978666`*^9}, {3.8072419333950815`*^9, 
   3.807241952765525*^9}, 3.8072420510914097`*^9, 3.8072421800924387`*^9, 
   3.807242213194024*^9, {3.8072425451505413`*^9, 3.807242615557778*^9}, 
   3.807243259960881*^9, {3.8072441254566774`*^9, 3.807244239804792*^9}, 
   3.807244274999642*^9, {3.807244467704273*^9, 3.807244559401432*^9}, {
   3.8072446013446655`*^9, 3.8072446866527443`*^9}, {3.8072447364847364`*^9, 
   3.8072447637439685`*^9}, 3.807245274842724*^9, {3.8210575884710093`*^9, 
   3.8210576167299614`*^9}, 3.8210576500345592`*^9, {3.8210577125041666`*^9, 
   3.8210577172999287`*^9}, 3.821057756009528*^9, {3.8210578196194696`*^9, 
   3.821057833694268*^9}, {3.821057866936447*^9, 3.821057932686528*^9}, {
   3.82105802613315*^9, 3.8210580343968244`*^9}, 3.821058076668109*^9, {
   3.8210581104413447`*^9, 3.821058123375817*^9}, 3.821058182643027*^9, {
   3.8210582413479204`*^9, 3.8210582902425904`*^9}, {3.8210583595387297`*^9, 
   3.821058381830335*^9}, 3.8210584418786182`*^9, {3.8210584761517935`*^9, 
   3.821058488352007*^9}, {3.8210585233124924`*^9, 3.821058550743508*^9}, {
   3.82105860888603*^9, 3.821058636238943*^9}, 3.821058700614352*^9, 
   3.8210588458924856`*^9, 3.821059072201398*^9, {3.8210734218271446`*^9, 
   3.821073432309046*^9}, {3.8210735542695475`*^9, 3.8210735580499363`*^9}, 
   3.821075553372513*^9, {3.8278746048380694`*^9, 3.8278746313943386`*^9}, {
   3.8287488220709143`*^9, 3.8287488345509357`*^9}, {3.828748874050205*^9, 
   3.828748885734626*^9}, 3.8287489282291*^9, {3.8287490792217655`*^9, 
   3.828749082482171*^9}, {3.828749113947427*^9, 3.8287491776111383`*^9}, {
   3.8287492167984076`*^9, 3.828749244972057*^9}, {3.82874927503331*^9, 
   3.8287493561846523`*^9}, {3.828749447297613*^9, 3.828749492709293*^9}, {
   3.828749552644598*^9, 3.828749603937488*^9}, {3.828749634763142*^9, 
   3.8287496378675475`*^9}, {3.828749731077711*^9, 3.8287497842426047`*^9}, 
   3.8287498785915704`*^9, 3.82946145141483*^9, {3.8294614834541597`*^9, 
   3.8294615297852592`*^9}, {3.829461680843571*^9, 3.829461692778242*^9}, {
   3.8294617356744547`*^9, 3.829461826918645*^9}, {3.8294620643473387`*^9, 
   3.8294621128359675`*^9}, 3.8294622108598495`*^9, {3.829462256864679*^9, 
   3.8294623300349975`*^9}, {3.829462366104672*^9, 3.8294623802107396`*^9}, {
   3.8294624538184395`*^9, 3.8294625116955137`*^9}, {3.829462551420568*^9, 
   3.829462562574212*^9}, {3.829462681671254*^9, 3.829462725301649*^9}, 
   3.829462763027173*^9, {3.8294628112033715`*^9, 3.8294628116720095`*^9}, {
   3.829462859067143*^9, 3.8294628790720625`*^9}, {3.829462929732047*^9, 
   3.8294629343715863`*^9}, {3.829462993092182*^9, 3.8294630007622566`*^9}, {
   3.8294636759476056`*^9, 3.829463682524181*^9}, {3.829463988916354*^9, 
   3.82946399285293*^9}, {3.8294641251812897`*^9, 3.829464185542125*^9}, {
   3.8294644575623865`*^9, 3.829464481572372*^9}, 3.8547421727696342`*^9, 
   3.854742229350079*^9, {3.854742268140275*^9, 3.854742273826438*^9}, {
   3.8547423452159033`*^9, 3.8547423636803102`*^9}, {3.854742395647602*^9, 
   3.854742452920491*^9}, {3.8547425604506865`*^9, 3.8547425607318735`*^9}, {
   3.8547425951645975`*^9, 3.854742660914789*^9}, {3.8547427079256783`*^9, 
   3.8547427440734277`*^9}, {3.8547427920152826`*^9, 3.854742795639428*^9}, {
   3.854742866079006*^9, 3.854742866282056*^9}, {3.854742908662737*^9, 
   3.854742936069667*^9}, {3.8547429676716113`*^9, 3.8547430039432487`*^9}, 
   3.854743039452135*^9, {3.854743162190482*^9, 3.8547432089175377`*^9}, 
   3.854743649769946*^9, {3.854743701533106*^9, 3.854743714998661*^9}, 
   3.8547437598356123`*^9, {3.854750271948118*^9, 3.854750383997134*^9}, 
   3.8547518341477346`*^9, 3.855089017803909*^9, 3.8806555907852793`*^9, 
   3.8806556592223673`*^9, {3.8806557940189486`*^9, 3.8806557996269817`*^9}, {
   3.880656454452241*^9, 3.8806565356832542`*^9}, {3.88065656958153*^9, 
   3.880656573877398*^9}, {3.8806566264273443`*^9, 3.8806566544988856`*^9}, {
   3.8806567631453204`*^9, 3.880656817288887*^9}, {3.880660812053049*^9, 
   3.8806608237065735`*^9}, {3.880660908624188*^9, 3.8806609760146465`*^9}, 
   3.880661033344963*^9, {3.8806610996673717`*^9, 3.88066111760067*^9}, 
   3.880661154748212*^9, {3.8806612011748405`*^9, 3.8806612510381603`*^9}, {
   3.880661500138209*^9, 3.8806615131664343`*^9}, {3.880661566060268*^9, 
   3.8806616509154277`*^9}, {3.883108994033066*^9, 3.8831089959857645`*^9}, {
   3.952878275699746*^9, 3.952878296788571*^9}, {3.9528783325146027`*^9, 
   3.95287841983799*^9}, {3.952878487353442*^9, 3.9528785816282997`*^9}, {
   3.952878615776575*^9, 3.9528786274769945`*^9}, {3.952878659532015*^9, 
   3.9528786851353846`*^9}, 3.952878715362693*^9, {3.952878775254991*^9, 
   3.9528787819253044`*^9}, {3.9528788175888195`*^9, 3.952878941575489*^9}, {
   3.9528790221035576`*^9, 3.9528791103329525`*^9}, {3.9528791420755725`*^9, 
   3.9528791962035275`*^9}, {3.9528796096010103`*^9, 
   3.9528796231447277`*^9}, {3.9528796571055317`*^9, 3.95287973063525*^9}, {
   3.9528798934097*^9, 3.952879895221816*^9}, {3.952879995057836*^9, 
   3.9528799999785643`*^9}, {3.952880096846595*^9, 3.95288012027863*^9}, {
   3.952880219800006*^9, 3.9528802326095204`*^9}, {3.952880307546419*^9, 
   3.9528803221212482`*^9}, {3.952880357909691*^9, 3.9528804437958436`*^9}, {
   3.952880498314397*^9, 3.9528805599874973`*^9}, {3.95288083001453*^9, 
   3.9528808436363497`*^9}, 3.952880903934797*^9, 3.952907746611789*^9, {
   3.9565179075303802`*^9, 3.9565179097798834`*^9}, {3.9565179572843657`*^9, 
   3.9565179664540825`*^9}, {3.956520285403778*^9, 3.956520319223996*^9}, 
   3.956520428874431*^9, {3.95652139761687*^9, 3.9565214557595115`*^9}, 
   3.9571402819329405`*^9, 3.9639882091510277`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0110.png\>\"", ",", "p3ConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, {3.669429968483719*^9, 3.6694299792009377`*^9}, 
   3.6695414937726173`*^9, {3.669541542304302*^9, 3.6695415424759026`*^9}, 
   3.6695427872984905`*^9, 3.669542874970644*^9, {3.6696138730631557`*^9, 
   3.6696138903791857`*^9}, {3.6696861629027576`*^9, 3.6696861631211576`*^9}, 
   3.6696862814941654`*^9, 3.66986256065805*^9, 3.6870392901593304`*^9, {
   3.687039490229682*^9, 3.687039497031294*^9}, {3.6870397058220606`*^9, 
   3.687039717615681*^9}, {3.7104498072224054`*^9, 3.7104498169568224`*^9}, 
   3.7104499946099343`*^9, 3.710450869621472*^9, {3.7119561182355337`*^9, 
   3.711956136471966*^9}, 3.711956221055314*^9, 3.7119582648253064`*^9, 
   3.7120398995014544`*^9, {3.712313120838914*^9, 3.7123131210417137`*^9}, {
   3.7326556355609922`*^9, 3.732655660770636*^9}, 3.732657635746906*^9, {
   3.7402166796299*^9, 3.7402167013763385`*^9}, {3.7407684545342298`*^9, 
   3.7407684753758664`*^9}, 3.7407758167939634`*^9, {3.7407763007692137`*^9, 
   3.7407763245436554`*^9}, {3.7407766041429462`*^9, 
   3.7407766173561697`*^9}, {3.7411134740028486`*^9, 
   3.7411134829104643`*^9}, {3.7414207980806737`*^9, 3.741420798283474*^9}, 
   3.744783897470586*^9, {3.7447936789552584`*^9, 3.744793682543265*^9}, 
   3.744852456774804*^9, 3.7448529884293385`*^9, {3.7452073885496655`*^9, 
   3.7452074029640903`*^9}, 3.7460552117927794`*^9, {3.7460559128736105`*^9, 
   3.7460559143244133`*^9}, {3.746991466930862*^9, 3.746991498240117*^9}, 
   3.7469916011066976`*^9, {3.747195658714813*^9, 3.747195677294446*^9}, 
   3.7471972139927454`*^9, 3.7472082014867215`*^9, {3.7472833609617367`*^9, 
   3.747283365080144*^9}, {3.7472973849875746`*^9, 3.7472973942695913`*^9}, 
   3.7482123299439473`*^9, {3.753848474247873*^9, 3.753848493326706*^9}, 
   3.791578362023325*^9, 3.7915787036456337`*^9, 3.791624068273596*^9, 
   3.800141896764979*^9, {3.800141936989874*^9, 3.80014194197311*^9}, {
   3.8001425509729953`*^9, 3.800142555253191*^9}, {3.8067020580603414`*^9, 
   3.8067020661834784`*^9}, {3.820712483499076*^9, 3.82071249135659*^9}, {
   3.827874604400671*^9, 3.8278746308475924`*^9}, 3.827874859224818*^9, {
   3.8482007476580734`*^9, 3.848200747798665*^9}, 3.848201100459812*^9, 
   3.8547404095981493`*^9, 3.854740446277025*^9, 3.883108226367322*^9, 
   3.8831082617339993`*^9, 3.8831144163403*^9, {3.9395727467455664`*^9, 
   3.9395727889387465`*^9}, {3.9395728835570545`*^9, 3.9395729099883156`*^9}, 
   3.939573183080165*^9, {3.956516691987017*^9, 3.9565167564250193`*^9}, {
   3.956517453683798*^9, 3.956517457229843*^9}, {3.956517534602311*^9, 
   3.956517541928712*^9}, {3.9565178871914463`*^9, 3.9565178971734724`*^9}, 
   3.957140284720487*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"conpConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", "250"}], ",", "ticksLeft", ",", "ticksRight", ",", 
      "ticksBottom", ",", "ticksTop"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ticksLeft", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksRight", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksBottom", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"#", "/", "2"}], "]"}], ",", "#", ",", "\"\<\>\""}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ticksTop", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", "\"\<\>\"", ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"IntegerQ", "[", 
                RowBox[{"#", "/", "2"}], "]"}], ",", "0.008", ",", "0.004"}], 
              "]"}], ",", "0"}], "}"}]}], "}"}], "&"}], ",", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{
         RowBox[{"-", "4.4"}], ",", "\[Gamma]", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Gamma]", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"-", "20"}], "]"}], ",", 
          RowBox[{"Sinh", "[", "20", "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"Contours", "\[Rule]", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sinh", "[", "#", "]"}], "&"}], ",", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "20"}], ",", "20", ",", "0.25"}], "]"}]}], "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"ContourStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.6"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0005", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", 
           RowBox[{"Rescale", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "p"}], ",", "p"}], "}"}]}], "]"}], "]"}], "&"}], 
         ")"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"ClippingStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "0", 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ColorData", "[", "\"\<Rainbow\>\"", "]"}], "[", "1", 
           "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Gamma]\>\"", ",", "\"\<x\>\""}], "}"}]}], ",", 
       RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontSize", "\[Rule]", "12"}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicksStyle", "\[Rule]", "8"}], ",", 
       RowBox[{"FrameStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.0009", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ticksLeft", ",", "ticksRight"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ticksBottom", ",", "ticksTop"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", 
           RowBox[{"0", ",", "0.15"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0002", "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\[Gamma]", ",", 
                 RowBox[{"-", "6"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\[Gamma]", ",", "6"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Gamma]", ",", 
               RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Line", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "6"}], ",", "x"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"6", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}], "]"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotRegion", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.015", ",", "0.98"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.01", ",", "0.985"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.956521596631053*^9, 3.956521614189432*^9}, {
   3.956521811897041*^9, 3.9565218174269924`*^9}, 3.9571402881323647`*^9, {
   3.9573394342726684`*^9, 3.9573394383810472`*^9}, 3.9639882124783683`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0120.png\>\"", ",", "conpConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.629172579079088*^9, 3.629172606332336*^9}, 
   3.6291729516077423`*^9, {3.6291769649291997`*^9, 3.6291769715436115`*^9}, {
   3.6694294146091456`*^9, 3.669429453390814*^9}, {3.6694295251133394`*^9, 
   3.66942952528494*^9}, 3.906596659531193*^9, {3.906598287112558*^9, 
   3.906598301937228*^9}, 3.906598717254052*^9, 3.9065990155121574`*^9, {
   3.906661029382049*^9, 3.9066610326781487`*^9}, 3.9102085302449045`*^9, {
   3.910208586721588*^9, 3.910208592173432*^9}, 3.910209252702484*^9, {
   3.9102093781574197`*^9, 3.9102093820940003`*^9}, {3.910209568801923*^9, 
   3.9102096039343557`*^9}, 3.9102097191138496`*^9, {3.9102118470896397`*^9, 
   3.9102119085127296`*^9}, {3.910211988290888*^9, 3.9102119987103558`*^9}, {
   3.9565173450374174`*^9, 3.9565173624395833`*^9}, {3.9565175017037773`*^9, 
   3.9565175064682846`*^9}, {3.9565175681413093`*^9, 
   3.9565175773422766`*^9}, {3.9565179817786174`*^9, 3.956517986090105*^9}, 
   3.957140291552244*^9},
 Background->RGBColor[
  0.9019607843137255, 0.9019607843137255, 0.9019607843137255]],

Cell[BoxData[
 RowBox[{"ap3dConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"AbsArgPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.1"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"-", "16"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0007", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0005", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.528619442909766*^9, 3.528619451910281*^9}, {
   3.5286214386949186`*^9, 3.5286214646354027`*^9}, {3.5286222532055063`*^9, 
   3.528622288166506*^9}, 3.52866506133381*^9, 3.5286651054974875`*^9, {
   3.5286651514707685`*^9, 3.528665155292775*^9}, {3.5287006732862062`*^9, 
   3.528700705625063*^9}, {3.5287008793313684`*^9, 3.5287008818741727`*^9}, {
   3.5287009125126266`*^9, 3.5287009144938297`*^9}, {3.5289198836377797`*^9, 
   3.5289199933371725`*^9}, {3.5289200401996546`*^9, 
   3.5289200576560855`*^9}, {3.5289201204305954`*^9, 
   3.5289201283242097`*^9}, {3.5289213102134857`*^9, 3.5289213711159925`*^9}, 
   3.5289214070272555`*^9, {3.52892258770053*^9, 3.528922633018609*^9}, {
   3.528922704669535*^9, 3.5289227124695487`*^9}, {3.5289237056920934`*^9, 
   3.528923718624516*^9}, 3.5289237912270436`*^9, {3.528923835453121*^9, 
   3.5289238359055223`*^9}, {3.52892390278284*^9, 3.5289239065580463`*^9}, 
   3.5289239438421116`*^9, {3.528923987787389*^9, 3.528924004978619*^9}, {
   3.5289240667547274`*^9, 3.528924087986365*^9}, {3.5289243401296077`*^9, 
   3.528924344294815*^9}, {3.5289245120575094`*^9, 3.5289245256919336`*^9}, {
   3.5289245779988256`*^9, 3.5289246058916745`*^9}, 3.5289246438465414`*^9, {
   3.5301781945730553`*^9, 3.530178289296421*^9}, {3.530178945963975*^9, 
   3.5301789486471796`*^9}, {3.5301820319841957`*^9, 3.530182109703532*^9}, {
   3.5339560194937434`*^9, 3.5339560600070143`*^9}, {3.5339561008634863`*^9, 
   3.53395611423271*^9}, {3.5339561603307905`*^9, 3.5339561646675987`*^9}, {
   3.5339561968816547`*^9, 3.533956209845278*^9}, {3.534022431253952*^9, 
   3.5340224314567523`*^9}, 3.534022572481*^9, {3.534022607705862*^9, 
   3.534022607924262*^9}, {3.5345620477651424`*^9, 3.5345620818512025`*^9}, {
   3.534562122941674*^9, 3.5345621667933517`*^9}, {3.534648397811719*^9, 
   3.534648401118925*^9}, {3.534709801160247*^9, 3.5347098283822947`*^9}, {
   3.5347098611891527`*^9, 3.5347098619223537`*^9}, {3.534709907926834*^9, 
   3.5347099086288357`*^9}, {3.534710222192987*^9, 3.5347102332066064`*^9}, 
   3.5347103216587615`*^9, {3.5347106722693777`*^9, 3.534710675982184*^9}, 
   3.5470089462373304`*^9, {3.5470091278996496`*^9, 3.5470091547472963`*^9}, {
   3.5470094371389923`*^9, 3.547009443207403*^9}, 3.547009595901272*^9, {
   3.547009818014462*^9, 3.5470098320856867`*^9}, {3.5470099040642133`*^9, 
   3.5470099184162383`*^9}, 3.5470100544952774`*^9, 3.547010367529028*^9, 
   3.550198810721326*^9, {3.550199038434926*^9, 3.550199045018138*^9}, {
   3.5501999115110607`*^9, 3.5501999141942654`*^9}, {3.55019997380197*^9, 
   3.55019997398917*^9}, 3.5502073133024054`*^9, 3.550207620982745*^9, {
   3.550207765158199*^9, 3.550207802863465*^9}, {3.55020859692346*^9, 
   3.550208598467862*^9}, {3.5502099531430416`*^9, 3.550209992720311*^9}, {
   3.550210137301365*^9, 3.550210139516569*^9}, {3.550210537442068*^9, 
   3.5502105388148704`*^9}, 3.550210684753127*^9, {3.553114489866292*^9, 
   3.5531145040935173`*^9}, 3.5531145564784093`*^9, 3.55311478447281*^9, {
   3.553114928071062*^9, 3.553114930255066*^9}, {3.5531151718526897`*^9, 
   3.5531152734400682`*^9}, {3.5531153988286963`*^9, 
   3.5531153999830985`*^9}, {3.5531841051629133`*^9, 3.5531841089225197`*^9}, 
   3.5531844703907547`*^9, {3.5531848141373587`*^9, 3.55318482037737*^9}, {
   3.564290330120206*^9, 3.564290330120206*^9}, {3.5642910712463074`*^9, 
   3.5642910895763397`*^9}, {3.5642912437514105`*^9, 3.564291261098641*^9}, {
   3.564291324902753*^9, 3.5642913279447584`*^9}, {3.564298881313227*^9, 
   3.564298910968879*^9}, 3.5645703399765744`*^9, {3.5645709011207676`*^9, 
   3.5645709125711875`*^9}, {3.5646321047687345`*^9, 
   3.5646321068747377`*^9}, {3.564706696754722*^9, 3.564706699547127*^9}, 
   3.5647067771728635`*^9, {3.564989627219633*^9, 3.564989637609251*^9}, 
   3.565030962442968*^9, {3.565152889292653*^9, 3.565152909557089*^9}, {
   3.565152945156351*^9, 3.565152963236783*^9}, 3.565153012439269*^9, 
   3.5651530922490096`*^9, {3.565162127699024*^9, 3.5651621308992076`*^9}, 
   3.565983845442522*^9, 3.56598387845218*^9, {3.5659904751889668`*^9, 
   3.5659904837065816`*^9}, 3.56599068772374*^9, 3.5659907302338142`*^9, {
   3.5659908215943756`*^9, 3.565990858936449*^9}, 3.5659913705393476`*^9, {
   3.566162100485265*^9, 3.566162102341668*^9}, {3.567196994409768*^9, 
   3.5671969959541707`*^9}, {3.567197054189073*^9, 3.567197061021885*^9}, {
   3.567197133858413*^9, 3.5671972115621495`*^9}, {3.5671973507731943`*^9, 
   3.5671973567168045`*^9}, {3.567197396247274*^9, 3.567197485604231*^9}, 
   3.5674580328183336`*^9, {3.567570200880618*^9, 3.5675702017074194`*^9}, {
   3.5675706469946012`*^9, 3.5675706511130085`*^9}, 3.5675897096419353`*^9, 
   3.5680246296369*^9, {3.568160274924254*^9, 3.568160309037122*^9}, {
   3.568160380558855*^9, 3.5681603947860794`*^9}, {3.568160466354613*^9, 
   3.5681604854178467`*^9}, 3.568160775578356*^9, {3.568160813751623*^9, 
   3.568160822394038*^9}, 3.570075555135485*^9, 3.570075606833976*^9, {
   3.570076573068473*^9, 3.5700766101497383`*^9}, {3.570086741011756*^9, 
   3.5700867466120763`*^9}, 3.570086991324073*^9, {3.570087119755419*^9, 
   3.570087155371456*^9}, {3.5700962095128574`*^9, 3.5700962258772864`*^9}, 
   3.5700962986358137`*^9, {3.570096349835104*^9, 3.570096368445937*^9}, 
   3.5700964717345185`*^9, 3.573604781666628*^9, 3.573604883878007*^9, 
   3.573604925826481*^9, {3.57360495952254*^9, 3.57360503919188*^9}, 
   3.573605070064334*^9, {3.573605328369588*^9, 3.573605331661194*^9}, 
   3.5736054416881866`*^9, {3.5736058843701644`*^9, 3.5736059731343203`*^9}, {
   3.5736060324456244`*^9, 3.5736060387012353`*^9}, 3.573606118386175*^9, 
   3.5736062033595247`*^9, 3.573606490725857*^9, {3.573692115976136*^9, 
   3.5736921224969473`*^9}, 3.574884949276402*^9, {3.574885006013702*^9, 
   3.574885007963705*^9}, {3.57577172896203*^9, 3.5757717849022293`*^9}, {
   3.575771839158333*^9, 3.5757719145096426`*^9}, {3.575772545302722*^9, 
   3.575772560950617*^9}, 3.5757894252461996`*^9, {3.575974174332202*^9, 
   3.5759741933330355`*^9}, {3.5767311834246573`*^9, 3.576731301158064*^9}, {
   3.576734520722247*^9, 3.5767345253398547`*^9}, {3.5767345693007317`*^9, 
   3.576734571297536*^9}, 3.5767349788482513`*^9, 3.5767427797108574`*^9, {
   3.5767839288211775`*^9, 3.5767839425180016`*^9}, 3.5767840176165333`*^9, {
   3.5767965812116947`*^9, 3.576796592521714*^9}, 3.577871510016669*^9, {
   3.57787163504882*^9, 3.577871661200316*^9}, {3.5778717168644996`*^9, 
   3.577871730870301*^9}, {3.577871778560028*^9, 3.577871806259613*^9}, 
   3.5778718509931717`*^9, {3.5778726345519886`*^9, 3.5778726367521143`*^9}, {
   3.5779963658724623`*^9, 3.577996367728865*^9}, 3.578002028108985*^9, 
   3.5921826867730446`*^9, 3.592182932910277*^9, {3.592182973563948*^9, 
   3.5921829890703754`*^9}, {3.5921894432385116`*^9, 3.59218944813692*^9}, 
   3.592189480928178*^9, 3.5921896208916235`*^9, {3.5921896765369215`*^9, 
   3.5921896875193405`*^9}, {3.592189778717101*^9, 3.592189837654004*^9}, 
   3.606352358951768*^9, {3.6063524969964104`*^9, 3.6063525015360184`*^9}, {
   3.6063526625511017`*^9, 3.6063527326732244`*^9}, {3.6063527650432816`*^9, 
   3.6063527755264997`*^9}, {3.606353335280284*^9, 3.6063533646707354`*^9}, 
   3.60635353794024*^9, 3.6063545635752487`*^9, {3.6063546892490697`*^9, 
   3.6063547050674973`*^9}, {3.6063552211473227`*^9, 3.606355223690127*^9}, {
   3.6063552577605867`*^9, 3.606355272190612*^9}, {3.6063553038430676`*^9, 
   3.606355338163128*^9}, {3.606355581851156*^9, 3.606355644547666*^9}, {
   3.60636212821593*^9, 3.6063621434727573`*^9}, {3.6063647301913004`*^9, 
   3.606364732328504*^9}, 3.606367653822036*^9, {3.606423653579423*^9, 
   3.606423662861439*^9}, 3.6064237042951117`*^9, 3.6064240186796646`*^9, 
   3.6064240824057765`*^9, 3.6064352530456715`*^9, 3.625306348124917*^9, {
   3.625306422349847*^9, 3.6253064464050894`*^9}, {3.625306510552402*^9, 
   3.625306553920478*^9}, {3.625306755270032*^9, 3.6253068394009795`*^9}, 
   3.625306876669445*^9, 3.625307106474249*^9, 3.6253080361026907`*^9, 
   3.6253565393719177`*^9, 3.6253833999639544`*^9, 3.6253834309924088`*^9, 
   3.6291871583501062`*^9, {3.6291872318262353`*^9, 3.629187239704249*^9}, {
   3.6291873056923647`*^9, 3.6291873143815804`*^9}, {3.6291875784324455`*^9, 
   3.6291876127525053`*^9}, {3.629189364101582*^9, 3.629189366394786*^9}, {
   3.629232868970395*^9, 3.629232869173195*^9}, 3.629412973595767*^9, {
   3.629681734167853*^9, 3.6296817892827497`*^9}, {3.6296820677432384`*^9, 
   3.6296821134157267`*^9}, {3.6296821492957897`*^9, 3.6296821592174067`*^9}, 
   3.6296822142855034`*^9, 3.6296823447797327`*^9, {3.6296823820481987`*^9, 
   3.6296823873678074`*^9}, 3.6296824244022727`*^9, {3.629682533259264*^9, 
   3.629682571479331*^9}, {3.6296864438997335`*^9, 3.6296864498121443`*^9}, 
   3.6301301056703367`*^9, 3.630186806038844*^9, {3.630187005195995*^9, 
   3.6301870543204813`*^9}, 3.630187116294997*^9, {3.6301872101759624`*^9, 
   3.630187240518016*^9}, {3.6301879818625174`*^9, 3.630188037336215*^9}, {
   3.6301880817139006`*^9, 3.6301881292739916`*^9}, {3.630192463897605*^9, 
   3.6301924663624096`*^9}, {3.6325489266416855`*^9, 3.6325489436145153`*^9}, 
   3.632549332330798*^9, {3.6325493823600864`*^9, 3.6325493932021055`*^9}, {
   3.632549475316257*^9, 3.632549494769491*^9}, 3.6325495787244463`*^9, {
   3.63254965087018*^9, 3.6325496533193846`*^9}, {3.632549689417848*^9, 
   3.632549695548659*^9}, {3.632549725609912*^9, 3.632549731350722*^9}, 
   3.632549777632004*^9, {3.6326038339351673`*^9, 3.6326038351987696`*^9}, 
   3.6326052431856437`*^9, 3.632605279237307*^9, {3.6327896696112256`*^9, 
   3.63278967761404*^9}, 3.632789733462138*^9, 3.632789829792307*^9, 
   3.632789870211978*^9, 3.632789986728583*^9, 3.632798118478204*^9, 
   3.632798253418441*^9, {3.632805774254259*^9, 3.6328057895110865`*^9}, {
   3.6328080477542534`*^9, 3.6328080865671215`*^9}, {3.632808253050614*^9, 
   3.6328082534094143`*^9}, {3.632808331378351*^9, 3.632808360269602*^9}, {
   3.632808538526723*^9, 3.6328085720043817`*^9}, {3.632808631050485*^9, 
   3.632808642282505*^9}, {3.632808677908575*^9, 3.6328087181990533`*^9}, {
   3.6328089591882763`*^9, 3.63280900082475*^9}, {3.6328090336628075`*^9, 
   3.632809129977377*^9}, 3.632809186913084*^9, {3.632809216974337*^9, 
   3.632809236926772*^9}, 3.6328094921744204`*^9, {3.6328628083886805`*^9, 
   3.6328628144414916`*^9}, 3.632862901630045*^9, 3.6345039446897955`*^9, 
   3.634504022565132*^9, {3.634504657689049*^9, 3.6345046727742753`*^9}, {
   3.634504709243346*^9, 3.6345047653410444`*^9}, {3.634504880625247*^9, 
   3.6345049408257523`*^9}, {3.6345049821346254`*^9, 3.63450498472423*^9}, {
   3.6345052382364817`*^9, 3.634505239952485*^9}, {3.6345553893336797`*^9, 
   3.6345554050117073`*^9}, 3.6345568508334475`*^9, {3.636074809678754*^9, 
   3.6360748135943604`*^9}, {3.6360753609197226`*^9, 3.636075371137741*^9}, {
   3.6360754445046697`*^9, 3.6360754448322706`*^9}, 3.6360754780759287`*^9, {
   3.6360755150323935`*^9, 3.636075526139613*^9}, 3.6364953410960603`*^9, 
   3.636495413464587*^9, 3.636495521806778*^9, 3.636495566391656*^9, 
   3.6364955986993127`*^9, 3.63649578354646*^9, {3.636496052943333*^9, 
   3.636496059417344*^9}, {3.636496089572198*^9, 3.6364960983862133`*^9}, 
   3.6364962814213343`*^9, {3.6364969368880863`*^9, 3.636496945000101*^9}, 
   3.7255922261262445`*^9, 3.7255924668034678`*^9, 3.7255925194379597`*^9, {
   3.725594490754224*^9, 3.7255945013310423`*^9}, 3.7255952592895737`*^9, 
   3.725595809710141*^9, 3.725595872032251*^9, 3.725596154470747*^9, 
   3.7255964263948245`*^9, 3.7255994902566366`*^9, 3.7256016031495495`*^9, 
   3.7256016803852854`*^9, {3.7257699711575327`*^9, 3.7257699995651827`*^9}, 
   3.7257711688340364`*^9, 3.7257741402492557`*^9, 3.7257744781258564`*^9, 
   3.7258490150765495`*^9, {3.725852074641125*^9, 3.725852075202726*^9}, 
   3.725852252840238*^9, 3.725852386626073*^9, {3.7258526579417496`*^9, 
   3.725852658565751*^9}, 3.7258527373146887`*^9, {3.7258528441436768`*^9, 
   3.7258528480904837`*^9}, 3.726913461460272*^9, {3.7269135066691513`*^9, 
   3.7269135066847515`*^9}, 3.7269135736244693`*^9, {3.7269141963775625`*^9, 
   3.726914207671983*^9}, 3.726914350100233*^9, {3.726914421298758*^9, 
   3.7269144217511587`*^9}, 3.7269145086589117`*^9, 3.7269146264547186`*^9, 
   3.7269147176680784`*^9, {3.726914927879649*^9, 3.7269149421848745`*^9}, {
   3.726942862934918*^9, 3.726942875820541*^9}, 3.7269430613360662`*^9, 
   3.7269527172550287`*^9, {3.732581313558529*^9, 3.732581414007105*^9}, {
   3.7326583984946456`*^9, 3.732658428493498*^9}, {3.732658557942526*^9, 
   3.732658586022575*^9}, {3.732659178499616*^9, 3.732659189263635*^9}, 
   3.732662539865631*^9, {3.7402178619119854`*^9, 3.740217868385997*^9}, {
   3.7402181435784817`*^9, 3.740218149693692*^9}, {3.740218205900591*^9, 
   3.7402182074137936`*^9}, {3.740218302823561*^9, 3.740218347018439*^9}, {
   3.740218658655794*^9, 3.7402186693574123`*^9}, {3.7402192940381107`*^9, 
   3.7402193007617226`*^9}, {3.740220269338224*^9, 3.7402202697282248`*^9}, {
   3.740220328462328*^9, 3.740220338337145*^9}, {3.74062349322491*^9, 
   3.7406234962357154`*^9}, {3.740778595583645*^9, 3.74077859848525*^9}, {
   3.740778651650143*^9, 3.7407786648009663`*^9}, {3.7407788761441393`*^9, 
   3.7407788989669795`*^9}, {3.740779013450781*^9, 3.740779023996399*^9}, {
   3.7407791542866287`*^9, 3.7407791747070646`*^9}, {3.740779219900344*^9, 
   3.740779220196744*^9}, {3.740779424588303*^9, 3.7407794273807077`*^9}, {
   3.7407794683775797`*^9, 3.7407794818404036`*^9}, {3.7407796849131613`*^9, 
   3.7407797216824255`*^9}, {3.7407798321070204`*^9, 3.7407798775031*^9}, {
   3.7407800627346253`*^9, 3.740780110221109*^9}, {3.740780271946593*^9, 
   3.7407802910098267`*^9}, 3.740780521968232*^9, {3.740780648765255*^9, 
   3.7407806521660604`*^9}, {3.740780740587016*^9, 3.7407807443622227`*^9}, {
   3.7407824497451477`*^9, 3.740782452974354*^9}, {3.740783174738423*^9, 
   3.740783181930035*^9}, 3.740784309105423*^9, 3.7407843782021475`*^9, 
   3.740784798230516*^9, 3.740792141493194*^9, {3.740795745950735*^9, 
   3.7407958089592457`*^9}, 3.7407962456820135`*^9, 3.740796278894471*^9, {
   3.7407966335298944`*^9, 3.740796667288354*^9}, {3.740796726833658*^9, 
   3.740796732012867*^9}, {3.7407968196070213`*^9, 3.740796823959429*^9}, {
   3.741114044270252*^9, 3.741114047499458*^9}, 3.741114172876878*^9, {
   3.741114214840952*^9, 3.7411142149657516`*^9}, {3.7411143056643114`*^9, 
   3.7411143086907167`*^9}, {3.7411143683764215`*^9, 
   3.7411143879700556`*^9}, {3.7411144249889207`*^9, 
   3.7411144431785526`*^9}, {3.7411667545006695`*^9, 3.741166765233488*^9}, 
   3.74189270181349*^9, 3.74466368597719*^9, 3.7446641759896507`*^9, 
   3.7446656127845235`*^9, 3.744665651924992*^9, 3.744742913131895*^9, {
   3.7447489853929644`*^9, 3.744748987545768*^9}, 3.744875554021535*^9, {
   3.7452126977581944`*^9, 3.7452126994273973`*^9}, {3.7452128151796007`*^9, 
   3.74521282638042*^9}, {3.7452129967795196`*^9, 3.745213042097599*^9}, {
   3.7452130797560654`*^9, 3.745213081565668*^9}, {3.7452131350581627`*^9, 
   3.74521318497825*^9}, {3.7452132378155427`*^9, 3.745213240966748*^9}, {
   3.7452136012649813`*^9, 3.745213631029834*^9}, {3.745213734582815*^9, 
   3.7452137373908205`*^9}, {3.7452153530628586`*^9, 3.7452153600672708`*^9}, 
   3.7452154080997553`*^9, {3.745215674051823*^9, 3.7452156741454234`*^9}, {
   3.7452158387569127`*^9, 3.745215838975313*^9}, {3.745216206574359*^9, 
   3.745216245761627*^9}, 3.745220787875206*^9, 3.746051986744711*^9, {
   3.7460521008589115`*^9, 3.746052131778166*^9}, {3.7460521666286273`*^9, 
   3.7460524545427327`*^9}, 3.746052540857684*^9, {3.746053417769227*^9, 
   3.7460534259280415`*^9}, 3.746054345117657*^9, 3.7460546304265585`*^9, {
   3.7460742014929237`*^9, 3.746074240758193*^9}, 3.746991621012333*^9, {
   3.746994997701064*^9, 3.746995027793517*^9}, {3.7469953201784315`*^9, 
   3.7469954400490417`*^9}, {3.7469954827307167`*^9, 3.74699550728516*^9}, 
   3.7469955396084166`*^9, {3.7470008008733025`*^9, 3.74700080527251*^9}, {
   3.7470008733666296`*^9, 3.747000875893834*^9}, {3.747000949837964*^9, 
   3.747000952287168*^9}, 3.7470264752655973`*^9, {3.747028003559884*^9, 
   3.7470280096126947`*^9}, {3.7481111476864767`*^9, 3.748111150276081*^9}, 
   3.748111262440278*^9, 3.7481114647570333`*^9, 3.7481114993578944`*^9, 
   3.7481117436231236`*^9, 3.7481117783019843`*^9, 3.7481118211240597`*^9, 
   3.7481119089054136`*^9, 3.748112016779603*^9, 3.7481126540251226`*^9, {
   3.748112759746508*^9, 3.7481127604173093`*^9}, {3.748112809635396*^9, 
   3.748112816156207*^9}, {3.748112846591861*^9, 3.7481128812083216`*^9}, 
   3.7481129454960346`*^9, 3.748113095849098*^9, 3.7481148409525647`*^9, 
   3.7481523665185213`*^9, 3.749668417688261*^9, 3.7507168750970583`*^9, {
   3.7507169896168594`*^9, 3.750716992861665*^9}, {3.750717108551468*^9, 
   3.7507172392640977`*^9}, {3.7507172898861866`*^9, 3.75071732030624*^9}, {
   3.750717367402723*^9, 3.7507173891803613`*^9}, {3.7507175430902314`*^9, 
   3.750717551592246*^9}, {3.750717698907706*^9, 3.7507177368313723`*^9}, {
   3.750717804535491*^9, 3.7507178507895727`*^9}, {3.750717899056057*^9, 
   3.750717922424898*^9}, {3.750718034791896*^9, 3.7507180483015194`*^9}, {
   3.7507198746355276`*^9, 3.7507198747915277`*^9}, 3.7507206603917084`*^9, 
   3.750743995100903*^9, {3.750744115267914*^9, 3.7507441173583174`*^9}, 
   3.751183154782548*^9, 3.7511832007870283`*^9, 3.7511889477875257`*^9, 
   3.7511898686887436`*^9, {3.751190067027492*^9, 3.751190067214692*^9}, {
   3.7511904339557366`*^9, 3.7511904342209373`*^9}, 3.751343678313509*^9, {
   3.751343737328412*^9, 3.7513437454248266`*^9}, {3.7513439903028574`*^9, 
   3.7513440021900787`*^9}, 3.7513440559165726`*^9, {3.751344356866702*^9, 
   3.751344358754305*^9}, {3.7513453951733255`*^9, 3.7513454022313385`*^9}, 
   3.751345479623074*^9, 3.751345663578597*^9, 3.7513458060536475`*^9, {
   3.7513462322931957`*^9, 3.751346244788818*^9}, 3.751347972101852*^9, {
   3.7513564574799557`*^9, 3.751356461379963*^9}, 3.7513572038244677`*^9, 
   3.7550499818675575`*^9, 3.755050081270932*^9, 3.755050162094674*^9, {
   3.7550503792938557`*^9, 3.755050383552663*^9}, {3.755050657769945*^9, 
   3.7550507162700477`*^9}, 3.7550507776249557`*^9, {3.7550508327710524`*^9, 
   3.7550509174012012`*^9}, {3.75506116943268*^9, 3.75506120939995*^9}, 
   3.755061263641245*^9, {3.755061304045316*^9, 3.755061332296966*^9}, {
   3.791837454079505*^9, 3.7918374672326627`*^9}, {3.7918375293898745`*^9, 
   3.791837639613963*^9}, {3.7918376716532726`*^9, 3.7918377406682825`*^9}, {
   3.7918378367550473`*^9, 3.7918378492208977`*^9}, {3.791837885353021*^9, 
   3.791837927093199*^9}, {3.7918379571642485`*^9, 3.791837983314344*^9}, {
   3.7918382715699883`*^9, 3.791838307577134*^9}, {3.791838449356269*^9, 
   3.7918384679143763`*^9}, {3.791838600615634*^9, 3.7918386391222763`*^9}, {
   3.7918387136916265`*^9, 3.791838717518922*^9}, {3.7918387964402494`*^9, 
   3.7918388962605457`*^9}, {3.7918390063752236`*^9, 3.791839009499524*^9}, {
   3.7918390718129854`*^9, 3.791839081279473*^9}, 3.791926694308837*^9, {
   3.7919269047590957`*^9, 3.7919269312528725`*^9}, {3.791941159803388*^9, 
   3.791941185000529*^9}, {3.7919414976767054`*^9, 3.7919415013477135`*^9}, {
   3.7919418976905293`*^9, 3.7919419070633483`*^9}, {3.79194194144582*^9, 
   3.7919419457417145`*^9}, {3.791944532323326*^9, 3.7919445402901945`*^9}, 
   3.791945575110017*^9, {3.7919456228331137`*^9, 3.7919456251919384`*^9}, {
   3.7919457477646008`*^9, 3.791945947970544*^9}, {3.7919459941783795`*^9, 
   3.7919459979274817`*^9}, 3.791946210705377*^9, 3.791947743925529*^9, {
   3.792142687080438*^9, 3.7921427322260327`*^9}, {3.7921428660273533`*^9, 
   3.792142869089161*^9}, {3.792142945399186*^9, 3.7921429898730664`*^9}, {
   3.7921430613873816`*^9, 3.792143077961583*^9}, {3.7921431184519978`*^9, 
   3.7921431238725896`*^9}, 3.792143155349477*^9, 3.792143211601818*^9, {
   3.7921432698380313`*^9, 3.7921432757897153`*^9}, 3.7921434567671947`*^9, 
   3.792144982440548*^9, 3.7921450272892933`*^9, {3.792145072528581*^9, 
   3.792145079042717*^9}, 3.79214511625261*^9, 3.792145176425829*^9, {
   3.792145498912012*^9, 3.792145499115088*^9}, 3.792145594592448*^9, {
   3.7921456423624225`*^9, 3.7921456449087653`*^9}, {3.792184449093946*^9, 
   3.792184475478321*^9}, {3.792184553584795*^9, 3.792184576954283*^9}, 
   3.79218461517962*^9, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, {
   3.792206718240422*^9, 3.792206731424799*^9}, 3.792206845007283*^9, {
   3.7922070074375753`*^9, 3.7922070321039267`*^9}, 3.7922073048830905`*^9, {
   3.792207471952895*^9, 3.7922074981029654`*^9}, 3.792207861765847*^9, {
   3.7922106379018235`*^9, 3.7922106451501083`*^9}, {3.792270597712449*^9, 
   3.792270597712449*^9}, {3.792270891033639*^9, 3.7922708912054386`*^9}, 
   3.7922709722175446`*^9, 3.792271039389139*^9, 3.792271363687356*^9, {
   3.792272235885374*^9, 3.792272236072836*^9}, {3.7922725073824296`*^9, 
   3.7922725105379333`*^9}, {3.7922725499817567`*^9, 3.792272575631919*^9}, {
   3.7923819877656794`*^9, 3.7923819927489023`*^9}, 3.7925386565345564`*^9, {
   3.7925388649840345`*^9, 3.7925389122384624`*^9}, {3.792538977710556*^9, 
   3.7925389836310034`*^9}, 3.792539073871907*^9, 3.792539144948824*^9, 
   3.7925391995140295`*^9, {3.7925392495646725`*^9, 3.7925392522827845`*^9}, {
   3.792553223558854*^9, 3.792553236758835*^9}, 3.7925532712350616`*^9, 
   3.792553308132576*^9, {3.7925533452331324`*^9, 3.7925534413978987`*^9}, {
   3.792553882028*^9, 3.7925538868705435`*^9}, 3.792554765327935*^9, 
   3.7926557610118475`*^9, {3.8025467409044847`*^9, 3.802546764242728*^9}, 
   3.802547143215903*^9, {3.8025527321047087`*^9, 3.8025527867480636`*^9}, 
   3.802552818615567*^9, {3.8025528666667347`*^9, 3.802552957988966*^9}, 
   3.802553005837062*^9, 3.802553077929443*^9, {3.8025798749373145`*^9, 
   3.8025798774367256`*^9}, 3.8025799386730447`*^9, {3.8025800226579857`*^9, 
   3.8025800228142033`*^9}, 3.802585141722986*^9, 3.8078545320706625`*^9, {
   3.8078546051822667`*^9, 3.8078546730877852`*^9}, {3.8078547090317235`*^9, 
   3.8078547719695177`*^9}, 3.8078548203562016`*^9, 3.8078549040505514`*^9, {
   3.807855037674405*^9, 3.807855037962635*^9}, 3.816906009920802*^9, {
   3.8169060910892124`*^9, 3.8169061174267793`*^9}, {3.8169061971268187`*^9, 
   3.81690620022064*^9}, {3.8169062907775416`*^9, 3.8169063139595995`*^9}, {
   3.816906347529848*^9, 3.816906358371046*^9}, {3.8169064463660016`*^9, 
   3.8169064751248894`*^9}, {3.8169065717896967`*^9, 
   3.8169065738517113`*^9}, {3.8169066667673993`*^9, 3.816906727987401*^9}, 
   3.816906887955981*^9, {3.8169072179264603`*^9, 3.816907218176386*^9}, {
   3.8208064885993166`*^9, 3.820806493191882*^9}, {3.820806571985753*^9, 
   3.820806591262437*^9}, {3.820806643218884*^9, 3.820806644468581*^9}, {
   3.820806710234253*^9, 3.8208067108747253`*^9}, 3.820806825550688*^9, 
   3.820806870305712*^9, {3.8208070329068413`*^9, 3.8208070358748503`*^9}, 
   3.8208071291340075`*^9, {3.827874604478779*^9, 3.8278746309413214`*^9}, {
   3.828285976508387*^9, 3.8282860378689904`*^9}, {3.828286069189767*^9, 
   3.8282860750946317`*^9}, {3.8282862454440393`*^9, 3.828286274874611*^9}, 
   3.8282864569082403`*^9, 3.8282865303597565`*^9, {3.828288390273615*^9, 
   3.8282884014897327`*^9}, 3.8286362223683195`*^9, 3.8288490034020543`*^9, {
   3.8482570386076126`*^9, 3.8482570386232243`*^9}, {3.8482571403492136`*^9, 
   3.8482571748254557`*^9}, 3.8482572580401783`*^9, {3.8482592159992356`*^9, 
   3.8482592163897705`*^9}, 3.8482592584954834`*^9, 3.848259312904552*^9, {
   3.848259470368842*^9, 3.8482594998619113`*^9}, {3.8482597067661886`*^9, 
   3.848259717341818*^9}, {3.8482598723142166`*^9, 3.848259905868791*^9}, {
   3.8482604837349753`*^9, 3.8482604978097763`*^9}, {3.8547617638223734`*^9, 
   3.8547617638379946`*^9}, {3.8547617944089394`*^9, 3.8547617956430206`*^9}, 
   3.8547619113724337`*^9, {3.854762164384845*^9, 3.8547621866921015`*^9}, 
   3.8549110836125603`*^9, 3.8831684291204414`*^9, 3.8831685486083903`*^9, 
   3.883168591770075*^9, 3.8831689414842877`*^9, 3.8831690014857616`*^9, 
   3.8831706667954407`*^9, 3.8831708703093653`*^9, 3.956529049280467*^9, 
   3.9565290970348783`*^9, {3.9565292776866674`*^9, 3.9565293066954803`*^9}, {
   3.9565293420934258`*^9, 3.9565293429526005`*^9}, {3.9565293996423855`*^9, 
   3.9565294227776165`*^9}, 3.956529535867911*^9, 3.956529572578045*^9, {
   3.9565296812237678`*^9, 3.9565296814268775`*^9}, {3.956530125035204*^9, 
   3.9565301364388113`*^9}, 3.956530440138101*^9, 3.9565415554720664`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0130.png\>\"", ",", "ap3dConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955147213811*^9, 3.533955206041514*^9, 3.5470088906700325`*^9, 
   3.5470089487489347`*^9, {3.5501987437036085`*^9, 3.5501987438440084`*^9}, 
   3.550198813591731*^9, {3.5504692939604816`*^9, 3.550469294069682*^9}, 
   3.553114267872302*^9, 3.5531143193679924`*^9, 3.5531145595360146`*^9, 
   3.5531850944854507`*^9, {3.5531852419837103`*^9, 3.5531852422489104`*^9}, 
   3.5531900792725277`*^9, 3.5531901503774524`*^9, 3.55319089444716*^9, 
   3.553190949265656*^9, {3.55321378571439*^9, 3.5532137858547897`*^9}, 
   3.553213822249654*^9, {3.5532141187749743`*^9, 3.553214146340223*^9}, {
   3.5563895716216006`*^9, 3.556389571762001*^9}, 3.5563898724213285`*^9, {
   3.7325812172595596`*^9, 3.7325812177743607`*^9}, 3.7326535308532934`*^9, {
   3.732659113743902*^9, 3.732659113899903*^9}, 3.732659206220865*^9, 
   3.740216750922025*^9, 3.7402182214850187`*^9, 3.740218987201172*^9, 
   3.740778600201253*^9, {3.740780597784365*^9, 3.740780598018366*^9}, 
   3.7407822969116793`*^9, {3.7407956919590406`*^9, 3.740795692161841*^9}, 
   3.7407957432831306`*^9, 3.741114049309061*^9, {3.7411141070915623`*^9, 
   3.7411141072631626`*^9}, 3.741166751692664*^9, 3.7411668366036134`*^9, {
   3.741421168425725*^9, 3.7414211686285257`*^9}, 3.7446636889255953`*^9, 
   3.744664374468799*^9, 3.7446656127845235`*^9, {3.7446659070166407`*^9, 
   3.7446659071882405`*^9}, 3.7452127094426146`*^9, {3.7452127690503197`*^9, 
   3.7452127718427243`*^9}, 3.745215203949396*^9, 3.745215406290152*^9, 
   3.746051989225116*^9, {3.746052022125573*^9, 3.7460520228275747`*^9}, 
   3.746055103278989*^9, 3.746991472593672*^9, 3.7469915089417357`*^9, 
   3.7469915389717884`*^9, 3.746991632774753*^9, 3.748111159012097*^9, {
   3.7481113177579756`*^9, 3.748111317945176*^9}, 3.7481126514667177`*^9, {
   3.748113195470874*^9, 3.748113195689274*^9}, {3.7507167568800507`*^9, 
   3.7507167594852552`*^9}, 3.7507168842542744`*^9, {3.750907902190365*^9, 
   3.750907924545204*^9}, 3.7509082695866103`*^9, 3.7513500248866577`*^9, 
   3.7513500919979753`*^9, {3.7513503196023755`*^9, 3.7513503197739754`*^9}, {
   3.7550497169166927`*^9, 3.7550497426723375`*^9}, 3.7550499818831577`*^9, {
   3.791837399326764*^9, 3.791837403919399*^9}, 3.7918374397704163`*^9, 
   3.7919411562417016`*^9, 3.7919412497352705`*^9, 3.7919455775000772`*^9, 
   3.79194561547548*^9, 3.7921427775170593`*^9, {3.7921442289360805`*^9, 
   3.7921442290922937`*^9}, 3.792144984877466*^9, {3.79214503848981*^9, 
   3.7921450386459846`*^9}, 3.7922066272150636`*^9, {3.7922081247973256`*^9, 
   3.792208125375308*^9}, 3.792270597728077*^9, {3.792270704359085*^9, 
   3.792270704452841*^9}, 3.792538656550113*^9, {3.7925539995157557`*^9, 
   3.7925540001562295`*^9}, 3.8025468009840703`*^9, {3.802546874435505*^9, 
   3.8025468749822507`*^9}, 3.8025469230959077`*^9, 3.8025516256547904`*^9, {
   3.8025798621278696`*^9, 3.802579872625392*^9}, {3.807854454103038*^9, 
   3.807854466154855*^9}, 3.807854538815669*^9, 3.8169060154038906`*^9, {
   3.81690681059914*^9, 3.8169068368429813`*^9}, {3.8208063901537895`*^9, 
   3.820806402244675*^9}, 3.820806503673809*^9, {3.827874604494393*^9, 
   3.8278746309413214`*^9}, {3.8278748592560916`*^9, 3.8278748863590775`*^9}, 
   3.82828663244518*^9, 3.8482570386232243`*^9, {3.8482570745991116`*^9, 
   3.848257085752733*^9}, 3.8547617638536158`*^9, {3.854761829152297*^9, 
   3.854761851225196*^9}, {3.883168591785688*^9, 3.883168637915431*^9}, 
   3.9565290755867867`*^9, {3.9565292024699354`*^9, 3.9565292106242757`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"adpConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"ArgDensityPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "0.1"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "16"}], ",", "22"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.732482892728856*^9, 3.7324829563457675`*^9}, {
   3.7324830851923943`*^9, 3.7324830882811995`*^9}, {3.732483262424306*^9, 
   3.732483272377123*^9}, 3.7326584415195208`*^9, {3.7326584750439796`*^9, 
   3.7326584764479823`*^9}, 3.732658701981179*^9, {3.732658872349078*^9, 
   3.732658872567479*^9}, 3.7326592186228867`*^9, 3.7326593083866453`*^9, 
   3.7326626660310535`*^9, {3.740218157446906*^9, 3.740218181533348*^9}, 
   3.7402182257126255`*^9, 3.7402183634452677`*^9, {3.740218493186303*^9, 
   3.7402184934047036`*^9}, 3.740218637580157*^9, {3.7402186807610326`*^9, 
   3.7402186901834493`*^9}, 3.740219272556873*^9, 3.7406235115861425`*^9, {
   3.740778603524059*^9, 3.740778607080865*^9}, {3.740778656564152*^9, 
   3.740778658529755*^9}, {3.740778688559808*^9, 3.7407786898078103`*^9}, {
   3.7407792259843545`*^9, 3.7407792441895866`*^9}, {3.7407793822810287`*^9, 
   3.740779417427891*^9}, {3.7407794646959734`*^9, 3.7407794857872105`*^9}, 
   3.740780774189475*^9, 3.7407824622407703`*^9, {3.740783008707331*^9, 
   3.7407830693134375`*^9}, 3.7407921769832563`*^9, 3.740795739929125*^9, 
   3.740795830549684*^9, {3.741114053755069*^9, 3.741114056173073*^9}, 
   3.741114177042085*^9, {3.741114217851757*^9, 3.7411142179765573`*^9}, 
   3.741114298004698*^9, 3.7411143910588613`*^9, {3.7411144222121162`*^9, 
   3.741114422383716*^9}, 3.7411667475274568`*^9, 3.741166782284318*^9, 
   3.741202200838129*^9, 3.7418928330565205`*^9, 3.744663694463605*^9, 
   3.7446641788132553`*^9, 3.7446656127845235`*^9, 3.7446656519405923`*^9, 
   3.744742916766701*^9, 3.7447489900885725`*^9, 3.745212714450224*^9, {
   3.7452134334710865`*^9, 3.745213472377555*^9}, {3.74521352657205*^9, 
   3.7452135499564915`*^9}, {3.745213645116658*^9, 3.74521367446031*^9}, 
   3.7452137501360426`*^9, 3.745215372484893*^9, 3.745215403544547*^9, {
   3.745215676563428*^9, 3.745215676657028*^9}, {3.745215841159317*^9, 
   3.7452158501293325`*^9}, 3.745220796377221*^9, 3.746051992891122*^9, {
   3.7460525179568443`*^9, 3.746052527363661*^9}, {3.7460525613717203`*^9, 
   3.7460526080470023`*^9}, {3.746052647827072*^9, 3.746052665392703*^9}, 
   3.7460527306476173`*^9, {3.7460534548348923`*^9, 3.746053478047733*^9}, {
   3.7460536390400157`*^9, 3.7460536607708535`*^9}, {3.7460537995066986`*^9, 
   3.7460538460103807`*^9}, 3.746054532895187*^9, 3.7460546210509415`*^9, {
   3.746055005030016*^9, 3.7460550460736885`*^9}, 3.7460615185886574`*^9, {
   3.746069839136873*^9, 3.7460698629425144`*^9}, {3.746073417607147*^9, 
   3.7460734321307726`*^9}, 3.7460741921641073`*^9, 3.7469916409491673`*^9, {
   3.7469955617292557`*^9, 3.746995578218485*^9}, 3.7469956382941904`*^9, {
   3.7469959147934766`*^9, 3.746995920768287*^9}, {3.7469959729191785`*^9, 
   3.746995986631603*^9}, 3.746998736928876*^9, 3.746999808962759*^9, 
   3.747000762809235*^9, {3.7470280162427063`*^9, 3.7470280188011107`*^9}, 
   3.7481111741597233`*^9, 3.74811125768227*^9, {3.7481113758212776`*^9, 
   3.748111454039815*^9}, 3.7481116828922167`*^9, 3.74811178123479*^9, 
   3.7481120097751913`*^9, 3.7481126483779125`*^9, 3.7481127678585224`*^9, 
   3.7481129482884398`*^9, 3.748113174738437*^9, {3.748114852964586*^9, 
   3.7481148546805887`*^9}, 3.7481523715885305`*^9, 3.748156676743692*^9, 
   3.7496684226178694`*^9, 3.7507168950182934`*^9, 3.7507174232196207`*^9, 
   3.7507179880698137`*^9, 3.7507180637455463`*^9, {3.750718172664938*^9, 
   3.7507181919309716`*^9}, {3.750718281381529*^9, 3.7507183044383693`*^9}, {
   3.7507198773499327`*^9, 3.7507198774903326`*^9}, 3.750720697925374*^9, 
   3.7507439988761096`*^9, {3.750744109105903*^9, 3.7507441115707073`*^9}, 
   3.75090826960221*^9, 3.750908324873107*^9, 3.750911281940936*^9, 
   3.7509118911532063`*^9, 3.7509120959347663`*^9, {3.750923612368995*^9, 
   3.750923612524996*^9}, {3.7509248608167896`*^9, 3.750924875777216*^9}, {
   3.7509256243805313`*^9, 3.750925624567732*^9}, 3.7513499450613174`*^9, 
   3.751350024902258*^9, 3.751350205378975*^9, {3.7513571187651176`*^9, 
   3.751357119545119*^9}, 3.751357214526087*^9, {3.7513577496226263`*^9, 
   3.7513577498410273`*^9}, {3.751405366281531*^9, 3.751405378480752*^9}, {
   3.7514055458066463`*^9, 3.751405557849867*^9}, {3.751405638626809*^9, 
   3.7514056388764095`*^9}, 3.755049981945558*^9, 3.755050081707733*^9, 
   3.7550501621258745`*^9, {3.755050400759494*^9, 3.7550504035050983`*^9}, 
   3.7550509310980253`*^9, {3.7550512422873716`*^9, 3.7550512668106146`*^9}, {
   3.755051312409495*^9, 3.755051312877496*^9}, {3.755051771595695*^9, 
   3.755051771751695*^9}, {3.7550518885491004`*^9, 3.7550519085639353`*^9}, 
   3.7551379658536453`*^9, {3.755138016132534*^9, 3.755138075287838*^9}, {
   3.7551381761264153`*^9, 3.755138212599279*^9}, {3.75513827588859*^9, 
   3.755138303656639*^9}, {3.7551383744339633`*^9, 3.7551383747147636`*^9}, {
   3.755138574254714*^9, 3.75513859464395*^9}, 3.755138673611289*^9, {
   3.755139946626726*^9, 3.7551399654559593`*^9}, {3.7551413576185923`*^9, 
   3.755141379583431*^9}, 3.7551422855775647`*^9, {3.7551424248350105`*^9, 
   3.7551424403258376`*^9}, 3.7551475815781126`*^9, 3.7552236306473618`*^9, 
   3.7552237351007524`*^9, 3.7552257200630403`*^9, {3.755227559021696*^9, 
   3.755227559177696*^9}, {3.755227954092391*^9, 3.7552279570407963`*^9}, 
   3.7642903613991814`*^9, {3.7642905329386835`*^9, 3.7642905870551786`*^9}, 
   3.7642906182396336`*^9, {3.764290672449729*^9, 3.7642906894693584`*^9}, 
   3.764290721075014*^9, {3.76429075314867*^9, 3.764290753289071*^9}, {
   3.7642908794620924`*^9, 3.7642908959981213`*^9}, 3.764291593614951*^9, 
   3.76429466703955*^9, 3.7643042218683386`*^9, 3.764315617343957*^9, 
   3.76431783317605*^9, 3.7643199388461533`*^9, 3.7643853579378877`*^9, 
   3.764664382553267*^9, 3.7646644254065423`*^9, {3.7646670199227085`*^9, 
   3.7646670350235357`*^9}, {3.7646689626829224`*^9, 3.7646689628545227`*^9}, 
   3.764887973228504*^9, 3.764888008734166*^9, 3.7648888932053223`*^9, {
   3.7648903774637313`*^9, 3.764890377635331*^9}, 3.7648904488962564`*^9, 
   3.764890628343372*^9, {3.7648920077004867`*^9, 3.764892008121687*^9}, 
   3.764892076278207*^9, {3.7649026437276335`*^9, 3.7649026438212337`*^9}, 
   3.76506077650143*^9, 3.765170874625887*^9, 3.7651709275099792`*^9, 
   3.7651715756087255`*^9, 3.765171666619285*^9, 3.7651717371314087`*^9, 
   3.765171875909253*^9, 3.7652588601167355`*^9, 3.7652589118932266`*^9, {
   3.765267833767707*^9, 3.7652678340173073`*^9}, 3.766219677016867*^9, 
   3.766219733629367*^9, 3.7662201958113785`*^9, {3.7662231334417396`*^9, 
   3.7662231361717443`*^9}, 3.7662232485855417`*^9, {3.766426144952866*^9, 
   3.766426157042887*^9}, {3.76647719987669*^9, 3.7664772214515276`*^9}, {
   3.7664774867767935`*^9, 3.7664775002396173`*^9}, {3.7688458990076995`*^9, 
   3.7688459132037244`*^9}, 3.7688464394654493`*^9, 3.7688469041774664`*^9, 
   3.791925257427122*^9, 3.791925346562312*^9, {3.791925415077385*^9, 
   3.791925432292034*^9}, {3.79192558767724*^9, 3.7919255902703776`*^9}, {
   3.7919257453302054`*^9, 3.791925757202401*^9}, {3.791925937519228*^9, 
   3.7919259408152847`*^9}, {3.7919259926311307`*^9, 3.791925997395666*^9}, 
   3.791926263855747*^9, {3.7919264890844517`*^9, 3.791926490037352*^9}, 
   3.791927284210745*^9, 3.7919411532580585`*^9, 3.791941223803928*^9, {
   3.7919415060341063`*^9, 3.7919415061903205`*^9}, 3.7919455800307994`*^9, 
   3.7919456362986813`*^9, {3.791945689832918*^9, 3.7919457217551537`*^9}, 
   3.7919460775336857`*^9, 3.7919462165008616`*^9, {3.7919462528203726`*^9, 
   3.7919462530703335`*^9}, 3.7921427775170593`*^9, 3.7921428783057747`*^9, {
   3.792143003807266*^9, 3.7921430251928267`*^9}, 3.792143064074258*^9, {
   3.7921431277154303`*^9, 3.792143128543357*^9}, {3.7921434609849415`*^9, 
   3.79214346590565*^9}, 3.7921449885797224`*^9, 3.792145025274151*^9, {
   3.7921450954762783`*^9, 3.7921451181897235`*^9}, {3.7921455056604123`*^9, 
   3.7921455095657372`*^9}, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, 
   3.7922067460150957`*^9, 3.7922068475379333`*^9, {3.792207866280402*^9, 
   3.792207873684909*^9}, {3.792270597728077*^9, 3.792270597728077*^9}, {
   3.792270895657544*^9, 3.792270895782504*^9}, {3.792271368045697*^9, 
   3.7922713738255787`*^9}, {3.7922722199672675`*^9, 3.792272227824782*^9}, 
   3.792538656565729*^9, 3.792538924313737*^9, {3.792538977710556*^9, 
   3.7925389876925745`*^9}, 3.792539078730129*^9, 3.7925391498539133`*^9, {
   3.7925532490372567`*^9, 3.792553269157399*^9}, {3.7925536620956464`*^9, 
   3.792553667672454*^9}, 3.7925537022735977`*^9, {3.792553890557179*^9, 
   3.7925538937751665`*^9}, {3.7925546404577494`*^9, 3.7925546465187893`*^9}, 
   3.7925547575953875`*^9, 3.7926551481604743`*^9, 3.802546774584007*^9, 
   3.802546806014125*^9, {3.8025471515108232`*^9, 3.802547153432208*^9}, {
   3.8025530095393133`*^9, 3.802553026457199*^9}, {3.8025532045714674`*^9, 
   3.802553229409363*^9}, 3.802553261038468*^9, 3.802553454664689*^9, {
   3.8025798431792006`*^9, 3.8025798457723475`*^9}, {3.8025800272037663`*^9, 
   3.802580027344387*^9}, {3.802582660552966*^9, 3.8025826638022027`*^9}, 
   3.8078545445533037`*^9, 3.8078546876419163`*^9, {3.807854721465523*^9, 
   3.8078547489939494`*^9}, 3.8078547791373887`*^9, {3.807855042242198*^9, 
   3.8078550464639173`*^9}, 3.816906024932904*^9, 3.816906211796054*^9, {
   3.8169062938236933`*^9, 3.816906310679119*^9}, 3.8169063942376285`*^9, 
   3.8169064881374598`*^9, 3.816906605547397*^9, {3.81690722223795*^9, 
   3.81690722739299*^9}, {3.816911790459921*^9, 3.816911790662994*^9}, {
   3.8208065113126163`*^9, 3.820806513952616*^9}, 3.8208066006040044`*^9, {
   3.8208066387668133`*^9, 3.820806640141487*^9}, {3.8208067180917654`*^9, 
   3.82080671859165*^9}, {3.8208068079142385`*^9, 3.820806816990216*^9}, 
   3.820807138147498*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.828286123457013*^9, {3.8282861747106113`*^9, 3.8282861989236813`*^9}, {
   3.828286440365247*^9, 3.8282864529248*^9}, {3.828553556846962*^9, 
   3.828553562587772*^9}, {3.828557128894436*^9, 3.8285571389096537`*^9}, {
   3.8285573314607916`*^9, 3.8285573321159925`*^9}, 3.828557376529271*^9, {
   3.8286360368995934`*^9, 3.828636050206417*^9}, 3.8286362099974976`*^9, 
   3.8286376533312335`*^9, 3.828718698781597*^9, {3.848257038638844*^9, 
   3.848257038638844*^9}, {3.8482571592822495`*^9, 3.8482571791525536`*^9}, 
   3.8482592259343624`*^9, {3.848259521700473*^9, 3.8482595244186172`*^9}, 
   3.848259575968937*^9, {3.848259744967764*^9, 3.848259748545044*^9}, {
   3.848259837688095*^9, 3.848259841812119*^9}, 3.848260108181464*^9, {
   3.8547617638692365`*^9, 3.8547617638848314`*^9}, 3.854761804515937*^9, 
   3.854761915152796*^9, {3.854762106815795*^9, 3.854762106987621*^9}, {
   3.8547621715706553`*^9, 3.854762191347271*^9}, {3.854762692983657*^9, 
   3.8547626933116884`*^9}, 3.8549110693034267`*^9, 3.883168548842718*^9, 
   3.883168591801283*^9, {3.8831693422177663`*^9, 3.883169342373979*^9}, 
   3.883170089065553*^9, {3.9565290756024103`*^9, 3.9565290756024103`*^9}, 
   3.956529277905364*^9, {3.9565293329237075`*^9, 3.956529358527069*^9}, 
   3.956529465626936*^9, {3.95652968441055*^9, 3.956529687425434*^9}, 
   3.956530150357442*^9, 3.956530343390212*^9, 3.9565304268131027`*^9, 
   3.956541558143319*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0140.png\>\"", ",", "adpConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955159803033*^9, 3.5339552034519095`*^9, 3.547008893618438*^9, 
   3.547008956314948*^9, {3.5501987477128153`*^9, 3.5501987478844156`*^9}, 
   3.5501988226865473`*^9, {3.550469306627704*^9, 3.5504693067681046`*^9}, 
   3.553114272723911*^9, 3.553114315530386*^9, 3.553114569972433*^9, 
   3.55318508843264*^9, {3.553185247131719*^9, 3.5531852473969193`*^9}, 
   3.5531900821741323`*^9, 3.55319015471426*^9, 3.5531908900479517`*^9, 
   3.5531909541796646`*^9, {3.553213790019997*^9, 3.5532138179752464`*^9}, {
   3.553214122440981*^9, 3.5532141511450315`*^9}, {3.556389578501213*^9, 
   3.556389578672813*^9}, 3.5563898772885375`*^9, {3.7325812073847427`*^9, 
   3.7325812080243435`*^9}, 3.7326535267504864`*^9, {3.732659119968313*^9, 
   3.732659120171114*^9}, {3.7326593137530546`*^9, 3.7326593214438686`*^9}, 
   3.740216750953225*^9, 3.740218228489431*^9, 3.740218990196377*^9, 
   3.74077860982647*^9, {3.740780605007178*^9, 3.7407806051787777`*^9}, 
   3.7407823021064887`*^9, {3.740795700305055*^9, 3.740795700539056*^9}, 
   3.7407957379479213`*^9, 3.7411140595270786`*^9, {3.7411141143767753`*^9, 
   3.741114114532776*^9}, 3.7411667457334538`*^9, {3.7411668447156277`*^9, 
   3.741166844871628*^9}, 3.74142115986131*^9, 3.744663700313615*^9, 
   3.744664379024007*^9, 3.7446656127845235`*^9, {3.7446659116810484`*^9, 
   3.744665911868249*^9}, 3.7452127175858293`*^9, {3.74521278093754*^9, 
   3.7452127811247406`*^9}, 3.7452152075218024`*^9, 3.7452154016881437`*^9, 
   3.7460519949503255`*^9, {3.7460520308459883`*^9, 3.74605203162599*^9}, 
   3.746055107834197*^9, 3.746991475479677*^9, {3.746991513918144*^9, 
   3.7469915424973946`*^9}, 3.746991645816376*^9, 3.748111177404529*^9, {
   3.748111322703184*^9, 3.748111322999585*^9}, 3.748112646147109*^9, {
   3.748113203645288*^9, 3.748113203988488*^9}, {3.7507167757248836`*^9, 
   3.7507167790164895`*^9}, 3.750716899963502*^9, {3.750907902190365*^9, 
   3.7509079301456137`*^9}, 3.75090826960221*^9, 3.751350024902258*^9, 
   3.7513500920135756`*^9, {3.7513503300387936`*^9, 3.751350330210394*^9}, 
   3.751400149651678*^9, {3.755049707478676*^9, 3.755049707634676*^9}, {
   3.755049765697978*^9, 3.75504976657158*^9}, 3.755049981945558*^9, 
   3.762283545821921*^9, 3.7622835936204047`*^9, 3.762283681510959*^9, 
   3.764280933902177*^9, 3.7642809906238766`*^9, {3.764281052961586*^9, 
   3.7642810835844398`*^9}, 3.7642811989934425`*^9, 3.764281290331603*^9, 
   3.764291454634307*^9, 3.7642915558472843`*^9, 3.7646644254065423`*^9, {
   3.7646645227819133`*^9, 3.7646645229067135`*^9}, {3.7648873755758543`*^9, 
   3.7648873757318544`*^9}, 3.764887973244104*^9, 3.7648894055102224`*^9, 
   3.765060231344472*^9, 3.765060779434235*^9, 3.7650876619491696`*^9, {
   3.7651708015085583`*^9, 3.7651708016333585`*^9}, 3.7651708746414866`*^9, 
   3.7652589118932266`*^9, {3.7652590299074335`*^9, 3.7652590301102343`*^9}, {
   3.7662195543382516`*^9, 3.766219578331094*^9}, 3.766219677016867*^9, 
   3.7662201983853827`*^9, 3.76647719987669*^9, 3.7664773392785344`*^9, 
   3.7664774867767935`*^9, 3.766477573559746*^9, 3.7666119106500444`*^9, {
   3.767393914938072*^9, 3.7673939150940723`*^9}, 3.7688458990076995`*^9, 
   3.768845992124263*^9, {3.7688460972060475`*^9, 3.768846097424448*^9}, 
   3.791925257442734*^9, {3.791926042673618*^9, 3.7919260678864145`*^9}, 
   3.7919411511491823`*^9, 3.7919412536874685`*^9, 3.7919455822489567`*^9, 
   3.791945613460332*^9, 3.7921427775327096`*^9, {3.7921442341379757`*^9, 
   3.7921442343566737`*^9}, 3.79214499129782*^9, {3.7921450432386465`*^9, 
   3.7921450433948555`*^9}, 3.7922066272150636`*^9, {3.7922081370131783`*^9, 
   3.7922081377629976`*^9}, 3.792270597728077*^9, {3.7922707124977846`*^9, 
   3.7922707126696568`*^9}, 3.792538656565729*^9, 3.792554019510995*^9, 
   3.802546808544753*^9, {3.8025468814650974`*^9, 3.802546882324236*^9}, 
   3.8025469199403934`*^9, 3.8025516303411865`*^9, {3.8025798413202734`*^9, 
   3.8025798500994525`*^9}, {3.80785445090362*^9, 3.8078544763037367`*^9}, 
   3.8078545477278557`*^9, 3.8169060294318476`*^9, 3.816906816785185*^9, 
   3.816906856635206*^9, 3.820806416772484*^9, 3.820806449655319*^9, 
   3.820806517936056*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.8278748592717104`*^9, 3.8278748912173123`*^9, 3.828286639443576*^9, 
   3.848257038638844*^9, 3.848257074614698*^9, 3.848257111481027*^9, 
   3.854761763900452*^9, {3.8547618323859158`*^9, 3.854761855958494*^9}, {
   3.883168591801283*^9, 3.88316864422643*^9}, 3.9565290756180315`*^9, {
   3.9565292024855556`*^9, 3.9565292145296135`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"rp3dConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"RePlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0.01", ",", "0.01"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "8"}], ",", "2"}], "}"}], ",", "25"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221349871864`*^9}, {3.533956562109496*^9, 3.533956663650075*^9}, 
   3.5339567557838364`*^9, 3.5347099882825756`*^9, 3.5347102657482634`*^9, {
   3.5347103008951254`*^9, 3.5347103043427315`*^9}, {3.535593994727907*^9, 
   3.535594052120408*^9}, {3.535594118654525*^9, 3.535594142257366*^9}, {
   3.53559417306742*^9, 3.5355941818346357`*^9}, {3.535594253173561*^9, 
   3.535594273141596*^9}, {3.535594308943659*^9, 3.535594311580064*^9}, {
   3.5355943417349167`*^9, 3.5355943446677217`*^9}, 3.5355944944279847`*^9, 
   3.5364644113098073`*^9, 3.547008961306957*^9, 3.547009174886932*^9, 
   3.5470100939009466`*^9, 3.5470101792522974`*^9, {3.547010219671968*^9, 
   3.5470102336495924`*^9}, {3.547010378308647*^9, 3.5470103791978483`*^9}, {
   3.5470106361019*^9, 3.547010661077544*^9}, 3.5501988290669584`*^9, 
   3.550199059994164*^9, 3.550199923226681*^9, {3.5501999833959866`*^9, 
   3.5501999880135946`*^9}, 3.5502073242848244`*^9, 3.5502076305611625`*^9, 
   3.5502077527405767`*^9, 3.550207824360303*^9, {3.5502086208227015`*^9, 
   3.5502086232251062`*^9}, 3.5502087333612995`*^9, {3.550210050393613*^9, 
   3.5502100620780334`*^9}, 3.5503471093742733`*^9, {3.5508011543922625`*^9, 
   3.5508011573094673`*^9}, 3.550801274574874*^9, 3.550828826075177*^9, 
   3.5531145222051487`*^9, 3.5531145764308443`*^9, 3.5531151448958426`*^9, {
   3.553115181758707*^9, 3.5531152194327736`*^9}, 3.5531152549228363`*^9, {
   3.553115444209176*^9, 3.5531154457847786`*^9}, 3.5531154834276447`*^9, 
   3.553184120965741*^9, 3.5531844553835287`*^9, 3.5531849288443604`*^9, {
   3.5531850323193417`*^9, 3.553185039214554*^9}, {3.5534455197643785`*^9, 
   3.5534455226191835`*^9}, {3.564290330151406*^9, 3.564290330151406*^9}, {
   3.564291249632621*^9, 3.5642913088503246`*^9}, {3.5642913587860126`*^9, 
   3.5642913874744625`*^9}, 3.5645701739454827`*^9, 3.56457022934118*^9, {
   3.5645704548083763`*^9, 3.564570523245696*^9}, 3.564632298359475*^9, 
   3.5672835710783267`*^9, 3.5672836098287945`*^9, 3.5672836500924654`*^9, 
   3.5672837096845703`*^9, {3.5672837599322586`*^9, 3.567283785797104*^9}, {
   3.567283815998757*^9, 3.567283882470474*^9}, 3.5672839294421563`*^9, 
   3.567283963200616*^9, 3.567749299701456*^9, 3.567802782394025*^9, 
   3.5678028822498007`*^9, {3.5681600327494287`*^9, 3.5681600592382755`*^9}, {
   3.568160109142763*^9, 3.5681601122315683`*^9}, 3.5681601467388287`*^9, {
   3.568160184319295*^9, 3.56816020424053*^9}, {3.568160517132702*^9, 
   3.568160596162441*^9}, 3.5681606610273547`*^9, {3.568160946421071*^9, 
   3.568160966030306*^9}, {3.5681705219146996`*^9, 3.5681705242703037`*^9}, 
   3.5681941899017687`*^9, 3.568194240352257*^9, 3.5700755677715073`*^9, 
   3.570075613354788*^9, 3.5700766540950155`*^9, {3.570086887572139*^9, 
   3.5700868877641497`*^9}, {3.570087003107747*^9, 3.570087005763899*^9}, {
   3.570087078020032*^9, 3.5700870989962316`*^9}, 3.5700872221102734`*^9, {
   3.57009623935571*^9, 3.570096282536586*^9}, 3.5736048119306808`*^9, 
   3.5736048904456186`*^9, 3.573604940833707*^9, {3.573605077677148*^9, 
   3.573605125865632*^9}, {3.5736051592964907`*^9, 3.573605161948496*^9}, {
   3.573605211119782*^9, 3.5736052136937866`*^9}, {3.5736052478578463`*^9, 
   3.5736052497922497`*^9}, 3.5736058726857443`*^9, 3.573605926771039*^9, {
   3.573605956925892*^9, 3.5736059886719475`*^9}, 3.573606090758527*^9, {
   3.5736061269973907`*^9, 3.57360615517104*^9}, {3.5736066713897743`*^9, 
   3.573606699345023*^9}, 3.573615836289501*^9, 3.57361605569005*^9, 
   3.5736161124242954`*^9, {3.5736161436740828`*^9, 3.5736161737138004`*^9}, 
   3.5736162263498116`*^9, {3.5736162577736087`*^9, 3.573616267602171*^9}, {
   3.573616444274276*^9, 3.5736164466824136`*^9}, {3.574885927166521*^9, 
   3.5748859637953854`*^9}, {3.5748860508435383`*^9, 
   3.5748860521695404`*^9}, {3.5748861157240524`*^9, 3.574886117252855*^9}, 
   3.57577235924708*^9, 3.5757724099589806`*^9, 3.575772445279001*^9, {
   3.5757724785189023`*^9, 3.5757724925687056`*^9}, {3.575772607702291*^9, 
   3.575772651454794*^9}, {3.5759741600893764`*^9, 3.575974161493379*^9}, {
   3.575974199510646*^9, 3.5759742220370855`*^9}, 3.576873240797937*^9, {
   3.5768733189384737`*^9, 3.576873344428919*^9}, {3.576873425346261*^9, 
   3.5768734529895096`*^9}, {3.576873485281566*^9, 3.5768734895091734`*^9}, {
   3.576873525514037*^9, 3.576873525701237*^9}, {3.577055332882147*^9, 
   3.5770553361425524`*^9}, 3.577871528638734*^9, {3.5778716843606405`*^9, 
   3.577871704824811*^9}, 3.5778717538886175`*^9, {3.5778718288889074`*^9, 
   3.577871876976658*^9}, {3.5778719113366227`*^9, 3.577871931008748*^9}, 
   3.577996382595691*^9, 3.5779973953859024`*^9, 3.577997497659682*^9, {
   3.592182738830336*^9, 3.592182738830336*^9}, 3.592182940881891*^9, 
   3.592183011815215*^9, {3.5921894364524994`*^9, 3.592189460086541*^9}, {
   3.592189491785797*^9, 3.592189494235001*^9}, {3.5921895481018953`*^9, 
   3.592189608177601*^9}, 3.592189794161128*^9, 3.5921898423808126`*^9, 
   3.5993883891423397`*^9, {3.5993886376195765`*^9, 3.5993886707696347`*^9}, 
   3.5993887338093452`*^9, 3.599388787067839*^9, 3.5993898053488283`*^9, 
   3.599450646030573*^9, 3.6063523737093935`*^9, {3.6063536327884064`*^9, 
   3.606353657155649*^9}, {3.6063536884961042`*^9, 3.606353715281351*^9}, {
   3.6063541082884493`*^9, 3.606354110690853*^9}, {3.606354174463765*^9, 
   3.6063541934333982`*^9}, 3.606354233681469*^9, {3.606354327624834*^9, 
   3.6063543393872547`*^9}, {3.6063554596717415`*^9, 3.606355469234558*^9}, {
   3.6063556589152913`*^9, 3.6063556888517437`*^9}, {3.6063559489462013`*^9, 
   3.60635597109824*^9}, {3.606356372177745*^9, 3.606356383128964*^9}, {
   3.6063564284002438`*^9, 3.606356435435856*^9}, 3.606356488460349*^9, {
   3.606356550096057*^9, 3.606356592091331*^9}, 3.606362300175032*^9, 
   3.606364095238985*^9, 3.6063646120054927`*^9, {3.606424049973319*^9, 
   3.606424053639326*^9}, 3.6064240927485943`*^9, 3.6064350337292786`*^9, 
   3.6253066892819157`*^9, 3.625306727517583*^9, {3.6253071403575087`*^9, 
   3.625307143961115*^9}, 3.6253071830235834`*^9, 3.625307214270438*^9, 
   3.62530768864248*^9, {3.625307721074937*^9, 3.6253077378137665`*^9}, {
   3.6253078152835026`*^9, 3.625307818465908*^9}, 3.6253078603831816`*^9, 
   3.625308042795102*^9, {3.625308091591988*^9, 3.6253080991112013`*^9}, {
   3.625383389886337*^9, 3.625383390822338*^9}, 3.6253834238787966`*^9, 
   3.6291871861181545`*^9, 3.629187255195076*^9, {3.629187298329152*^9, 
   3.629187319170789*^9}, 3.629187721281896*^9, {3.629187761576767*^9, 
   3.629187773105187*^9}, 3.629187853476528*^9, {3.629189386050821*^9, 
   3.6291893870960226`*^9}, 3.6294129792897773`*^9, {3.629681940821416*^9, 
   3.629681967825063*^9}, 3.6296830652981987`*^9, {3.629683828638739*^9, 
   3.629683873535618*^9}, 3.6296840724983673`*^9, 3.629684659074998*^9, {
   3.6296848918274064`*^9, 3.629684894619811*^9}, 3.630130105717137*^9, 
   3.6301868115768538`*^9, 3.6301913486360464`*^9, {3.6301914399118066`*^9, 
   3.630191440754208*^9}, {3.6301915173347425`*^9, 3.630191517662343*^9}, {
   3.630191564462425*^9, 3.6301915646184254`*^9}, 3.6301916235085287`*^9, 
   3.6301916648486013`*^9, {3.6301916949722548`*^9, 3.630191743254339*^9}, 
   3.630192498482866*^9, 3.630224013755659*^9, 3.6325489583565407`*^9, 
   3.6325493465892234`*^9, 3.6325495969920783`*^9, 3.6325497909544272`*^9, {
   3.6325499065150375`*^9, 3.6325499323798833`*^9}, {3.6326039905906425`*^9, 
   3.6326039969398537`*^9}, {3.6326052476784515`*^9, 3.6326052678180866`*^9}, 
   3.632789691264064*^9, {3.632789738937748*^9, 3.632789739811349*^9}, {
   3.632789771198604*^9, 3.63278978590943*^9}, 3.632789880617196*^9, 
   3.6327899977890024`*^9, 3.63279813902344*^9, 3.632798262731657*^9, 
   3.632807713384465*^9, 3.6328077532581353`*^9, {3.632813931449418*^9, 
   3.6328140063139496`*^9}, {3.632814038262806*^9, 3.632814038481206*^9}, {
   3.6328142150367174`*^9, 3.632814235581953*^9}, {3.632862829136717*^9, 
   3.6328628333643246`*^9}, 3.632863060297923*^9, 3.6328903848425245`*^9, 
   3.6345039605706234`*^9, 3.6345039979950895`*^9, 3.634505028388706*^9, {
   3.634505073659986*^9, 3.634505094844823*^9}, {3.6345051346835*^9, 
   3.6345051909059987`*^9}, {3.634505248002099*^9, 3.6345052831177607`*^9}, 
   3.6345058717026*^9, {3.6345559035261827`*^9, 3.6345559061157875`*^9}, {
   3.634555945349856*^9, 3.634555948313861*^9}, 3.634556202246708*^9, {
   3.6360748453404164`*^9, 3.6360748476336203`*^9}, 3.636075402244196*^9, 
   3.6360755387756352`*^9, 3.6360756646834564`*^9, 3.636076028008095*^9, 
   3.6360760583769555`*^9, {3.6360761965931983`*^9, 3.6360762071856165`*^9}, 
   3.6364953485684733`*^9, 3.6364953884889436`*^9, 3.636495515816367*^9, 
   3.6364955598396444`*^9, 3.63649577777445*^9, {3.6364958118137093`*^9, 
   3.636495860766596*^9}, 3.636495993039228*^9, 3.636496147385899*^9, {
   3.636496214996418*^9, 3.636496253372485*^9}, 3.6364964311815977`*^9, {
   3.6364969697417445`*^9, 3.6364969814261646`*^9}, {3.636762383421364*^9, 
   3.6367623872745705`*^9}, 3.725592441562623*^9, 3.7255925278151746`*^9, 
   3.7255944795378036`*^9, {3.72559451145546*^9, 3.7255945146846657`*^9}, 
   3.7255953568521447`*^9, 3.725595801020926*^9, 3.725595862875035*^9, 
   3.725596145750332*^9, 3.72559634416708*^9, 3.7255964017623816`*^9, {
   3.725600882543482*^9, 3.725600909469129*^9}, 3.725601380552758*^9, 
   3.725771260842998*^9, {3.725774253989055*^9, 3.725774282505905*^9}, {
   3.725774385294486*^9, 3.725774424243362*^9}, {3.7257804563043575`*^9, 
   3.7257804693615804`*^9}, 3.7258490252477674`*^9, 3.7258521016447725`*^9, 
   3.725852258877449*^9, 3.725852363803233*^9, 3.7258524000108967`*^9, 
   3.725852749623111*^9, {3.7258530098159676`*^9, 3.7258530484884357`*^9}, {
   3.7258533935578427`*^9, 3.7258534235566955`*^9}, {3.725853537717696*^9, 
   3.725853546578511*^9}, 3.726913461460272*^9, {3.7269135067003517`*^9, 
   3.726913506715952*^9}, 3.726913573655669*^9, 3.7269142247852125`*^9, {
   3.726914355279442*^9, 3.726914372969873*^9}, 3.7269144359471836`*^9, 
   3.7269145160221243`*^9, 3.726914654581568*^9, 3.726914723206088*^9, {
   3.7269151216475897`*^9, 3.726915129884404*^9}, 3.726915517287485*^9, {
   3.726942972603111*^9, 3.7269429731335115`*^9}, 3.726952629442474*^9, 
   3.7269527024818025`*^9, {3.7325814358471437`*^9, 3.732581510446475*^9}, 
   3.7325815475277395`*^9, {3.7326584462775297`*^9, 3.732658472844376*^9}, {
   3.732658943126403*^9, 3.732658966682444*^9}, 3.7326593293998823`*^9, 
   3.732668442777998*^9, {3.7402181611597123`*^9, 3.740218186072956*^9}, 
   3.740218232124237*^9, {3.7402183905893154`*^9, 3.7402183918841176`*^9}, 
   3.740218439771809*^9, 3.7402184717362657`*^9, {3.740218744752345*^9, 
   3.740218755048363*^9}, {3.7402188877977967`*^9, 3.740218953427112*^9}, {
   3.7402206710333304`*^9, 3.740220709690198*^9}, 3.740623517482953*^9, {
   3.740778612338074*^9, 3.740778614194477*^9}, {3.740778697514224*^9, 
   3.740778713769452*^9}, {3.7407792507571983`*^9, 3.740779281707652*^9}, {
   3.7407793154973116`*^9, 3.7407793317681403`*^9}, {3.74077962170185*^9, 
   3.740779646209493*^9}, 3.7407805331690516`*^9, 3.7407805721691203`*^9, 
   3.7407807771378803`*^9, 3.7407824673731785`*^9, 3.740784298882004*^9, 
   3.740784367336528*^9, 3.7407845511906676`*^9, 3.7407847911139035`*^9, 
   3.740785320891444*^9, {3.740792222878537*^9, 3.74079222451654*^9}, 
   3.740795734391115*^9, 3.7407958434197063`*^9, 3.7407962499408207`*^9, 
   3.740796287817687*^9, 3.7407968561734858`*^9, 3.7407968980127587`*^9, {
   3.7411140633022857`*^9, 3.741114065189889*^9}, 3.7411141817688937`*^9, {
   3.7411142451362047`*^9, 3.7411142815778685`*^9}, {3.7411143643984146`*^9, 
   3.741114394927668*^9}, 3.741114449028563*^9, 3.741165053951681*^9, 
   3.7411667429098487`*^9, 3.741166800005949*^9, 3.741167002587905*^9, 
   3.7418927044966946`*^9, 3.744663705024823*^9, 3.744664181730461*^9, 
   3.7446656128001237`*^9, 3.7446656519405923`*^9, 3.7447503917826357`*^9, 
   3.744875558139942*^9, 3.745212724418641*^9, 3.7452130520192165`*^9, 
   3.7452134415987005`*^9, {3.7452134772759633`*^9, 3.745213477884364*^9}, 
   3.745213581842947*^9, 3.745213760572461*^9, {3.7452137926617174`*^9, 
   3.7452138142521553`*^9}, {3.7452138718318567`*^9, 3.745213901846309*^9}, 
   3.74521397072043*^9, {3.7452140044788895`*^9, 3.745214017692113*^9}, {
   3.745215374934097*^9, 3.745215398848939*^9}, 3.745215733004327*^9, {
   3.745215869754167*^9, 3.74521587134537*^9}, {3.7452159052910295`*^9, 
   3.7452159092066364`*^9}, {3.745215982604765*^9, 3.7452159998115954`*^9}, 
   3.7452162565100465`*^9, 3.74605199750873*^9, {3.7460524917799983`*^9, 
   3.7460525007812138`*^9}, 3.7460544899795113`*^9, 3.74605461420253*^9, {
   3.746054731577136*^9, 3.746054777706417*^9}, {3.7460548234768972`*^9, 
   3.7460548417133293`*^9}, 3.746054911461052*^9, 3.7469916527895885`*^9, 
   3.746995583616094*^9, 3.7469956167661524`*^9, {3.7469957258615446`*^9, 
   3.7469957275151477`*^9}, {3.746995760977206*^9, 3.746995762147208*^9}, {
   3.7469958133464985`*^9, 3.746995836512539*^9}, 3.746995880816617*^9, {
   3.7469959276946993`*^9, 3.746995931984707*^9}, {3.7470008112785206`*^9, 
   3.7470008135717244`*^9}, {3.7470008798094406`*^9, 3.747000881369444*^9}, {
   3.747027563106309*^9, 3.74702756362111*^9}, {3.747028030906732*^9, 
   3.747028033511936*^9}, 3.7481111814917364`*^9, 3.7481112473238516`*^9, 
   3.748111472572647*^9, 3.748111511900316*^9, 3.748111751157937*^9, 
   3.7481117965072165`*^9, 3.748111837706889*^9, 3.7481119389198666`*^9, 
   3.748112002271578*^9, 3.7481126431207037`*^9, 3.7481127702141266`*^9, 
   3.748112890599538*^9, 3.748112975042486*^9, {3.748113023496172*^9, 
   3.748113025196574*^9}, 3.748113104850314*^9, 3.7481148783458304`*^9, 
   3.748152378124942*^9, 3.748156761576641*^9, 3.749668426627076*^9, 
   3.7507169093079185`*^9, {3.750717434654441*^9, 3.7507174520016713`*^9}, 
   3.7507179985374317`*^9, 3.7507180693303566`*^9, 3.750718107222823*^9, {
   3.750718237732652*^9, 3.7507182378574524`*^9}, 3.750718351924853*^9, {
   3.750719888347952*^9, 3.75071989302796*^9}, 3.75072066733372*^9, 
   3.750724214763152*^9, 3.7507255977531834`*^9, 3.7507440011381135`*^9, {
   3.7507441014618897`*^9, 3.7507441048314953`*^9}, 3.7511831548137474`*^9, 
   3.7511832008026285`*^9, {3.751189420749557*^9, 3.7511894221223593`*^9}, {
   3.751189545112975*^9, 3.7511895500581837`*^9}, {3.751191026389179*^9, 
   3.751191036263996*^9}, {3.7511922279880896`*^9, 3.75119225077973*^9}, {
   3.7512741081272516`*^9, 3.7512741083924522`*^9}, 3.751343680793913*^9, {
   3.7513437352380085`*^9, 3.751343748076831*^9}, {3.751343859991428*^9, 
   3.7513438704746466`*^9}, 3.751343972284826*^9, {3.751344206045637*^9, 
   3.751344228946477*^9}, {3.751345479654274*^9, 3.751345479669874*^9}, 
   3.7513458163340654`*^9, {3.7513459501355004`*^9, 3.751345950946702*^9}, 
   3.751346259250044*^9, {3.75134772036421*^9, 3.751347750955864*^9}, {
   3.7513478386904173`*^9, 3.7513478502656384`*^9}, {3.7513480264523478`*^9, 
   3.7513480387451687`*^9}, {3.751356659578311*^9, 3.7513566652723207`*^9}, {
   3.7513584868487215`*^9, 3.751358487051522*^9}, {3.7513587764620385`*^9, 
   3.7513587766960387`*^9}, 3.751359217521613*^9, 3.755049981961158*^9, 
   3.755050081910534*^9, 3.7550501621414747`*^9, {3.7550504076079054`*^9, 
   3.7550504105563107`*^9}, 3.755050934296031*^9, 3.7550519317455764`*^9, {
   3.7550519933656845`*^9, 3.7550521232671127`*^9}, 3.7550521578835735`*^9, 
   3.755061383808256*^9, 3.755137961376438*^9, {3.7551380194709396`*^9, 
   3.755138043448182*^9}, 3.7551380790006447`*^9, {3.755138180494423*^9, 
   3.7551382149704833`*^9}, 3.7551383199274673`*^9, {3.7551384479880924`*^9, 
   3.755138485646559*^9}, {3.7551385328522415`*^9, 3.755138535301446*^9}, {
   3.7551388552780085`*^9, 3.755138867898431*^9}, {3.755138899379286*^9, 
   3.755138900923689*^9}, {3.755141473017996*^9, 3.7551414735015965`*^9}, 
   3.7551423127060127`*^9, 3.755143428371771*^9, {3.7551475899709272`*^9, 
   3.7551475974589405`*^9}, {3.755147763630432*^9, 3.755147798215693*^9}, 
   3.7552236306629615`*^9, 3.7552237351007524`*^9, {3.7552274948275833`*^9, 
   3.7552275018475957`*^9}, 3.7642903579671755`*^9, {3.7642905351382875`*^9, 
   3.764290614448827*^9}, 3.764290670343725*^9, {3.7642907227754173`*^9, 
   3.7642907831007233`*^9}, {3.764290822865193*^9, 3.7642908322408094`*^9}, 
   3.7642909401461987`*^9, {3.76429097484066*^9, 3.764290976041862*^9}, 
   3.764291199136257*^9, {3.7642913149984617`*^9, 3.7642913174008656`*^9}, 
   3.7642916029593673`*^9, 3.764302351074251*^9, 3.7643023945203276`*^9, 
   3.764304227843149*^9, 3.7643178515372825`*^9, 3.76432045498466*^9, 
   3.764370158357931*^9, 3.7643729553032446`*^9, {3.764374606185746*^9, 
   3.764374606466547*^9}, 3.7643849800828085`*^9, 3.764385335676648*^9, {
   3.7646681230006466`*^9, 3.764668147102689*^9}, {3.764668200189582*^9, 
   3.764668201515584*^9}, {3.764668246396863*^9, 3.764668249766469*^9}, 
   3.764668283384528*^9, 3.7646685415805817`*^9, 3.764887973275304*^9, 
   3.764888009139767*^9, 3.7648889009273357`*^9, {3.764890388914151*^9, 
   3.7648904010509725`*^9}, {3.764890438990239*^9, 3.764890439130639*^9}, 
   3.7648906343181825`*^9, 3.76489671665236*^9, 3.7650607837398424`*^9, 
   3.7651708746570864`*^9, 3.7651709275255795`*^9, {3.7651715865911446`*^9, 
   3.7651716002099686`*^9}, {3.765172130556101*^9, 3.7651721436133237`*^9}, 
   3.765258860522336*^9, 3.7652589119088264`*^9, 3.765267845342927*^9, 
   3.766219677032467*^9, 3.766219733644967*^9, 3.766220205062195*^9, 
   3.766224732047748*^9, {3.766371669949203*^9, 3.766371670120803*^9}, {
   3.7664771998922896`*^9, 3.7664772214515276`*^9}, {3.7664774867767935`*^9, 
   3.7664775002396173`*^9}, {3.768845899023299*^9, 3.768845913219324*^9}, {
   3.7688464421018543`*^9, 3.7688464430066557`*^9}, {3.768846907500272*^9, 
   3.768846908498674*^9}, {3.7756127056776414`*^9, 3.7756127085636463`*^9}, 
   3.7919252574583597`*^9, 3.791925346562312*^9, 3.7919254153117027`*^9, {
   3.7919255247077045`*^9, 3.791925531253033*^9}, 3.791925598002926*^9, {
   3.791925817141368*^9, 3.791925857178751*^9}, {3.7919259309425774`*^9, 
   3.791925933801317*^9}, {3.7919260057136*^9, 3.791926009212773*^9}, {
   3.79192660049582*^9, 3.7919266190539074`*^9}, {3.7919271891237907`*^9, 
   3.7919272245842*^9}, {3.7919274867894063`*^9, 3.791927489554371*^9}, {
   3.791927538745885*^9, 3.791927604824026*^9}, {3.7919283206321373`*^9, 
   3.791928328770767*^9}, 3.7919283681131506`*^9, 3.791941147556281*^9, 
   3.791941226943779*^9, {3.791943064803152*^9, 3.791943072441972*^9}, 
   3.7919455853419733`*^9, 3.7919456390636563`*^9, 3.7919457301594105`*^9, {
   3.7919460176571693`*^9, 3.791946064630477*^9}, 3.7919462776270447`*^9, {
   3.7919463420805435`*^9, 3.7919463444393888`*^9}, {3.791948507232851*^9, 
   3.7919485077639413`*^9}, 3.7921427775327096`*^9, 3.7921428813674984`*^9, {
   3.7921430077438335`*^9, 3.7921430285982695`*^9}, {3.792143075102886*^9, 
   3.792143196527261*^9}, 3.7921432320813465`*^9, {3.7921435108289423`*^9, 
   3.7921435112507515`*^9}, {3.792144994000306*^9, 3.7921450236495314`*^9}, 
   3.7921450984755683`*^9, {3.792145135779237*^9, 3.7921451459487057`*^9}, 
   3.7921451813309965`*^9, {3.7921455405896435`*^9, 3.792145540823963*^9}, {
   3.792184495223648*^9, 3.7921844998788123`*^9}, {3.792184623771303*^9, 
   3.7921846334096813`*^9}, {3.792206627230712*^9, 3.792206627230712*^9}, 
   3.7922067487800713`*^9, {3.792206857551155*^9, 3.7922068652212453`*^9}, 
   3.79220731139717*^9, 3.7922074804352627`*^9, {3.792207911722797*^9, 
   3.792207920220762*^9}, 3.7922106315283227`*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709234165945`*^9, 3.7922709273375435`*^9}, 
   3.7922709952589617`*^9, 3.792271044919084*^9, {3.7922714000850353`*^9, 
   3.7922714133162184`*^9}, {3.79227225780206*^9, 3.7922722845301075`*^9}, 
   3.7922726379453006`*^9, 3.792538656581356*^9, 3.792538928359619*^9, {
   3.79253897772618*^9, 3.7925389929881973`*^9}, 3.792539105239499*^9, 
   3.7925391544309196`*^9, {3.7925392146979003`*^9, 3.7925392318501225`*^9}, {
   3.792553251880274*^9, 3.7925533135219245`*^9}, {3.792553558651388*^9, 
   3.7925535983294907`*^9}, 3.7925536300406995`*^9, 3.792553977661547*^9, 
   3.7934110765855913`*^9, 3.802546778036353*^9, 3.8025468148870387`*^9, 
   3.802552822458405*^9, {3.8025530544662237`*^9, 3.8025530844279113`*^9}, {
   3.802553133713169*^9, 3.8025531354783773`*^9}, {3.8025532097421217`*^9, 
   3.8025532578048534`*^9}, {3.802553588023881*^9, 3.802553607941058*^9}, {
   3.8025798334471254`*^9, 3.802579836009097*^9}, 3.8025799428439727`*^9, 
   3.8025826954822035`*^9, 3.807854554258397*^9, 3.807854690828374*^9, {
   3.8078547263903584`*^9, 3.8078547526052713`*^9}, {3.8078547973826*^9, 
   3.8078548259492536`*^9}, 3.807854857290492*^9, {3.807855065442194*^9, 
   3.8078550755771074`*^9}, 3.816906042506902*^9, 3.8169062174197626`*^9, {
   3.8169062961825204`*^9, 3.8169063081953278`*^9}, 3.8169064017358685`*^9, 
   3.8169064565355053`*^9, {3.816906506133236*^9, 3.816906533095647*^9}, 
   3.8169065818185563`*^9, 3.816906741702897*^9, 3.8169069030617733`*^9, 
   3.816911863808765*^9, {3.820806523044219*^9, 3.820806525543599*^9}, {
   3.820806605337228*^9, 3.820806634720892*^9}, {3.820806728870463*^9, 
   3.8208067606910887`*^9}, 3.8208068514664154`*^9, 3.8208068887857084`*^9, {
   3.820806986417849*^9, 3.820806992557019*^9}, 3.820807050543249*^9, 
   3.8208071575179443`*^9, {3.827874604494393*^9, 3.8278746309725633`*^9}, 
   3.828286126815601*^9, 3.828286178522227*^9, {3.8282862114207487`*^9, 
   3.828286249083788*^9}, 3.8282862800765343`*^9, {3.828286322644653*^9, 
   3.828286322972701*^9}, {3.828286357931463*^9, 3.828286378520382*^9}, 
   3.828286413949597*^9, 3.8282865511517544`*^9, 3.828849014384474*^9, {
   3.8482570386544743`*^9, 3.8482570386544743`*^9}, {3.848257162547103*^9, 
   3.8482572050995564`*^9}, 3.8482572474489293`*^9, 3.8482592289492965`*^9, 
   3.8482592632131195`*^9, 3.8482593480525*^9, {3.8482596406568003`*^9, 
   3.848259662354802*^9}, {3.8482598575520773`*^9, 3.848259863863089*^9}, {
   3.848259935769012*^9, 3.848259938174694*^9}, {3.848260033511561*^9, 
   3.8482600702372885`*^9}, {3.848260636230188*^9, 3.848260666894863*^9}, 
   3.8482606989966545`*^9, 3.8482607541243086`*^9, {3.8547617639317226`*^9, 
   3.854761763947344*^9}, 3.854761807093421*^9, {3.854761939287712*^9, 
   3.854761948035654*^9}, {3.854762215597452*^9, 3.8547622692588873`*^9}, {
   3.8547623089584866`*^9, 3.854762311739122*^9}, {3.8547623431746674`*^9, 
   3.854762363654195*^9}, 3.854763519987254*^9, 3.8831684261211495`*^9, 
   3.883168549077005*^9, 3.8831685918169317`*^9, {3.883169007296896*^9, 
   3.88316901865359*^9}, 3.883169538507764*^9, 3.8831706590004115`*^9, 
   3.883170863795307*^9, {3.9565290756180315`*^9, 3.9565290756180315`*^9}, 
   3.9565292781396837`*^9, {3.9565293331424026`*^9, 3.9565293645100403`*^9}, 
   3.9565294692042217`*^9, 3.956529507929509*^9, {3.9565295473808737`*^9, 
   3.9565295677979517`*^9}, {3.9565297430061445`*^9, 
   3.9565297484892626`*^9}, {3.956529847778465*^9, 3.956529900063098*^9}, {
   3.9565301658693733`*^9, 3.956530172289773*^9}, 3.9565304532600217`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0150.png\>\"", ",", "rp3dConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.5339551667918453`*^9, 3.5339552009091053`*^9, 3.5470088969568434`*^9, 
   3.5470089640057616`*^9, {3.5501987513788223`*^9, 3.550198751410022*^9}, 
   3.5501988321245637`*^9, {3.5504693115261126`*^9, 3.550469311666513*^9}, 
   3.5531142779343195`*^9, 3.5531143119735794`*^9, 3.5531145798316503`*^9, 
   3.55318508241103*^9, {3.55318525330933*^9, 3.5531852534809303`*^9}, 
   3.553190085153738*^9, 3.553190157912266*^9, 3.553190885227544*^9, {
   3.553190960606876*^9, 3.5531909607628765`*^9}, {3.5532137942008047`*^9, 
   3.553213813825639*^9}, {3.55321412771379*^9, 3.553214156714241*^9}, {
   3.556389588766031*^9, 3.5563895889376307`*^9}, 3.5563898811573443`*^9, {
   3.7325812234839706`*^9, 3.7325812239051714`*^9}, 3.7326535205260754`*^9, {
   3.7326591250071225`*^9, 3.7326591252255225`*^9}, 3.732659348416316*^9, 
   3.7402167509688253`*^9, 3.740218234479841*^9, 3.740218993768783*^9, 
   3.740778618671685*^9, {3.7407806106543875`*^9, 3.740780610810388*^9}, {
   3.740782307394898*^9, 3.7407823078160987`*^9}, {3.7407957072626677`*^9, 
   3.740795732191511*^9}, 3.7411140683254943`*^9, {3.7411141195091844`*^9, 
   3.7411141197119846`*^9}, 3.7411667406790447`*^9, {3.7411668525936413`*^9, 
   3.7411668526872416`*^9}, {3.7414211411412773`*^9, 3.7414211413128777`*^9}, 
   3.7446637082540293`*^9, {3.744664383891216*^9, 3.7446643841564164`*^9}, 
   3.7446656128001237`*^9, {3.744665919325062*^9, 3.7446659194654617`*^9}, 
   3.745212728256248*^9, {3.7452127863195496`*^9, 3.7452127865379505`*^9}, 
   3.745215210719808*^9, 3.7452153969769354`*^9, 3.7460519999891343`*^9, {
   3.7460520390048027`*^9, 3.746052039628804*^9}, 3.7460551110166025`*^9, 
   3.7469914786308823`*^9, {3.7469915178025513`*^9, 3.746991547068203*^9}, 
   3.7469916572823963`*^9, 3.7481111850173426`*^9, {3.7481113291771955`*^9, 
   3.748111329348796*^9}, 3.7481126410927*^9, 3.7481132104469*^9, {
   3.750716795334118*^9, 3.7507167978769226`*^9}, 3.750716914752328*^9, 
   3.750907902205965*^9, {3.7509079354808235`*^9, 3.750907935777224*^9}, 
   3.7509082696178102`*^9, 3.751350024917858*^9, 3.7513500920135756`*^9, {
   3.751350335186803*^9, 3.7513503353740034`*^9}, 3.7514001537856855`*^9, {
   3.7550497020342665`*^9, 3.755049702159066*^9}, {3.755049780455604*^9, 
   3.7550497817660065`*^9}, 3.755049981961158*^9, 3.7622835534347343`*^9, 
   3.7622835983940134`*^9, 3.7622836925245786`*^9, 3.7642809470685997`*^9, 
   3.764280993650282*^9, {3.764281062056402*^9, 3.7642810876404467`*^9}, 
   3.7642812103970623`*^9, {3.7642812957916126`*^9, 3.764281295994413*^9}, 
   3.7642914608743176`*^9, 3.7642915591544905`*^9, 3.764664425437742*^9, {
   3.7646645337331324`*^9, 3.7646645339047327`*^9}, {3.7648873895846786`*^9, 
   3.764887389771879*^9}, 3.764887973275304*^9, 3.764889411126232*^9, 
   3.765060236898082*^9, 3.7650607861422467`*^9, {3.765087671387186*^9, 
   3.7650876715275865`*^9}, {3.7651708114457755`*^9, 3.765170811664176*^9}, 
   3.7651708746570864`*^9, 3.765258911924426*^9, {3.765259045601061*^9, 
   3.7652590457882614`*^9}, {3.766219554353852*^9, 3.766219582964302*^9}, 
   3.766219677032467*^9, 3.7662202070277977`*^9, 3.7664771998922896`*^9, 
   3.7664773392785344`*^9, 3.7664774867923937`*^9, 3.766477573575346*^9, 
   3.766611931678881*^9, {3.7673939264508924`*^9, 3.767393926622493*^9}, 
   3.768845899023299*^9, 3.768845992139863*^9, 3.7688461046784606`*^9, 
   3.791925257473979*^9, 3.7919260459384813`*^9, {3.791926076384407*^9, 
   3.791926077056122*^9}, 3.7919411447288256`*^9, 3.7919412585144467`*^9, {
   3.791945587700791*^9, 3.7919456092894487`*^9}, 3.7921427775327096`*^9, {
   3.7921442396836076`*^9, 3.7921442398866467`*^9}, 3.7921449966246824`*^9, {
   3.7921450490810156`*^9, 3.792145049205987*^9}, 3.792206627230712*^9, {
   3.792208145964188*^9, 3.7922081471983175`*^9}, 3.7922705977436914`*^9, {
   3.7922707178871346`*^9, 3.792270718027725*^9}, 3.792538656581356*^9, 
   3.792554025353397*^9, 3.8025468178550973`*^9, {3.8025468885259333`*^9, 
   3.802546916941086*^9}, 3.8025516349182377`*^9, {3.8025798245429773`*^9, 
   3.8025798309477167`*^9}, 3.8078544471885157`*^9, {3.807854484527757*^9, 
   3.8078544851420836`*^9}, 3.8078545576323867`*^9, 3.8169060469746084`*^9, 
   3.8169068200344243`*^9, 3.816906860056246*^9, 3.8208064231928377`*^9, 
   3.82080645710668*^9, 3.8208065296052046`*^9, {3.827874604510014*^9, 
   3.8278746309725633`*^9}, 3.8278748592717104`*^9, 3.827874904026807*^9, 
   3.828286644676685*^9, 3.8482570386544743`*^9, 3.8482570746303196`*^9, 
   3.8482571201821003`*^9, 3.854761763962966*^9, {3.8547618360100236`*^9, 
   3.8547618598794146`*^9}, {3.883168591832553*^9, 3.8831686183106723`*^9}, {
   3.883168650240633*^9, 3.883168650334363*^9}, 3.9565290756336536`*^9, {
   3.9565292024855556`*^9, 3.9565292194190598`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ip3dConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"ImPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", "0.1"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0.01", ",", "0.01"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "8"}], ",", "2"}], "}"}], ",", "25"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221546276207`*^9}, {3.533956568630308*^9, 3.533956665834079*^9}, 
   3.533956762975449*^9, 3.534709995286988*^9, 3.5347102702566714`*^9, {
   3.534710307587537*^9, 3.5347103104111423`*^9}, {3.5355943645733566`*^9, 
   3.535594376788178*^9}, 3.535594491198779*^9, 3.5364644067701993`*^9, 
   3.5470089687325697`*^9, 3.5470091814857435`*^9, 3.547010097738553*^9, 
   3.5470101745878887`*^9, {3.5470102237747755`*^9, 3.547010237268799*^9}, {
   3.547010380711051*^9, 3.5470103817718525`*^9}, {3.5470104851844344`*^9, 
   3.547010496198054*^9}, {3.5470106544943323`*^9, 3.5470106643379498`*^9}, 
   3.5501988381617746`*^9, 3.5501990644401717`*^9, 3.5501999267834873`*^9, 
   3.55019999637521*^9, 3.5502073267184286`*^9, 3.5502076353347707`*^9, 
   3.5502077484661694`*^9, 3.550207835311522*^9, 3.5502086336303244`*^9, 
   3.550208731848097*^9, 3.550210071001249*^9, 3.550347114335082*^9, {
   3.550801163206278*^9, 3.550801166139083*^9}, 3.550801269660865*^9, 
   3.550828851690422*^9, 3.5531145252783546`*^9, 3.5531145863212614`*^9, 
   3.55311514895185*^9, {3.5531151847383127`*^9, 3.553115215641967*^9}, 
   3.553115260164445*^9, {3.5531154473135815`*^9, 3.553115448514784*^9}, 
   3.5531154849408474`*^9, 3.553184125130948*^9, 3.5531844635735426`*^9, 
   3.553184932650767*^9, {3.5531850286689353`*^9, 3.5531850425373597`*^9}, {
   3.5534455293427954`*^9, 3.553445530746798*^9}, {3.5534883365952864`*^9, 
   3.553488340932094*^9}, 3.553543103023369*^9, {3.5642903301670055`*^9, 
   3.5642903301670055`*^9}, {3.564291253782228*^9, 3.564291279803074*^9}, {
   3.564291310691128*^9, 3.5642913116739297`*^9}, 3.5642913605800157`*^9, 
   3.5642913913588696`*^9, 3.5645701775490894`*^9, 3.5645702349415903`*^9, {
   3.5645704646519933`*^9, 3.5645704806576214`*^9}, {3.564632162083235*^9, 
   3.5646321622704353`*^9}, {3.5672835744635324`*^9, 3.567283599189576*^9}, 
   3.567283658984481*^9, 3.567283712648576*^9, {3.5672837757506866`*^9, 
   3.5672838367779937`*^9}, 3.567283936711769*^9, 3.5672839671942225`*^9, 
   3.567749304927465*^9, 3.567802786200432*^9, 3.5678028867426085`*^9, 
   3.568197679377499*^9, 3.5681977398588057`*^9, {3.568197770497259*^9, 
   3.568197789934893*^9}, 3.568197954873983*^9, 3.570075573527918*^9, 
   3.5700756161159925`*^9, 3.5700766576674213`*^9, {3.570086891428359*^9, 
   3.5700868916123695`*^9}, {3.570087021291787*^9, 3.5700870234839125`*^9}, {
   3.570087084260389*^9, 3.5700871039165125`*^9}, 3.5700872267835407`*^9, {
   3.5700962429593163`*^9, 3.570096251367731*^9}, 3.5700963382910833`*^9, 
   3.573604824020702*^9, 3.573604898479633*^9, 3.5736049445153136`*^9, {
   3.5736050810779533`*^9, 3.5736051059131975`*^9}, 3.573605138158454*^9, 
   3.5736051863625383`*^9, {3.573605233568221*^9, 3.5736052565938616`*^9}, 
   3.573605861250924*^9, 3.5736059303122454`*^9, 3.5736059609350986`*^9, {
   3.573605994537558*^9, 3.5736059957855597`*^9}, 3.573606094143733*^9, 
   3.5736061630646544`*^9, {3.5736066875826025`*^9, 3.5736067019502277`*^9}, 
   3.573615827794015*^9, 3.573616064212538*^9, {3.5736161174245815`*^9, 
   3.573616176377953*^9}, 3.573616231172087*^9, 3.573616275574627*^9, {
   3.5736164520657215`*^9, 3.5736164539218273`*^9}, {3.574885930536127*^9, 
   3.574885961158981*^9}, {3.5748860538543434`*^9, 3.574886055414346*^9}, {
   3.57488610316603*^9, 3.574886104788433*^9}, 3.575772368950635*^9, 
   3.575772414543243*^9, {3.5757724483991795`*^9, 3.575772496190913*^9}, {
   3.575772614086656*^9, 3.5757726286944914`*^9}, 3.5757726590812297`*^9, {
   3.5759741411197433`*^9, 3.5759741561581697`*^9}, {3.5759742021002502`*^9, 
   3.5759742157346745`*^9}, 3.5768732485823507`*^9, {3.5768733225420804`*^9, 
   3.576873346644123*^9}, {3.5768734557819147`*^9, 3.576873461850325*^9}, {
   3.5768734924263787`*^9, 3.57687352147363*^9}, {3.5770554598819695`*^9, 
   3.577055463204776*^9}, 3.5778715362491693`*^9, {3.5778716912240334`*^9, 
   3.577871702816696*^9}, 3.5778717565767713`*^9, {3.5778718371413794`*^9, 
   3.577871932399828*^9}, 3.5779963889137025`*^9, {3.5779971639186645`*^9, 
   3.577997164261865*^9}, 3.577997327712983*^9, {3.5779973707690587`*^9, 
   3.577997383857482*^9}, 3.577997501216488*^9, {3.592182738845936*^9, 
   3.592182738861536*^9}, 3.592182944360697*^9, 3.5921830186012273`*^9, 
   3.592189432880093*^9, 3.592189463674547*^9, {3.592189504297019*^9, 
   3.592189506559023*^9}, 3.592189562375921*^9, {3.592189594262377*^9, 
   3.5921896106424055`*^9}, 3.5921897904795218`*^9, 3.592189846156019*^9, 
   3.592355462843272*^9, 3.59938841163758*^9, {3.599388677087646*^9, 
   3.599388684560059*^9}, 3.5993887418121595`*^9, 3.5993887919038477`*^9, 
   3.599389809202035*^9, 3.5994506393849616`*^9, 3.606352380183405*^9, {
   3.6063536387788167`*^9, 3.606353654363244*^9}, {3.606353693441313*^9, 
   3.6063537178865557`*^9}, 3.606354117960466*^9, {3.6063541792997737`*^9, 
   3.606354199065008*^9}, 3.606354347452469*^9, {3.606355491121396*^9, 
   3.606355500497013*^9}, {3.6063556639697*^9, 3.606355691815749*^9}, {
   3.606355951598206*^9, 3.606355974249446*^9}, 3.6063566362550087`*^9, 
   3.6063623067270436`*^9, 3.6063641073134065`*^9, 3.6063646163423004`*^9, {
   3.606424064606145*^9, 3.606424095525399*^9}, 3.606435037067684*^9, 
   3.6253066976903305`*^9, 3.6253067308559885`*^9, {3.625307148703523*^9, 
   3.6253071524163303`*^9}, 3.6253071875163918`*^9, 3.6253072177180443`*^9, {
   3.625307746315781*^9, 3.625307759903405*^9}, {3.625307823676317*^9, 
   3.625307828637126*^9}, 3.62530786493839*^9, 3.625308047693511*^9, {
   3.6253081020908065`*^9, 3.6253081157564306`*^9}, {3.6253833845823274`*^9, 
   3.6253833858459296`*^9}, 3.6253834204935904`*^9, 3.6291871979741755`*^9, 
   3.6291872594694834`*^9, {3.6291872945851455`*^9, 3.6291873218851933`*^9}, 
   3.6291877401579294`*^9, 3.6291877836352053`*^9, 3.6291878504345226`*^9, 
   3.629188085136935*^9, {3.6291893908088293`*^9, 3.62918939137043*^9}, 
   3.629412984390986*^9, {3.6296819408526163`*^9, 3.629681967825063*^9}, 
   3.6296830686522045`*^9, {3.6296838311971436`*^9, 3.629683868200409*^9}, 
   3.629684076866375*^9, 3.6296853116949444`*^9, 3.6301301057327366`*^9, 
   3.630186815320861*^9, 3.630191351912052*^9, {3.630191442251811*^9, 
   3.630191443047412*^9}, {3.6301915674264307`*^9, 3.630191567582431*^9}, 
   3.630191627034135*^9, 3.6301916686862087`*^9, {3.630191698872261*^9, 
   3.630191748199548*^9}, 3.6301925032876744`*^9, 3.6302240261576805`*^9, 
   3.6325489666245556`*^9, 3.6325493494752283`*^9, 3.632549601344486*^9, 
   3.6325497935128317`*^9, {3.6325499103370447`*^9, 3.632549935952289*^9}, {
   3.6326052493632545`*^9, 3.6326052629040785`*^9}, 3.63278969455567*^9, {
   3.632789742073353*^9, 3.632789791213439*^9}, 3.632789884486003*^9, 
   3.63279000237541*^9, 3.632798142408646*^9, 3.6327982664912643`*^9, 
   3.6328077266600885`*^9, 3.6328077568617415`*^9, {3.6328139368782277`*^9, 
   3.6328140112279577`*^9}, {3.632814042646413*^9, 3.6328140428492136`*^9}, {
   3.6328142255199356`*^9, 3.6328142422743645`*^9}, {3.6328628377011323`*^9, 
   3.6328628382471333`*^9}, 3.632863071561143*^9, 3.6328903827053213`*^9, {
   3.63450396414303*^9, 3.634503989945475*^9}, 3.634505031134311*^9, {
   3.6345050814287996`*^9, 3.6345050826300015`*^9}, {3.634505119567073*^9, 
   3.6345051390203075`*^9}, {3.63450518026678*^9, 3.6345051946500053`*^9}, {
   3.634505252089306*^9, 3.634505279467354*^9}, {3.6345559523854685`*^9, 
   3.634555955614674*^9}, 3.634556221122741*^9, {3.6360748556676345`*^9, 
   3.636074857804838*^9}, 3.6360754056294017`*^9, 3.6360755416304407`*^9, {
   3.636075572097294*^9, 3.6360755749364986`*^9}, 3.6360756677410617`*^9, 
   3.6360760229536858`*^9, {3.6360760624173627`*^9, 3.6360760925254154`*^9}, 
   3.6360761236318703`*^9, {3.636495351875679*^9, 3.636495380361329*^9}, 
   3.636495512727562*^9, 3.6364955557680373`*^9, 3.636495774451644*^9, {
   3.636495808288103*^9, 3.6364958628569994`*^9}, 3.636495995379232*^9, 
   3.6364961521595078`*^9, 3.6364963213886046`*^9, 3.636496426595189*^9, 
   3.636496986184173*^9, {3.6367624760855265`*^9, 3.636762479361532*^9}, 
   3.7255924293790016`*^9, 3.7255925317463818`*^9, 3.7255944743117948`*^9, {
   3.725594518943473*^9, 3.7255945214862776`*^9}, 3.7255953603777514`*^9, 
   3.7255957972769194`*^9, {3.7255958312537794`*^9, 3.7255958481174088`*^9}, {
   3.725596058390178*^9, 3.7255960649109898`*^9}, 3.7255963371938677`*^9, 
   3.72559640661399*^9, {3.725601386418369*^9, 3.7256014341076527`*^9}, 
   3.7257712704994154`*^9, 3.725774257093461*^9, 3.72577429072712*^9, {
   3.725774416443348*^9, 3.7257744278937683`*^9}, 3.725779901988584*^9, 
   3.72578045202995*^9, 3.7258490308793774`*^9, 3.7258521063247805`*^9, 
   3.725852262605855*^9, 3.725852360558427*^9, 3.7258524069529085`*^9, 
   3.725852753257917*^9, 3.725853436567118*^9, {3.7258534847400026`*^9, 
   3.7258535107140484`*^9}, {3.725853667353924*^9, 3.7258536787419434`*^9}, 
   3.726913461475872*^9, {3.726913506715952*^9, 3.7269135067315516`*^9}, 
   3.726913573655669*^9, 3.7269142285136194`*^9, {3.7269143657158604`*^9, 
   3.7269143772130804`*^9}, 3.726914441095193*^9, 3.7269145189861298`*^9, 
   3.726914651929563*^9, 3.7269147274648952`*^9, 3.726915143191228*^9, {
   3.7269151750932837`*^9, 3.7269151752336836`*^9}, {3.7269155027638597`*^9, 
   3.726915507599868*^9}, {3.726942965317898*^9, 3.7269429659418993`*^9}, 
   3.7269527321998544`*^9, {3.732581567667375*^9, 3.732581616495461*^9}, {
   3.732658450427137*^9, 3.732658468772769*^9}, {3.732658950832816*^9, 
   3.7326589718928533`*^9}, 3.7326593484319158`*^9, 3.7326684474112062`*^9, {
   3.740218164622918*^9, 3.740218189130562*^9}, 3.7402182402830515`*^9, {
   3.7402183944893227`*^9, 3.7402184164385605`*^9}, 3.740218476010673*^9, 
   3.740218965392333*^9, 3.7402207306098347`*^9, 3.740623523847764*^9, {
   3.7407786224156923`*^9, 3.7407786244124956`*^9}, {3.740778719260662*^9, 
   3.7407787320526843`*^9}, {3.7407792555464067`*^9, 3.7407793011608863`*^9}, 
   3.7407793394121532`*^9, {3.740779664601926*^9, 3.7407796776747484`*^9}, 
   3.7407805414526663`*^9, 3.740780576287527*^9, 3.7407807802890854`*^9, 
   3.74078247376919*^9, {3.7407839511537724`*^9, 3.7407839979846582`*^9}, 
   3.7407842696709504`*^9, {3.740784331289063*^9, 3.7407843341800685`*^9}, {
   3.740784465266109*^9, 3.7407844673429127`*^9}, 3.740784531285632*^9, 
   3.74078474467282*^9, {3.740785226216671*^9, 3.740785234380486*^9}, {
   3.74079231722311*^9, 3.740792318034312*^9}, 3.740795728899905*^9, 
   3.740795848146515*^9, 3.740796253029626*^9, 3.7407962960389013`*^9, 
   3.7407968627566967`*^9, 3.7407969034103684`*^9, {3.7411140723503017`*^9, 
   3.7411140740039043`*^9}, 3.7411141862149014`*^9, {3.7411142414077983`*^9, 
   3.7411142788634644`*^9}, {3.741114361278409*^9, 3.741114362464011*^9}, 
   3.741114397938473*^9, 3.7411144525385695`*^9, 3.741165060176092*^9, 
   3.741166736872638*^9, 3.7411668048419576`*^9, 3.741167005957511*^9, 
   3.741892706493498*^9, 3.7446637127156367`*^9, 3.744664185162467*^9, 
   3.7446656128001237`*^9, 3.7446656519561925`*^9, 3.7447503942786407`*^9, 
   3.7448755599807453`*^9, 3.7452127385678663`*^9, 3.7452130555136228`*^9, 
   3.7452134456391077`*^9, {3.7452134806767693`*^9, 3.7452134813007703`*^9}, 
   3.745213585493354*^9, 3.745213767873274*^9, {3.7452137983869276`*^9, 
   3.7452138193377643`*^9}, {3.745213904810314*^9, 3.7452139139363303`*^9}, {
   3.745213949395193*^9, 3.7452139495823927`*^9}, {3.745213986975659*^9, 
   3.74521402177932*^9}, {3.7452153772273006`*^9, 3.7452153940753307`*^9}, {
   3.7452158730613728`*^9, 3.745215903824627*^9}, {3.7452159530895133`*^9, 
   3.7452159792039595`*^9}, 3.745216259770452*^9, 3.7460520035615406`*^9, {
   3.746054453943448*^9, 3.7460544574378543`*^9}, 3.746054497295924*^9, 
   3.746054597682101*^9, {3.7460547541659756`*^9, 3.7460547746800117`*^9}, 
   3.7460548541777515`*^9, 3.746054960086337*^9, 3.746991665534811*^9, 
   3.746995590370906*^9, 3.7469956213057604`*^9, {3.746995729995552*^9, 
   3.746995731243554*^9}, {3.7469957645028124`*^9, 3.746995765407614*^9}, {
   3.746995818198107*^9, 3.7469958661213913`*^9}, {3.7469959375383167`*^9, 
   3.746995941453923*^9}, {3.747000815490528*^9, 3.7470008173313313`*^9}, {
   3.7470008849886503`*^9, 3.7470008863926525`*^9}, {3.7470275513438883`*^9, 
   3.7470275518742895`*^9}, {3.7470280525595703`*^9, 3.7470280552115746`*^9}, 
   3.7481111897753506`*^9, 3.7481112427842436`*^9, 3.748111476535054*^9, 
   3.7481115164555244`*^9, 3.7481117566959467`*^9, 3.7481117914684076`*^9, 
   3.7481118423556967`*^9, 3.7481119434438744`*^9, 3.7481119960783668`*^9, 
   3.7481126379102945`*^9, 3.7481127727725315`*^9, 3.748112894015944*^9, 
   3.7481129700816774`*^9, {3.748113028800181*^9, 3.748113030016983*^9}, 
   3.7481131110123253`*^9, 3.748114875740626*^9, 3.748152382102949*^9, 
   3.748156767894652*^9, 3.749668431509885*^9, 3.7507169249859457`*^9, {
   3.7507174668996973`*^9, 3.750717469458102*^9}, 3.750718004418642*^9, 
   3.750718074774766*^9, 3.7507181111072297`*^9, {3.7507182219610243`*^9, 
   3.7507182332866445`*^9}, 3.7507183577748632`*^9, {3.750719884635145*^9, 
   3.750719897083967*^9}, 3.750720673464531*^9, 3.7507242419383993`*^9, 
   3.7507256027451925`*^9, 3.750744003618518*^9, {3.750744093771076*^9, 
   3.7507440965790815`*^9}, 3.7511831548293476`*^9, 3.7511832008026285`*^9, {
   3.751189424649564*^9, 3.7511894256479654`*^9}, 3.7511895614618044`*^9, {
   3.7511910305075865`*^9, 3.7511910391500015`*^9}, {3.751192237613307*^9, 
   3.751192254305336*^9}, 3.751230212036337*^9, {3.751274116442066*^9, 
   3.7512741166136665`*^9}, 3.751343682541116*^9, {3.751343733085205*^9, 
   3.7513437501204348`*^9}, 3.751344238166094*^9, 3.75134430452861*^9, {
   3.751345479669874*^9, 3.7513454796854744`*^9}, 3.751345820748873*^9, {
   3.7513459524443045`*^9, 3.7513459532399063`*^9}, 3.751346262260849*^9, {
   3.751348105092086*^9, 3.7513481245765195`*^9}, {3.7513566618091145`*^9, 
   3.751356668220726*^9}, {3.751358491060729*^9, 3.7513584912323294`*^9}, {
   3.75135877156363*^9, 3.75135877173523*^9}, 3.751359211999203*^9, 
   3.755049981976758*^9, 3.7550500821133337`*^9, 3.7550501621414747`*^9, {
   3.755050416297121*^9, 3.7550504199943275`*^9}, 3.7550509388668385`*^9, 
   3.7550519367687855`*^9, {3.755051997187691*^9, 3.755052060695403*^9}, 
   3.7550521337191315`*^9, 3.7550521647007856`*^9, 3.7550613876302633`*^9, 
   3.7551379564936295`*^9, {3.755138024930949*^9, 3.7551380411237783`*^9}, 
   3.755138082682251*^9, {3.7551381845348296`*^9, 3.7551382172792873`*^9}, 
   3.7551383234530735`*^9, {3.755138441217681*^9, 3.7551385276106324`*^9}, {
   3.755138882422056*^9, 3.755138897273282*^9}, {3.7551414688371882`*^9, 
   3.7551414693363895`*^9}, 3.755142317557621*^9, 3.755143433067379*^9, {
   3.7551476031529503`*^9, 3.7551476133397684`*^9}, 3.7551478086989117`*^9, 
   3.7552236306785617`*^9, 3.7552237351007524`*^9, {3.7552275045464*^9, 
   3.7552275077132063`*^9}, 3.7642903539579687`*^9, 3.76429053655789*^9, {
   3.7642905687251463`*^9, 3.7642906105332203`*^9}, 3.764290668502922*^9, {
   3.7642907246006203`*^9, 3.764290784832326*^9}, {3.7642908265935993`*^9, 
   3.7642908360628157`*^9}, 3.7642909449510074`*^9, {3.764290981189871*^9, 
   3.764290981876272*^9}, 3.7642912047834673`*^9, {3.764291319491269*^9, 
   3.764291321378873*^9}, 3.764291611398982*^9, 3.7643023539758563`*^9, 
   3.7643023976559334`*^9, 3.764304230323553*^9, 3.7643178534248857`*^9, 
   3.7643204595866685`*^9, 3.764370162398338*^9, 3.764372959000451*^9, {
   3.7643746106161537`*^9, 3.7643746108813543`*^9}, 3.764384946199549*^9, 
   3.764385323602227*^9, 3.7646681264950523`*^9, 3.764668209284398*^9, {
   3.7646682425904565`*^9, 3.7646682533076754`*^9}, 3.764668288563737*^9, 
   3.764668544731787*^9, 3.764887973290904*^9, 3.7648880093425674`*^9, 
   3.7648889030021396`*^9, {3.7648903950293617`*^9, 3.7648904044205785`*^9}, {
   3.764890442796646*^9, 3.7648904429526463`*^9}, 3.7648906360965853`*^9, 
   3.7648967215975685`*^9, 3.765060789137452*^9, 3.7651708746726866`*^9, 
   3.7651709275255795`*^9, {3.765171589180749*^9, 3.765171597479964*^9}, {
   3.765172134970908*^9, 3.765172146390128*^9}, 3.7652588607251368`*^9, 
   3.765258911924426*^9, 3.7652678488217335`*^9, 3.766219677032467*^9, 
   3.766219733644967*^9, 3.766220209789003*^9, 3.766224738350159*^9, {
   3.766371673365609*^9, 3.7663716735372095`*^9}, {3.7664771999078894`*^9, 
   3.766477221467128*^9}, {3.7664774867923937`*^9, 3.7664775002552176`*^9}, {
   3.768845899023299*^9, 3.768845913219324*^9}, {3.768846446688262*^9, 
   3.7688464478114643`*^9}, {3.7688469105734777`*^9, 3.768846911556279*^9}, {
   3.7756127125728536`*^9, 3.775612713805256*^9}, 3.791925257473979*^9, 
   3.7919253465779333`*^9, 3.791925415545993*^9, 3.791925538329486*^9, 
   3.791925601252158*^9, {3.7919258208123755`*^9, 3.791925846181349*^9}, {
   3.7919258965132446`*^9, 3.791925926459304*^9}, {3.791926014071001*^9, 
   3.7919260175701747`*^9}, 3.7919266484290524`*^9, {3.7919272055886946`*^9, 
   3.791927235331627*^9}, {3.7919276582332497`*^9, 3.7919277101428995`*^9}, {
   3.7919283378467164`*^9, 3.7919283439703007`*^9}, 3.791928389264398*^9, 
   3.7919411413389997`*^9, 3.791941230396061*^9, 3.7919430979993715`*^9, 
   3.7919455907781906`*^9, 3.7919456413443985`*^9, 3.791945710086*^9, {
   3.791946022624746*^9, 3.791946071628796*^9}, 3.7919462750182886`*^9, {
   3.7919463468763237`*^9, 3.791946348454059*^9}, {3.7919485149966345`*^9, 
   3.7919485152934113`*^9}, 3.7921427775327096`*^9, 3.7921428844917583`*^9, {
   3.792143012102148*^9, 3.7921430326754313`*^9}, {3.7921430729159*^9, 
   3.7921430957230043`*^9}, {3.792143137525601*^9, 3.7921431788751917`*^9}, 
   3.792143236720871*^9, {3.7921435062050405`*^9, 3.7921435066268454`*^9}, {
   3.792144999623945*^9, 3.792145021384448*^9}, {3.7921451021622267`*^9, 
   3.7921451511037264`*^9}, 3.792145185720539*^9, {3.7921455447136655`*^9, 
   3.792145545432212*^9}, {3.792184507470749*^9, 3.7921845096108675`*^9}, 
   3.792184641720213*^9, {3.792206627246333*^9, 3.792206627246333*^9}, 
   3.792206751388796*^9, {3.792206853864559*^9, 3.7922068746252704`*^9}, 
   3.7922073162553945`*^9, 3.7922074838563423`*^9, {3.792207902303128*^9, 
   3.7922079240167284`*^9}, 3.792210628560286*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709171055946`*^9, 3.7922709214014473`*^9}, 
   3.7922710012262707`*^9, 3.7922710487775407`*^9, {3.7922714048807282`*^9, 
   3.792271416690432*^9}, {3.7922722543810005`*^9, 3.7922722888259625`*^9}, 
   3.7922726333057737`*^9, 3.792538656581356*^9, 3.79253893338968*^9, {
   3.79253897772618*^9, 3.792538997607256*^9}, {3.7925390932423153`*^9, 
   3.7925390962103596`*^9}, 3.792539159820304*^9, 3.792539240269972*^9, {
   3.7925532546452465`*^9, 3.7925533205046535`*^9}, {3.792553601937978*^9, 
   3.7925536273538704`*^9}, 3.79255397433422*^9, 3.7934110830440025`*^9, 
   3.8025467812543383`*^9, 3.8025468240567527`*^9, 3.8025528269104867`*^9, 
   3.802553052279233*^9, 3.802553090613947*^9, {3.802553138758854*^9, 
   3.802553139914831*^9}, {3.8025532126007967`*^9, 3.802553250295064*^9}, {
   3.802553594834815*^9, 3.8025536101749134`*^9}, {3.8025798116085243`*^9, 
   3.8025798132175207`*^9}, 3.802579945624563*^9, 3.802582701183984*^9, 
   3.807854563419881*^9, 3.807854694546463*^9, {3.8078547295149803`*^9, 
   3.8078547561408234`*^9}, {3.8078547919860497`*^9, 3.8078548304791474`*^9}, 
   3.8078548606684666`*^9, 3.807855083466024*^9, 3.816906053582398*^9, 
   3.8169062224342117`*^9, {3.8169062988381157`*^9, 3.8169063060864477`*^9}, 
   3.8169064065628595`*^9, 3.816906461050069*^9, {3.8169064993379393`*^9, 
   3.8169065035244703`*^9}, 3.8169065362667856`*^9, 3.8169065845523252`*^9, 
   3.816906745967521*^9, 3.816906908810424*^9, 3.816911860153344*^9, {
   3.8208065344321394`*^9, 3.8208065372752233`*^9}, {3.8208066098049192`*^9, 
   3.820806629253437*^9}, {3.8208067246527057`*^9, 3.820806757035666*^9}, 
   3.820806846764411*^9, 3.820806898986417*^9, {3.8208069817158995`*^9, 
   3.8208069962436466`*^9}, 3.8208070567761927`*^9, 3.8208071646412573`*^9, {
   3.827874604510014*^9, 3.8278746309881845`*^9}, 3.8282861305022345`*^9, {
   3.8282861822244864`*^9, 3.8282862225431395`*^9}, 3.8282862526298304`*^9, 
   3.8282862842161703`*^9, 3.828286431179902*^9, 3.8282865552758007`*^9, 
   3.8288490182376804`*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571656713667`*^9, 3.8482572003506775`*^9}, 3.848257241247275*^9, 
   3.848259231776729*^9, 3.848259267571465*^9, 3.848259344803232*^9, 
   3.848259673414655*^9, {3.848259861051252*^9, 3.848259867143531*^9}, {
   3.848259941470792*^9, 3.8482599439389577`*^9}, 3.8482600898263903`*^9, 
   3.848260640619811*^9, 3.8482608256478395`*^9, {3.8482609065250673`*^9, 
   3.848260907681044*^9}, {3.8547617639785867`*^9, 3.8547617639785867`*^9}, 
   3.854761809702217*^9, {3.854761942224519*^9, 3.8547619519097843`*^9}, {
   3.8547622351085224`*^9, 3.854762249654128*^9}, 3.854762371152464*^9, 
   3.8547635232989454`*^9, 3.8831684232624483`*^9, 3.8831685493113613`*^9, 
   3.883168591832553*^9, {3.883169010827317*^9, 3.883169014857577*^9}, 
   3.883169424066017*^9, {3.8831694760850053`*^9, 3.8831694856764994`*^9}, 
   3.883170656625969*^9, 3.8831708592182693`*^9, {3.9565290756336536`*^9, 
   3.9565290756336536`*^9}, 3.956529278342761*^9, 3.9565293333611*^9, {
   3.956529367509301*^9, 3.9565293704148693`*^9}, 3.9565294729845495`*^9, 
   3.9565295110113583`*^9, {3.956529552879578*^9, 3.956529563252109*^9}, 
   3.9565298355156817`*^9, 3.9565299092171383`*^9, {3.95653017492978*^9, 
   3.9565301806784286`*^9}, 3.956530444152749*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0160.png\>\"", ",", "ip3dConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5339551753718605`*^9, 3.5339551977422996`*^9}, 
   3.5470088994684477`*^9, 3.5470089727417765`*^9, {3.5501987561524305`*^9, 
   3.55019875626163*^9}, 3.5501988411413794`*^9, {3.550469316159321*^9, 
   3.550469316393321*^9}, {3.5531142826767282`*^9, 3.5531142878403373`*^9}, 
   3.553114589410067*^9, 3.5531850735502143`*^9, 3.5531852580361385`*^9, 
   3.553190088148943*^9, 3.5531901617342725`*^9, 3.553190880875136*^9, {
   3.553190965255684*^9, 3.5531909657236853`*^9}, {3.553213796837209*^9, 
   3.5532138090832305`*^9}, {3.553214132081798*^9, 3.5532141604270477`*^9}, {
   3.55638959965485*^9, 3.5563895998420506`*^9}, 3.5563898856657524`*^9, {
   3.732581228351179*^9, 3.73258122874118*^9}, 3.7326535161424675`*^9, {
   3.732659131075533*^9, 3.7326591312627335`*^9}, 3.7326593484475155`*^9, 
   3.7402167509844255`*^9, 3.740218243403057*^9, 3.74021899790279*^9, 
   3.740778626643299*^9, {3.740780616519998*^9, 3.7407806166603985`*^9}, 
   3.7407823179717164`*^9, {3.740795712629077*^9, 3.7407957267315016`*^9}, 
   3.7411140764375086`*^9, {3.741114125515195*^9, 3.741114125671195*^9}, 
   3.741166734985035*^9, {3.741166859442054*^9, 3.7411668600660543`*^9}, {
   3.741421137522071*^9, 3.741421137662471*^9}, 3.7446637165064435`*^9, 
   3.7446643950296354`*^9, 3.7446656128001237`*^9, {3.7446659247070713`*^9, 
   3.7446659248786716`*^9}, 3.7452127427798734`*^9, {3.7452127929651613`*^9, 
   3.745212793152362*^9}, 3.7452152142298145`*^9, 3.7452153921565275`*^9, 
   3.7460520052775435`*^9, {3.746052046134015*^9, 3.746052046851617*^9}, 
   3.74605511521301*^9, 3.7469914820784883`*^9, {3.746991523184561*^9, 
   3.74699155112421*^9}, 3.746991670152419*^9, 3.748111192864156*^9, {
   3.748111336868009*^9, 3.7481113370708094`*^9}, 3.748112636022691*^9, 
   3.748113214284507*^9, {3.7507168278133755`*^9, 3.7507168307305803`*^9}, 
   3.7507169297439537`*^9, 3.7509079022215652`*^9, {3.750907940301232*^9, 
   3.7509079404728317`*^9}, 3.7509082696334105`*^9, 3.751350024917858*^9, 
   3.7513500920291758`*^9, {3.7513503405844126`*^9, 3.751350340787213*^9}, 
   3.7514002188533993`*^9, {3.7550496972606583`*^9, 3.7550496974946585`*^9}, {
   3.75504978959722*^9, 3.7550497905488214`*^9}, 3.755049981976758*^9, 
   3.762283559846346*^9, {3.762283605102025*^9, 3.762283605258025*^9}, 
   3.7622837044741993`*^9, 3.764280957785819*^9, 3.7642809971446877`*^9, {
   3.7642810687488136`*^9, 3.764281091244053*^9}, {3.764281218056676*^9, 
   3.764281218197076*^9}, 3.764281300721221*^9, 3.76429146773833*^9, 
   3.7642915623056955`*^9, 3.7646644254533424`*^9, {3.764664539785943*^9, 
   3.7646645399731436`*^9}, {3.7648873980398936`*^9, 3.7648873981958942`*^9}, 
   3.764887973290904*^9, {3.764889416149441*^9, 3.7648894163366413`*^9}, {
   3.7650602413440895`*^9, 3.76506024151569*^9}, 3.765060791461856*^9, 
   3.765087677377597*^9, {3.765170815548583*^9, 3.7651708157513833`*^9}, 
   3.7651708746726866`*^9, 3.765258911924426*^9, {3.765259059017085*^9, 
   3.765259059188685*^9}, 3.766219554353852*^9, {3.766219588096711*^9, 
   3.766219588315111*^9}, 3.766219677048067*^9, 3.7662202121290073`*^9, 
   3.7664771999078894`*^9, 3.766477339294134*^9, 3.7664774867923937`*^9, 
   3.766477573575346*^9, {3.76661193684249*^9, 3.7666119369516907`*^9}, {
   3.767393932285303*^9, 3.7673939324413033`*^9}, 3.7688458990388994`*^9, 
   3.768845992139863*^9, 3.7688461103100705`*^9, 3.7919252574896*^9, 
   3.791926049453236*^9, {3.7919260861008263`*^9, 3.791926086913168*^9}, 
   3.791941139339487*^9, 3.7919412617480307`*^9, {3.791945592480884*^9, 
   3.7919456060870748`*^9}, 3.7921427775483007`*^9, {3.7921442451353717`*^9, 
   3.792144245338449*^9}, 3.792145001857826*^9, {3.792145054236045*^9, 
   3.7921450544235*^9}, 3.792206627246333*^9, {3.792208155180749*^9, 
   3.7922081559774384`*^9}, 3.7922705977593207`*^9, {3.7922707237138777`*^9, 
   3.792270723791984*^9}, 3.79253865659698*^9, 3.792554032117412*^9, 
   3.8025468267904854`*^9, {3.802546894868189*^9, 3.802546913582498*^9}, 
   3.8025516394640093`*^9, {3.8025798091715994`*^9, 3.802579817638352*^9}, 
   3.8078544431792603`*^9, {3.8078544925433044`*^9, 3.8078544933671336`*^9}, 
   3.807854566519637*^9, 3.816906057737702*^9, 3.816906822971233*^9, 
   3.8169068639616127`*^9, 3.8208064318782806`*^9, {3.8208064621211166`*^9, 
   3.820806462214844*^9}, 3.820806541039958*^9, {3.8278746045256357`*^9, 
   3.8278746309881845`*^9}, 3.827874859287332*^9, {3.827874908775693*^9, 
   3.827874908963181*^9}, 3.828286648410184*^9, 3.8482570386700907`*^9, 
   3.8482570746303196`*^9, 3.848257124337367*^9, 3.854761763994209*^9, {
   3.8547618395248256`*^9, 3.854761864503364*^9}, {3.883168591832553*^9, 
   3.8831686183106723`*^9}, {3.883168654880164*^9, 3.8831686550051346`*^9}, 
   3.956529075649271*^9, {3.9565292024855556`*^9, 3.95652922354312*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"frpConfHypergeomF1", "=", "\[IndentingNewLine]", 
  RowBox[{"FundamentalRegionPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "0.1"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"400", ",", "600"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "16"}], ",", "22"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.530344234110747*^9, 3.530344269600809*^9, {3.53395684314399*^9, 
   3.5339568911608744`*^9}, {3.533956924529333*^9, 3.533956959972595*^9}, {
   3.533957001359468*^9, 3.5339570248843093`*^9}, {3.5346482317806273`*^9, 
   3.5346482369130363`*^9}, {3.5346484132401457`*^9, 3.534648422927763*^9}, {
   3.534648600908476*^9, 3.534648602874079*^9}, 3.534710001277398*^9, {
   3.534710275763481*^9, 3.5347102880095024`*^9}, {3.534710723484267*^9, 
   3.5347107275246744`*^9}, {3.534710781017168*^9, 3.534710781219969*^9}, {
   3.5347108477228856`*^9, 3.5347108501564903`*^9}, {3.536464399328986*^9, 
   3.5364644013413897`*^9}, 3.5470089850033984`*^9, {3.547009186867753*^9, 
   3.547009193606965*^9}, {3.5470101014513597`*^9, 3.5470101345858183`*^9}, 
   3.5470103852662587`*^9, 3.5501988466325893`*^9, 3.550199068246578*^9, {
   3.5502084668036313`*^9, 3.5502084670064316`*^9}, 3.550208582867835*^9, 
   3.550210551794093*^9, 3.5502106958603463`*^9, {3.550798929203307*^9, 
   3.5507989293125067`*^9}, 3.5531145282735596`*^9, 3.55311459660168*^9, 
   3.553115153538258*^9, 3.553115190603923*^9, 3.553115426549945*^9, 
   3.5531841290621552`*^9, 3.553184841780607*^9, 3.553185595402331*^9, {
   3.5642903301826057`*^9, 3.5642903301826057`*^9}, {3.564291282969879*^9, 
   3.56429128880429*^9}, 3.564291394822076*^9, 3.5645701814958963`*^9, 
   3.564570242882004*^9, {3.564570442328354*^9, 3.5645704448087587`*^9}, 
   3.5646312482712297`*^9, 3.564632058343053*^9, {3.5646323584975805`*^9, 
   3.5646323647687917`*^9}, 3.564706563514888*^9, {3.5647069832336254`*^9, 
   3.564706991033639*^9}, {3.564989542386684*^9, 3.56498954572509*^9}, {
   3.5651175773891916`*^9, 3.565117582833601*^9}, {3.567283577864339*^9, 
   3.5672835875051556`*^9}, {3.5672836659264936`*^9, 
   3.5672836766593122`*^9}, {3.567283716548582*^9, 3.567283718576586*^9}, 
   3.567283973247033*^9, 3.56728425586953*^9, {3.5672842997836075`*^9, 
   3.567284320703244*^9}, 3.5672843556005054`*^9, 3.5677493102314744`*^9, 
   3.56780279067764*^9, 3.567802890923416*^9, {3.567802966739549*^9, 
   3.5678029668955493`*^9}, 3.5681976926063223`*^9, 3.5681977453968153`*^9, {
   3.568197813974536*^9, 3.568197826126957*^9}, {3.5681978838782587`*^9, 
   3.568197918401119*^9}, 3.5700755786291265`*^9, {3.5700756190487976`*^9, 
   3.5700756257724094`*^9}, {3.570086895267579*^9, 3.570086895443589*^9}, 
   3.570087027747156*^9, 3.5700870928118777`*^9, 3.5700872352950277`*^9, {
   3.570096246297722*^9, 3.5700962494177275`*^9}, 3.570606665466712*^9, 
   3.573604837639526*^9, 3.5736049030816407`*^9, 3.5736049498193226`*^9, {
   3.5736050854147615`*^9, 3.573605109750804*^9}, 3.5736051427448616`*^9, {
   3.5736052053321714`*^9, 3.573605205519372*^9}, {3.573605408179328*^9, 
   3.573605433950573*^9}, 3.5736058570857162`*^9, 3.5736059335570507`*^9, 
   3.573605964039504*^9, 3.5736059994827666`*^9, 3.5736060984805403`*^9, {
   3.573606625978094*^9, 3.5736066285832987`*^9}, 3.5736158211856375`*^9, 
   3.5736160693318305`*^9, 3.5736161223258615`*^9, {3.573616182105281*^9, 
   3.573616182321293*^9}, 3.573616236132371*^9, 3.5736164232410727`*^9, {
   3.573692298777257*^9, 3.5736923146424847`*^9}, {3.574885935637336*^9, 
   3.5748859559173717`*^9}, {3.574886059891554*^9, 3.574886060063154*^9}, 
   3.5748861763301587`*^9, 3.57488628534315*^9, 3.575772379966265*^9, {
   3.5757724207015953`*^9, 3.5757725117098007`*^9}, {3.575772591741378*^9, 
   3.5757725927734375`*^9}, {3.575772672229982*^9, 3.5757726811024895`*^9}, 
   3.5757893795025835`*^9, {3.5759741275789194`*^9, 3.5759741492005577`*^9}, 
   3.5759742049082556`*^9, 3.576873260313571*^9, {3.5768733266760874`*^9, 
   3.5768733636481524`*^9}, {3.576961566809566*^9, 3.576961566965566*^9}, 
   3.5778715430075555`*^9, {3.577871696168316*^9, 3.5778716991834884`*^9}, {
   3.577871760471994*^9, 3.5778717880315704`*^9}, 3.5778726548461494`*^9, 
   3.577996394467312*^9, {3.577996527223545*^9, 3.5779965332763557`*^9}, 
   3.5780020367826004`*^9, {3.592182738877136*^9, 3.592182738877136*^9}, 
   3.592182948245104*^9, 3.592183023967637*^9, {3.5921894148308616`*^9, 
   3.5921894250800796`*^9}, 3.592189468058155*^9, 3.59218951063063*^9, {
   3.5921897614790707`*^9, 3.5921897687174835`*^9}, {3.5921898718180647`*^9, 
   3.5921898746416693`*^9}, 3.592190089781647*^9, 3.599383290830182*^9, 
   3.606352387733818*^9, {3.6063536447692275`*^9, 3.6063536521324406`*^9}, {
   3.6063536981837215`*^9, 3.606353720959761*^9}, {3.6063540035186653`*^9, 
   3.60635401782389*^9}, {3.606354435187023*^9, 3.606354443579838*^9}, {
   3.606355512883435*^9, 3.6063555243806553`*^9}, {3.606355667978907*^9, 
   3.606355694748554*^9}, {3.6063559545934114`*^9, 3.60635597637105*^9}, 
   3.6063566455526247`*^9, 3.606364112430215*^9, {3.606364199790369*^9, 
   3.606364203237975*^9}, 3.6063646197275066`*^9, 3.606367676083275*^9, {
   3.625306705256344*^9, 3.6253067345531955`*^9}, {3.6253071577203393`*^9, 
   3.625307191275998*^9}, {3.6253072256584587`*^9, 3.625307230572467*^9}, 
   3.625307268620934*^9, {3.625307476549307*^9, 3.6253074769705076`*^9}, {
   3.6253081892637596`*^9, 3.6253082416486516`*^9}, 3.6253530322619123`*^9, 
   3.6253833808227205`*^9, 3.6253834171083846`*^9, 3.6291872118269997`*^9, {
   3.629187263494291*^9, 3.629187284616728*^9}, 3.6291873266120014`*^9, 
   3.629187811262854*^9, 3.629187845489314*^9, 3.6291893763632035`*^9, {
   3.6292328386751413`*^9, 3.6292328506403627`*^9}, 3.6294129869649906`*^9, {
   3.629681940868216*^9, 3.629681967840663*^9}, {3.629683072302611*^9, 
   3.629683104204667*^9}, 3.6296834256744313`*^9, 3.62968375522501*^9, 
   3.6296908987102036`*^9, 3.630130105748337*^9, 3.6301868181132655`*^9, {
   3.630191355032058*^9, 3.6301913594624653`*^9}, 3.6301916306065416`*^9, {
   3.6301917699615865`*^9, 3.63019186320295*^9}, {3.630192661908753*^9, 
   3.6301926650911584`*^9}, {3.6301964589726305`*^9, 3.6301964616870356`*^9}, 
   3.630397911894512*^9, 3.631494715345451*^9, {3.631494897830179*^9, 
   3.6314948980173793`*^9}, 3.6325489741749687`*^9, 3.632549352439234*^9, 
   3.632549606008894*^9, {3.6325498031224484`*^9, 3.6325498272824984`*^9}, 
   3.6325498689969716`*^9, 3.632603972588211*^9, {3.6326052512664576`*^9, 
   3.63260525814607*^9}, 3.6326054984956923`*^9, 3.632789700000079*^9, 
   3.632789744647358*^9, {3.632789801166257*^9, 3.632789811633875*^9}, 
   3.6327900076794195`*^9, {3.6327981115517917`*^9, 3.632798133781831*^9}, 
   3.632798223201188*^9, {3.6328077370497065`*^9, 3.632807759903747*^9}, 
   3.6328139472210455`*^9, 3.632814030665592*^9, {3.6328142522895823`*^9, 
   3.6328142524611826`*^9}, {3.632862843129942*^9, 3.632862843800743*^9}, 
   3.63286308115516*^9, 3.6328903786025143`*^9, {3.634503967294235*^9, 
   3.6345039716310434`*^9}, {3.634505033567916*^9, 3.6345050472023396`*^9}, {
   3.6345052904809732`*^9, 3.6345052910893745`*^9}, {3.634505400581773*^9, 
   3.634505441906245*^9}, {3.634505494244337*^9, 3.6345055070207596`*^9}, {
   3.6345055797168875`*^9, 3.6345055799040875`*^9}, 3.6345562254439487`*^9, {
   3.6345563039276867`*^9, 3.6345563048948884`*^9}, 3.634556840334629*^9, {
   3.636074869723259*^9, 3.6360748731240654`*^9}, 3.6360754084218063`*^9, {
   3.6360755439392443`*^9, 3.636075558915271*^9}, {3.636075874067024*^9, 
   3.6360758917886553`*^9}, {3.6364953559316864`*^9, 3.636495366508505*^9}, {
   3.6364954773934994`*^9, 3.636495502852744*^9}, {3.636495534396*^9, 
   3.6364955371572046`*^9}, {3.6364955872176924`*^9, 3.63649567827066*^9}, 
   3.636495724504749*^9, {3.636495894244254*^9, 3.6364959362083282`*^9}, {
   3.6364963754739*^9, 3.636496380231908*^9}, {3.636497028007847*^9, 
   3.6364970357610607`*^9}, {3.6367624922783546`*^9, 
   3.6367624954763603`*^9}, {3.6367923982578783`*^9, 3.636792403624288*^9}, 
   3.725592414137775*^9, 3.72559253645759*^9, {3.725595004057525*^9, 
   3.725595014041543*^9}, 3.7255952212879066`*^9, 3.7255953656817603`*^9, 
   3.7255956160982013`*^9, {3.725595650901862*^9, 3.7255956517442636`*^9}, {
   3.725595707529962*^9, 3.7255957181379805`*^9}, {3.7255957501492367`*^9, 
   3.7255957539400434`*^9}, {3.7255961085130663`*^9, 3.72559611623508*^9}, 
   3.725596322436242*^9, 3.7255964148976045`*^9, {3.7257712777690277`*^9, 
   3.7257712801558323`*^9}, 3.725773155528726*^9, 3.725774260463067*^9, {
   3.7257742995099354`*^9, 3.7257743102739544`*^9}, 3.725774372830064*^9, 
   3.7257745020094986`*^9, 3.7258490354189854`*^9, 3.72585211170679*^9, 
   3.7258523136023445`*^9, 3.725852357064021*^9, 3.725852412709319*^9, 
   3.725852690077806*^9, {3.7258529112549944`*^9, 3.725852914297*^9}, 
   3.725866558776852*^9, 3.726913461475872*^9, {3.7269135067471514`*^9, 
   3.7269135067471514`*^9}, 3.7269135736712694`*^9, 3.7269142332092276`*^9, 
   3.726914379943085*^9, {3.72691444512*^9, 3.72691444551*^9}, 
   3.726914522230935*^9, {3.7269150197170105`*^9, 3.726915029623028*^9}, 
   3.7269154806118207`*^9, 3.7269429541638784`*^9, 3.726943055174056*^9, 
   3.7269527416378713`*^9, {3.7325816271502795`*^9, 3.73258171281003*^9}, {
   3.732658455138345*^9, 3.7326584615967565`*^9}, 3.7326589054523363`*^9, 
   3.7326593484475155`*^9, 3.732665438975348*^9, {3.7402181674777236`*^9, 
   3.740218192921368*^9}, 3.7402182516554713`*^9, 3.7402183778596935`*^9, {
   3.7402184897074966`*^9, 3.7402184899102974`*^9}, 3.740218703693073*^9, 
   3.740219316174549*^9, 3.740220725664626*^9, 3.7406235299785748`*^9, 
   3.7407786300441055`*^9, {3.7407787374658937`*^9, 3.7407787515059185`*^9}, 
   3.7407792597116137`*^9, {3.740779291410869*^9, 3.74077929150447*^9}, {
   3.7407794435579367`*^9, 3.7407794537603545`*^9}, {3.740779489359617*^9, 
   3.7407794895936174`*^9}, {3.740779670623536*^9, 3.7407796794843516`*^9}, 
   3.740780547224676*^9, 3.740780580078334*^9, {3.7407807829566903`*^9, 
   3.740780802675125*^9}, 3.7407824785895987`*^9, {3.740783120387927*^9, 
   3.7407831238823338`*^9}, 3.740784281084571*^9, 3.7407843527561016`*^9, 
   3.7407847831226892`*^9, 3.740792340872752*^9, 3.740795723424296*^9, 
   3.7407958523585224`*^9, 3.7407962560248313`*^9, 3.740796299814108*^9, 
   3.740796868840708*^9, 3.7407969075287757`*^9, {3.7411140798071146`*^9, 
   3.7411140827087193`*^9}, 3.7411141905985093`*^9, {3.7411142267125726`*^9, 
   3.7411142268685727`*^9}, {3.741114330047154*^9, 3.7411143512943916`*^9}, {
   3.741114411151696*^9, 3.741114418093709*^9}, 3.7411667320210295`*^9, 
   3.7411668087419643`*^9, 3.741202221929366*^9, 3.741892837970529*^9, 
   3.7446637237292566`*^9, 3.744664188516473*^9, 3.7446656128157234`*^9, 
   3.7446656519561925`*^9, 3.744742920198707*^9, 3.744748993426978*^9, 
   3.744875562242749*^9, 3.7452127485518837`*^9, {3.7452134494767146`*^9, 
   3.7452134887263837`*^9}, 3.7452135890501595`*^9, 3.7452136909027386`*^9, {
   3.745213776375289*^9, 3.745213824891374*^9}, {3.7452153796921053`*^9, 
   3.7452153895513225`*^9}, {3.745215679480633*^9, 3.7452156795430326`*^9}, {
   3.7452158443729224`*^9, 3.7452158470717273`*^9}, 3.745216263249258*^9, 
   3.745220775675985*^9, 3.74605200870955*^9, {3.746054459278658*^9, 
   3.746054461899462*^9}, {3.746054502833934*^9, 3.7460545099319468`*^9}, {
   3.7460545513812194`*^9, 3.746054580834071*^9}, 3.746054715181507*^9, {
   3.746055056728507*^9, 3.746055078334545*^9}, {3.7460696676769714`*^9, 
   3.746069675196185*^9}, {3.746069717519059*^9, 3.7460697568623285`*^9}, {
   3.746069787937583*^9, 3.74606981489443*^9}, 3.746073742165717*^9, 
   3.7460738199942536`*^9, 3.74607396574531*^9, {3.7460739981621666`*^9, 
   3.7460740214218073`*^9}, {3.7460741612292533`*^9, 3.7460741660964613`*^9}, 
   3.7460742930026846`*^9, 3.7469916783892336`*^9, {3.746995596376917*^9, 
   3.7469956449086018`*^9}, 3.746995874717006*^9, {3.746995951484741*^9, 
   3.7469959562115493`*^9}, {3.7469960042752333`*^9, 
   3.7469960100160437`*^9}, {3.7470008209349375`*^9, 3.747000823181341*^9}, {
   3.747000889419058*^9, 3.7470008910414605`*^9}, {3.7470280589399815`*^9, 
   3.7470280614983854`*^9}, {3.748111197232164*^9, 3.7481112317394247`*^9}, 
   3.74811147967066*^9, 3.7481115205271316`*^9, 3.748111692642234*^9, 
   3.7481117874748*^9, 3.748112631498683*^9, 3.748112775284136*^9, 
   3.7481129517516456`*^9, {3.748113151322796*^9, 3.7481131579684076`*^9}, 
   3.7481148652730074`*^9, 3.748152386065356*^9, 3.7481567738382626`*^9, 
   3.749668436049493*^9, 3.75071693891677*^9, 3.7507175127325783`*^9, 
   3.7507180095666513`*^9, 3.7507180789087734`*^9, 3.7507182048633947`*^9, 
   3.7507183299756145`*^9, {3.750719880875539*^9, 3.750719881031539*^9}, 
   3.750720705694188*^9, 3.7507440057557216`*^9, {3.750744086719864*^9, 
   3.750744089496669*^9}, 3.7509082696490107`*^9, 3.7509083249043074`*^9, 
   3.750911286246544*^9, 3.7509118911532063`*^9, 3.7509121115503936`*^9, {
   3.750923632836231*^9, 3.750923632961032*^9}, 3.750925073460763*^9, 
   3.750927718913814*^9, 3.7513499450769176`*^9, 3.7513500249334583`*^9, 
   3.751350205394575*^9, {3.751357124693128*^9, 3.751357125535529*^9}, 
   3.7513572227785015`*^9, {3.7513577543338346`*^9, 3.7513577545366354`*^9}, {
   3.7514075994397964`*^9, 3.7514076315758533`*^9}, 3.755049981992358*^9, 
   3.7550500823161345`*^9, 3.7550501621414747`*^9, {3.755050424627536*^9, 
   3.75505042743554*^9}, 3.7550509452316504`*^9, {3.7550519417295938`*^9, 
   3.755051975534853*^9}, 3.755137950815219*^9, {3.755138029314557*^9, 
   3.755138038986574*^9}, 3.755138086785058*^9, {3.755138188762437*^9, 
   3.7551382198688917`*^9}, 3.755138327743081*^9, {3.7551385822731285`*^9, 
   3.7551385983567567`*^9}, {3.7551386797264996`*^9, 3.755138682924505*^9}, {
   3.755138886446863*^9, 3.7551388934044757`*^9}, 3.75514146393878*^9, 
   3.7551414955444355`*^9, 3.755142322019229*^9, 3.755143438106188*^9, 
   3.755147618487777*^9, 3.7552236306785617`*^9, 3.755223735116352*^9, {
   3.755225733931464*^9, 3.7552257365054693`*^9}, {3.755227512081214*^9, 
   3.755227512237214*^9}, 3.7552279693180175`*^9, 3.7642903496367607`*^9, 
   3.7642905384454937`*^9, {3.764290573888756*^9, 3.7642906052136106`*^9}, 
   3.764290664977316*^9, {3.7642906962553706`*^9, 3.7642907377670436`*^9}, 
   3.7642907697626996`*^9, {3.7642908862013044`*^9, 3.7642908919733143`*^9}, {
   3.764290988459484*^9, 3.7642909895202856`*^9}, 3.7642916178573933`*^9, 
   3.7642946900651903`*^9, 3.764304233178358*^9, 3.764315634831588*^9, 
   3.7643178571376925`*^9, 3.7643199679870043`*^9, 3.7646643825688667`*^9, 
   3.7646644254533424`*^9, {3.7646670587823772`*^9, 3.7646670614031816`*^9}, {
   3.7646689741957426`*^9, 3.7646689743361425`*^9}, 3.7648879733065042`*^9, 
   3.7648880095453677`*^9, 3.764888905544944*^9, {3.7648904306286244`*^9, 
   3.764890430784625*^9}, 3.764890639856192*^9, 3.7648920316777287`*^9, 
   3.7648920799130135`*^9, {3.7649026496400437`*^9, 3.764902649811644*^9}, 
   3.765060795861064*^9, 3.765170874688287*^9, 3.7651709275255795`*^9, 
   3.7651715934707565`*^9, 3.765171678553306*^9, 3.7651720873988247`*^9, 
   3.7652588609279366`*^9, 3.7652589119400263`*^9, {3.7652678534549417`*^9, 
   3.765267853720142*^9}, 3.766219677048067*^9, 3.766219733644967*^9, 
   3.7662202150930123`*^9, 3.7662231492289677`*^9, 3.7662232546071525`*^9, 
   3.7664261773697233`*^9, {3.7664771999234896`*^9, 3.766477221467128*^9}, {
   3.7664774867923937`*^9, 3.7664775002552176`*^9}, {3.7688458990388994`*^9, 
   3.7688459132349243`*^9}, 3.7688464502450686`*^9, 3.7688469138338833`*^9, 
   3.7919252574896*^9, 3.7919253465779333`*^9, {3.791925415764722*^9, 
   3.7919254377907343`*^9}, {3.791925604735676*^9, 3.791925624980929*^9}, 
   3.791925707745304*^9, 3.791925763091635*^9, {3.791925911291008*^9, 
   3.7919259140403547`*^9}, {3.7919260222877755`*^9, 3.7919260262243795`*^9}, 
   3.7919263244810195`*^9, 3.7919272129150743`*^9, 3.7919273025813866`*^9, 
   3.79194113621521*^9, 3.791941232926713*^9, {3.791941514157159*^9, 
   3.7919415143290224`*^9}, 3.791943103216889*^9, 3.791945596183156*^9, 
   3.7919456441249638`*^9, 3.791946082173215*^9, 3.7919462651924844`*^9, 
   3.7921427775483007`*^9, 3.7921428897561445`*^9, {3.7921430152576857`*^9, 
   3.7921430359090414`*^9}, 3.7921430673703427`*^9, {3.792143141259096*^9, 
   3.7921431417121143`*^9}, 3.792143242125839*^9, 3.792143486850278*^9, {
   3.7921450052007465`*^9, 3.792145013042673*^9}, {3.7921451058956823`*^9, 
   3.7921451214857616`*^9}, 3.7921455314668036`*^9, {3.792206627246333*^9, 
   3.792206627246333*^9}, 3.792206754231901*^9, 3.79220685052157*^9, 
   3.7922078842917633`*^9, {3.7922705977593207`*^9, 3.7922705977593207`*^9}, {
   3.7922709118099704`*^9, 3.792270911903698*^9}, 3.792271385291582*^9, 
   3.792272246914014*^9, 3.79253865659698*^9, 3.7925389383292637`*^9, {
   3.79253897772618*^9, 3.7925390027310505`*^9}, 3.792539084603735*^9, 
   3.792539165209653*^9, {3.7925532584724584`*^9, 3.792553265876953*^9}, {
   3.7925536738897276`*^9, 3.7925536950096927`*^9}, 3.792553901929451*^9, 
   3.7925547774031987`*^9, 3.7926564191426325`*^9, 3.802546784503578*^9, 
   3.8025468351166477`*^9, {3.802547157478155*^9, 3.8025471596963935`*^9}, 
   3.8025530393291664`*^9, {3.802553145023003*^9, 3.8025531542395735`*^9}, {
   3.8025532156626034`*^9, 3.802553248326777*^9}, {3.8025534886879206`*^9, 
   3.802553504246724*^9}, {3.8025797911758394`*^9, 3.8025798028293123`*^9}, {
   3.8025800334054585`*^9, 3.802580033577258*^9}, 3.802582705776685*^9, 
   3.807854574938098*^9, 3.8078546986654563`*^9, {3.8078547333297863`*^9, 
   3.8078547854564734`*^9}, 3.80785486835991*^9, 3.807855055961532*^9, 
   3.816906071203289*^9, 3.8169062277454643`*^9, {3.816906300915784*^9, 
   3.8169063034933043`*^9}, 3.8169064130613346`*^9, 3.816906495104565*^9, 
   3.816906610405632*^9, 3.816906749379136*^9, 3.816907241217867*^9, 
   3.8169118516709604`*^9, {3.8208065480383034`*^9, 3.8208065503971148`*^9}, {
   3.8208066149286785`*^9, 3.820806624051549*^9}, {3.8208067216221795`*^9, 
   3.8208067220908184`*^9}, 3.8208068322209473`*^9, 3.820807172858101*^9, {
   3.8278746045256357`*^9, 3.8278746309881845`*^9}, {3.8282860508815856`*^9, 
   3.8282860579267845`*^9}, {3.8282861859735947`*^9, 3.8282862018448706`*^9}, 
   3.828286468280572*^9, 3.828553587454216*^9, 3.8285574082753267`*^9, {
   3.8286362338967395`*^9, 3.828636255175177*^9}, 3.828637664454053*^9, 
   3.828718689983182*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571686237884`*^9, 3.848257192868057*^9}, {3.84825923472919*^9, 
   3.848259236681822*^9}, 3.848259612007312*^9, {3.8482597677280135`*^9, 
   3.848259771133461*^9}, {3.8482598468578053`*^9, 3.8482598497008877`*^9}, {
   3.848260094465921*^9, 3.8482601019797363`*^9}, {3.854761764009829*^9, 
   3.854761764009829*^9}, 3.854761812763962*^9, 3.8547619184957533`*^9, {
   3.85476213510832*^9, 3.8547621352801824`*^9}, {3.854762175741544*^9, 
   3.854762196820649*^9}, 3.854763397808587*^9, 3.854911091585896*^9, 
   3.883168549514434*^9, 3.8831685918481736`*^9, {3.8831693368284187`*^9, 
   3.8831693369690075`*^9}, 3.8831700820047045`*^9, {3.88326856715734*^9, 
   3.883268567688492*^9}, {3.956529075649271*^9, 3.956529075649271*^9}, 
   3.956529278561458*^9, 3.956529333579769*^9, 3.956529375257483*^9, {
   3.956529477764713*^9, 3.9565294832321777`*^9}, {3.95652970749885*^9, 
   3.9565297214487343`*^9}, {3.9565301959560966`*^9, 3.9565302258865724`*^9}, 
   3.956530334767271*^9, 3.9565304297655487`*^9, 3.956541561095746*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0170.png\>\"", ",", "frpConfHypergeomF1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533955185636678*^9, 3.533955193530292*^9}, 
   3.5470089020736527`*^9, 3.5470089906974087`*^9, {3.5501987606920385`*^9, 
   3.5501987608792386`*^9}, 3.550198849300194*^9, {3.5504693214945307`*^9, 
   3.55046932160373*^9}, {3.5531142987603564`*^9, 3.55311430097556*^9}, 
   3.553114600798087*^9, 3.5531850697594075`*^9, 3.55318527036016*^9, 
   3.5531900910817485`*^9, 3.553190165072678*^9, 3.5531908750251255`*^9, {
   3.553190970122893*^9, 3.553190970310093*^9}, {3.5532137997388144`*^9, 
   3.5532138043876224`*^9}, {3.5532141363562055`*^9, 3.553214165434656*^9}, {
   3.556389606160061*^9, 3.5563896074548635`*^9}, 3.556389890454961*^9, {
   3.7325812332963877`*^9, 3.732581233717589*^9}, 3.7326535116184597`*^9, {
   3.7326591364731426`*^9, 3.732659136644743*^9}, 3.7326593484631157`*^9, 
   3.7402167509844255`*^9, 3.7402182539798756`*^9, 3.740219001927597*^9, 
   3.7407786321033087`*^9, {3.740780622260808*^9, 3.7407806224012084`*^9}, 
   3.740782321871723*^9, {3.7407957164042835`*^9, 3.740795721505492*^9}, 
   3.7411140854231243`*^9, {3.74111413420441*^9, 3.7411141344228106`*^9}, 
   3.741166727684222*^9, {3.7411668654792643`*^9, 3.741166865619664*^9}, 
   3.7414211246988482`*^9, 3.7446637267400618`*^9, 3.7446644002400446`*^9, 
   3.7446656128157234`*^9, {3.744665930744282*^9, 3.744665930884682*^9}, 
   3.7452127519526896`*^9, 3.7452127982691708`*^9, 3.7452152179426208`*^9, 
   3.7452153867901173`*^9, 3.7460520107999535`*^9, {3.7460520534036283`*^9, 
   3.74605205424603*^9}, 3.746055118879016*^9, 3.7469914856820946`*^9, {
   3.746991527770969*^9, 3.746991555866618*^9}, 3.7469916833032417`*^9, 
   3.7481112017873716`*^9, {3.7481113416104174`*^9, 3.7481113417820177`*^9}, 
   3.748112629455079*^9, 3.7481132179193125`*^9, {3.7507168447394047`*^9, 
   3.7507168472198095`*^9}, 3.7507169437995787`*^9, 3.7509079022215652`*^9, {
   3.75090794495004*^9, 3.75090794512164*^9}, 3.7509082696490107`*^9, 
   3.7513500249334583`*^9, 3.7513500920291758`*^9, {3.7513503492580276`*^9, 
   3.751350349445228*^9}, 3.7514002242042093`*^9, {3.755049692159449*^9, 
   3.7550496922998495`*^9}, {3.7550498033876443`*^9, 3.7550498039024453`*^9}, 
   3.755049981992358*^9, 3.762283566429557*^9, {3.762283611841237*^9, 
   3.7622836119660373`*^9}, 3.7622837156906195`*^9, 3.764280969439039*^9, 
   3.7642810018246965`*^9, {3.764281074411624*^9, 3.7642810945668592`*^9}, {
   3.764281227135892*^9, 3.7642812273854923`*^9}, 3.7642813042000275`*^9, 
   3.764291565768902*^9, 3.7646644254533424`*^9, {3.7646645461195545`*^9, 
   3.7646645463223543`*^9}, {3.7648874056839075`*^9, 3.7648874058399076`*^9}, 
   3.7648879733221045`*^9, {3.7648894222178516`*^9, 3.7648894224050517`*^9}, {
   3.7650602476465006`*^9, 3.765060247818101*^9}, 3.765060798138668*^9, 
   3.7650876836644077`*^9, {3.765170820041391*^9, 3.765170820322191*^9}, 
   3.765170874688287*^9, 3.7652589119400263`*^9, {3.765259071731107*^9, 
   3.7652590718091073`*^9}, {3.7662195948515224`*^9, 3.7662195957563243`*^9}, 
   3.766219677048067*^9, 3.766220217308216*^9, 3.7664771999234896`*^9, 
   3.7664773393097343`*^9, 3.766477486807994*^9, 3.766477573590946*^9, {
   3.7666119431449013`*^9, 3.7666119433165016`*^9}, {3.7673939377297125`*^9, 
   3.7673939378857126`*^9}, 3.7688458990388994`*^9, 3.768845992155463*^9, 
   3.7688461150368786`*^9, 3.7919252574896*^9, 3.791926052499424*^9, {
   3.791926095989151*^9, 3.791926096598382*^9}, 3.791941133887636*^9, 
   3.7919412657158723`*^9, {3.7919455983389053`*^9, 3.7919456033221006`*^9}, 
   3.7921427775483007`*^9, {3.792144252867916*^9, 3.7921442530085073`*^9}, 
   3.792145007731429*^9, 3.792145059016163*^9, 3.792206627246333*^9, {
   3.792208164803473*^9, 3.792208165553295*^9}, 3.7922705977593207`*^9, {
   3.7922707301029916`*^9, 3.7922707302904463`*^9}, 3.79253865659698*^9, 
   3.7925540406154003`*^9, 3.8025468380534554`*^9, {3.8025469017103243`*^9, 
   3.8025469097240615`*^9}, {3.8025516449002275`*^9, 3.802551645056441*^9}, {
   3.8025797876922874`*^9, 3.802579794206377*^9}, 3.8078544401712985`*^9, {
   3.8078545001470075`*^9, 3.807854500934877*^9}, 3.8078545785694313`*^9, 
   3.8169060743744335`*^9, 3.816906826079885*^9, 3.8169068668827724`*^9, 
   3.820806437814374*^9, {3.8208064682759457`*^9, 3.8208064684790215`*^9}, 
   3.820806553490138*^9, {3.8278746045256357`*^9, 3.8278746310038056`*^9}, 
   3.827874859287332*^9, {3.827874913149688*^9, 3.827874914102568*^9}, 
   3.828286652268653*^9, 3.8482570386857076`*^9, 3.848257074645941*^9, {
   3.84825712863323*^9, 3.8482571287582006`*^9}, 3.8547617640254436`*^9, {
   3.854761842820959*^9, 3.8547618694084587`*^9}, {3.8831685918481736`*^9, 
   3.8831686183106723`*^9}, {3.8831686600976796`*^9, 3.8831686602538943`*^9}, 
   3.9565290756648955`*^9, {3.9565292025011487`*^9, 3.956529227448423*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ap3dConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"AbsArgPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "20000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"-", "8"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0007", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0005", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.528619442909766*^9, 3.528619451910281*^9}, {
   3.5286214386949186`*^9, 3.5286214646354027`*^9}, {3.5286222532055063`*^9, 
   3.528622288166506*^9}, 3.52866506133381*^9, 3.5286651054974875`*^9, {
   3.5286651514707685`*^9, 3.528665155292775*^9}, {3.5287006732862062`*^9, 
   3.528700705625063*^9}, {3.5287008793313684`*^9, 3.5287008818741727`*^9}, {
   3.5287009125126266`*^9, 3.5287009144938297`*^9}, {3.5289198836377797`*^9, 
   3.5289199933371725`*^9}, {3.5289200401996546`*^9, 
   3.5289200576560855`*^9}, {3.5289201204305954`*^9, 
   3.5289201283242097`*^9}, {3.5289213102134857`*^9, 3.5289213711159925`*^9}, 
   3.5289214070272555`*^9, {3.52892258770053*^9, 3.528922633018609*^9}, {
   3.528922704669535*^9, 3.5289227124695487`*^9}, {3.5289237056920934`*^9, 
   3.528923718624516*^9}, 3.5289237912270436`*^9, {3.528923835453121*^9, 
   3.5289238359055223`*^9}, {3.52892390278284*^9, 3.5289239065580463`*^9}, 
   3.5289239438421116`*^9, {3.528923987787389*^9, 3.528924004978619*^9}, {
   3.5289240667547274`*^9, 3.528924087986365*^9}, {3.5289243401296077`*^9, 
   3.528924344294815*^9}, {3.5289245120575094`*^9, 3.5289245256919336`*^9}, {
   3.5289245779988256`*^9, 3.5289246058916745`*^9}, 3.5289246438465414`*^9, {
   3.5301781945730553`*^9, 3.530178289296421*^9}, {3.530178945963975*^9, 
   3.5301789486471796`*^9}, {3.5301820319841957`*^9, 3.530182109703532*^9}, {
   3.5339560194937434`*^9, 3.5339560600070143`*^9}, {3.5339561008634863`*^9, 
   3.53395611423271*^9}, {3.5339561603307905`*^9, 3.5339561646675987`*^9}, {
   3.5339561968816547`*^9, 3.533956209845278*^9}, {3.534022431253952*^9, 
   3.5340224314567523`*^9}, 3.534022572481*^9, {3.534022607705862*^9, 
   3.534022607924262*^9}, {3.5345620477651424`*^9, 3.5345620818512025`*^9}, {
   3.534562122941674*^9, 3.5345621667933517`*^9}, {3.534648397811719*^9, 
   3.534648401118925*^9}, {3.534709801160247*^9, 3.5347098283822947`*^9}, {
   3.5347098611891527`*^9, 3.5347098619223537`*^9}, {3.534709907926834*^9, 
   3.5347099086288357`*^9}, {3.534710222192987*^9, 3.5347102332066064`*^9}, 
   3.5347103216587615`*^9, {3.5347106722693777`*^9, 3.534710675982184*^9}, 
   3.5470089462373304`*^9, {3.5470091278996496`*^9, 3.5470091547472963`*^9}, {
   3.5470094371389923`*^9, 3.547009443207403*^9}, 3.547009595901272*^9, {
   3.547009818014462*^9, 3.5470098320856867`*^9}, {3.5470099040642133`*^9, 
   3.5470099184162383`*^9}, 3.5470100544952774`*^9, 3.547010367529028*^9, 
   3.550198810721326*^9, {3.550199038434926*^9, 3.550199045018138*^9}, {
   3.5501999115110607`*^9, 3.5501999141942654`*^9}, {3.55019997380197*^9, 
   3.55019997398917*^9}, 3.5502073133024054`*^9, 3.550207620982745*^9, {
   3.550207765158199*^9, 3.550207802863465*^9}, {3.55020859692346*^9, 
   3.550208598467862*^9}, {3.5502099531430416`*^9, 3.550209992720311*^9}, {
   3.550210137301365*^9, 3.550210139516569*^9}, {3.550210537442068*^9, 
   3.5502105388148704`*^9}, 3.550210684753127*^9, {3.553114489866292*^9, 
   3.5531145040935173`*^9}, 3.5531145564784093`*^9, 3.55311478447281*^9, {
   3.553114928071062*^9, 3.553114930255066*^9}, {3.5531151718526897`*^9, 
   3.5531152734400682`*^9}, {3.5531153988286963`*^9, 
   3.5531153999830985`*^9}, {3.5531841051629133`*^9, 3.5531841089225197`*^9}, 
   3.5531844703907547`*^9, {3.5531848141373587`*^9, 3.55318482037737*^9}, {
   3.564290330120206*^9, 3.564290330120206*^9}, {3.5642910712463074`*^9, 
   3.5642910895763397`*^9}, {3.5642912437514105`*^9, 3.564291261098641*^9}, {
   3.564291324902753*^9, 3.5642913279447584`*^9}, {3.564298881313227*^9, 
   3.564298910968879*^9}, 3.5645703399765744`*^9, {3.5645709011207676`*^9, 
   3.5645709125711875`*^9}, {3.5646321047687345`*^9, 
   3.5646321068747377`*^9}, {3.564706696754722*^9, 3.564706699547127*^9}, 
   3.5647067771728635`*^9, {3.564989627219633*^9, 3.564989637609251*^9}, 
   3.565030962442968*^9, {3.565152889292653*^9, 3.565152909557089*^9}, {
   3.565152945156351*^9, 3.565152963236783*^9}, 3.565153012439269*^9, 
   3.5651530922490096`*^9, {3.565162127699024*^9, 3.5651621308992076`*^9}, 
   3.565983845442522*^9, 3.56598387845218*^9, {3.5659904751889668`*^9, 
   3.5659904837065816`*^9}, 3.56599068772374*^9, 3.5659907302338142`*^9, {
   3.5659908215943756`*^9, 3.565990858936449*^9}, 3.5659913705393476`*^9, {
   3.566162100485265*^9, 3.566162102341668*^9}, {3.567196994409768*^9, 
   3.5671969959541707`*^9}, {3.567197054189073*^9, 3.567197061021885*^9}, {
   3.567197133858413*^9, 3.5671972115621495`*^9}, {3.5671973507731943`*^9, 
   3.5671973567168045`*^9}, {3.567197396247274*^9, 3.567197485604231*^9}, 
   3.5674580328183336`*^9, {3.567570200880618*^9, 3.5675702017074194`*^9}, {
   3.5675706469946012`*^9, 3.5675706511130085`*^9}, 3.5675897096419353`*^9, 
   3.5680246296369*^9, {3.568160274924254*^9, 3.568160309037122*^9}, {
   3.568160380558855*^9, 3.5681603947860794`*^9}, {3.568160466354613*^9, 
   3.5681604854178467`*^9}, 3.568160775578356*^9, {3.568160813751623*^9, 
   3.568160822394038*^9}, 3.570075555135485*^9, 3.570075606833976*^9, {
   3.570076573068473*^9, 3.5700766101497383`*^9}, {3.570086741011756*^9, 
   3.5700867466120763`*^9}, 3.570086991324073*^9, {3.570087119755419*^9, 
   3.570087155371456*^9}, {3.5700962095128574`*^9, 3.5700962258772864`*^9}, 
   3.5700962986358137`*^9, {3.570096349835104*^9, 3.570096368445937*^9}, 
   3.5700964717345185`*^9, 3.573604781666628*^9, 3.573604883878007*^9, 
   3.573604925826481*^9, {3.57360495952254*^9, 3.57360503919188*^9}, 
   3.573605070064334*^9, {3.573605328369588*^9, 3.573605331661194*^9}, 
   3.5736054416881866`*^9, {3.5736058843701644`*^9, 3.5736059731343203`*^9}, {
   3.5736060324456244`*^9, 3.5736060387012353`*^9}, 3.573606118386175*^9, 
   3.5736062033595247`*^9, 3.573606490725857*^9, {3.573692115976136*^9, 
   3.5736921224969473`*^9}, 3.574884949276402*^9, {3.574885006013702*^9, 
   3.574885007963705*^9}, {3.57577172896203*^9, 3.5757717849022293`*^9}, {
   3.575771839158333*^9, 3.5757719145096426`*^9}, {3.575772545302722*^9, 
   3.575772560950617*^9}, 3.5757894252461996`*^9, {3.575974174332202*^9, 
   3.5759741933330355`*^9}, {3.5767311834246573`*^9, 3.576731301158064*^9}, {
   3.576734520722247*^9, 3.5767345253398547`*^9}, {3.5767345693007317`*^9, 
   3.576734571297536*^9}, 3.5767349788482513`*^9, 3.5767427797108574`*^9, {
   3.5767839288211775`*^9, 3.5767839425180016`*^9}, 3.5767840176165333`*^9, {
   3.5767965812116947`*^9, 3.576796592521714*^9}, 3.577871510016669*^9, {
   3.57787163504882*^9, 3.577871661200316*^9}, {3.5778717168644996`*^9, 
   3.577871730870301*^9}, {3.577871778560028*^9, 3.577871806259613*^9}, 
   3.5778718509931717`*^9, {3.5778726345519886`*^9, 3.5778726367521143`*^9}, {
   3.5779963658724623`*^9, 3.577996367728865*^9}, 3.578002028108985*^9, 
   3.5921826867730446`*^9, 3.592182932910277*^9, {3.592182973563948*^9, 
   3.5921829890703754`*^9}, {3.5921894432385116`*^9, 3.59218944813692*^9}, 
   3.592189480928178*^9, 3.5921896208916235`*^9, {3.5921896765369215`*^9, 
   3.5921896875193405`*^9}, {3.592189778717101*^9, 3.592189837654004*^9}, 
   3.606352358951768*^9, {3.6063524969964104`*^9, 3.6063525015360184`*^9}, {
   3.6063526625511017`*^9, 3.6063527326732244`*^9}, {3.6063527650432816`*^9, 
   3.6063527755264997`*^9}, {3.606353335280284*^9, 3.6063533646707354`*^9}, 
   3.60635353794024*^9, 3.6063545635752487`*^9, {3.6063546892490697`*^9, 
   3.6063547050674973`*^9}, {3.6063552211473227`*^9, 3.606355223690127*^9}, {
   3.6063552577605867`*^9, 3.606355272190612*^9}, {3.6063553038430676`*^9, 
   3.606355338163128*^9}, {3.606355581851156*^9, 3.606355644547666*^9}, {
   3.60636212821593*^9, 3.6063621434727573`*^9}, {3.6063647301913004`*^9, 
   3.606364732328504*^9}, 3.606367653822036*^9, {3.606423653579423*^9, 
   3.606423662861439*^9}, 3.6064237042951117`*^9, 3.6064240186796646`*^9, 
   3.6064240824057765`*^9, 3.6064352530456715`*^9, 3.625306348124917*^9, {
   3.625306422349847*^9, 3.6253064464050894`*^9}, {3.625306510552402*^9, 
   3.625306553920478*^9}, {3.625306755270032*^9, 3.6253068394009795`*^9}, 
   3.625306876669445*^9, 3.625307106474249*^9, 3.6253080361026907`*^9, 
   3.6253565393719177`*^9, 3.6253833999639544`*^9, 3.6253834309924088`*^9, 
   3.6291871583501062`*^9, {3.6291872318262353`*^9, 3.629187239704249*^9}, {
   3.6291873056923647`*^9, 3.6291873143815804`*^9}, {3.6291875784324455`*^9, 
   3.6291876127525053`*^9}, {3.629189364101582*^9, 3.629189366394786*^9}, {
   3.629232868970395*^9, 3.629232869173195*^9}, 3.629412973595767*^9, {
   3.629681734167853*^9, 3.6296817892827497`*^9}, {3.6296820677432384`*^9, 
   3.6296821134157267`*^9}, {3.6296821492957897`*^9, 3.6296821592174067`*^9}, 
   3.6296822142855034`*^9, 3.6296823447797327`*^9, {3.6296823820481987`*^9, 
   3.6296823873678074`*^9}, 3.6296824244022727`*^9, {3.629682533259264*^9, 
   3.629682571479331*^9}, {3.6296864438997335`*^9, 3.6296864498121443`*^9}, 
   3.6301301056703367`*^9, 3.630186806038844*^9, {3.630187005195995*^9, 
   3.6301870543204813`*^9}, 3.630187116294997*^9, {3.6301872101759624`*^9, 
   3.630187240518016*^9}, {3.6301879818625174`*^9, 3.630188037336215*^9}, {
   3.6301880817139006`*^9, 3.6301881292739916`*^9}, {3.630192463897605*^9, 
   3.6301924663624096`*^9}, {3.6325489266416855`*^9, 3.6325489436145153`*^9}, 
   3.632549332330798*^9, {3.6325493823600864`*^9, 3.6325493932021055`*^9}, {
   3.632549475316257*^9, 3.632549494769491*^9}, 3.6325495787244463`*^9, {
   3.63254965087018*^9, 3.6325496533193846`*^9}, {3.632549689417848*^9, 
   3.632549695548659*^9}, {3.632549725609912*^9, 3.632549731350722*^9}, 
   3.632549777632004*^9, {3.6326038339351673`*^9, 3.6326038351987696`*^9}, 
   3.6326052431856437`*^9, 3.632605279237307*^9, {3.6327896696112256`*^9, 
   3.63278967761404*^9}, 3.632789733462138*^9, 3.632789829792307*^9, 
   3.632789870211978*^9, 3.632789986728583*^9, 3.632798118478204*^9, 
   3.632798253418441*^9, {3.632805774254259*^9, 3.6328057895110865`*^9}, {
   3.6328080477542534`*^9, 3.6328080865671215`*^9}, {3.632808253050614*^9, 
   3.6328082534094143`*^9}, {3.632808331378351*^9, 3.632808360269602*^9}, {
   3.632808538526723*^9, 3.6328085720043817`*^9}, {3.632808631050485*^9, 
   3.632808642282505*^9}, {3.632808677908575*^9, 3.6328087181990533`*^9}, {
   3.6328089591882763`*^9, 3.63280900082475*^9}, {3.6328090336628075`*^9, 
   3.632809129977377*^9}, 3.632809186913084*^9, {3.632809216974337*^9, 
   3.632809236926772*^9}, 3.6328094921744204`*^9, {3.6328628083886805`*^9, 
   3.6328628144414916`*^9}, 3.632862901630045*^9, 3.6345039446897955`*^9, 
   3.634504022565132*^9, {3.634504657689049*^9, 3.6345046727742753`*^9}, {
   3.634504709243346*^9, 3.6345047653410444`*^9}, {3.634504880625247*^9, 
   3.6345049408257523`*^9}, {3.6345049821346254`*^9, 3.63450498472423*^9}, {
   3.6345052382364817`*^9, 3.634505239952485*^9}, {3.6345553893336797`*^9, 
   3.6345554050117073`*^9}, 3.6345568508334475`*^9, {3.636074809678754*^9, 
   3.6360748135943604`*^9}, {3.6360753609197226`*^9, 3.636075371137741*^9}, {
   3.6360754445046697`*^9, 3.6360754448322706`*^9}, 3.6360754780759287`*^9, {
   3.6360755150323935`*^9, 3.636075526139613*^9}, 3.6364953410960603`*^9, 
   3.636495413464587*^9, 3.636495521806778*^9, 3.636495566391656*^9, 
   3.6364955986993127`*^9, 3.63649578354646*^9, {3.636496052943333*^9, 
   3.636496059417344*^9}, {3.636496089572198*^9, 3.6364960983862133`*^9}, 
   3.6364962814213343`*^9, {3.6364969368880863`*^9, 3.636496945000101*^9}, 
   3.7255922261262445`*^9, 3.7255924668034678`*^9, 3.7255925194379597`*^9, {
   3.725594490754224*^9, 3.7255945013310423`*^9}, 3.7255952592895737`*^9, 
   3.725595809710141*^9, 3.725595872032251*^9, 3.725596154470747*^9, 
   3.7255964263948245`*^9, 3.7255994902566366`*^9, 3.7256016031495495`*^9, 
   3.7256016803852854`*^9, {3.7257699711575327`*^9, 3.7257699995651827`*^9}, 
   3.7257711688340364`*^9, 3.7257741402492557`*^9, 3.7257744781258564`*^9, 
   3.7258490150765495`*^9, {3.725852074641125*^9, 3.725852075202726*^9}, 
   3.725852252840238*^9, 3.725852386626073*^9, {3.7258526579417496`*^9, 
   3.725852658565751*^9}, 3.7258527373146887`*^9, {3.7258528441436768`*^9, 
   3.7258528480904837`*^9}, 3.726913461460272*^9, {3.7269135066691513`*^9, 
   3.7269135066847515`*^9}, 3.7269135736244693`*^9, {3.7269141963775625`*^9, 
   3.726914207671983*^9}, 3.726914350100233*^9, {3.726914421298758*^9, 
   3.7269144217511587`*^9}, 3.7269145086589117`*^9, 3.7269146264547186`*^9, 
   3.7269147176680784`*^9, {3.726914927879649*^9, 3.7269149421848745`*^9}, {
   3.726942862934918*^9, 3.726942875820541*^9}, 3.7269430613360662`*^9, 
   3.7269527172550287`*^9, {3.732581313558529*^9, 3.732581414007105*^9}, {
   3.7326583984946456`*^9, 3.732658428493498*^9}, {3.732658557942526*^9, 
   3.732658586022575*^9}, {3.732659178499616*^9, 3.732659189263635*^9}, 
   3.732662539865631*^9, {3.7402178619119854`*^9, 3.740217868385997*^9}, {
   3.7402181435784817`*^9, 3.740218149693692*^9}, {3.740218205900591*^9, 
   3.7402182074137936`*^9}, {3.740218302823561*^9, 3.740218347018439*^9}, {
   3.740218658655794*^9, 3.7402186693574123`*^9}, {3.7402192940381107`*^9, 
   3.7402193007617226`*^9}, {3.740220269338224*^9, 3.7402202697282248`*^9}, {
   3.740220328462328*^9, 3.740220338337145*^9}, {3.74062349322491*^9, 
   3.7406234962357154`*^9}, {3.740778595583645*^9, 3.74077859848525*^9}, {
   3.740778651650143*^9, 3.7407786648009663`*^9}, {3.7407788761441393`*^9, 
   3.7407788989669795`*^9}, {3.740779013450781*^9, 3.740779023996399*^9}, {
   3.7407791542866287`*^9, 3.7407791747070646`*^9}, {3.740779219900344*^9, 
   3.740779220196744*^9}, {3.740779424588303*^9, 3.7407794273807077`*^9}, {
   3.7407794683775797`*^9, 3.7407794818404036`*^9}, {3.7407796849131613`*^9, 
   3.7407797216824255`*^9}, {3.7407798321070204`*^9, 3.7407798775031*^9}, {
   3.7407800627346253`*^9, 3.740780110221109*^9}, {3.740780271946593*^9, 
   3.7407802910098267`*^9}, 3.740780521968232*^9, {3.740780648765255*^9, 
   3.7407806521660604`*^9}, {3.740780740587016*^9, 3.7407807443622227`*^9}, {
   3.7407824497451477`*^9, 3.740782452974354*^9}, {3.740783174738423*^9, 
   3.740783181930035*^9}, 3.740784309105423*^9, 3.7407843782021475`*^9, 
   3.740784798230516*^9, 3.740792141493194*^9, {3.740795745950735*^9, 
   3.7407958089592457`*^9}, 3.7407962456820135`*^9, 3.740796278894471*^9, {
   3.7407966335298944`*^9, 3.740796667288354*^9}, {3.740796726833658*^9, 
   3.740796732012867*^9}, {3.7407968196070213`*^9, 3.740796823959429*^9}, {
   3.741114044270252*^9, 3.741114047499458*^9}, 3.741114172876878*^9, {
   3.741114214840952*^9, 3.7411142149657516`*^9}, {3.7411143056643114`*^9, 
   3.7411143086907167`*^9}, {3.7411143683764215`*^9, 
   3.7411143879700556`*^9}, {3.7411144249889207`*^9, 
   3.7411144431785526`*^9}, {3.7411667545006695`*^9, 3.741166765233488*^9}, 
   3.74189270181349*^9, 3.74466368597719*^9, 3.7446641759896507`*^9, 
   3.7446656127845235`*^9, 3.744665651924992*^9, 3.744742913131895*^9, {
   3.7447489853929644`*^9, 3.744748987545768*^9}, 3.744875554021535*^9, {
   3.7452126977581944`*^9, 3.7452126994273973`*^9}, {3.7452128151796007`*^9, 
   3.74521282638042*^9}, {3.7452129967795196`*^9, 3.745213042097599*^9}, {
   3.7452130797560654`*^9, 3.745213081565668*^9}, {3.7452131350581627`*^9, 
   3.74521318497825*^9}, {3.7452132378155427`*^9, 3.745213240966748*^9}, {
   3.7452136012649813`*^9, 3.745213631029834*^9}, {3.745213734582815*^9, 
   3.7452137373908205`*^9}, {3.7452153530628586`*^9, 3.7452153600672708`*^9}, 
   3.7452154080997553`*^9, {3.745215674051823*^9, 3.7452156741454234`*^9}, {
   3.7452158387569127`*^9, 3.745215838975313*^9}, {3.745216206574359*^9, 
   3.745216245761627*^9}, 3.745220787875206*^9, 3.746051986744711*^9, {
   3.7460521008589115`*^9, 3.746052131778166*^9}, {3.7460521666286273`*^9, 
   3.7460524545427327`*^9}, 3.746052540857684*^9, {3.746053417769227*^9, 
   3.7460534259280415`*^9}, 3.746054345117657*^9, 3.7460546304265585`*^9, {
   3.7460742014929237`*^9, 3.746074240758193*^9}, 3.746991621012333*^9, {
   3.746994997701064*^9, 3.746995027793517*^9}, {3.7469953201784315`*^9, 
   3.7469954400490417`*^9}, {3.7469954827307167`*^9, 3.74699550728516*^9}, 
   3.7469955396084166`*^9, {3.7470008008733025`*^9, 3.74700080527251*^9}, {
   3.7470008733666296`*^9, 3.747000875893834*^9}, {3.747000949837964*^9, 
   3.747000952287168*^9}, 3.7470264752655973`*^9, {3.747028003559884*^9, 
   3.7470280096126947`*^9}, {3.7481111476864767`*^9, 3.748111150276081*^9}, 
   3.748111262440278*^9, 3.7481114647570333`*^9, 3.7481114993578944`*^9, 
   3.7481117436231236`*^9, 3.7481117783019843`*^9, 3.7481118211240597`*^9, 
   3.7481119089054136`*^9, 3.748112016779603*^9, 3.7481126540251226`*^9, {
   3.748112759746508*^9, 3.7481127604173093`*^9}, {3.748112809635396*^9, 
   3.748112816156207*^9}, {3.748112846591861*^9, 3.7481128812083216`*^9}, 
   3.7481129454960346`*^9, 3.748113095849098*^9, 3.7481148409525647`*^9, 
   3.7481523665185213`*^9, 3.749668417688261*^9, 3.7507168750970583`*^9, {
   3.7507169896168594`*^9, 3.750716992861665*^9}, {3.750717108551468*^9, 
   3.7507172392640977`*^9}, {3.7507172898861866`*^9, 3.75071732030624*^9}, {
   3.750717367402723*^9, 3.7507173891803613`*^9}, {3.7507175430902314`*^9, 
   3.750717551592246*^9}, {3.750717698907706*^9, 3.7507177368313723`*^9}, {
   3.750717804535491*^9, 3.7507178507895727`*^9}, {3.750717899056057*^9, 
   3.750717922424898*^9}, {3.750718034791896*^9, 3.7507180483015194`*^9}, {
   3.7507198746355276`*^9, 3.7507198747915277`*^9}, 3.7507206603917084`*^9, 
   3.750743995100903*^9, {3.750744115267914*^9, 3.7507441173583174`*^9}, 
   3.751183154782548*^9, 3.7511832007870283`*^9, 3.7511889477875257`*^9, 
   3.7511898686887436`*^9, {3.751190067027492*^9, 3.751190067214692*^9}, {
   3.7511904339557366`*^9, 3.7511904342209373`*^9}, 3.751343678313509*^9, {
   3.751343737328412*^9, 3.7513437454248266`*^9}, {3.7513439903028574`*^9, 
   3.7513440021900787`*^9}, 3.7513440559165726`*^9, {3.751344356866702*^9, 
   3.751344358754305*^9}, {3.7513453951733255`*^9, 3.7513454022313385`*^9}, 
   3.751345479623074*^9, 3.751345663578597*^9, 3.7513458060536475`*^9, {
   3.7513462322931957`*^9, 3.751346244788818*^9}, 3.751347972101852*^9, {
   3.7513564574799557`*^9, 3.751356461379963*^9}, 3.7513572038244677`*^9, 
   3.7550499818675575`*^9, 3.755050081270932*^9, 3.755050162094674*^9, {
   3.7550503792938557`*^9, 3.755050383552663*^9}, {3.755050657769945*^9, 
   3.7550507162700477`*^9}, 3.7550507776249557`*^9, {3.7550508327710524`*^9, 
   3.7550509174012012`*^9}, {3.75506116943268*^9, 3.75506120939995*^9}, 
   3.755061263641245*^9, {3.755061304045316*^9, 3.755061332296966*^9}, {
   3.791837454079505*^9, 3.7918374672326627`*^9}, {3.7918375293898745`*^9, 
   3.791837639613963*^9}, {3.7918376716532726`*^9, 3.7918377406682825`*^9}, {
   3.7918378367550473`*^9, 3.7918378492208977`*^9}, {3.791837885353021*^9, 
   3.791837927093199*^9}, {3.7918379571642485`*^9, 3.791837983314344*^9}, {
   3.7918382715699883`*^9, 3.791838307577134*^9}, {3.791838449356269*^9, 
   3.7918384679143763`*^9}, {3.791838600615634*^9, 3.7918386391222763`*^9}, {
   3.7918387136916265`*^9, 3.791838717518922*^9}, {3.7918387964402494`*^9, 
   3.7918388962605457`*^9}, {3.7918390063752236`*^9, 3.791839009499524*^9}, {
   3.7918390718129854`*^9, 3.791839081279473*^9}, 3.791926694308837*^9, {
   3.7919269047590957`*^9, 3.7919269312528725`*^9}, {3.791941159803388*^9, 
   3.791941185000529*^9}, {3.7919414976767054`*^9, 3.7919415013477135`*^9}, {
   3.7919418976905293`*^9, 3.7919419070633483`*^9}, {3.79194194144582*^9, 
   3.7919419457417145`*^9}, {3.791944532323326*^9, 3.7919445402901945`*^9}, 
   3.791945575110017*^9, {3.7919456228331137`*^9, 3.7919456251919384`*^9}, {
   3.7919457477646008`*^9, 3.791945947970544*^9}, {3.7919459941783795`*^9, 
   3.7919459979274817`*^9}, 3.791946210705377*^9, 3.791947743925529*^9, {
   3.792142687080438*^9, 3.7921427322260327`*^9}, {3.7921428660273533`*^9, 
   3.792142869089161*^9}, {3.792142945399186*^9, 3.7921429898730664`*^9}, {
   3.7921430613873816`*^9, 3.792143077961583*^9}, {3.7921431184519978`*^9, 
   3.7921431238725896`*^9}, 3.792143155349477*^9, 3.792143211601818*^9, {
   3.7921432698380313`*^9, 3.7921432757897153`*^9}, 3.7921434567671947`*^9, 
   3.792144982440548*^9, 3.7921450272892933`*^9, {3.792145072528581*^9, 
   3.792145079042717*^9}, 3.79214511625261*^9, 3.792145176425829*^9, {
   3.792145498912012*^9, 3.792145499115088*^9}, 3.792145594592448*^9, {
   3.7921456423624225`*^9, 3.7921456449087653`*^9}, {3.792184449093946*^9, 
   3.792184475478321*^9}, {3.792184553584795*^9, 3.792184576954283*^9}, 
   3.79218461517962*^9, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, {
   3.792206718240422*^9, 3.792206731424799*^9}, 3.792206845007283*^9, {
   3.7922070074375753`*^9, 3.7922070321039267`*^9}, 3.7922073048830905`*^9, {
   3.792207471952895*^9, 3.7922074981029654`*^9}, 3.792207861765847*^9, {
   3.7922106379018235`*^9, 3.7922106451501083`*^9}, {3.792270597712449*^9, 
   3.792270597712449*^9}, {3.792270891033639*^9, 3.7922708912054386`*^9}, 
   3.7922709722175446`*^9, 3.792271039389139*^9, 3.792271363687356*^9, {
   3.792272235885374*^9, 3.792272236072836*^9}, {3.7922725073824296`*^9, 
   3.7922725105379333`*^9}, {3.7922725499817567`*^9, 3.792272575631919*^9}, {
   3.7923819877656794`*^9, 3.7923819927489023`*^9}, 3.7925386565345564`*^9, {
   3.7925388649840345`*^9, 3.7925389122384624`*^9}, {3.792538977710556*^9, 
   3.7925389836310034`*^9}, 3.792539073871907*^9, 3.792539144948824*^9, 
   3.7925391995140295`*^9, {3.7925392495646725`*^9, 3.7925392522827845`*^9}, {
   3.792553223558854*^9, 3.792553236758835*^9}, 3.7925532712350616`*^9, 
   3.792553308132576*^9, {3.7925533452331324`*^9, 3.7925534413978987`*^9}, {
   3.792553882028*^9, 3.7925538868705435`*^9}, 3.792554765327935*^9, 
   3.7926557610118475`*^9, {3.8025467409044847`*^9, 3.802546764242728*^9}, 
   3.802547143215903*^9, {3.8025527321047087`*^9, 3.8025527867480636`*^9}, 
   3.802552818615567*^9, {3.8025528666667347`*^9, 3.802552957988966*^9}, 
   3.802553005837062*^9, 3.802553077929443*^9, {3.8025798749373145`*^9, 
   3.8025798774367256`*^9}, 3.8025799386730447`*^9, {3.8025800226579857`*^9, 
   3.8025800228142033`*^9}, 3.802585141722986*^9, 3.8078545320706625`*^9, {
   3.8078546051822667`*^9, 3.8078546730877852`*^9}, {3.8078547090317235`*^9, 
   3.8078547719695177`*^9}, 3.8078548203562016`*^9, 3.8078549040505514`*^9, {
   3.807855037674405*^9, 3.807855037962635*^9}, 3.816906009920802*^9, {
   3.8169060910892124`*^9, 3.8169061174267793`*^9}, {3.8169061971268187`*^9, 
   3.81690620022064*^9}, {3.8169062907775416`*^9, 3.8169063139595995`*^9}, {
   3.816906347529848*^9, 3.816906358371046*^9}, {3.8169064463660016`*^9, 
   3.8169064751248894`*^9}, {3.8169065717896967`*^9, 
   3.8169065738517113`*^9}, {3.8169066667673993`*^9, 3.816906727987401*^9}, 
   3.816906887955981*^9, {3.8169072179264603`*^9, 3.816907218176386*^9}, {
   3.8208064885993166`*^9, 3.820806493191882*^9}, {3.820806571985753*^9, 
   3.820806591262437*^9}, {3.820806643218884*^9, 3.820806644468581*^9}, {
   3.820806710234253*^9, 3.8208067108747253`*^9}, 3.820806825550688*^9, 
   3.820806870305712*^9, {3.8208070329068413`*^9, 3.8208070358748503`*^9}, 
   3.8208071291340075`*^9, {3.827874604478779*^9, 3.8278746309413214`*^9}, {
   3.828285976508387*^9, 3.8282860378689904`*^9}, {3.828286069189767*^9, 
   3.8282860750946317`*^9}, {3.8282862454440393`*^9, 3.828286274874611*^9}, 
   3.8282864569082403`*^9, 3.8282865303597565`*^9, {3.828288390273615*^9, 
   3.8282884014897327`*^9}, 3.8286362223683195`*^9, 3.8288490034020543`*^9, {
   3.8482570386076126`*^9, 3.8482570386232243`*^9}, {3.8482571403492136`*^9, 
   3.8482571748254557`*^9}, 3.8482572580401783`*^9, {3.8482592159992356`*^9, 
   3.8482592163897705`*^9}, 3.8482592584954834`*^9, 3.848259312904552*^9, {
   3.848259470368842*^9, 3.8482594998619113`*^9}, {3.8482597067661886`*^9, 
   3.848259717341818*^9}, {3.8482598723142166`*^9, 3.848259905868791*^9}, {
   3.8482604837349753`*^9, 3.8482604978097763`*^9}, {3.8547617638223734`*^9, 
   3.8547617638379946`*^9}, {3.8547617944089394`*^9, 3.8547617956430206`*^9}, 
   3.8547619113724337`*^9, {3.854762164384845*^9, 3.8547621866921015`*^9}, 
   3.8549110836125603`*^9, 3.8831684291204414`*^9, 3.8831685486083903`*^9, 
   3.883168591770075*^9, 3.8831689414842877`*^9, 3.8831690014857616`*^9, 
   3.8831706667954407`*^9, 3.8831708703093653`*^9, 3.956529049280467*^9, 
   3.9565290970348783`*^9, {3.9565292776866674`*^9, 3.9565293066954803`*^9}, {
   3.9565293420934258`*^9, 3.9565293429526005`*^9}, {3.9565293996423855`*^9, 
   3.9565294227776165`*^9}, 3.956529535867911*^9, 3.956529572578045*^9, {
   3.9565296812237678`*^9, 3.9565296814268775`*^9}, {3.956530125035204*^9, 
   3.9565301364388113`*^9}, 3.956530440138101*^9, 3.9565415554720664`*^9, {
   3.956546654988694*^9, 3.956546660393709*^9}, 3.9565469377505007`*^9, 
   3.9565471139747667`*^9, {3.9565471759133606`*^9, 3.9565471791939087`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0180.png\>\"", ",", "ap3dConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955147213811*^9, 3.533955206041514*^9, 3.5470088906700325`*^9, 
   3.5470089487489347`*^9, {3.5501987437036085`*^9, 3.5501987438440084`*^9}, 
   3.550198813591731*^9, {3.5504692939604816`*^9, 3.550469294069682*^9}, 
   3.553114267872302*^9, 3.5531143193679924`*^9, 3.5531145595360146`*^9, 
   3.5531850944854507`*^9, {3.5531852419837103`*^9, 3.5531852422489104`*^9}, 
   3.5531900792725277`*^9, 3.5531901503774524`*^9, 3.55319089444716*^9, 
   3.553190949265656*^9, {3.55321378571439*^9, 3.5532137858547897`*^9}, 
   3.553213822249654*^9, {3.5532141187749743`*^9, 3.553214146340223*^9}, {
   3.5563895716216006`*^9, 3.556389571762001*^9}, 3.5563898724213285`*^9, {
   3.7325812172595596`*^9, 3.7325812177743607`*^9}, 3.7326535308532934`*^9, {
   3.732659113743902*^9, 3.732659113899903*^9}, 3.732659206220865*^9, 
   3.740216750922025*^9, 3.7402182214850187`*^9, 3.740218987201172*^9, 
   3.740778600201253*^9, {3.740780597784365*^9, 3.740780598018366*^9}, 
   3.7407822969116793`*^9, {3.7407956919590406`*^9, 3.740795692161841*^9}, 
   3.7407957432831306`*^9, 3.741114049309061*^9, {3.7411141070915623`*^9, 
   3.7411141072631626`*^9}, 3.741166751692664*^9, 3.7411668366036134`*^9, {
   3.741421168425725*^9, 3.7414211686285257`*^9}, 3.7446636889255953`*^9, 
   3.744664374468799*^9, 3.7446656127845235`*^9, {3.7446659070166407`*^9, 
   3.7446659071882405`*^9}, 3.7452127094426146`*^9, {3.7452127690503197`*^9, 
   3.7452127718427243`*^9}, 3.745215203949396*^9, 3.745215406290152*^9, 
   3.746051989225116*^9, {3.746052022125573*^9, 3.7460520228275747`*^9}, 
   3.746055103278989*^9, 3.746991472593672*^9, 3.7469915089417357`*^9, 
   3.7469915389717884`*^9, 3.746991632774753*^9, 3.748111159012097*^9, {
   3.7481113177579756`*^9, 3.748111317945176*^9}, 3.7481126514667177`*^9, {
   3.748113195470874*^9, 3.748113195689274*^9}, {3.7507167568800507`*^9, 
   3.7507167594852552`*^9}, 3.7507168842542744`*^9, {3.750907902190365*^9, 
   3.750907924545204*^9}, 3.7509082695866103`*^9, 3.7513500248866577`*^9, 
   3.7513500919979753`*^9, {3.7513503196023755`*^9, 3.7513503197739754`*^9}, {
   3.7550497169166927`*^9, 3.7550497426723375`*^9}, 3.7550499818831577`*^9, {
   3.791837399326764*^9, 3.791837403919399*^9}, 3.7918374397704163`*^9, 
   3.7919411562417016`*^9, 3.7919412497352705`*^9, 3.7919455775000772`*^9, 
   3.79194561547548*^9, 3.7921427775170593`*^9, {3.7921442289360805`*^9, 
   3.7921442290922937`*^9}, 3.792144984877466*^9, {3.79214503848981*^9, 
   3.7921450386459846`*^9}, 3.7922066272150636`*^9, {3.7922081247973256`*^9, 
   3.792208125375308*^9}, 3.792270597728077*^9, {3.792270704359085*^9, 
   3.792270704452841*^9}, 3.792538656550113*^9, {3.7925539995157557`*^9, 
   3.7925540001562295`*^9}, 3.8025468009840703`*^9, {3.802546874435505*^9, 
   3.8025468749822507`*^9}, 3.8025469230959077`*^9, 3.8025516256547904`*^9, {
   3.8025798621278696`*^9, 3.802579872625392*^9}, {3.807854454103038*^9, 
   3.807854466154855*^9}, 3.807854538815669*^9, 3.8169060154038906`*^9, {
   3.81690681059914*^9, 3.8169068368429813`*^9}, {3.8208063901537895`*^9, 
   3.820806402244675*^9}, 3.820806503673809*^9, {3.827874604494393*^9, 
   3.8278746309413214`*^9}, {3.8278748592560916`*^9, 3.8278748863590775`*^9}, 
   3.82828663244518*^9, 3.8482570386232243`*^9, {3.8482570745991116`*^9, 
   3.848257085752733*^9}, 3.8547617638536158`*^9, {3.854761829152297*^9, 
   3.854761851225196*^9}, {3.883168591785688*^9, 3.883168637915431*^9}, 
   3.9565290755867867`*^9, {3.9565292024699354`*^9, 3.9565292106242757`*^9}, 
   3.95654665337973*^9, 3.956546684981656*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"adpConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"ArgDensityPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "20000"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "8"}], ",", "30"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.732482892728856*^9, 3.7324829563457675`*^9}, {
   3.7324830851923943`*^9, 3.7324830882811995`*^9}, {3.732483262424306*^9, 
   3.732483272377123*^9}, 3.7326584415195208`*^9, {3.7326584750439796`*^9, 
   3.7326584764479823`*^9}, 3.732658701981179*^9, {3.732658872349078*^9, 
   3.732658872567479*^9}, 3.7326592186228867`*^9, 3.7326593083866453`*^9, 
   3.7326626660310535`*^9, {3.740218157446906*^9, 3.740218181533348*^9}, 
   3.7402182257126255`*^9, 3.7402183634452677`*^9, {3.740218493186303*^9, 
   3.7402184934047036`*^9}, 3.740218637580157*^9, {3.7402186807610326`*^9, 
   3.7402186901834493`*^9}, 3.740219272556873*^9, 3.7406235115861425`*^9, {
   3.740778603524059*^9, 3.740778607080865*^9}, {3.740778656564152*^9, 
   3.740778658529755*^9}, {3.740778688559808*^9, 3.7407786898078103`*^9}, {
   3.7407792259843545`*^9, 3.7407792441895866`*^9}, {3.7407793822810287`*^9, 
   3.740779417427891*^9}, {3.7407794646959734`*^9, 3.7407794857872105`*^9}, 
   3.740780774189475*^9, 3.7407824622407703`*^9, {3.740783008707331*^9, 
   3.7407830693134375`*^9}, 3.7407921769832563`*^9, 3.740795739929125*^9, 
   3.740795830549684*^9, {3.741114053755069*^9, 3.741114056173073*^9}, 
   3.741114177042085*^9, {3.741114217851757*^9, 3.7411142179765573`*^9}, 
   3.741114298004698*^9, 3.7411143910588613`*^9, {3.7411144222121162`*^9, 
   3.741114422383716*^9}, 3.7411667475274568`*^9, 3.741166782284318*^9, 
   3.741202200838129*^9, 3.7418928330565205`*^9, 3.744663694463605*^9, 
   3.7446641788132553`*^9, 3.7446656127845235`*^9, 3.7446656519405923`*^9, 
   3.744742916766701*^9, 3.7447489900885725`*^9, 3.745212714450224*^9, {
   3.7452134334710865`*^9, 3.745213472377555*^9}, {3.74521352657205*^9, 
   3.7452135499564915`*^9}, {3.745213645116658*^9, 3.74521367446031*^9}, 
   3.7452137501360426`*^9, 3.745215372484893*^9, 3.745215403544547*^9, {
   3.745215676563428*^9, 3.745215676657028*^9}, {3.745215841159317*^9, 
   3.7452158501293325`*^9}, 3.745220796377221*^9, 3.746051992891122*^9, {
   3.7460525179568443`*^9, 3.746052527363661*^9}, {3.7460525613717203`*^9, 
   3.7460526080470023`*^9}, {3.746052647827072*^9, 3.746052665392703*^9}, 
   3.7460527306476173`*^9, {3.7460534548348923`*^9, 3.746053478047733*^9}, {
   3.7460536390400157`*^9, 3.7460536607708535`*^9}, {3.7460537995066986`*^9, 
   3.7460538460103807`*^9}, 3.746054532895187*^9, 3.7460546210509415`*^9, {
   3.746055005030016*^9, 3.7460550460736885`*^9}, 3.7460615185886574`*^9, {
   3.746069839136873*^9, 3.7460698629425144`*^9}, {3.746073417607147*^9, 
   3.7460734321307726`*^9}, 3.7460741921641073`*^9, 3.7469916409491673`*^9, {
   3.7469955617292557`*^9, 3.746995578218485*^9}, 3.7469956382941904`*^9, {
   3.7469959147934766`*^9, 3.746995920768287*^9}, {3.7469959729191785`*^9, 
   3.746995986631603*^9}, 3.746998736928876*^9, 3.746999808962759*^9, 
   3.747000762809235*^9, {3.7470280162427063`*^9, 3.7470280188011107`*^9}, 
   3.7481111741597233`*^9, 3.74811125768227*^9, {3.7481113758212776`*^9, 
   3.748111454039815*^9}, 3.7481116828922167`*^9, 3.74811178123479*^9, 
   3.7481120097751913`*^9, 3.7481126483779125`*^9, 3.7481127678585224`*^9, 
   3.7481129482884398`*^9, 3.748113174738437*^9, {3.748114852964586*^9, 
   3.7481148546805887`*^9}, 3.7481523715885305`*^9, 3.748156676743692*^9, 
   3.7496684226178694`*^9, 3.7507168950182934`*^9, 3.7507174232196207`*^9, 
   3.7507179880698137`*^9, 3.7507180637455463`*^9, {3.750718172664938*^9, 
   3.7507181919309716`*^9}, {3.750718281381529*^9, 3.7507183044383693`*^9}, {
   3.7507198773499327`*^9, 3.7507198774903326`*^9}, 3.750720697925374*^9, 
   3.7507439988761096`*^9, {3.750744109105903*^9, 3.7507441115707073`*^9}, 
   3.75090826960221*^9, 3.750908324873107*^9, 3.750911281940936*^9, 
   3.7509118911532063`*^9, 3.7509120959347663`*^9, {3.750923612368995*^9, 
   3.750923612524996*^9}, {3.7509248608167896`*^9, 3.750924875777216*^9}, {
   3.7509256243805313`*^9, 3.750925624567732*^9}, 3.7513499450613174`*^9, 
   3.751350024902258*^9, 3.751350205378975*^9, {3.7513571187651176`*^9, 
   3.751357119545119*^9}, 3.751357214526087*^9, {3.7513577496226263`*^9, 
   3.7513577498410273`*^9}, {3.751405366281531*^9, 3.751405378480752*^9}, {
   3.7514055458066463`*^9, 3.751405557849867*^9}, {3.751405638626809*^9, 
   3.7514056388764095`*^9}, 3.755049981945558*^9, 3.755050081707733*^9, 
   3.7550501621258745`*^9, {3.755050400759494*^9, 3.7550504035050983`*^9}, 
   3.7550509310980253`*^9, {3.7550512422873716`*^9, 3.7550512668106146`*^9}, {
   3.755051312409495*^9, 3.755051312877496*^9}, {3.755051771595695*^9, 
   3.755051771751695*^9}, {3.7550518885491004`*^9, 3.7550519085639353`*^9}, 
   3.7551379658536453`*^9, {3.755138016132534*^9, 3.755138075287838*^9}, {
   3.7551381761264153`*^9, 3.755138212599279*^9}, {3.75513827588859*^9, 
   3.755138303656639*^9}, {3.7551383744339633`*^9, 3.7551383747147636`*^9}, {
   3.755138574254714*^9, 3.75513859464395*^9}, 3.755138673611289*^9, {
   3.755139946626726*^9, 3.7551399654559593`*^9}, {3.7551413576185923`*^9, 
   3.755141379583431*^9}, 3.7551422855775647`*^9, {3.7551424248350105`*^9, 
   3.7551424403258376`*^9}, 3.7551475815781126`*^9, 3.7552236306473618`*^9, 
   3.7552237351007524`*^9, 3.7552257200630403`*^9, {3.755227559021696*^9, 
   3.755227559177696*^9}, {3.755227954092391*^9, 3.7552279570407963`*^9}, 
   3.7642903613991814`*^9, {3.7642905329386835`*^9, 3.7642905870551786`*^9}, 
   3.7642906182396336`*^9, {3.764290672449729*^9, 3.7642906894693584`*^9}, 
   3.764290721075014*^9, {3.76429075314867*^9, 3.764290753289071*^9}, {
   3.7642908794620924`*^9, 3.7642908959981213`*^9}, 3.764291593614951*^9, 
   3.76429466703955*^9, 3.7643042218683386`*^9, 3.764315617343957*^9, 
   3.76431783317605*^9, 3.7643199388461533`*^9, 3.7643853579378877`*^9, 
   3.764664382553267*^9, 3.7646644254065423`*^9, {3.7646670199227085`*^9, 
   3.7646670350235357`*^9}, {3.7646689626829224`*^9, 3.7646689628545227`*^9}, 
   3.764887973228504*^9, 3.764888008734166*^9, 3.7648888932053223`*^9, {
   3.7648903774637313`*^9, 3.764890377635331*^9}, 3.7648904488962564`*^9, 
   3.764890628343372*^9, {3.7648920077004867`*^9, 3.764892008121687*^9}, 
   3.764892076278207*^9, {3.7649026437276335`*^9, 3.7649026438212337`*^9}, 
   3.76506077650143*^9, 3.765170874625887*^9, 3.7651709275099792`*^9, 
   3.7651715756087255`*^9, 3.765171666619285*^9, 3.7651717371314087`*^9, 
   3.765171875909253*^9, 3.7652588601167355`*^9, 3.7652589118932266`*^9, {
   3.765267833767707*^9, 3.7652678340173073`*^9}, 3.766219677016867*^9, 
   3.766219733629367*^9, 3.7662201958113785`*^9, {3.7662231334417396`*^9, 
   3.7662231361717443`*^9}, 3.7662232485855417`*^9, {3.766426144952866*^9, 
   3.766426157042887*^9}, {3.76647719987669*^9, 3.7664772214515276`*^9}, {
   3.7664774867767935`*^9, 3.7664775002396173`*^9}, {3.7688458990076995`*^9, 
   3.7688459132037244`*^9}, 3.7688464394654493`*^9, 3.7688469041774664`*^9, 
   3.791925257427122*^9, 3.791925346562312*^9, {3.791925415077385*^9, 
   3.791925432292034*^9}, {3.79192558767724*^9, 3.7919255902703776`*^9}, {
   3.7919257453302054`*^9, 3.791925757202401*^9}, {3.791925937519228*^9, 
   3.7919259408152847`*^9}, {3.7919259926311307`*^9, 3.791925997395666*^9}, 
   3.791926263855747*^9, {3.7919264890844517`*^9, 3.791926490037352*^9}, 
   3.791927284210745*^9, 3.7919411532580585`*^9, 3.791941223803928*^9, {
   3.7919415060341063`*^9, 3.7919415061903205`*^9}, 3.7919455800307994`*^9, 
   3.7919456362986813`*^9, {3.791945689832918*^9, 3.7919457217551537`*^9}, 
   3.7919460775336857`*^9, 3.7919462165008616`*^9, {3.7919462528203726`*^9, 
   3.7919462530703335`*^9}, 3.7921427775170593`*^9, 3.7921428783057747`*^9, {
   3.792143003807266*^9, 3.7921430251928267`*^9}, 3.792143064074258*^9, {
   3.7921431277154303`*^9, 3.792143128543357*^9}, {3.7921434609849415`*^9, 
   3.79214346590565*^9}, 3.7921449885797224`*^9, 3.792145025274151*^9, {
   3.7921450954762783`*^9, 3.7921451181897235`*^9}, {3.7921455056604123`*^9, 
   3.7921455095657372`*^9}, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, 
   3.7922067460150957`*^9, 3.7922068475379333`*^9, {3.792207866280402*^9, 
   3.792207873684909*^9}, {3.792270597728077*^9, 3.792270597728077*^9}, {
   3.792270895657544*^9, 3.792270895782504*^9}, {3.792271368045697*^9, 
   3.7922713738255787`*^9}, {3.7922722199672675`*^9, 3.792272227824782*^9}, 
   3.792538656565729*^9, 3.792538924313737*^9, {3.792538977710556*^9, 
   3.7925389876925745`*^9}, 3.792539078730129*^9, 3.7925391498539133`*^9, {
   3.7925532490372567`*^9, 3.792553269157399*^9}, {3.7925536620956464`*^9, 
   3.792553667672454*^9}, 3.7925537022735977`*^9, {3.792553890557179*^9, 
   3.7925538937751665`*^9}, {3.7925546404577494`*^9, 3.7925546465187893`*^9}, 
   3.7925547575953875`*^9, 3.7926551481604743`*^9, 3.802546774584007*^9, 
   3.802546806014125*^9, {3.8025471515108232`*^9, 3.802547153432208*^9}, {
   3.8025530095393133`*^9, 3.802553026457199*^9}, {3.8025532045714674`*^9, 
   3.802553229409363*^9}, 3.802553261038468*^9, 3.802553454664689*^9, {
   3.8025798431792006`*^9, 3.8025798457723475`*^9}, {3.8025800272037663`*^9, 
   3.802580027344387*^9}, {3.802582660552966*^9, 3.8025826638022027`*^9}, 
   3.8078545445533037`*^9, 3.8078546876419163`*^9, {3.807854721465523*^9, 
   3.8078547489939494`*^9}, 3.8078547791373887`*^9, {3.807855042242198*^9, 
   3.8078550464639173`*^9}, 3.816906024932904*^9, 3.816906211796054*^9, {
   3.8169062938236933`*^9, 3.816906310679119*^9}, 3.8169063942376285`*^9, 
   3.8169064881374598`*^9, 3.816906605547397*^9, {3.81690722223795*^9, 
   3.81690722739299*^9}, {3.816911790459921*^9, 3.816911790662994*^9}, {
   3.8208065113126163`*^9, 3.820806513952616*^9}, 3.8208066006040044`*^9, {
   3.8208066387668133`*^9, 3.820806640141487*^9}, {3.8208067180917654`*^9, 
   3.82080671859165*^9}, {3.8208068079142385`*^9, 3.820806816990216*^9}, 
   3.820807138147498*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.828286123457013*^9, {3.8282861747106113`*^9, 3.8282861989236813`*^9}, {
   3.828286440365247*^9, 3.8282864529248*^9}, {3.828553556846962*^9, 
   3.828553562587772*^9}, {3.828557128894436*^9, 3.8285571389096537`*^9}, {
   3.8285573314607916`*^9, 3.8285573321159925`*^9}, 3.828557376529271*^9, {
   3.8286360368995934`*^9, 3.828636050206417*^9}, 3.8286362099974976`*^9, 
   3.8286376533312335`*^9, 3.828718698781597*^9, {3.848257038638844*^9, 
   3.848257038638844*^9}, {3.8482571592822495`*^9, 3.8482571791525536`*^9}, 
   3.8482592259343624`*^9, {3.848259521700473*^9, 3.8482595244186172`*^9}, 
   3.848259575968937*^9, {3.848259744967764*^9, 3.848259748545044*^9}, {
   3.848259837688095*^9, 3.848259841812119*^9}, 3.848260108181464*^9, {
   3.8547617638692365`*^9, 3.8547617638848314`*^9}, 3.854761804515937*^9, 
   3.854761915152796*^9, {3.854762106815795*^9, 3.854762106987621*^9}, {
   3.8547621715706553`*^9, 3.854762191347271*^9}, {3.854762692983657*^9, 
   3.8547626933116884`*^9}, 3.8549110693034267`*^9, 3.883168548842718*^9, 
   3.883168591801283*^9, {3.8831693422177663`*^9, 3.883169342373979*^9}, 
   3.883170089065553*^9, {3.9565290756024103`*^9, 3.9565290756024103`*^9}, 
   3.956529277905364*^9, {3.9565293329237075`*^9, 3.956529358527069*^9}, 
   3.956529465626936*^9, {3.95652968441055*^9, 3.956529687425434*^9}, 
   3.956530150357442*^9, 3.956530343390212*^9, 3.9565304268131027`*^9, 
   3.956541558143319*^9, {3.956546649786872*^9, 3.956546668048131*^9}, {
   3.9565469418589067`*^9, 3.95654694610791*^9}, 3.956547118942315*^9, 
   3.956547186832667*^9, {3.9565482187887077`*^9, 3.956548219210427*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0190.png\>\"", ",", "adpConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955159803033*^9, 3.5339552034519095`*^9, 3.547008893618438*^9, 
   3.547008956314948*^9, {3.5501987477128153`*^9, 3.5501987478844156`*^9}, 
   3.5501988226865473`*^9, {3.550469306627704*^9, 3.5504693067681046`*^9}, 
   3.553114272723911*^9, 3.553114315530386*^9, 3.553114569972433*^9, 
   3.55318508843264*^9, {3.553185247131719*^9, 3.5531852473969193`*^9}, 
   3.5531900821741323`*^9, 3.55319015471426*^9, 3.5531908900479517`*^9, 
   3.5531909541796646`*^9, {3.553213790019997*^9, 3.5532138179752464`*^9}, {
   3.553214122440981*^9, 3.5532141511450315`*^9}, {3.556389578501213*^9, 
   3.556389578672813*^9}, 3.5563898772885375`*^9, {3.7325812073847427`*^9, 
   3.7325812080243435`*^9}, 3.7326535267504864`*^9, {3.732659119968313*^9, 
   3.732659120171114*^9}, {3.7326593137530546`*^9, 3.7326593214438686`*^9}, 
   3.740216750953225*^9, 3.740218228489431*^9, 3.740218990196377*^9, 
   3.74077860982647*^9, {3.740780605007178*^9, 3.7407806051787777`*^9}, 
   3.7407823021064887`*^9, {3.740795700305055*^9, 3.740795700539056*^9}, 
   3.7407957379479213`*^9, 3.7411140595270786`*^9, {3.7411141143767753`*^9, 
   3.741114114532776*^9}, 3.7411667457334538`*^9, {3.7411668447156277`*^9, 
   3.741166844871628*^9}, 3.74142115986131*^9, 3.744663700313615*^9, 
   3.744664379024007*^9, 3.7446656127845235`*^9, {3.7446659116810484`*^9, 
   3.744665911868249*^9}, 3.7452127175858293`*^9, {3.74521278093754*^9, 
   3.7452127811247406`*^9}, 3.7452152075218024`*^9, 3.7452154016881437`*^9, 
   3.7460519949503255`*^9, {3.7460520308459883`*^9, 3.74605203162599*^9}, 
   3.746055107834197*^9, 3.746991475479677*^9, {3.746991513918144*^9, 
   3.7469915424973946`*^9}, 3.746991645816376*^9, 3.748111177404529*^9, {
   3.748111322703184*^9, 3.748111322999585*^9}, 3.748112646147109*^9, {
   3.748113203645288*^9, 3.748113203988488*^9}, {3.7507167757248836`*^9, 
   3.7507167790164895`*^9}, 3.750716899963502*^9, {3.750907902190365*^9, 
   3.7509079301456137`*^9}, 3.75090826960221*^9, 3.751350024902258*^9, 
   3.7513500920135756`*^9, {3.7513503300387936`*^9, 3.751350330210394*^9}, 
   3.751400149651678*^9, {3.755049707478676*^9, 3.755049707634676*^9}, {
   3.755049765697978*^9, 3.75504976657158*^9}, 3.755049981945558*^9, 
   3.762283545821921*^9, 3.7622835936204047`*^9, 3.762283681510959*^9, 
   3.764280933902177*^9, 3.7642809906238766`*^9, {3.764281052961586*^9, 
   3.7642810835844398`*^9}, 3.7642811989934425`*^9, 3.764281290331603*^9, 
   3.764291454634307*^9, 3.7642915558472843`*^9, 3.7646644254065423`*^9, {
   3.7646645227819133`*^9, 3.7646645229067135`*^9}, {3.7648873755758543`*^9, 
   3.7648873757318544`*^9}, 3.764887973244104*^9, 3.7648894055102224`*^9, 
   3.765060231344472*^9, 3.765060779434235*^9, 3.7650876619491696`*^9, {
   3.7651708015085583`*^9, 3.7651708016333585`*^9}, 3.7651708746414866`*^9, 
   3.7652589118932266`*^9, {3.7652590299074335`*^9, 3.7652590301102343`*^9}, {
   3.7662195543382516`*^9, 3.766219578331094*^9}, 3.766219677016867*^9, 
   3.7662201983853827`*^9, 3.76647719987669*^9, 3.7664773392785344`*^9, 
   3.7664774867767935`*^9, 3.766477573559746*^9, 3.7666119106500444`*^9, {
   3.767393914938072*^9, 3.7673939150940723`*^9}, 3.7688458990076995`*^9, 
   3.768845992124263*^9, {3.7688460972060475`*^9, 3.768846097424448*^9}, 
   3.791925257442734*^9, {3.791926042673618*^9, 3.7919260678864145`*^9}, 
   3.7919411511491823`*^9, 3.7919412536874685`*^9, 3.7919455822489567`*^9, 
   3.791945613460332*^9, 3.7921427775327096`*^9, {3.7921442341379757`*^9, 
   3.7921442343566737`*^9}, 3.79214499129782*^9, {3.7921450432386465`*^9, 
   3.7921450433948555`*^9}, 3.7922066272150636`*^9, {3.7922081370131783`*^9, 
   3.7922081377629976`*^9}, 3.792270597728077*^9, {3.7922707124977846`*^9, 
   3.7922707126696568`*^9}, 3.792538656565729*^9, 3.792554019510995*^9, 
   3.802546808544753*^9, {3.8025468814650974`*^9, 3.802546882324236*^9}, 
   3.8025469199403934`*^9, 3.8025516303411865`*^9, {3.8025798413202734`*^9, 
   3.8025798500994525`*^9}, {3.80785445090362*^9, 3.8078544763037367`*^9}, 
   3.8078545477278557`*^9, 3.8169060294318476`*^9, 3.816906816785185*^9, 
   3.816906856635206*^9, 3.820806416772484*^9, 3.820806449655319*^9, 
   3.820806517936056*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.8278748592717104`*^9, 3.8278748912173123`*^9, 3.828286639443576*^9, 
   3.848257038638844*^9, 3.848257074614698*^9, 3.848257111481027*^9, 
   3.854761763900452*^9, {3.8547618323859158`*^9, 3.854761855958494*^9}, {
   3.883168591801283*^9, 3.88316864422643*^9}, 3.9565290756180315`*^9, {
   3.9565292024855556`*^9, 3.9565292145296135`*^9}, 3.9565466482091475`*^9, 
   3.9565466883246565`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"rp3dConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"RePlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20000"}], ",", "20000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"2000", ",", "2000"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"128", ",", "2"}], "}"}], ",", "24"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221349871864`*^9}, {3.533956562109496*^9, 3.533956663650075*^9}, 
   3.5339567557838364`*^9, 3.5347099882825756`*^9, 3.5347102657482634`*^9, {
   3.5347103008951254`*^9, 3.5347103043427315`*^9}, {3.535593994727907*^9, 
   3.535594052120408*^9}, {3.535594118654525*^9, 3.535594142257366*^9}, {
   3.53559417306742*^9, 3.5355941818346357`*^9}, {3.535594253173561*^9, 
   3.535594273141596*^9}, {3.535594308943659*^9, 3.535594311580064*^9}, {
   3.5355943417349167`*^9, 3.5355943446677217`*^9}, 3.5355944944279847`*^9, 
   3.5364644113098073`*^9, 3.547008961306957*^9, 3.547009174886932*^9, 
   3.5470100939009466`*^9, 3.5470101792522974`*^9, {3.547010219671968*^9, 
   3.5470102336495924`*^9}, {3.547010378308647*^9, 3.5470103791978483`*^9}, {
   3.5470106361019*^9, 3.547010661077544*^9}, 3.5501988290669584`*^9, 
   3.550199059994164*^9, 3.550199923226681*^9, {3.5501999833959866`*^9, 
   3.5501999880135946`*^9}, 3.5502073242848244`*^9, 3.5502076305611625`*^9, 
   3.5502077527405767`*^9, 3.550207824360303*^9, {3.5502086208227015`*^9, 
   3.5502086232251062`*^9}, 3.5502087333612995`*^9, {3.550210050393613*^9, 
   3.5502100620780334`*^9}, 3.5503471093742733`*^9, {3.5508011543922625`*^9, 
   3.5508011573094673`*^9}, 3.550801274574874*^9, 3.550828826075177*^9, 
   3.5531145222051487`*^9, 3.5531145764308443`*^9, 3.5531151448958426`*^9, {
   3.553115181758707*^9, 3.5531152194327736`*^9}, 3.5531152549228363`*^9, {
   3.553115444209176*^9, 3.5531154457847786`*^9}, 3.5531154834276447`*^9, 
   3.553184120965741*^9, 3.5531844553835287`*^9, 3.5531849288443604`*^9, {
   3.5531850323193417`*^9, 3.553185039214554*^9}, {3.5534455197643785`*^9, 
   3.5534455226191835`*^9}, {3.564290330151406*^9, 3.564290330151406*^9}, {
   3.564291249632621*^9, 3.5642913088503246`*^9}, {3.5642913587860126`*^9, 
   3.5642913874744625`*^9}, 3.5645701739454827`*^9, 3.56457022934118*^9, {
   3.5645704548083763`*^9, 3.564570523245696*^9}, 3.564632298359475*^9, 
   3.5672835710783267`*^9, 3.5672836098287945`*^9, 3.5672836500924654`*^9, 
   3.5672837096845703`*^9, {3.5672837599322586`*^9, 3.567283785797104*^9}, {
   3.567283815998757*^9, 3.567283882470474*^9}, 3.5672839294421563`*^9, 
   3.567283963200616*^9, 3.567749299701456*^9, 3.567802782394025*^9, 
   3.5678028822498007`*^9, {3.5681600327494287`*^9, 3.5681600592382755`*^9}, {
   3.568160109142763*^9, 3.5681601122315683`*^9}, 3.5681601467388287`*^9, {
   3.568160184319295*^9, 3.56816020424053*^9}, {3.568160517132702*^9, 
   3.568160596162441*^9}, 3.5681606610273547`*^9, {3.568160946421071*^9, 
   3.568160966030306*^9}, {3.5681705219146996`*^9, 3.5681705242703037`*^9}, 
   3.5681941899017687`*^9, 3.568194240352257*^9, 3.5700755677715073`*^9, 
   3.570075613354788*^9, 3.5700766540950155`*^9, {3.570086887572139*^9, 
   3.5700868877641497`*^9}, {3.570087003107747*^9, 3.570087005763899*^9}, {
   3.570087078020032*^9, 3.5700870989962316`*^9}, 3.5700872221102734`*^9, {
   3.57009623935571*^9, 3.570096282536586*^9}, 3.5736048119306808`*^9, 
   3.5736048904456186`*^9, 3.573604940833707*^9, {3.573605077677148*^9, 
   3.573605125865632*^9}, {3.5736051592964907`*^9, 3.573605161948496*^9}, {
   3.573605211119782*^9, 3.5736052136937866`*^9}, {3.5736052478578463`*^9, 
   3.5736052497922497`*^9}, 3.5736058726857443`*^9, 3.573605926771039*^9, {
   3.573605956925892*^9, 3.5736059886719475`*^9}, 3.573606090758527*^9, {
   3.5736061269973907`*^9, 3.57360615517104*^9}, {3.5736066713897743`*^9, 
   3.573606699345023*^9}, 3.573615836289501*^9, 3.57361605569005*^9, 
   3.5736161124242954`*^9, {3.5736161436740828`*^9, 3.5736161737138004`*^9}, 
   3.5736162263498116`*^9, {3.5736162577736087`*^9, 3.573616267602171*^9}, {
   3.573616444274276*^9, 3.5736164466824136`*^9}, {3.574885927166521*^9, 
   3.5748859637953854`*^9}, {3.5748860508435383`*^9, 
   3.5748860521695404`*^9}, {3.5748861157240524`*^9, 3.574886117252855*^9}, 
   3.57577235924708*^9, 3.5757724099589806`*^9, 3.575772445279001*^9, {
   3.5757724785189023`*^9, 3.5757724925687056`*^9}, {3.575772607702291*^9, 
   3.575772651454794*^9}, {3.5759741600893764`*^9, 3.575974161493379*^9}, {
   3.575974199510646*^9, 3.5759742220370855`*^9}, 3.576873240797937*^9, {
   3.5768733189384737`*^9, 3.576873344428919*^9}, {3.576873425346261*^9, 
   3.5768734529895096`*^9}, {3.576873485281566*^9, 3.5768734895091734`*^9}, {
   3.576873525514037*^9, 3.576873525701237*^9}, {3.577055332882147*^9, 
   3.5770553361425524`*^9}, 3.577871528638734*^9, {3.5778716843606405`*^9, 
   3.577871704824811*^9}, 3.5778717538886175`*^9, {3.5778718288889074`*^9, 
   3.577871876976658*^9}, {3.5778719113366227`*^9, 3.577871931008748*^9}, 
   3.577996382595691*^9, 3.5779973953859024`*^9, 3.577997497659682*^9, {
   3.592182738830336*^9, 3.592182738830336*^9}, 3.592182940881891*^9, 
   3.592183011815215*^9, {3.5921894364524994`*^9, 3.592189460086541*^9}, {
   3.592189491785797*^9, 3.592189494235001*^9}, {3.5921895481018953`*^9, 
   3.592189608177601*^9}, 3.592189794161128*^9, 3.5921898423808126`*^9, 
   3.5993883891423397`*^9, {3.5993886376195765`*^9, 3.5993886707696347`*^9}, 
   3.5993887338093452`*^9, 3.599388787067839*^9, 3.5993898053488283`*^9, 
   3.599450646030573*^9, 3.6063523737093935`*^9, {3.6063536327884064`*^9, 
   3.606353657155649*^9}, {3.6063536884961042`*^9, 3.606353715281351*^9}, {
   3.6063541082884493`*^9, 3.606354110690853*^9}, {3.606354174463765*^9, 
   3.6063541934333982`*^9}, 3.606354233681469*^9, {3.606354327624834*^9, 
   3.6063543393872547`*^9}, {3.6063554596717415`*^9, 3.606355469234558*^9}, {
   3.6063556589152913`*^9, 3.6063556888517437`*^9}, {3.6063559489462013`*^9, 
   3.60635597109824*^9}, {3.606356372177745*^9, 3.606356383128964*^9}, {
   3.6063564284002438`*^9, 3.606356435435856*^9}, 3.606356488460349*^9, {
   3.606356550096057*^9, 3.606356592091331*^9}, 3.606362300175032*^9, 
   3.606364095238985*^9, 3.6063646120054927`*^9, {3.606424049973319*^9, 
   3.606424053639326*^9}, 3.6064240927485943`*^9, 3.6064350337292786`*^9, 
   3.6253066892819157`*^9, 3.625306727517583*^9, {3.6253071403575087`*^9, 
   3.625307143961115*^9}, 3.6253071830235834`*^9, 3.625307214270438*^9, 
   3.62530768864248*^9, {3.625307721074937*^9, 3.6253077378137665`*^9}, {
   3.6253078152835026`*^9, 3.625307818465908*^9}, 3.6253078603831816`*^9, 
   3.625308042795102*^9, {3.625308091591988*^9, 3.6253080991112013`*^9}, {
   3.625383389886337*^9, 3.625383390822338*^9}, 3.6253834238787966`*^9, 
   3.6291871861181545`*^9, 3.629187255195076*^9, {3.629187298329152*^9, 
   3.629187319170789*^9}, 3.629187721281896*^9, {3.629187761576767*^9, 
   3.629187773105187*^9}, 3.629187853476528*^9, {3.629189386050821*^9, 
   3.6291893870960226`*^9}, 3.6294129792897773`*^9, {3.629681940821416*^9, 
   3.629681967825063*^9}, 3.6296830652981987`*^9, {3.629683828638739*^9, 
   3.629683873535618*^9}, 3.6296840724983673`*^9, 3.629684659074998*^9, {
   3.6296848918274064`*^9, 3.629684894619811*^9}, 3.630130105717137*^9, 
   3.6301868115768538`*^9, 3.6301913486360464`*^9, {3.6301914399118066`*^9, 
   3.630191440754208*^9}, {3.6301915173347425`*^9, 3.630191517662343*^9}, {
   3.630191564462425*^9, 3.6301915646184254`*^9}, 3.6301916235085287`*^9, 
   3.6301916648486013`*^9, {3.6301916949722548`*^9, 3.630191743254339*^9}, 
   3.630192498482866*^9, 3.630224013755659*^9, 3.6325489583565407`*^9, 
   3.6325493465892234`*^9, 3.6325495969920783`*^9, 3.6325497909544272`*^9, {
   3.6325499065150375`*^9, 3.6325499323798833`*^9}, {3.6326039905906425`*^9, 
   3.6326039969398537`*^9}, {3.6326052476784515`*^9, 3.6326052678180866`*^9}, 
   3.632789691264064*^9, {3.632789738937748*^9, 3.632789739811349*^9}, {
   3.632789771198604*^9, 3.63278978590943*^9}, 3.632789880617196*^9, 
   3.6327899977890024`*^9, 3.63279813902344*^9, 3.632798262731657*^9, 
   3.632807713384465*^9, 3.6328077532581353`*^9, {3.632813931449418*^9, 
   3.6328140063139496`*^9}, {3.632814038262806*^9, 3.632814038481206*^9}, {
   3.6328142150367174`*^9, 3.632814235581953*^9}, {3.632862829136717*^9, 
   3.6328628333643246`*^9}, 3.632863060297923*^9, 3.6328903848425245`*^9, 
   3.6345039605706234`*^9, 3.6345039979950895`*^9, 3.634505028388706*^9, {
   3.634505073659986*^9, 3.634505094844823*^9}, {3.6345051346835*^9, 
   3.6345051909059987`*^9}, {3.634505248002099*^9, 3.6345052831177607`*^9}, 
   3.6345058717026*^9, {3.6345559035261827`*^9, 3.6345559061157875`*^9}, {
   3.634555945349856*^9, 3.634555948313861*^9}, 3.634556202246708*^9, {
   3.6360748453404164`*^9, 3.6360748476336203`*^9}, 3.636075402244196*^9, 
   3.6360755387756352`*^9, 3.6360756646834564`*^9, 3.636076028008095*^9, 
   3.6360760583769555`*^9, {3.6360761965931983`*^9, 3.6360762071856165`*^9}, 
   3.6364953485684733`*^9, 3.6364953884889436`*^9, 3.636495515816367*^9, 
   3.6364955598396444`*^9, 3.63649577777445*^9, {3.6364958118137093`*^9, 
   3.636495860766596*^9}, 3.636495993039228*^9, 3.636496147385899*^9, {
   3.636496214996418*^9, 3.636496253372485*^9}, 3.6364964311815977`*^9, {
   3.6364969697417445`*^9, 3.6364969814261646`*^9}, {3.636762383421364*^9, 
   3.6367623872745705`*^9}, 3.725592441562623*^9, 3.7255925278151746`*^9, 
   3.7255944795378036`*^9, {3.72559451145546*^9, 3.7255945146846657`*^9}, 
   3.7255953568521447`*^9, 3.725595801020926*^9, 3.725595862875035*^9, 
   3.725596145750332*^9, 3.72559634416708*^9, 3.7255964017623816`*^9, {
   3.725600882543482*^9, 3.725600909469129*^9}, 3.725601380552758*^9, 
   3.725771260842998*^9, {3.725774253989055*^9, 3.725774282505905*^9}, {
   3.725774385294486*^9, 3.725774424243362*^9}, {3.7257804563043575`*^9, 
   3.7257804693615804`*^9}, 3.7258490252477674`*^9, 3.7258521016447725`*^9, 
   3.725852258877449*^9, 3.725852363803233*^9, 3.7258524000108967`*^9, 
   3.725852749623111*^9, {3.7258530098159676`*^9, 3.7258530484884357`*^9}, {
   3.7258533935578427`*^9, 3.7258534235566955`*^9}, {3.725853537717696*^9, 
   3.725853546578511*^9}, 3.726913461460272*^9, {3.7269135067003517`*^9, 
   3.726913506715952*^9}, 3.726913573655669*^9, 3.7269142247852125`*^9, {
   3.726914355279442*^9, 3.726914372969873*^9}, 3.7269144359471836`*^9, 
   3.7269145160221243`*^9, 3.726914654581568*^9, 3.726914723206088*^9, {
   3.7269151216475897`*^9, 3.726915129884404*^9}, 3.726915517287485*^9, {
   3.726942972603111*^9, 3.7269429731335115`*^9}, 3.726952629442474*^9, 
   3.7269527024818025`*^9, {3.7325814358471437`*^9, 3.732581510446475*^9}, 
   3.7325815475277395`*^9, {3.7326584462775297`*^9, 3.732658472844376*^9}, {
   3.732658943126403*^9, 3.732658966682444*^9}, 3.7326593293998823`*^9, 
   3.732668442777998*^9, {3.7402181611597123`*^9, 3.740218186072956*^9}, 
   3.740218232124237*^9, {3.7402183905893154`*^9, 3.7402183918841176`*^9}, 
   3.740218439771809*^9, 3.7402184717362657`*^9, {3.740218744752345*^9, 
   3.740218755048363*^9}, {3.7402188877977967`*^9, 3.740218953427112*^9}, {
   3.7402206710333304`*^9, 3.740220709690198*^9}, 3.740623517482953*^9, {
   3.740778612338074*^9, 3.740778614194477*^9}, {3.740778697514224*^9, 
   3.740778713769452*^9}, {3.7407792507571983`*^9, 3.740779281707652*^9}, {
   3.7407793154973116`*^9, 3.7407793317681403`*^9}, {3.74077962170185*^9, 
   3.740779646209493*^9}, 3.7407805331690516`*^9, 3.7407805721691203`*^9, 
   3.7407807771378803`*^9, 3.7407824673731785`*^9, 3.740784298882004*^9, 
   3.740784367336528*^9, 3.7407845511906676`*^9, 3.7407847911139035`*^9, 
   3.740785320891444*^9, {3.740792222878537*^9, 3.74079222451654*^9}, 
   3.740795734391115*^9, 3.7407958434197063`*^9, 3.7407962499408207`*^9, 
   3.740796287817687*^9, 3.7407968561734858`*^9, 3.7407968980127587`*^9, {
   3.7411140633022857`*^9, 3.741114065189889*^9}, 3.7411141817688937`*^9, {
   3.7411142451362047`*^9, 3.7411142815778685`*^9}, {3.7411143643984146`*^9, 
   3.741114394927668*^9}, 3.741114449028563*^9, 3.741165053951681*^9, 
   3.7411667429098487`*^9, 3.741166800005949*^9, 3.741167002587905*^9, 
   3.7418927044966946`*^9, 3.744663705024823*^9, 3.744664181730461*^9, 
   3.7446656128001237`*^9, 3.7446656519405923`*^9, 3.7447503917826357`*^9, 
   3.744875558139942*^9, 3.745212724418641*^9, 3.7452130520192165`*^9, 
   3.7452134415987005`*^9, {3.7452134772759633`*^9, 3.745213477884364*^9}, 
   3.745213581842947*^9, 3.745213760572461*^9, {3.7452137926617174`*^9, 
   3.7452138142521553`*^9}, {3.7452138718318567`*^9, 3.745213901846309*^9}, 
   3.74521397072043*^9, {3.7452140044788895`*^9, 3.745214017692113*^9}, {
   3.745215374934097*^9, 3.745215398848939*^9}, 3.745215733004327*^9, {
   3.745215869754167*^9, 3.74521587134537*^9}, {3.7452159052910295`*^9, 
   3.7452159092066364`*^9}, {3.745215982604765*^9, 3.7452159998115954`*^9}, 
   3.7452162565100465`*^9, 3.74605199750873*^9, {3.7460524917799983`*^9, 
   3.7460525007812138`*^9}, 3.7460544899795113`*^9, 3.74605461420253*^9, {
   3.746054731577136*^9, 3.746054777706417*^9}, {3.7460548234768972`*^9, 
   3.7460548417133293`*^9}, 3.746054911461052*^9, 3.7469916527895885`*^9, 
   3.746995583616094*^9, 3.7469956167661524`*^9, {3.7469957258615446`*^9, 
   3.7469957275151477`*^9}, {3.746995760977206*^9, 3.746995762147208*^9}, {
   3.7469958133464985`*^9, 3.746995836512539*^9}, 3.746995880816617*^9, {
   3.7469959276946993`*^9, 3.746995931984707*^9}, {3.7470008112785206`*^9, 
   3.7470008135717244`*^9}, {3.7470008798094406`*^9, 3.747000881369444*^9}, {
   3.747027563106309*^9, 3.74702756362111*^9}, {3.747028030906732*^9, 
   3.747028033511936*^9}, 3.7481111814917364`*^9, 3.7481112473238516`*^9, 
   3.748111472572647*^9, 3.748111511900316*^9, 3.748111751157937*^9, 
   3.7481117965072165`*^9, 3.748111837706889*^9, 3.7481119389198666`*^9, 
   3.748112002271578*^9, 3.7481126431207037`*^9, 3.7481127702141266`*^9, 
   3.748112890599538*^9, 3.748112975042486*^9, {3.748113023496172*^9, 
   3.748113025196574*^9}, 3.748113104850314*^9, 3.7481148783458304`*^9, 
   3.748152378124942*^9, 3.748156761576641*^9, 3.749668426627076*^9, 
   3.7507169093079185`*^9, {3.750717434654441*^9, 3.7507174520016713`*^9}, 
   3.7507179985374317`*^9, 3.7507180693303566`*^9, 3.750718107222823*^9, {
   3.750718237732652*^9, 3.7507182378574524`*^9}, 3.750718351924853*^9, {
   3.750719888347952*^9, 3.75071989302796*^9}, 3.75072066733372*^9, 
   3.750724214763152*^9, 3.7507255977531834`*^9, 3.7507440011381135`*^9, {
   3.7507441014618897`*^9, 3.7507441048314953`*^9}, 3.7511831548137474`*^9, 
   3.7511832008026285`*^9, {3.751189420749557*^9, 3.7511894221223593`*^9}, {
   3.751189545112975*^9, 3.7511895500581837`*^9}, {3.751191026389179*^9, 
   3.751191036263996*^9}, {3.7511922279880896`*^9, 3.75119225077973*^9}, {
   3.7512741081272516`*^9, 3.7512741083924522`*^9}, 3.751343680793913*^9, {
   3.7513437352380085`*^9, 3.751343748076831*^9}, {3.751343859991428*^9, 
   3.7513438704746466`*^9}, 3.751343972284826*^9, {3.751344206045637*^9, 
   3.751344228946477*^9}, {3.751345479654274*^9, 3.751345479669874*^9}, 
   3.7513458163340654`*^9, {3.7513459501355004`*^9, 3.751345950946702*^9}, 
   3.751346259250044*^9, {3.75134772036421*^9, 3.751347750955864*^9}, {
   3.7513478386904173`*^9, 3.7513478502656384`*^9}, {3.7513480264523478`*^9, 
   3.7513480387451687`*^9}, {3.751356659578311*^9, 3.7513566652723207`*^9}, {
   3.7513584868487215`*^9, 3.751358487051522*^9}, {3.7513587764620385`*^9, 
   3.7513587766960387`*^9}, 3.751359217521613*^9, 3.755049981961158*^9, 
   3.755050081910534*^9, 3.7550501621414747`*^9, {3.7550504076079054`*^9, 
   3.7550504105563107`*^9}, 3.755050934296031*^9, 3.7550519317455764`*^9, {
   3.7550519933656845`*^9, 3.7550521232671127`*^9}, 3.7550521578835735`*^9, 
   3.755061383808256*^9, 3.755137961376438*^9, {3.7551380194709396`*^9, 
   3.755138043448182*^9}, 3.7551380790006447`*^9, {3.755138180494423*^9, 
   3.7551382149704833`*^9}, 3.7551383199274673`*^9, {3.7551384479880924`*^9, 
   3.755138485646559*^9}, {3.7551385328522415`*^9, 3.755138535301446*^9}, {
   3.7551388552780085`*^9, 3.755138867898431*^9}, {3.755138899379286*^9, 
   3.755138900923689*^9}, {3.755141473017996*^9, 3.7551414735015965`*^9}, 
   3.7551423127060127`*^9, 3.755143428371771*^9, {3.7551475899709272`*^9, 
   3.7551475974589405`*^9}, {3.755147763630432*^9, 3.755147798215693*^9}, 
   3.7552236306629615`*^9, 3.7552237351007524`*^9, {3.7552274948275833`*^9, 
   3.7552275018475957`*^9}, 3.7642903579671755`*^9, {3.7642905351382875`*^9, 
   3.764290614448827*^9}, 3.764290670343725*^9, {3.7642907227754173`*^9, 
   3.7642907831007233`*^9}, {3.764290822865193*^9, 3.7642908322408094`*^9}, 
   3.7642909401461987`*^9, {3.76429097484066*^9, 3.764290976041862*^9}, 
   3.764291199136257*^9, {3.7642913149984617`*^9, 3.7642913174008656`*^9}, 
   3.7642916029593673`*^9, 3.764302351074251*^9, 3.7643023945203276`*^9, 
   3.764304227843149*^9, 3.7643178515372825`*^9, 3.76432045498466*^9, 
   3.764370158357931*^9, 3.7643729553032446`*^9, {3.764374606185746*^9, 
   3.764374606466547*^9}, 3.7643849800828085`*^9, 3.764385335676648*^9, {
   3.7646681230006466`*^9, 3.764668147102689*^9}, {3.764668200189582*^9, 
   3.764668201515584*^9}, {3.764668246396863*^9, 3.764668249766469*^9}, 
   3.764668283384528*^9, 3.7646685415805817`*^9, 3.764887973275304*^9, 
   3.764888009139767*^9, 3.7648889009273357`*^9, {3.764890388914151*^9, 
   3.7648904010509725`*^9}, {3.764890438990239*^9, 3.764890439130639*^9}, 
   3.7648906343181825`*^9, 3.76489671665236*^9, 3.7650607837398424`*^9, 
   3.7651708746570864`*^9, 3.7651709275255795`*^9, {3.7651715865911446`*^9, 
   3.7651716002099686`*^9}, {3.765172130556101*^9, 3.7651721436133237`*^9}, 
   3.765258860522336*^9, 3.7652589119088264`*^9, 3.765267845342927*^9, 
   3.766219677032467*^9, 3.766219733644967*^9, 3.766220205062195*^9, 
   3.766224732047748*^9, {3.766371669949203*^9, 3.766371670120803*^9}, {
   3.7664771998922896`*^9, 3.7664772214515276`*^9}, {3.7664774867767935`*^9, 
   3.7664775002396173`*^9}, {3.768845899023299*^9, 3.768845913219324*^9}, {
   3.7688464421018543`*^9, 3.7688464430066557`*^9}, {3.768846907500272*^9, 
   3.768846908498674*^9}, {3.7756127056776414`*^9, 3.7756127085636463`*^9}, 
   3.7919252574583597`*^9, 3.791925346562312*^9, 3.7919254153117027`*^9, {
   3.7919255247077045`*^9, 3.791925531253033*^9}, 3.791925598002926*^9, {
   3.791925817141368*^9, 3.791925857178751*^9}, {3.7919259309425774`*^9, 
   3.791925933801317*^9}, {3.7919260057136*^9, 3.791926009212773*^9}, {
   3.79192660049582*^9, 3.7919266190539074`*^9}, {3.7919271891237907`*^9, 
   3.7919272245842*^9}, {3.7919274867894063`*^9, 3.791927489554371*^9}, {
   3.791927538745885*^9, 3.791927604824026*^9}, {3.7919283206321373`*^9, 
   3.791928328770767*^9}, 3.7919283681131506`*^9, 3.791941147556281*^9, 
   3.791941226943779*^9, {3.791943064803152*^9, 3.791943072441972*^9}, 
   3.7919455853419733`*^9, 3.7919456390636563`*^9, 3.7919457301594105`*^9, {
   3.7919460176571693`*^9, 3.791946064630477*^9}, 3.7919462776270447`*^9, {
   3.7919463420805435`*^9, 3.7919463444393888`*^9}, {3.791948507232851*^9, 
   3.7919485077639413`*^9}, 3.7921427775327096`*^9, 3.7921428813674984`*^9, {
   3.7921430077438335`*^9, 3.7921430285982695`*^9}, {3.792143075102886*^9, 
   3.792143196527261*^9}, 3.7921432320813465`*^9, {3.7921435108289423`*^9, 
   3.7921435112507515`*^9}, {3.792144994000306*^9, 3.7921450236495314`*^9}, 
   3.7921450984755683`*^9, {3.792145135779237*^9, 3.7921451459487057`*^9}, 
   3.7921451813309965`*^9, {3.7921455405896435`*^9, 3.792145540823963*^9}, {
   3.792184495223648*^9, 3.7921844998788123`*^9}, {3.792184623771303*^9, 
   3.7921846334096813`*^9}, {3.792206627230712*^9, 3.792206627230712*^9}, 
   3.7922067487800713`*^9, {3.792206857551155*^9, 3.7922068652212453`*^9}, 
   3.79220731139717*^9, 3.7922074804352627`*^9, {3.792207911722797*^9, 
   3.792207920220762*^9}, 3.7922106315283227`*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709234165945`*^9, 3.7922709273375435`*^9}, 
   3.7922709952589617`*^9, 3.792271044919084*^9, {3.7922714000850353`*^9, 
   3.7922714133162184`*^9}, {3.79227225780206*^9, 3.7922722845301075`*^9}, 
   3.7922726379453006`*^9, 3.792538656581356*^9, 3.792538928359619*^9, {
   3.79253897772618*^9, 3.7925389929881973`*^9}, 3.792539105239499*^9, 
   3.7925391544309196`*^9, {3.7925392146979003`*^9, 3.7925392318501225`*^9}, {
   3.792553251880274*^9, 3.7925533135219245`*^9}, {3.792553558651388*^9, 
   3.7925535983294907`*^9}, 3.7925536300406995`*^9, 3.792553977661547*^9, 
   3.7934110765855913`*^9, 3.802546778036353*^9, 3.8025468148870387`*^9, 
   3.802552822458405*^9, {3.8025530544662237`*^9, 3.8025530844279113`*^9}, {
   3.802553133713169*^9, 3.8025531354783773`*^9}, {3.8025532097421217`*^9, 
   3.8025532578048534`*^9}, {3.802553588023881*^9, 3.802553607941058*^9}, {
   3.8025798334471254`*^9, 3.802579836009097*^9}, 3.8025799428439727`*^9, 
   3.8025826954822035`*^9, 3.807854554258397*^9, 3.807854690828374*^9, {
   3.8078547263903584`*^9, 3.8078547526052713`*^9}, {3.8078547973826*^9, 
   3.8078548259492536`*^9}, 3.807854857290492*^9, {3.807855065442194*^9, 
   3.8078550755771074`*^9}, 3.816906042506902*^9, 3.8169062174197626`*^9, {
   3.8169062961825204`*^9, 3.8169063081953278`*^9}, 3.8169064017358685`*^9, 
   3.8169064565355053`*^9, {3.816906506133236*^9, 3.816906533095647*^9}, 
   3.8169065818185563`*^9, 3.816906741702897*^9, 3.8169069030617733`*^9, 
   3.816911863808765*^9, {3.820806523044219*^9, 3.820806525543599*^9}, {
   3.820806605337228*^9, 3.820806634720892*^9}, {3.820806728870463*^9, 
   3.8208067606910887`*^9}, 3.8208068514664154`*^9, 3.8208068887857084`*^9, {
   3.820806986417849*^9, 3.820806992557019*^9}, 3.820807050543249*^9, 
   3.8208071575179443`*^9, {3.827874604494393*^9, 3.8278746309725633`*^9}, 
   3.828286126815601*^9, 3.828286178522227*^9, {3.8282862114207487`*^9, 
   3.828286249083788*^9}, 3.8282862800765343`*^9, {3.828286322644653*^9, 
   3.828286322972701*^9}, {3.828286357931463*^9, 3.828286378520382*^9}, 
   3.828286413949597*^9, 3.8282865511517544`*^9, 3.828849014384474*^9, {
   3.8482570386544743`*^9, 3.8482570386544743`*^9}, {3.848257162547103*^9, 
   3.8482572050995564`*^9}, 3.8482572474489293`*^9, 3.8482592289492965`*^9, 
   3.8482592632131195`*^9, 3.8482593480525*^9, {3.8482596406568003`*^9, 
   3.848259662354802*^9}, {3.8482598575520773`*^9, 3.848259863863089*^9}, {
   3.848259935769012*^9, 3.848259938174694*^9}, {3.848260033511561*^9, 
   3.8482600702372885`*^9}, {3.848260636230188*^9, 3.848260666894863*^9}, 
   3.8482606989966545`*^9, 3.8482607541243086`*^9, {3.8547617639317226`*^9, 
   3.854761763947344*^9}, 3.854761807093421*^9, {3.854761939287712*^9, 
   3.854761948035654*^9}, {3.854762215597452*^9, 3.8547622692588873`*^9}, {
   3.8547623089584866`*^9, 3.854762311739122*^9}, {3.8547623431746674`*^9, 
   3.854762363654195*^9}, 3.854763519987254*^9, 3.8831684261211495`*^9, 
   3.883168549077005*^9, 3.8831685918169317`*^9, {3.883169007296896*^9, 
   3.88316901865359*^9}, 3.883169538507764*^9, 3.8831706590004115`*^9, 
   3.883170863795307*^9, {3.9565290756180315`*^9, 3.9565290756180315`*^9}, 
   3.9565292781396837`*^9, {3.9565293331424026`*^9, 3.9565293645100403`*^9}, 
   3.9565294692042217`*^9, 3.956529507929509*^9, {3.9565295473808737`*^9, 
   3.9565295677979517`*^9}, {3.9565297430061445`*^9, 
   3.9565297484892626`*^9}, {3.956529847778465*^9, 3.956529900063098*^9}, {
   3.9565301658693733`*^9, 3.956530172289773*^9}, 3.9565304532600217`*^9, {
   3.956546645162876*^9, 3.956546671516094*^9}, {3.956547099525032*^9, 
   3.9565471318611584`*^9}, {3.9565471656188617`*^9, 
   3.9565471910504293`*^9}, {3.9565482301141186`*^9, 
   3.9565482547333107`*^9}, {3.956555971195315*^9, 3.9565559740540113`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0200.png\>\"", ",", "rp3dConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.5339551667918453`*^9, 3.5339552009091053`*^9, 3.5470088969568434`*^9, 
   3.5470089640057616`*^9, {3.5501987513788223`*^9, 3.550198751410022*^9}, 
   3.5501988321245637`*^9, {3.5504693115261126`*^9, 3.550469311666513*^9}, 
   3.5531142779343195`*^9, 3.5531143119735794`*^9, 3.5531145798316503`*^9, 
   3.55318508241103*^9, {3.55318525330933*^9, 3.5531852534809303`*^9}, 
   3.553190085153738*^9, 3.553190157912266*^9, 3.553190885227544*^9, {
   3.553190960606876*^9, 3.5531909607628765`*^9}, {3.5532137942008047`*^9, 
   3.553213813825639*^9}, {3.55321412771379*^9, 3.553214156714241*^9}, {
   3.556389588766031*^9, 3.5563895889376307`*^9}, 3.5563898811573443`*^9, {
   3.7325812234839706`*^9, 3.7325812239051714`*^9}, 3.7326535205260754`*^9, {
   3.7326591250071225`*^9, 3.7326591252255225`*^9}, 3.732659348416316*^9, 
   3.7402167509688253`*^9, 3.740218234479841*^9, 3.740218993768783*^9, 
   3.740778618671685*^9, {3.7407806106543875`*^9, 3.740780610810388*^9}, {
   3.740782307394898*^9, 3.7407823078160987`*^9}, {3.7407957072626677`*^9, 
   3.740795732191511*^9}, 3.7411140683254943`*^9, {3.7411141195091844`*^9, 
   3.7411141197119846`*^9}, 3.7411667406790447`*^9, {3.7411668525936413`*^9, 
   3.7411668526872416`*^9}, {3.7414211411412773`*^9, 3.7414211413128777`*^9}, 
   3.7446637082540293`*^9, {3.744664383891216*^9, 3.7446643841564164`*^9}, 
   3.7446656128001237`*^9, {3.744665919325062*^9, 3.7446659194654617`*^9}, 
   3.745212728256248*^9, {3.7452127863195496`*^9, 3.7452127865379505`*^9}, 
   3.745215210719808*^9, 3.7452153969769354`*^9, 3.7460519999891343`*^9, {
   3.7460520390048027`*^9, 3.746052039628804*^9}, 3.7460551110166025`*^9, 
   3.7469914786308823`*^9, {3.7469915178025513`*^9, 3.746991547068203*^9}, 
   3.7469916572823963`*^9, 3.7481111850173426`*^9, {3.7481113291771955`*^9, 
   3.748111329348796*^9}, 3.7481126410927*^9, 3.7481132104469*^9, {
   3.750716795334118*^9, 3.7507167978769226`*^9}, 3.750716914752328*^9, 
   3.750907902205965*^9, {3.7509079354808235`*^9, 3.750907935777224*^9}, 
   3.7509082696178102`*^9, 3.751350024917858*^9, 3.7513500920135756`*^9, {
   3.751350335186803*^9, 3.7513503353740034`*^9}, 3.7514001537856855`*^9, {
   3.7550497020342665`*^9, 3.755049702159066*^9}, {3.755049780455604*^9, 
   3.7550497817660065`*^9}, 3.755049981961158*^9, 3.7622835534347343`*^9, 
   3.7622835983940134`*^9, 3.7622836925245786`*^9, 3.7642809470685997`*^9, 
   3.764280993650282*^9, {3.764281062056402*^9, 3.7642810876404467`*^9}, 
   3.7642812103970623`*^9, {3.7642812957916126`*^9, 3.764281295994413*^9}, 
   3.7642914608743176`*^9, 3.7642915591544905`*^9, 3.764664425437742*^9, {
   3.7646645337331324`*^9, 3.7646645339047327`*^9}, {3.7648873895846786`*^9, 
   3.764887389771879*^9}, 3.764887973275304*^9, 3.764889411126232*^9, 
   3.765060236898082*^9, 3.7650607861422467`*^9, {3.765087671387186*^9, 
   3.7650876715275865`*^9}, {3.7651708114457755`*^9, 3.765170811664176*^9}, 
   3.7651708746570864`*^9, 3.765258911924426*^9, {3.765259045601061*^9, 
   3.7652590457882614`*^9}, {3.766219554353852*^9, 3.766219582964302*^9}, 
   3.766219677032467*^9, 3.7662202070277977`*^9, 3.7664771998922896`*^9, 
   3.7664773392785344`*^9, 3.7664774867923937`*^9, 3.766477573575346*^9, 
   3.766611931678881*^9, {3.7673939264508924`*^9, 3.767393926622493*^9}, 
   3.768845899023299*^9, 3.768845992139863*^9, 3.7688461046784606`*^9, 
   3.791925257473979*^9, 3.7919260459384813`*^9, {3.791926076384407*^9, 
   3.791926077056122*^9}, 3.7919411447288256`*^9, 3.7919412585144467`*^9, {
   3.791945587700791*^9, 3.7919456092894487`*^9}, 3.7921427775327096`*^9, {
   3.7921442396836076`*^9, 3.7921442398866467`*^9}, 3.7921449966246824`*^9, {
   3.7921450490810156`*^9, 3.792145049205987*^9}, 3.792206627230712*^9, {
   3.792208145964188*^9, 3.7922081471983175`*^9}, 3.7922705977436914`*^9, {
   3.7922707178871346`*^9, 3.792270718027725*^9}, 3.792538656581356*^9, 
   3.792554025353397*^9, 3.8025468178550973`*^9, {3.8025468885259333`*^9, 
   3.802546916941086*^9}, 3.8025516349182377`*^9, {3.8025798245429773`*^9, 
   3.8025798309477167`*^9}, 3.8078544471885157`*^9, {3.807854484527757*^9, 
   3.8078544851420836`*^9}, 3.8078545576323867`*^9, 3.8169060469746084`*^9, 
   3.8169068200344243`*^9, 3.816906860056246*^9, 3.8208064231928377`*^9, 
   3.82080645710668*^9, 3.8208065296052046`*^9, {3.827874604510014*^9, 
   3.8278746309725633`*^9}, 3.8278748592717104`*^9, 3.827874904026807*^9, 
   3.828286644676685*^9, 3.8482570386544743`*^9, 3.8482570746303196`*^9, 
   3.8482571201821003`*^9, 3.854761763962966*^9, {3.8547618360100236`*^9, 
   3.8547618598794146`*^9}, {3.883168591832553*^9, 3.8831686183106723`*^9}, {
   3.883168650240633*^9, 3.883168650334363*^9}, 3.9565290756336536`*^9, {
   3.9565292024855556`*^9, 3.9565292194190598`*^9}, 3.9565466431633916`*^9, {
   3.956546692776702*^9, 3.9565466929485703`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ip3dConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"ImPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20000"}], ",", "20000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"2000", ",", "2000"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"128", ",", "2"}], "}"}], ",", "24"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221546276207`*^9}, {3.533956568630308*^9, 3.533956665834079*^9}, 
   3.533956762975449*^9, 3.534709995286988*^9, 3.5347102702566714`*^9, {
   3.534710307587537*^9, 3.5347103104111423`*^9}, {3.5355943645733566`*^9, 
   3.535594376788178*^9}, 3.535594491198779*^9, 3.5364644067701993`*^9, 
   3.5470089687325697`*^9, 3.5470091814857435`*^9, 3.547010097738553*^9, 
   3.5470101745878887`*^9, {3.5470102237747755`*^9, 3.547010237268799*^9}, {
   3.547010380711051*^9, 3.5470103817718525`*^9}, {3.5470104851844344`*^9, 
   3.547010496198054*^9}, {3.5470106544943323`*^9, 3.5470106643379498`*^9}, 
   3.5501988381617746`*^9, 3.5501990644401717`*^9, 3.5501999267834873`*^9, 
   3.55019999637521*^9, 3.5502073267184286`*^9, 3.5502076353347707`*^9, 
   3.5502077484661694`*^9, 3.550207835311522*^9, 3.5502086336303244`*^9, 
   3.550208731848097*^9, 3.550210071001249*^9, 3.550347114335082*^9, {
   3.550801163206278*^9, 3.550801166139083*^9}, 3.550801269660865*^9, 
   3.550828851690422*^9, 3.5531145252783546`*^9, 3.5531145863212614`*^9, 
   3.55311514895185*^9, {3.5531151847383127`*^9, 3.553115215641967*^9}, 
   3.553115260164445*^9, {3.5531154473135815`*^9, 3.553115448514784*^9}, 
   3.5531154849408474`*^9, 3.553184125130948*^9, 3.5531844635735426`*^9, 
   3.553184932650767*^9, {3.5531850286689353`*^9, 3.5531850425373597`*^9}, {
   3.5534455293427954`*^9, 3.553445530746798*^9}, {3.5534883365952864`*^9, 
   3.553488340932094*^9}, 3.553543103023369*^9, {3.5642903301670055`*^9, 
   3.5642903301670055`*^9}, {3.564291253782228*^9, 3.564291279803074*^9}, {
   3.564291310691128*^9, 3.5642913116739297`*^9}, 3.5642913605800157`*^9, 
   3.5642913913588696`*^9, 3.5645701775490894`*^9, 3.5645702349415903`*^9, {
   3.5645704646519933`*^9, 3.5645704806576214`*^9}, {3.564632162083235*^9, 
   3.5646321622704353`*^9}, {3.5672835744635324`*^9, 3.567283599189576*^9}, 
   3.567283658984481*^9, 3.567283712648576*^9, {3.5672837757506866`*^9, 
   3.5672838367779937`*^9}, 3.567283936711769*^9, 3.5672839671942225`*^9, 
   3.567749304927465*^9, 3.567802786200432*^9, 3.5678028867426085`*^9, 
   3.568197679377499*^9, 3.5681977398588057`*^9, {3.568197770497259*^9, 
   3.568197789934893*^9}, 3.568197954873983*^9, 3.570075573527918*^9, 
   3.5700756161159925`*^9, 3.5700766576674213`*^9, {3.570086891428359*^9, 
   3.5700868916123695`*^9}, {3.570087021291787*^9, 3.5700870234839125`*^9}, {
   3.570087084260389*^9, 3.5700871039165125`*^9}, 3.5700872267835407`*^9, {
   3.5700962429593163`*^9, 3.570096251367731*^9}, 3.5700963382910833`*^9, 
   3.573604824020702*^9, 3.573604898479633*^9, 3.5736049445153136`*^9, {
   3.5736050810779533`*^9, 3.5736051059131975`*^9}, 3.573605138158454*^9, 
   3.5736051863625383`*^9, {3.573605233568221*^9, 3.5736052565938616`*^9}, 
   3.573605861250924*^9, 3.5736059303122454`*^9, 3.5736059609350986`*^9, {
   3.573605994537558*^9, 3.5736059957855597`*^9}, 3.573606094143733*^9, 
   3.5736061630646544`*^9, {3.5736066875826025`*^9, 3.5736067019502277`*^9}, 
   3.573615827794015*^9, 3.573616064212538*^9, {3.5736161174245815`*^9, 
   3.573616176377953*^9}, 3.573616231172087*^9, 3.573616275574627*^9, {
   3.5736164520657215`*^9, 3.5736164539218273`*^9}, {3.574885930536127*^9, 
   3.574885961158981*^9}, {3.5748860538543434`*^9, 3.574886055414346*^9}, {
   3.57488610316603*^9, 3.574886104788433*^9}, 3.575772368950635*^9, 
   3.575772414543243*^9, {3.5757724483991795`*^9, 3.575772496190913*^9}, {
   3.575772614086656*^9, 3.5757726286944914`*^9}, 3.5757726590812297`*^9, {
   3.5759741411197433`*^9, 3.5759741561581697`*^9}, {3.5759742021002502`*^9, 
   3.5759742157346745`*^9}, 3.5768732485823507`*^9, {3.5768733225420804`*^9, 
   3.576873346644123*^9}, {3.5768734557819147`*^9, 3.576873461850325*^9}, {
   3.5768734924263787`*^9, 3.57687352147363*^9}, {3.5770554598819695`*^9, 
   3.577055463204776*^9}, 3.5778715362491693`*^9, {3.5778716912240334`*^9, 
   3.577871702816696*^9}, 3.5778717565767713`*^9, {3.5778718371413794`*^9, 
   3.577871932399828*^9}, 3.5779963889137025`*^9, {3.5779971639186645`*^9, 
   3.577997164261865*^9}, 3.577997327712983*^9, {3.5779973707690587`*^9, 
   3.577997383857482*^9}, 3.577997501216488*^9, {3.592182738845936*^9, 
   3.592182738861536*^9}, 3.592182944360697*^9, 3.5921830186012273`*^9, 
   3.592189432880093*^9, 3.592189463674547*^9, {3.592189504297019*^9, 
   3.592189506559023*^9}, 3.592189562375921*^9, {3.592189594262377*^9, 
   3.5921896106424055`*^9}, 3.5921897904795218`*^9, 3.592189846156019*^9, 
   3.592355462843272*^9, 3.59938841163758*^9, {3.599388677087646*^9, 
   3.599388684560059*^9}, 3.5993887418121595`*^9, 3.5993887919038477`*^9, 
   3.599389809202035*^9, 3.5994506393849616`*^9, 3.606352380183405*^9, {
   3.6063536387788167`*^9, 3.606353654363244*^9}, {3.606353693441313*^9, 
   3.6063537178865557`*^9}, 3.606354117960466*^9, {3.6063541792997737`*^9, 
   3.606354199065008*^9}, 3.606354347452469*^9, {3.606355491121396*^9, 
   3.606355500497013*^9}, {3.6063556639697*^9, 3.606355691815749*^9}, {
   3.606355951598206*^9, 3.606355974249446*^9}, 3.6063566362550087`*^9, 
   3.6063623067270436`*^9, 3.6063641073134065`*^9, 3.6063646163423004`*^9, {
   3.606424064606145*^9, 3.606424095525399*^9}, 3.606435037067684*^9, 
   3.6253066976903305`*^9, 3.6253067308559885`*^9, {3.625307148703523*^9, 
   3.6253071524163303`*^9}, 3.6253071875163918`*^9, 3.6253072177180443`*^9, {
   3.625307746315781*^9, 3.625307759903405*^9}, {3.625307823676317*^9, 
   3.625307828637126*^9}, 3.62530786493839*^9, 3.625308047693511*^9, {
   3.6253081020908065`*^9, 3.6253081157564306`*^9}, {3.6253833845823274`*^9, 
   3.6253833858459296`*^9}, 3.6253834204935904`*^9, 3.6291871979741755`*^9, 
   3.6291872594694834`*^9, {3.6291872945851455`*^9, 3.6291873218851933`*^9}, 
   3.6291877401579294`*^9, 3.6291877836352053`*^9, 3.6291878504345226`*^9, 
   3.629188085136935*^9, {3.6291893908088293`*^9, 3.62918939137043*^9}, 
   3.629412984390986*^9, {3.6296819408526163`*^9, 3.629681967825063*^9}, 
   3.6296830686522045`*^9, {3.6296838311971436`*^9, 3.629683868200409*^9}, 
   3.629684076866375*^9, 3.6296853116949444`*^9, 3.6301301057327366`*^9, 
   3.630186815320861*^9, 3.630191351912052*^9, {3.630191442251811*^9, 
   3.630191443047412*^9}, {3.6301915674264307`*^9, 3.630191567582431*^9}, 
   3.630191627034135*^9, 3.6301916686862087`*^9, {3.630191698872261*^9, 
   3.630191748199548*^9}, 3.6301925032876744`*^9, 3.6302240261576805`*^9, 
   3.6325489666245556`*^9, 3.6325493494752283`*^9, 3.632549601344486*^9, 
   3.6325497935128317`*^9, {3.6325499103370447`*^9, 3.632549935952289*^9}, {
   3.6326052493632545`*^9, 3.6326052629040785`*^9}, 3.63278969455567*^9, {
   3.632789742073353*^9, 3.632789791213439*^9}, 3.632789884486003*^9, 
   3.63279000237541*^9, 3.632798142408646*^9, 3.6327982664912643`*^9, 
   3.6328077266600885`*^9, 3.6328077568617415`*^9, {3.6328139368782277`*^9, 
   3.6328140112279577`*^9}, {3.632814042646413*^9, 3.6328140428492136`*^9}, {
   3.6328142255199356`*^9, 3.6328142422743645`*^9}, {3.6328628377011323`*^9, 
   3.6328628382471333`*^9}, 3.632863071561143*^9, 3.6328903827053213`*^9, {
   3.63450396414303*^9, 3.634503989945475*^9}, 3.634505031134311*^9, {
   3.6345050814287996`*^9, 3.6345050826300015`*^9}, {3.634505119567073*^9, 
   3.6345051390203075`*^9}, {3.63450518026678*^9, 3.6345051946500053`*^9}, {
   3.634505252089306*^9, 3.634505279467354*^9}, {3.6345559523854685`*^9, 
   3.634555955614674*^9}, 3.634556221122741*^9, {3.6360748556676345`*^9, 
   3.636074857804838*^9}, 3.6360754056294017`*^9, 3.6360755416304407`*^9, {
   3.636075572097294*^9, 3.6360755749364986`*^9}, 3.6360756677410617`*^9, 
   3.6360760229536858`*^9, {3.6360760624173627`*^9, 3.6360760925254154`*^9}, 
   3.6360761236318703`*^9, {3.636495351875679*^9, 3.636495380361329*^9}, 
   3.636495512727562*^9, 3.6364955557680373`*^9, 3.636495774451644*^9, {
   3.636495808288103*^9, 3.6364958628569994`*^9}, 3.636495995379232*^9, 
   3.6364961521595078`*^9, 3.6364963213886046`*^9, 3.636496426595189*^9, 
   3.636496986184173*^9, {3.6367624760855265`*^9, 3.636762479361532*^9}, 
   3.7255924293790016`*^9, 3.7255925317463818`*^9, 3.7255944743117948`*^9, {
   3.725594518943473*^9, 3.7255945214862776`*^9}, 3.7255953603777514`*^9, 
   3.7255957972769194`*^9, {3.7255958312537794`*^9, 3.7255958481174088`*^9}, {
   3.725596058390178*^9, 3.7255960649109898`*^9}, 3.7255963371938677`*^9, 
   3.72559640661399*^9, {3.725601386418369*^9, 3.7256014341076527`*^9}, 
   3.7257712704994154`*^9, 3.725774257093461*^9, 3.72577429072712*^9, {
   3.725774416443348*^9, 3.7257744278937683`*^9}, 3.725779901988584*^9, 
   3.72578045202995*^9, 3.7258490308793774`*^9, 3.7258521063247805`*^9, 
   3.725852262605855*^9, 3.725852360558427*^9, 3.7258524069529085`*^9, 
   3.725852753257917*^9, 3.725853436567118*^9, {3.7258534847400026`*^9, 
   3.7258535107140484`*^9}, {3.725853667353924*^9, 3.7258536787419434`*^9}, 
   3.726913461475872*^9, {3.726913506715952*^9, 3.7269135067315516`*^9}, 
   3.726913573655669*^9, 3.7269142285136194`*^9, {3.7269143657158604`*^9, 
   3.7269143772130804`*^9}, 3.726914441095193*^9, 3.7269145189861298`*^9, 
   3.726914651929563*^9, 3.7269147274648952`*^9, 3.726915143191228*^9, {
   3.7269151750932837`*^9, 3.7269151752336836`*^9}, {3.7269155027638597`*^9, 
   3.726915507599868*^9}, {3.726942965317898*^9, 3.7269429659418993`*^9}, 
   3.7269527321998544`*^9, {3.732581567667375*^9, 3.732581616495461*^9}, {
   3.732658450427137*^9, 3.732658468772769*^9}, {3.732658950832816*^9, 
   3.7326589718928533`*^9}, 3.7326593484319158`*^9, 3.7326684474112062`*^9, {
   3.740218164622918*^9, 3.740218189130562*^9}, 3.7402182402830515`*^9, {
   3.7402183944893227`*^9, 3.7402184164385605`*^9}, 3.740218476010673*^9, 
   3.740218965392333*^9, 3.7402207306098347`*^9, 3.740623523847764*^9, {
   3.7407786224156923`*^9, 3.7407786244124956`*^9}, {3.740778719260662*^9, 
   3.7407787320526843`*^9}, {3.7407792555464067`*^9, 3.7407793011608863`*^9}, 
   3.7407793394121532`*^9, {3.740779664601926*^9, 3.7407796776747484`*^9}, 
   3.7407805414526663`*^9, 3.740780576287527*^9, 3.7407807802890854`*^9, 
   3.74078247376919*^9, {3.7407839511537724`*^9, 3.7407839979846582`*^9}, 
   3.7407842696709504`*^9, {3.740784331289063*^9, 3.7407843341800685`*^9}, {
   3.740784465266109*^9, 3.7407844673429127`*^9}, 3.740784531285632*^9, 
   3.74078474467282*^9, {3.740785226216671*^9, 3.740785234380486*^9}, {
   3.74079231722311*^9, 3.740792318034312*^9}, 3.740795728899905*^9, 
   3.740795848146515*^9, 3.740796253029626*^9, 3.7407962960389013`*^9, 
   3.7407968627566967`*^9, 3.7407969034103684`*^9, {3.7411140723503017`*^9, 
   3.7411140740039043`*^9}, 3.7411141862149014`*^9, {3.7411142414077983`*^9, 
   3.7411142788634644`*^9}, {3.741114361278409*^9, 3.741114362464011*^9}, 
   3.741114397938473*^9, 3.7411144525385695`*^9, 3.741165060176092*^9, 
   3.741166736872638*^9, 3.7411668048419576`*^9, 3.741167005957511*^9, 
   3.741892706493498*^9, 3.7446637127156367`*^9, 3.744664185162467*^9, 
   3.7446656128001237`*^9, 3.7446656519561925`*^9, 3.7447503942786407`*^9, 
   3.7448755599807453`*^9, 3.7452127385678663`*^9, 3.7452130555136228`*^9, 
   3.7452134456391077`*^9, {3.7452134806767693`*^9, 3.7452134813007703`*^9}, 
   3.745213585493354*^9, 3.745213767873274*^9, {3.7452137983869276`*^9, 
   3.7452138193377643`*^9}, {3.745213904810314*^9, 3.7452139139363303`*^9}, {
   3.745213949395193*^9, 3.7452139495823927`*^9}, {3.745213986975659*^9, 
   3.74521402177932*^9}, {3.7452153772273006`*^9, 3.7452153940753307`*^9}, {
   3.7452158730613728`*^9, 3.745215903824627*^9}, {3.7452159530895133`*^9, 
   3.7452159792039595`*^9}, 3.745216259770452*^9, 3.7460520035615406`*^9, {
   3.746054453943448*^9, 3.7460544574378543`*^9}, 3.746054497295924*^9, 
   3.746054597682101*^9, {3.7460547541659756`*^9, 3.7460547746800117`*^9}, 
   3.7460548541777515`*^9, 3.746054960086337*^9, 3.746991665534811*^9, 
   3.746995590370906*^9, 3.7469956213057604`*^9, {3.746995729995552*^9, 
   3.746995731243554*^9}, {3.7469957645028124`*^9, 3.746995765407614*^9}, {
   3.746995818198107*^9, 3.7469958661213913`*^9}, {3.7469959375383167`*^9, 
   3.746995941453923*^9}, {3.747000815490528*^9, 3.7470008173313313`*^9}, {
   3.7470008849886503`*^9, 3.7470008863926525`*^9}, {3.7470275513438883`*^9, 
   3.7470275518742895`*^9}, {3.7470280525595703`*^9, 3.7470280552115746`*^9}, 
   3.7481111897753506`*^9, 3.7481112427842436`*^9, 3.748111476535054*^9, 
   3.7481115164555244`*^9, 3.7481117566959467`*^9, 3.7481117914684076`*^9, 
   3.7481118423556967`*^9, 3.7481119434438744`*^9, 3.7481119960783668`*^9, 
   3.7481126379102945`*^9, 3.7481127727725315`*^9, 3.748112894015944*^9, 
   3.7481129700816774`*^9, {3.748113028800181*^9, 3.748113030016983*^9}, 
   3.7481131110123253`*^9, 3.748114875740626*^9, 3.748152382102949*^9, 
   3.748156767894652*^9, 3.749668431509885*^9, 3.7507169249859457`*^9, {
   3.7507174668996973`*^9, 3.750717469458102*^9}, 3.750718004418642*^9, 
   3.750718074774766*^9, 3.7507181111072297`*^9, {3.7507182219610243`*^9, 
   3.7507182332866445`*^9}, 3.7507183577748632`*^9, {3.750719884635145*^9, 
   3.750719897083967*^9}, 3.750720673464531*^9, 3.7507242419383993`*^9, 
   3.7507256027451925`*^9, 3.750744003618518*^9, {3.750744093771076*^9, 
   3.7507440965790815`*^9}, 3.7511831548293476`*^9, 3.7511832008026285`*^9, {
   3.751189424649564*^9, 3.7511894256479654`*^9}, 3.7511895614618044`*^9, {
   3.7511910305075865`*^9, 3.7511910391500015`*^9}, {3.751192237613307*^9, 
   3.751192254305336*^9}, 3.751230212036337*^9, {3.751274116442066*^9, 
   3.7512741166136665`*^9}, 3.751343682541116*^9, {3.751343733085205*^9, 
   3.7513437501204348`*^9}, 3.751344238166094*^9, 3.75134430452861*^9, {
   3.751345479669874*^9, 3.7513454796854744`*^9}, 3.751345820748873*^9, {
   3.7513459524443045`*^9, 3.7513459532399063`*^9}, 3.751346262260849*^9, {
   3.751348105092086*^9, 3.7513481245765195`*^9}, {3.7513566618091145`*^9, 
   3.751356668220726*^9}, {3.751358491060729*^9, 3.7513584912323294`*^9}, {
   3.75135877156363*^9, 3.75135877173523*^9}, 3.751359211999203*^9, 
   3.755049981976758*^9, 3.7550500821133337`*^9, 3.7550501621414747`*^9, {
   3.755050416297121*^9, 3.7550504199943275`*^9}, 3.7550509388668385`*^9, 
   3.7550519367687855`*^9, {3.755051997187691*^9, 3.755052060695403*^9}, 
   3.7550521337191315`*^9, 3.7550521647007856`*^9, 3.7550613876302633`*^9, 
   3.7551379564936295`*^9, {3.755138024930949*^9, 3.7551380411237783`*^9}, 
   3.755138082682251*^9, {3.7551381845348296`*^9, 3.7551382172792873`*^9}, 
   3.7551383234530735`*^9, {3.755138441217681*^9, 3.7551385276106324`*^9}, {
   3.755138882422056*^9, 3.755138897273282*^9}, {3.7551414688371882`*^9, 
   3.7551414693363895`*^9}, 3.755142317557621*^9, 3.755143433067379*^9, {
   3.7551476031529503`*^9, 3.7551476133397684`*^9}, 3.7551478086989117`*^9, 
   3.7552236306785617`*^9, 3.7552237351007524`*^9, {3.7552275045464*^9, 
   3.7552275077132063`*^9}, 3.7642903539579687`*^9, 3.76429053655789*^9, {
   3.7642905687251463`*^9, 3.7642906105332203`*^9}, 3.764290668502922*^9, {
   3.7642907246006203`*^9, 3.764290784832326*^9}, {3.7642908265935993`*^9, 
   3.7642908360628157`*^9}, 3.7642909449510074`*^9, {3.764290981189871*^9, 
   3.764290981876272*^9}, 3.7642912047834673`*^9, {3.764291319491269*^9, 
   3.764291321378873*^9}, 3.764291611398982*^9, 3.7643023539758563`*^9, 
   3.7643023976559334`*^9, 3.764304230323553*^9, 3.7643178534248857`*^9, 
   3.7643204595866685`*^9, 3.764370162398338*^9, 3.764372959000451*^9, {
   3.7643746106161537`*^9, 3.7643746108813543`*^9}, 3.764384946199549*^9, 
   3.764385323602227*^9, 3.7646681264950523`*^9, 3.764668209284398*^9, {
   3.7646682425904565`*^9, 3.7646682533076754`*^9}, 3.764668288563737*^9, 
   3.764668544731787*^9, 3.764887973290904*^9, 3.7648880093425674`*^9, 
   3.7648889030021396`*^9, {3.7648903950293617`*^9, 3.7648904044205785`*^9}, {
   3.764890442796646*^9, 3.7648904429526463`*^9}, 3.7648906360965853`*^9, 
   3.7648967215975685`*^9, 3.765060789137452*^9, 3.7651708746726866`*^9, 
   3.7651709275255795`*^9, {3.765171589180749*^9, 3.765171597479964*^9}, {
   3.765172134970908*^9, 3.765172146390128*^9}, 3.7652588607251368`*^9, 
   3.765258911924426*^9, 3.7652678488217335`*^9, 3.766219677032467*^9, 
   3.766219733644967*^9, 3.766220209789003*^9, 3.766224738350159*^9, {
   3.766371673365609*^9, 3.7663716735372095`*^9}, {3.7664771999078894`*^9, 
   3.766477221467128*^9}, {3.7664774867923937`*^9, 3.7664775002552176`*^9}, {
   3.768845899023299*^9, 3.768845913219324*^9}, {3.768846446688262*^9, 
   3.7688464478114643`*^9}, {3.7688469105734777`*^9, 3.768846911556279*^9}, {
   3.7756127125728536`*^9, 3.775612713805256*^9}, 3.791925257473979*^9, 
   3.7919253465779333`*^9, 3.791925415545993*^9, 3.791925538329486*^9, 
   3.791925601252158*^9, {3.7919258208123755`*^9, 3.791925846181349*^9}, {
   3.7919258965132446`*^9, 3.791925926459304*^9}, {3.791926014071001*^9, 
   3.7919260175701747`*^9}, 3.7919266484290524`*^9, {3.7919272055886946`*^9, 
   3.791927235331627*^9}, {3.7919276582332497`*^9, 3.7919277101428995`*^9}, {
   3.7919283378467164`*^9, 3.7919283439703007`*^9}, 3.791928389264398*^9, 
   3.7919411413389997`*^9, 3.791941230396061*^9, 3.7919430979993715`*^9, 
   3.7919455907781906`*^9, 3.7919456413443985`*^9, 3.791945710086*^9, {
   3.791946022624746*^9, 3.791946071628796*^9}, 3.7919462750182886`*^9, {
   3.7919463468763237`*^9, 3.791946348454059*^9}, {3.7919485149966345`*^9, 
   3.7919485152934113`*^9}, 3.7921427775327096`*^9, 3.7921428844917583`*^9, {
   3.792143012102148*^9, 3.7921430326754313`*^9}, {3.7921430729159*^9, 
   3.7921430957230043`*^9}, {3.792143137525601*^9, 3.7921431788751917`*^9}, 
   3.792143236720871*^9, {3.7921435062050405`*^9, 3.7921435066268454`*^9}, {
   3.792144999623945*^9, 3.792145021384448*^9}, {3.7921451021622267`*^9, 
   3.7921451511037264`*^9}, 3.792145185720539*^9, {3.7921455447136655`*^9, 
   3.792145545432212*^9}, {3.792184507470749*^9, 3.7921845096108675`*^9}, 
   3.792184641720213*^9, {3.792206627246333*^9, 3.792206627246333*^9}, 
   3.792206751388796*^9, {3.792206853864559*^9, 3.7922068746252704`*^9}, 
   3.7922073162553945`*^9, 3.7922074838563423`*^9, {3.792207902303128*^9, 
   3.7922079240167284`*^9}, 3.792210628560286*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709171055946`*^9, 3.7922709214014473`*^9}, 
   3.7922710012262707`*^9, 3.7922710487775407`*^9, {3.7922714048807282`*^9, 
   3.792271416690432*^9}, {3.7922722543810005`*^9, 3.7922722888259625`*^9}, 
   3.7922726333057737`*^9, 3.792538656581356*^9, 3.79253893338968*^9, {
   3.79253897772618*^9, 3.792538997607256*^9}, {3.7925390932423153`*^9, 
   3.7925390962103596`*^9}, 3.792539159820304*^9, 3.792539240269972*^9, {
   3.7925532546452465`*^9, 3.7925533205046535`*^9}, {3.792553601937978*^9, 
   3.7925536273538704`*^9}, 3.79255397433422*^9, 3.7934110830440025`*^9, 
   3.8025467812543383`*^9, 3.8025468240567527`*^9, 3.8025528269104867`*^9, 
   3.802553052279233*^9, 3.802553090613947*^9, {3.802553138758854*^9, 
   3.802553139914831*^9}, {3.8025532126007967`*^9, 3.802553250295064*^9}, {
   3.802553594834815*^9, 3.8025536101749134`*^9}, {3.8025798116085243`*^9, 
   3.8025798132175207`*^9}, 3.802579945624563*^9, 3.802582701183984*^9, 
   3.807854563419881*^9, 3.807854694546463*^9, {3.8078547295149803`*^9, 
   3.8078547561408234`*^9}, {3.8078547919860497`*^9, 3.8078548304791474`*^9}, 
   3.8078548606684666`*^9, 3.807855083466024*^9, 3.816906053582398*^9, 
   3.8169062224342117`*^9, {3.8169062988381157`*^9, 3.8169063060864477`*^9}, 
   3.8169064065628595`*^9, 3.816906461050069*^9, {3.8169064993379393`*^9, 
   3.8169065035244703`*^9}, 3.8169065362667856`*^9, 3.8169065845523252`*^9, 
   3.816906745967521*^9, 3.816906908810424*^9, 3.816911860153344*^9, {
   3.8208065344321394`*^9, 3.8208065372752233`*^9}, {3.8208066098049192`*^9, 
   3.820806629253437*^9}, {3.8208067246527057`*^9, 3.820806757035666*^9}, 
   3.820806846764411*^9, 3.820806898986417*^9, {3.8208069817158995`*^9, 
   3.8208069962436466`*^9}, 3.8208070567761927`*^9, 3.8208071646412573`*^9, {
   3.827874604510014*^9, 3.8278746309881845`*^9}, 3.8282861305022345`*^9, {
   3.8282861822244864`*^9, 3.8282862225431395`*^9}, 3.8282862526298304`*^9, 
   3.8282862842161703`*^9, 3.828286431179902*^9, 3.8282865552758007`*^9, 
   3.8288490182376804`*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571656713667`*^9, 3.8482572003506775`*^9}, 3.848257241247275*^9, 
   3.848259231776729*^9, 3.848259267571465*^9, 3.848259344803232*^9, 
   3.848259673414655*^9, {3.848259861051252*^9, 3.848259867143531*^9}, {
   3.848259941470792*^9, 3.8482599439389577`*^9}, 3.8482600898263903`*^9, 
   3.848260640619811*^9, 3.8482608256478395`*^9, {3.8482609065250673`*^9, 
   3.848260907681044*^9}, {3.8547617639785867`*^9, 3.8547617639785867`*^9}, 
   3.854761809702217*^9, {3.854761942224519*^9, 3.8547619519097843`*^9}, {
   3.8547622351085224`*^9, 3.854762249654128*^9}, 3.854762371152464*^9, 
   3.8547635232989454`*^9, 3.8831684232624483`*^9, 3.8831685493113613`*^9, 
   3.883168591832553*^9, {3.883169010827317*^9, 3.883169014857577*^9}, 
   3.883169424066017*^9, {3.8831694760850053`*^9, 3.8831694856764994`*^9}, 
   3.883170656625969*^9, 3.8831708592182693`*^9, {3.9565290756336536`*^9, 
   3.9565290756336536`*^9}, 3.956529278342761*^9, 3.9565293333611*^9, {
   3.956529367509301*^9, 3.9565293704148693`*^9}, 3.9565294729845495`*^9, 
   3.9565295110113583`*^9, {3.956529552879578*^9, 3.956529563252109*^9}, 
   3.9565298355156817`*^9, 3.9565299092171383`*^9, {3.95653017492978*^9, 
   3.9565301806784286`*^9}, 3.956530444152749*^9, 3.9565466403671255`*^9, {
   3.956546673874888*^9, 3.9565466746247115`*^9}, {3.956546996970974*^9, 
   3.9565470893711643`*^9}, {3.9565471392500925`*^9, 3.956547154496507*^9}, 
   3.956547195080699*^9, {3.956548241173988*^9, 3.956548252889991*^9}, {
   3.956555964009493*^9, 3.956555967555545*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0210.png\>\"", ",", "ip3dConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5339551753718605`*^9, 3.5339551977422996`*^9}, 
   3.5470088994684477`*^9, 3.5470089727417765`*^9, {3.5501987561524305`*^9, 
   3.55019875626163*^9}, 3.5501988411413794`*^9, {3.550469316159321*^9, 
   3.550469316393321*^9}, {3.5531142826767282`*^9, 3.5531142878403373`*^9}, 
   3.553114589410067*^9, 3.5531850735502143`*^9, 3.5531852580361385`*^9, 
   3.553190088148943*^9, 3.5531901617342725`*^9, 3.553190880875136*^9, {
   3.553190965255684*^9, 3.5531909657236853`*^9}, {3.553213796837209*^9, 
   3.5532138090832305`*^9}, {3.553214132081798*^9, 3.5532141604270477`*^9}, {
   3.55638959965485*^9, 3.5563895998420506`*^9}, 3.5563898856657524`*^9, {
   3.732581228351179*^9, 3.73258122874118*^9}, 3.7326535161424675`*^9, {
   3.732659131075533*^9, 3.7326591312627335`*^9}, 3.7326593484475155`*^9, 
   3.7402167509844255`*^9, 3.740218243403057*^9, 3.74021899790279*^9, 
   3.740778626643299*^9, {3.740780616519998*^9, 3.7407806166603985`*^9}, 
   3.7407823179717164`*^9, {3.740795712629077*^9, 3.7407957267315016`*^9}, 
   3.7411140764375086`*^9, {3.741114125515195*^9, 3.741114125671195*^9}, 
   3.741166734985035*^9, {3.741166859442054*^9, 3.7411668600660543`*^9}, {
   3.741421137522071*^9, 3.741421137662471*^9}, 3.7446637165064435`*^9, 
   3.7446643950296354`*^9, 3.7446656128001237`*^9, {3.7446659247070713`*^9, 
   3.7446659248786716`*^9}, 3.7452127427798734`*^9, {3.7452127929651613`*^9, 
   3.745212793152362*^9}, 3.7452152142298145`*^9, 3.7452153921565275`*^9, 
   3.7460520052775435`*^9, {3.746052046134015*^9, 3.746052046851617*^9}, 
   3.74605511521301*^9, 3.7469914820784883`*^9, {3.746991523184561*^9, 
   3.74699155112421*^9}, 3.746991670152419*^9, 3.748111192864156*^9, {
   3.748111336868009*^9, 3.7481113370708094`*^9}, 3.748112636022691*^9, 
   3.748113214284507*^9, {3.7507168278133755`*^9, 3.7507168307305803`*^9}, 
   3.7507169297439537`*^9, 3.7509079022215652`*^9, {3.750907940301232*^9, 
   3.7509079404728317`*^9}, 3.7509082696334105`*^9, 3.751350024917858*^9, 
   3.7513500920291758`*^9, {3.7513503405844126`*^9, 3.751350340787213*^9}, 
   3.7514002188533993`*^9, {3.7550496972606583`*^9, 3.7550496974946585`*^9}, {
   3.75504978959722*^9, 3.7550497905488214`*^9}, 3.755049981976758*^9, 
   3.762283559846346*^9, {3.762283605102025*^9, 3.762283605258025*^9}, 
   3.7622837044741993`*^9, 3.764280957785819*^9, 3.7642809971446877`*^9, {
   3.7642810687488136`*^9, 3.764281091244053*^9}, {3.764281218056676*^9, 
   3.764281218197076*^9}, 3.764281300721221*^9, 3.76429146773833*^9, 
   3.7642915623056955`*^9, 3.7646644254533424`*^9, {3.764664539785943*^9, 
   3.7646645399731436`*^9}, {3.7648873980398936`*^9, 3.7648873981958942`*^9}, 
   3.764887973290904*^9, {3.764889416149441*^9, 3.7648894163366413`*^9}, {
   3.7650602413440895`*^9, 3.76506024151569*^9}, 3.765060791461856*^9, 
   3.765087677377597*^9, {3.765170815548583*^9, 3.7651708157513833`*^9}, 
   3.7651708746726866`*^9, 3.765258911924426*^9, {3.765259059017085*^9, 
   3.765259059188685*^9}, 3.766219554353852*^9, {3.766219588096711*^9, 
   3.766219588315111*^9}, 3.766219677048067*^9, 3.7662202121290073`*^9, 
   3.7664771999078894`*^9, 3.766477339294134*^9, 3.7664774867923937`*^9, 
   3.766477573575346*^9, {3.76661193684249*^9, 3.7666119369516907`*^9}, {
   3.767393932285303*^9, 3.7673939324413033`*^9}, 3.7688458990388994`*^9, 
   3.768845992139863*^9, 3.7688461103100705`*^9, 3.7919252574896*^9, 
   3.791926049453236*^9, {3.7919260861008263`*^9, 3.791926086913168*^9}, 
   3.791941139339487*^9, 3.7919412617480307`*^9, {3.791945592480884*^9, 
   3.7919456060870748`*^9}, 3.7921427775483007`*^9, {3.7921442451353717`*^9, 
   3.792144245338449*^9}, 3.792145001857826*^9, {3.792145054236045*^9, 
   3.7921450544235*^9}, 3.792206627246333*^9, {3.792208155180749*^9, 
   3.7922081559774384`*^9}, 3.7922705977593207`*^9, {3.7922707237138777`*^9, 
   3.792270723791984*^9}, 3.79253865659698*^9, 3.792554032117412*^9, 
   3.8025468267904854`*^9, {3.802546894868189*^9, 3.802546913582498*^9}, 
   3.8025516394640093`*^9, {3.8025798091715994`*^9, 3.802579817638352*^9}, 
   3.8078544431792603`*^9, {3.8078544925433044`*^9, 3.8078544933671336`*^9}, 
   3.807854566519637*^9, 3.816906057737702*^9, 3.816906822971233*^9, 
   3.8169068639616127`*^9, 3.8208064318782806`*^9, {3.8208064621211166`*^9, 
   3.820806462214844*^9}, 3.820806541039958*^9, {3.8278746045256357`*^9, 
   3.8278746309881845`*^9}, 3.827874859287332*^9, {3.827874908775693*^9, 
   3.827874908963181*^9}, 3.828286648410184*^9, 3.8482570386700907`*^9, 
   3.8482570746303196`*^9, 3.848257124337367*^9, 3.854761763994209*^9, {
   3.8547618395248256`*^9, 3.854761864503364*^9}, {3.883168591832553*^9, 
   3.8831686183106723`*^9}, {3.883168654880164*^9, 3.8831686550051346`*^9}, 
   3.956529075649271*^9, {3.9565292024855556`*^9, 3.95652922354312*^9}, 
   3.956546638367628*^9, {3.95654669893154*^9, 3.9565466991502466`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"frpConfHypergeomF2", "=", "\[IndentingNewLine]", 
  RowBox[{"FundamentalRegionPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "20000"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"400", ",", "600"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "8"}], ",", "30"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.530344234110747*^9, 3.530344269600809*^9, {3.53395684314399*^9, 
   3.5339568911608744`*^9}, {3.533956924529333*^9, 3.533956959972595*^9}, {
   3.533957001359468*^9, 3.5339570248843093`*^9}, {3.5346482317806273`*^9, 
   3.5346482369130363`*^9}, {3.5346484132401457`*^9, 3.534648422927763*^9}, {
   3.534648600908476*^9, 3.534648602874079*^9}, 3.534710001277398*^9, {
   3.534710275763481*^9, 3.5347102880095024`*^9}, {3.534710723484267*^9, 
   3.5347107275246744`*^9}, {3.534710781017168*^9, 3.534710781219969*^9}, {
   3.5347108477228856`*^9, 3.5347108501564903`*^9}, {3.536464399328986*^9, 
   3.5364644013413897`*^9}, 3.5470089850033984`*^9, {3.547009186867753*^9, 
   3.547009193606965*^9}, {3.5470101014513597`*^9, 3.5470101345858183`*^9}, 
   3.5470103852662587`*^9, 3.5501988466325893`*^9, 3.550199068246578*^9, {
   3.5502084668036313`*^9, 3.5502084670064316`*^9}, 3.550208582867835*^9, 
   3.550210551794093*^9, 3.5502106958603463`*^9, {3.550798929203307*^9, 
   3.5507989293125067`*^9}, 3.5531145282735596`*^9, 3.55311459660168*^9, 
   3.553115153538258*^9, 3.553115190603923*^9, 3.553115426549945*^9, 
   3.5531841290621552`*^9, 3.553184841780607*^9, 3.553185595402331*^9, {
   3.5642903301826057`*^9, 3.5642903301826057`*^9}, {3.564291282969879*^9, 
   3.56429128880429*^9}, 3.564291394822076*^9, 3.5645701814958963`*^9, 
   3.564570242882004*^9, {3.564570442328354*^9, 3.5645704448087587`*^9}, 
   3.5646312482712297`*^9, 3.564632058343053*^9, {3.5646323584975805`*^9, 
   3.5646323647687917`*^9}, 3.564706563514888*^9, {3.5647069832336254`*^9, 
   3.564706991033639*^9}, {3.564989542386684*^9, 3.56498954572509*^9}, {
   3.5651175773891916`*^9, 3.565117582833601*^9}, {3.567283577864339*^9, 
   3.5672835875051556`*^9}, {3.5672836659264936`*^9, 
   3.5672836766593122`*^9}, {3.567283716548582*^9, 3.567283718576586*^9}, 
   3.567283973247033*^9, 3.56728425586953*^9, {3.5672842997836075`*^9, 
   3.567284320703244*^9}, 3.5672843556005054`*^9, 3.5677493102314744`*^9, 
   3.56780279067764*^9, 3.567802890923416*^9, {3.567802966739549*^9, 
   3.5678029668955493`*^9}, 3.5681976926063223`*^9, 3.5681977453968153`*^9, {
   3.568197813974536*^9, 3.568197826126957*^9}, {3.5681978838782587`*^9, 
   3.568197918401119*^9}, 3.5700755786291265`*^9, {3.5700756190487976`*^9, 
   3.5700756257724094`*^9}, {3.570086895267579*^9, 3.570086895443589*^9}, 
   3.570087027747156*^9, 3.5700870928118777`*^9, 3.5700872352950277`*^9, {
   3.570096246297722*^9, 3.5700962494177275`*^9}, 3.570606665466712*^9, 
   3.573604837639526*^9, 3.5736049030816407`*^9, 3.5736049498193226`*^9, {
   3.5736050854147615`*^9, 3.573605109750804*^9}, 3.5736051427448616`*^9, {
   3.5736052053321714`*^9, 3.573605205519372*^9}, {3.573605408179328*^9, 
   3.573605433950573*^9}, 3.5736058570857162`*^9, 3.5736059335570507`*^9, 
   3.573605964039504*^9, 3.5736059994827666`*^9, 3.5736060984805403`*^9, {
   3.573606625978094*^9, 3.5736066285832987`*^9}, 3.5736158211856375`*^9, 
   3.5736160693318305`*^9, 3.5736161223258615`*^9, {3.573616182105281*^9, 
   3.573616182321293*^9}, 3.573616236132371*^9, 3.5736164232410727`*^9, {
   3.573692298777257*^9, 3.5736923146424847`*^9}, {3.574885935637336*^9, 
   3.5748859559173717`*^9}, {3.574886059891554*^9, 3.574886060063154*^9}, 
   3.5748861763301587`*^9, 3.57488628534315*^9, 3.575772379966265*^9, {
   3.5757724207015953`*^9, 3.5757725117098007`*^9}, {3.575772591741378*^9, 
   3.5757725927734375`*^9}, {3.575772672229982*^9, 3.5757726811024895`*^9}, 
   3.5757893795025835`*^9, {3.5759741275789194`*^9, 3.5759741492005577`*^9}, 
   3.5759742049082556`*^9, 3.576873260313571*^9, {3.5768733266760874`*^9, 
   3.5768733636481524`*^9}, {3.576961566809566*^9, 3.576961566965566*^9}, 
   3.5778715430075555`*^9, {3.577871696168316*^9, 3.5778716991834884`*^9}, {
   3.577871760471994*^9, 3.5778717880315704`*^9}, 3.5778726548461494`*^9, 
   3.577996394467312*^9, {3.577996527223545*^9, 3.5779965332763557`*^9}, 
   3.5780020367826004`*^9, {3.592182738877136*^9, 3.592182738877136*^9}, 
   3.592182948245104*^9, 3.592183023967637*^9, {3.5921894148308616`*^9, 
   3.5921894250800796`*^9}, 3.592189468058155*^9, 3.59218951063063*^9, {
   3.5921897614790707`*^9, 3.5921897687174835`*^9}, {3.5921898718180647`*^9, 
   3.5921898746416693`*^9}, 3.592190089781647*^9, 3.599383290830182*^9, 
   3.606352387733818*^9, {3.6063536447692275`*^9, 3.6063536521324406`*^9}, {
   3.6063536981837215`*^9, 3.606353720959761*^9}, {3.6063540035186653`*^9, 
   3.60635401782389*^9}, {3.606354435187023*^9, 3.606354443579838*^9}, {
   3.606355512883435*^9, 3.6063555243806553`*^9}, {3.606355667978907*^9, 
   3.606355694748554*^9}, {3.6063559545934114`*^9, 3.60635597637105*^9}, 
   3.6063566455526247`*^9, 3.606364112430215*^9, {3.606364199790369*^9, 
   3.606364203237975*^9}, 3.6063646197275066`*^9, 3.606367676083275*^9, {
   3.625306705256344*^9, 3.6253067345531955`*^9}, {3.6253071577203393`*^9, 
   3.625307191275998*^9}, {3.6253072256584587`*^9, 3.625307230572467*^9}, 
   3.625307268620934*^9, {3.625307476549307*^9, 3.6253074769705076`*^9}, {
   3.6253081892637596`*^9, 3.6253082416486516`*^9}, 3.6253530322619123`*^9, 
   3.6253833808227205`*^9, 3.6253834171083846`*^9, 3.6291872118269997`*^9, {
   3.629187263494291*^9, 3.629187284616728*^9}, 3.6291873266120014`*^9, 
   3.629187811262854*^9, 3.629187845489314*^9, 3.6291893763632035`*^9, {
   3.6292328386751413`*^9, 3.6292328506403627`*^9}, 3.6294129869649906`*^9, {
   3.629681940868216*^9, 3.629681967840663*^9}, {3.629683072302611*^9, 
   3.629683104204667*^9}, 3.6296834256744313`*^9, 3.62968375522501*^9, 
   3.6296908987102036`*^9, 3.630130105748337*^9, 3.6301868181132655`*^9, {
   3.630191355032058*^9, 3.6301913594624653`*^9}, 3.6301916306065416`*^9, {
   3.6301917699615865`*^9, 3.63019186320295*^9}, {3.630192661908753*^9, 
   3.6301926650911584`*^9}, {3.6301964589726305`*^9, 3.6301964616870356`*^9}, 
   3.630397911894512*^9, 3.631494715345451*^9, {3.631494897830179*^9, 
   3.6314948980173793`*^9}, 3.6325489741749687`*^9, 3.632549352439234*^9, 
   3.632549606008894*^9, {3.6325498031224484`*^9, 3.6325498272824984`*^9}, 
   3.6325498689969716`*^9, 3.632603972588211*^9, {3.6326052512664576`*^9, 
   3.63260525814607*^9}, 3.6326054984956923`*^9, 3.632789700000079*^9, 
   3.632789744647358*^9, {3.632789801166257*^9, 3.632789811633875*^9}, 
   3.6327900076794195`*^9, {3.6327981115517917`*^9, 3.632798133781831*^9}, 
   3.632798223201188*^9, {3.6328077370497065`*^9, 3.632807759903747*^9}, 
   3.6328139472210455`*^9, 3.632814030665592*^9, {3.6328142522895823`*^9, 
   3.6328142524611826`*^9}, {3.632862843129942*^9, 3.632862843800743*^9}, 
   3.63286308115516*^9, 3.6328903786025143`*^9, {3.634503967294235*^9, 
   3.6345039716310434`*^9}, {3.634505033567916*^9, 3.6345050472023396`*^9}, {
   3.6345052904809732`*^9, 3.6345052910893745`*^9}, {3.634505400581773*^9, 
   3.634505441906245*^9}, {3.634505494244337*^9, 3.6345055070207596`*^9}, {
   3.6345055797168875`*^9, 3.6345055799040875`*^9}, 3.6345562254439487`*^9, {
   3.6345563039276867`*^9, 3.6345563048948884`*^9}, 3.634556840334629*^9, {
   3.636074869723259*^9, 3.6360748731240654`*^9}, 3.6360754084218063`*^9, {
   3.6360755439392443`*^9, 3.636075558915271*^9}, {3.636075874067024*^9, 
   3.6360758917886553`*^9}, {3.6364953559316864`*^9, 3.636495366508505*^9}, {
   3.6364954773934994`*^9, 3.636495502852744*^9}, {3.636495534396*^9, 
   3.6364955371572046`*^9}, {3.6364955872176924`*^9, 3.63649567827066*^9}, 
   3.636495724504749*^9, {3.636495894244254*^9, 3.6364959362083282`*^9}, {
   3.6364963754739*^9, 3.636496380231908*^9}, {3.636497028007847*^9, 
   3.6364970357610607`*^9}, {3.6367624922783546`*^9, 
   3.6367624954763603`*^9}, {3.6367923982578783`*^9, 3.636792403624288*^9}, 
   3.725592414137775*^9, 3.72559253645759*^9, {3.725595004057525*^9, 
   3.725595014041543*^9}, 3.7255952212879066`*^9, 3.7255953656817603`*^9, 
   3.7255956160982013`*^9, {3.725595650901862*^9, 3.7255956517442636`*^9}, {
   3.725595707529962*^9, 3.7255957181379805`*^9}, {3.7255957501492367`*^9, 
   3.7255957539400434`*^9}, {3.7255961085130663`*^9, 3.72559611623508*^9}, 
   3.725596322436242*^9, 3.7255964148976045`*^9, {3.7257712777690277`*^9, 
   3.7257712801558323`*^9}, 3.725773155528726*^9, 3.725774260463067*^9, {
   3.7257742995099354`*^9, 3.7257743102739544`*^9}, 3.725774372830064*^9, 
   3.7257745020094986`*^9, 3.7258490354189854`*^9, 3.72585211170679*^9, 
   3.7258523136023445`*^9, 3.725852357064021*^9, 3.725852412709319*^9, 
   3.725852690077806*^9, {3.7258529112549944`*^9, 3.725852914297*^9}, 
   3.725866558776852*^9, 3.726913461475872*^9, {3.7269135067471514`*^9, 
   3.7269135067471514`*^9}, 3.7269135736712694`*^9, 3.7269142332092276`*^9, 
   3.726914379943085*^9, {3.72691444512*^9, 3.72691444551*^9}, 
   3.726914522230935*^9, {3.7269150197170105`*^9, 3.726915029623028*^9}, 
   3.7269154806118207`*^9, 3.7269429541638784`*^9, 3.726943055174056*^9, 
   3.7269527416378713`*^9, {3.7325816271502795`*^9, 3.73258171281003*^9}, {
   3.732658455138345*^9, 3.7326584615967565`*^9}, 3.7326589054523363`*^9, 
   3.7326593484475155`*^9, 3.732665438975348*^9, {3.7402181674777236`*^9, 
   3.740218192921368*^9}, 3.7402182516554713`*^9, 3.7402183778596935`*^9, {
   3.7402184897074966`*^9, 3.7402184899102974`*^9}, 3.740218703693073*^9, 
   3.740219316174549*^9, 3.740220725664626*^9, 3.7406235299785748`*^9, 
   3.7407786300441055`*^9, {3.7407787374658937`*^9, 3.7407787515059185`*^9}, 
   3.7407792597116137`*^9, {3.740779291410869*^9, 3.74077929150447*^9}, {
   3.7407794435579367`*^9, 3.7407794537603545`*^9}, {3.740779489359617*^9, 
   3.7407794895936174`*^9}, {3.740779670623536*^9, 3.7407796794843516`*^9}, 
   3.740780547224676*^9, 3.740780580078334*^9, {3.7407807829566903`*^9, 
   3.740780802675125*^9}, 3.7407824785895987`*^9, {3.740783120387927*^9, 
   3.7407831238823338`*^9}, 3.740784281084571*^9, 3.7407843527561016`*^9, 
   3.7407847831226892`*^9, 3.740792340872752*^9, 3.740795723424296*^9, 
   3.7407958523585224`*^9, 3.7407962560248313`*^9, 3.740796299814108*^9, 
   3.740796868840708*^9, 3.7407969075287757`*^9, {3.7411140798071146`*^9, 
   3.7411140827087193`*^9}, 3.7411141905985093`*^9, {3.7411142267125726`*^9, 
   3.7411142268685727`*^9}, {3.741114330047154*^9, 3.7411143512943916`*^9}, {
   3.741114411151696*^9, 3.741114418093709*^9}, 3.7411667320210295`*^9, 
   3.7411668087419643`*^9, 3.741202221929366*^9, 3.741892837970529*^9, 
   3.7446637237292566`*^9, 3.744664188516473*^9, 3.7446656128157234`*^9, 
   3.7446656519561925`*^9, 3.744742920198707*^9, 3.744748993426978*^9, 
   3.744875562242749*^9, 3.7452127485518837`*^9, {3.7452134494767146`*^9, 
   3.7452134887263837`*^9}, 3.7452135890501595`*^9, 3.7452136909027386`*^9, {
   3.745213776375289*^9, 3.745213824891374*^9}, {3.7452153796921053`*^9, 
   3.7452153895513225`*^9}, {3.745215679480633*^9, 3.7452156795430326`*^9}, {
   3.7452158443729224`*^9, 3.7452158470717273`*^9}, 3.745216263249258*^9, 
   3.745220775675985*^9, 3.74605200870955*^9, {3.746054459278658*^9, 
   3.746054461899462*^9}, {3.746054502833934*^9, 3.7460545099319468`*^9}, {
   3.7460545513812194`*^9, 3.746054580834071*^9}, 3.746054715181507*^9, {
   3.746055056728507*^9, 3.746055078334545*^9}, {3.7460696676769714`*^9, 
   3.746069675196185*^9}, {3.746069717519059*^9, 3.7460697568623285`*^9}, {
   3.746069787937583*^9, 3.74606981489443*^9}, 3.746073742165717*^9, 
   3.7460738199942536`*^9, 3.74607396574531*^9, {3.7460739981621666`*^9, 
   3.7460740214218073`*^9}, {3.7460741612292533`*^9, 3.7460741660964613`*^9}, 
   3.7460742930026846`*^9, 3.7469916783892336`*^9, {3.746995596376917*^9, 
   3.7469956449086018`*^9}, 3.746995874717006*^9, {3.746995951484741*^9, 
   3.7469959562115493`*^9}, {3.7469960042752333`*^9, 
   3.7469960100160437`*^9}, {3.7470008209349375`*^9, 3.747000823181341*^9}, {
   3.747000889419058*^9, 3.7470008910414605`*^9}, {3.7470280589399815`*^9, 
   3.7470280614983854`*^9}, {3.748111197232164*^9, 3.7481112317394247`*^9}, 
   3.74811147967066*^9, 3.7481115205271316`*^9, 3.748111692642234*^9, 
   3.7481117874748*^9, 3.748112631498683*^9, 3.748112775284136*^9, 
   3.7481129517516456`*^9, {3.748113151322796*^9, 3.7481131579684076`*^9}, 
   3.7481148652730074`*^9, 3.748152386065356*^9, 3.7481567738382626`*^9, 
   3.749668436049493*^9, 3.75071693891677*^9, 3.7507175127325783`*^9, 
   3.7507180095666513`*^9, 3.7507180789087734`*^9, 3.7507182048633947`*^9, 
   3.7507183299756145`*^9, {3.750719880875539*^9, 3.750719881031539*^9}, 
   3.750720705694188*^9, 3.7507440057557216`*^9, {3.750744086719864*^9, 
   3.750744089496669*^9}, 3.7509082696490107`*^9, 3.7509083249043074`*^9, 
   3.750911286246544*^9, 3.7509118911532063`*^9, 3.7509121115503936`*^9, {
   3.750923632836231*^9, 3.750923632961032*^9}, 3.750925073460763*^9, 
   3.750927718913814*^9, 3.7513499450769176`*^9, 3.7513500249334583`*^9, 
   3.751350205394575*^9, {3.751357124693128*^9, 3.751357125535529*^9}, 
   3.7513572227785015`*^9, {3.7513577543338346`*^9, 3.7513577545366354`*^9}, {
   3.7514075994397964`*^9, 3.7514076315758533`*^9}, 3.755049981992358*^9, 
   3.7550500823161345`*^9, 3.7550501621414747`*^9, {3.755050424627536*^9, 
   3.75505042743554*^9}, 3.7550509452316504`*^9, {3.7550519417295938`*^9, 
   3.755051975534853*^9}, 3.755137950815219*^9, {3.755138029314557*^9, 
   3.755138038986574*^9}, 3.755138086785058*^9, {3.755138188762437*^9, 
   3.7551382198688917`*^9}, 3.755138327743081*^9, {3.7551385822731285`*^9, 
   3.7551385983567567`*^9}, {3.7551386797264996`*^9, 3.755138682924505*^9}, {
   3.755138886446863*^9, 3.7551388934044757`*^9}, 3.75514146393878*^9, 
   3.7551414955444355`*^9, 3.755142322019229*^9, 3.755143438106188*^9, 
   3.755147618487777*^9, 3.7552236306785617`*^9, 3.755223735116352*^9, {
   3.755225733931464*^9, 3.7552257365054693`*^9}, {3.755227512081214*^9, 
   3.755227512237214*^9}, 3.7552279693180175`*^9, 3.7642903496367607`*^9, 
   3.7642905384454937`*^9, {3.764290573888756*^9, 3.7642906052136106`*^9}, 
   3.764290664977316*^9, {3.7642906962553706`*^9, 3.7642907377670436`*^9}, 
   3.7642907697626996`*^9, {3.7642908862013044`*^9, 3.7642908919733143`*^9}, {
   3.764290988459484*^9, 3.7642909895202856`*^9}, 3.7642916178573933`*^9, 
   3.7642946900651903`*^9, 3.764304233178358*^9, 3.764315634831588*^9, 
   3.7643178571376925`*^9, 3.7643199679870043`*^9, 3.7646643825688667`*^9, 
   3.7646644254533424`*^9, {3.7646670587823772`*^9, 3.7646670614031816`*^9}, {
   3.7646689741957426`*^9, 3.7646689743361425`*^9}, 3.7648879733065042`*^9, 
   3.7648880095453677`*^9, 3.764888905544944*^9, {3.7648904306286244`*^9, 
   3.764890430784625*^9}, 3.764890639856192*^9, 3.7648920316777287`*^9, 
   3.7648920799130135`*^9, {3.7649026496400437`*^9, 3.764902649811644*^9}, 
   3.765060795861064*^9, 3.765170874688287*^9, 3.7651709275255795`*^9, 
   3.7651715934707565`*^9, 3.765171678553306*^9, 3.7651720873988247`*^9, 
   3.7652588609279366`*^9, 3.7652589119400263`*^9, {3.7652678534549417`*^9, 
   3.765267853720142*^9}, 3.766219677048067*^9, 3.766219733644967*^9, 
   3.7662202150930123`*^9, 3.7662231492289677`*^9, 3.7662232546071525`*^9, 
   3.7664261773697233`*^9, {3.7664771999234896`*^9, 3.766477221467128*^9}, {
   3.7664774867923937`*^9, 3.7664775002552176`*^9}, {3.7688458990388994`*^9, 
   3.7688459132349243`*^9}, 3.7688464502450686`*^9, 3.7688469138338833`*^9, 
   3.7919252574896*^9, 3.7919253465779333`*^9, {3.791925415764722*^9, 
   3.7919254377907343`*^9}, {3.791925604735676*^9, 3.791925624980929*^9}, 
   3.791925707745304*^9, 3.791925763091635*^9, {3.791925911291008*^9, 
   3.7919259140403547`*^9}, {3.7919260222877755`*^9, 3.7919260262243795`*^9}, 
   3.7919263244810195`*^9, 3.7919272129150743`*^9, 3.7919273025813866`*^9, 
   3.79194113621521*^9, 3.791941232926713*^9, {3.791941514157159*^9, 
   3.7919415143290224`*^9}, 3.791943103216889*^9, 3.791945596183156*^9, 
   3.7919456441249638`*^9, 3.791946082173215*^9, 3.7919462651924844`*^9, 
   3.7921427775483007`*^9, 3.7921428897561445`*^9, {3.7921430152576857`*^9, 
   3.7921430359090414`*^9}, 3.7921430673703427`*^9, {3.792143141259096*^9, 
   3.7921431417121143`*^9}, 3.792143242125839*^9, 3.792143486850278*^9, {
   3.7921450052007465`*^9, 3.792145013042673*^9}, {3.7921451058956823`*^9, 
   3.7921451214857616`*^9}, 3.7921455314668036`*^9, {3.792206627246333*^9, 
   3.792206627246333*^9}, 3.792206754231901*^9, 3.79220685052157*^9, 
   3.7922078842917633`*^9, {3.7922705977593207`*^9, 3.7922705977593207`*^9}, {
   3.7922709118099704`*^9, 3.792270911903698*^9}, 3.792271385291582*^9, 
   3.792272246914014*^9, 3.79253865659698*^9, 3.7925389383292637`*^9, {
   3.79253897772618*^9, 3.7925390027310505`*^9}, 3.792539084603735*^9, 
   3.792539165209653*^9, {3.7925532584724584`*^9, 3.792553265876953*^9}, {
   3.7925536738897276`*^9, 3.7925536950096927`*^9}, 3.792553901929451*^9, 
   3.7925547774031987`*^9, 3.7926564191426325`*^9, 3.802546784503578*^9, 
   3.8025468351166477`*^9, {3.802547157478155*^9, 3.8025471596963935`*^9}, 
   3.8025530393291664`*^9, {3.802553145023003*^9, 3.8025531542395735`*^9}, {
   3.8025532156626034`*^9, 3.802553248326777*^9}, {3.8025534886879206`*^9, 
   3.802553504246724*^9}, {3.8025797911758394`*^9, 3.8025798028293123`*^9}, {
   3.8025800334054585`*^9, 3.802580033577258*^9}, 3.802582705776685*^9, 
   3.807854574938098*^9, 3.8078546986654563`*^9, {3.8078547333297863`*^9, 
   3.8078547854564734`*^9}, 3.80785486835991*^9, 3.807855055961532*^9, 
   3.816906071203289*^9, 3.8169062277454643`*^9, {3.816906300915784*^9, 
   3.8169063034933043`*^9}, 3.8169064130613346`*^9, 3.816906495104565*^9, 
   3.816906610405632*^9, 3.816906749379136*^9, 3.816907241217867*^9, 
   3.8169118516709604`*^9, {3.8208065480383034`*^9, 3.8208065503971148`*^9}, {
   3.8208066149286785`*^9, 3.820806624051549*^9}, {3.8208067216221795`*^9, 
   3.8208067220908184`*^9}, 3.8208068322209473`*^9, 3.820807172858101*^9, {
   3.8278746045256357`*^9, 3.8278746309881845`*^9}, {3.8282860508815856`*^9, 
   3.8282860579267845`*^9}, {3.8282861859735947`*^9, 3.8282862018448706`*^9}, 
   3.828286468280572*^9, 3.828553587454216*^9, 3.8285574082753267`*^9, {
   3.8286362338967395`*^9, 3.828636255175177*^9}, 3.828637664454053*^9, 
   3.828718689983182*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571686237884`*^9, 3.848257192868057*^9}, {3.84825923472919*^9, 
   3.848259236681822*^9}, 3.848259612007312*^9, {3.8482597677280135`*^9, 
   3.848259771133461*^9}, {3.8482598468578053`*^9, 3.8482598497008877`*^9}, {
   3.848260094465921*^9, 3.8482601019797363`*^9}, {3.854761764009829*^9, 
   3.854761764009829*^9}, 3.854761812763962*^9, 3.8547619184957533`*^9, {
   3.85476213510832*^9, 3.8547621352801824`*^9}, {3.854762175741544*^9, 
   3.854762196820649*^9}, 3.854763397808587*^9, 3.854911091585896*^9, 
   3.883168549514434*^9, 3.8831685918481736`*^9, {3.8831693368284187`*^9, 
   3.8831693369690075`*^9}, 3.8831700820047045`*^9, {3.88326856715734*^9, 
   3.883268567688492*^9}, {3.956529075649271*^9, 3.956529075649271*^9}, 
   3.956529278561458*^9, 3.956529333579769*^9, 3.956529375257483*^9, {
   3.956529477764713*^9, 3.9565294832321777`*^9}, {3.95652970749885*^9, 
   3.9565297214487343`*^9}, {3.9565301959560966`*^9, 3.9565302258865724`*^9}, 
   3.956530334767271*^9, 3.9565304297655487`*^9, 3.956541561095746*^9, 
   3.9565466347746897`*^9, {3.9565466764680595`*^9, 3.9565466773584785`*^9}, 
   3.9565469537936063`*^9, 3.956547123488159*^9, 3.9565472030163713`*^9, {
   3.956548210431202*^9, 3.956548210837391*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0220.png\>\"", ",", "frpConfHypergeomF2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533955185636678*^9, 3.533955193530292*^9}, 
   3.5470089020736527`*^9, 3.5470089906974087`*^9, {3.5501987606920385`*^9, 
   3.5501987608792386`*^9}, 3.550198849300194*^9, {3.5504693214945307`*^9, 
   3.55046932160373*^9}, {3.5531142987603564`*^9, 3.55311430097556*^9}, 
   3.553114600798087*^9, 3.5531850697594075`*^9, 3.55318527036016*^9, 
   3.5531900910817485`*^9, 3.553190165072678*^9, 3.5531908750251255`*^9, {
   3.553190970122893*^9, 3.553190970310093*^9}, {3.5532137997388144`*^9, 
   3.5532138043876224`*^9}, {3.5532141363562055`*^9, 3.553214165434656*^9}, {
   3.556389606160061*^9, 3.5563896074548635`*^9}, 3.556389890454961*^9, {
   3.7325812332963877`*^9, 3.732581233717589*^9}, 3.7326535116184597`*^9, {
   3.7326591364731426`*^9, 3.732659136644743*^9}, 3.7326593484631157`*^9, 
   3.7402167509844255`*^9, 3.7402182539798756`*^9, 3.740219001927597*^9, 
   3.7407786321033087`*^9, {3.740780622260808*^9, 3.7407806224012084`*^9}, 
   3.740782321871723*^9, {3.7407957164042835`*^9, 3.740795721505492*^9}, 
   3.7411140854231243`*^9, {3.74111413420441*^9, 3.7411141344228106`*^9}, 
   3.741166727684222*^9, {3.7411668654792643`*^9, 3.741166865619664*^9}, 
   3.7414211246988482`*^9, 3.7446637267400618`*^9, 3.7446644002400446`*^9, 
   3.7446656128157234`*^9, {3.744665930744282*^9, 3.744665930884682*^9}, 
   3.7452127519526896`*^9, 3.7452127982691708`*^9, 3.7452152179426208`*^9, 
   3.7452153867901173`*^9, 3.7460520107999535`*^9, {3.7460520534036283`*^9, 
   3.74605205424603*^9}, 3.746055118879016*^9, 3.7469914856820946`*^9, {
   3.746991527770969*^9, 3.746991555866618*^9}, 3.7469916833032417`*^9, 
   3.7481112017873716`*^9, {3.7481113416104174`*^9, 3.7481113417820177`*^9}, 
   3.748112629455079*^9, 3.7481132179193125`*^9, {3.7507168447394047`*^9, 
   3.7507168472198095`*^9}, 3.7507169437995787`*^9, 3.7509079022215652`*^9, {
   3.75090794495004*^9, 3.75090794512164*^9}, 3.7509082696490107`*^9, 
   3.7513500249334583`*^9, 3.7513500920291758`*^9, {3.7513503492580276`*^9, 
   3.751350349445228*^9}, 3.7514002242042093`*^9, {3.755049692159449*^9, 
   3.7550496922998495`*^9}, {3.7550498033876443`*^9, 3.7550498039024453`*^9}, 
   3.755049981992358*^9, 3.762283566429557*^9, {3.762283611841237*^9, 
   3.7622836119660373`*^9}, 3.7622837156906195`*^9, 3.764280969439039*^9, 
   3.7642810018246965`*^9, {3.764281074411624*^9, 3.7642810945668592`*^9}, {
   3.764281227135892*^9, 3.7642812273854923`*^9}, 3.7642813042000275`*^9, 
   3.764291565768902*^9, 3.7646644254533424`*^9, {3.7646645461195545`*^9, 
   3.7646645463223543`*^9}, {3.7648874056839075`*^9, 3.7648874058399076`*^9}, 
   3.7648879733221045`*^9, {3.7648894222178516`*^9, 3.7648894224050517`*^9}, {
   3.7650602476465006`*^9, 3.765060247818101*^9}, 3.765060798138668*^9, 
   3.7650876836644077`*^9, {3.765170820041391*^9, 3.765170820322191*^9}, 
   3.765170874688287*^9, 3.7652589119400263`*^9, {3.765259071731107*^9, 
   3.7652590718091073`*^9}, {3.7662195948515224`*^9, 3.7662195957563243`*^9}, 
   3.766219677048067*^9, 3.766220217308216*^9, 3.7664771999234896`*^9, 
   3.7664773393097343`*^9, 3.766477486807994*^9, 3.766477573590946*^9, {
   3.7666119431449013`*^9, 3.7666119433165016`*^9}, {3.7673939377297125`*^9, 
   3.7673939378857126`*^9}, 3.7688458990388994`*^9, 3.768845992155463*^9, 
   3.7688461150368786`*^9, 3.7919252574896*^9, 3.791926052499424*^9, {
   3.791926095989151*^9, 3.791926096598382*^9}, 3.791941133887636*^9, 
   3.7919412657158723`*^9, {3.7919455983389053`*^9, 3.7919456033221006`*^9}, 
   3.7921427775483007`*^9, {3.792144252867916*^9, 3.7921442530085073`*^9}, 
   3.792145007731429*^9, 3.792145059016163*^9, 3.792206627246333*^9, {
   3.792208164803473*^9, 3.792208165553295*^9}, 3.7922705977593207`*^9, {
   3.7922707301029916`*^9, 3.7922707302904463`*^9}, 3.79253865659698*^9, 
   3.7925540406154003`*^9, 3.8025468380534554`*^9, {3.8025469017103243`*^9, 
   3.8025469097240615`*^9}, {3.8025516449002275`*^9, 3.802551645056441*^9}, {
   3.8025797876922874`*^9, 3.802579794206377*^9}, 3.8078544401712985`*^9, {
   3.8078545001470075`*^9, 3.807854500934877*^9}, 3.8078545785694313`*^9, 
   3.8169060743744335`*^9, 3.816906826079885*^9, 3.8169068668827724`*^9, 
   3.820806437814374*^9, {3.8208064682759457`*^9, 3.8208064684790215`*^9}, 
   3.820806553490138*^9, {3.8278746045256357`*^9, 3.8278746310038056`*^9}, 
   3.827874859287332*^9, {3.827874913149688*^9, 3.827874914102568*^9}, 
   3.828286652268653*^9, 3.8482570386857076`*^9, 3.848257074645941*^9, {
   3.84825712863323*^9, 3.8482571287582006`*^9}, 3.8547617640254436`*^9, {
   3.854761842820959*^9, 3.8547618694084587`*^9}, {3.8831685918481736`*^9, 
   3.8831686183106723`*^9}, {3.8831686600976796`*^9, 3.8831686602538943`*^9}, 
   3.9565290756648955`*^9, {3.9565292025011487`*^9, 3.956529227448423*^9}, 
   3.9565466330407534`*^9, {3.9565467031961346`*^9, 3.956546703399209*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ap3dConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"AbsArgPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.6"}], "-", 
       RowBox[{"3.7", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3.8"}], "-", 
       RowBox[{"3.2", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.2"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"-", "20"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0007", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0005", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.528619442909766*^9, 3.528619451910281*^9}, {
   3.5286214386949186`*^9, 3.5286214646354027`*^9}, {3.5286222532055063`*^9, 
   3.528622288166506*^9}, 3.52866506133381*^9, 3.5286651054974875`*^9, {
   3.5286651514707685`*^9, 3.528665155292775*^9}, {3.5287006732862062`*^9, 
   3.528700705625063*^9}, {3.5287008793313684`*^9, 3.5287008818741727`*^9}, {
   3.5287009125126266`*^9, 3.5287009144938297`*^9}, {3.5289198836377797`*^9, 
   3.5289199933371725`*^9}, {3.5289200401996546`*^9, 
   3.5289200576560855`*^9}, {3.5289201204305954`*^9, 
   3.5289201283242097`*^9}, {3.5289213102134857`*^9, 3.5289213711159925`*^9}, 
   3.5289214070272555`*^9, {3.52892258770053*^9, 3.528922633018609*^9}, {
   3.528922704669535*^9, 3.5289227124695487`*^9}, {3.5289237056920934`*^9, 
   3.528923718624516*^9}, 3.5289237912270436`*^9, {3.528923835453121*^9, 
   3.5289238359055223`*^9}, {3.52892390278284*^9, 3.5289239065580463`*^9}, 
   3.5289239438421116`*^9, {3.528923987787389*^9, 3.528924004978619*^9}, {
   3.5289240667547274`*^9, 3.528924087986365*^9}, {3.5289243401296077`*^9, 
   3.528924344294815*^9}, {3.5289245120575094`*^9, 3.5289245256919336`*^9}, {
   3.5289245779988256`*^9, 3.5289246058916745`*^9}, 3.5289246438465414`*^9, {
   3.5301781945730553`*^9, 3.530178289296421*^9}, {3.530178945963975*^9, 
   3.5301789486471796`*^9}, {3.5301820319841957`*^9, 3.530182109703532*^9}, {
   3.5339560194937434`*^9, 3.5339560600070143`*^9}, {3.5339561008634863`*^9, 
   3.53395611423271*^9}, {3.5339561603307905`*^9, 3.5339561646675987`*^9}, {
   3.5339561968816547`*^9, 3.533956209845278*^9}, {3.534022431253952*^9, 
   3.5340224314567523`*^9}, 3.534022572481*^9, {3.534022607705862*^9, 
   3.534022607924262*^9}, {3.5345620477651424`*^9, 3.5345620818512025`*^9}, {
   3.534562122941674*^9, 3.5345621667933517`*^9}, {3.534648397811719*^9, 
   3.534648401118925*^9}, {3.534709801160247*^9, 3.5347098283822947`*^9}, {
   3.5347098611891527`*^9, 3.5347098619223537`*^9}, {3.534709907926834*^9, 
   3.5347099086288357`*^9}, {3.534710222192987*^9, 3.5347102332066064`*^9}, 
   3.5347103216587615`*^9, {3.5347106722693777`*^9, 3.534710675982184*^9}, 
   3.5470089462373304`*^9, {3.5470091278996496`*^9, 3.5470091547472963`*^9}, {
   3.5470094371389923`*^9, 3.547009443207403*^9}, 3.547009595901272*^9, {
   3.547009818014462*^9, 3.5470098320856867`*^9}, {3.5470099040642133`*^9, 
   3.5470099184162383`*^9}, 3.5470100544952774`*^9, 3.547010367529028*^9, 
   3.550198810721326*^9, {3.550199038434926*^9, 3.550199045018138*^9}, {
   3.5501999115110607`*^9, 3.5501999141942654`*^9}, {3.55019997380197*^9, 
   3.55019997398917*^9}, 3.5502073133024054`*^9, 3.550207620982745*^9, {
   3.550207765158199*^9, 3.550207802863465*^9}, {3.55020859692346*^9, 
   3.550208598467862*^9}, {3.5502099531430416`*^9, 3.550209992720311*^9}, {
   3.550210137301365*^9, 3.550210139516569*^9}, {3.550210537442068*^9, 
   3.5502105388148704`*^9}, 3.550210684753127*^9, {3.553114489866292*^9, 
   3.5531145040935173`*^9}, 3.5531145564784093`*^9, 3.55311478447281*^9, {
   3.553114928071062*^9, 3.553114930255066*^9}, {3.5531151718526897`*^9, 
   3.5531152734400682`*^9}, {3.5531153988286963`*^9, 
   3.5531153999830985`*^9}, {3.5531841051629133`*^9, 3.5531841089225197`*^9}, 
   3.5531844703907547`*^9, {3.5531848141373587`*^9, 3.55318482037737*^9}, {
   3.564290330120206*^9, 3.564290330120206*^9}, {3.5642910712463074`*^9, 
   3.5642910895763397`*^9}, {3.5642912437514105`*^9, 3.564291261098641*^9}, {
   3.564291324902753*^9, 3.5642913279447584`*^9}, {3.564298881313227*^9, 
   3.564298910968879*^9}, 3.5645703399765744`*^9, {3.5645709011207676`*^9, 
   3.5645709125711875`*^9}, {3.5646321047687345`*^9, 
   3.5646321068747377`*^9}, {3.564706696754722*^9, 3.564706699547127*^9}, 
   3.5647067771728635`*^9, {3.564989627219633*^9, 3.564989637609251*^9}, 
   3.565030962442968*^9, {3.565152889292653*^9, 3.565152909557089*^9}, {
   3.565152945156351*^9, 3.565152963236783*^9}, 3.565153012439269*^9, 
   3.5651530922490096`*^9, {3.565162127699024*^9, 3.5651621308992076`*^9}, 
   3.565983845442522*^9, 3.56598387845218*^9, {3.5659904751889668`*^9, 
   3.5659904837065816`*^9}, 3.56599068772374*^9, 3.5659907302338142`*^9, {
   3.5659908215943756`*^9, 3.565990858936449*^9}, 3.5659913705393476`*^9, {
   3.566162100485265*^9, 3.566162102341668*^9}, {3.567196994409768*^9, 
   3.5671969959541707`*^9}, {3.567197054189073*^9, 3.567197061021885*^9}, {
   3.567197133858413*^9, 3.5671972115621495`*^9}, {3.5671973507731943`*^9, 
   3.5671973567168045`*^9}, {3.567197396247274*^9, 3.567197485604231*^9}, 
   3.5674580328183336`*^9, {3.567570200880618*^9, 3.5675702017074194`*^9}, {
   3.5675706469946012`*^9, 3.5675706511130085`*^9}, 3.5675897096419353`*^9, 
   3.5680246296369*^9, {3.568160274924254*^9, 3.568160309037122*^9}, {
   3.568160380558855*^9, 3.5681603947860794`*^9}, {3.568160466354613*^9, 
   3.5681604854178467`*^9}, 3.568160775578356*^9, {3.568160813751623*^9, 
   3.568160822394038*^9}, 3.570075555135485*^9, 3.570075606833976*^9, {
   3.570076573068473*^9, 3.5700766101497383`*^9}, {3.570086741011756*^9, 
   3.5700867466120763`*^9}, 3.570086991324073*^9, {3.570087119755419*^9, 
   3.570087155371456*^9}, {3.5700962095128574`*^9, 3.5700962258772864`*^9}, 
   3.5700962986358137`*^9, {3.570096349835104*^9, 3.570096368445937*^9}, 
   3.5700964717345185`*^9, 3.573604781666628*^9, 3.573604883878007*^9, 
   3.573604925826481*^9, {3.57360495952254*^9, 3.57360503919188*^9}, 
   3.573605070064334*^9, {3.573605328369588*^9, 3.573605331661194*^9}, 
   3.5736054416881866`*^9, {3.5736058843701644`*^9, 3.5736059731343203`*^9}, {
   3.5736060324456244`*^9, 3.5736060387012353`*^9}, 3.573606118386175*^9, 
   3.5736062033595247`*^9, 3.573606490725857*^9, {3.573692115976136*^9, 
   3.5736921224969473`*^9}, 3.574884949276402*^9, {3.574885006013702*^9, 
   3.574885007963705*^9}, {3.57577172896203*^9, 3.5757717849022293`*^9}, {
   3.575771839158333*^9, 3.5757719145096426`*^9}, {3.575772545302722*^9, 
   3.575772560950617*^9}, 3.5757894252461996`*^9, {3.575974174332202*^9, 
   3.5759741933330355`*^9}, {3.5767311834246573`*^9, 3.576731301158064*^9}, {
   3.576734520722247*^9, 3.5767345253398547`*^9}, {3.5767345693007317`*^9, 
   3.576734571297536*^9}, 3.5767349788482513`*^9, 3.5767427797108574`*^9, {
   3.5767839288211775`*^9, 3.5767839425180016`*^9}, 3.5767840176165333`*^9, {
   3.5767965812116947`*^9, 3.576796592521714*^9}, 3.577871510016669*^9, {
   3.57787163504882*^9, 3.577871661200316*^9}, {3.5778717168644996`*^9, 
   3.577871730870301*^9}, {3.577871778560028*^9, 3.577871806259613*^9}, 
   3.5778718509931717`*^9, {3.5778726345519886`*^9, 3.5778726367521143`*^9}, {
   3.5779963658724623`*^9, 3.577996367728865*^9}, 3.578002028108985*^9, 
   3.5921826867730446`*^9, 3.592182932910277*^9, {3.592182973563948*^9, 
   3.5921829890703754`*^9}, {3.5921894432385116`*^9, 3.59218944813692*^9}, 
   3.592189480928178*^9, 3.5921896208916235`*^9, {3.5921896765369215`*^9, 
   3.5921896875193405`*^9}, {3.592189778717101*^9, 3.592189837654004*^9}, 
   3.606352358951768*^9, {3.6063524969964104`*^9, 3.6063525015360184`*^9}, {
   3.6063526625511017`*^9, 3.6063527326732244`*^9}, {3.6063527650432816`*^9, 
   3.6063527755264997`*^9}, {3.606353335280284*^9, 3.6063533646707354`*^9}, 
   3.60635353794024*^9, 3.6063545635752487`*^9, {3.6063546892490697`*^9, 
   3.6063547050674973`*^9}, {3.6063552211473227`*^9, 3.606355223690127*^9}, {
   3.6063552577605867`*^9, 3.606355272190612*^9}, {3.6063553038430676`*^9, 
   3.606355338163128*^9}, {3.606355581851156*^9, 3.606355644547666*^9}, {
   3.60636212821593*^9, 3.6063621434727573`*^9}, {3.6063647301913004`*^9, 
   3.606364732328504*^9}, 3.606367653822036*^9, {3.606423653579423*^9, 
   3.606423662861439*^9}, 3.6064237042951117`*^9, 3.6064240186796646`*^9, 
   3.6064240824057765`*^9, 3.6064352530456715`*^9, 3.625306348124917*^9, {
   3.625306422349847*^9, 3.6253064464050894`*^9}, {3.625306510552402*^9, 
   3.625306553920478*^9}, {3.625306755270032*^9, 3.6253068394009795`*^9}, 
   3.625306876669445*^9, 3.625307106474249*^9, 3.6253080361026907`*^9, 
   3.6253565393719177`*^9, 3.6253833999639544`*^9, 3.6253834309924088`*^9, 
   3.6291871583501062`*^9, {3.6291872318262353`*^9, 3.629187239704249*^9}, {
   3.6291873056923647`*^9, 3.6291873143815804`*^9}, {3.6291875784324455`*^9, 
   3.6291876127525053`*^9}, {3.629189364101582*^9, 3.629189366394786*^9}, {
   3.629232868970395*^9, 3.629232869173195*^9}, 3.629412973595767*^9, {
   3.629681734167853*^9, 3.6296817892827497`*^9}, {3.6296820677432384`*^9, 
   3.6296821134157267`*^9}, {3.6296821492957897`*^9, 3.6296821592174067`*^9}, 
   3.6296822142855034`*^9, 3.6296823447797327`*^9, {3.6296823820481987`*^9, 
   3.6296823873678074`*^9}, 3.6296824244022727`*^9, {3.629682533259264*^9, 
   3.629682571479331*^9}, {3.6296864438997335`*^9, 3.6296864498121443`*^9}, 
   3.6301301056703367`*^9, 3.630186806038844*^9, {3.630187005195995*^9, 
   3.6301870543204813`*^9}, 3.630187116294997*^9, {3.6301872101759624`*^9, 
   3.630187240518016*^9}, {3.6301879818625174`*^9, 3.630188037336215*^9}, {
   3.6301880817139006`*^9, 3.6301881292739916`*^9}, {3.630192463897605*^9, 
   3.6301924663624096`*^9}, {3.6325489266416855`*^9, 3.6325489436145153`*^9}, 
   3.632549332330798*^9, {3.6325493823600864`*^9, 3.6325493932021055`*^9}, {
   3.632549475316257*^9, 3.632549494769491*^9}, 3.6325495787244463`*^9, {
   3.63254965087018*^9, 3.6325496533193846`*^9}, {3.632549689417848*^9, 
   3.632549695548659*^9}, {3.632549725609912*^9, 3.632549731350722*^9}, 
   3.632549777632004*^9, {3.6326038339351673`*^9, 3.6326038351987696`*^9}, 
   3.6326052431856437`*^9, 3.632605279237307*^9, {3.6327896696112256`*^9, 
   3.63278967761404*^9}, 3.632789733462138*^9, 3.632789829792307*^9, 
   3.632789870211978*^9, 3.632789986728583*^9, 3.632798118478204*^9, 
   3.632798253418441*^9, {3.632805774254259*^9, 3.6328057895110865`*^9}, {
   3.6328080477542534`*^9, 3.6328080865671215`*^9}, {3.632808253050614*^9, 
   3.6328082534094143`*^9}, {3.632808331378351*^9, 3.632808360269602*^9}, {
   3.632808538526723*^9, 3.6328085720043817`*^9}, {3.632808631050485*^9, 
   3.632808642282505*^9}, {3.632808677908575*^9, 3.6328087181990533`*^9}, {
   3.6328089591882763`*^9, 3.63280900082475*^9}, {3.6328090336628075`*^9, 
   3.632809129977377*^9}, 3.632809186913084*^9, {3.632809216974337*^9, 
   3.632809236926772*^9}, 3.6328094921744204`*^9, {3.6328628083886805`*^9, 
   3.6328628144414916`*^9}, 3.632862901630045*^9, 3.6345039446897955`*^9, 
   3.634504022565132*^9, {3.634504657689049*^9, 3.6345046727742753`*^9}, {
   3.634504709243346*^9, 3.6345047653410444`*^9}, {3.634504880625247*^9, 
   3.6345049408257523`*^9}, {3.6345049821346254`*^9, 3.63450498472423*^9}, {
   3.6345052382364817`*^9, 3.634505239952485*^9}, {3.6345553893336797`*^9, 
   3.6345554050117073`*^9}, 3.6345568508334475`*^9, {3.636074809678754*^9, 
   3.6360748135943604`*^9}, {3.6360753609197226`*^9, 3.636075371137741*^9}, {
   3.6360754445046697`*^9, 3.6360754448322706`*^9}, 3.6360754780759287`*^9, {
   3.6360755150323935`*^9, 3.636075526139613*^9}, 3.6364953410960603`*^9, 
   3.636495413464587*^9, 3.636495521806778*^9, 3.636495566391656*^9, 
   3.6364955986993127`*^9, 3.63649578354646*^9, {3.636496052943333*^9, 
   3.636496059417344*^9}, {3.636496089572198*^9, 3.6364960983862133`*^9}, 
   3.6364962814213343`*^9, {3.6364969368880863`*^9, 3.636496945000101*^9}, 
   3.7255922261262445`*^9, 3.7255924668034678`*^9, 3.7255925194379597`*^9, {
   3.725594490754224*^9, 3.7255945013310423`*^9}, 3.7255952592895737`*^9, 
   3.725595809710141*^9, 3.725595872032251*^9, 3.725596154470747*^9, 
   3.7255964263948245`*^9, 3.7255994902566366`*^9, 3.7256016031495495`*^9, 
   3.7256016803852854`*^9, {3.7257699711575327`*^9, 3.7257699995651827`*^9}, 
   3.7257711688340364`*^9, 3.7257741402492557`*^9, 3.7257744781258564`*^9, 
   3.7258490150765495`*^9, {3.725852074641125*^9, 3.725852075202726*^9}, 
   3.725852252840238*^9, 3.725852386626073*^9, {3.7258526579417496`*^9, 
   3.725852658565751*^9}, 3.7258527373146887`*^9, {3.7258528441436768`*^9, 
   3.7258528480904837`*^9}, 3.726913461460272*^9, {3.7269135066691513`*^9, 
   3.7269135066847515`*^9}, 3.7269135736244693`*^9, {3.7269141963775625`*^9, 
   3.726914207671983*^9}, 3.726914350100233*^9, {3.726914421298758*^9, 
   3.7269144217511587`*^9}, 3.7269145086589117`*^9, 3.7269146264547186`*^9, 
   3.7269147176680784`*^9, {3.726914927879649*^9, 3.7269149421848745`*^9}, {
   3.726942862934918*^9, 3.726942875820541*^9}, 3.7269430613360662`*^9, 
   3.7269527172550287`*^9, {3.732581313558529*^9, 3.732581414007105*^9}, {
   3.7326583984946456`*^9, 3.732658428493498*^9}, {3.732658557942526*^9, 
   3.732658586022575*^9}, {3.732659178499616*^9, 3.732659189263635*^9}, 
   3.732662539865631*^9, {3.7402178619119854`*^9, 3.740217868385997*^9}, {
   3.7402181435784817`*^9, 3.740218149693692*^9}, {3.740218205900591*^9, 
   3.7402182074137936`*^9}, {3.740218302823561*^9, 3.740218347018439*^9}, {
   3.740218658655794*^9, 3.7402186693574123`*^9}, {3.7402192940381107`*^9, 
   3.7402193007617226`*^9}, {3.740220269338224*^9, 3.7402202697282248`*^9}, {
   3.740220328462328*^9, 3.740220338337145*^9}, {3.74062349322491*^9, 
   3.7406234962357154`*^9}, {3.740778595583645*^9, 3.74077859848525*^9}, {
   3.740778651650143*^9, 3.7407786648009663`*^9}, {3.7407788761441393`*^9, 
   3.7407788989669795`*^9}, {3.740779013450781*^9, 3.740779023996399*^9}, {
   3.7407791542866287`*^9, 3.7407791747070646`*^9}, {3.740779219900344*^9, 
   3.740779220196744*^9}, {3.740779424588303*^9, 3.7407794273807077`*^9}, {
   3.7407794683775797`*^9, 3.7407794818404036`*^9}, {3.7407796849131613`*^9, 
   3.7407797216824255`*^9}, {3.7407798321070204`*^9, 3.7407798775031*^9}, {
   3.7407800627346253`*^9, 3.740780110221109*^9}, {3.740780271946593*^9, 
   3.7407802910098267`*^9}, 3.740780521968232*^9, {3.740780648765255*^9, 
   3.7407806521660604`*^9}, {3.740780740587016*^9, 3.7407807443622227`*^9}, {
   3.7407824497451477`*^9, 3.740782452974354*^9}, {3.740783174738423*^9, 
   3.740783181930035*^9}, 3.740784309105423*^9, 3.7407843782021475`*^9, 
   3.740784798230516*^9, 3.740792141493194*^9, {3.740795745950735*^9, 
   3.7407958089592457`*^9}, 3.7407962456820135`*^9, 3.740796278894471*^9, {
   3.7407966335298944`*^9, 3.740796667288354*^9}, {3.740796726833658*^9, 
   3.740796732012867*^9}, {3.7407968196070213`*^9, 3.740796823959429*^9}, {
   3.741114044270252*^9, 3.741114047499458*^9}, 3.741114172876878*^9, {
   3.741114214840952*^9, 3.7411142149657516`*^9}, {3.7411143056643114`*^9, 
   3.7411143086907167`*^9}, {3.7411143683764215`*^9, 
   3.7411143879700556`*^9}, {3.7411144249889207`*^9, 
   3.7411144431785526`*^9}, {3.7411667545006695`*^9, 3.741166765233488*^9}, 
   3.74189270181349*^9, 3.74466368597719*^9, 3.7446641759896507`*^9, 
   3.7446656127845235`*^9, 3.744665651924992*^9, 3.744742913131895*^9, {
   3.7447489853929644`*^9, 3.744748987545768*^9}, 3.744875554021535*^9, {
   3.7452126977581944`*^9, 3.7452126994273973`*^9}, {3.7452128151796007`*^9, 
   3.74521282638042*^9}, {3.7452129967795196`*^9, 3.745213042097599*^9}, {
   3.7452130797560654`*^9, 3.745213081565668*^9}, {3.7452131350581627`*^9, 
   3.74521318497825*^9}, {3.7452132378155427`*^9, 3.745213240966748*^9}, {
   3.7452136012649813`*^9, 3.745213631029834*^9}, {3.745213734582815*^9, 
   3.7452137373908205`*^9}, {3.7452153530628586`*^9, 3.7452153600672708`*^9}, 
   3.7452154080997553`*^9, {3.745215674051823*^9, 3.7452156741454234`*^9}, {
   3.7452158387569127`*^9, 3.745215838975313*^9}, {3.745216206574359*^9, 
   3.745216245761627*^9}, 3.745220787875206*^9, 3.746051986744711*^9, {
   3.7460521008589115`*^9, 3.746052131778166*^9}, {3.7460521666286273`*^9, 
   3.7460524545427327`*^9}, 3.746052540857684*^9, {3.746053417769227*^9, 
   3.7460534259280415`*^9}, 3.746054345117657*^9, 3.7460546304265585`*^9, {
   3.7460742014929237`*^9, 3.746074240758193*^9}, 3.746991621012333*^9, {
   3.746994997701064*^9, 3.746995027793517*^9}, {3.7469953201784315`*^9, 
   3.7469954400490417`*^9}, {3.7469954827307167`*^9, 3.74699550728516*^9}, 
   3.7469955396084166`*^9, {3.7470008008733025`*^9, 3.74700080527251*^9}, {
   3.7470008733666296`*^9, 3.747000875893834*^9}, {3.747000949837964*^9, 
   3.747000952287168*^9}, 3.7470264752655973`*^9, {3.747028003559884*^9, 
   3.7470280096126947`*^9}, {3.7481111476864767`*^9, 3.748111150276081*^9}, 
   3.748111262440278*^9, 3.7481114647570333`*^9, 3.7481114993578944`*^9, 
   3.7481117436231236`*^9, 3.7481117783019843`*^9, 3.7481118211240597`*^9, 
   3.7481119089054136`*^9, 3.748112016779603*^9, 3.7481126540251226`*^9, {
   3.748112759746508*^9, 3.7481127604173093`*^9}, {3.748112809635396*^9, 
   3.748112816156207*^9}, {3.748112846591861*^9, 3.7481128812083216`*^9}, 
   3.7481129454960346`*^9, 3.748113095849098*^9, 3.7481148409525647`*^9, 
   3.7481523665185213`*^9, 3.749668417688261*^9, 3.7507168750970583`*^9, {
   3.7507169896168594`*^9, 3.750716992861665*^9}, {3.750717108551468*^9, 
   3.7507172392640977`*^9}, {3.7507172898861866`*^9, 3.75071732030624*^9}, {
   3.750717367402723*^9, 3.7507173891803613`*^9}, {3.7507175430902314`*^9, 
   3.750717551592246*^9}, {3.750717698907706*^9, 3.7507177368313723`*^9}, {
   3.750717804535491*^9, 3.7507178507895727`*^9}, {3.750717899056057*^9, 
   3.750717922424898*^9}, {3.750718034791896*^9, 3.7507180483015194`*^9}, {
   3.7507198746355276`*^9, 3.7507198747915277`*^9}, 3.7507206603917084`*^9, 
   3.750743995100903*^9, {3.750744115267914*^9, 3.7507441173583174`*^9}, 
   3.751183154782548*^9, 3.7511832007870283`*^9, 3.7511889477875257`*^9, 
   3.7511898686887436`*^9, {3.751190067027492*^9, 3.751190067214692*^9}, {
   3.7511904339557366`*^9, 3.7511904342209373`*^9}, 3.751343678313509*^9, {
   3.751343737328412*^9, 3.7513437454248266`*^9}, {3.7513439903028574`*^9, 
   3.7513440021900787`*^9}, 3.7513440559165726`*^9, {3.751344356866702*^9, 
   3.751344358754305*^9}, {3.7513453951733255`*^9, 3.7513454022313385`*^9}, 
   3.751345479623074*^9, 3.751345663578597*^9, 3.7513458060536475`*^9, {
   3.7513462322931957`*^9, 3.751346244788818*^9}, 3.751347972101852*^9, {
   3.7513564574799557`*^9, 3.751356461379963*^9}, 3.7513572038244677`*^9, 
   3.7550499818675575`*^9, 3.755050081270932*^9, 3.755050162094674*^9, {
   3.7550503792938557`*^9, 3.755050383552663*^9}, {3.755050657769945*^9, 
   3.7550507162700477`*^9}, 3.7550507776249557`*^9, {3.7550508327710524`*^9, 
   3.7550509174012012`*^9}, {3.75506116943268*^9, 3.75506120939995*^9}, 
   3.755061263641245*^9, {3.755061304045316*^9, 3.755061332296966*^9}, {
   3.791837454079505*^9, 3.7918374672326627`*^9}, {3.7918375293898745`*^9, 
   3.791837639613963*^9}, {3.7918376716532726`*^9, 3.7918377406682825`*^9}, {
   3.7918378367550473`*^9, 3.7918378492208977`*^9}, {3.791837885353021*^9, 
   3.791837927093199*^9}, {3.7918379571642485`*^9, 3.791837983314344*^9}, {
   3.7918382715699883`*^9, 3.791838307577134*^9}, {3.791838449356269*^9, 
   3.7918384679143763`*^9}, {3.791838600615634*^9, 3.7918386391222763`*^9}, {
   3.7918387136916265`*^9, 3.791838717518922*^9}, {3.7918387964402494`*^9, 
   3.7918388962605457`*^9}, {3.7918390063752236`*^9, 3.791839009499524*^9}, {
   3.7918390718129854`*^9, 3.791839081279473*^9}, 3.791926694308837*^9, {
   3.7919269047590957`*^9, 3.7919269312528725`*^9}, {3.791941159803388*^9, 
   3.791941185000529*^9}, {3.7919414976767054`*^9, 3.7919415013477135`*^9}, {
   3.7919418976905293`*^9, 3.7919419070633483`*^9}, {3.79194194144582*^9, 
   3.7919419457417145`*^9}, {3.791944532323326*^9, 3.7919445402901945`*^9}, 
   3.791945575110017*^9, {3.7919456228331137`*^9, 3.7919456251919384`*^9}, {
   3.7919457477646008`*^9, 3.791945947970544*^9}, {3.7919459941783795`*^9, 
   3.7919459979274817`*^9}, 3.791946210705377*^9, 3.791947743925529*^9, {
   3.792142687080438*^9, 3.7921427322260327`*^9}, {3.7921428660273533`*^9, 
   3.792142869089161*^9}, {3.792142945399186*^9, 3.7921429898730664`*^9}, {
   3.7921430613873816`*^9, 3.792143077961583*^9}, {3.7921431184519978`*^9, 
   3.7921431238725896`*^9}, 3.792143155349477*^9, 3.792143211601818*^9, {
   3.7921432698380313`*^9, 3.7921432757897153`*^9}, 3.7921434567671947`*^9, 
   3.792144982440548*^9, 3.7921450272892933`*^9, {3.792145072528581*^9, 
   3.792145079042717*^9}, 3.79214511625261*^9, 3.792145176425829*^9, {
   3.792145498912012*^9, 3.792145499115088*^9}, 3.792145594592448*^9, {
   3.7921456423624225`*^9, 3.7921456449087653`*^9}, {3.792184449093946*^9, 
   3.792184475478321*^9}, {3.792184553584795*^9, 3.792184576954283*^9}, 
   3.79218461517962*^9, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, {
   3.792206718240422*^9, 3.792206731424799*^9}, 3.792206845007283*^9, {
   3.7922070074375753`*^9, 3.7922070321039267`*^9}, 3.7922073048830905`*^9, {
   3.792207471952895*^9, 3.7922074981029654`*^9}, 3.792207861765847*^9, {
   3.7922106379018235`*^9, 3.7922106451501083`*^9}, {3.792270597712449*^9, 
   3.792270597712449*^9}, {3.792270891033639*^9, 3.7922708912054386`*^9}, 
   3.7922709722175446`*^9, 3.792271039389139*^9, 3.792271363687356*^9, {
   3.792272235885374*^9, 3.792272236072836*^9}, {3.7922725073824296`*^9, 
   3.7922725105379333`*^9}, {3.7922725499817567`*^9, 3.792272575631919*^9}, {
   3.7923819877656794`*^9, 3.7923819927489023`*^9}, 3.7925386565345564`*^9, {
   3.7925388649840345`*^9, 3.7925389122384624`*^9}, {3.792538977710556*^9, 
   3.7925389836310034`*^9}, 3.792539073871907*^9, 3.792539144948824*^9, 
   3.7925391995140295`*^9, {3.7925392495646725`*^9, 3.7925392522827845`*^9}, {
   3.792553223558854*^9, 3.792553236758835*^9}, 3.7925532712350616`*^9, 
   3.792553308132576*^9, {3.7925533452331324`*^9, 3.7925534413978987`*^9}, {
   3.792553882028*^9, 3.7925538868705435`*^9}, 3.792554765327935*^9, 
   3.7926557610118475`*^9, {3.8025467409044847`*^9, 3.802546764242728*^9}, 
   3.802547143215903*^9, {3.8025527321047087`*^9, 3.8025527867480636`*^9}, 
   3.802552818615567*^9, {3.8025528666667347`*^9, 3.802552957988966*^9}, 
   3.802553005837062*^9, 3.802553077929443*^9, {3.8025798749373145`*^9, 
   3.8025798774367256`*^9}, 3.8025799386730447`*^9, {3.8025800226579857`*^9, 
   3.8025800228142033`*^9}, 3.802585141722986*^9, 3.8078545320706625`*^9, {
   3.8078546051822667`*^9, 3.8078546730877852`*^9}, {3.8078547090317235`*^9, 
   3.8078547719695177`*^9}, 3.8078548203562016`*^9, 3.8078549040505514`*^9, {
   3.807855037674405*^9, 3.807855037962635*^9}, 3.816906009920802*^9, {
   3.8169060910892124`*^9, 3.8169061174267793`*^9}, {3.8169061971268187`*^9, 
   3.81690620022064*^9}, {3.8169062907775416`*^9, 3.8169063139595995`*^9}, {
   3.816906347529848*^9, 3.816906358371046*^9}, {3.8169064463660016`*^9, 
   3.8169064751248894`*^9}, {3.8169065717896967`*^9, 
   3.8169065738517113`*^9}, {3.8169066667673993`*^9, 3.816906727987401*^9}, 
   3.816906887955981*^9, {3.8169072179264603`*^9, 3.816907218176386*^9}, {
   3.8208064885993166`*^9, 3.820806493191882*^9}, {3.820806571985753*^9, 
   3.820806591262437*^9}, {3.820806643218884*^9, 3.820806644468581*^9}, {
   3.820806710234253*^9, 3.8208067108747253`*^9}, 3.820806825550688*^9, 
   3.820806870305712*^9, {3.8208070329068413`*^9, 3.8208070358748503`*^9}, 
   3.8208071291340075`*^9, {3.827874604478779*^9, 3.8278746309413214`*^9}, {
   3.828285976508387*^9, 3.8282860378689904`*^9}, {3.828286069189767*^9, 
   3.8282860750946317`*^9}, {3.8282862454440393`*^9, 3.828286274874611*^9}, 
   3.8282864569082403`*^9, 3.8282865303597565`*^9, {3.828288390273615*^9, 
   3.8282884014897327`*^9}, 3.8286362223683195`*^9, 3.8288490034020543`*^9, {
   3.8482570386076126`*^9, 3.8482570386232243`*^9}, {3.8482571403492136`*^9, 
   3.8482571748254557`*^9}, 3.8482572580401783`*^9, {3.8482592159992356`*^9, 
   3.8482592163897705`*^9}, 3.8482592584954834`*^9, 3.848259312904552*^9, {
   3.848259470368842*^9, 3.8482594998619113`*^9}, {3.8482597067661886`*^9, 
   3.848259717341818*^9}, {3.8482598723142166`*^9, 3.848259905868791*^9}, {
   3.8482604837349753`*^9, 3.8482604978097763`*^9}, {3.8547617638223734`*^9, 
   3.8547617638379946`*^9}, {3.8547617944089394`*^9, 3.8547617956430206`*^9}, 
   3.8547619113724337`*^9, {3.854762164384845*^9, 3.8547621866921015`*^9}, 
   3.8549110836125603`*^9, 3.8831684291204414`*^9, 3.8831685486083903`*^9, 
   3.883168591770075*^9, 3.8831689414842877`*^9, 3.8831690014857616`*^9, 
   3.8831706667954407`*^9, 3.8831708703093653`*^9, 3.956529049280467*^9, 
   3.9565290970348783`*^9, {3.9565292776866674`*^9, 3.9565293066954803`*^9}, {
   3.9565293420934258`*^9, 3.9565293429526005`*^9}, {3.9565293996423855`*^9, 
   3.9565294227776165`*^9}, 3.956529535867911*^9, 3.956529572578045*^9, {
   3.9565296812237678`*^9, 3.9565296814268775`*^9}, {3.956530125035204*^9, 
   3.9565301364388113`*^9}, 3.956530440138101*^9, 3.9565415554720664`*^9, 
   3.9565603893207836`*^9, {3.9565604891567297`*^9, 3.956560501966188*^9}, {
   3.956560829312087*^9, 3.9565608294526777`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0230.png\>\"", ",", "ap3dConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955147213811*^9, 3.533955206041514*^9, 3.5470088906700325`*^9, 
   3.5470089487489347`*^9, {3.5501987437036085`*^9, 3.5501987438440084`*^9}, 
   3.550198813591731*^9, {3.5504692939604816`*^9, 3.550469294069682*^9}, 
   3.553114267872302*^9, 3.5531143193679924`*^9, 3.5531145595360146`*^9, 
   3.5531850944854507`*^9, {3.5531852419837103`*^9, 3.5531852422489104`*^9}, 
   3.5531900792725277`*^9, 3.5531901503774524`*^9, 3.55319089444716*^9, 
   3.553190949265656*^9, {3.55321378571439*^9, 3.5532137858547897`*^9}, 
   3.553213822249654*^9, {3.5532141187749743`*^9, 3.553214146340223*^9}, {
   3.5563895716216006`*^9, 3.556389571762001*^9}, 3.5563898724213285`*^9, {
   3.7325812172595596`*^9, 3.7325812177743607`*^9}, 3.7326535308532934`*^9, {
   3.732659113743902*^9, 3.732659113899903*^9}, 3.732659206220865*^9, 
   3.740216750922025*^9, 3.7402182214850187`*^9, 3.740218987201172*^9, 
   3.740778600201253*^9, {3.740780597784365*^9, 3.740780598018366*^9}, 
   3.7407822969116793`*^9, {3.7407956919590406`*^9, 3.740795692161841*^9}, 
   3.7407957432831306`*^9, 3.741114049309061*^9, {3.7411141070915623`*^9, 
   3.7411141072631626`*^9}, 3.741166751692664*^9, 3.7411668366036134`*^9, {
   3.741421168425725*^9, 3.7414211686285257`*^9}, 3.7446636889255953`*^9, 
   3.744664374468799*^9, 3.7446656127845235`*^9, {3.7446659070166407`*^9, 
   3.7446659071882405`*^9}, 3.7452127094426146`*^9, {3.7452127690503197`*^9, 
   3.7452127718427243`*^9}, 3.745215203949396*^9, 3.745215406290152*^9, 
   3.746051989225116*^9, {3.746052022125573*^9, 3.7460520228275747`*^9}, 
   3.746055103278989*^9, 3.746991472593672*^9, 3.7469915089417357`*^9, 
   3.7469915389717884`*^9, 3.746991632774753*^9, 3.748111159012097*^9, {
   3.7481113177579756`*^9, 3.748111317945176*^9}, 3.7481126514667177`*^9, {
   3.748113195470874*^9, 3.748113195689274*^9}, {3.7507167568800507`*^9, 
   3.7507167594852552`*^9}, 3.7507168842542744`*^9, {3.750907902190365*^9, 
   3.750907924545204*^9}, 3.7509082695866103`*^9, 3.7513500248866577`*^9, 
   3.7513500919979753`*^9, {3.7513503196023755`*^9, 3.7513503197739754`*^9}, {
   3.7550497169166927`*^9, 3.7550497426723375`*^9}, 3.7550499818831577`*^9, {
   3.791837399326764*^9, 3.791837403919399*^9}, 3.7918374397704163`*^9, 
   3.7919411562417016`*^9, 3.7919412497352705`*^9, 3.7919455775000772`*^9, 
   3.79194561547548*^9, 3.7921427775170593`*^9, {3.7921442289360805`*^9, 
   3.7921442290922937`*^9}, 3.792144984877466*^9, {3.79214503848981*^9, 
   3.7921450386459846`*^9}, 3.7922066272150636`*^9, {3.7922081247973256`*^9, 
   3.792208125375308*^9}, 3.792270597728077*^9, {3.792270704359085*^9, 
   3.792270704452841*^9}, 3.792538656550113*^9, {3.7925539995157557`*^9, 
   3.7925540001562295`*^9}, 3.8025468009840703`*^9, {3.802546874435505*^9, 
   3.8025468749822507`*^9}, 3.8025469230959077`*^9, 3.8025516256547904`*^9, {
   3.8025798621278696`*^9, 3.802579872625392*^9}, {3.807854454103038*^9, 
   3.807854466154855*^9}, 3.807854538815669*^9, 3.8169060154038906`*^9, {
   3.81690681059914*^9, 3.8169068368429813`*^9}, {3.8208063901537895`*^9, 
   3.820806402244675*^9}, 3.820806503673809*^9, {3.827874604494393*^9, 
   3.8278746309413214`*^9}, {3.8278748592560916`*^9, 3.8278748863590775`*^9}, 
   3.82828663244518*^9, 3.8482570386232243`*^9, {3.8482570745991116`*^9, 
   3.848257085752733*^9}, 3.8547617638536158`*^9, {3.854761829152297*^9, 
   3.854761851225196*^9}, {3.883168591785688*^9, 3.883168637915431*^9}, 
   3.9565290755867867`*^9, {3.9565292024699354`*^9, 3.9565292106242757`*^9}, 
   3.956560385743496*^9, 3.9565604362003746`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"adpConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"ArgDensityPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.6"}], "-", 
       RowBox[{"3.7", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3.8"}], "-", 
       RowBox[{"3.2", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "0.2"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "25"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.732482892728856*^9, 3.7324829563457675`*^9}, {
   3.7324830851923943`*^9, 3.7324830882811995`*^9}, {3.732483262424306*^9, 
   3.732483272377123*^9}, 3.7326584415195208`*^9, {3.7326584750439796`*^9, 
   3.7326584764479823`*^9}, 3.732658701981179*^9, {3.732658872349078*^9, 
   3.732658872567479*^9}, 3.7326592186228867`*^9, 3.7326593083866453`*^9, 
   3.7326626660310535`*^9, {3.740218157446906*^9, 3.740218181533348*^9}, 
   3.7402182257126255`*^9, 3.7402183634452677`*^9, {3.740218493186303*^9, 
   3.7402184934047036`*^9}, 3.740218637580157*^9, {3.7402186807610326`*^9, 
   3.7402186901834493`*^9}, 3.740219272556873*^9, 3.7406235115861425`*^9, {
   3.740778603524059*^9, 3.740778607080865*^9}, {3.740778656564152*^9, 
   3.740778658529755*^9}, {3.740778688559808*^9, 3.7407786898078103`*^9}, {
   3.7407792259843545`*^9, 3.7407792441895866`*^9}, {3.7407793822810287`*^9, 
   3.740779417427891*^9}, {3.7407794646959734`*^9, 3.7407794857872105`*^9}, 
   3.740780774189475*^9, 3.7407824622407703`*^9, {3.740783008707331*^9, 
   3.7407830693134375`*^9}, 3.7407921769832563`*^9, 3.740795739929125*^9, 
   3.740795830549684*^9, {3.741114053755069*^9, 3.741114056173073*^9}, 
   3.741114177042085*^9, {3.741114217851757*^9, 3.7411142179765573`*^9}, 
   3.741114298004698*^9, 3.7411143910588613`*^9, {3.7411144222121162`*^9, 
   3.741114422383716*^9}, 3.7411667475274568`*^9, 3.741166782284318*^9, 
   3.741202200838129*^9, 3.7418928330565205`*^9, 3.744663694463605*^9, 
   3.7446641788132553`*^9, 3.7446656127845235`*^9, 3.7446656519405923`*^9, 
   3.744742916766701*^9, 3.7447489900885725`*^9, 3.745212714450224*^9, {
   3.7452134334710865`*^9, 3.745213472377555*^9}, {3.74521352657205*^9, 
   3.7452135499564915`*^9}, {3.745213645116658*^9, 3.74521367446031*^9}, 
   3.7452137501360426`*^9, 3.745215372484893*^9, 3.745215403544547*^9, {
   3.745215676563428*^9, 3.745215676657028*^9}, {3.745215841159317*^9, 
   3.7452158501293325`*^9}, 3.745220796377221*^9, 3.746051992891122*^9, {
   3.7460525179568443`*^9, 3.746052527363661*^9}, {3.7460525613717203`*^9, 
   3.7460526080470023`*^9}, {3.746052647827072*^9, 3.746052665392703*^9}, 
   3.7460527306476173`*^9, {3.7460534548348923`*^9, 3.746053478047733*^9}, {
   3.7460536390400157`*^9, 3.7460536607708535`*^9}, {3.7460537995066986`*^9, 
   3.7460538460103807`*^9}, 3.746054532895187*^9, 3.7460546210509415`*^9, {
   3.746055005030016*^9, 3.7460550460736885`*^9}, 3.7460615185886574`*^9, {
   3.746069839136873*^9, 3.7460698629425144`*^9}, {3.746073417607147*^9, 
   3.7460734321307726`*^9}, 3.7460741921641073`*^9, 3.7469916409491673`*^9, {
   3.7469955617292557`*^9, 3.746995578218485*^9}, 3.7469956382941904`*^9, {
   3.7469959147934766`*^9, 3.746995920768287*^9}, {3.7469959729191785`*^9, 
   3.746995986631603*^9}, 3.746998736928876*^9, 3.746999808962759*^9, 
   3.747000762809235*^9, {3.7470280162427063`*^9, 3.7470280188011107`*^9}, 
   3.7481111741597233`*^9, 3.74811125768227*^9, {3.7481113758212776`*^9, 
   3.748111454039815*^9}, 3.7481116828922167`*^9, 3.74811178123479*^9, 
   3.7481120097751913`*^9, 3.7481126483779125`*^9, 3.7481127678585224`*^9, 
   3.7481129482884398`*^9, 3.748113174738437*^9, {3.748114852964586*^9, 
   3.7481148546805887`*^9}, 3.7481523715885305`*^9, 3.748156676743692*^9, 
   3.7496684226178694`*^9, 3.7507168950182934`*^9, 3.7507174232196207`*^9, 
   3.7507179880698137`*^9, 3.7507180637455463`*^9, {3.750718172664938*^9, 
   3.7507181919309716`*^9}, {3.750718281381529*^9, 3.7507183044383693`*^9}, {
   3.7507198773499327`*^9, 3.7507198774903326`*^9}, 3.750720697925374*^9, 
   3.7507439988761096`*^9, {3.750744109105903*^9, 3.7507441115707073`*^9}, 
   3.75090826960221*^9, 3.750908324873107*^9, 3.750911281940936*^9, 
   3.7509118911532063`*^9, 3.7509120959347663`*^9, {3.750923612368995*^9, 
   3.750923612524996*^9}, {3.7509248608167896`*^9, 3.750924875777216*^9}, {
   3.7509256243805313`*^9, 3.750925624567732*^9}, 3.7513499450613174`*^9, 
   3.751350024902258*^9, 3.751350205378975*^9, {3.7513571187651176`*^9, 
   3.751357119545119*^9}, 3.751357214526087*^9, {3.7513577496226263`*^9, 
   3.7513577498410273`*^9}, {3.751405366281531*^9, 3.751405378480752*^9}, {
   3.7514055458066463`*^9, 3.751405557849867*^9}, {3.751405638626809*^9, 
   3.7514056388764095`*^9}, 3.755049981945558*^9, 3.755050081707733*^9, 
   3.7550501621258745`*^9, {3.755050400759494*^9, 3.7550504035050983`*^9}, 
   3.7550509310980253`*^9, {3.7550512422873716`*^9, 3.7550512668106146`*^9}, {
   3.755051312409495*^9, 3.755051312877496*^9}, {3.755051771595695*^9, 
   3.755051771751695*^9}, {3.7550518885491004`*^9, 3.7550519085639353`*^9}, 
   3.7551379658536453`*^9, {3.755138016132534*^9, 3.755138075287838*^9}, {
   3.7551381761264153`*^9, 3.755138212599279*^9}, {3.75513827588859*^9, 
   3.755138303656639*^9}, {3.7551383744339633`*^9, 3.7551383747147636`*^9}, {
   3.755138574254714*^9, 3.75513859464395*^9}, 3.755138673611289*^9, {
   3.755139946626726*^9, 3.7551399654559593`*^9}, {3.7551413576185923`*^9, 
   3.755141379583431*^9}, 3.7551422855775647`*^9, {3.7551424248350105`*^9, 
   3.7551424403258376`*^9}, 3.7551475815781126`*^9, 3.7552236306473618`*^9, 
   3.7552237351007524`*^9, 3.7552257200630403`*^9, {3.755227559021696*^9, 
   3.755227559177696*^9}, {3.755227954092391*^9, 3.7552279570407963`*^9}, 
   3.7642903613991814`*^9, {3.7642905329386835`*^9, 3.7642905870551786`*^9}, 
   3.7642906182396336`*^9, {3.764290672449729*^9, 3.7642906894693584`*^9}, 
   3.764290721075014*^9, {3.76429075314867*^9, 3.764290753289071*^9}, {
   3.7642908794620924`*^9, 3.7642908959981213`*^9}, 3.764291593614951*^9, 
   3.76429466703955*^9, 3.7643042218683386`*^9, 3.764315617343957*^9, 
   3.76431783317605*^9, 3.7643199388461533`*^9, 3.7643853579378877`*^9, 
   3.764664382553267*^9, 3.7646644254065423`*^9, {3.7646670199227085`*^9, 
   3.7646670350235357`*^9}, {3.7646689626829224`*^9, 3.7646689628545227`*^9}, 
   3.764887973228504*^9, 3.764888008734166*^9, 3.7648888932053223`*^9, {
   3.7648903774637313`*^9, 3.764890377635331*^9}, 3.7648904488962564`*^9, 
   3.764890628343372*^9, {3.7648920077004867`*^9, 3.764892008121687*^9}, 
   3.764892076278207*^9, {3.7649026437276335`*^9, 3.7649026438212337`*^9}, 
   3.76506077650143*^9, 3.765170874625887*^9, 3.7651709275099792`*^9, 
   3.7651715756087255`*^9, 3.765171666619285*^9, 3.7651717371314087`*^9, 
   3.765171875909253*^9, 3.7652588601167355`*^9, 3.7652589118932266`*^9, {
   3.765267833767707*^9, 3.7652678340173073`*^9}, 3.766219677016867*^9, 
   3.766219733629367*^9, 3.7662201958113785`*^9, {3.7662231334417396`*^9, 
   3.7662231361717443`*^9}, 3.7662232485855417`*^9, {3.766426144952866*^9, 
   3.766426157042887*^9}, {3.76647719987669*^9, 3.7664772214515276`*^9}, {
   3.7664774867767935`*^9, 3.7664775002396173`*^9}, {3.7688458990076995`*^9, 
   3.7688459132037244`*^9}, 3.7688464394654493`*^9, 3.7688469041774664`*^9, 
   3.791925257427122*^9, 3.791925346562312*^9, {3.791925415077385*^9, 
   3.791925432292034*^9}, {3.79192558767724*^9, 3.7919255902703776`*^9}, {
   3.7919257453302054`*^9, 3.791925757202401*^9}, {3.791925937519228*^9, 
   3.7919259408152847`*^9}, {3.7919259926311307`*^9, 3.791925997395666*^9}, 
   3.791926263855747*^9, {3.7919264890844517`*^9, 3.791926490037352*^9}, 
   3.791927284210745*^9, 3.7919411532580585`*^9, 3.791941223803928*^9, {
   3.7919415060341063`*^9, 3.7919415061903205`*^9}, 3.7919455800307994`*^9, 
   3.7919456362986813`*^9, {3.791945689832918*^9, 3.7919457217551537`*^9}, 
   3.7919460775336857`*^9, 3.7919462165008616`*^9, {3.7919462528203726`*^9, 
   3.7919462530703335`*^9}, 3.7921427775170593`*^9, 3.7921428783057747`*^9, {
   3.792143003807266*^9, 3.7921430251928267`*^9}, 3.792143064074258*^9, {
   3.7921431277154303`*^9, 3.792143128543357*^9}, {3.7921434609849415`*^9, 
   3.79214346590565*^9}, 3.7921449885797224`*^9, 3.792145025274151*^9, {
   3.7921450954762783`*^9, 3.7921451181897235`*^9}, {3.7921455056604123`*^9, 
   3.7921455095657372`*^9}, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, 
   3.7922067460150957`*^9, 3.7922068475379333`*^9, {3.792207866280402*^9, 
   3.792207873684909*^9}, {3.792270597728077*^9, 3.792270597728077*^9}, {
   3.792270895657544*^9, 3.792270895782504*^9}, {3.792271368045697*^9, 
   3.7922713738255787`*^9}, {3.7922722199672675`*^9, 3.792272227824782*^9}, 
   3.792538656565729*^9, 3.792538924313737*^9, {3.792538977710556*^9, 
   3.7925389876925745`*^9}, 3.792539078730129*^9, 3.7925391498539133`*^9, {
   3.7925532490372567`*^9, 3.792553269157399*^9}, {3.7925536620956464`*^9, 
   3.792553667672454*^9}, 3.7925537022735977`*^9, {3.792553890557179*^9, 
   3.7925538937751665`*^9}, {3.7925546404577494`*^9, 3.7925546465187893`*^9}, 
   3.7925547575953875`*^9, 3.7926551481604743`*^9, 3.802546774584007*^9, 
   3.802546806014125*^9, {3.8025471515108232`*^9, 3.802547153432208*^9}, {
   3.8025530095393133`*^9, 3.802553026457199*^9}, {3.8025532045714674`*^9, 
   3.802553229409363*^9}, 3.802553261038468*^9, 3.802553454664689*^9, {
   3.8025798431792006`*^9, 3.8025798457723475`*^9}, {3.8025800272037663`*^9, 
   3.802580027344387*^9}, {3.802582660552966*^9, 3.8025826638022027`*^9}, 
   3.8078545445533037`*^9, 3.8078546876419163`*^9, {3.807854721465523*^9, 
   3.8078547489939494`*^9}, 3.8078547791373887`*^9, {3.807855042242198*^9, 
   3.8078550464639173`*^9}, 3.816906024932904*^9, 3.816906211796054*^9, {
   3.8169062938236933`*^9, 3.816906310679119*^9}, 3.8169063942376285`*^9, 
   3.8169064881374598`*^9, 3.816906605547397*^9, {3.81690722223795*^9, 
   3.81690722739299*^9}, {3.816911790459921*^9, 3.816911790662994*^9}, {
   3.8208065113126163`*^9, 3.820806513952616*^9}, 3.8208066006040044`*^9, {
   3.8208066387668133`*^9, 3.820806640141487*^9}, {3.8208067180917654`*^9, 
   3.82080671859165*^9}, {3.8208068079142385`*^9, 3.820806816990216*^9}, 
   3.820807138147498*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.828286123457013*^9, {3.8282861747106113`*^9, 3.8282861989236813`*^9}, {
   3.828286440365247*^9, 3.8282864529248*^9}, {3.828553556846962*^9, 
   3.828553562587772*^9}, {3.828557128894436*^9, 3.8285571389096537`*^9}, {
   3.8285573314607916`*^9, 3.8285573321159925`*^9}, 3.828557376529271*^9, {
   3.8286360368995934`*^9, 3.828636050206417*^9}, 3.8286362099974976`*^9, 
   3.8286376533312335`*^9, 3.828718698781597*^9, {3.848257038638844*^9, 
   3.848257038638844*^9}, {3.8482571592822495`*^9, 3.8482571791525536`*^9}, 
   3.8482592259343624`*^9, {3.848259521700473*^9, 3.8482595244186172`*^9}, 
   3.848259575968937*^9, {3.848259744967764*^9, 3.848259748545044*^9}, {
   3.848259837688095*^9, 3.848259841812119*^9}, 3.848260108181464*^9, {
   3.8547617638692365`*^9, 3.8547617638848314`*^9}, 3.854761804515937*^9, 
   3.854761915152796*^9, {3.854762106815795*^9, 3.854762106987621*^9}, {
   3.8547621715706553`*^9, 3.854762191347271*^9}, {3.854762692983657*^9, 
   3.8547626933116884`*^9}, 3.8549110693034267`*^9, 3.883168548842718*^9, 
   3.883168591801283*^9, {3.8831693422177663`*^9, 3.883169342373979*^9}, 
   3.883170089065553*^9, {3.9565290756024103`*^9, 3.9565290756024103`*^9}, 
   3.956529277905364*^9, {3.9565293329237075`*^9, 3.956529358527069*^9}, 
   3.956529465626936*^9, {3.95652968441055*^9, 3.956529687425434*^9}, 
   3.956530150357442*^9, 3.956530343390212*^9, 3.9565304268131027`*^9, 
   3.956541558143319*^9, 3.956560381760056*^9, {3.9565604913281097`*^9, 
   3.956560505887143*^9}, {3.9565608360761228`*^9, 3.956560839950215*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0240.png\>\"", ",", "adpConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955159803033*^9, 3.5339552034519095`*^9, 3.547008893618438*^9, 
   3.547008956314948*^9, {3.5501987477128153`*^9, 3.5501987478844156`*^9}, 
   3.5501988226865473`*^9, {3.550469306627704*^9, 3.5504693067681046`*^9}, 
   3.553114272723911*^9, 3.553114315530386*^9, 3.553114569972433*^9, 
   3.55318508843264*^9, {3.553185247131719*^9, 3.5531852473969193`*^9}, 
   3.5531900821741323`*^9, 3.55319015471426*^9, 3.5531908900479517`*^9, 
   3.5531909541796646`*^9, {3.553213790019997*^9, 3.5532138179752464`*^9}, {
   3.553214122440981*^9, 3.5532141511450315`*^9}, {3.556389578501213*^9, 
   3.556389578672813*^9}, 3.5563898772885375`*^9, {3.7325812073847427`*^9, 
   3.7325812080243435`*^9}, 3.7326535267504864`*^9, {3.732659119968313*^9, 
   3.732659120171114*^9}, {3.7326593137530546`*^9, 3.7326593214438686`*^9}, 
   3.740216750953225*^9, 3.740218228489431*^9, 3.740218990196377*^9, 
   3.74077860982647*^9, {3.740780605007178*^9, 3.7407806051787777`*^9}, 
   3.7407823021064887`*^9, {3.740795700305055*^9, 3.740795700539056*^9}, 
   3.7407957379479213`*^9, 3.7411140595270786`*^9, {3.7411141143767753`*^9, 
   3.741114114532776*^9}, 3.7411667457334538`*^9, {3.7411668447156277`*^9, 
   3.741166844871628*^9}, 3.74142115986131*^9, 3.744663700313615*^9, 
   3.744664379024007*^9, 3.7446656127845235`*^9, {3.7446659116810484`*^9, 
   3.744665911868249*^9}, 3.7452127175858293`*^9, {3.74521278093754*^9, 
   3.7452127811247406`*^9}, 3.7452152075218024`*^9, 3.7452154016881437`*^9, 
   3.7460519949503255`*^9, {3.7460520308459883`*^9, 3.74605203162599*^9}, 
   3.746055107834197*^9, 3.746991475479677*^9, {3.746991513918144*^9, 
   3.7469915424973946`*^9}, 3.746991645816376*^9, 3.748111177404529*^9, {
   3.748111322703184*^9, 3.748111322999585*^9}, 3.748112646147109*^9, {
   3.748113203645288*^9, 3.748113203988488*^9}, {3.7507167757248836`*^9, 
   3.7507167790164895`*^9}, 3.750716899963502*^9, {3.750907902190365*^9, 
   3.7509079301456137`*^9}, 3.75090826960221*^9, 3.751350024902258*^9, 
   3.7513500920135756`*^9, {3.7513503300387936`*^9, 3.751350330210394*^9}, 
   3.751400149651678*^9, {3.755049707478676*^9, 3.755049707634676*^9}, {
   3.755049765697978*^9, 3.75504976657158*^9}, 3.755049981945558*^9, 
   3.762283545821921*^9, 3.7622835936204047`*^9, 3.762283681510959*^9, 
   3.764280933902177*^9, 3.7642809906238766`*^9, {3.764281052961586*^9, 
   3.7642810835844398`*^9}, 3.7642811989934425`*^9, 3.764281290331603*^9, 
   3.764291454634307*^9, 3.7642915558472843`*^9, 3.7646644254065423`*^9, {
   3.7646645227819133`*^9, 3.7646645229067135`*^9}, {3.7648873755758543`*^9, 
   3.7648873757318544`*^9}, 3.764887973244104*^9, 3.7648894055102224`*^9, 
   3.765060231344472*^9, 3.765060779434235*^9, 3.7650876619491696`*^9, {
   3.7651708015085583`*^9, 3.7651708016333585`*^9}, 3.7651708746414866`*^9, 
   3.7652589118932266`*^9, {3.7652590299074335`*^9, 3.7652590301102343`*^9}, {
   3.7662195543382516`*^9, 3.766219578331094*^9}, 3.766219677016867*^9, 
   3.7662201983853827`*^9, 3.76647719987669*^9, 3.7664773392785344`*^9, 
   3.7664774867767935`*^9, 3.766477573559746*^9, 3.7666119106500444`*^9, {
   3.767393914938072*^9, 3.7673939150940723`*^9}, 3.7688458990076995`*^9, 
   3.768845992124263*^9, {3.7688460972060475`*^9, 3.768846097424448*^9}, 
   3.791925257442734*^9, {3.791926042673618*^9, 3.7919260678864145`*^9}, 
   3.7919411511491823`*^9, 3.7919412536874685`*^9, 3.7919455822489567`*^9, 
   3.791945613460332*^9, 3.7921427775327096`*^9, {3.7921442341379757`*^9, 
   3.7921442343566737`*^9}, 3.79214499129782*^9, {3.7921450432386465`*^9, 
   3.7921450433948555`*^9}, 3.7922066272150636`*^9, {3.7922081370131783`*^9, 
   3.7922081377629976`*^9}, 3.792270597728077*^9, {3.7922707124977846`*^9, 
   3.7922707126696568`*^9}, 3.792538656565729*^9, 3.792554019510995*^9, 
   3.802546808544753*^9, {3.8025468814650974`*^9, 3.802546882324236*^9}, 
   3.8025469199403934`*^9, 3.8025516303411865`*^9, {3.8025798413202734`*^9, 
   3.8025798500994525`*^9}, {3.80785445090362*^9, 3.8078544763037367`*^9}, 
   3.8078545477278557`*^9, 3.8169060294318476`*^9, 3.816906816785185*^9, 
   3.816906856635206*^9, 3.820806416772484*^9, 3.820806449655319*^9, 
   3.820806517936056*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.8278748592717104`*^9, 3.8278748912173123`*^9, 3.828286639443576*^9, 
   3.848257038638844*^9, 3.848257074614698*^9, 3.848257111481027*^9, 
   3.854761763900452*^9, {3.8547618323859158`*^9, 3.854761855958494*^9}, {
   3.883168591801283*^9, 3.88316864422643*^9}, 3.9565290756180315`*^9, {
   3.9565292024855556`*^9, 3.9565292145296135`*^9}, 3.9565603751522007`*^9, 
   3.956560441292962*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"rp3dConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"RePlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.6"}], "-", 
       RowBox[{"3.7", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3.8"}], "-", 
       RowBox[{"3.2", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0.02", ",", "0.02"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "8"}], ",", "2"}], "}"}], ",", "28"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221349871864`*^9}, {3.533956562109496*^9, 3.533956663650075*^9}, 
   3.5339567557838364`*^9, 3.5347099882825756`*^9, 3.5347102657482634`*^9, {
   3.5347103008951254`*^9, 3.5347103043427315`*^9}, {3.535593994727907*^9, 
   3.535594052120408*^9}, {3.535594118654525*^9, 3.535594142257366*^9}, {
   3.53559417306742*^9, 3.5355941818346357`*^9}, {3.535594253173561*^9, 
   3.535594273141596*^9}, {3.535594308943659*^9, 3.535594311580064*^9}, {
   3.5355943417349167`*^9, 3.5355943446677217`*^9}, 3.5355944944279847`*^9, 
   3.5364644113098073`*^9, 3.547008961306957*^9, 3.547009174886932*^9, 
   3.5470100939009466`*^9, 3.5470101792522974`*^9, {3.547010219671968*^9, 
   3.5470102336495924`*^9}, {3.547010378308647*^9, 3.5470103791978483`*^9}, {
   3.5470106361019*^9, 3.547010661077544*^9}, 3.5501988290669584`*^9, 
   3.550199059994164*^9, 3.550199923226681*^9, {3.5501999833959866`*^9, 
   3.5501999880135946`*^9}, 3.5502073242848244`*^9, 3.5502076305611625`*^9, 
   3.5502077527405767`*^9, 3.550207824360303*^9, {3.5502086208227015`*^9, 
   3.5502086232251062`*^9}, 3.5502087333612995`*^9, {3.550210050393613*^9, 
   3.5502100620780334`*^9}, 3.5503471093742733`*^9, {3.5508011543922625`*^9, 
   3.5508011573094673`*^9}, 3.550801274574874*^9, 3.550828826075177*^9, 
   3.5531145222051487`*^9, 3.5531145764308443`*^9, 3.5531151448958426`*^9, {
   3.553115181758707*^9, 3.5531152194327736`*^9}, 3.5531152549228363`*^9, {
   3.553115444209176*^9, 3.5531154457847786`*^9}, 3.5531154834276447`*^9, 
   3.553184120965741*^9, 3.5531844553835287`*^9, 3.5531849288443604`*^9, {
   3.5531850323193417`*^9, 3.553185039214554*^9}, {3.5534455197643785`*^9, 
   3.5534455226191835`*^9}, {3.564290330151406*^9, 3.564290330151406*^9}, {
   3.564291249632621*^9, 3.5642913088503246`*^9}, {3.5642913587860126`*^9, 
   3.5642913874744625`*^9}, 3.5645701739454827`*^9, 3.56457022934118*^9, {
   3.5645704548083763`*^9, 3.564570523245696*^9}, 3.564632298359475*^9, 
   3.5672835710783267`*^9, 3.5672836098287945`*^9, 3.5672836500924654`*^9, 
   3.5672837096845703`*^9, {3.5672837599322586`*^9, 3.567283785797104*^9}, {
   3.567283815998757*^9, 3.567283882470474*^9}, 3.5672839294421563`*^9, 
   3.567283963200616*^9, 3.567749299701456*^9, 3.567802782394025*^9, 
   3.5678028822498007`*^9, {3.5681600327494287`*^9, 3.5681600592382755`*^9}, {
   3.568160109142763*^9, 3.5681601122315683`*^9}, 3.5681601467388287`*^9, {
   3.568160184319295*^9, 3.56816020424053*^9}, {3.568160517132702*^9, 
   3.568160596162441*^9}, 3.5681606610273547`*^9, {3.568160946421071*^9, 
   3.568160966030306*^9}, {3.5681705219146996`*^9, 3.5681705242703037`*^9}, 
   3.5681941899017687`*^9, 3.568194240352257*^9, 3.5700755677715073`*^9, 
   3.570075613354788*^9, 3.5700766540950155`*^9, {3.570086887572139*^9, 
   3.5700868877641497`*^9}, {3.570087003107747*^9, 3.570087005763899*^9}, {
   3.570087078020032*^9, 3.5700870989962316`*^9}, 3.5700872221102734`*^9, {
   3.57009623935571*^9, 3.570096282536586*^9}, 3.5736048119306808`*^9, 
   3.5736048904456186`*^9, 3.573604940833707*^9, {3.573605077677148*^9, 
   3.573605125865632*^9}, {3.5736051592964907`*^9, 3.573605161948496*^9}, {
   3.573605211119782*^9, 3.5736052136937866`*^9}, {3.5736052478578463`*^9, 
   3.5736052497922497`*^9}, 3.5736058726857443`*^9, 3.573605926771039*^9, {
   3.573605956925892*^9, 3.5736059886719475`*^9}, 3.573606090758527*^9, {
   3.5736061269973907`*^9, 3.57360615517104*^9}, {3.5736066713897743`*^9, 
   3.573606699345023*^9}, 3.573615836289501*^9, 3.57361605569005*^9, 
   3.5736161124242954`*^9, {3.5736161436740828`*^9, 3.5736161737138004`*^9}, 
   3.5736162263498116`*^9, {3.5736162577736087`*^9, 3.573616267602171*^9}, {
   3.573616444274276*^9, 3.5736164466824136`*^9}, {3.574885927166521*^9, 
   3.5748859637953854`*^9}, {3.5748860508435383`*^9, 
   3.5748860521695404`*^9}, {3.5748861157240524`*^9, 3.574886117252855*^9}, 
   3.57577235924708*^9, 3.5757724099589806`*^9, 3.575772445279001*^9, {
   3.5757724785189023`*^9, 3.5757724925687056`*^9}, {3.575772607702291*^9, 
   3.575772651454794*^9}, {3.5759741600893764`*^9, 3.575974161493379*^9}, {
   3.575974199510646*^9, 3.5759742220370855`*^9}, 3.576873240797937*^9, {
   3.5768733189384737`*^9, 3.576873344428919*^9}, {3.576873425346261*^9, 
   3.5768734529895096`*^9}, {3.576873485281566*^9, 3.5768734895091734`*^9}, {
   3.576873525514037*^9, 3.576873525701237*^9}, {3.577055332882147*^9, 
   3.5770553361425524`*^9}, 3.577871528638734*^9, {3.5778716843606405`*^9, 
   3.577871704824811*^9}, 3.5778717538886175`*^9, {3.5778718288889074`*^9, 
   3.577871876976658*^9}, {3.5778719113366227`*^9, 3.577871931008748*^9}, 
   3.577996382595691*^9, 3.5779973953859024`*^9, 3.577997497659682*^9, {
   3.592182738830336*^9, 3.592182738830336*^9}, 3.592182940881891*^9, 
   3.592183011815215*^9, {3.5921894364524994`*^9, 3.592189460086541*^9}, {
   3.592189491785797*^9, 3.592189494235001*^9}, {3.5921895481018953`*^9, 
   3.592189608177601*^9}, 3.592189794161128*^9, 3.5921898423808126`*^9, 
   3.5993883891423397`*^9, {3.5993886376195765`*^9, 3.5993886707696347`*^9}, 
   3.5993887338093452`*^9, 3.599388787067839*^9, 3.5993898053488283`*^9, 
   3.599450646030573*^9, 3.6063523737093935`*^9, {3.6063536327884064`*^9, 
   3.606353657155649*^9}, {3.6063536884961042`*^9, 3.606353715281351*^9}, {
   3.6063541082884493`*^9, 3.606354110690853*^9}, {3.606354174463765*^9, 
   3.6063541934333982`*^9}, 3.606354233681469*^9, {3.606354327624834*^9, 
   3.6063543393872547`*^9}, {3.6063554596717415`*^9, 3.606355469234558*^9}, {
   3.6063556589152913`*^9, 3.6063556888517437`*^9}, {3.6063559489462013`*^9, 
   3.60635597109824*^9}, {3.606356372177745*^9, 3.606356383128964*^9}, {
   3.6063564284002438`*^9, 3.606356435435856*^9}, 3.606356488460349*^9, {
   3.606356550096057*^9, 3.606356592091331*^9}, 3.606362300175032*^9, 
   3.606364095238985*^9, 3.6063646120054927`*^9, {3.606424049973319*^9, 
   3.606424053639326*^9}, 3.6064240927485943`*^9, 3.6064350337292786`*^9, 
   3.6253066892819157`*^9, 3.625306727517583*^9, {3.6253071403575087`*^9, 
   3.625307143961115*^9}, 3.6253071830235834`*^9, 3.625307214270438*^9, 
   3.62530768864248*^9, {3.625307721074937*^9, 3.6253077378137665`*^9}, {
   3.6253078152835026`*^9, 3.625307818465908*^9}, 3.6253078603831816`*^9, 
   3.625308042795102*^9, {3.625308091591988*^9, 3.6253080991112013`*^9}, {
   3.625383389886337*^9, 3.625383390822338*^9}, 3.6253834238787966`*^9, 
   3.6291871861181545`*^9, 3.629187255195076*^9, {3.629187298329152*^9, 
   3.629187319170789*^9}, 3.629187721281896*^9, {3.629187761576767*^9, 
   3.629187773105187*^9}, 3.629187853476528*^9, {3.629189386050821*^9, 
   3.6291893870960226`*^9}, 3.6294129792897773`*^9, {3.629681940821416*^9, 
   3.629681967825063*^9}, 3.6296830652981987`*^9, {3.629683828638739*^9, 
   3.629683873535618*^9}, 3.6296840724983673`*^9, 3.629684659074998*^9, {
   3.6296848918274064`*^9, 3.629684894619811*^9}, 3.630130105717137*^9, 
   3.6301868115768538`*^9, 3.6301913486360464`*^9, {3.6301914399118066`*^9, 
   3.630191440754208*^9}, {3.6301915173347425`*^9, 3.630191517662343*^9}, {
   3.630191564462425*^9, 3.6301915646184254`*^9}, 3.6301916235085287`*^9, 
   3.6301916648486013`*^9, {3.6301916949722548`*^9, 3.630191743254339*^9}, 
   3.630192498482866*^9, 3.630224013755659*^9, 3.6325489583565407`*^9, 
   3.6325493465892234`*^9, 3.6325495969920783`*^9, 3.6325497909544272`*^9, {
   3.6325499065150375`*^9, 3.6325499323798833`*^9}, {3.6326039905906425`*^9, 
   3.6326039969398537`*^9}, {3.6326052476784515`*^9, 3.6326052678180866`*^9}, 
   3.632789691264064*^9, {3.632789738937748*^9, 3.632789739811349*^9}, {
   3.632789771198604*^9, 3.63278978590943*^9}, 3.632789880617196*^9, 
   3.6327899977890024`*^9, 3.63279813902344*^9, 3.632798262731657*^9, 
   3.632807713384465*^9, 3.6328077532581353`*^9, {3.632813931449418*^9, 
   3.6328140063139496`*^9}, {3.632814038262806*^9, 3.632814038481206*^9}, {
   3.6328142150367174`*^9, 3.632814235581953*^9}, {3.632862829136717*^9, 
   3.6328628333643246`*^9}, 3.632863060297923*^9, 3.6328903848425245`*^9, 
   3.6345039605706234`*^9, 3.6345039979950895`*^9, 3.634505028388706*^9, {
   3.634505073659986*^9, 3.634505094844823*^9}, {3.6345051346835*^9, 
   3.6345051909059987`*^9}, {3.634505248002099*^9, 3.6345052831177607`*^9}, 
   3.6345058717026*^9, {3.6345559035261827`*^9, 3.6345559061157875`*^9}, {
   3.634555945349856*^9, 3.634555948313861*^9}, 3.634556202246708*^9, {
   3.6360748453404164`*^9, 3.6360748476336203`*^9}, 3.636075402244196*^9, 
   3.6360755387756352`*^9, 3.6360756646834564`*^9, 3.636076028008095*^9, 
   3.6360760583769555`*^9, {3.6360761965931983`*^9, 3.6360762071856165`*^9}, 
   3.6364953485684733`*^9, 3.6364953884889436`*^9, 3.636495515816367*^9, 
   3.6364955598396444`*^9, 3.63649577777445*^9, {3.6364958118137093`*^9, 
   3.636495860766596*^9}, 3.636495993039228*^9, 3.636496147385899*^9, {
   3.636496214996418*^9, 3.636496253372485*^9}, 3.6364964311815977`*^9, {
   3.6364969697417445`*^9, 3.6364969814261646`*^9}, {3.636762383421364*^9, 
   3.6367623872745705`*^9}, 3.725592441562623*^9, 3.7255925278151746`*^9, 
   3.7255944795378036`*^9, {3.72559451145546*^9, 3.7255945146846657`*^9}, 
   3.7255953568521447`*^9, 3.725595801020926*^9, 3.725595862875035*^9, 
   3.725596145750332*^9, 3.72559634416708*^9, 3.7255964017623816`*^9, {
   3.725600882543482*^9, 3.725600909469129*^9}, 3.725601380552758*^9, 
   3.725771260842998*^9, {3.725774253989055*^9, 3.725774282505905*^9}, {
   3.725774385294486*^9, 3.725774424243362*^9}, {3.7257804563043575`*^9, 
   3.7257804693615804`*^9}, 3.7258490252477674`*^9, 3.7258521016447725`*^9, 
   3.725852258877449*^9, 3.725852363803233*^9, 3.7258524000108967`*^9, 
   3.725852749623111*^9, {3.7258530098159676`*^9, 3.7258530484884357`*^9}, {
   3.7258533935578427`*^9, 3.7258534235566955`*^9}, {3.725853537717696*^9, 
   3.725853546578511*^9}, 3.726913461460272*^9, {3.7269135067003517`*^9, 
   3.726913506715952*^9}, 3.726913573655669*^9, 3.7269142247852125`*^9, {
   3.726914355279442*^9, 3.726914372969873*^9}, 3.7269144359471836`*^9, 
   3.7269145160221243`*^9, 3.726914654581568*^9, 3.726914723206088*^9, {
   3.7269151216475897`*^9, 3.726915129884404*^9}, 3.726915517287485*^9, {
   3.726942972603111*^9, 3.7269429731335115`*^9}, 3.726952629442474*^9, 
   3.7269527024818025`*^9, {3.7325814358471437`*^9, 3.732581510446475*^9}, 
   3.7325815475277395`*^9, {3.7326584462775297`*^9, 3.732658472844376*^9}, {
   3.732658943126403*^9, 3.732658966682444*^9}, 3.7326593293998823`*^9, 
   3.732668442777998*^9, {3.7402181611597123`*^9, 3.740218186072956*^9}, 
   3.740218232124237*^9, {3.7402183905893154`*^9, 3.7402183918841176`*^9}, 
   3.740218439771809*^9, 3.7402184717362657`*^9, {3.740218744752345*^9, 
   3.740218755048363*^9}, {3.7402188877977967`*^9, 3.740218953427112*^9}, {
   3.7402206710333304`*^9, 3.740220709690198*^9}, 3.740623517482953*^9, {
   3.740778612338074*^9, 3.740778614194477*^9}, {3.740778697514224*^9, 
   3.740778713769452*^9}, {3.7407792507571983`*^9, 3.740779281707652*^9}, {
   3.7407793154973116`*^9, 3.7407793317681403`*^9}, {3.74077962170185*^9, 
   3.740779646209493*^9}, 3.7407805331690516`*^9, 3.7407805721691203`*^9, 
   3.7407807771378803`*^9, 3.7407824673731785`*^9, 3.740784298882004*^9, 
   3.740784367336528*^9, 3.7407845511906676`*^9, 3.7407847911139035`*^9, 
   3.740785320891444*^9, {3.740792222878537*^9, 3.74079222451654*^9}, 
   3.740795734391115*^9, 3.7407958434197063`*^9, 3.7407962499408207`*^9, 
   3.740796287817687*^9, 3.7407968561734858`*^9, 3.7407968980127587`*^9, {
   3.7411140633022857`*^9, 3.741114065189889*^9}, 3.7411141817688937`*^9, {
   3.7411142451362047`*^9, 3.7411142815778685`*^9}, {3.7411143643984146`*^9, 
   3.741114394927668*^9}, 3.741114449028563*^9, 3.741165053951681*^9, 
   3.7411667429098487`*^9, 3.741166800005949*^9, 3.741167002587905*^9, 
   3.7418927044966946`*^9, 3.744663705024823*^9, 3.744664181730461*^9, 
   3.7446656128001237`*^9, 3.7446656519405923`*^9, 3.7447503917826357`*^9, 
   3.744875558139942*^9, 3.745212724418641*^9, 3.7452130520192165`*^9, 
   3.7452134415987005`*^9, {3.7452134772759633`*^9, 3.745213477884364*^9}, 
   3.745213581842947*^9, 3.745213760572461*^9, {3.7452137926617174`*^9, 
   3.7452138142521553`*^9}, {3.7452138718318567`*^9, 3.745213901846309*^9}, 
   3.74521397072043*^9, {3.7452140044788895`*^9, 3.745214017692113*^9}, {
   3.745215374934097*^9, 3.745215398848939*^9}, 3.745215733004327*^9, {
   3.745215869754167*^9, 3.74521587134537*^9}, {3.7452159052910295`*^9, 
   3.7452159092066364`*^9}, {3.745215982604765*^9, 3.7452159998115954`*^9}, 
   3.7452162565100465`*^9, 3.74605199750873*^9, {3.7460524917799983`*^9, 
   3.7460525007812138`*^9}, 3.7460544899795113`*^9, 3.74605461420253*^9, {
   3.746054731577136*^9, 3.746054777706417*^9}, {3.7460548234768972`*^9, 
   3.7460548417133293`*^9}, 3.746054911461052*^9, 3.7469916527895885`*^9, 
   3.746995583616094*^9, 3.7469956167661524`*^9, {3.7469957258615446`*^9, 
   3.7469957275151477`*^9}, {3.746995760977206*^9, 3.746995762147208*^9}, {
   3.7469958133464985`*^9, 3.746995836512539*^9}, 3.746995880816617*^9, {
   3.7469959276946993`*^9, 3.746995931984707*^9}, {3.7470008112785206`*^9, 
   3.7470008135717244`*^9}, {3.7470008798094406`*^9, 3.747000881369444*^9}, {
   3.747027563106309*^9, 3.74702756362111*^9}, {3.747028030906732*^9, 
   3.747028033511936*^9}, 3.7481111814917364`*^9, 3.7481112473238516`*^9, 
   3.748111472572647*^9, 3.748111511900316*^9, 3.748111751157937*^9, 
   3.7481117965072165`*^9, 3.748111837706889*^9, 3.7481119389198666`*^9, 
   3.748112002271578*^9, 3.7481126431207037`*^9, 3.7481127702141266`*^9, 
   3.748112890599538*^9, 3.748112975042486*^9, {3.748113023496172*^9, 
   3.748113025196574*^9}, 3.748113104850314*^9, 3.7481148783458304`*^9, 
   3.748152378124942*^9, 3.748156761576641*^9, 3.749668426627076*^9, 
   3.7507169093079185`*^9, {3.750717434654441*^9, 3.7507174520016713`*^9}, 
   3.7507179985374317`*^9, 3.7507180693303566`*^9, 3.750718107222823*^9, {
   3.750718237732652*^9, 3.7507182378574524`*^9}, 3.750718351924853*^9, {
   3.750719888347952*^9, 3.75071989302796*^9}, 3.75072066733372*^9, 
   3.750724214763152*^9, 3.7507255977531834`*^9, 3.7507440011381135`*^9, {
   3.7507441014618897`*^9, 3.7507441048314953`*^9}, 3.7511831548137474`*^9, 
   3.7511832008026285`*^9, {3.751189420749557*^9, 3.7511894221223593`*^9}, {
   3.751189545112975*^9, 3.7511895500581837`*^9}, {3.751191026389179*^9, 
   3.751191036263996*^9}, {3.7511922279880896`*^9, 3.75119225077973*^9}, {
   3.7512741081272516`*^9, 3.7512741083924522`*^9}, 3.751343680793913*^9, {
   3.7513437352380085`*^9, 3.751343748076831*^9}, {3.751343859991428*^9, 
   3.7513438704746466`*^9}, 3.751343972284826*^9, {3.751344206045637*^9, 
   3.751344228946477*^9}, {3.751345479654274*^9, 3.751345479669874*^9}, 
   3.7513458163340654`*^9, {3.7513459501355004`*^9, 3.751345950946702*^9}, 
   3.751346259250044*^9, {3.75134772036421*^9, 3.751347750955864*^9}, {
   3.7513478386904173`*^9, 3.7513478502656384`*^9}, {3.7513480264523478`*^9, 
   3.7513480387451687`*^9}, {3.751356659578311*^9, 3.7513566652723207`*^9}, {
   3.7513584868487215`*^9, 3.751358487051522*^9}, {3.7513587764620385`*^9, 
   3.7513587766960387`*^9}, 3.751359217521613*^9, 3.755049981961158*^9, 
   3.755050081910534*^9, 3.7550501621414747`*^9, {3.7550504076079054`*^9, 
   3.7550504105563107`*^9}, 3.755050934296031*^9, 3.7550519317455764`*^9, {
   3.7550519933656845`*^9, 3.7550521232671127`*^9}, 3.7550521578835735`*^9, 
   3.755061383808256*^9, 3.755137961376438*^9, {3.7551380194709396`*^9, 
   3.755138043448182*^9}, 3.7551380790006447`*^9, {3.755138180494423*^9, 
   3.7551382149704833`*^9}, 3.7551383199274673`*^9, {3.7551384479880924`*^9, 
   3.755138485646559*^9}, {3.7551385328522415`*^9, 3.755138535301446*^9}, {
   3.7551388552780085`*^9, 3.755138867898431*^9}, {3.755138899379286*^9, 
   3.755138900923689*^9}, {3.755141473017996*^9, 3.7551414735015965`*^9}, 
   3.7551423127060127`*^9, 3.755143428371771*^9, {3.7551475899709272`*^9, 
   3.7551475974589405`*^9}, {3.755147763630432*^9, 3.755147798215693*^9}, 
   3.7552236306629615`*^9, 3.7552237351007524`*^9, {3.7552274948275833`*^9, 
   3.7552275018475957`*^9}, 3.7642903579671755`*^9, {3.7642905351382875`*^9, 
   3.764290614448827*^9}, 3.764290670343725*^9, {3.7642907227754173`*^9, 
   3.7642907831007233`*^9}, {3.764290822865193*^9, 3.7642908322408094`*^9}, 
   3.7642909401461987`*^9, {3.76429097484066*^9, 3.764290976041862*^9}, 
   3.764291199136257*^9, {3.7642913149984617`*^9, 3.7642913174008656`*^9}, 
   3.7642916029593673`*^9, 3.764302351074251*^9, 3.7643023945203276`*^9, 
   3.764304227843149*^9, 3.7643178515372825`*^9, 3.76432045498466*^9, 
   3.764370158357931*^9, 3.7643729553032446`*^9, {3.764374606185746*^9, 
   3.764374606466547*^9}, 3.7643849800828085`*^9, 3.764385335676648*^9, {
   3.7646681230006466`*^9, 3.764668147102689*^9}, {3.764668200189582*^9, 
   3.764668201515584*^9}, {3.764668246396863*^9, 3.764668249766469*^9}, 
   3.764668283384528*^9, 3.7646685415805817`*^9, 3.764887973275304*^9, 
   3.764888009139767*^9, 3.7648889009273357`*^9, {3.764890388914151*^9, 
   3.7648904010509725`*^9}, {3.764890438990239*^9, 3.764890439130639*^9}, 
   3.7648906343181825`*^9, 3.76489671665236*^9, 3.7650607837398424`*^9, 
   3.7651708746570864`*^9, 3.7651709275255795`*^9, {3.7651715865911446`*^9, 
   3.7651716002099686`*^9}, {3.765172130556101*^9, 3.7651721436133237`*^9}, 
   3.765258860522336*^9, 3.7652589119088264`*^9, 3.765267845342927*^9, 
   3.766219677032467*^9, 3.766219733644967*^9, 3.766220205062195*^9, 
   3.766224732047748*^9, {3.766371669949203*^9, 3.766371670120803*^9}, {
   3.7664771998922896`*^9, 3.7664772214515276`*^9}, {3.7664774867767935`*^9, 
   3.7664775002396173`*^9}, {3.768845899023299*^9, 3.768845913219324*^9}, {
   3.7688464421018543`*^9, 3.7688464430066557`*^9}, {3.768846907500272*^9, 
   3.768846908498674*^9}, {3.7756127056776414`*^9, 3.7756127085636463`*^9}, 
   3.7919252574583597`*^9, 3.791925346562312*^9, 3.7919254153117027`*^9, {
   3.7919255247077045`*^9, 3.791925531253033*^9}, 3.791925598002926*^9, {
   3.791925817141368*^9, 3.791925857178751*^9}, {3.7919259309425774`*^9, 
   3.791925933801317*^9}, {3.7919260057136*^9, 3.791926009212773*^9}, {
   3.79192660049582*^9, 3.7919266190539074`*^9}, {3.7919271891237907`*^9, 
   3.7919272245842*^9}, {3.7919274867894063`*^9, 3.791927489554371*^9}, {
   3.791927538745885*^9, 3.791927604824026*^9}, {3.7919283206321373`*^9, 
   3.791928328770767*^9}, 3.7919283681131506`*^9, 3.791941147556281*^9, 
   3.791941226943779*^9, {3.791943064803152*^9, 3.791943072441972*^9}, 
   3.7919455853419733`*^9, 3.7919456390636563`*^9, 3.7919457301594105`*^9, {
   3.7919460176571693`*^9, 3.791946064630477*^9}, 3.7919462776270447`*^9, {
   3.7919463420805435`*^9, 3.7919463444393888`*^9}, {3.791948507232851*^9, 
   3.7919485077639413`*^9}, 3.7921427775327096`*^9, 3.7921428813674984`*^9, {
   3.7921430077438335`*^9, 3.7921430285982695`*^9}, {3.792143075102886*^9, 
   3.792143196527261*^9}, 3.7921432320813465`*^9, {3.7921435108289423`*^9, 
   3.7921435112507515`*^9}, {3.792144994000306*^9, 3.7921450236495314`*^9}, 
   3.7921450984755683`*^9, {3.792145135779237*^9, 3.7921451459487057`*^9}, 
   3.7921451813309965`*^9, {3.7921455405896435`*^9, 3.792145540823963*^9}, {
   3.792184495223648*^9, 3.7921844998788123`*^9}, {3.792184623771303*^9, 
   3.7921846334096813`*^9}, {3.792206627230712*^9, 3.792206627230712*^9}, 
   3.7922067487800713`*^9, {3.792206857551155*^9, 3.7922068652212453`*^9}, 
   3.79220731139717*^9, 3.7922074804352627`*^9, {3.792207911722797*^9, 
   3.792207920220762*^9}, 3.7922106315283227`*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709234165945`*^9, 3.7922709273375435`*^9}, 
   3.7922709952589617`*^9, 3.792271044919084*^9, {3.7922714000850353`*^9, 
   3.7922714133162184`*^9}, {3.79227225780206*^9, 3.7922722845301075`*^9}, 
   3.7922726379453006`*^9, 3.792538656581356*^9, 3.792538928359619*^9, {
   3.79253897772618*^9, 3.7925389929881973`*^9}, 3.792539105239499*^9, 
   3.7925391544309196`*^9, {3.7925392146979003`*^9, 3.7925392318501225`*^9}, {
   3.792553251880274*^9, 3.7925533135219245`*^9}, {3.792553558651388*^9, 
   3.7925535983294907`*^9}, 3.7925536300406995`*^9, 3.792553977661547*^9, 
   3.7934110765855913`*^9, 3.802546778036353*^9, 3.8025468148870387`*^9, 
   3.802552822458405*^9, {3.8025530544662237`*^9, 3.8025530844279113`*^9}, {
   3.802553133713169*^9, 3.8025531354783773`*^9}, {3.8025532097421217`*^9, 
   3.8025532578048534`*^9}, {3.802553588023881*^9, 3.802553607941058*^9}, {
   3.8025798334471254`*^9, 3.802579836009097*^9}, 3.8025799428439727`*^9, 
   3.8025826954822035`*^9, 3.807854554258397*^9, 3.807854690828374*^9, {
   3.8078547263903584`*^9, 3.8078547526052713`*^9}, {3.8078547973826*^9, 
   3.8078548259492536`*^9}, 3.807854857290492*^9, {3.807855065442194*^9, 
   3.8078550755771074`*^9}, 3.816906042506902*^9, 3.8169062174197626`*^9, {
   3.8169062961825204`*^9, 3.8169063081953278`*^9}, 3.8169064017358685`*^9, 
   3.8169064565355053`*^9, {3.816906506133236*^9, 3.816906533095647*^9}, 
   3.8169065818185563`*^9, 3.816906741702897*^9, 3.8169069030617733`*^9, 
   3.816911863808765*^9, {3.820806523044219*^9, 3.820806525543599*^9}, {
   3.820806605337228*^9, 3.820806634720892*^9}, {3.820806728870463*^9, 
   3.8208067606910887`*^9}, 3.8208068514664154`*^9, 3.8208068887857084`*^9, {
   3.820806986417849*^9, 3.820806992557019*^9}, 3.820807050543249*^9, 
   3.8208071575179443`*^9, {3.827874604494393*^9, 3.8278746309725633`*^9}, 
   3.828286126815601*^9, 3.828286178522227*^9, {3.8282862114207487`*^9, 
   3.828286249083788*^9}, 3.8282862800765343`*^9, {3.828286322644653*^9, 
   3.828286322972701*^9}, {3.828286357931463*^9, 3.828286378520382*^9}, 
   3.828286413949597*^9, 3.8282865511517544`*^9, 3.828849014384474*^9, {
   3.8482570386544743`*^9, 3.8482570386544743`*^9}, {3.848257162547103*^9, 
   3.8482572050995564`*^9}, 3.8482572474489293`*^9, 3.8482592289492965`*^9, 
   3.8482592632131195`*^9, 3.8482593480525*^9, {3.8482596406568003`*^9, 
   3.848259662354802*^9}, {3.8482598575520773`*^9, 3.848259863863089*^9}, {
   3.848259935769012*^9, 3.848259938174694*^9}, {3.848260033511561*^9, 
   3.8482600702372885`*^9}, {3.848260636230188*^9, 3.848260666894863*^9}, 
   3.8482606989966545`*^9, 3.8482607541243086`*^9, {3.8547617639317226`*^9, 
   3.854761763947344*^9}, 3.854761807093421*^9, {3.854761939287712*^9, 
   3.854761948035654*^9}, {3.854762215597452*^9, 3.8547622692588873`*^9}, {
   3.8547623089584866`*^9, 3.854762311739122*^9}, {3.8547623431746674`*^9, 
   3.854762363654195*^9}, 3.854763519987254*^9, 3.8831684261211495`*^9, 
   3.883168549077005*^9, 3.8831685918169317`*^9, {3.883169007296896*^9, 
   3.88316901865359*^9}, 3.883169538507764*^9, 3.8831706590004115`*^9, 
   3.883170863795307*^9, {3.9565290756180315`*^9, 3.9565290756180315`*^9}, 
   3.9565292781396837`*^9, {3.9565293331424026`*^9, 3.9565293645100403`*^9}, 
   3.9565294692042217`*^9, 3.956529507929509*^9, {3.9565295473808737`*^9, 
   3.9565295677979517`*^9}, {3.9565297430061445`*^9, 
   3.9565297484892626`*^9}, {3.956529847778465*^9, 3.956529900063098*^9}, {
   3.9565301658693733`*^9, 3.956530172289773*^9}, 3.9565304532600217`*^9, 
   3.95656037030962*^9, {3.9565604806586895`*^9, 3.9565605106516905`*^9}, {
   3.956560884861517*^9, 3.956560886423687*^9}, 3.956560954532699*^9, 
   3.9565610181461544`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0250.png\>\"", ",", "rp3dConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.5339551667918453`*^9, 3.5339552009091053`*^9, 3.5470088969568434`*^9, 
   3.5470089640057616`*^9, {3.5501987513788223`*^9, 3.550198751410022*^9}, 
   3.5501988321245637`*^9, {3.5504693115261126`*^9, 3.550469311666513*^9}, 
   3.5531142779343195`*^9, 3.5531143119735794`*^9, 3.5531145798316503`*^9, 
   3.55318508241103*^9, {3.55318525330933*^9, 3.5531852534809303`*^9}, 
   3.553190085153738*^9, 3.553190157912266*^9, 3.553190885227544*^9, {
   3.553190960606876*^9, 3.5531909607628765`*^9}, {3.5532137942008047`*^9, 
   3.553213813825639*^9}, {3.55321412771379*^9, 3.553214156714241*^9}, {
   3.556389588766031*^9, 3.5563895889376307`*^9}, 3.5563898811573443`*^9, {
   3.7325812234839706`*^9, 3.7325812239051714`*^9}, 3.7326535205260754`*^9, {
   3.7326591250071225`*^9, 3.7326591252255225`*^9}, 3.732659348416316*^9, 
   3.7402167509688253`*^9, 3.740218234479841*^9, 3.740218993768783*^9, 
   3.740778618671685*^9, {3.7407806106543875`*^9, 3.740780610810388*^9}, {
   3.740782307394898*^9, 3.7407823078160987`*^9}, {3.7407957072626677`*^9, 
   3.740795732191511*^9}, 3.7411140683254943`*^9, {3.7411141195091844`*^9, 
   3.7411141197119846`*^9}, 3.7411667406790447`*^9, {3.7411668525936413`*^9, 
   3.7411668526872416`*^9}, {3.7414211411412773`*^9, 3.7414211413128777`*^9}, 
   3.7446637082540293`*^9, {3.744664383891216*^9, 3.7446643841564164`*^9}, 
   3.7446656128001237`*^9, {3.744665919325062*^9, 3.7446659194654617`*^9}, 
   3.745212728256248*^9, {3.7452127863195496`*^9, 3.7452127865379505`*^9}, 
   3.745215210719808*^9, 3.7452153969769354`*^9, 3.7460519999891343`*^9, {
   3.7460520390048027`*^9, 3.746052039628804*^9}, 3.7460551110166025`*^9, 
   3.7469914786308823`*^9, {3.7469915178025513`*^9, 3.746991547068203*^9}, 
   3.7469916572823963`*^9, 3.7481111850173426`*^9, {3.7481113291771955`*^9, 
   3.748111329348796*^9}, 3.7481126410927*^9, 3.7481132104469*^9, {
   3.750716795334118*^9, 3.7507167978769226`*^9}, 3.750716914752328*^9, 
   3.750907902205965*^9, {3.7509079354808235`*^9, 3.750907935777224*^9}, 
   3.7509082696178102`*^9, 3.751350024917858*^9, 3.7513500920135756`*^9, {
   3.751350335186803*^9, 3.7513503353740034`*^9}, 3.7514001537856855`*^9, {
   3.7550497020342665`*^9, 3.755049702159066*^9}, {3.755049780455604*^9, 
   3.7550497817660065`*^9}, 3.755049981961158*^9, 3.7622835534347343`*^9, 
   3.7622835983940134`*^9, 3.7622836925245786`*^9, 3.7642809470685997`*^9, 
   3.764280993650282*^9, {3.764281062056402*^9, 3.7642810876404467`*^9}, 
   3.7642812103970623`*^9, {3.7642812957916126`*^9, 3.764281295994413*^9}, 
   3.7642914608743176`*^9, 3.7642915591544905`*^9, 3.764664425437742*^9, {
   3.7646645337331324`*^9, 3.7646645339047327`*^9}, {3.7648873895846786`*^9, 
   3.764887389771879*^9}, 3.764887973275304*^9, 3.764889411126232*^9, 
   3.765060236898082*^9, 3.7650607861422467`*^9, {3.765087671387186*^9, 
   3.7650876715275865`*^9}, {3.7651708114457755`*^9, 3.765170811664176*^9}, 
   3.7651708746570864`*^9, 3.765258911924426*^9, {3.765259045601061*^9, 
   3.7652590457882614`*^9}, {3.766219554353852*^9, 3.766219582964302*^9}, 
   3.766219677032467*^9, 3.7662202070277977`*^9, 3.7664771998922896`*^9, 
   3.7664773392785344`*^9, 3.7664774867923937`*^9, 3.766477573575346*^9, 
   3.766611931678881*^9, {3.7673939264508924`*^9, 3.767393926622493*^9}, 
   3.768845899023299*^9, 3.768845992139863*^9, 3.7688461046784606`*^9, 
   3.791925257473979*^9, 3.7919260459384813`*^9, {3.791926076384407*^9, 
   3.791926077056122*^9}, 3.7919411447288256`*^9, 3.7919412585144467`*^9, {
   3.791945587700791*^9, 3.7919456092894487`*^9}, 3.7921427775327096`*^9, {
   3.7921442396836076`*^9, 3.7921442398866467`*^9}, 3.7921449966246824`*^9, {
   3.7921450490810156`*^9, 3.792145049205987*^9}, 3.792206627230712*^9, {
   3.792208145964188*^9, 3.7922081471983175`*^9}, 3.7922705977436914`*^9, {
   3.7922707178871346`*^9, 3.792270718027725*^9}, 3.792538656581356*^9, 
   3.792554025353397*^9, 3.8025468178550973`*^9, {3.8025468885259333`*^9, 
   3.802546916941086*^9}, 3.8025516349182377`*^9, {3.8025798245429773`*^9, 
   3.8025798309477167`*^9}, 3.8078544471885157`*^9, {3.807854484527757*^9, 
   3.8078544851420836`*^9}, 3.8078545576323867`*^9, 3.8169060469746084`*^9, 
   3.8169068200344243`*^9, 3.816906860056246*^9, 3.8208064231928377`*^9, 
   3.82080645710668*^9, 3.8208065296052046`*^9, {3.827874604510014*^9, 
   3.8278746309725633`*^9}, 3.8278748592717104`*^9, 3.827874904026807*^9, 
   3.828286644676685*^9, 3.8482570386544743`*^9, 3.8482570746303196`*^9, 
   3.8482571201821003`*^9, 3.854761763962966*^9, {3.8547618360100236`*^9, 
   3.8547618598794146`*^9}, {3.883168591832553*^9, 3.8831686183106723`*^9}, {
   3.883168650240633*^9, 3.883168650334363*^9}, 3.9565290756336536`*^9, {
   3.9565292024855556`*^9, 3.9565292194190598`*^9}, 3.956560367857068*^9, 
   3.95656044477652*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ip3dConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"ImPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.6"}], "-", 
       RowBox[{"3.7", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3.8"}], "-", 
       RowBox[{"3.2", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2"}], ",", "0.2"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0.02", ",", "0.02"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "8"}], ",", "2"}], "}"}], ",", "28"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221546276207`*^9}, {3.533956568630308*^9, 3.533956665834079*^9}, 
   3.533956762975449*^9, 3.534709995286988*^9, 3.5347102702566714`*^9, {
   3.534710307587537*^9, 3.5347103104111423`*^9}, {3.5355943645733566`*^9, 
   3.535594376788178*^9}, 3.535594491198779*^9, 3.5364644067701993`*^9, 
   3.5470089687325697`*^9, 3.5470091814857435`*^9, 3.547010097738553*^9, 
   3.5470101745878887`*^9, {3.5470102237747755`*^9, 3.547010237268799*^9}, {
   3.547010380711051*^9, 3.5470103817718525`*^9}, {3.5470104851844344`*^9, 
   3.547010496198054*^9}, {3.5470106544943323`*^9, 3.5470106643379498`*^9}, 
   3.5501988381617746`*^9, 3.5501990644401717`*^9, 3.5501999267834873`*^9, 
   3.55019999637521*^9, 3.5502073267184286`*^9, 3.5502076353347707`*^9, 
   3.5502077484661694`*^9, 3.550207835311522*^9, 3.5502086336303244`*^9, 
   3.550208731848097*^9, 3.550210071001249*^9, 3.550347114335082*^9, {
   3.550801163206278*^9, 3.550801166139083*^9}, 3.550801269660865*^9, 
   3.550828851690422*^9, 3.5531145252783546`*^9, 3.5531145863212614`*^9, 
   3.55311514895185*^9, {3.5531151847383127`*^9, 3.553115215641967*^9}, 
   3.553115260164445*^9, {3.5531154473135815`*^9, 3.553115448514784*^9}, 
   3.5531154849408474`*^9, 3.553184125130948*^9, 3.5531844635735426`*^9, 
   3.553184932650767*^9, {3.5531850286689353`*^9, 3.5531850425373597`*^9}, {
   3.5534455293427954`*^9, 3.553445530746798*^9}, {3.5534883365952864`*^9, 
   3.553488340932094*^9}, 3.553543103023369*^9, {3.5642903301670055`*^9, 
   3.5642903301670055`*^9}, {3.564291253782228*^9, 3.564291279803074*^9}, {
   3.564291310691128*^9, 3.5642913116739297`*^9}, 3.5642913605800157`*^9, 
   3.5642913913588696`*^9, 3.5645701775490894`*^9, 3.5645702349415903`*^9, {
   3.5645704646519933`*^9, 3.5645704806576214`*^9}, {3.564632162083235*^9, 
   3.5646321622704353`*^9}, {3.5672835744635324`*^9, 3.567283599189576*^9}, 
   3.567283658984481*^9, 3.567283712648576*^9, {3.5672837757506866`*^9, 
   3.5672838367779937`*^9}, 3.567283936711769*^9, 3.5672839671942225`*^9, 
   3.567749304927465*^9, 3.567802786200432*^9, 3.5678028867426085`*^9, 
   3.568197679377499*^9, 3.5681977398588057`*^9, {3.568197770497259*^9, 
   3.568197789934893*^9}, 3.568197954873983*^9, 3.570075573527918*^9, 
   3.5700756161159925`*^9, 3.5700766576674213`*^9, {3.570086891428359*^9, 
   3.5700868916123695`*^9}, {3.570087021291787*^9, 3.5700870234839125`*^9}, {
   3.570087084260389*^9, 3.5700871039165125`*^9}, 3.5700872267835407`*^9, {
   3.5700962429593163`*^9, 3.570096251367731*^9}, 3.5700963382910833`*^9, 
   3.573604824020702*^9, 3.573604898479633*^9, 3.5736049445153136`*^9, {
   3.5736050810779533`*^9, 3.5736051059131975`*^9}, 3.573605138158454*^9, 
   3.5736051863625383`*^9, {3.573605233568221*^9, 3.5736052565938616`*^9}, 
   3.573605861250924*^9, 3.5736059303122454`*^9, 3.5736059609350986`*^9, {
   3.573605994537558*^9, 3.5736059957855597`*^9}, 3.573606094143733*^9, 
   3.5736061630646544`*^9, {3.5736066875826025`*^9, 3.5736067019502277`*^9}, 
   3.573615827794015*^9, 3.573616064212538*^9, {3.5736161174245815`*^9, 
   3.573616176377953*^9}, 3.573616231172087*^9, 3.573616275574627*^9, {
   3.5736164520657215`*^9, 3.5736164539218273`*^9}, {3.574885930536127*^9, 
   3.574885961158981*^9}, {3.5748860538543434`*^9, 3.574886055414346*^9}, {
   3.57488610316603*^9, 3.574886104788433*^9}, 3.575772368950635*^9, 
   3.575772414543243*^9, {3.5757724483991795`*^9, 3.575772496190913*^9}, {
   3.575772614086656*^9, 3.5757726286944914`*^9}, 3.5757726590812297`*^9, {
   3.5759741411197433`*^9, 3.5759741561581697`*^9}, {3.5759742021002502`*^9, 
   3.5759742157346745`*^9}, 3.5768732485823507`*^9, {3.5768733225420804`*^9, 
   3.576873346644123*^9}, {3.5768734557819147`*^9, 3.576873461850325*^9}, {
   3.5768734924263787`*^9, 3.57687352147363*^9}, {3.5770554598819695`*^9, 
   3.577055463204776*^9}, 3.5778715362491693`*^9, {3.5778716912240334`*^9, 
   3.577871702816696*^9}, 3.5778717565767713`*^9, {3.5778718371413794`*^9, 
   3.577871932399828*^9}, 3.5779963889137025`*^9, {3.5779971639186645`*^9, 
   3.577997164261865*^9}, 3.577997327712983*^9, {3.5779973707690587`*^9, 
   3.577997383857482*^9}, 3.577997501216488*^9, {3.592182738845936*^9, 
   3.592182738861536*^9}, 3.592182944360697*^9, 3.5921830186012273`*^9, 
   3.592189432880093*^9, 3.592189463674547*^9, {3.592189504297019*^9, 
   3.592189506559023*^9}, 3.592189562375921*^9, {3.592189594262377*^9, 
   3.5921896106424055`*^9}, 3.5921897904795218`*^9, 3.592189846156019*^9, 
   3.592355462843272*^9, 3.59938841163758*^9, {3.599388677087646*^9, 
   3.599388684560059*^9}, 3.5993887418121595`*^9, 3.5993887919038477`*^9, 
   3.599389809202035*^9, 3.5994506393849616`*^9, 3.606352380183405*^9, {
   3.6063536387788167`*^9, 3.606353654363244*^9}, {3.606353693441313*^9, 
   3.6063537178865557`*^9}, 3.606354117960466*^9, {3.6063541792997737`*^9, 
   3.606354199065008*^9}, 3.606354347452469*^9, {3.606355491121396*^9, 
   3.606355500497013*^9}, {3.6063556639697*^9, 3.606355691815749*^9}, {
   3.606355951598206*^9, 3.606355974249446*^9}, 3.6063566362550087`*^9, 
   3.6063623067270436`*^9, 3.6063641073134065`*^9, 3.6063646163423004`*^9, {
   3.606424064606145*^9, 3.606424095525399*^9}, 3.606435037067684*^9, 
   3.6253066976903305`*^9, 3.6253067308559885`*^9, {3.625307148703523*^9, 
   3.6253071524163303`*^9}, 3.6253071875163918`*^9, 3.6253072177180443`*^9, {
   3.625307746315781*^9, 3.625307759903405*^9}, {3.625307823676317*^9, 
   3.625307828637126*^9}, 3.62530786493839*^9, 3.625308047693511*^9, {
   3.6253081020908065`*^9, 3.6253081157564306`*^9}, {3.6253833845823274`*^9, 
   3.6253833858459296`*^9}, 3.6253834204935904`*^9, 3.6291871979741755`*^9, 
   3.6291872594694834`*^9, {3.6291872945851455`*^9, 3.6291873218851933`*^9}, 
   3.6291877401579294`*^9, 3.6291877836352053`*^9, 3.6291878504345226`*^9, 
   3.629188085136935*^9, {3.6291893908088293`*^9, 3.62918939137043*^9}, 
   3.629412984390986*^9, {3.6296819408526163`*^9, 3.629681967825063*^9}, 
   3.6296830686522045`*^9, {3.6296838311971436`*^9, 3.629683868200409*^9}, 
   3.629684076866375*^9, 3.6296853116949444`*^9, 3.6301301057327366`*^9, 
   3.630186815320861*^9, 3.630191351912052*^9, {3.630191442251811*^9, 
   3.630191443047412*^9}, {3.6301915674264307`*^9, 3.630191567582431*^9}, 
   3.630191627034135*^9, 3.6301916686862087`*^9, {3.630191698872261*^9, 
   3.630191748199548*^9}, 3.6301925032876744`*^9, 3.6302240261576805`*^9, 
   3.6325489666245556`*^9, 3.6325493494752283`*^9, 3.632549601344486*^9, 
   3.6325497935128317`*^9, {3.6325499103370447`*^9, 3.632549935952289*^9}, {
   3.6326052493632545`*^9, 3.6326052629040785`*^9}, 3.63278969455567*^9, {
   3.632789742073353*^9, 3.632789791213439*^9}, 3.632789884486003*^9, 
   3.63279000237541*^9, 3.632798142408646*^9, 3.6327982664912643`*^9, 
   3.6328077266600885`*^9, 3.6328077568617415`*^9, {3.6328139368782277`*^9, 
   3.6328140112279577`*^9}, {3.632814042646413*^9, 3.6328140428492136`*^9}, {
   3.6328142255199356`*^9, 3.6328142422743645`*^9}, {3.6328628377011323`*^9, 
   3.6328628382471333`*^9}, 3.632863071561143*^9, 3.6328903827053213`*^9, {
   3.63450396414303*^9, 3.634503989945475*^9}, 3.634505031134311*^9, {
   3.6345050814287996`*^9, 3.6345050826300015`*^9}, {3.634505119567073*^9, 
   3.6345051390203075`*^9}, {3.63450518026678*^9, 3.6345051946500053`*^9}, {
   3.634505252089306*^9, 3.634505279467354*^9}, {3.6345559523854685`*^9, 
   3.634555955614674*^9}, 3.634556221122741*^9, {3.6360748556676345`*^9, 
   3.636074857804838*^9}, 3.6360754056294017`*^9, 3.6360755416304407`*^9, {
   3.636075572097294*^9, 3.6360755749364986`*^9}, 3.6360756677410617`*^9, 
   3.6360760229536858`*^9, {3.6360760624173627`*^9, 3.6360760925254154`*^9}, 
   3.6360761236318703`*^9, {3.636495351875679*^9, 3.636495380361329*^9}, 
   3.636495512727562*^9, 3.6364955557680373`*^9, 3.636495774451644*^9, {
   3.636495808288103*^9, 3.6364958628569994`*^9}, 3.636495995379232*^9, 
   3.6364961521595078`*^9, 3.6364963213886046`*^9, 3.636496426595189*^9, 
   3.636496986184173*^9, {3.6367624760855265`*^9, 3.636762479361532*^9}, 
   3.7255924293790016`*^9, 3.7255925317463818`*^9, 3.7255944743117948`*^9, {
   3.725594518943473*^9, 3.7255945214862776`*^9}, 3.7255953603777514`*^9, 
   3.7255957972769194`*^9, {3.7255958312537794`*^9, 3.7255958481174088`*^9}, {
   3.725596058390178*^9, 3.7255960649109898`*^9}, 3.7255963371938677`*^9, 
   3.72559640661399*^9, {3.725601386418369*^9, 3.7256014341076527`*^9}, 
   3.7257712704994154`*^9, 3.725774257093461*^9, 3.72577429072712*^9, {
   3.725774416443348*^9, 3.7257744278937683`*^9}, 3.725779901988584*^9, 
   3.72578045202995*^9, 3.7258490308793774`*^9, 3.7258521063247805`*^9, 
   3.725852262605855*^9, 3.725852360558427*^9, 3.7258524069529085`*^9, 
   3.725852753257917*^9, 3.725853436567118*^9, {3.7258534847400026`*^9, 
   3.7258535107140484`*^9}, {3.725853667353924*^9, 3.7258536787419434`*^9}, 
   3.726913461475872*^9, {3.726913506715952*^9, 3.7269135067315516`*^9}, 
   3.726913573655669*^9, 3.7269142285136194`*^9, {3.7269143657158604`*^9, 
   3.7269143772130804`*^9}, 3.726914441095193*^9, 3.7269145189861298`*^9, 
   3.726914651929563*^9, 3.7269147274648952`*^9, 3.726915143191228*^9, {
   3.7269151750932837`*^9, 3.7269151752336836`*^9}, {3.7269155027638597`*^9, 
   3.726915507599868*^9}, {3.726942965317898*^9, 3.7269429659418993`*^9}, 
   3.7269527321998544`*^9, {3.732581567667375*^9, 3.732581616495461*^9}, {
   3.732658450427137*^9, 3.732658468772769*^9}, {3.732658950832816*^9, 
   3.7326589718928533`*^9}, 3.7326593484319158`*^9, 3.7326684474112062`*^9, {
   3.740218164622918*^9, 3.740218189130562*^9}, 3.7402182402830515`*^9, {
   3.7402183944893227`*^9, 3.7402184164385605`*^9}, 3.740218476010673*^9, 
   3.740218965392333*^9, 3.7402207306098347`*^9, 3.740623523847764*^9, {
   3.7407786224156923`*^9, 3.7407786244124956`*^9}, {3.740778719260662*^9, 
   3.7407787320526843`*^9}, {3.7407792555464067`*^9, 3.7407793011608863`*^9}, 
   3.7407793394121532`*^9, {3.740779664601926*^9, 3.7407796776747484`*^9}, 
   3.7407805414526663`*^9, 3.740780576287527*^9, 3.7407807802890854`*^9, 
   3.74078247376919*^9, {3.7407839511537724`*^9, 3.7407839979846582`*^9}, 
   3.7407842696709504`*^9, {3.740784331289063*^9, 3.7407843341800685`*^9}, {
   3.740784465266109*^9, 3.7407844673429127`*^9}, 3.740784531285632*^9, 
   3.74078474467282*^9, {3.740785226216671*^9, 3.740785234380486*^9}, {
   3.74079231722311*^9, 3.740792318034312*^9}, 3.740795728899905*^9, 
   3.740795848146515*^9, 3.740796253029626*^9, 3.7407962960389013`*^9, 
   3.7407968627566967`*^9, 3.7407969034103684`*^9, {3.7411140723503017`*^9, 
   3.7411140740039043`*^9}, 3.7411141862149014`*^9, {3.7411142414077983`*^9, 
   3.7411142788634644`*^9}, {3.741114361278409*^9, 3.741114362464011*^9}, 
   3.741114397938473*^9, 3.7411144525385695`*^9, 3.741165060176092*^9, 
   3.741166736872638*^9, 3.7411668048419576`*^9, 3.741167005957511*^9, 
   3.741892706493498*^9, 3.7446637127156367`*^9, 3.744664185162467*^9, 
   3.7446656128001237`*^9, 3.7446656519561925`*^9, 3.7447503942786407`*^9, 
   3.7448755599807453`*^9, 3.7452127385678663`*^9, 3.7452130555136228`*^9, 
   3.7452134456391077`*^9, {3.7452134806767693`*^9, 3.7452134813007703`*^9}, 
   3.745213585493354*^9, 3.745213767873274*^9, {3.7452137983869276`*^9, 
   3.7452138193377643`*^9}, {3.745213904810314*^9, 3.7452139139363303`*^9}, {
   3.745213949395193*^9, 3.7452139495823927`*^9}, {3.745213986975659*^9, 
   3.74521402177932*^9}, {3.7452153772273006`*^9, 3.7452153940753307`*^9}, {
   3.7452158730613728`*^9, 3.745215903824627*^9}, {3.7452159530895133`*^9, 
   3.7452159792039595`*^9}, 3.745216259770452*^9, 3.7460520035615406`*^9, {
   3.746054453943448*^9, 3.7460544574378543`*^9}, 3.746054497295924*^9, 
   3.746054597682101*^9, {3.7460547541659756`*^9, 3.7460547746800117`*^9}, 
   3.7460548541777515`*^9, 3.746054960086337*^9, 3.746991665534811*^9, 
   3.746995590370906*^9, 3.7469956213057604`*^9, {3.746995729995552*^9, 
   3.746995731243554*^9}, {3.7469957645028124`*^9, 3.746995765407614*^9}, {
   3.746995818198107*^9, 3.7469958661213913`*^9}, {3.7469959375383167`*^9, 
   3.746995941453923*^9}, {3.747000815490528*^9, 3.7470008173313313`*^9}, {
   3.7470008849886503`*^9, 3.7470008863926525`*^9}, {3.7470275513438883`*^9, 
   3.7470275518742895`*^9}, {3.7470280525595703`*^9, 3.7470280552115746`*^9}, 
   3.7481111897753506`*^9, 3.7481112427842436`*^9, 3.748111476535054*^9, 
   3.7481115164555244`*^9, 3.7481117566959467`*^9, 3.7481117914684076`*^9, 
   3.7481118423556967`*^9, 3.7481119434438744`*^9, 3.7481119960783668`*^9, 
   3.7481126379102945`*^9, 3.7481127727725315`*^9, 3.748112894015944*^9, 
   3.7481129700816774`*^9, {3.748113028800181*^9, 3.748113030016983*^9}, 
   3.7481131110123253`*^9, 3.748114875740626*^9, 3.748152382102949*^9, 
   3.748156767894652*^9, 3.749668431509885*^9, 3.7507169249859457`*^9, {
   3.7507174668996973`*^9, 3.750717469458102*^9}, 3.750718004418642*^9, 
   3.750718074774766*^9, 3.7507181111072297`*^9, {3.7507182219610243`*^9, 
   3.7507182332866445`*^9}, 3.7507183577748632`*^9, {3.750719884635145*^9, 
   3.750719897083967*^9}, 3.750720673464531*^9, 3.7507242419383993`*^9, 
   3.7507256027451925`*^9, 3.750744003618518*^9, {3.750744093771076*^9, 
   3.7507440965790815`*^9}, 3.7511831548293476`*^9, 3.7511832008026285`*^9, {
   3.751189424649564*^9, 3.7511894256479654`*^9}, 3.7511895614618044`*^9, {
   3.7511910305075865`*^9, 3.7511910391500015`*^9}, {3.751192237613307*^9, 
   3.751192254305336*^9}, 3.751230212036337*^9, {3.751274116442066*^9, 
   3.7512741166136665`*^9}, 3.751343682541116*^9, {3.751343733085205*^9, 
   3.7513437501204348`*^9}, 3.751344238166094*^9, 3.75134430452861*^9, {
   3.751345479669874*^9, 3.7513454796854744`*^9}, 3.751345820748873*^9, {
   3.7513459524443045`*^9, 3.7513459532399063`*^9}, 3.751346262260849*^9, {
   3.751348105092086*^9, 3.7513481245765195`*^9}, {3.7513566618091145`*^9, 
   3.751356668220726*^9}, {3.751358491060729*^9, 3.7513584912323294`*^9}, {
   3.75135877156363*^9, 3.75135877173523*^9}, 3.751359211999203*^9, 
   3.755049981976758*^9, 3.7550500821133337`*^9, 3.7550501621414747`*^9, {
   3.755050416297121*^9, 3.7550504199943275`*^9}, 3.7550509388668385`*^9, 
   3.7550519367687855`*^9, {3.755051997187691*^9, 3.755052060695403*^9}, 
   3.7550521337191315`*^9, 3.7550521647007856`*^9, 3.7550613876302633`*^9, 
   3.7551379564936295`*^9, {3.755138024930949*^9, 3.7551380411237783`*^9}, 
   3.755138082682251*^9, {3.7551381845348296`*^9, 3.7551382172792873`*^9}, 
   3.7551383234530735`*^9, {3.755138441217681*^9, 3.7551385276106324`*^9}, {
   3.755138882422056*^9, 3.755138897273282*^9}, {3.7551414688371882`*^9, 
   3.7551414693363895`*^9}, 3.755142317557621*^9, 3.755143433067379*^9, {
   3.7551476031529503`*^9, 3.7551476133397684`*^9}, 3.7551478086989117`*^9, 
   3.7552236306785617`*^9, 3.7552237351007524`*^9, {3.7552275045464*^9, 
   3.7552275077132063`*^9}, 3.7642903539579687`*^9, 3.76429053655789*^9, {
   3.7642905687251463`*^9, 3.7642906105332203`*^9}, 3.764290668502922*^9, {
   3.7642907246006203`*^9, 3.764290784832326*^9}, {3.7642908265935993`*^9, 
   3.7642908360628157`*^9}, 3.7642909449510074`*^9, {3.764290981189871*^9, 
   3.764290981876272*^9}, 3.7642912047834673`*^9, {3.764291319491269*^9, 
   3.764291321378873*^9}, 3.764291611398982*^9, 3.7643023539758563`*^9, 
   3.7643023976559334`*^9, 3.764304230323553*^9, 3.7643178534248857`*^9, 
   3.7643204595866685`*^9, 3.764370162398338*^9, 3.764372959000451*^9, {
   3.7643746106161537`*^9, 3.7643746108813543`*^9}, 3.764384946199549*^9, 
   3.764385323602227*^9, 3.7646681264950523`*^9, 3.764668209284398*^9, {
   3.7646682425904565`*^9, 3.7646682533076754`*^9}, 3.764668288563737*^9, 
   3.764668544731787*^9, 3.764887973290904*^9, 3.7648880093425674`*^9, 
   3.7648889030021396`*^9, {3.7648903950293617`*^9, 3.7648904044205785`*^9}, {
   3.764890442796646*^9, 3.7648904429526463`*^9}, 3.7648906360965853`*^9, 
   3.7648967215975685`*^9, 3.765060789137452*^9, 3.7651708746726866`*^9, 
   3.7651709275255795`*^9, {3.765171589180749*^9, 3.765171597479964*^9}, {
   3.765172134970908*^9, 3.765172146390128*^9}, 3.7652588607251368`*^9, 
   3.765258911924426*^9, 3.7652678488217335`*^9, 3.766219677032467*^9, 
   3.766219733644967*^9, 3.766220209789003*^9, 3.766224738350159*^9, {
   3.766371673365609*^9, 3.7663716735372095`*^9}, {3.7664771999078894`*^9, 
   3.766477221467128*^9}, {3.7664774867923937`*^9, 3.7664775002552176`*^9}, {
   3.768845899023299*^9, 3.768845913219324*^9}, {3.768846446688262*^9, 
   3.7688464478114643`*^9}, {3.7688469105734777`*^9, 3.768846911556279*^9}, {
   3.7756127125728536`*^9, 3.775612713805256*^9}, 3.791925257473979*^9, 
   3.7919253465779333`*^9, 3.791925415545993*^9, 3.791925538329486*^9, 
   3.791925601252158*^9, {3.7919258208123755`*^9, 3.791925846181349*^9}, {
   3.7919258965132446`*^9, 3.791925926459304*^9}, {3.791926014071001*^9, 
   3.7919260175701747`*^9}, 3.7919266484290524`*^9, {3.7919272055886946`*^9, 
   3.791927235331627*^9}, {3.7919276582332497`*^9, 3.7919277101428995`*^9}, {
   3.7919283378467164`*^9, 3.7919283439703007`*^9}, 3.791928389264398*^9, 
   3.7919411413389997`*^9, 3.791941230396061*^9, 3.7919430979993715`*^9, 
   3.7919455907781906`*^9, 3.7919456413443985`*^9, 3.791945710086*^9, {
   3.791946022624746*^9, 3.791946071628796*^9}, 3.7919462750182886`*^9, {
   3.7919463468763237`*^9, 3.791946348454059*^9}, {3.7919485149966345`*^9, 
   3.7919485152934113`*^9}, 3.7921427775327096`*^9, 3.7921428844917583`*^9, {
   3.792143012102148*^9, 3.7921430326754313`*^9}, {3.7921430729159*^9, 
   3.7921430957230043`*^9}, {3.792143137525601*^9, 3.7921431788751917`*^9}, 
   3.792143236720871*^9, {3.7921435062050405`*^9, 3.7921435066268454`*^9}, {
   3.792144999623945*^9, 3.792145021384448*^9}, {3.7921451021622267`*^9, 
   3.7921451511037264`*^9}, 3.792145185720539*^9, {3.7921455447136655`*^9, 
   3.792145545432212*^9}, {3.792184507470749*^9, 3.7921845096108675`*^9}, 
   3.792184641720213*^9, {3.792206627246333*^9, 3.792206627246333*^9}, 
   3.792206751388796*^9, {3.792206853864559*^9, 3.7922068746252704`*^9}, 
   3.7922073162553945`*^9, 3.7922074838563423`*^9, {3.792207902303128*^9, 
   3.7922079240167284`*^9}, 3.792210628560286*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709171055946`*^9, 3.7922709214014473`*^9}, 
   3.7922710012262707`*^9, 3.7922710487775407`*^9, {3.7922714048807282`*^9, 
   3.792271416690432*^9}, {3.7922722543810005`*^9, 3.7922722888259625`*^9}, 
   3.7922726333057737`*^9, 3.792538656581356*^9, 3.79253893338968*^9, {
   3.79253897772618*^9, 3.792538997607256*^9}, {3.7925390932423153`*^9, 
   3.7925390962103596`*^9}, 3.792539159820304*^9, 3.792539240269972*^9, {
   3.7925532546452465`*^9, 3.7925533205046535`*^9}, {3.792553601937978*^9, 
   3.7925536273538704`*^9}, 3.79255397433422*^9, 3.7934110830440025`*^9, 
   3.8025467812543383`*^9, 3.8025468240567527`*^9, 3.8025528269104867`*^9, 
   3.802553052279233*^9, 3.802553090613947*^9, {3.802553138758854*^9, 
   3.802553139914831*^9}, {3.8025532126007967`*^9, 3.802553250295064*^9}, {
   3.802553594834815*^9, 3.8025536101749134`*^9}, {3.8025798116085243`*^9, 
   3.8025798132175207`*^9}, 3.802579945624563*^9, 3.802582701183984*^9, 
   3.807854563419881*^9, 3.807854694546463*^9, {3.8078547295149803`*^9, 
   3.8078547561408234`*^9}, {3.8078547919860497`*^9, 3.8078548304791474`*^9}, 
   3.8078548606684666`*^9, 3.807855083466024*^9, 3.816906053582398*^9, 
   3.8169062224342117`*^9, {3.8169062988381157`*^9, 3.8169063060864477`*^9}, 
   3.8169064065628595`*^9, 3.816906461050069*^9, {3.8169064993379393`*^9, 
   3.8169065035244703`*^9}, 3.8169065362667856`*^9, 3.8169065845523252`*^9, 
   3.816906745967521*^9, 3.816906908810424*^9, 3.816911860153344*^9, {
   3.8208065344321394`*^9, 3.8208065372752233`*^9}, {3.8208066098049192`*^9, 
   3.820806629253437*^9}, {3.8208067246527057`*^9, 3.820806757035666*^9}, 
   3.820806846764411*^9, 3.820806898986417*^9, {3.8208069817158995`*^9, 
   3.8208069962436466`*^9}, 3.8208070567761927`*^9, 3.8208071646412573`*^9, {
   3.827874604510014*^9, 3.8278746309881845`*^9}, 3.8282861305022345`*^9, {
   3.8282861822244864`*^9, 3.8282862225431395`*^9}, 3.8282862526298304`*^9, 
   3.8282862842161703`*^9, 3.828286431179902*^9, 3.8282865552758007`*^9, 
   3.8288490182376804`*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571656713667`*^9, 3.8482572003506775`*^9}, 3.848257241247275*^9, 
   3.848259231776729*^9, 3.848259267571465*^9, 3.848259344803232*^9, 
   3.848259673414655*^9, {3.848259861051252*^9, 3.848259867143531*^9}, {
   3.848259941470792*^9, 3.8482599439389577`*^9}, 3.8482600898263903`*^9, 
   3.848260640619811*^9, 3.8482608256478395`*^9, {3.8482609065250673`*^9, 
   3.848260907681044*^9}, {3.8547617639785867`*^9, 3.8547617639785867`*^9}, 
   3.854761809702217*^9, {3.854761942224519*^9, 3.8547619519097843`*^9}, {
   3.8547622351085224`*^9, 3.854762249654128*^9}, 3.854762371152464*^9, 
   3.8547635232989454`*^9, 3.8831684232624483`*^9, 3.8831685493113613`*^9, 
   3.883168591832553*^9, {3.883169010827317*^9, 3.883169014857577*^9}, 
   3.883169424066017*^9, {3.8831694760850053`*^9, 3.8831694856764994`*^9}, 
   3.883170656625969*^9, 3.8831708592182693`*^9, {3.9565290756336536`*^9, 
   3.9565290756336536`*^9}, 3.956529278342761*^9, 3.9565293333611*^9, {
   3.956529367509301*^9, 3.9565293704148693`*^9}, 3.9565294729845495`*^9, 
   3.9565295110113583`*^9, {3.956529552879578*^9, 3.956529563252109*^9}, 
   3.9565298355156817`*^9, 3.9565299092171383`*^9, {3.95653017492978*^9, 
   3.9565301806784286`*^9}, 3.956530444152749*^9, 3.9565603644516945`*^9, 
   3.9565604775188007`*^9, 3.956560515322481*^9, {3.9565608539937935`*^9, 
   3.956560860211093*^9}, 3.956560959234726*^9, 3.9565610203956203`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0260.png\>\"", ",", "ip3dConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5339551753718605`*^9, 3.5339551977422996`*^9}, 
   3.5470088994684477`*^9, 3.5470089727417765`*^9, {3.5501987561524305`*^9, 
   3.55019875626163*^9}, 3.5501988411413794`*^9, {3.550469316159321*^9, 
   3.550469316393321*^9}, {3.5531142826767282`*^9, 3.5531142878403373`*^9}, 
   3.553114589410067*^9, 3.5531850735502143`*^9, 3.5531852580361385`*^9, 
   3.553190088148943*^9, 3.5531901617342725`*^9, 3.553190880875136*^9, {
   3.553190965255684*^9, 3.5531909657236853`*^9}, {3.553213796837209*^9, 
   3.5532138090832305`*^9}, {3.553214132081798*^9, 3.5532141604270477`*^9}, {
   3.55638959965485*^9, 3.5563895998420506`*^9}, 3.5563898856657524`*^9, {
   3.732581228351179*^9, 3.73258122874118*^9}, 3.7326535161424675`*^9, {
   3.732659131075533*^9, 3.7326591312627335`*^9}, 3.7326593484475155`*^9, 
   3.7402167509844255`*^9, 3.740218243403057*^9, 3.74021899790279*^9, 
   3.740778626643299*^9, {3.740780616519998*^9, 3.7407806166603985`*^9}, 
   3.7407823179717164`*^9, {3.740795712629077*^9, 3.7407957267315016`*^9}, 
   3.7411140764375086`*^9, {3.741114125515195*^9, 3.741114125671195*^9}, 
   3.741166734985035*^9, {3.741166859442054*^9, 3.7411668600660543`*^9}, {
   3.741421137522071*^9, 3.741421137662471*^9}, 3.7446637165064435`*^9, 
   3.7446643950296354`*^9, 3.7446656128001237`*^9, {3.7446659247070713`*^9, 
   3.7446659248786716`*^9}, 3.7452127427798734`*^9, {3.7452127929651613`*^9, 
   3.745212793152362*^9}, 3.7452152142298145`*^9, 3.7452153921565275`*^9, 
   3.7460520052775435`*^9, {3.746052046134015*^9, 3.746052046851617*^9}, 
   3.74605511521301*^9, 3.7469914820784883`*^9, {3.746991523184561*^9, 
   3.74699155112421*^9}, 3.746991670152419*^9, 3.748111192864156*^9, {
   3.748111336868009*^9, 3.7481113370708094`*^9}, 3.748112636022691*^9, 
   3.748113214284507*^9, {3.7507168278133755`*^9, 3.7507168307305803`*^9}, 
   3.7507169297439537`*^9, 3.7509079022215652`*^9, {3.750907940301232*^9, 
   3.7509079404728317`*^9}, 3.7509082696334105`*^9, 3.751350024917858*^9, 
   3.7513500920291758`*^9, {3.7513503405844126`*^9, 3.751350340787213*^9}, 
   3.7514002188533993`*^9, {3.7550496972606583`*^9, 3.7550496974946585`*^9}, {
   3.75504978959722*^9, 3.7550497905488214`*^9}, 3.755049981976758*^9, 
   3.762283559846346*^9, {3.762283605102025*^9, 3.762283605258025*^9}, 
   3.7622837044741993`*^9, 3.764280957785819*^9, 3.7642809971446877`*^9, {
   3.7642810687488136`*^9, 3.764281091244053*^9}, {3.764281218056676*^9, 
   3.764281218197076*^9}, 3.764281300721221*^9, 3.76429146773833*^9, 
   3.7642915623056955`*^9, 3.7646644254533424`*^9, {3.764664539785943*^9, 
   3.7646645399731436`*^9}, {3.7648873980398936`*^9, 3.7648873981958942`*^9}, 
   3.764887973290904*^9, {3.764889416149441*^9, 3.7648894163366413`*^9}, {
   3.7650602413440895`*^9, 3.76506024151569*^9}, 3.765060791461856*^9, 
   3.765087677377597*^9, {3.765170815548583*^9, 3.7651708157513833`*^9}, 
   3.7651708746726866`*^9, 3.765258911924426*^9, {3.765259059017085*^9, 
   3.765259059188685*^9}, 3.766219554353852*^9, {3.766219588096711*^9, 
   3.766219588315111*^9}, 3.766219677048067*^9, 3.7662202121290073`*^9, 
   3.7664771999078894`*^9, 3.766477339294134*^9, 3.7664774867923937`*^9, 
   3.766477573575346*^9, {3.76661193684249*^9, 3.7666119369516907`*^9}, {
   3.767393932285303*^9, 3.7673939324413033`*^9}, 3.7688458990388994`*^9, 
   3.768845992139863*^9, 3.7688461103100705`*^9, 3.7919252574896*^9, 
   3.791926049453236*^9, {3.7919260861008263`*^9, 3.791926086913168*^9}, 
   3.791941139339487*^9, 3.7919412617480307`*^9, {3.791945592480884*^9, 
   3.7919456060870748`*^9}, 3.7921427775483007`*^9, {3.7921442451353717`*^9, 
   3.792144245338449*^9}, 3.792145001857826*^9, {3.792145054236045*^9, 
   3.7921450544235*^9}, 3.792206627246333*^9, {3.792208155180749*^9, 
   3.7922081559774384`*^9}, 3.7922705977593207`*^9, {3.7922707237138777`*^9, 
   3.792270723791984*^9}, 3.79253865659698*^9, 3.792554032117412*^9, 
   3.8025468267904854`*^9, {3.802546894868189*^9, 3.802546913582498*^9}, 
   3.8025516394640093`*^9, {3.8025798091715994`*^9, 3.802579817638352*^9}, 
   3.8078544431792603`*^9, {3.8078544925433044`*^9, 3.8078544933671336`*^9}, 
   3.807854566519637*^9, 3.816906057737702*^9, 3.816906822971233*^9, 
   3.8169068639616127`*^9, 3.8208064318782806`*^9, {3.8208064621211166`*^9, 
   3.820806462214844*^9}, 3.820806541039958*^9, {3.8278746045256357`*^9, 
   3.8278746309881845`*^9}, 3.827874859287332*^9, {3.827874908775693*^9, 
   3.827874908963181*^9}, 3.828286648410184*^9, 3.8482570386700907`*^9, 
   3.8482570746303196`*^9, 3.848257124337367*^9, 3.854761763994209*^9, {
   3.8547618395248256`*^9, 3.854761864503364*^9}, {3.883168591832553*^9, 
   3.8831686183106723`*^9}, {3.883168654880164*^9, 3.8831686550051346`*^9}, 
   3.956529075649271*^9, {3.9565292024855556`*^9, 3.95652922354312*^9}, 
   3.9565603622021456`*^9, 3.956560449400402*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"frpConfHypergeomF3", "=", "\[IndentingNewLine]", 
  RowBox[{"FundamentalRegionPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.6"}], "-", 
       RowBox[{"3.7", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3.8"}], "-", 
       RowBox[{"3.2", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "30"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "0.2"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"400", ",", "600"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "20"}], ",", "25"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.530344234110747*^9, 3.530344269600809*^9, {3.53395684314399*^9, 
   3.5339568911608744`*^9}, {3.533956924529333*^9, 3.533956959972595*^9}, {
   3.533957001359468*^9, 3.5339570248843093`*^9}, {3.5346482317806273`*^9, 
   3.5346482369130363`*^9}, {3.5346484132401457`*^9, 3.534648422927763*^9}, {
   3.534648600908476*^9, 3.534648602874079*^9}, 3.534710001277398*^9, {
   3.534710275763481*^9, 3.5347102880095024`*^9}, {3.534710723484267*^9, 
   3.5347107275246744`*^9}, {3.534710781017168*^9, 3.534710781219969*^9}, {
   3.5347108477228856`*^9, 3.5347108501564903`*^9}, {3.536464399328986*^9, 
   3.5364644013413897`*^9}, 3.5470089850033984`*^9, {3.547009186867753*^9, 
   3.547009193606965*^9}, {3.5470101014513597`*^9, 3.5470101345858183`*^9}, 
   3.5470103852662587`*^9, 3.5501988466325893`*^9, 3.550199068246578*^9, {
   3.5502084668036313`*^9, 3.5502084670064316`*^9}, 3.550208582867835*^9, 
   3.550210551794093*^9, 3.5502106958603463`*^9, {3.550798929203307*^9, 
   3.5507989293125067`*^9}, 3.5531145282735596`*^9, 3.55311459660168*^9, 
   3.553115153538258*^9, 3.553115190603923*^9, 3.553115426549945*^9, 
   3.5531841290621552`*^9, 3.553184841780607*^9, 3.553185595402331*^9, {
   3.5642903301826057`*^9, 3.5642903301826057`*^9}, {3.564291282969879*^9, 
   3.56429128880429*^9}, 3.564291394822076*^9, 3.5645701814958963`*^9, 
   3.564570242882004*^9, {3.564570442328354*^9, 3.5645704448087587`*^9}, 
   3.5646312482712297`*^9, 3.564632058343053*^9, {3.5646323584975805`*^9, 
   3.5646323647687917`*^9}, 3.564706563514888*^9, {3.5647069832336254`*^9, 
   3.564706991033639*^9}, {3.564989542386684*^9, 3.56498954572509*^9}, {
   3.5651175773891916`*^9, 3.565117582833601*^9}, {3.567283577864339*^9, 
   3.5672835875051556`*^9}, {3.5672836659264936`*^9, 
   3.5672836766593122`*^9}, {3.567283716548582*^9, 3.567283718576586*^9}, 
   3.567283973247033*^9, 3.56728425586953*^9, {3.5672842997836075`*^9, 
   3.567284320703244*^9}, 3.5672843556005054`*^9, 3.5677493102314744`*^9, 
   3.56780279067764*^9, 3.567802890923416*^9, {3.567802966739549*^9, 
   3.5678029668955493`*^9}, 3.5681976926063223`*^9, 3.5681977453968153`*^9, {
   3.568197813974536*^9, 3.568197826126957*^9}, {3.5681978838782587`*^9, 
   3.568197918401119*^9}, 3.5700755786291265`*^9, {3.5700756190487976`*^9, 
   3.5700756257724094`*^9}, {3.570086895267579*^9, 3.570086895443589*^9}, 
   3.570087027747156*^9, 3.5700870928118777`*^9, 3.5700872352950277`*^9, {
   3.570096246297722*^9, 3.5700962494177275`*^9}, 3.570606665466712*^9, 
   3.573604837639526*^9, 3.5736049030816407`*^9, 3.5736049498193226`*^9, {
   3.5736050854147615`*^9, 3.573605109750804*^9}, 3.5736051427448616`*^9, {
   3.5736052053321714`*^9, 3.573605205519372*^9}, {3.573605408179328*^9, 
   3.573605433950573*^9}, 3.5736058570857162`*^9, 3.5736059335570507`*^9, 
   3.573605964039504*^9, 3.5736059994827666`*^9, 3.5736060984805403`*^9, {
   3.573606625978094*^9, 3.5736066285832987`*^9}, 3.5736158211856375`*^9, 
   3.5736160693318305`*^9, 3.5736161223258615`*^9, {3.573616182105281*^9, 
   3.573616182321293*^9}, 3.573616236132371*^9, 3.5736164232410727`*^9, {
   3.573692298777257*^9, 3.5736923146424847`*^9}, {3.574885935637336*^9, 
   3.5748859559173717`*^9}, {3.574886059891554*^9, 3.574886060063154*^9}, 
   3.5748861763301587`*^9, 3.57488628534315*^9, 3.575772379966265*^9, {
   3.5757724207015953`*^9, 3.5757725117098007`*^9}, {3.575772591741378*^9, 
   3.5757725927734375`*^9}, {3.575772672229982*^9, 3.5757726811024895`*^9}, 
   3.5757893795025835`*^9, {3.5759741275789194`*^9, 3.5759741492005577`*^9}, 
   3.5759742049082556`*^9, 3.576873260313571*^9, {3.5768733266760874`*^9, 
   3.5768733636481524`*^9}, {3.576961566809566*^9, 3.576961566965566*^9}, 
   3.5778715430075555`*^9, {3.577871696168316*^9, 3.5778716991834884`*^9}, {
   3.577871760471994*^9, 3.5778717880315704`*^9}, 3.5778726548461494`*^9, 
   3.577996394467312*^9, {3.577996527223545*^9, 3.5779965332763557`*^9}, 
   3.5780020367826004`*^9, {3.592182738877136*^9, 3.592182738877136*^9}, 
   3.592182948245104*^9, 3.592183023967637*^9, {3.5921894148308616`*^9, 
   3.5921894250800796`*^9}, 3.592189468058155*^9, 3.59218951063063*^9, {
   3.5921897614790707`*^9, 3.5921897687174835`*^9}, {3.5921898718180647`*^9, 
   3.5921898746416693`*^9}, 3.592190089781647*^9, 3.599383290830182*^9, 
   3.606352387733818*^9, {3.6063536447692275`*^9, 3.6063536521324406`*^9}, {
   3.6063536981837215`*^9, 3.606353720959761*^9}, {3.6063540035186653`*^9, 
   3.60635401782389*^9}, {3.606354435187023*^9, 3.606354443579838*^9}, {
   3.606355512883435*^9, 3.6063555243806553`*^9}, {3.606355667978907*^9, 
   3.606355694748554*^9}, {3.6063559545934114`*^9, 3.60635597637105*^9}, 
   3.6063566455526247`*^9, 3.606364112430215*^9, {3.606364199790369*^9, 
   3.606364203237975*^9}, 3.6063646197275066`*^9, 3.606367676083275*^9, {
   3.625306705256344*^9, 3.6253067345531955`*^9}, {3.6253071577203393`*^9, 
   3.625307191275998*^9}, {3.6253072256584587`*^9, 3.625307230572467*^9}, 
   3.625307268620934*^9, {3.625307476549307*^9, 3.6253074769705076`*^9}, {
   3.6253081892637596`*^9, 3.6253082416486516`*^9}, 3.6253530322619123`*^9, 
   3.6253833808227205`*^9, 3.6253834171083846`*^9, 3.6291872118269997`*^9, {
   3.629187263494291*^9, 3.629187284616728*^9}, 3.6291873266120014`*^9, 
   3.629187811262854*^9, 3.629187845489314*^9, 3.6291893763632035`*^9, {
   3.6292328386751413`*^9, 3.6292328506403627`*^9}, 3.6294129869649906`*^9, {
   3.629681940868216*^9, 3.629681967840663*^9}, {3.629683072302611*^9, 
   3.629683104204667*^9}, 3.6296834256744313`*^9, 3.62968375522501*^9, 
   3.6296908987102036`*^9, 3.630130105748337*^9, 3.6301868181132655`*^9, {
   3.630191355032058*^9, 3.6301913594624653`*^9}, 3.6301916306065416`*^9, {
   3.6301917699615865`*^9, 3.63019186320295*^9}, {3.630192661908753*^9, 
   3.6301926650911584`*^9}, {3.6301964589726305`*^9, 3.6301964616870356`*^9}, 
   3.630397911894512*^9, 3.631494715345451*^9, {3.631494897830179*^9, 
   3.6314948980173793`*^9}, 3.6325489741749687`*^9, 3.632549352439234*^9, 
   3.632549606008894*^9, {3.6325498031224484`*^9, 3.6325498272824984`*^9}, 
   3.6325498689969716`*^9, 3.632603972588211*^9, {3.6326052512664576`*^9, 
   3.63260525814607*^9}, 3.6326054984956923`*^9, 3.632789700000079*^9, 
   3.632789744647358*^9, {3.632789801166257*^9, 3.632789811633875*^9}, 
   3.6327900076794195`*^9, {3.6327981115517917`*^9, 3.632798133781831*^9}, 
   3.632798223201188*^9, {3.6328077370497065`*^9, 3.632807759903747*^9}, 
   3.6328139472210455`*^9, 3.632814030665592*^9, {3.6328142522895823`*^9, 
   3.6328142524611826`*^9}, {3.632862843129942*^9, 3.632862843800743*^9}, 
   3.63286308115516*^9, 3.6328903786025143`*^9, {3.634503967294235*^9, 
   3.6345039716310434`*^9}, {3.634505033567916*^9, 3.6345050472023396`*^9}, {
   3.6345052904809732`*^9, 3.6345052910893745`*^9}, {3.634505400581773*^9, 
   3.634505441906245*^9}, {3.634505494244337*^9, 3.6345055070207596`*^9}, {
   3.6345055797168875`*^9, 3.6345055799040875`*^9}, 3.6345562254439487`*^9, {
   3.6345563039276867`*^9, 3.6345563048948884`*^9}, 3.634556840334629*^9, {
   3.636074869723259*^9, 3.6360748731240654`*^9}, 3.6360754084218063`*^9, {
   3.6360755439392443`*^9, 3.636075558915271*^9}, {3.636075874067024*^9, 
   3.6360758917886553`*^9}, {3.6364953559316864`*^9, 3.636495366508505*^9}, {
   3.6364954773934994`*^9, 3.636495502852744*^9}, {3.636495534396*^9, 
   3.6364955371572046`*^9}, {3.6364955872176924`*^9, 3.63649567827066*^9}, 
   3.636495724504749*^9, {3.636495894244254*^9, 3.6364959362083282`*^9}, {
   3.6364963754739*^9, 3.636496380231908*^9}, {3.636497028007847*^9, 
   3.6364970357610607`*^9}, {3.6367624922783546`*^9, 
   3.6367624954763603`*^9}, {3.6367923982578783`*^9, 3.636792403624288*^9}, 
   3.725592414137775*^9, 3.72559253645759*^9, {3.725595004057525*^9, 
   3.725595014041543*^9}, 3.7255952212879066`*^9, 3.7255953656817603`*^9, 
   3.7255956160982013`*^9, {3.725595650901862*^9, 3.7255956517442636`*^9}, {
   3.725595707529962*^9, 3.7255957181379805`*^9}, {3.7255957501492367`*^9, 
   3.7255957539400434`*^9}, {3.7255961085130663`*^9, 3.72559611623508*^9}, 
   3.725596322436242*^9, 3.7255964148976045`*^9, {3.7257712777690277`*^9, 
   3.7257712801558323`*^9}, 3.725773155528726*^9, 3.725774260463067*^9, {
   3.7257742995099354`*^9, 3.7257743102739544`*^9}, 3.725774372830064*^9, 
   3.7257745020094986`*^9, 3.7258490354189854`*^9, 3.72585211170679*^9, 
   3.7258523136023445`*^9, 3.725852357064021*^9, 3.725852412709319*^9, 
   3.725852690077806*^9, {3.7258529112549944`*^9, 3.725852914297*^9}, 
   3.725866558776852*^9, 3.726913461475872*^9, {3.7269135067471514`*^9, 
   3.7269135067471514`*^9}, 3.7269135736712694`*^9, 3.7269142332092276`*^9, 
   3.726914379943085*^9, {3.72691444512*^9, 3.72691444551*^9}, 
   3.726914522230935*^9, {3.7269150197170105`*^9, 3.726915029623028*^9}, 
   3.7269154806118207`*^9, 3.7269429541638784`*^9, 3.726943055174056*^9, 
   3.7269527416378713`*^9, {3.7325816271502795`*^9, 3.73258171281003*^9}, {
   3.732658455138345*^9, 3.7326584615967565`*^9}, 3.7326589054523363`*^9, 
   3.7326593484475155`*^9, 3.732665438975348*^9, {3.7402181674777236`*^9, 
   3.740218192921368*^9}, 3.7402182516554713`*^9, 3.7402183778596935`*^9, {
   3.7402184897074966`*^9, 3.7402184899102974`*^9}, 3.740218703693073*^9, 
   3.740219316174549*^9, 3.740220725664626*^9, 3.7406235299785748`*^9, 
   3.7407786300441055`*^9, {3.7407787374658937`*^9, 3.7407787515059185`*^9}, 
   3.7407792597116137`*^9, {3.740779291410869*^9, 3.74077929150447*^9}, {
   3.7407794435579367`*^9, 3.7407794537603545`*^9}, {3.740779489359617*^9, 
   3.7407794895936174`*^9}, {3.740779670623536*^9, 3.7407796794843516`*^9}, 
   3.740780547224676*^9, 3.740780580078334*^9, {3.7407807829566903`*^9, 
   3.740780802675125*^9}, 3.7407824785895987`*^9, {3.740783120387927*^9, 
   3.7407831238823338`*^9}, 3.740784281084571*^9, 3.7407843527561016`*^9, 
   3.7407847831226892`*^9, 3.740792340872752*^9, 3.740795723424296*^9, 
   3.7407958523585224`*^9, 3.7407962560248313`*^9, 3.740796299814108*^9, 
   3.740796868840708*^9, 3.7407969075287757`*^9, {3.7411140798071146`*^9, 
   3.7411140827087193`*^9}, 3.7411141905985093`*^9, {3.7411142267125726`*^9, 
   3.7411142268685727`*^9}, {3.741114330047154*^9, 3.7411143512943916`*^9}, {
   3.741114411151696*^9, 3.741114418093709*^9}, 3.7411667320210295`*^9, 
   3.7411668087419643`*^9, 3.741202221929366*^9, 3.741892837970529*^9, 
   3.7446637237292566`*^9, 3.744664188516473*^9, 3.7446656128157234`*^9, 
   3.7446656519561925`*^9, 3.744742920198707*^9, 3.744748993426978*^9, 
   3.744875562242749*^9, 3.7452127485518837`*^9, {3.7452134494767146`*^9, 
   3.7452134887263837`*^9}, 3.7452135890501595`*^9, 3.7452136909027386`*^9, {
   3.745213776375289*^9, 3.745213824891374*^9}, {3.7452153796921053`*^9, 
   3.7452153895513225`*^9}, {3.745215679480633*^9, 3.7452156795430326`*^9}, {
   3.7452158443729224`*^9, 3.7452158470717273`*^9}, 3.745216263249258*^9, 
   3.745220775675985*^9, 3.74605200870955*^9, {3.746054459278658*^9, 
   3.746054461899462*^9}, {3.746054502833934*^9, 3.7460545099319468`*^9}, {
   3.7460545513812194`*^9, 3.746054580834071*^9}, 3.746054715181507*^9, {
   3.746055056728507*^9, 3.746055078334545*^9}, {3.7460696676769714`*^9, 
   3.746069675196185*^9}, {3.746069717519059*^9, 3.7460697568623285`*^9}, {
   3.746069787937583*^9, 3.74606981489443*^9}, 3.746073742165717*^9, 
   3.7460738199942536`*^9, 3.74607396574531*^9, {3.7460739981621666`*^9, 
   3.7460740214218073`*^9}, {3.7460741612292533`*^9, 3.7460741660964613`*^9}, 
   3.7460742930026846`*^9, 3.7469916783892336`*^9, {3.746995596376917*^9, 
   3.7469956449086018`*^9}, 3.746995874717006*^9, {3.746995951484741*^9, 
   3.7469959562115493`*^9}, {3.7469960042752333`*^9, 
   3.7469960100160437`*^9}, {3.7470008209349375`*^9, 3.747000823181341*^9}, {
   3.747000889419058*^9, 3.7470008910414605`*^9}, {3.7470280589399815`*^9, 
   3.7470280614983854`*^9}, {3.748111197232164*^9, 3.7481112317394247`*^9}, 
   3.74811147967066*^9, 3.7481115205271316`*^9, 3.748111692642234*^9, 
   3.7481117874748*^9, 3.748112631498683*^9, 3.748112775284136*^9, 
   3.7481129517516456`*^9, {3.748113151322796*^9, 3.7481131579684076`*^9}, 
   3.7481148652730074`*^9, 3.748152386065356*^9, 3.7481567738382626`*^9, 
   3.749668436049493*^9, 3.75071693891677*^9, 3.7507175127325783`*^9, 
   3.7507180095666513`*^9, 3.7507180789087734`*^9, 3.7507182048633947`*^9, 
   3.7507183299756145`*^9, {3.750719880875539*^9, 3.750719881031539*^9}, 
   3.750720705694188*^9, 3.7507440057557216`*^9, {3.750744086719864*^9, 
   3.750744089496669*^9}, 3.7509082696490107`*^9, 3.7509083249043074`*^9, 
   3.750911286246544*^9, 3.7509118911532063`*^9, 3.7509121115503936`*^9, {
   3.750923632836231*^9, 3.750923632961032*^9}, 3.750925073460763*^9, 
   3.750927718913814*^9, 3.7513499450769176`*^9, 3.7513500249334583`*^9, 
   3.751350205394575*^9, {3.751357124693128*^9, 3.751357125535529*^9}, 
   3.7513572227785015`*^9, {3.7513577543338346`*^9, 3.7513577545366354`*^9}, {
   3.7514075994397964`*^9, 3.7514076315758533`*^9}, 3.755049981992358*^9, 
   3.7550500823161345`*^9, 3.7550501621414747`*^9, {3.755050424627536*^9, 
   3.75505042743554*^9}, 3.7550509452316504`*^9, {3.7550519417295938`*^9, 
   3.755051975534853*^9}, 3.755137950815219*^9, {3.755138029314557*^9, 
   3.755138038986574*^9}, 3.755138086785058*^9, {3.755138188762437*^9, 
   3.7551382198688917`*^9}, 3.755138327743081*^9, {3.7551385822731285`*^9, 
   3.7551385983567567`*^9}, {3.7551386797264996`*^9, 3.755138682924505*^9}, {
   3.755138886446863*^9, 3.7551388934044757`*^9}, 3.75514146393878*^9, 
   3.7551414955444355`*^9, 3.755142322019229*^9, 3.755143438106188*^9, 
   3.755147618487777*^9, 3.7552236306785617`*^9, 3.755223735116352*^9, {
   3.755225733931464*^9, 3.7552257365054693`*^9}, {3.755227512081214*^9, 
   3.755227512237214*^9}, 3.7552279693180175`*^9, 3.7642903496367607`*^9, 
   3.7642905384454937`*^9, {3.764290573888756*^9, 3.7642906052136106`*^9}, 
   3.764290664977316*^9, {3.7642906962553706`*^9, 3.7642907377670436`*^9}, 
   3.7642907697626996`*^9, {3.7642908862013044`*^9, 3.7642908919733143`*^9}, {
   3.764290988459484*^9, 3.7642909895202856`*^9}, 3.7642916178573933`*^9, 
   3.7642946900651903`*^9, 3.764304233178358*^9, 3.764315634831588*^9, 
   3.7643178571376925`*^9, 3.7643199679870043`*^9, 3.7646643825688667`*^9, 
   3.7646644254533424`*^9, {3.7646670587823772`*^9, 3.7646670614031816`*^9}, {
   3.7646689741957426`*^9, 3.7646689743361425`*^9}, 3.7648879733065042`*^9, 
   3.7648880095453677`*^9, 3.764888905544944*^9, {3.7648904306286244`*^9, 
   3.764890430784625*^9}, 3.764890639856192*^9, 3.7648920316777287`*^9, 
   3.7648920799130135`*^9, {3.7649026496400437`*^9, 3.764902649811644*^9}, 
   3.765060795861064*^9, 3.765170874688287*^9, 3.7651709275255795`*^9, 
   3.7651715934707565`*^9, 3.765171678553306*^9, 3.7651720873988247`*^9, 
   3.7652588609279366`*^9, 3.7652589119400263`*^9, {3.7652678534549417`*^9, 
   3.765267853720142*^9}, 3.766219677048067*^9, 3.766219733644967*^9, 
   3.7662202150930123`*^9, 3.7662231492289677`*^9, 3.7662232546071525`*^9, 
   3.7664261773697233`*^9, {3.7664771999234896`*^9, 3.766477221467128*^9}, {
   3.7664774867923937`*^9, 3.7664775002552176`*^9}, {3.7688458990388994`*^9, 
   3.7688459132349243`*^9}, 3.7688464502450686`*^9, 3.7688469138338833`*^9, 
   3.7919252574896*^9, 3.7919253465779333`*^9, {3.791925415764722*^9, 
   3.7919254377907343`*^9}, {3.791925604735676*^9, 3.791925624980929*^9}, 
   3.791925707745304*^9, 3.791925763091635*^9, {3.791925911291008*^9, 
   3.7919259140403547`*^9}, {3.7919260222877755`*^9, 3.7919260262243795`*^9}, 
   3.7919263244810195`*^9, 3.7919272129150743`*^9, 3.7919273025813866`*^9, 
   3.79194113621521*^9, 3.791941232926713*^9, {3.791941514157159*^9, 
   3.7919415143290224`*^9}, 3.791943103216889*^9, 3.791945596183156*^9, 
   3.7919456441249638`*^9, 3.791946082173215*^9, 3.7919462651924844`*^9, 
   3.7921427775483007`*^9, 3.7921428897561445`*^9, {3.7921430152576857`*^9, 
   3.7921430359090414`*^9}, 3.7921430673703427`*^9, {3.792143141259096*^9, 
   3.7921431417121143`*^9}, 3.792143242125839*^9, 3.792143486850278*^9, {
   3.7921450052007465`*^9, 3.792145013042673*^9}, {3.7921451058956823`*^9, 
   3.7921451214857616`*^9}, 3.7921455314668036`*^9, {3.792206627246333*^9, 
   3.792206627246333*^9}, 3.792206754231901*^9, 3.79220685052157*^9, 
   3.7922078842917633`*^9, {3.7922705977593207`*^9, 3.7922705977593207`*^9}, {
   3.7922709118099704`*^9, 3.792270911903698*^9}, 3.792271385291582*^9, 
   3.792272246914014*^9, 3.79253865659698*^9, 3.7925389383292637`*^9, {
   3.79253897772618*^9, 3.7925390027310505`*^9}, 3.792539084603735*^9, 
   3.792539165209653*^9, {3.7925532584724584`*^9, 3.792553265876953*^9}, {
   3.7925536738897276`*^9, 3.7925536950096927`*^9}, 3.792553901929451*^9, 
   3.7925547774031987`*^9, 3.7926564191426325`*^9, 3.802546784503578*^9, 
   3.8025468351166477`*^9, {3.802547157478155*^9, 3.8025471596963935`*^9}, 
   3.8025530393291664`*^9, {3.802553145023003*^9, 3.8025531542395735`*^9}, {
   3.8025532156626034`*^9, 3.802553248326777*^9}, {3.8025534886879206`*^9, 
   3.802553504246724*^9}, {3.8025797911758394`*^9, 3.8025798028293123`*^9}, {
   3.8025800334054585`*^9, 3.802580033577258*^9}, 3.802582705776685*^9, 
   3.807854574938098*^9, 3.8078546986654563`*^9, {3.8078547333297863`*^9, 
   3.8078547854564734`*^9}, 3.80785486835991*^9, 3.807855055961532*^9, 
   3.816906071203289*^9, 3.8169062277454643`*^9, {3.816906300915784*^9, 
   3.8169063034933043`*^9}, 3.8169064130613346`*^9, 3.816906495104565*^9, 
   3.816906610405632*^9, 3.816906749379136*^9, 3.816907241217867*^9, 
   3.8169118516709604`*^9, {3.8208065480383034`*^9, 3.8208065503971148`*^9}, {
   3.8208066149286785`*^9, 3.820806624051549*^9}, {3.8208067216221795`*^9, 
   3.8208067220908184`*^9}, 3.8208068322209473`*^9, 3.820807172858101*^9, {
   3.8278746045256357`*^9, 3.8278746309881845`*^9}, {3.8282860508815856`*^9, 
   3.8282860579267845`*^9}, {3.8282861859735947`*^9, 3.8282862018448706`*^9}, 
   3.828286468280572*^9, 3.828553587454216*^9, 3.8285574082753267`*^9, {
   3.8286362338967395`*^9, 3.828636255175177*^9}, 3.828637664454053*^9, 
   3.828718689983182*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571686237884`*^9, 3.848257192868057*^9}, {3.84825923472919*^9, 
   3.848259236681822*^9}, 3.848259612007312*^9, {3.8482597677280135`*^9, 
   3.848259771133461*^9}, {3.8482598468578053`*^9, 3.8482598497008877`*^9}, {
   3.848260094465921*^9, 3.8482601019797363`*^9}, {3.854761764009829*^9, 
   3.854761764009829*^9}, 3.854761812763962*^9, 3.8547619184957533`*^9, {
   3.85476213510832*^9, 3.8547621352801824`*^9}, {3.854762175741544*^9, 
   3.854762196820649*^9}, 3.854763397808587*^9, 3.854911091585896*^9, 
   3.883168549514434*^9, 3.8831685918481736`*^9, {3.8831693368284187`*^9, 
   3.8831693369690075`*^9}, 3.8831700820047045`*^9, {3.88326856715734*^9, 
   3.883268567688492*^9}, {3.956529075649271*^9, 3.956529075649271*^9}, 
   3.956529278561458*^9, 3.956529333579769*^9, 3.956529375257483*^9, {
   3.956529477764713*^9, 3.9565294832321777`*^9}, {3.95652970749885*^9, 
   3.9565297214487343`*^9}, {3.9565301959560966`*^9, 3.9565302258865724`*^9}, 
   3.956530334767271*^9, 3.9565304297655487`*^9, 3.956541561095746*^9, 
   3.9565603591403613`*^9, 3.956560485579527*^9, 3.9565605193840313`*^9, 
   3.9565608478858576`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0270.png\>\"", ",", "frpConfHypergeomF3", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533955185636678*^9, 3.533955193530292*^9}, 
   3.5470089020736527`*^9, 3.5470089906974087`*^9, {3.5501987606920385`*^9, 
   3.5501987608792386`*^9}, 3.550198849300194*^9, {3.5504693214945307`*^9, 
   3.55046932160373*^9}, {3.5531142987603564`*^9, 3.55311430097556*^9}, 
   3.553114600798087*^9, 3.5531850697594075`*^9, 3.55318527036016*^9, 
   3.5531900910817485`*^9, 3.553190165072678*^9, 3.5531908750251255`*^9, {
   3.553190970122893*^9, 3.553190970310093*^9}, {3.5532137997388144`*^9, 
   3.5532138043876224`*^9}, {3.5532141363562055`*^9, 3.553214165434656*^9}, {
   3.556389606160061*^9, 3.5563896074548635`*^9}, 3.556389890454961*^9, {
   3.7325812332963877`*^9, 3.732581233717589*^9}, 3.7326535116184597`*^9, {
   3.7326591364731426`*^9, 3.732659136644743*^9}, 3.7326593484631157`*^9, 
   3.7402167509844255`*^9, 3.7402182539798756`*^9, 3.740219001927597*^9, 
   3.7407786321033087`*^9, {3.740780622260808*^9, 3.7407806224012084`*^9}, 
   3.740782321871723*^9, {3.7407957164042835`*^9, 3.740795721505492*^9}, 
   3.7411140854231243`*^9, {3.74111413420441*^9, 3.7411141344228106`*^9}, 
   3.741166727684222*^9, {3.7411668654792643`*^9, 3.741166865619664*^9}, 
   3.7414211246988482`*^9, 3.7446637267400618`*^9, 3.7446644002400446`*^9, 
   3.7446656128157234`*^9, {3.744665930744282*^9, 3.744665930884682*^9}, 
   3.7452127519526896`*^9, 3.7452127982691708`*^9, 3.7452152179426208`*^9, 
   3.7452153867901173`*^9, 3.7460520107999535`*^9, {3.7460520534036283`*^9, 
   3.74605205424603*^9}, 3.746055118879016*^9, 3.7469914856820946`*^9, {
   3.746991527770969*^9, 3.746991555866618*^9}, 3.7469916833032417`*^9, 
   3.7481112017873716`*^9, {3.7481113416104174`*^9, 3.7481113417820177`*^9}, 
   3.748112629455079*^9, 3.7481132179193125`*^9, {3.7507168447394047`*^9, 
   3.7507168472198095`*^9}, 3.7507169437995787`*^9, 3.7509079022215652`*^9, {
   3.75090794495004*^9, 3.75090794512164*^9}, 3.7509082696490107`*^9, 
   3.7513500249334583`*^9, 3.7513500920291758`*^9, {3.7513503492580276`*^9, 
   3.751350349445228*^9}, 3.7514002242042093`*^9, {3.755049692159449*^9, 
   3.7550496922998495`*^9}, {3.7550498033876443`*^9, 3.7550498039024453`*^9}, 
   3.755049981992358*^9, 3.762283566429557*^9, {3.762283611841237*^9, 
   3.7622836119660373`*^9}, 3.7622837156906195`*^9, 3.764280969439039*^9, 
   3.7642810018246965`*^9, {3.764281074411624*^9, 3.7642810945668592`*^9}, {
   3.764281227135892*^9, 3.7642812273854923`*^9}, 3.7642813042000275`*^9, 
   3.764291565768902*^9, 3.7646644254533424`*^9, {3.7646645461195545`*^9, 
   3.7646645463223543`*^9}, {3.7648874056839075`*^9, 3.7648874058399076`*^9}, 
   3.7648879733221045`*^9, {3.7648894222178516`*^9, 3.7648894224050517`*^9}, {
   3.7650602476465006`*^9, 3.765060247818101*^9}, 3.765060798138668*^9, 
   3.7650876836644077`*^9, {3.765170820041391*^9, 3.765170820322191*^9}, 
   3.765170874688287*^9, 3.7652589119400263`*^9, {3.765259071731107*^9, 
   3.7652590718091073`*^9}, {3.7662195948515224`*^9, 3.7662195957563243`*^9}, 
   3.766219677048067*^9, 3.766220217308216*^9, 3.7664771999234896`*^9, 
   3.7664773393097343`*^9, 3.766477486807994*^9, 3.766477573590946*^9, {
   3.7666119431449013`*^9, 3.7666119433165016`*^9}, {3.7673939377297125`*^9, 
   3.7673939378857126`*^9}, 3.7688458990388994`*^9, 3.768845992155463*^9, 
   3.7688461150368786`*^9, 3.7919252574896*^9, 3.791926052499424*^9, {
   3.791926095989151*^9, 3.791926096598382*^9}, 3.791941133887636*^9, 
   3.7919412657158723`*^9, {3.7919455983389053`*^9, 3.7919456033221006`*^9}, 
   3.7921427775483007`*^9, {3.792144252867916*^9, 3.7921442530085073`*^9}, 
   3.792145007731429*^9, 3.792145059016163*^9, 3.792206627246333*^9, {
   3.792208164803473*^9, 3.792208165553295*^9}, 3.7922705977593207`*^9, {
   3.7922707301029916`*^9, 3.7922707302904463`*^9}, 3.79253865659698*^9, 
   3.7925540406154003`*^9, 3.8025468380534554`*^9, {3.8025469017103243`*^9, 
   3.8025469097240615`*^9}, {3.8025516449002275`*^9, 3.802551645056441*^9}, {
   3.8025797876922874`*^9, 3.802579794206377*^9}, 3.8078544401712985`*^9, {
   3.8078545001470075`*^9, 3.807854500934877*^9}, 3.8078545785694313`*^9, 
   3.8169060743744335`*^9, 3.816906826079885*^9, 3.8169068668827724`*^9, 
   3.820806437814374*^9, {3.8208064682759457`*^9, 3.8208064684790215`*^9}, 
   3.820806553490138*^9, {3.8278746045256357`*^9, 3.8278746310038056`*^9}, 
   3.827874859287332*^9, {3.827874913149688*^9, 3.827874914102568*^9}, 
   3.828286652268653*^9, 3.8482570386857076`*^9, 3.848257074645941*^9, {
   3.84825712863323*^9, 3.8482571287582006`*^9}, 3.8547617640254436`*^9, {
   3.854761842820959*^9, 3.8547618694084587`*^9}, {3.8831685918481736`*^9, 
   3.8831686183106723`*^9}, {3.8831686600976796`*^9, 3.8831686602538943`*^9}, 
   3.9565290756648955`*^9, {3.9565292025011487`*^9, 3.956529227448423*^9}, 
   3.9565603555786777`*^9, 3.956560451712392*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ap3dConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"AbsArgPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1.9"}], "-", 
       RowBox[{"1.3", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{"1.3", "+", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"-", "10"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0007", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0005", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.528619442909766*^9, 3.528619451910281*^9}, {
   3.5286214386949186`*^9, 3.5286214646354027`*^9}, {3.5286222532055063`*^9, 
   3.528622288166506*^9}, 3.52866506133381*^9, 3.5286651054974875`*^9, {
   3.5286651514707685`*^9, 3.528665155292775*^9}, {3.5287006732862062`*^9, 
   3.528700705625063*^9}, {3.5287008793313684`*^9, 3.5287008818741727`*^9}, {
   3.5287009125126266`*^9, 3.5287009144938297`*^9}, {3.5289198836377797`*^9, 
   3.5289199933371725`*^9}, {3.5289200401996546`*^9, 
   3.5289200576560855`*^9}, {3.5289201204305954`*^9, 
   3.5289201283242097`*^9}, {3.5289213102134857`*^9, 3.5289213711159925`*^9}, 
   3.5289214070272555`*^9, {3.52892258770053*^9, 3.528922633018609*^9}, {
   3.528922704669535*^9, 3.5289227124695487`*^9}, {3.5289237056920934`*^9, 
   3.528923718624516*^9}, 3.5289237912270436`*^9, {3.528923835453121*^9, 
   3.5289238359055223`*^9}, {3.52892390278284*^9, 3.5289239065580463`*^9}, 
   3.5289239438421116`*^9, {3.528923987787389*^9, 3.528924004978619*^9}, {
   3.5289240667547274`*^9, 3.528924087986365*^9}, {3.5289243401296077`*^9, 
   3.528924344294815*^9}, {3.5289245120575094`*^9, 3.5289245256919336`*^9}, {
   3.5289245779988256`*^9, 3.5289246058916745`*^9}, 3.5289246438465414`*^9, {
   3.5301781945730553`*^9, 3.530178289296421*^9}, {3.530178945963975*^9, 
   3.5301789486471796`*^9}, {3.5301820319841957`*^9, 3.530182109703532*^9}, {
   3.5339560194937434`*^9, 3.5339560600070143`*^9}, {3.5339561008634863`*^9, 
   3.53395611423271*^9}, {3.5339561603307905`*^9, 3.5339561646675987`*^9}, {
   3.5339561968816547`*^9, 3.533956209845278*^9}, {3.534022431253952*^9, 
   3.5340224314567523`*^9}, 3.534022572481*^9, {3.534022607705862*^9, 
   3.534022607924262*^9}, {3.5345620477651424`*^9, 3.5345620818512025`*^9}, {
   3.534562122941674*^9, 3.5345621667933517`*^9}, {3.534648397811719*^9, 
   3.534648401118925*^9}, {3.534709801160247*^9, 3.5347098283822947`*^9}, {
   3.5347098611891527`*^9, 3.5347098619223537`*^9}, {3.534709907926834*^9, 
   3.5347099086288357`*^9}, {3.534710222192987*^9, 3.5347102332066064`*^9}, 
   3.5347103216587615`*^9, {3.5347106722693777`*^9, 3.534710675982184*^9}, 
   3.5470089462373304`*^9, {3.5470091278996496`*^9, 3.5470091547472963`*^9}, {
   3.5470094371389923`*^9, 3.547009443207403*^9}, 3.547009595901272*^9, {
   3.547009818014462*^9, 3.5470098320856867`*^9}, {3.5470099040642133`*^9, 
   3.5470099184162383`*^9}, 3.5470100544952774`*^9, 3.547010367529028*^9, 
   3.550198810721326*^9, {3.550199038434926*^9, 3.550199045018138*^9}, {
   3.5501999115110607`*^9, 3.5501999141942654`*^9}, {3.55019997380197*^9, 
   3.55019997398917*^9}, 3.5502073133024054`*^9, 3.550207620982745*^9, {
   3.550207765158199*^9, 3.550207802863465*^9}, {3.55020859692346*^9, 
   3.550208598467862*^9}, {3.5502099531430416`*^9, 3.550209992720311*^9}, {
   3.550210137301365*^9, 3.550210139516569*^9}, {3.550210537442068*^9, 
   3.5502105388148704`*^9}, 3.550210684753127*^9, {3.553114489866292*^9, 
   3.5531145040935173`*^9}, 3.5531145564784093`*^9, 3.55311478447281*^9, {
   3.553114928071062*^9, 3.553114930255066*^9}, {3.5531151718526897`*^9, 
   3.5531152734400682`*^9}, {3.5531153988286963`*^9, 
   3.5531153999830985`*^9}, {3.5531841051629133`*^9, 3.5531841089225197`*^9}, 
   3.5531844703907547`*^9, {3.5531848141373587`*^9, 3.55318482037737*^9}, {
   3.564290330120206*^9, 3.564290330120206*^9}, {3.5642910712463074`*^9, 
   3.5642910895763397`*^9}, {3.5642912437514105`*^9, 3.564291261098641*^9}, {
   3.564291324902753*^9, 3.5642913279447584`*^9}, {3.564298881313227*^9, 
   3.564298910968879*^9}, 3.5645703399765744`*^9, {3.5645709011207676`*^9, 
   3.5645709125711875`*^9}, {3.5646321047687345`*^9, 
   3.5646321068747377`*^9}, {3.564706696754722*^9, 3.564706699547127*^9}, 
   3.5647067771728635`*^9, {3.564989627219633*^9, 3.564989637609251*^9}, 
   3.565030962442968*^9, {3.565152889292653*^9, 3.565152909557089*^9}, {
   3.565152945156351*^9, 3.565152963236783*^9}, 3.565153012439269*^9, 
   3.5651530922490096`*^9, {3.565162127699024*^9, 3.5651621308992076`*^9}, 
   3.565983845442522*^9, 3.56598387845218*^9, {3.5659904751889668`*^9, 
   3.5659904837065816`*^9}, 3.56599068772374*^9, 3.5659907302338142`*^9, {
   3.5659908215943756`*^9, 3.565990858936449*^9}, 3.5659913705393476`*^9, {
   3.566162100485265*^9, 3.566162102341668*^9}, {3.567196994409768*^9, 
   3.5671969959541707`*^9}, {3.567197054189073*^9, 3.567197061021885*^9}, {
   3.567197133858413*^9, 3.5671972115621495`*^9}, {3.5671973507731943`*^9, 
   3.5671973567168045`*^9}, {3.567197396247274*^9, 3.567197485604231*^9}, 
   3.5674580328183336`*^9, {3.567570200880618*^9, 3.5675702017074194`*^9}, {
   3.5675706469946012`*^9, 3.5675706511130085`*^9}, 3.5675897096419353`*^9, 
   3.5680246296369*^9, {3.568160274924254*^9, 3.568160309037122*^9}, {
   3.568160380558855*^9, 3.5681603947860794`*^9}, {3.568160466354613*^9, 
   3.5681604854178467`*^9}, 3.568160775578356*^9, {3.568160813751623*^9, 
   3.568160822394038*^9}, 3.570075555135485*^9, 3.570075606833976*^9, {
   3.570076573068473*^9, 3.5700766101497383`*^9}, {3.570086741011756*^9, 
   3.5700867466120763`*^9}, 3.570086991324073*^9, {3.570087119755419*^9, 
   3.570087155371456*^9}, {3.5700962095128574`*^9, 3.5700962258772864`*^9}, 
   3.5700962986358137`*^9, {3.570096349835104*^9, 3.570096368445937*^9}, 
   3.5700964717345185`*^9, 3.573604781666628*^9, 3.573604883878007*^9, 
   3.573604925826481*^9, {3.57360495952254*^9, 3.57360503919188*^9}, 
   3.573605070064334*^9, {3.573605328369588*^9, 3.573605331661194*^9}, 
   3.5736054416881866`*^9, {3.5736058843701644`*^9, 3.5736059731343203`*^9}, {
   3.5736060324456244`*^9, 3.5736060387012353`*^9}, 3.573606118386175*^9, 
   3.5736062033595247`*^9, 3.573606490725857*^9, {3.573692115976136*^9, 
   3.5736921224969473`*^9}, 3.574884949276402*^9, {3.574885006013702*^9, 
   3.574885007963705*^9}, {3.57577172896203*^9, 3.5757717849022293`*^9}, {
   3.575771839158333*^9, 3.5757719145096426`*^9}, {3.575772545302722*^9, 
   3.575772560950617*^9}, 3.5757894252461996`*^9, {3.575974174332202*^9, 
   3.5759741933330355`*^9}, {3.5767311834246573`*^9, 3.576731301158064*^9}, {
   3.576734520722247*^9, 3.5767345253398547`*^9}, {3.5767345693007317`*^9, 
   3.576734571297536*^9}, 3.5767349788482513`*^9, 3.5767427797108574`*^9, {
   3.5767839288211775`*^9, 3.5767839425180016`*^9}, 3.5767840176165333`*^9, {
   3.5767965812116947`*^9, 3.576796592521714*^9}, 3.577871510016669*^9, {
   3.57787163504882*^9, 3.577871661200316*^9}, {3.5778717168644996`*^9, 
   3.577871730870301*^9}, {3.577871778560028*^9, 3.577871806259613*^9}, 
   3.5778718509931717`*^9, {3.5778726345519886`*^9, 3.5778726367521143`*^9}, {
   3.5779963658724623`*^9, 3.577996367728865*^9}, 3.578002028108985*^9, 
   3.5921826867730446`*^9, 3.592182932910277*^9, {3.592182973563948*^9, 
   3.5921829890703754`*^9}, {3.5921894432385116`*^9, 3.59218944813692*^9}, 
   3.592189480928178*^9, 3.5921896208916235`*^9, {3.5921896765369215`*^9, 
   3.5921896875193405`*^9}, {3.592189778717101*^9, 3.592189837654004*^9}, 
   3.606352358951768*^9, {3.6063524969964104`*^9, 3.6063525015360184`*^9}, {
   3.6063526625511017`*^9, 3.6063527326732244`*^9}, {3.6063527650432816`*^9, 
   3.6063527755264997`*^9}, {3.606353335280284*^9, 3.6063533646707354`*^9}, 
   3.60635353794024*^9, 3.6063545635752487`*^9, {3.6063546892490697`*^9, 
   3.6063547050674973`*^9}, {3.6063552211473227`*^9, 3.606355223690127*^9}, {
   3.6063552577605867`*^9, 3.606355272190612*^9}, {3.6063553038430676`*^9, 
   3.606355338163128*^9}, {3.606355581851156*^9, 3.606355644547666*^9}, {
   3.60636212821593*^9, 3.6063621434727573`*^9}, {3.6063647301913004`*^9, 
   3.606364732328504*^9}, 3.606367653822036*^9, {3.606423653579423*^9, 
   3.606423662861439*^9}, 3.6064237042951117`*^9, 3.6064240186796646`*^9, 
   3.6064240824057765`*^9, 3.6064352530456715`*^9, 3.625306348124917*^9, {
   3.625306422349847*^9, 3.6253064464050894`*^9}, {3.625306510552402*^9, 
   3.625306553920478*^9}, {3.625306755270032*^9, 3.6253068394009795`*^9}, 
   3.625306876669445*^9, 3.625307106474249*^9, 3.6253080361026907`*^9, 
   3.6253565393719177`*^9, 3.6253833999639544`*^9, 3.6253834309924088`*^9, 
   3.6291871583501062`*^9, {3.6291872318262353`*^9, 3.629187239704249*^9}, {
   3.6291873056923647`*^9, 3.6291873143815804`*^9}, {3.6291875784324455`*^9, 
   3.6291876127525053`*^9}, {3.629189364101582*^9, 3.629189366394786*^9}, {
   3.629232868970395*^9, 3.629232869173195*^9}, 3.629412973595767*^9, {
   3.629681734167853*^9, 3.6296817892827497`*^9}, {3.6296820677432384`*^9, 
   3.6296821134157267`*^9}, {3.6296821492957897`*^9, 3.6296821592174067`*^9}, 
   3.6296822142855034`*^9, 3.6296823447797327`*^9, {3.6296823820481987`*^9, 
   3.6296823873678074`*^9}, 3.6296824244022727`*^9, {3.629682533259264*^9, 
   3.629682571479331*^9}, {3.6296864438997335`*^9, 3.6296864498121443`*^9}, 
   3.6301301056703367`*^9, 3.630186806038844*^9, {3.630187005195995*^9, 
   3.6301870543204813`*^9}, 3.630187116294997*^9, {3.6301872101759624`*^9, 
   3.630187240518016*^9}, {3.6301879818625174`*^9, 3.630188037336215*^9}, {
   3.6301880817139006`*^9, 3.6301881292739916`*^9}, {3.630192463897605*^9, 
   3.6301924663624096`*^9}, {3.6325489266416855`*^9, 3.6325489436145153`*^9}, 
   3.632549332330798*^9, {3.6325493823600864`*^9, 3.6325493932021055`*^9}, {
   3.632549475316257*^9, 3.632549494769491*^9}, 3.6325495787244463`*^9, {
   3.63254965087018*^9, 3.6325496533193846`*^9}, {3.632549689417848*^9, 
   3.632549695548659*^9}, {3.632549725609912*^9, 3.632549731350722*^9}, 
   3.632549777632004*^9, {3.6326038339351673`*^9, 3.6326038351987696`*^9}, 
   3.6326052431856437`*^9, 3.632605279237307*^9, {3.6327896696112256`*^9, 
   3.63278967761404*^9}, 3.632789733462138*^9, 3.632789829792307*^9, 
   3.632789870211978*^9, 3.632789986728583*^9, 3.632798118478204*^9, 
   3.632798253418441*^9, {3.632805774254259*^9, 3.6328057895110865`*^9}, {
   3.6328080477542534`*^9, 3.6328080865671215`*^9}, {3.632808253050614*^9, 
   3.6328082534094143`*^9}, {3.632808331378351*^9, 3.632808360269602*^9}, {
   3.632808538526723*^9, 3.6328085720043817`*^9}, {3.632808631050485*^9, 
   3.632808642282505*^9}, {3.632808677908575*^9, 3.6328087181990533`*^9}, {
   3.6328089591882763`*^9, 3.63280900082475*^9}, {3.6328090336628075`*^9, 
   3.632809129977377*^9}, 3.632809186913084*^9, {3.632809216974337*^9, 
   3.632809236926772*^9}, 3.6328094921744204`*^9, {3.6328628083886805`*^9, 
   3.6328628144414916`*^9}, 3.632862901630045*^9, 3.6345039446897955`*^9, 
   3.634504022565132*^9, {3.634504657689049*^9, 3.6345046727742753`*^9}, {
   3.634504709243346*^9, 3.6345047653410444`*^9}, {3.634504880625247*^9, 
   3.6345049408257523`*^9}, {3.6345049821346254`*^9, 3.63450498472423*^9}, {
   3.6345052382364817`*^9, 3.634505239952485*^9}, {3.6345553893336797`*^9, 
   3.6345554050117073`*^9}, 3.6345568508334475`*^9, {3.636074809678754*^9, 
   3.6360748135943604`*^9}, {3.6360753609197226`*^9, 3.636075371137741*^9}, {
   3.6360754445046697`*^9, 3.6360754448322706`*^9}, 3.6360754780759287`*^9, {
   3.6360755150323935`*^9, 3.636075526139613*^9}, 3.6364953410960603`*^9, 
   3.636495413464587*^9, 3.636495521806778*^9, 3.636495566391656*^9, 
   3.6364955986993127`*^9, 3.63649578354646*^9, {3.636496052943333*^9, 
   3.636496059417344*^9}, {3.636496089572198*^9, 3.6364960983862133`*^9}, 
   3.6364962814213343`*^9, {3.6364969368880863`*^9, 3.636496945000101*^9}, 
   3.7255922261262445`*^9, 3.7255924668034678`*^9, 3.7255925194379597`*^9, {
   3.725594490754224*^9, 3.7255945013310423`*^9}, 3.7255952592895737`*^9, 
   3.725595809710141*^9, 3.725595872032251*^9, 3.725596154470747*^9, 
   3.7255964263948245`*^9, 3.7255994902566366`*^9, 3.7256016031495495`*^9, 
   3.7256016803852854`*^9, {3.7257699711575327`*^9, 3.7257699995651827`*^9}, 
   3.7257711688340364`*^9, 3.7257741402492557`*^9, 3.7257744781258564`*^9, 
   3.7258490150765495`*^9, {3.725852074641125*^9, 3.725852075202726*^9}, 
   3.725852252840238*^9, 3.725852386626073*^9, {3.7258526579417496`*^9, 
   3.725852658565751*^9}, 3.7258527373146887`*^9, {3.7258528441436768`*^9, 
   3.7258528480904837`*^9}, 3.726913461460272*^9, {3.7269135066691513`*^9, 
   3.7269135066847515`*^9}, 3.7269135736244693`*^9, {3.7269141963775625`*^9, 
   3.726914207671983*^9}, 3.726914350100233*^9, {3.726914421298758*^9, 
   3.7269144217511587`*^9}, 3.7269145086589117`*^9, 3.7269146264547186`*^9, 
   3.7269147176680784`*^9, {3.726914927879649*^9, 3.7269149421848745`*^9}, {
   3.726942862934918*^9, 3.726942875820541*^9}, 3.7269430613360662`*^9, 
   3.7269527172550287`*^9, {3.732581313558529*^9, 3.732581414007105*^9}, {
   3.7326583984946456`*^9, 3.732658428493498*^9}, {3.732658557942526*^9, 
   3.732658586022575*^9}, {3.732659178499616*^9, 3.732659189263635*^9}, 
   3.732662539865631*^9, {3.7402178619119854`*^9, 3.740217868385997*^9}, {
   3.7402181435784817`*^9, 3.740218149693692*^9}, {3.740218205900591*^9, 
   3.7402182074137936`*^9}, {3.740218302823561*^9, 3.740218347018439*^9}, {
   3.740218658655794*^9, 3.7402186693574123`*^9}, {3.7402192940381107`*^9, 
   3.7402193007617226`*^9}, {3.740220269338224*^9, 3.7402202697282248`*^9}, {
   3.740220328462328*^9, 3.740220338337145*^9}, {3.74062349322491*^9, 
   3.7406234962357154`*^9}, {3.740778595583645*^9, 3.74077859848525*^9}, {
   3.740778651650143*^9, 3.7407786648009663`*^9}, {3.7407788761441393`*^9, 
   3.7407788989669795`*^9}, {3.740779013450781*^9, 3.740779023996399*^9}, {
   3.7407791542866287`*^9, 3.7407791747070646`*^9}, {3.740779219900344*^9, 
   3.740779220196744*^9}, {3.740779424588303*^9, 3.7407794273807077`*^9}, {
   3.7407794683775797`*^9, 3.7407794818404036`*^9}, {3.7407796849131613`*^9, 
   3.7407797216824255`*^9}, {3.7407798321070204`*^9, 3.7407798775031*^9}, {
   3.7407800627346253`*^9, 3.740780110221109*^9}, {3.740780271946593*^9, 
   3.7407802910098267`*^9}, 3.740780521968232*^9, {3.740780648765255*^9, 
   3.7407806521660604`*^9}, {3.740780740587016*^9, 3.7407807443622227`*^9}, {
   3.7407824497451477`*^9, 3.740782452974354*^9}, {3.740783174738423*^9, 
   3.740783181930035*^9}, 3.740784309105423*^9, 3.7407843782021475`*^9, 
   3.740784798230516*^9, 3.740792141493194*^9, {3.740795745950735*^9, 
   3.7407958089592457`*^9}, 3.7407962456820135`*^9, 3.740796278894471*^9, {
   3.7407966335298944`*^9, 3.740796667288354*^9}, {3.740796726833658*^9, 
   3.740796732012867*^9}, {3.7407968196070213`*^9, 3.740796823959429*^9}, {
   3.741114044270252*^9, 3.741114047499458*^9}, 3.741114172876878*^9, {
   3.741114214840952*^9, 3.7411142149657516`*^9}, {3.7411143056643114`*^9, 
   3.7411143086907167`*^9}, {3.7411143683764215`*^9, 
   3.7411143879700556`*^9}, {3.7411144249889207`*^9, 
   3.7411144431785526`*^9}, {3.7411667545006695`*^9, 3.741166765233488*^9}, 
   3.74189270181349*^9, 3.74466368597719*^9, 3.7446641759896507`*^9, 
   3.7446656127845235`*^9, 3.744665651924992*^9, 3.744742913131895*^9, {
   3.7447489853929644`*^9, 3.744748987545768*^9}, 3.744875554021535*^9, {
   3.7452126977581944`*^9, 3.7452126994273973`*^9}, {3.7452128151796007`*^9, 
   3.74521282638042*^9}, {3.7452129967795196`*^9, 3.745213042097599*^9}, {
   3.7452130797560654`*^9, 3.745213081565668*^9}, {3.7452131350581627`*^9, 
   3.74521318497825*^9}, {3.7452132378155427`*^9, 3.745213240966748*^9}, {
   3.7452136012649813`*^9, 3.745213631029834*^9}, {3.745213734582815*^9, 
   3.7452137373908205`*^9}, {3.7452153530628586`*^9, 3.7452153600672708`*^9}, 
   3.7452154080997553`*^9, {3.745215674051823*^9, 3.7452156741454234`*^9}, {
   3.7452158387569127`*^9, 3.745215838975313*^9}, {3.745216206574359*^9, 
   3.745216245761627*^9}, 3.745220787875206*^9, 3.746051986744711*^9, {
   3.7460521008589115`*^9, 3.746052131778166*^9}, {3.7460521666286273`*^9, 
   3.7460524545427327`*^9}, 3.746052540857684*^9, {3.746053417769227*^9, 
   3.7460534259280415`*^9}, 3.746054345117657*^9, 3.7460546304265585`*^9, {
   3.7460742014929237`*^9, 3.746074240758193*^9}, 3.746991621012333*^9, {
   3.746994997701064*^9, 3.746995027793517*^9}, {3.7469953201784315`*^9, 
   3.7469954400490417`*^9}, {3.7469954827307167`*^9, 3.74699550728516*^9}, 
   3.7469955396084166`*^9, {3.7470008008733025`*^9, 3.74700080527251*^9}, {
   3.7470008733666296`*^9, 3.747000875893834*^9}, {3.747000949837964*^9, 
   3.747000952287168*^9}, 3.7470264752655973`*^9, {3.747028003559884*^9, 
   3.7470280096126947`*^9}, {3.7481111476864767`*^9, 3.748111150276081*^9}, 
   3.748111262440278*^9, 3.7481114647570333`*^9, 3.7481114993578944`*^9, 
   3.7481117436231236`*^9, 3.7481117783019843`*^9, 3.7481118211240597`*^9, 
   3.7481119089054136`*^9, 3.748112016779603*^9, 3.7481126540251226`*^9, {
   3.748112759746508*^9, 3.7481127604173093`*^9}, {3.748112809635396*^9, 
   3.748112816156207*^9}, {3.748112846591861*^9, 3.7481128812083216`*^9}, 
   3.7481129454960346`*^9, 3.748113095849098*^9, 3.7481148409525647`*^9, 
   3.7481523665185213`*^9, 3.749668417688261*^9, 3.7507168750970583`*^9, {
   3.7507169896168594`*^9, 3.750716992861665*^9}, {3.750717108551468*^9, 
   3.7507172392640977`*^9}, {3.7507172898861866`*^9, 3.75071732030624*^9}, {
   3.750717367402723*^9, 3.7507173891803613`*^9}, {3.7507175430902314`*^9, 
   3.750717551592246*^9}, {3.750717698907706*^9, 3.7507177368313723`*^9}, {
   3.750717804535491*^9, 3.7507178507895727`*^9}, {3.750717899056057*^9, 
   3.750717922424898*^9}, {3.750718034791896*^9, 3.7507180483015194`*^9}, {
   3.7507198746355276`*^9, 3.7507198747915277`*^9}, 3.7507206603917084`*^9, 
   3.750743995100903*^9, {3.750744115267914*^9, 3.7507441173583174`*^9}, 
   3.751183154782548*^9, 3.7511832007870283`*^9, 3.7511889477875257`*^9, 
   3.7511898686887436`*^9, {3.751190067027492*^9, 3.751190067214692*^9}, {
   3.7511904339557366`*^9, 3.7511904342209373`*^9}, 3.751343678313509*^9, {
   3.751343737328412*^9, 3.7513437454248266`*^9}, {3.7513439903028574`*^9, 
   3.7513440021900787`*^9}, 3.7513440559165726`*^9, {3.751344356866702*^9, 
   3.751344358754305*^9}, {3.7513453951733255`*^9, 3.7513454022313385`*^9}, 
   3.751345479623074*^9, 3.751345663578597*^9, 3.7513458060536475`*^9, {
   3.7513462322931957`*^9, 3.751346244788818*^9}, 3.751347972101852*^9, {
   3.7513564574799557`*^9, 3.751356461379963*^9}, 3.7513572038244677`*^9, 
   3.7550499818675575`*^9, 3.755050081270932*^9, 3.755050162094674*^9, {
   3.7550503792938557`*^9, 3.755050383552663*^9}, {3.755050657769945*^9, 
   3.7550507162700477`*^9}, 3.7550507776249557`*^9, {3.7550508327710524`*^9, 
   3.7550509174012012`*^9}, {3.75506116943268*^9, 3.75506120939995*^9}, 
   3.755061263641245*^9, {3.755061304045316*^9, 3.755061332296966*^9}, {
   3.791837454079505*^9, 3.7918374672326627`*^9}, {3.7918375293898745`*^9, 
   3.791837639613963*^9}, {3.7918376716532726`*^9, 3.7918377406682825`*^9}, {
   3.7918378367550473`*^9, 3.7918378492208977`*^9}, {3.791837885353021*^9, 
   3.791837927093199*^9}, {3.7918379571642485`*^9, 3.791837983314344*^9}, {
   3.7918382715699883`*^9, 3.791838307577134*^9}, {3.791838449356269*^9, 
   3.7918384679143763`*^9}, {3.791838600615634*^9, 3.7918386391222763`*^9}, {
   3.7918387136916265`*^9, 3.791838717518922*^9}, {3.7918387964402494`*^9, 
   3.7918388962605457`*^9}, {3.7918390063752236`*^9, 3.791839009499524*^9}, {
   3.7918390718129854`*^9, 3.791839081279473*^9}, 3.791926694308837*^9, {
   3.7919269047590957`*^9, 3.7919269312528725`*^9}, {3.791941159803388*^9, 
   3.791941185000529*^9}, {3.7919414976767054`*^9, 3.7919415013477135`*^9}, {
   3.7919418976905293`*^9, 3.7919419070633483`*^9}, {3.79194194144582*^9, 
   3.7919419457417145`*^9}, {3.791944532323326*^9, 3.7919445402901945`*^9}, 
   3.791945575110017*^9, {3.7919456228331137`*^9, 3.7919456251919384`*^9}, {
   3.7919457477646008`*^9, 3.791945947970544*^9}, {3.7919459941783795`*^9, 
   3.7919459979274817`*^9}, 3.791946210705377*^9, 3.791947743925529*^9, {
   3.792142687080438*^9, 3.7921427322260327`*^9}, {3.7921428660273533`*^9, 
   3.792142869089161*^9}, {3.792142945399186*^9, 3.7921429898730664`*^9}, {
   3.7921430613873816`*^9, 3.792143077961583*^9}, {3.7921431184519978`*^9, 
   3.7921431238725896`*^9}, 3.792143155349477*^9, 3.792143211601818*^9, {
   3.7921432698380313`*^9, 3.7921432757897153`*^9}, 3.7921434567671947`*^9, 
   3.792144982440548*^9, 3.7921450272892933`*^9, {3.792145072528581*^9, 
   3.792145079042717*^9}, 3.79214511625261*^9, 3.792145176425829*^9, {
   3.792145498912012*^9, 3.792145499115088*^9}, 3.792145594592448*^9, {
   3.7921456423624225`*^9, 3.7921456449087653`*^9}, {3.792184449093946*^9, 
   3.792184475478321*^9}, {3.792184553584795*^9, 3.792184576954283*^9}, 
   3.79218461517962*^9, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, {
   3.792206718240422*^9, 3.792206731424799*^9}, 3.792206845007283*^9, {
   3.7922070074375753`*^9, 3.7922070321039267`*^9}, 3.7922073048830905`*^9, {
   3.792207471952895*^9, 3.7922074981029654`*^9}, 3.792207861765847*^9, {
   3.7922106379018235`*^9, 3.7922106451501083`*^9}, {3.792270597712449*^9, 
   3.792270597712449*^9}, {3.792270891033639*^9, 3.7922708912054386`*^9}, 
   3.7922709722175446`*^9, 3.792271039389139*^9, 3.792271363687356*^9, {
   3.792272235885374*^9, 3.792272236072836*^9}, {3.7922725073824296`*^9, 
   3.7922725105379333`*^9}, {3.7922725499817567`*^9, 3.792272575631919*^9}, {
   3.7923819877656794`*^9, 3.7923819927489023`*^9}, 3.7925386565345564`*^9, {
   3.7925388649840345`*^9, 3.7925389122384624`*^9}, {3.792538977710556*^9, 
   3.7925389836310034`*^9}, 3.792539073871907*^9, 3.792539144948824*^9, 
   3.7925391995140295`*^9, {3.7925392495646725`*^9, 3.7925392522827845`*^9}, {
   3.792553223558854*^9, 3.792553236758835*^9}, 3.7925532712350616`*^9, 
   3.792553308132576*^9, {3.7925533452331324`*^9, 3.7925534413978987`*^9}, {
   3.792553882028*^9, 3.7925538868705435`*^9}, 3.792554765327935*^9, 
   3.7926557610118475`*^9, {3.8025467409044847`*^9, 3.802546764242728*^9}, 
   3.802547143215903*^9, {3.8025527321047087`*^9, 3.8025527867480636`*^9}, 
   3.802552818615567*^9, {3.8025528666667347`*^9, 3.802552957988966*^9}, 
   3.802553005837062*^9, 3.802553077929443*^9, {3.8025798749373145`*^9, 
   3.8025798774367256`*^9}, 3.8025799386730447`*^9, {3.8025800226579857`*^9, 
   3.8025800228142033`*^9}, 3.802585141722986*^9, 3.8078545320706625`*^9, {
   3.8078546051822667`*^9, 3.8078546730877852`*^9}, {3.8078547090317235`*^9, 
   3.8078547719695177`*^9}, 3.8078548203562016`*^9, 3.8078549040505514`*^9, {
   3.807855037674405*^9, 3.807855037962635*^9}, 3.816906009920802*^9, {
   3.8169060910892124`*^9, 3.8169061174267793`*^9}, {3.8169061971268187`*^9, 
   3.81690620022064*^9}, {3.8169062907775416`*^9, 3.8169063139595995`*^9}, {
   3.816906347529848*^9, 3.816906358371046*^9}, {3.8169064463660016`*^9, 
   3.8169064751248894`*^9}, {3.8169065717896967`*^9, 
   3.8169065738517113`*^9}, {3.8169066667673993`*^9, 3.816906727987401*^9}, 
   3.816906887955981*^9, {3.8169072179264603`*^9, 3.816907218176386*^9}, {
   3.8208064885993166`*^9, 3.820806493191882*^9}, {3.820806571985753*^9, 
   3.820806591262437*^9}, {3.820806643218884*^9, 3.820806644468581*^9}, {
   3.820806710234253*^9, 3.8208067108747253`*^9}, 3.820806825550688*^9, 
   3.820806870305712*^9, {3.8208070329068413`*^9, 3.8208070358748503`*^9}, 
   3.8208071291340075`*^9, {3.827874604478779*^9, 3.8278746309413214`*^9}, {
   3.828285976508387*^9, 3.8282860378689904`*^9}, {3.828286069189767*^9, 
   3.8282860750946317`*^9}, {3.8282862454440393`*^9, 3.828286274874611*^9}, 
   3.8282864569082403`*^9, 3.8282865303597565`*^9, {3.828288390273615*^9, 
   3.8282884014897327`*^9}, 3.8286362223683195`*^9, 3.8288490034020543`*^9, {
   3.8482570386076126`*^9, 3.8482570386232243`*^9}, {3.8482571403492136`*^9, 
   3.8482571748254557`*^9}, 3.8482572580401783`*^9, {3.8482592159992356`*^9, 
   3.8482592163897705`*^9}, 3.8482592584954834`*^9, 3.848259312904552*^9, {
   3.848259470368842*^9, 3.8482594998619113`*^9}, {3.8482597067661886`*^9, 
   3.848259717341818*^9}, {3.8482598723142166`*^9, 3.848259905868791*^9}, {
   3.8482604837349753`*^9, 3.8482604978097763`*^9}, {3.8547617638223734`*^9, 
   3.8547617638379946`*^9}, {3.8547617944089394`*^9, 3.8547617956430206`*^9}, 
   3.8547619113724337`*^9, {3.854762164384845*^9, 3.8547621866921015`*^9}, 
   3.8549110836125603`*^9, 3.8831684291204414`*^9, 3.8831685486083903`*^9, 
   3.883168591770075*^9, 3.8831689414842877`*^9, 3.8831690014857616`*^9, 
   3.8831706667954407`*^9, 3.8831708703093653`*^9, 3.956529049280467*^9, 
   3.9565290970348783`*^9, {3.9565292776866674`*^9, 3.9565293066954803`*^9}, {
   3.9565293420934258`*^9, 3.9565293429526005`*^9}, {3.9565293996423855`*^9, 
   3.9565294227776165`*^9}, 3.956529535867911*^9, 3.956529572578045*^9, {
   3.9565296812237678`*^9, 3.9565296814268775`*^9}, {3.956530125035204*^9, 
   3.9565301364388113`*^9}, 3.956530440138101*^9, 3.9565415554720664`*^9, 
   3.9565603893207836`*^9, {3.9565604891567297`*^9, 3.956560501966188*^9}, {
   3.956560829312087*^9, 3.9565608294526777`*^9}, {3.9565611655490513`*^9, 
   3.956561174421974*^9}, 3.956561243265194*^9, {3.956561530586708*^9, 
   3.9565615310397224`*^9}, 3.9578878267913127`*^9, {3.9578878602834253`*^9, 
   3.957887863876362*^9}, 3.957887917644964*^9, 3.957887959931946*^9, 
   3.9578881842003508`*^9, 3.9579383845178804`*^9, {3.9579739993059688`*^9, 
   3.9579740333761063`*^9}, 3.9579740705705004`*^9, 3.9579742407783546`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0280.png\>\"", ",", "ap3dConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955147213811*^9, 3.533955206041514*^9, 3.5470088906700325`*^9, 
   3.5470089487489347`*^9, {3.5501987437036085`*^9, 3.5501987438440084`*^9}, 
   3.550198813591731*^9, {3.5504692939604816`*^9, 3.550469294069682*^9}, 
   3.553114267872302*^9, 3.5531143193679924`*^9, 3.5531145595360146`*^9, 
   3.5531850944854507`*^9, {3.5531852419837103`*^9, 3.5531852422489104`*^9}, 
   3.5531900792725277`*^9, 3.5531901503774524`*^9, 3.55319089444716*^9, 
   3.553190949265656*^9, {3.55321378571439*^9, 3.5532137858547897`*^9}, 
   3.553213822249654*^9, {3.5532141187749743`*^9, 3.553214146340223*^9}, {
   3.5563895716216006`*^9, 3.556389571762001*^9}, 3.5563898724213285`*^9, {
   3.7325812172595596`*^9, 3.7325812177743607`*^9}, 3.7326535308532934`*^9, {
   3.732659113743902*^9, 3.732659113899903*^9}, 3.732659206220865*^9, 
   3.740216750922025*^9, 3.7402182214850187`*^9, 3.740218987201172*^9, 
   3.740778600201253*^9, {3.740780597784365*^9, 3.740780598018366*^9}, 
   3.7407822969116793`*^9, {3.7407956919590406`*^9, 3.740795692161841*^9}, 
   3.7407957432831306`*^9, 3.741114049309061*^9, {3.7411141070915623`*^9, 
   3.7411141072631626`*^9}, 3.741166751692664*^9, 3.7411668366036134`*^9, {
   3.741421168425725*^9, 3.7414211686285257`*^9}, 3.7446636889255953`*^9, 
   3.744664374468799*^9, 3.7446656127845235`*^9, {3.7446659070166407`*^9, 
   3.7446659071882405`*^9}, 3.7452127094426146`*^9, {3.7452127690503197`*^9, 
   3.7452127718427243`*^9}, 3.745215203949396*^9, 3.745215406290152*^9, 
   3.746051989225116*^9, {3.746052022125573*^9, 3.7460520228275747`*^9}, 
   3.746055103278989*^9, 3.746991472593672*^9, 3.7469915089417357`*^9, 
   3.7469915389717884`*^9, 3.746991632774753*^9, 3.748111159012097*^9, {
   3.7481113177579756`*^9, 3.748111317945176*^9}, 3.7481126514667177`*^9, {
   3.748113195470874*^9, 3.748113195689274*^9}, {3.7507167568800507`*^9, 
   3.7507167594852552`*^9}, 3.7507168842542744`*^9, {3.750907902190365*^9, 
   3.750907924545204*^9}, 3.7509082695866103`*^9, 3.7513500248866577`*^9, 
   3.7513500919979753`*^9, {3.7513503196023755`*^9, 3.7513503197739754`*^9}, {
   3.7550497169166927`*^9, 3.7550497426723375`*^9}, 3.7550499818831577`*^9, {
   3.791837399326764*^9, 3.791837403919399*^9}, 3.7918374397704163`*^9, 
   3.7919411562417016`*^9, 3.7919412497352705`*^9, 3.7919455775000772`*^9, 
   3.79194561547548*^9, 3.7921427775170593`*^9, {3.7921442289360805`*^9, 
   3.7921442290922937`*^9}, 3.792144984877466*^9, {3.79214503848981*^9, 
   3.7921450386459846`*^9}, 3.7922066272150636`*^9, {3.7922081247973256`*^9, 
   3.792208125375308*^9}, 3.792270597728077*^9, {3.792270704359085*^9, 
   3.792270704452841*^9}, 3.792538656550113*^9, {3.7925539995157557`*^9, 
   3.7925540001562295`*^9}, 3.8025468009840703`*^9, {3.802546874435505*^9, 
   3.8025468749822507`*^9}, 3.8025469230959077`*^9, 3.8025516256547904`*^9, {
   3.8025798621278696`*^9, 3.802579872625392*^9}, {3.807854454103038*^9, 
   3.807854466154855*^9}, 3.807854538815669*^9, 3.8169060154038906`*^9, {
   3.81690681059914*^9, 3.8169068368429813`*^9}, {3.8208063901537895`*^9, 
   3.820806402244675*^9}, 3.820806503673809*^9, {3.827874604494393*^9, 
   3.8278746309413214`*^9}, {3.8278748592560916`*^9, 3.8278748863590775`*^9}, 
   3.82828663244518*^9, 3.8482570386232243`*^9, {3.8482570745991116`*^9, 
   3.848257085752733*^9}, 3.8547617638536158`*^9, {3.854761829152297*^9, 
   3.854761851225196*^9}, {3.883168591785688*^9, 3.883168637915431*^9}, 
   3.9565290755867867`*^9, {3.9565292024699354`*^9, 3.9565292106242757`*^9}, 
   3.956560385743496*^9, 3.9565604362003746`*^9, 3.956561163393279*^9, 
   3.9565617008592467`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"adpConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"ArgDensityPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1.9"}], "-", 
       RowBox[{"1.3", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{"1.3", "+", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "1000"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "24"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.732482892728856*^9, 3.7324829563457675`*^9}, {
   3.7324830851923943`*^9, 3.7324830882811995`*^9}, {3.732483262424306*^9, 
   3.732483272377123*^9}, 3.7326584415195208`*^9, {3.7326584750439796`*^9, 
   3.7326584764479823`*^9}, 3.732658701981179*^9, {3.732658872349078*^9, 
   3.732658872567479*^9}, 3.7326592186228867`*^9, 3.7326593083866453`*^9, 
   3.7326626660310535`*^9, {3.740218157446906*^9, 3.740218181533348*^9}, 
   3.7402182257126255`*^9, 3.7402183634452677`*^9, {3.740218493186303*^9, 
   3.7402184934047036`*^9}, 3.740218637580157*^9, {3.7402186807610326`*^9, 
   3.7402186901834493`*^9}, 3.740219272556873*^9, 3.7406235115861425`*^9, {
   3.740778603524059*^9, 3.740778607080865*^9}, {3.740778656564152*^9, 
   3.740778658529755*^9}, {3.740778688559808*^9, 3.7407786898078103`*^9}, {
   3.7407792259843545`*^9, 3.7407792441895866`*^9}, {3.7407793822810287`*^9, 
   3.740779417427891*^9}, {3.7407794646959734`*^9, 3.7407794857872105`*^9}, 
   3.740780774189475*^9, 3.7407824622407703`*^9, {3.740783008707331*^9, 
   3.7407830693134375`*^9}, 3.7407921769832563`*^9, 3.740795739929125*^9, 
   3.740795830549684*^9, {3.741114053755069*^9, 3.741114056173073*^9}, 
   3.741114177042085*^9, {3.741114217851757*^9, 3.7411142179765573`*^9}, 
   3.741114298004698*^9, 3.7411143910588613`*^9, {3.7411144222121162`*^9, 
   3.741114422383716*^9}, 3.7411667475274568`*^9, 3.741166782284318*^9, 
   3.741202200838129*^9, 3.7418928330565205`*^9, 3.744663694463605*^9, 
   3.7446641788132553`*^9, 3.7446656127845235`*^9, 3.7446656519405923`*^9, 
   3.744742916766701*^9, 3.7447489900885725`*^9, 3.745212714450224*^9, {
   3.7452134334710865`*^9, 3.745213472377555*^9}, {3.74521352657205*^9, 
   3.7452135499564915`*^9}, {3.745213645116658*^9, 3.74521367446031*^9}, 
   3.7452137501360426`*^9, 3.745215372484893*^9, 3.745215403544547*^9, {
   3.745215676563428*^9, 3.745215676657028*^9}, {3.745215841159317*^9, 
   3.7452158501293325`*^9}, 3.745220796377221*^9, 3.746051992891122*^9, {
   3.7460525179568443`*^9, 3.746052527363661*^9}, {3.7460525613717203`*^9, 
   3.7460526080470023`*^9}, {3.746052647827072*^9, 3.746052665392703*^9}, 
   3.7460527306476173`*^9, {3.7460534548348923`*^9, 3.746053478047733*^9}, {
   3.7460536390400157`*^9, 3.7460536607708535`*^9}, {3.7460537995066986`*^9, 
   3.7460538460103807`*^9}, 3.746054532895187*^9, 3.7460546210509415`*^9, {
   3.746055005030016*^9, 3.7460550460736885`*^9}, 3.7460615185886574`*^9, {
   3.746069839136873*^9, 3.7460698629425144`*^9}, {3.746073417607147*^9, 
   3.7460734321307726`*^9}, 3.7460741921641073`*^9, 3.7469916409491673`*^9, {
   3.7469955617292557`*^9, 3.746995578218485*^9}, 3.7469956382941904`*^9, {
   3.7469959147934766`*^9, 3.746995920768287*^9}, {3.7469959729191785`*^9, 
   3.746995986631603*^9}, 3.746998736928876*^9, 3.746999808962759*^9, 
   3.747000762809235*^9, {3.7470280162427063`*^9, 3.7470280188011107`*^9}, 
   3.7481111741597233`*^9, 3.74811125768227*^9, {3.7481113758212776`*^9, 
   3.748111454039815*^9}, 3.7481116828922167`*^9, 3.74811178123479*^9, 
   3.7481120097751913`*^9, 3.7481126483779125`*^9, 3.7481127678585224`*^9, 
   3.7481129482884398`*^9, 3.748113174738437*^9, {3.748114852964586*^9, 
   3.7481148546805887`*^9}, 3.7481523715885305`*^9, 3.748156676743692*^9, 
   3.7496684226178694`*^9, 3.7507168950182934`*^9, 3.7507174232196207`*^9, 
   3.7507179880698137`*^9, 3.7507180637455463`*^9, {3.750718172664938*^9, 
   3.7507181919309716`*^9}, {3.750718281381529*^9, 3.7507183044383693`*^9}, {
   3.7507198773499327`*^9, 3.7507198774903326`*^9}, 3.750720697925374*^9, 
   3.7507439988761096`*^9, {3.750744109105903*^9, 3.7507441115707073`*^9}, 
   3.75090826960221*^9, 3.750908324873107*^9, 3.750911281940936*^9, 
   3.7509118911532063`*^9, 3.7509120959347663`*^9, {3.750923612368995*^9, 
   3.750923612524996*^9}, {3.7509248608167896`*^9, 3.750924875777216*^9}, {
   3.7509256243805313`*^9, 3.750925624567732*^9}, 3.7513499450613174`*^9, 
   3.751350024902258*^9, 3.751350205378975*^9, {3.7513571187651176`*^9, 
   3.751357119545119*^9}, 3.751357214526087*^9, {3.7513577496226263`*^9, 
   3.7513577498410273`*^9}, {3.751405366281531*^9, 3.751405378480752*^9}, {
   3.7514055458066463`*^9, 3.751405557849867*^9}, {3.751405638626809*^9, 
   3.7514056388764095`*^9}, 3.755049981945558*^9, 3.755050081707733*^9, 
   3.7550501621258745`*^9, {3.755050400759494*^9, 3.7550504035050983`*^9}, 
   3.7550509310980253`*^9, {3.7550512422873716`*^9, 3.7550512668106146`*^9}, {
   3.755051312409495*^9, 3.755051312877496*^9}, {3.755051771595695*^9, 
   3.755051771751695*^9}, {3.7550518885491004`*^9, 3.7550519085639353`*^9}, 
   3.7551379658536453`*^9, {3.755138016132534*^9, 3.755138075287838*^9}, {
   3.7551381761264153`*^9, 3.755138212599279*^9}, {3.75513827588859*^9, 
   3.755138303656639*^9}, {3.7551383744339633`*^9, 3.7551383747147636`*^9}, {
   3.755138574254714*^9, 3.75513859464395*^9}, 3.755138673611289*^9, {
   3.755139946626726*^9, 3.7551399654559593`*^9}, {3.7551413576185923`*^9, 
   3.755141379583431*^9}, 3.7551422855775647`*^9, {3.7551424248350105`*^9, 
   3.7551424403258376`*^9}, 3.7551475815781126`*^9, 3.7552236306473618`*^9, 
   3.7552237351007524`*^9, 3.7552257200630403`*^9, {3.755227559021696*^9, 
   3.755227559177696*^9}, {3.755227954092391*^9, 3.7552279570407963`*^9}, 
   3.7642903613991814`*^9, {3.7642905329386835`*^9, 3.7642905870551786`*^9}, 
   3.7642906182396336`*^9, {3.764290672449729*^9, 3.7642906894693584`*^9}, 
   3.764290721075014*^9, {3.76429075314867*^9, 3.764290753289071*^9}, {
   3.7642908794620924`*^9, 3.7642908959981213`*^9}, 3.764291593614951*^9, 
   3.76429466703955*^9, 3.7643042218683386`*^9, 3.764315617343957*^9, 
   3.76431783317605*^9, 3.7643199388461533`*^9, 3.7643853579378877`*^9, 
   3.764664382553267*^9, 3.7646644254065423`*^9, {3.7646670199227085`*^9, 
   3.7646670350235357`*^9}, {3.7646689626829224`*^9, 3.7646689628545227`*^9}, 
   3.764887973228504*^9, 3.764888008734166*^9, 3.7648888932053223`*^9, {
   3.7648903774637313`*^9, 3.764890377635331*^9}, 3.7648904488962564`*^9, 
   3.764890628343372*^9, {3.7648920077004867`*^9, 3.764892008121687*^9}, 
   3.764892076278207*^9, {3.7649026437276335`*^9, 3.7649026438212337`*^9}, 
   3.76506077650143*^9, 3.765170874625887*^9, 3.7651709275099792`*^9, 
   3.7651715756087255`*^9, 3.765171666619285*^9, 3.7651717371314087`*^9, 
   3.765171875909253*^9, 3.7652588601167355`*^9, 3.7652589118932266`*^9, {
   3.765267833767707*^9, 3.7652678340173073`*^9}, 3.766219677016867*^9, 
   3.766219733629367*^9, 3.7662201958113785`*^9, {3.7662231334417396`*^9, 
   3.7662231361717443`*^9}, 3.7662232485855417`*^9, {3.766426144952866*^9, 
   3.766426157042887*^9}, {3.76647719987669*^9, 3.7664772214515276`*^9}, {
   3.7664774867767935`*^9, 3.7664775002396173`*^9}, {3.7688458990076995`*^9, 
   3.7688459132037244`*^9}, 3.7688464394654493`*^9, 3.7688469041774664`*^9, 
   3.791925257427122*^9, 3.791925346562312*^9, {3.791925415077385*^9, 
   3.791925432292034*^9}, {3.79192558767724*^9, 3.7919255902703776`*^9}, {
   3.7919257453302054`*^9, 3.791925757202401*^9}, {3.791925937519228*^9, 
   3.7919259408152847`*^9}, {3.7919259926311307`*^9, 3.791925997395666*^9}, 
   3.791926263855747*^9, {3.7919264890844517`*^9, 3.791926490037352*^9}, 
   3.791927284210745*^9, 3.7919411532580585`*^9, 3.791941223803928*^9, {
   3.7919415060341063`*^9, 3.7919415061903205`*^9}, 3.7919455800307994`*^9, 
   3.7919456362986813`*^9, {3.791945689832918*^9, 3.7919457217551537`*^9}, 
   3.7919460775336857`*^9, 3.7919462165008616`*^9, {3.7919462528203726`*^9, 
   3.7919462530703335`*^9}, 3.7921427775170593`*^9, 3.7921428783057747`*^9, {
   3.792143003807266*^9, 3.7921430251928267`*^9}, 3.792143064074258*^9, {
   3.7921431277154303`*^9, 3.792143128543357*^9}, {3.7921434609849415`*^9, 
   3.79214346590565*^9}, 3.7921449885797224`*^9, 3.792145025274151*^9, {
   3.7921450954762783`*^9, 3.7921451181897235`*^9}, {3.7921455056604123`*^9, 
   3.7921455095657372`*^9}, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, 
   3.7922067460150957`*^9, 3.7922068475379333`*^9, {3.792207866280402*^9, 
   3.792207873684909*^9}, {3.792270597728077*^9, 3.792270597728077*^9}, {
   3.792270895657544*^9, 3.792270895782504*^9}, {3.792271368045697*^9, 
   3.7922713738255787`*^9}, {3.7922722199672675`*^9, 3.792272227824782*^9}, 
   3.792538656565729*^9, 3.792538924313737*^9, {3.792538977710556*^9, 
   3.7925389876925745`*^9}, 3.792539078730129*^9, 3.7925391498539133`*^9, {
   3.7925532490372567`*^9, 3.792553269157399*^9}, {3.7925536620956464`*^9, 
   3.792553667672454*^9}, 3.7925537022735977`*^9, {3.792553890557179*^9, 
   3.7925538937751665`*^9}, {3.7925546404577494`*^9, 3.7925546465187893`*^9}, 
   3.7925547575953875`*^9, 3.7926551481604743`*^9, 3.802546774584007*^9, 
   3.802546806014125*^9, {3.8025471515108232`*^9, 3.802547153432208*^9}, {
   3.8025530095393133`*^9, 3.802553026457199*^9}, {3.8025532045714674`*^9, 
   3.802553229409363*^9}, 3.802553261038468*^9, 3.802553454664689*^9, {
   3.8025798431792006`*^9, 3.8025798457723475`*^9}, {3.8025800272037663`*^9, 
   3.802580027344387*^9}, {3.802582660552966*^9, 3.8025826638022027`*^9}, 
   3.8078545445533037`*^9, 3.8078546876419163`*^9, {3.807854721465523*^9, 
   3.8078547489939494`*^9}, 3.8078547791373887`*^9, {3.807855042242198*^9, 
   3.8078550464639173`*^9}, 3.816906024932904*^9, 3.816906211796054*^9, {
   3.8169062938236933`*^9, 3.816906310679119*^9}, 3.8169063942376285`*^9, 
   3.8169064881374598`*^9, 3.816906605547397*^9, {3.81690722223795*^9, 
   3.81690722739299*^9}, {3.816911790459921*^9, 3.816911790662994*^9}, {
   3.8208065113126163`*^9, 3.820806513952616*^9}, 3.8208066006040044`*^9, {
   3.8208066387668133`*^9, 3.820806640141487*^9}, {3.8208067180917654`*^9, 
   3.82080671859165*^9}, {3.8208068079142385`*^9, 3.820806816990216*^9}, 
   3.820807138147498*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.828286123457013*^9, {3.8282861747106113`*^9, 3.8282861989236813`*^9}, {
   3.828286440365247*^9, 3.8282864529248*^9}, {3.828553556846962*^9, 
   3.828553562587772*^9}, {3.828557128894436*^9, 3.8285571389096537`*^9}, {
   3.8285573314607916`*^9, 3.8285573321159925`*^9}, 3.828557376529271*^9, {
   3.8286360368995934`*^9, 3.828636050206417*^9}, 3.8286362099974976`*^9, 
   3.8286376533312335`*^9, 3.828718698781597*^9, {3.848257038638844*^9, 
   3.848257038638844*^9}, {3.8482571592822495`*^9, 3.8482571791525536`*^9}, 
   3.8482592259343624`*^9, {3.848259521700473*^9, 3.8482595244186172`*^9}, 
   3.848259575968937*^9, {3.848259744967764*^9, 3.848259748545044*^9}, {
   3.848259837688095*^9, 3.848259841812119*^9}, 3.848260108181464*^9, {
   3.8547617638692365`*^9, 3.8547617638848314`*^9}, 3.854761804515937*^9, 
   3.854761915152796*^9, {3.854762106815795*^9, 3.854762106987621*^9}, {
   3.8547621715706553`*^9, 3.854762191347271*^9}, {3.854762692983657*^9, 
   3.8547626933116884`*^9}, 3.8549110693034267`*^9, 3.883168548842718*^9, 
   3.883168591801283*^9, {3.8831693422177663`*^9, 3.883169342373979*^9}, 
   3.883170089065553*^9, {3.9565290756024103`*^9, 3.9565290756024103`*^9}, 
   3.956529277905364*^9, {3.9565293329237075`*^9, 3.956529358527069*^9}, 
   3.956529465626936*^9, {3.95652968441055*^9, 3.956529687425434*^9}, 
   3.956530150357442*^9, 3.956530343390212*^9, 3.9565304268131027`*^9, 
   3.956541558143319*^9, 3.956560381760056*^9, {3.9565604913281097`*^9, 
   3.956560505887143*^9}, {3.9565608360761228`*^9, 3.956560839950215*^9}, {
   3.956561159347355*^9, 3.9565611827012787`*^9}, 3.956561235548219*^9, {
   3.956561534820157*^9, 3.956561551644227*^9}, 3.9578878365390205`*^9, 
   3.9578878759828672`*^9, 3.957887911583887*^9, {3.957887966930303*^9, 
   3.9578879809894958`*^9}, {3.957974015239732*^9, 3.957974035734919*^9}, 
   3.9579741033128133`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0290.png\>\"", ",", "adpConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955159803033*^9, 3.5339552034519095`*^9, 3.547008893618438*^9, 
   3.547008956314948*^9, {3.5501987477128153`*^9, 3.5501987478844156`*^9}, 
   3.5501988226865473`*^9, {3.550469306627704*^9, 3.5504693067681046`*^9}, 
   3.553114272723911*^9, 3.553114315530386*^9, 3.553114569972433*^9, 
   3.55318508843264*^9, {3.553185247131719*^9, 3.5531852473969193`*^9}, 
   3.5531900821741323`*^9, 3.55319015471426*^9, 3.5531908900479517`*^9, 
   3.5531909541796646`*^9, {3.553213790019997*^9, 3.5532138179752464`*^9}, {
   3.553214122440981*^9, 3.5532141511450315`*^9}, {3.556389578501213*^9, 
   3.556389578672813*^9}, 3.5563898772885375`*^9, {3.7325812073847427`*^9, 
   3.7325812080243435`*^9}, 3.7326535267504864`*^9, {3.732659119968313*^9, 
   3.732659120171114*^9}, {3.7326593137530546`*^9, 3.7326593214438686`*^9}, 
   3.740216750953225*^9, 3.740218228489431*^9, 3.740218990196377*^9, 
   3.74077860982647*^9, {3.740780605007178*^9, 3.7407806051787777`*^9}, 
   3.7407823021064887`*^9, {3.740795700305055*^9, 3.740795700539056*^9}, 
   3.7407957379479213`*^9, 3.7411140595270786`*^9, {3.7411141143767753`*^9, 
   3.741114114532776*^9}, 3.7411667457334538`*^9, {3.7411668447156277`*^9, 
   3.741166844871628*^9}, 3.74142115986131*^9, 3.744663700313615*^9, 
   3.744664379024007*^9, 3.7446656127845235`*^9, {3.7446659116810484`*^9, 
   3.744665911868249*^9}, 3.7452127175858293`*^9, {3.74521278093754*^9, 
   3.7452127811247406`*^9}, 3.7452152075218024`*^9, 3.7452154016881437`*^9, 
   3.7460519949503255`*^9, {3.7460520308459883`*^9, 3.74605203162599*^9}, 
   3.746055107834197*^9, 3.746991475479677*^9, {3.746991513918144*^9, 
   3.7469915424973946`*^9}, 3.746991645816376*^9, 3.748111177404529*^9, {
   3.748111322703184*^9, 3.748111322999585*^9}, 3.748112646147109*^9, {
   3.748113203645288*^9, 3.748113203988488*^9}, {3.7507167757248836`*^9, 
   3.7507167790164895`*^9}, 3.750716899963502*^9, {3.750907902190365*^9, 
   3.7509079301456137`*^9}, 3.75090826960221*^9, 3.751350024902258*^9, 
   3.7513500920135756`*^9, {3.7513503300387936`*^9, 3.751350330210394*^9}, 
   3.751400149651678*^9, {3.755049707478676*^9, 3.755049707634676*^9}, {
   3.755049765697978*^9, 3.75504976657158*^9}, 3.755049981945558*^9, 
   3.762283545821921*^9, 3.7622835936204047`*^9, 3.762283681510959*^9, 
   3.764280933902177*^9, 3.7642809906238766`*^9, {3.764281052961586*^9, 
   3.7642810835844398`*^9}, 3.7642811989934425`*^9, 3.764281290331603*^9, 
   3.764291454634307*^9, 3.7642915558472843`*^9, 3.7646644254065423`*^9, {
   3.7646645227819133`*^9, 3.7646645229067135`*^9}, {3.7648873755758543`*^9, 
   3.7648873757318544`*^9}, 3.764887973244104*^9, 3.7648894055102224`*^9, 
   3.765060231344472*^9, 3.765060779434235*^9, 3.7650876619491696`*^9, {
   3.7651708015085583`*^9, 3.7651708016333585`*^9}, 3.7651708746414866`*^9, 
   3.7652589118932266`*^9, {3.7652590299074335`*^9, 3.7652590301102343`*^9}, {
   3.7662195543382516`*^9, 3.766219578331094*^9}, 3.766219677016867*^9, 
   3.7662201983853827`*^9, 3.76647719987669*^9, 3.7664773392785344`*^9, 
   3.7664774867767935`*^9, 3.766477573559746*^9, 3.7666119106500444`*^9, {
   3.767393914938072*^9, 3.7673939150940723`*^9}, 3.7688458990076995`*^9, 
   3.768845992124263*^9, {3.7688460972060475`*^9, 3.768846097424448*^9}, 
   3.791925257442734*^9, {3.791926042673618*^9, 3.7919260678864145`*^9}, 
   3.7919411511491823`*^9, 3.7919412536874685`*^9, 3.7919455822489567`*^9, 
   3.791945613460332*^9, 3.7921427775327096`*^9, {3.7921442341379757`*^9, 
   3.7921442343566737`*^9}, 3.79214499129782*^9, {3.7921450432386465`*^9, 
   3.7921450433948555`*^9}, 3.7922066272150636`*^9, {3.7922081370131783`*^9, 
   3.7922081377629976`*^9}, 3.792270597728077*^9, {3.7922707124977846`*^9, 
   3.7922707126696568`*^9}, 3.792538656565729*^9, 3.792554019510995*^9, 
   3.802546808544753*^9, {3.8025468814650974`*^9, 3.802546882324236*^9}, 
   3.8025469199403934`*^9, 3.8025516303411865`*^9, {3.8025798413202734`*^9, 
   3.8025798500994525`*^9}, {3.80785445090362*^9, 3.8078544763037367`*^9}, 
   3.8078545477278557`*^9, 3.8169060294318476`*^9, 3.816906816785185*^9, 
   3.816906856635206*^9, 3.820806416772484*^9, 3.820806449655319*^9, 
   3.820806517936056*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.8278748592717104`*^9, 3.8278748912173123`*^9, 3.828286639443576*^9, 
   3.848257038638844*^9, 3.848257074614698*^9, 3.848257111481027*^9, 
   3.854761763900452*^9, {3.8547618323859158`*^9, 3.854761855958494*^9}, {
   3.883168591801283*^9, 3.88316864422643*^9}, 3.9565290756180315`*^9, {
   3.9565292024855556`*^9, 3.9565292145296135`*^9}, 3.9565603751522007`*^9, 
   3.956560441292962*^9, 3.9565611575821805`*^9, 3.956561707966959*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"rp3dConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"RePlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1.9"}], "-", 
       RowBox[{"1.3", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{"1.3", "+", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1000"}], ",", "1000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "100"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "2"}], "}"}], ",", "20"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221349871864`*^9}, {3.533956562109496*^9, 3.533956663650075*^9}, 
   3.5339567557838364`*^9, 3.5347099882825756`*^9, 3.5347102657482634`*^9, {
   3.5347103008951254`*^9, 3.5347103043427315`*^9}, {3.535593994727907*^9, 
   3.535594052120408*^9}, {3.535594118654525*^9, 3.535594142257366*^9}, {
   3.53559417306742*^9, 3.5355941818346357`*^9}, {3.535594253173561*^9, 
   3.535594273141596*^9}, {3.535594308943659*^9, 3.535594311580064*^9}, {
   3.5355943417349167`*^9, 3.5355943446677217`*^9}, 3.5355944944279847`*^9, 
   3.5364644113098073`*^9, 3.547008961306957*^9, 3.547009174886932*^9, 
   3.5470100939009466`*^9, 3.5470101792522974`*^9, {3.547010219671968*^9, 
   3.5470102336495924`*^9}, {3.547010378308647*^9, 3.5470103791978483`*^9}, {
   3.5470106361019*^9, 3.547010661077544*^9}, 3.5501988290669584`*^9, 
   3.550199059994164*^9, 3.550199923226681*^9, {3.5501999833959866`*^9, 
   3.5501999880135946`*^9}, 3.5502073242848244`*^9, 3.5502076305611625`*^9, 
   3.5502077527405767`*^9, 3.550207824360303*^9, {3.5502086208227015`*^9, 
   3.5502086232251062`*^9}, 3.5502087333612995`*^9, {3.550210050393613*^9, 
   3.5502100620780334`*^9}, 3.5503471093742733`*^9, {3.5508011543922625`*^9, 
   3.5508011573094673`*^9}, 3.550801274574874*^9, 3.550828826075177*^9, 
   3.5531145222051487`*^9, 3.5531145764308443`*^9, 3.5531151448958426`*^9, {
   3.553115181758707*^9, 3.5531152194327736`*^9}, 3.5531152549228363`*^9, {
   3.553115444209176*^9, 3.5531154457847786`*^9}, 3.5531154834276447`*^9, 
   3.553184120965741*^9, 3.5531844553835287`*^9, 3.5531849288443604`*^9, {
   3.5531850323193417`*^9, 3.553185039214554*^9}, {3.5534455197643785`*^9, 
   3.5534455226191835`*^9}, {3.564290330151406*^9, 3.564290330151406*^9}, {
   3.564291249632621*^9, 3.5642913088503246`*^9}, {3.5642913587860126`*^9, 
   3.5642913874744625`*^9}, 3.5645701739454827`*^9, 3.56457022934118*^9, {
   3.5645704548083763`*^9, 3.564570523245696*^9}, 3.564632298359475*^9, 
   3.5672835710783267`*^9, 3.5672836098287945`*^9, 3.5672836500924654`*^9, 
   3.5672837096845703`*^9, {3.5672837599322586`*^9, 3.567283785797104*^9}, {
   3.567283815998757*^9, 3.567283882470474*^9}, 3.5672839294421563`*^9, 
   3.567283963200616*^9, 3.567749299701456*^9, 3.567802782394025*^9, 
   3.5678028822498007`*^9, {3.5681600327494287`*^9, 3.5681600592382755`*^9}, {
   3.568160109142763*^9, 3.5681601122315683`*^9}, 3.5681601467388287`*^9, {
   3.568160184319295*^9, 3.56816020424053*^9}, {3.568160517132702*^9, 
   3.568160596162441*^9}, 3.5681606610273547`*^9, {3.568160946421071*^9, 
   3.568160966030306*^9}, {3.5681705219146996`*^9, 3.5681705242703037`*^9}, 
   3.5681941899017687`*^9, 3.568194240352257*^9, 3.5700755677715073`*^9, 
   3.570075613354788*^9, 3.5700766540950155`*^9, {3.570086887572139*^9, 
   3.5700868877641497`*^9}, {3.570087003107747*^9, 3.570087005763899*^9}, {
   3.570087078020032*^9, 3.5700870989962316`*^9}, 3.5700872221102734`*^9, {
   3.57009623935571*^9, 3.570096282536586*^9}, 3.5736048119306808`*^9, 
   3.5736048904456186`*^9, 3.573604940833707*^9, {3.573605077677148*^9, 
   3.573605125865632*^9}, {3.5736051592964907`*^9, 3.573605161948496*^9}, {
   3.573605211119782*^9, 3.5736052136937866`*^9}, {3.5736052478578463`*^9, 
   3.5736052497922497`*^9}, 3.5736058726857443`*^9, 3.573605926771039*^9, {
   3.573605956925892*^9, 3.5736059886719475`*^9}, 3.573606090758527*^9, {
   3.5736061269973907`*^9, 3.57360615517104*^9}, {3.5736066713897743`*^9, 
   3.573606699345023*^9}, 3.573615836289501*^9, 3.57361605569005*^9, 
   3.5736161124242954`*^9, {3.5736161436740828`*^9, 3.5736161737138004`*^9}, 
   3.5736162263498116`*^9, {3.5736162577736087`*^9, 3.573616267602171*^9}, {
   3.573616444274276*^9, 3.5736164466824136`*^9}, {3.574885927166521*^9, 
   3.5748859637953854`*^9}, {3.5748860508435383`*^9, 
   3.5748860521695404`*^9}, {3.5748861157240524`*^9, 3.574886117252855*^9}, 
   3.57577235924708*^9, 3.5757724099589806`*^9, 3.575772445279001*^9, {
   3.5757724785189023`*^9, 3.5757724925687056`*^9}, {3.575772607702291*^9, 
   3.575772651454794*^9}, {3.5759741600893764`*^9, 3.575974161493379*^9}, {
   3.575974199510646*^9, 3.5759742220370855`*^9}, 3.576873240797937*^9, {
   3.5768733189384737`*^9, 3.576873344428919*^9}, {3.576873425346261*^9, 
   3.5768734529895096`*^9}, {3.576873485281566*^9, 3.5768734895091734`*^9}, {
   3.576873525514037*^9, 3.576873525701237*^9}, {3.577055332882147*^9, 
   3.5770553361425524`*^9}, 3.577871528638734*^9, {3.5778716843606405`*^9, 
   3.577871704824811*^9}, 3.5778717538886175`*^9, {3.5778718288889074`*^9, 
   3.577871876976658*^9}, {3.5778719113366227`*^9, 3.577871931008748*^9}, 
   3.577996382595691*^9, 3.5779973953859024`*^9, 3.577997497659682*^9, {
   3.592182738830336*^9, 3.592182738830336*^9}, 3.592182940881891*^9, 
   3.592183011815215*^9, {3.5921894364524994`*^9, 3.592189460086541*^9}, {
   3.592189491785797*^9, 3.592189494235001*^9}, {3.5921895481018953`*^9, 
   3.592189608177601*^9}, 3.592189794161128*^9, 3.5921898423808126`*^9, 
   3.5993883891423397`*^9, {3.5993886376195765`*^9, 3.5993886707696347`*^9}, 
   3.5993887338093452`*^9, 3.599388787067839*^9, 3.5993898053488283`*^9, 
   3.599450646030573*^9, 3.6063523737093935`*^9, {3.6063536327884064`*^9, 
   3.606353657155649*^9}, {3.6063536884961042`*^9, 3.606353715281351*^9}, {
   3.6063541082884493`*^9, 3.606354110690853*^9}, {3.606354174463765*^9, 
   3.6063541934333982`*^9}, 3.606354233681469*^9, {3.606354327624834*^9, 
   3.6063543393872547`*^9}, {3.6063554596717415`*^9, 3.606355469234558*^9}, {
   3.6063556589152913`*^9, 3.6063556888517437`*^9}, {3.6063559489462013`*^9, 
   3.60635597109824*^9}, {3.606356372177745*^9, 3.606356383128964*^9}, {
   3.6063564284002438`*^9, 3.606356435435856*^9}, 3.606356488460349*^9, {
   3.606356550096057*^9, 3.606356592091331*^9}, 3.606362300175032*^9, 
   3.606364095238985*^9, 3.6063646120054927`*^9, {3.606424049973319*^9, 
   3.606424053639326*^9}, 3.6064240927485943`*^9, 3.6064350337292786`*^9, 
   3.6253066892819157`*^9, 3.625306727517583*^9, {3.6253071403575087`*^9, 
   3.625307143961115*^9}, 3.6253071830235834`*^9, 3.625307214270438*^9, 
   3.62530768864248*^9, {3.625307721074937*^9, 3.6253077378137665`*^9}, {
   3.6253078152835026`*^9, 3.625307818465908*^9}, 3.6253078603831816`*^9, 
   3.625308042795102*^9, {3.625308091591988*^9, 3.6253080991112013`*^9}, {
   3.625383389886337*^9, 3.625383390822338*^9}, 3.6253834238787966`*^9, 
   3.6291871861181545`*^9, 3.629187255195076*^9, {3.629187298329152*^9, 
   3.629187319170789*^9}, 3.629187721281896*^9, {3.629187761576767*^9, 
   3.629187773105187*^9}, 3.629187853476528*^9, {3.629189386050821*^9, 
   3.6291893870960226`*^9}, 3.6294129792897773`*^9, {3.629681940821416*^9, 
   3.629681967825063*^9}, 3.6296830652981987`*^9, {3.629683828638739*^9, 
   3.629683873535618*^9}, 3.6296840724983673`*^9, 3.629684659074998*^9, {
   3.6296848918274064`*^9, 3.629684894619811*^9}, 3.630130105717137*^9, 
   3.6301868115768538`*^9, 3.6301913486360464`*^9, {3.6301914399118066`*^9, 
   3.630191440754208*^9}, {3.6301915173347425`*^9, 3.630191517662343*^9}, {
   3.630191564462425*^9, 3.6301915646184254`*^9}, 3.6301916235085287`*^9, 
   3.6301916648486013`*^9, {3.6301916949722548`*^9, 3.630191743254339*^9}, 
   3.630192498482866*^9, 3.630224013755659*^9, 3.6325489583565407`*^9, 
   3.6325493465892234`*^9, 3.6325495969920783`*^9, 3.6325497909544272`*^9, {
   3.6325499065150375`*^9, 3.6325499323798833`*^9}, {3.6326039905906425`*^9, 
   3.6326039969398537`*^9}, {3.6326052476784515`*^9, 3.6326052678180866`*^9}, 
   3.632789691264064*^9, {3.632789738937748*^9, 3.632789739811349*^9}, {
   3.632789771198604*^9, 3.63278978590943*^9}, 3.632789880617196*^9, 
   3.6327899977890024`*^9, 3.63279813902344*^9, 3.632798262731657*^9, 
   3.632807713384465*^9, 3.6328077532581353`*^9, {3.632813931449418*^9, 
   3.6328140063139496`*^9}, {3.632814038262806*^9, 3.632814038481206*^9}, {
   3.6328142150367174`*^9, 3.632814235581953*^9}, {3.632862829136717*^9, 
   3.6328628333643246`*^9}, 3.632863060297923*^9, 3.6328903848425245`*^9, 
   3.6345039605706234`*^9, 3.6345039979950895`*^9, 3.634505028388706*^9, {
   3.634505073659986*^9, 3.634505094844823*^9}, {3.6345051346835*^9, 
   3.6345051909059987`*^9}, {3.634505248002099*^9, 3.6345052831177607`*^9}, 
   3.6345058717026*^9, {3.6345559035261827`*^9, 3.6345559061157875`*^9}, {
   3.634555945349856*^9, 3.634555948313861*^9}, 3.634556202246708*^9, {
   3.6360748453404164`*^9, 3.6360748476336203`*^9}, 3.636075402244196*^9, 
   3.6360755387756352`*^9, 3.6360756646834564`*^9, 3.636076028008095*^9, 
   3.6360760583769555`*^9, {3.6360761965931983`*^9, 3.6360762071856165`*^9}, 
   3.6364953485684733`*^9, 3.6364953884889436`*^9, 3.636495515816367*^9, 
   3.6364955598396444`*^9, 3.63649577777445*^9, {3.6364958118137093`*^9, 
   3.636495860766596*^9}, 3.636495993039228*^9, 3.636496147385899*^9, {
   3.636496214996418*^9, 3.636496253372485*^9}, 3.6364964311815977`*^9, {
   3.6364969697417445`*^9, 3.6364969814261646`*^9}, {3.636762383421364*^9, 
   3.6367623872745705`*^9}, 3.725592441562623*^9, 3.7255925278151746`*^9, 
   3.7255944795378036`*^9, {3.72559451145546*^9, 3.7255945146846657`*^9}, 
   3.7255953568521447`*^9, 3.725595801020926*^9, 3.725595862875035*^9, 
   3.725596145750332*^9, 3.72559634416708*^9, 3.7255964017623816`*^9, {
   3.725600882543482*^9, 3.725600909469129*^9}, 3.725601380552758*^9, 
   3.725771260842998*^9, {3.725774253989055*^9, 3.725774282505905*^9}, {
   3.725774385294486*^9, 3.725774424243362*^9}, {3.7257804563043575`*^9, 
   3.7257804693615804`*^9}, 3.7258490252477674`*^9, 3.7258521016447725`*^9, 
   3.725852258877449*^9, 3.725852363803233*^9, 3.7258524000108967`*^9, 
   3.725852749623111*^9, {3.7258530098159676`*^9, 3.7258530484884357`*^9}, {
   3.7258533935578427`*^9, 3.7258534235566955`*^9}, {3.725853537717696*^9, 
   3.725853546578511*^9}, 3.726913461460272*^9, {3.7269135067003517`*^9, 
   3.726913506715952*^9}, 3.726913573655669*^9, 3.7269142247852125`*^9, {
   3.726914355279442*^9, 3.726914372969873*^9}, 3.7269144359471836`*^9, 
   3.7269145160221243`*^9, 3.726914654581568*^9, 3.726914723206088*^9, {
   3.7269151216475897`*^9, 3.726915129884404*^9}, 3.726915517287485*^9, {
   3.726942972603111*^9, 3.7269429731335115`*^9}, 3.726952629442474*^9, 
   3.7269527024818025`*^9, {3.7325814358471437`*^9, 3.732581510446475*^9}, 
   3.7325815475277395`*^9, {3.7326584462775297`*^9, 3.732658472844376*^9}, {
   3.732658943126403*^9, 3.732658966682444*^9}, 3.7326593293998823`*^9, 
   3.732668442777998*^9, {3.7402181611597123`*^9, 3.740218186072956*^9}, 
   3.740218232124237*^9, {3.7402183905893154`*^9, 3.7402183918841176`*^9}, 
   3.740218439771809*^9, 3.7402184717362657`*^9, {3.740218744752345*^9, 
   3.740218755048363*^9}, {3.7402188877977967`*^9, 3.740218953427112*^9}, {
   3.7402206710333304`*^9, 3.740220709690198*^9}, 3.740623517482953*^9, {
   3.740778612338074*^9, 3.740778614194477*^9}, {3.740778697514224*^9, 
   3.740778713769452*^9}, {3.7407792507571983`*^9, 3.740779281707652*^9}, {
   3.7407793154973116`*^9, 3.7407793317681403`*^9}, {3.74077962170185*^9, 
   3.740779646209493*^9}, 3.7407805331690516`*^9, 3.7407805721691203`*^9, 
   3.7407807771378803`*^9, 3.7407824673731785`*^9, 3.740784298882004*^9, 
   3.740784367336528*^9, 3.7407845511906676`*^9, 3.7407847911139035`*^9, 
   3.740785320891444*^9, {3.740792222878537*^9, 3.74079222451654*^9}, 
   3.740795734391115*^9, 3.7407958434197063`*^9, 3.7407962499408207`*^9, 
   3.740796287817687*^9, 3.7407968561734858`*^9, 3.7407968980127587`*^9, {
   3.7411140633022857`*^9, 3.741114065189889*^9}, 3.7411141817688937`*^9, {
   3.7411142451362047`*^9, 3.7411142815778685`*^9}, {3.7411143643984146`*^9, 
   3.741114394927668*^9}, 3.741114449028563*^9, 3.741165053951681*^9, 
   3.7411667429098487`*^9, 3.741166800005949*^9, 3.741167002587905*^9, 
   3.7418927044966946`*^9, 3.744663705024823*^9, 3.744664181730461*^9, 
   3.7446656128001237`*^9, 3.7446656519405923`*^9, 3.7447503917826357`*^9, 
   3.744875558139942*^9, 3.745212724418641*^9, 3.7452130520192165`*^9, 
   3.7452134415987005`*^9, {3.7452134772759633`*^9, 3.745213477884364*^9}, 
   3.745213581842947*^9, 3.745213760572461*^9, {3.7452137926617174`*^9, 
   3.7452138142521553`*^9}, {3.7452138718318567`*^9, 3.745213901846309*^9}, 
   3.74521397072043*^9, {3.7452140044788895`*^9, 3.745214017692113*^9}, {
   3.745215374934097*^9, 3.745215398848939*^9}, 3.745215733004327*^9, {
   3.745215869754167*^9, 3.74521587134537*^9}, {3.7452159052910295`*^9, 
   3.7452159092066364`*^9}, {3.745215982604765*^9, 3.7452159998115954`*^9}, 
   3.7452162565100465`*^9, 3.74605199750873*^9, {3.7460524917799983`*^9, 
   3.7460525007812138`*^9}, 3.7460544899795113`*^9, 3.74605461420253*^9, {
   3.746054731577136*^9, 3.746054777706417*^9}, {3.7460548234768972`*^9, 
   3.7460548417133293`*^9}, 3.746054911461052*^9, 3.7469916527895885`*^9, 
   3.746995583616094*^9, 3.7469956167661524`*^9, {3.7469957258615446`*^9, 
   3.7469957275151477`*^9}, {3.746995760977206*^9, 3.746995762147208*^9}, {
   3.7469958133464985`*^9, 3.746995836512539*^9}, 3.746995880816617*^9, {
   3.7469959276946993`*^9, 3.746995931984707*^9}, {3.7470008112785206`*^9, 
   3.7470008135717244`*^9}, {3.7470008798094406`*^9, 3.747000881369444*^9}, {
   3.747027563106309*^9, 3.74702756362111*^9}, {3.747028030906732*^9, 
   3.747028033511936*^9}, 3.7481111814917364`*^9, 3.7481112473238516`*^9, 
   3.748111472572647*^9, 3.748111511900316*^9, 3.748111751157937*^9, 
   3.7481117965072165`*^9, 3.748111837706889*^9, 3.7481119389198666`*^9, 
   3.748112002271578*^9, 3.7481126431207037`*^9, 3.7481127702141266`*^9, 
   3.748112890599538*^9, 3.748112975042486*^9, {3.748113023496172*^9, 
   3.748113025196574*^9}, 3.748113104850314*^9, 3.7481148783458304`*^9, 
   3.748152378124942*^9, 3.748156761576641*^9, 3.749668426627076*^9, 
   3.7507169093079185`*^9, {3.750717434654441*^9, 3.7507174520016713`*^9}, 
   3.7507179985374317`*^9, 3.7507180693303566`*^9, 3.750718107222823*^9, {
   3.750718237732652*^9, 3.7507182378574524`*^9}, 3.750718351924853*^9, {
   3.750719888347952*^9, 3.75071989302796*^9}, 3.75072066733372*^9, 
   3.750724214763152*^9, 3.7507255977531834`*^9, 3.7507440011381135`*^9, {
   3.7507441014618897`*^9, 3.7507441048314953`*^9}, 3.7511831548137474`*^9, 
   3.7511832008026285`*^9, {3.751189420749557*^9, 3.7511894221223593`*^9}, {
   3.751189545112975*^9, 3.7511895500581837`*^9}, {3.751191026389179*^9, 
   3.751191036263996*^9}, {3.7511922279880896`*^9, 3.75119225077973*^9}, {
   3.7512741081272516`*^9, 3.7512741083924522`*^9}, 3.751343680793913*^9, {
   3.7513437352380085`*^9, 3.751343748076831*^9}, {3.751343859991428*^9, 
   3.7513438704746466`*^9}, 3.751343972284826*^9, {3.751344206045637*^9, 
   3.751344228946477*^9}, {3.751345479654274*^9, 3.751345479669874*^9}, 
   3.7513458163340654`*^9, {3.7513459501355004`*^9, 3.751345950946702*^9}, 
   3.751346259250044*^9, {3.75134772036421*^9, 3.751347750955864*^9}, {
   3.7513478386904173`*^9, 3.7513478502656384`*^9}, {3.7513480264523478`*^9, 
   3.7513480387451687`*^9}, {3.751356659578311*^9, 3.7513566652723207`*^9}, {
   3.7513584868487215`*^9, 3.751358487051522*^9}, {3.7513587764620385`*^9, 
   3.7513587766960387`*^9}, 3.751359217521613*^9, 3.755049981961158*^9, 
   3.755050081910534*^9, 3.7550501621414747`*^9, {3.7550504076079054`*^9, 
   3.7550504105563107`*^9}, 3.755050934296031*^9, 3.7550519317455764`*^9, {
   3.7550519933656845`*^9, 3.7550521232671127`*^9}, 3.7550521578835735`*^9, 
   3.755061383808256*^9, 3.755137961376438*^9, {3.7551380194709396`*^9, 
   3.755138043448182*^9}, 3.7551380790006447`*^9, {3.755138180494423*^9, 
   3.7551382149704833`*^9}, 3.7551383199274673`*^9, {3.7551384479880924`*^9, 
   3.755138485646559*^9}, {3.7551385328522415`*^9, 3.755138535301446*^9}, {
   3.7551388552780085`*^9, 3.755138867898431*^9}, {3.755138899379286*^9, 
   3.755138900923689*^9}, {3.755141473017996*^9, 3.7551414735015965`*^9}, 
   3.7551423127060127`*^9, 3.755143428371771*^9, {3.7551475899709272`*^9, 
   3.7551475974589405`*^9}, {3.755147763630432*^9, 3.755147798215693*^9}, 
   3.7552236306629615`*^9, 3.7552237351007524`*^9, {3.7552274948275833`*^9, 
   3.7552275018475957`*^9}, 3.7642903579671755`*^9, {3.7642905351382875`*^9, 
   3.764290614448827*^9}, 3.764290670343725*^9, {3.7642907227754173`*^9, 
   3.7642907831007233`*^9}, {3.764290822865193*^9, 3.7642908322408094`*^9}, 
   3.7642909401461987`*^9, {3.76429097484066*^9, 3.764290976041862*^9}, 
   3.764291199136257*^9, {3.7642913149984617`*^9, 3.7642913174008656`*^9}, 
   3.7642916029593673`*^9, 3.764302351074251*^9, 3.7643023945203276`*^9, 
   3.764304227843149*^9, 3.7643178515372825`*^9, 3.76432045498466*^9, 
   3.764370158357931*^9, 3.7643729553032446`*^9, {3.764374606185746*^9, 
   3.764374606466547*^9}, 3.7643849800828085`*^9, 3.764385335676648*^9, {
   3.7646681230006466`*^9, 3.764668147102689*^9}, {3.764668200189582*^9, 
   3.764668201515584*^9}, {3.764668246396863*^9, 3.764668249766469*^9}, 
   3.764668283384528*^9, 3.7646685415805817`*^9, 3.764887973275304*^9, 
   3.764888009139767*^9, 3.7648889009273357`*^9, {3.764890388914151*^9, 
   3.7648904010509725`*^9}, {3.764890438990239*^9, 3.764890439130639*^9}, 
   3.7648906343181825`*^9, 3.76489671665236*^9, 3.7650607837398424`*^9, 
   3.7651708746570864`*^9, 3.7651709275255795`*^9, {3.7651715865911446`*^9, 
   3.7651716002099686`*^9}, {3.765172130556101*^9, 3.7651721436133237`*^9}, 
   3.765258860522336*^9, 3.7652589119088264`*^9, 3.765267845342927*^9, 
   3.766219677032467*^9, 3.766219733644967*^9, 3.766220205062195*^9, 
   3.766224732047748*^9, {3.766371669949203*^9, 3.766371670120803*^9}, {
   3.7664771998922896`*^9, 3.7664772214515276`*^9}, {3.7664774867767935`*^9, 
   3.7664775002396173`*^9}, {3.768845899023299*^9, 3.768845913219324*^9}, {
   3.7688464421018543`*^9, 3.7688464430066557`*^9}, {3.768846907500272*^9, 
   3.768846908498674*^9}, {3.7756127056776414`*^9, 3.7756127085636463`*^9}, 
   3.7919252574583597`*^9, 3.791925346562312*^9, 3.7919254153117027`*^9, {
   3.7919255247077045`*^9, 3.791925531253033*^9}, 3.791925598002926*^9, {
   3.791925817141368*^9, 3.791925857178751*^9}, {3.7919259309425774`*^9, 
   3.791925933801317*^9}, {3.7919260057136*^9, 3.791926009212773*^9}, {
   3.79192660049582*^9, 3.7919266190539074`*^9}, {3.7919271891237907`*^9, 
   3.7919272245842*^9}, {3.7919274867894063`*^9, 3.791927489554371*^9}, {
   3.791927538745885*^9, 3.791927604824026*^9}, {3.7919283206321373`*^9, 
   3.791928328770767*^9}, 3.7919283681131506`*^9, 3.791941147556281*^9, 
   3.791941226943779*^9, {3.791943064803152*^9, 3.791943072441972*^9}, 
   3.7919455853419733`*^9, 3.7919456390636563`*^9, 3.7919457301594105`*^9, {
   3.7919460176571693`*^9, 3.791946064630477*^9}, 3.7919462776270447`*^9, {
   3.7919463420805435`*^9, 3.7919463444393888`*^9}, {3.791948507232851*^9, 
   3.7919485077639413`*^9}, 3.7921427775327096`*^9, 3.7921428813674984`*^9, {
   3.7921430077438335`*^9, 3.7921430285982695`*^9}, {3.792143075102886*^9, 
   3.792143196527261*^9}, 3.7921432320813465`*^9, {3.7921435108289423`*^9, 
   3.7921435112507515`*^9}, {3.792144994000306*^9, 3.7921450236495314`*^9}, 
   3.7921450984755683`*^9, {3.792145135779237*^9, 3.7921451459487057`*^9}, 
   3.7921451813309965`*^9, {3.7921455405896435`*^9, 3.792145540823963*^9}, {
   3.792184495223648*^9, 3.7921844998788123`*^9}, {3.792184623771303*^9, 
   3.7921846334096813`*^9}, {3.792206627230712*^9, 3.792206627230712*^9}, 
   3.7922067487800713`*^9, {3.792206857551155*^9, 3.7922068652212453`*^9}, 
   3.79220731139717*^9, 3.7922074804352627`*^9, {3.792207911722797*^9, 
   3.792207920220762*^9}, 3.7922106315283227`*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709234165945`*^9, 3.7922709273375435`*^9}, 
   3.7922709952589617`*^9, 3.792271044919084*^9, {3.7922714000850353`*^9, 
   3.7922714133162184`*^9}, {3.79227225780206*^9, 3.7922722845301075`*^9}, 
   3.7922726379453006`*^9, 3.792538656581356*^9, 3.792538928359619*^9, {
   3.79253897772618*^9, 3.7925389929881973`*^9}, 3.792539105239499*^9, 
   3.7925391544309196`*^9, {3.7925392146979003`*^9, 3.7925392318501225`*^9}, {
   3.792553251880274*^9, 3.7925533135219245`*^9}, {3.792553558651388*^9, 
   3.7925535983294907`*^9}, 3.7925536300406995`*^9, 3.792553977661547*^9, 
   3.7934110765855913`*^9, 3.802546778036353*^9, 3.8025468148870387`*^9, 
   3.802552822458405*^9, {3.8025530544662237`*^9, 3.8025530844279113`*^9}, {
   3.802553133713169*^9, 3.8025531354783773`*^9}, {3.8025532097421217`*^9, 
   3.8025532578048534`*^9}, {3.802553588023881*^9, 3.802553607941058*^9}, {
   3.8025798334471254`*^9, 3.802579836009097*^9}, 3.8025799428439727`*^9, 
   3.8025826954822035`*^9, 3.807854554258397*^9, 3.807854690828374*^9, {
   3.8078547263903584`*^9, 3.8078547526052713`*^9}, {3.8078547973826*^9, 
   3.8078548259492536`*^9}, 3.807854857290492*^9, {3.807855065442194*^9, 
   3.8078550755771074`*^9}, 3.816906042506902*^9, 3.8169062174197626`*^9, {
   3.8169062961825204`*^9, 3.8169063081953278`*^9}, 3.8169064017358685`*^9, 
   3.8169064565355053`*^9, {3.816906506133236*^9, 3.816906533095647*^9}, 
   3.8169065818185563`*^9, 3.816906741702897*^9, 3.8169069030617733`*^9, 
   3.816911863808765*^9, {3.820806523044219*^9, 3.820806525543599*^9}, {
   3.820806605337228*^9, 3.820806634720892*^9}, {3.820806728870463*^9, 
   3.8208067606910887`*^9}, 3.8208068514664154`*^9, 3.8208068887857084`*^9, {
   3.820806986417849*^9, 3.820806992557019*^9}, 3.820807050543249*^9, 
   3.8208071575179443`*^9, {3.827874604494393*^9, 3.8278746309725633`*^9}, 
   3.828286126815601*^9, 3.828286178522227*^9, {3.8282862114207487`*^9, 
   3.828286249083788*^9}, 3.8282862800765343`*^9, {3.828286322644653*^9, 
   3.828286322972701*^9}, {3.828286357931463*^9, 3.828286378520382*^9}, 
   3.828286413949597*^9, 3.8282865511517544`*^9, 3.828849014384474*^9, {
   3.8482570386544743`*^9, 3.8482570386544743`*^9}, {3.848257162547103*^9, 
   3.8482572050995564`*^9}, 3.8482572474489293`*^9, 3.8482592289492965`*^9, 
   3.8482592632131195`*^9, 3.8482593480525*^9, {3.8482596406568003`*^9, 
   3.848259662354802*^9}, {3.8482598575520773`*^9, 3.848259863863089*^9}, {
   3.848259935769012*^9, 3.848259938174694*^9}, {3.848260033511561*^9, 
   3.8482600702372885`*^9}, {3.848260636230188*^9, 3.848260666894863*^9}, 
   3.8482606989966545`*^9, 3.8482607541243086`*^9, {3.8547617639317226`*^9, 
   3.854761763947344*^9}, 3.854761807093421*^9, {3.854761939287712*^9, 
   3.854761948035654*^9}, {3.854762215597452*^9, 3.8547622692588873`*^9}, {
   3.8547623089584866`*^9, 3.854762311739122*^9}, {3.8547623431746674`*^9, 
   3.854762363654195*^9}, 3.854763519987254*^9, 3.8831684261211495`*^9, 
   3.883168549077005*^9, 3.8831685918169317`*^9, {3.883169007296896*^9, 
   3.88316901865359*^9}, 3.883169538507764*^9, 3.8831706590004115`*^9, 
   3.883170863795307*^9, {3.9565290756180315`*^9, 3.9565290756180315`*^9}, 
   3.9565292781396837`*^9, {3.9565293331424026`*^9, 3.9565293645100403`*^9}, 
   3.9565294692042217`*^9, 3.956529507929509*^9, {3.9565295473808737`*^9, 
   3.9565295677979517`*^9}, {3.9565297430061445`*^9, 
   3.9565297484892626`*^9}, {3.956529847778465*^9, 3.956529900063098*^9}, {
   3.9565301658693733`*^9, 3.956530172289773*^9}, 3.9565304532600217`*^9, 
   3.95656037030962*^9, {3.9565604806586895`*^9, 3.9565605106516905`*^9}, {
   3.956560884861517*^9, 3.956560886423687*^9}, 3.956560954532699*^9, 
   3.9565610181461544`*^9, 3.956561149849616*^9, 3.9565611874970684`*^9, 
   3.956561229659077*^9, {3.9565615712490005`*^9, 3.956561587057831*^9}, 
   3.957887840725542*^9, 3.9578878804193583`*^9, {3.957887921440979*^9, 
   3.9578879407645397`*^9}, {3.957887995079945*^9, 3.9578880194023633`*^9}, 
   3.957888198368905*^9, 3.957938391422511*^9, {3.957974018395235*^9, 
   3.957974045701331*^9}, 3.9579740812398686`*^9, {3.957974117450122*^9, 
   3.9579741398199406`*^9}, 3.9579742459958787`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0300.png\>\"", ",", "rp3dConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.5339551667918453`*^9, 3.5339552009091053`*^9, 3.5470088969568434`*^9, 
   3.5470089640057616`*^9, {3.5501987513788223`*^9, 3.550198751410022*^9}, 
   3.5501988321245637`*^9, {3.5504693115261126`*^9, 3.550469311666513*^9}, 
   3.5531142779343195`*^9, 3.5531143119735794`*^9, 3.5531145798316503`*^9, 
   3.55318508241103*^9, {3.55318525330933*^9, 3.5531852534809303`*^9}, 
   3.553190085153738*^9, 3.553190157912266*^9, 3.553190885227544*^9, {
   3.553190960606876*^9, 3.5531909607628765`*^9}, {3.5532137942008047`*^9, 
   3.553213813825639*^9}, {3.55321412771379*^9, 3.553214156714241*^9}, {
   3.556389588766031*^9, 3.5563895889376307`*^9}, 3.5563898811573443`*^9, {
   3.7325812234839706`*^9, 3.7325812239051714`*^9}, 3.7326535205260754`*^9, {
   3.7326591250071225`*^9, 3.7326591252255225`*^9}, 3.732659348416316*^9, 
   3.7402167509688253`*^9, 3.740218234479841*^9, 3.740218993768783*^9, 
   3.740778618671685*^9, {3.7407806106543875`*^9, 3.740780610810388*^9}, {
   3.740782307394898*^9, 3.7407823078160987`*^9}, {3.7407957072626677`*^9, 
   3.740795732191511*^9}, 3.7411140683254943`*^9, {3.7411141195091844`*^9, 
   3.7411141197119846`*^9}, 3.7411667406790447`*^9, {3.7411668525936413`*^9, 
   3.7411668526872416`*^9}, {3.7414211411412773`*^9, 3.7414211413128777`*^9}, 
   3.7446637082540293`*^9, {3.744664383891216*^9, 3.7446643841564164`*^9}, 
   3.7446656128001237`*^9, {3.744665919325062*^9, 3.7446659194654617`*^9}, 
   3.745212728256248*^9, {3.7452127863195496`*^9, 3.7452127865379505`*^9}, 
   3.745215210719808*^9, 3.7452153969769354`*^9, 3.7460519999891343`*^9, {
   3.7460520390048027`*^9, 3.746052039628804*^9}, 3.7460551110166025`*^9, 
   3.7469914786308823`*^9, {3.7469915178025513`*^9, 3.746991547068203*^9}, 
   3.7469916572823963`*^9, 3.7481111850173426`*^9, {3.7481113291771955`*^9, 
   3.748111329348796*^9}, 3.7481126410927*^9, 3.7481132104469*^9, {
   3.750716795334118*^9, 3.7507167978769226`*^9}, 3.750716914752328*^9, 
   3.750907902205965*^9, {3.7509079354808235`*^9, 3.750907935777224*^9}, 
   3.7509082696178102`*^9, 3.751350024917858*^9, 3.7513500920135756`*^9, {
   3.751350335186803*^9, 3.7513503353740034`*^9}, 3.7514001537856855`*^9, {
   3.7550497020342665`*^9, 3.755049702159066*^9}, {3.755049780455604*^9, 
   3.7550497817660065`*^9}, 3.755049981961158*^9, 3.7622835534347343`*^9, 
   3.7622835983940134`*^9, 3.7622836925245786`*^9, 3.7642809470685997`*^9, 
   3.764280993650282*^9, {3.764281062056402*^9, 3.7642810876404467`*^9}, 
   3.7642812103970623`*^9, {3.7642812957916126`*^9, 3.764281295994413*^9}, 
   3.7642914608743176`*^9, 3.7642915591544905`*^9, 3.764664425437742*^9, {
   3.7646645337331324`*^9, 3.7646645339047327`*^9}, {3.7648873895846786`*^9, 
   3.764887389771879*^9}, 3.764887973275304*^9, 3.764889411126232*^9, 
   3.765060236898082*^9, 3.7650607861422467`*^9, {3.765087671387186*^9, 
   3.7650876715275865`*^9}, {3.7651708114457755`*^9, 3.765170811664176*^9}, 
   3.7651708746570864`*^9, 3.765258911924426*^9, {3.765259045601061*^9, 
   3.7652590457882614`*^9}, {3.766219554353852*^9, 3.766219582964302*^9}, 
   3.766219677032467*^9, 3.7662202070277977`*^9, 3.7664771998922896`*^9, 
   3.7664773392785344`*^9, 3.7664774867923937`*^9, 3.766477573575346*^9, 
   3.766611931678881*^9, {3.7673939264508924`*^9, 3.767393926622493*^9}, 
   3.768845899023299*^9, 3.768845992139863*^9, 3.7688461046784606`*^9, 
   3.791925257473979*^9, 3.7919260459384813`*^9, {3.791926076384407*^9, 
   3.791926077056122*^9}, 3.7919411447288256`*^9, 3.7919412585144467`*^9, {
   3.791945587700791*^9, 3.7919456092894487`*^9}, 3.7921427775327096`*^9, {
   3.7921442396836076`*^9, 3.7921442398866467`*^9}, 3.7921449966246824`*^9, {
   3.7921450490810156`*^9, 3.792145049205987*^9}, 3.792206627230712*^9, {
   3.792208145964188*^9, 3.7922081471983175`*^9}, 3.7922705977436914`*^9, {
   3.7922707178871346`*^9, 3.792270718027725*^9}, 3.792538656581356*^9, 
   3.792554025353397*^9, 3.8025468178550973`*^9, {3.8025468885259333`*^9, 
   3.802546916941086*^9}, 3.8025516349182377`*^9, {3.8025798245429773`*^9, 
   3.8025798309477167`*^9}, 3.8078544471885157`*^9, {3.807854484527757*^9, 
   3.8078544851420836`*^9}, 3.8078545576323867`*^9, 3.8169060469746084`*^9, 
   3.8169068200344243`*^9, 3.816906860056246*^9, 3.8208064231928377`*^9, 
   3.82080645710668*^9, 3.8208065296052046`*^9, {3.827874604510014*^9, 
   3.8278746309725633`*^9}, 3.8278748592717104`*^9, 3.827874904026807*^9, 
   3.828286644676685*^9, 3.8482570386544743`*^9, 3.8482570746303196`*^9, 
   3.8482571201821003`*^9, 3.854761763962966*^9, {3.8547618360100236`*^9, 
   3.8547618598794146`*^9}, {3.883168591832553*^9, 3.8831686183106723`*^9}, {
   3.883168650240633*^9, 3.883168650334363*^9}, 3.9565290756336536`*^9, {
   3.9565292024855556`*^9, 3.9565292194190598`*^9}, 3.956560367857068*^9, 
   3.95656044477652*^9, 3.9565611476001225`*^9, {3.956561712606456*^9, 
   3.9565617127314644`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ip3dConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"ImPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1.9"}], "-", 
       RowBox[{"1.3", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{"1.3", "+", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1000"}], ",", "1000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "480"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.97"}], ",", 
       RowBox[{"-", "1.46"}], ",", "2.40"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "100"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "2"}], "}"}], ",", "20"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "380"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221546276207`*^9}, {3.533956568630308*^9, 3.533956665834079*^9}, 
   3.533956762975449*^9, 3.534709995286988*^9, 3.5347102702566714`*^9, {
   3.534710307587537*^9, 3.5347103104111423`*^9}, {3.5355943645733566`*^9, 
   3.535594376788178*^9}, 3.535594491198779*^9, 3.5364644067701993`*^9, 
   3.5470089687325697`*^9, 3.5470091814857435`*^9, 3.547010097738553*^9, 
   3.5470101745878887`*^9, {3.5470102237747755`*^9, 3.547010237268799*^9}, {
   3.547010380711051*^9, 3.5470103817718525`*^9}, {3.5470104851844344`*^9, 
   3.547010496198054*^9}, {3.5470106544943323`*^9, 3.5470106643379498`*^9}, 
   3.5501988381617746`*^9, 3.5501990644401717`*^9, 3.5501999267834873`*^9, 
   3.55019999637521*^9, 3.5502073267184286`*^9, 3.5502076353347707`*^9, 
   3.5502077484661694`*^9, 3.550207835311522*^9, 3.5502086336303244`*^9, 
   3.550208731848097*^9, 3.550210071001249*^9, 3.550347114335082*^9, {
   3.550801163206278*^9, 3.550801166139083*^9}, 3.550801269660865*^9, 
   3.550828851690422*^9, 3.5531145252783546`*^9, 3.5531145863212614`*^9, 
   3.55311514895185*^9, {3.5531151847383127`*^9, 3.553115215641967*^9}, 
   3.553115260164445*^9, {3.5531154473135815`*^9, 3.553115448514784*^9}, 
   3.5531154849408474`*^9, 3.553184125130948*^9, 3.5531844635735426`*^9, 
   3.553184932650767*^9, {3.5531850286689353`*^9, 3.5531850425373597`*^9}, {
   3.5534455293427954`*^9, 3.553445530746798*^9}, {3.5534883365952864`*^9, 
   3.553488340932094*^9}, 3.553543103023369*^9, {3.5642903301670055`*^9, 
   3.5642903301670055`*^9}, {3.564291253782228*^9, 3.564291279803074*^9}, {
   3.564291310691128*^9, 3.5642913116739297`*^9}, 3.5642913605800157`*^9, 
   3.5642913913588696`*^9, 3.5645701775490894`*^9, 3.5645702349415903`*^9, {
   3.5645704646519933`*^9, 3.5645704806576214`*^9}, {3.564632162083235*^9, 
   3.5646321622704353`*^9}, {3.5672835744635324`*^9, 3.567283599189576*^9}, 
   3.567283658984481*^9, 3.567283712648576*^9, {3.5672837757506866`*^9, 
   3.5672838367779937`*^9}, 3.567283936711769*^9, 3.5672839671942225`*^9, 
   3.567749304927465*^9, 3.567802786200432*^9, 3.5678028867426085`*^9, 
   3.568197679377499*^9, 3.5681977398588057`*^9, {3.568197770497259*^9, 
   3.568197789934893*^9}, 3.568197954873983*^9, 3.570075573527918*^9, 
   3.5700756161159925`*^9, 3.5700766576674213`*^9, {3.570086891428359*^9, 
   3.5700868916123695`*^9}, {3.570087021291787*^9, 3.5700870234839125`*^9}, {
   3.570087084260389*^9, 3.5700871039165125`*^9}, 3.5700872267835407`*^9, {
   3.5700962429593163`*^9, 3.570096251367731*^9}, 3.5700963382910833`*^9, 
   3.573604824020702*^9, 3.573604898479633*^9, 3.5736049445153136`*^9, {
   3.5736050810779533`*^9, 3.5736051059131975`*^9}, 3.573605138158454*^9, 
   3.5736051863625383`*^9, {3.573605233568221*^9, 3.5736052565938616`*^9}, 
   3.573605861250924*^9, 3.5736059303122454`*^9, 3.5736059609350986`*^9, {
   3.573605994537558*^9, 3.5736059957855597`*^9}, 3.573606094143733*^9, 
   3.5736061630646544`*^9, {3.5736066875826025`*^9, 3.5736067019502277`*^9}, 
   3.573615827794015*^9, 3.573616064212538*^9, {3.5736161174245815`*^9, 
   3.573616176377953*^9}, 3.573616231172087*^9, 3.573616275574627*^9, {
   3.5736164520657215`*^9, 3.5736164539218273`*^9}, {3.574885930536127*^9, 
   3.574885961158981*^9}, {3.5748860538543434`*^9, 3.574886055414346*^9}, {
   3.57488610316603*^9, 3.574886104788433*^9}, 3.575772368950635*^9, 
   3.575772414543243*^9, {3.5757724483991795`*^9, 3.575772496190913*^9}, {
   3.575772614086656*^9, 3.5757726286944914`*^9}, 3.5757726590812297`*^9, {
   3.5759741411197433`*^9, 3.5759741561581697`*^9}, {3.5759742021002502`*^9, 
   3.5759742157346745`*^9}, 3.5768732485823507`*^9, {3.5768733225420804`*^9, 
   3.576873346644123*^9}, {3.5768734557819147`*^9, 3.576873461850325*^9}, {
   3.5768734924263787`*^9, 3.57687352147363*^9}, {3.5770554598819695`*^9, 
   3.577055463204776*^9}, 3.5778715362491693`*^9, {3.5778716912240334`*^9, 
   3.577871702816696*^9}, 3.5778717565767713`*^9, {3.5778718371413794`*^9, 
   3.577871932399828*^9}, 3.5779963889137025`*^9, {3.5779971639186645`*^9, 
   3.577997164261865*^9}, 3.577997327712983*^9, {3.5779973707690587`*^9, 
   3.577997383857482*^9}, 3.577997501216488*^9, {3.592182738845936*^9, 
   3.592182738861536*^9}, 3.592182944360697*^9, 3.5921830186012273`*^9, 
   3.592189432880093*^9, 3.592189463674547*^9, {3.592189504297019*^9, 
   3.592189506559023*^9}, 3.592189562375921*^9, {3.592189594262377*^9, 
   3.5921896106424055`*^9}, 3.5921897904795218`*^9, 3.592189846156019*^9, 
   3.592355462843272*^9, 3.59938841163758*^9, {3.599388677087646*^9, 
   3.599388684560059*^9}, 3.5993887418121595`*^9, 3.5993887919038477`*^9, 
   3.599389809202035*^9, 3.5994506393849616`*^9, 3.606352380183405*^9, {
   3.6063536387788167`*^9, 3.606353654363244*^9}, {3.606353693441313*^9, 
   3.6063537178865557`*^9}, 3.606354117960466*^9, {3.6063541792997737`*^9, 
   3.606354199065008*^9}, 3.606354347452469*^9, {3.606355491121396*^9, 
   3.606355500497013*^9}, {3.6063556639697*^9, 3.606355691815749*^9}, {
   3.606355951598206*^9, 3.606355974249446*^9}, 3.6063566362550087`*^9, 
   3.6063623067270436`*^9, 3.6063641073134065`*^9, 3.6063646163423004`*^9, {
   3.606424064606145*^9, 3.606424095525399*^9}, 3.606435037067684*^9, 
   3.6253066976903305`*^9, 3.6253067308559885`*^9, {3.625307148703523*^9, 
   3.6253071524163303`*^9}, 3.6253071875163918`*^9, 3.6253072177180443`*^9, {
   3.625307746315781*^9, 3.625307759903405*^9}, {3.625307823676317*^9, 
   3.625307828637126*^9}, 3.62530786493839*^9, 3.625308047693511*^9, {
   3.6253081020908065`*^9, 3.6253081157564306`*^9}, {3.6253833845823274`*^9, 
   3.6253833858459296`*^9}, 3.6253834204935904`*^9, 3.6291871979741755`*^9, 
   3.6291872594694834`*^9, {3.6291872945851455`*^9, 3.6291873218851933`*^9}, 
   3.6291877401579294`*^9, 3.6291877836352053`*^9, 3.6291878504345226`*^9, 
   3.629188085136935*^9, {3.6291893908088293`*^9, 3.62918939137043*^9}, 
   3.629412984390986*^9, {3.6296819408526163`*^9, 3.629681967825063*^9}, 
   3.6296830686522045`*^9, {3.6296838311971436`*^9, 3.629683868200409*^9}, 
   3.629684076866375*^9, 3.6296853116949444`*^9, 3.6301301057327366`*^9, 
   3.630186815320861*^9, 3.630191351912052*^9, {3.630191442251811*^9, 
   3.630191443047412*^9}, {3.6301915674264307`*^9, 3.630191567582431*^9}, 
   3.630191627034135*^9, 3.6301916686862087`*^9, {3.630191698872261*^9, 
   3.630191748199548*^9}, 3.6301925032876744`*^9, 3.6302240261576805`*^9, 
   3.6325489666245556`*^9, 3.6325493494752283`*^9, 3.632549601344486*^9, 
   3.6325497935128317`*^9, {3.6325499103370447`*^9, 3.632549935952289*^9}, {
   3.6326052493632545`*^9, 3.6326052629040785`*^9}, 3.63278969455567*^9, {
   3.632789742073353*^9, 3.632789791213439*^9}, 3.632789884486003*^9, 
   3.63279000237541*^9, 3.632798142408646*^9, 3.6327982664912643`*^9, 
   3.6328077266600885`*^9, 3.6328077568617415`*^9, {3.6328139368782277`*^9, 
   3.6328140112279577`*^9}, {3.632814042646413*^9, 3.6328140428492136`*^9}, {
   3.6328142255199356`*^9, 3.6328142422743645`*^9}, {3.6328628377011323`*^9, 
   3.6328628382471333`*^9}, 3.632863071561143*^9, 3.6328903827053213`*^9, {
   3.63450396414303*^9, 3.634503989945475*^9}, 3.634505031134311*^9, {
   3.6345050814287996`*^9, 3.6345050826300015`*^9}, {3.634505119567073*^9, 
   3.6345051390203075`*^9}, {3.63450518026678*^9, 3.6345051946500053`*^9}, {
   3.634505252089306*^9, 3.634505279467354*^9}, {3.6345559523854685`*^9, 
   3.634555955614674*^9}, 3.634556221122741*^9, {3.6360748556676345`*^9, 
   3.636074857804838*^9}, 3.6360754056294017`*^9, 3.6360755416304407`*^9, {
   3.636075572097294*^9, 3.6360755749364986`*^9}, 3.6360756677410617`*^9, 
   3.6360760229536858`*^9, {3.6360760624173627`*^9, 3.6360760925254154`*^9}, 
   3.6360761236318703`*^9, {3.636495351875679*^9, 3.636495380361329*^9}, 
   3.636495512727562*^9, 3.6364955557680373`*^9, 3.636495774451644*^9, {
   3.636495808288103*^9, 3.6364958628569994`*^9}, 3.636495995379232*^9, 
   3.6364961521595078`*^9, 3.6364963213886046`*^9, 3.636496426595189*^9, 
   3.636496986184173*^9, {3.6367624760855265`*^9, 3.636762479361532*^9}, 
   3.7255924293790016`*^9, 3.7255925317463818`*^9, 3.7255944743117948`*^9, {
   3.725594518943473*^9, 3.7255945214862776`*^9}, 3.7255953603777514`*^9, 
   3.7255957972769194`*^9, {3.7255958312537794`*^9, 3.7255958481174088`*^9}, {
   3.725596058390178*^9, 3.7255960649109898`*^9}, 3.7255963371938677`*^9, 
   3.72559640661399*^9, {3.725601386418369*^9, 3.7256014341076527`*^9}, 
   3.7257712704994154`*^9, 3.725774257093461*^9, 3.72577429072712*^9, {
   3.725774416443348*^9, 3.7257744278937683`*^9}, 3.725779901988584*^9, 
   3.72578045202995*^9, 3.7258490308793774`*^9, 3.7258521063247805`*^9, 
   3.725852262605855*^9, 3.725852360558427*^9, 3.7258524069529085`*^9, 
   3.725852753257917*^9, 3.725853436567118*^9, {3.7258534847400026`*^9, 
   3.7258535107140484`*^9}, {3.725853667353924*^9, 3.7258536787419434`*^9}, 
   3.726913461475872*^9, {3.726913506715952*^9, 3.7269135067315516`*^9}, 
   3.726913573655669*^9, 3.7269142285136194`*^9, {3.7269143657158604`*^9, 
   3.7269143772130804`*^9}, 3.726914441095193*^9, 3.7269145189861298`*^9, 
   3.726914651929563*^9, 3.7269147274648952`*^9, 3.726915143191228*^9, {
   3.7269151750932837`*^9, 3.7269151752336836`*^9}, {3.7269155027638597`*^9, 
   3.726915507599868*^9}, {3.726942965317898*^9, 3.7269429659418993`*^9}, 
   3.7269527321998544`*^9, {3.732581567667375*^9, 3.732581616495461*^9}, {
   3.732658450427137*^9, 3.732658468772769*^9}, {3.732658950832816*^9, 
   3.7326589718928533`*^9}, 3.7326593484319158`*^9, 3.7326684474112062`*^9, {
   3.740218164622918*^9, 3.740218189130562*^9}, 3.7402182402830515`*^9, {
   3.7402183944893227`*^9, 3.7402184164385605`*^9}, 3.740218476010673*^9, 
   3.740218965392333*^9, 3.7402207306098347`*^9, 3.740623523847764*^9, {
   3.7407786224156923`*^9, 3.7407786244124956`*^9}, {3.740778719260662*^9, 
   3.7407787320526843`*^9}, {3.7407792555464067`*^9, 3.7407793011608863`*^9}, 
   3.7407793394121532`*^9, {3.740779664601926*^9, 3.7407796776747484`*^9}, 
   3.7407805414526663`*^9, 3.740780576287527*^9, 3.7407807802890854`*^9, 
   3.74078247376919*^9, {3.7407839511537724`*^9, 3.7407839979846582`*^9}, 
   3.7407842696709504`*^9, {3.740784331289063*^9, 3.7407843341800685`*^9}, {
   3.740784465266109*^9, 3.7407844673429127`*^9}, 3.740784531285632*^9, 
   3.74078474467282*^9, {3.740785226216671*^9, 3.740785234380486*^9}, {
   3.74079231722311*^9, 3.740792318034312*^9}, 3.740795728899905*^9, 
   3.740795848146515*^9, 3.740796253029626*^9, 3.7407962960389013`*^9, 
   3.7407968627566967`*^9, 3.7407969034103684`*^9, {3.7411140723503017`*^9, 
   3.7411140740039043`*^9}, 3.7411141862149014`*^9, {3.7411142414077983`*^9, 
   3.7411142788634644`*^9}, {3.741114361278409*^9, 3.741114362464011*^9}, 
   3.741114397938473*^9, 3.7411144525385695`*^9, 3.741165060176092*^9, 
   3.741166736872638*^9, 3.7411668048419576`*^9, 3.741167005957511*^9, 
   3.741892706493498*^9, 3.7446637127156367`*^9, 3.744664185162467*^9, 
   3.7446656128001237`*^9, 3.7446656519561925`*^9, 3.7447503942786407`*^9, 
   3.7448755599807453`*^9, 3.7452127385678663`*^9, 3.7452130555136228`*^9, 
   3.7452134456391077`*^9, {3.7452134806767693`*^9, 3.7452134813007703`*^9}, 
   3.745213585493354*^9, 3.745213767873274*^9, {3.7452137983869276`*^9, 
   3.7452138193377643`*^9}, {3.745213904810314*^9, 3.7452139139363303`*^9}, {
   3.745213949395193*^9, 3.7452139495823927`*^9}, {3.745213986975659*^9, 
   3.74521402177932*^9}, {3.7452153772273006`*^9, 3.7452153940753307`*^9}, {
   3.7452158730613728`*^9, 3.745215903824627*^9}, {3.7452159530895133`*^9, 
   3.7452159792039595`*^9}, 3.745216259770452*^9, 3.7460520035615406`*^9, {
   3.746054453943448*^9, 3.7460544574378543`*^9}, 3.746054497295924*^9, 
   3.746054597682101*^9, {3.7460547541659756`*^9, 3.7460547746800117`*^9}, 
   3.7460548541777515`*^9, 3.746054960086337*^9, 3.746991665534811*^9, 
   3.746995590370906*^9, 3.7469956213057604`*^9, {3.746995729995552*^9, 
   3.746995731243554*^9}, {3.7469957645028124`*^9, 3.746995765407614*^9}, {
   3.746995818198107*^9, 3.7469958661213913`*^9}, {3.7469959375383167`*^9, 
   3.746995941453923*^9}, {3.747000815490528*^9, 3.7470008173313313`*^9}, {
   3.7470008849886503`*^9, 3.7470008863926525`*^9}, {3.7470275513438883`*^9, 
   3.7470275518742895`*^9}, {3.7470280525595703`*^9, 3.7470280552115746`*^9}, 
   3.7481111897753506`*^9, 3.7481112427842436`*^9, 3.748111476535054*^9, 
   3.7481115164555244`*^9, 3.7481117566959467`*^9, 3.7481117914684076`*^9, 
   3.7481118423556967`*^9, 3.7481119434438744`*^9, 3.7481119960783668`*^9, 
   3.7481126379102945`*^9, 3.7481127727725315`*^9, 3.748112894015944*^9, 
   3.7481129700816774`*^9, {3.748113028800181*^9, 3.748113030016983*^9}, 
   3.7481131110123253`*^9, 3.748114875740626*^9, 3.748152382102949*^9, 
   3.748156767894652*^9, 3.749668431509885*^9, 3.7507169249859457`*^9, {
   3.7507174668996973`*^9, 3.750717469458102*^9}, 3.750718004418642*^9, 
   3.750718074774766*^9, 3.7507181111072297`*^9, {3.7507182219610243`*^9, 
   3.7507182332866445`*^9}, 3.7507183577748632`*^9, {3.750719884635145*^9, 
   3.750719897083967*^9}, 3.750720673464531*^9, 3.7507242419383993`*^9, 
   3.7507256027451925`*^9, 3.750744003618518*^9, {3.750744093771076*^9, 
   3.7507440965790815`*^9}, 3.7511831548293476`*^9, 3.7511832008026285`*^9, {
   3.751189424649564*^9, 3.7511894256479654`*^9}, 3.7511895614618044`*^9, {
   3.7511910305075865`*^9, 3.7511910391500015`*^9}, {3.751192237613307*^9, 
   3.751192254305336*^9}, 3.751230212036337*^9, {3.751274116442066*^9, 
   3.7512741166136665`*^9}, 3.751343682541116*^9, {3.751343733085205*^9, 
   3.7513437501204348`*^9}, 3.751344238166094*^9, 3.75134430452861*^9, {
   3.751345479669874*^9, 3.7513454796854744`*^9}, 3.751345820748873*^9, {
   3.7513459524443045`*^9, 3.7513459532399063`*^9}, 3.751346262260849*^9, {
   3.751348105092086*^9, 3.7513481245765195`*^9}, {3.7513566618091145`*^9, 
   3.751356668220726*^9}, {3.751358491060729*^9, 3.7513584912323294`*^9}, {
   3.75135877156363*^9, 3.75135877173523*^9}, 3.751359211999203*^9, 
   3.755049981976758*^9, 3.7550500821133337`*^9, 3.7550501621414747`*^9, {
   3.755050416297121*^9, 3.7550504199943275`*^9}, 3.7550509388668385`*^9, 
   3.7550519367687855`*^9, {3.755051997187691*^9, 3.755052060695403*^9}, 
   3.7550521337191315`*^9, 3.7550521647007856`*^9, 3.7550613876302633`*^9, 
   3.7551379564936295`*^9, {3.755138024930949*^9, 3.7551380411237783`*^9}, 
   3.755138082682251*^9, {3.7551381845348296`*^9, 3.7551382172792873`*^9}, 
   3.7551383234530735`*^9, {3.755138441217681*^9, 3.7551385276106324`*^9}, {
   3.755138882422056*^9, 3.755138897273282*^9}, {3.7551414688371882`*^9, 
   3.7551414693363895`*^9}, 3.755142317557621*^9, 3.755143433067379*^9, {
   3.7551476031529503`*^9, 3.7551476133397684`*^9}, 3.7551478086989117`*^9, 
   3.7552236306785617`*^9, 3.7552237351007524`*^9, {3.7552275045464*^9, 
   3.7552275077132063`*^9}, 3.7642903539579687`*^9, 3.76429053655789*^9, {
   3.7642905687251463`*^9, 3.7642906105332203`*^9}, 3.764290668502922*^9, {
   3.7642907246006203`*^9, 3.764290784832326*^9}, {3.7642908265935993`*^9, 
   3.7642908360628157`*^9}, 3.7642909449510074`*^9, {3.764290981189871*^9, 
   3.764290981876272*^9}, 3.7642912047834673`*^9, {3.764291319491269*^9, 
   3.764291321378873*^9}, 3.764291611398982*^9, 3.7643023539758563`*^9, 
   3.7643023976559334`*^9, 3.764304230323553*^9, 3.7643178534248857`*^9, 
   3.7643204595866685`*^9, 3.764370162398338*^9, 3.764372959000451*^9, {
   3.7643746106161537`*^9, 3.7643746108813543`*^9}, 3.764384946199549*^9, 
   3.764385323602227*^9, 3.7646681264950523`*^9, 3.764668209284398*^9, {
   3.7646682425904565`*^9, 3.7646682533076754`*^9}, 3.764668288563737*^9, 
   3.764668544731787*^9, 3.764887973290904*^9, 3.7648880093425674`*^9, 
   3.7648889030021396`*^9, {3.7648903950293617`*^9, 3.7648904044205785`*^9}, {
   3.764890442796646*^9, 3.7648904429526463`*^9}, 3.7648906360965853`*^9, 
   3.7648967215975685`*^9, 3.765060789137452*^9, 3.7651708746726866`*^9, 
   3.7651709275255795`*^9, {3.765171589180749*^9, 3.765171597479964*^9}, {
   3.765172134970908*^9, 3.765172146390128*^9}, 3.7652588607251368`*^9, 
   3.765258911924426*^9, 3.7652678488217335`*^9, 3.766219677032467*^9, 
   3.766219733644967*^9, 3.766220209789003*^9, 3.766224738350159*^9, {
   3.766371673365609*^9, 3.7663716735372095`*^9}, {3.7664771999078894`*^9, 
   3.766477221467128*^9}, {3.7664774867923937`*^9, 3.7664775002552176`*^9}, {
   3.768845899023299*^9, 3.768845913219324*^9}, {3.768846446688262*^9, 
   3.7688464478114643`*^9}, {3.7688469105734777`*^9, 3.768846911556279*^9}, {
   3.7756127125728536`*^9, 3.775612713805256*^9}, 3.791925257473979*^9, 
   3.7919253465779333`*^9, 3.791925415545993*^9, 3.791925538329486*^9, 
   3.791925601252158*^9, {3.7919258208123755`*^9, 3.791925846181349*^9}, {
   3.7919258965132446`*^9, 3.791925926459304*^9}, {3.791926014071001*^9, 
   3.7919260175701747`*^9}, 3.7919266484290524`*^9, {3.7919272055886946`*^9, 
   3.791927235331627*^9}, {3.7919276582332497`*^9, 3.7919277101428995`*^9}, {
   3.7919283378467164`*^9, 3.7919283439703007`*^9}, 3.791928389264398*^9, 
   3.7919411413389997`*^9, 3.791941230396061*^9, 3.7919430979993715`*^9, 
   3.7919455907781906`*^9, 3.7919456413443985`*^9, 3.791945710086*^9, {
   3.791946022624746*^9, 3.791946071628796*^9}, 3.7919462750182886`*^9, {
   3.7919463468763237`*^9, 3.791946348454059*^9}, {3.7919485149966345`*^9, 
   3.7919485152934113`*^9}, 3.7921427775327096`*^9, 3.7921428844917583`*^9, {
   3.792143012102148*^9, 3.7921430326754313`*^9}, {3.7921430729159*^9, 
   3.7921430957230043`*^9}, {3.792143137525601*^9, 3.7921431788751917`*^9}, 
   3.792143236720871*^9, {3.7921435062050405`*^9, 3.7921435066268454`*^9}, {
   3.792144999623945*^9, 3.792145021384448*^9}, {3.7921451021622267`*^9, 
   3.7921451511037264`*^9}, 3.792145185720539*^9, {3.7921455447136655`*^9, 
   3.792145545432212*^9}, {3.792184507470749*^9, 3.7921845096108675`*^9}, 
   3.792184641720213*^9, {3.792206627246333*^9, 3.792206627246333*^9}, 
   3.792206751388796*^9, {3.792206853864559*^9, 3.7922068746252704`*^9}, 
   3.7922073162553945`*^9, 3.7922074838563423`*^9, {3.792207902303128*^9, 
   3.7922079240167284`*^9}, 3.792210628560286*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709171055946`*^9, 3.7922709214014473`*^9}, 
   3.7922710012262707`*^9, 3.7922710487775407`*^9, {3.7922714048807282`*^9, 
   3.792271416690432*^9}, {3.7922722543810005`*^9, 3.7922722888259625`*^9}, 
   3.7922726333057737`*^9, 3.792538656581356*^9, 3.79253893338968*^9, {
   3.79253897772618*^9, 3.792538997607256*^9}, {3.7925390932423153`*^9, 
   3.7925390962103596`*^9}, 3.792539159820304*^9, 3.792539240269972*^9, {
   3.7925532546452465`*^9, 3.7925533205046535`*^9}, {3.792553601937978*^9, 
   3.7925536273538704`*^9}, 3.79255397433422*^9, 3.7934110830440025`*^9, 
   3.8025467812543383`*^9, 3.8025468240567527`*^9, 3.8025528269104867`*^9, 
   3.802553052279233*^9, 3.802553090613947*^9, {3.802553138758854*^9, 
   3.802553139914831*^9}, {3.8025532126007967`*^9, 3.802553250295064*^9}, {
   3.802553594834815*^9, 3.8025536101749134`*^9}, {3.8025798116085243`*^9, 
   3.8025798132175207`*^9}, 3.802579945624563*^9, 3.802582701183984*^9, 
   3.807854563419881*^9, 3.807854694546463*^9, {3.8078547295149803`*^9, 
   3.8078547561408234`*^9}, {3.8078547919860497`*^9, 3.8078548304791474`*^9}, 
   3.8078548606684666`*^9, 3.807855083466024*^9, 3.816906053582398*^9, 
   3.8169062224342117`*^9, {3.8169062988381157`*^9, 3.8169063060864477`*^9}, 
   3.8169064065628595`*^9, 3.816906461050069*^9, {3.8169064993379393`*^9, 
   3.8169065035244703`*^9}, 3.8169065362667856`*^9, 3.8169065845523252`*^9, 
   3.816906745967521*^9, 3.816906908810424*^9, 3.816911860153344*^9, {
   3.8208065344321394`*^9, 3.8208065372752233`*^9}, {3.8208066098049192`*^9, 
   3.820806629253437*^9}, {3.8208067246527057`*^9, 3.820806757035666*^9}, 
   3.820806846764411*^9, 3.820806898986417*^9, {3.8208069817158995`*^9, 
   3.8208069962436466`*^9}, 3.8208070567761927`*^9, 3.8208071646412573`*^9, {
   3.827874604510014*^9, 3.8278746309881845`*^9}, 3.8282861305022345`*^9, {
   3.8282861822244864`*^9, 3.8282862225431395`*^9}, 3.8282862526298304`*^9, 
   3.8282862842161703`*^9, 3.828286431179902*^9, 3.8282865552758007`*^9, 
   3.8288490182376804`*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571656713667`*^9, 3.8482572003506775`*^9}, 3.848257241247275*^9, 
   3.848259231776729*^9, 3.848259267571465*^9, 3.848259344803232*^9, 
   3.848259673414655*^9, {3.848259861051252*^9, 3.848259867143531*^9}, {
   3.848259941470792*^9, 3.8482599439389577`*^9}, 3.8482600898263903`*^9, 
   3.848260640619811*^9, 3.8482608256478395`*^9, {3.8482609065250673`*^9, 
   3.848260907681044*^9}, {3.8547617639785867`*^9, 3.8547617639785867`*^9}, 
   3.854761809702217*^9, {3.854761942224519*^9, 3.8547619519097843`*^9}, {
   3.8547622351085224`*^9, 3.854762249654128*^9}, 3.854762371152464*^9, 
   3.8547635232989454`*^9, 3.8831684232624483`*^9, 3.8831685493113613`*^9, 
   3.883168591832553*^9, {3.883169010827317*^9, 3.883169014857577*^9}, 
   3.883169424066017*^9, {3.8831694760850053`*^9, 3.8831694856764994`*^9}, 
   3.883170656625969*^9, 3.8831708592182693`*^9, {3.9565290756336536`*^9, 
   3.9565290756336536`*^9}, 3.956529278342761*^9, 3.9565293333611*^9, {
   3.956529367509301*^9, 3.9565293704148693`*^9}, 3.9565294729845495`*^9, 
   3.9565295110113583`*^9, {3.956529552879578*^9, 3.956529563252109*^9}, 
   3.9565298355156817`*^9, 3.9565299092171383`*^9, {3.95653017492978*^9, 
   3.9565301806784286`*^9}, 3.956530444152749*^9, 3.9565603644516945`*^9, 
   3.9565604775188007`*^9, 3.956560515322481*^9, {3.9565608539937935`*^9, 
   3.956560860211093*^9}, 3.956560959234726*^9, 3.9565610203956203`*^9, 
   3.9565611448663774`*^9, 3.9565611934487906`*^9, 3.9565612247226753`*^9, {
   3.956561584542796*^9, 3.956561584652109*^9}, 3.9578878456775055`*^9, 
   3.9578878854962807`*^9, {3.957887925190097*^9, 3.9578879344847903`*^9}, {
   3.9578879996569986`*^9, 3.9578880234951534`*^9}, 3.957888203383353*^9, 
   3.9579383959839053`*^9, {3.957974021628857*^9, 3.9579740523091555`*^9}, 
   3.957974084270421*^9, {3.9579741213866944`*^9, 3.957974142678589*^9}, 
   3.957974248604641*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0310.png\>\"", ",", "ip3dConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5339551753718605`*^9, 3.5339551977422996`*^9}, 
   3.5470088994684477`*^9, 3.5470089727417765`*^9, {3.5501987561524305`*^9, 
   3.55019875626163*^9}, 3.5501988411413794`*^9, {3.550469316159321*^9, 
   3.550469316393321*^9}, {3.5531142826767282`*^9, 3.5531142878403373`*^9}, 
   3.553114589410067*^9, 3.5531850735502143`*^9, 3.5531852580361385`*^9, 
   3.553190088148943*^9, 3.5531901617342725`*^9, 3.553190880875136*^9, {
   3.553190965255684*^9, 3.5531909657236853`*^9}, {3.553213796837209*^9, 
   3.5532138090832305`*^9}, {3.553214132081798*^9, 3.5532141604270477`*^9}, {
   3.55638959965485*^9, 3.5563895998420506`*^9}, 3.5563898856657524`*^9, {
   3.732581228351179*^9, 3.73258122874118*^9}, 3.7326535161424675`*^9, {
   3.732659131075533*^9, 3.7326591312627335`*^9}, 3.7326593484475155`*^9, 
   3.7402167509844255`*^9, 3.740218243403057*^9, 3.74021899790279*^9, 
   3.740778626643299*^9, {3.740780616519998*^9, 3.7407806166603985`*^9}, 
   3.7407823179717164`*^9, {3.740795712629077*^9, 3.7407957267315016`*^9}, 
   3.7411140764375086`*^9, {3.741114125515195*^9, 3.741114125671195*^9}, 
   3.741166734985035*^9, {3.741166859442054*^9, 3.7411668600660543`*^9}, {
   3.741421137522071*^9, 3.741421137662471*^9}, 3.7446637165064435`*^9, 
   3.7446643950296354`*^9, 3.7446656128001237`*^9, {3.7446659247070713`*^9, 
   3.7446659248786716`*^9}, 3.7452127427798734`*^9, {3.7452127929651613`*^9, 
   3.745212793152362*^9}, 3.7452152142298145`*^9, 3.7452153921565275`*^9, 
   3.7460520052775435`*^9, {3.746052046134015*^9, 3.746052046851617*^9}, 
   3.74605511521301*^9, 3.7469914820784883`*^9, {3.746991523184561*^9, 
   3.74699155112421*^9}, 3.746991670152419*^9, 3.748111192864156*^9, {
   3.748111336868009*^9, 3.7481113370708094`*^9}, 3.748112636022691*^9, 
   3.748113214284507*^9, {3.7507168278133755`*^9, 3.7507168307305803`*^9}, 
   3.7507169297439537`*^9, 3.7509079022215652`*^9, {3.750907940301232*^9, 
   3.7509079404728317`*^9}, 3.7509082696334105`*^9, 3.751350024917858*^9, 
   3.7513500920291758`*^9, {3.7513503405844126`*^9, 3.751350340787213*^9}, 
   3.7514002188533993`*^9, {3.7550496972606583`*^9, 3.7550496974946585`*^9}, {
   3.75504978959722*^9, 3.7550497905488214`*^9}, 3.755049981976758*^9, 
   3.762283559846346*^9, {3.762283605102025*^9, 3.762283605258025*^9}, 
   3.7622837044741993`*^9, 3.764280957785819*^9, 3.7642809971446877`*^9, {
   3.7642810687488136`*^9, 3.764281091244053*^9}, {3.764281218056676*^9, 
   3.764281218197076*^9}, 3.764281300721221*^9, 3.76429146773833*^9, 
   3.7642915623056955`*^9, 3.7646644254533424`*^9, {3.764664539785943*^9, 
   3.7646645399731436`*^9}, {3.7648873980398936`*^9, 3.7648873981958942`*^9}, 
   3.764887973290904*^9, {3.764889416149441*^9, 3.7648894163366413`*^9}, {
   3.7650602413440895`*^9, 3.76506024151569*^9}, 3.765060791461856*^9, 
   3.765087677377597*^9, {3.765170815548583*^9, 3.7651708157513833`*^9}, 
   3.7651708746726866`*^9, 3.765258911924426*^9, {3.765259059017085*^9, 
   3.765259059188685*^9}, 3.766219554353852*^9, {3.766219588096711*^9, 
   3.766219588315111*^9}, 3.766219677048067*^9, 3.7662202121290073`*^9, 
   3.7664771999078894`*^9, 3.766477339294134*^9, 3.7664774867923937`*^9, 
   3.766477573575346*^9, {3.76661193684249*^9, 3.7666119369516907`*^9}, {
   3.767393932285303*^9, 3.7673939324413033`*^9}, 3.7688458990388994`*^9, 
   3.768845992139863*^9, 3.7688461103100705`*^9, 3.7919252574896*^9, 
   3.791926049453236*^9, {3.7919260861008263`*^9, 3.791926086913168*^9}, 
   3.791941139339487*^9, 3.7919412617480307`*^9, {3.791945592480884*^9, 
   3.7919456060870748`*^9}, 3.7921427775483007`*^9, {3.7921442451353717`*^9, 
   3.792144245338449*^9}, 3.792145001857826*^9, {3.792145054236045*^9, 
   3.7921450544235*^9}, 3.792206627246333*^9, {3.792208155180749*^9, 
   3.7922081559774384`*^9}, 3.7922705977593207`*^9, {3.7922707237138777`*^9, 
   3.792270723791984*^9}, 3.79253865659698*^9, 3.792554032117412*^9, 
   3.8025468267904854`*^9, {3.802546894868189*^9, 3.802546913582498*^9}, 
   3.8025516394640093`*^9, {3.8025798091715994`*^9, 3.802579817638352*^9}, 
   3.8078544431792603`*^9, {3.8078544925433044`*^9, 3.8078544933671336`*^9}, 
   3.807854566519637*^9, 3.816906057737702*^9, 3.816906822971233*^9, 
   3.8169068639616127`*^9, 3.8208064318782806`*^9, {3.8208064621211166`*^9, 
   3.820806462214844*^9}, 3.820806541039958*^9, {3.8278746045256357`*^9, 
   3.8278746309881845`*^9}, 3.827874859287332*^9, {3.827874908775693*^9, 
   3.827874908963181*^9}, 3.828286648410184*^9, 3.8482570386700907`*^9, 
   3.8482570746303196`*^9, 3.848257124337367*^9, 3.854761763994209*^9, {
   3.8547618395248256`*^9, 3.854761864503364*^9}, {3.883168591832553*^9, 
   3.8831686183106723`*^9}, {3.883168654880164*^9, 3.8831686550051346`*^9}, 
   3.956529075649271*^9, {3.9565292024855556`*^9, 3.95652922354312*^9}, 
   3.9565603622021456`*^9, 3.956560449400402*^9, 3.956561142663807*^9, {
   3.9565617193392906`*^9, 3.9565617194955015`*^9}},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"frpConfHypergeomF4", "=", "\[IndentingNewLine]", 
  RowBox[{"FundamentalRegionPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1.9"}], "-", 
       RowBox[{"1.3", " ", "\[ImaginaryI]"}]}], ",", 
      RowBox[{"1.3", "+", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "z"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "15"}], "-", 
       RowBox[{"30", " ", "I"}]}], ",", 
      RowBox[{"25", "+", 
       RowBox[{"30", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "1000"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"400", ",", "600"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "24"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "280"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.530344234110747*^9, 3.530344269600809*^9, {3.53395684314399*^9, 
   3.5339568911608744`*^9}, {3.533956924529333*^9, 3.533956959972595*^9}, {
   3.533957001359468*^9, 3.5339570248843093`*^9}, {3.5346482317806273`*^9, 
   3.5346482369130363`*^9}, {3.5346484132401457`*^9, 3.534648422927763*^9}, {
   3.534648600908476*^9, 3.534648602874079*^9}, 3.534710001277398*^9, {
   3.534710275763481*^9, 3.5347102880095024`*^9}, {3.534710723484267*^9, 
   3.5347107275246744`*^9}, {3.534710781017168*^9, 3.534710781219969*^9}, {
   3.5347108477228856`*^9, 3.5347108501564903`*^9}, {3.536464399328986*^9, 
   3.5364644013413897`*^9}, 3.5470089850033984`*^9, {3.547009186867753*^9, 
   3.547009193606965*^9}, {3.5470101014513597`*^9, 3.5470101345858183`*^9}, 
   3.5470103852662587`*^9, 3.5501988466325893`*^9, 3.550199068246578*^9, {
   3.5502084668036313`*^9, 3.5502084670064316`*^9}, 3.550208582867835*^9, 
   3.550210551794093*^9, 3.5502106958603463`*^9, {3.550798929203307*^9, 
   3.5507989293125067`*^9}, 3.5531145282735596`*^9, 3.55311459660168*^9, 
   3.553115153538258*^9, 3.553115190603923*^9, 3.553115426549945*^9, 
   3.5531841290621552`*^9, 3.553184841780607*^9, 3.553185595402331*^9, {
   3.5642903301826057`*^9, 3.5642903301826057`*^9}, {3.564291282969879*^9, 
   3.56429128880429*^9}, 3.564291394822076*^9, 3.5645701814958963`*^9, 
   3.564570242882004*^9, {3.564570442328354*^9, 3.5645704448087587`*^9}, 
   3.5646312482712297`*^9, 3.564632058343053*^9, {3.5646323584975805`*^9, 
   3.5646323647687917`*^9}, 3.564706563514888*^9, {3.5647069832336254`*^9, 
   3.564706991033639*^9}, {3.564989542386684*^9, 3.56498954572509*^9}, {
   3.5651175773891916`*^9, 3.565117582833601*^9}, {3.567283577864339*^9, 
   3.5672835875051556`*^9}, {3.5672836659264936`*^9, 
   3.5672836766593122`*^9}, {3.567283716548582*^9, 3.567283718576586*^9}, 
   3.567283973247033*^9, 3.56728425586953*^9, {3.5672842997836075`*^9, 
   3.567284320703244*^9}, 3.5672843556005054`*^9, 3.5677493102314744`*^9, 
   3.56780279067764*^9, 3.567802890923416*^9, {3.567802966739549*^9, 
   3.5678029668955493`*^9}, 3.5681976926063223`*^9, 3.5681977453968153`*^9, {
   3.568197813974536*^9, 3.568197826126957*^9}, {3.5681978838782587`*^9, 
   3.568197918401119*^9}, 3.5700755786291265`*^9, {3.5700756190487976`*^9, 
   3.5700756257724094`*^9}, {3.570086895267579*^9, 3.570086895443589*^9}, 
   3.570087027747156*^9, 3.5700870928118777`*^9, 3.5700872352950277`*^9, {
   3.570096246297722*^9, 3.5700962494177275`*^9}, 3.570606665466712*^9, 
   3.573604837639526*^9, 3.5736049030816407`*^9, 3.5736049498193226`*^9, {
   3.5736050854147615`*^9, 3.573605109750804*^9}, 3.5736051427448616`*^9, {
   3.5736052053321714`*^9, 3.573605205519372*^9}, {3.573605408179328*^9, 
   3.573605433950573*^9}, 3.5736058570857162`*^9, 3.5736059335570507`*^9, 
   3.573605964039504*^9, 3.5736059994827666`*^9, 3.5736060984805403`*^9, {
   3.573606625978094*^9, 3.5736066285832987`*^9}, 3.5736158211856375`*^9, 
   3.5736160693318305`*^9, 3.5736161223258615`*^9, {3.573616182105281*^9, 
   3.573616182321293*^9}, 3.573616236132371*^9, 3.5736164232410727`*^9, {
   3.573692298777257*^9, 3.5736923146424847`*^9}, {3.574885935637336*^9, 
   3.5748859559173717`*^9}, {3.574886059891554*^9, 3.574886060063154*^9}, 
   3.5748861763301587`*^9, 3.57488628534315*^9, 3.575772379966265*^9, {
   3.5757724207015953`*^9, 3.5757725117098007`*^9}, {3.575772591741378*^9, 
   3.5757725927734375`*^9}, {3.575772672229982*^9, 3.5757726811024895`*^9}, 
   3.5757893795025835`*^9, {3.5759741275789194`*^9, 3.5759741492005577`*^9}, 
   3.5759742049082556`*^9, 3.576873260313571*^9, {3.5768733266760874`*^9, 
   3.5768733636481524`*^9}, {3.576961566809566*^9, 3.576961566965566*^9}, 
   3.5778715430075555`*^9, {3.577871696168316*^9, 3.5778716991834884`*^9}, {
   3.577871760471994*^9, 3.5778717880315704`*^9}, 3.5778726548461494`*^9, 
   3.577996394467312*^9, {3.577996527223545*^9, 3.5779965332763557`*^9}, 
   3.5780020367826004`*^9, {3.592182738877136*^9, 3.592182738877136*^9}, 
   3.592182948245104*^9, 3.592183023967637*^9, {3.5921894148308616`*^9, 
   3.5921894250800796`*^9}, 3.592189468058155*^9, 3.59218951063063*^9, {
   3.5921897614790707`*^9, 3.5921897687174835`*^9}, {3.5921898718180647`*^9, 
   3.5921898746416693`*^9}, 3.592190089781647*^9, 3.599383290830182*^9, 
   3.606352387733818*^9, {3.6063536447692275`*^9, 3.6063536521324406`*^9}, {
   3.6063536981837215`*^9, 3.606353720959761*^9}, {3.6063540035186653`*^9, 
   3.60635401782389*^9}, {3.606354435187023*^9, 3.606354443579838*^9}, {
   3.606355512883435*^9, 3.6063555243806553`*^9}, {3.606355667978907*^9, 
   3.606355694748554*^9}, {3.6063559545934114`*^9, 3.60635597637105*^9}, 
   3.6063566455526247`*^9, 3.606364112430215*^9, {3.606364199790369*^9, 
   3.606364203237975*^9}, 3.6063646197275066`*^9, 3.606367676083275*^9, {
   3.625306705256344*^9, 3.6253067345531955`*^9}, {3.6253071577203393`*^9, 
   3.625307191275998*^9}, {3.6253072256584587`*^9, 3.625307230572467*^9}, 
   3.625307268620934*^9, {3.625307476549307*^9, 3.6253074769705076`*^9}, {
   3.6253081892637596`*^9, 3.6253082416486516`*^9}, 3.6253530322619123`*^9, 
   3.6253833808227205`*^9, 3.6253834171083846`*^9, 3.6291872118269997`*^9, {
   3.629187263494291*^9, 3.629187284616728*^9}, 3.6291873266120014`*^9, 
   3.629187811262854*^9, 3.629187845489314*^9, 3.6291893763632035`*^9, {
   3.6292328386751413`*^9, 3.6292328506403627`*^9}, 3.6294129869649906`*^9, {
   3.629681940868216*^9, 3.629681967840663*^9}, {3.629683072302611*^9, 
   3.629683104204667*^9}, 3.6296834256744313`*^9, 3.62968375522501*^9, 
   3.6296908987102036`*^9, 3.630130105748337*^9, 3.6301868181132655`*^9, {
   3.630191355032058*^9, 3.6301913594624653`*^9}, 3.6301916306065416`*^9, {
   3.6301917699615865`*^9, 3.63019186320295*^9}, {3.630192661908753*^9, 
   3.6301926650911584`*^9}, {3.6301964589726305`*^9, 3.6301964616870356`*^9}, 
   3.630397911894512*^9, 3.631494715345451*^9, {3.631494897830179*^9, 
   3.6314948980173793`*^9}, 3.6325489741749687`*^9, 3.632549352439234*^9, 
   3.632549606008894*^9, {3.6325498031224484`*^9, 3.6325498272824984`*^9}, 
   3.6325498689969716`*^9, 3.632603972588211*^9, {3.6326052512664576`*^9, 
   3.63260525814607*^9}, 3.6326054984956923`*^9, 3.632789700000079*^9, 
   3.632789744647358*^9, {3.632789801166257*^9, 3.632789811633875*^9}, 
   3.6327900076794195`*^9, {3.6327981115517917`*^9, 3.632798133781831*^9}, 
   3.632798223201188*^9, {3.6328077370497065`*^9, 3.632807759903747*^9}, 
   3.6328139472210455`*^9, 3.632814030665592*^9, {3.6328142522895823`*^9, 
   3.6328142524611826`*^9}, {3.632862843129942*^9, 3.632862843800743*^9}, 
   3.63286308115516*^9, 3.6328903786025143`*^9, {3.634503967294235*^9, 
   3.6345039716310434`*^9}, {3.634505033567916*^9, 3.6345050472023396`*^9}, {
   3.6345052904809732`*^9, 3.6345052910893745`*^9}, {3.634505400581773*^9, 
   3.634505441906245*^9}, {3.634505494244337*^9, 3.6345055070207596`*^9}, {
   3.6345055797168875`*^9, 3.6345055799040875`*^9}, 3.6345562254439487`*^9, {
   3.6345563039276867`*^9, 3.6345563048948884`*^9}, 3.634556840334629*^9, {
   3.636074869723259*^9, 3.6360748731240654`*^9}, 3.6360754084218063`*^9, {
   3.6360755439392443`*^9, 3.636075558915271*^9}, {3.636075874067024*^9, 
   3.6360758917886553`*^9}, {3.6364953559316864`*^9, 3.636495366508505*^9}, {
   3.6364954773934994`*^9, 3.636495502852744*^9}, {3.636495534396*^9, 
   3.6364955371572046`*^9}, {3.6364955872176924`*^9, 3.63649567827066*^9}, 
   3.636495724504749*^9, {3.636495894244254*^9, 3.6364959362083282`*^9}, {
   3.6364963754739*^9, 3.636496380231908*^9}, {3.636497028007847*^9, 
   3.6364970357610607`*^9}, {3.6367624922783546`*^9, 
   3.6367624954763603`*^9}, {3.6367923982578783`*^9, 3.636792403624288*^9}, 
   3.725592414137775*^9, 3.72559253645759*^9, {3.725595004057525*^9, 
   3.725595014041543*^9}, 3.7255952212879066`*^9, 3.7255953656817603`*^9, 
   3.7255956160982013`*^9, {3.725595650901862*^9, 3.7255956517442636`*^9}, {
   3.725595707529962*^9, 3.7255957181379805`*^9}, {3.7255957501492367`*^9, 
   3.7255957539400434`*^9}, {3.7255961085130663`*^9, 3.72559611623508*^9}, 
   3.725596322436242*^9, 3.7255964148976045`*^9, {3.7257712777690277`*^9, 
   3.7257712801558323`*^9}, 3.725773155528726*^9, 3.725774260463067*^9, {
   3.7257742995099354`*^9, 3.7257743102739544`*^9}, 3.725774372830064*^9, 
   3.7257745020094986`*^9, 3.7258490354189854`*^9, 3.72585211170679*^9, 
   3.7258523136023445`*^9, 3.725852357064021*^9, 3.725852412709319*^9, 
   3.725852690077806*^9, {3.7258529112549944`*^9, 3.725852914297*^9}, 
   3.725866558776852*^9, 3.726913461475872*^9, {3.7269135067471514`*^9, 
   3.7269135067471514`*^9}, 3.7269135736712694`*^9, 3.7269142332092276`*^9, 
   3.726914379943085*^9, {3.72691444512*^9, 3.72691444551*^9}, 
   3.726914522230935*^9, {3.7269150197170105`*^9, 3.726915029623028*^9}, 
   3.7269154806118207`*^9, 3.7269429541638784`*^9, 3.726943055174056*^9, 
   3.7269527416378713`*^9, {3.7325816271502795`*^9, 3.73258171281003*^9}, {
   3.732658455138345*^9, 3.7326584615967565`*^9}, 3.7326589054523363`*^9, 
   3.7326593484475155`*^9, 3.732665438975348*^9, {3.7402181674777236`*^9, 
   3.740218192921368*^9}, 3.7402182516554713`*^9, 3.7402183778596935`*^9, {
   3.7402184897074966`*^9, 3.7402184899102974`*^9}, 3.740218703693073*^9, 
   3.740219316174549*^9, 3.740220725664626*^9, 3.7406235299785748`*^9, 
   3.7407786300441055`*^9, {3.7407787374658937`*^9, 3.7407787515059185`*^9}, 
   3.7407792597116137`*^9, {3.740779291410869*^9, 3.74077929150447*^9}, {
   3.7407794435579367`*^9, 3.7407794537603545`*^9}, {3.740779489359617*^9, 
   3.7407794895936174`*^9}, {3.740779670623536*^9, 3.7407796794843516`*^9}, 
   3.740780547224676*^9, 3.740780580078334*^9, {3.7407807829566903`*^9, 
   3.740780802675125*^9}, 3.7407824785895987`*^9, {3.740783120387927*^9, 
   3.7407831238823338`*^9}, 3.740784281084571*^9, 3.7407843527561016`*^9, 
   3.7407847831226892`*^9, 3.740792340872752*^9, 3.740795723424296*^9, 
   3.7407958523585224`*^9, 3.7407962560248313`*^9, 3.740796299814108*^9, 
   3.740796868840708*^9, 3.7407969075287757`*^9, {3.7411140798071146`*^9, 
   3.7411140827087193`*^9}, 3.7411141905985093`*^9, {3.7411142267125726`*^9, 
   3.7411142268685727`*^9}, {3.741114330047154*^9, 3.7411143512943916`*^9}, {
   3.741114411151696*^9, 3.741114418093709*^9}, 3.7411667320210295`*^9, 
   3.7411668087419643`*^9, 3.741202221929366*^9, 3.741892837970529*^9, 
   3.7446637237292566`*^9, 3.744664188516473*^9, 3.7446656128157234`*^9, 
   3.7446656519561925`*^9, 3.744742920198707*^9, 3.744748993426978*^9, 
   3.744875562242749*^9, 3.7452127485518837`*^9, {3.7452134494767146`*^9, 
   3.7452134887263837`*^9}, 3.7452135890501595`*^9, 3.7452136909027386`*^9, {
   3.745213776375289*^9, 3.745213824891374*^9}, {3.7452153796921053`*^9, 
   3.7452153895513225`*^9}, {3.745215679480633*^9, 3.7452156795430326`*^9}, {
   3.7452158443729224`*^9, 3.7452158470717273`*^9}, 3.745216263249258*^9, 
   3.745220775675985*^9, 3.74605200870955*^9, {3.746054459278658*^9, 
   3.746054461899462*^9}, {3.746054502833934*^9, 3.7460545099319468`*^9}, {
   3.7460545513812194`*^9, 3.746054580834071*^9}, 3.746054715181507*^9, {
   3.746055056728507*^9, 3.746055078334545*^9}, {3.7460696676769714`*^9, 
   3.746069675196185*^9}, {3.746069717519059*^9, 3.7460697568623285`*^9}, {
   3.746069787937583*^9, 3.74606981489443*^9}, 3.746073742165717*^9, 
   3.7460738199942536`*^9, 3.74607396574531*^9, {3.7460739981621666`*^9, 
   3.7460740214218073`*^9}, {3.7460741612292533`*^9, 3.7460741660964613`*^9}, 
   3.7460742930026846`*^9, 3.7469916783892336`*^9, {3.746995596376917*^9, 
   3.7469956449086018`*^9}, 3.746995874717006*^9, {3.746995951484741*^9, 
   3.7469959562115493`*^9}, {3.7469960042752333`*^9, 
   3.7469960100160437`*^9}, {3.7470008209349375`*^9, 3.747000823181341*^9}, {
   3.747000889419058*^9, 3.7470008910414605`*^9}, {3.7470280589399815`*^9, 
   3.7470280614983854`*^9}, {3.748111197232164*^9, 3.7481112317394247`*^9}, 
   3.74811147967066*^9, 3.7481115205271316`*^9, 3.748111692642234*^9, 
   3.7481117874748*^9, 3.748112631498683*^9, 3.748112775284136*^9, 
   3.7481129517516456`*^9, {3.748113151322796*^9, 3.7481131579684076`*^9}, 
   3.7481148652730074`*^9, 3.748152386065356*^9, 3.7481567738382626`*^9, 
   3.749668436049493*^9, 3.75071693891677*^9, 3.7507175127325783`*^9, 
   3.7507180095666513`*^9, 3.7507180789087734`*^9, 3.7507182048633947`*^9, 
   3.7507183299756145`*^9, {3.750719880875539*^9, 3.750719881031539*^9}, 
   3.750720705694188*^9, 3.7507440057557216`*^9, {3.750744086719864*^9, 
   3.750744089496669*^9}, 3.7509082696490107`*^9, 3.7509083249043074`*^9, 
   3.750911286246544*^9, 3.7509118911532063`*^9, 3.7509121115503936`*^9, {
   3.750923632836231*^9, 3.750923632961032*^9}, 3.750925073460763*^9, 
   3.750927718913814*^9, 3.7513499450769176`*^9, 3.7513500249334583`*^9, 
   3.751350205394575*^9, {3.751357124693128*^9, 3.751357125535529*^9}, 
   3.7513572227785015`*^9, {3.7513577543338346`*^9, 3.7513577545366354`*^9}, {
   3.7514075994397964`*^9, 3.7514076315758533`*^9}, 3.755049981992358*^9, 
   3.7550500823161345`*^9, 3.7550501621414747`*^9, {3.755050424627536*^9, 
   3.75505042743554*^9}, 3.7550509452316504`*^9, {3.7550519417295938`*^9, 
   3.755051975534853*^9}, 3.755137950815219*^9, {3.755138029314557*^9, 
   3.755138038986574*^9}, 3.755138086785058*^9, {3.755138188762437*^9, 
   3.7551382198688917`*^9}, 3.755138327743081*^9, {3.7551385822731285`*^9, 
   3.7551385983567567`*^9}, {3.7551386797264996`*^9, 3.755138682924505*^9}, {
   3.755138886446863*^9, 3.7551388934044757`*^9}, 3.75514146393878*^9, 
   3.7551414955444355`*^9, 3.755142322019229*^9, 3.755143438106188*^9, 
   3.755147618487777*^9, 3.7552236306785617`*^9, 3.755223735116352*^9, {
   3.755225733931464*^9, 3.7552257365054693`*^9}, {3.755227512081214*^9, 
   3.755227512237214*^9}, 3.7552279693180175`*^9, 3.7642903496367607`*^9, 
   3.7642905384454937`*^9, {3.764290573888756*^9, 3.7642906052136106`*^9}, 
   3.764290664977316*^9, {3.7642906962553706`*^9, 3.7642907377670436`*^9}, 
   3.7642907697626996`*^9, {3.7642908862013044`*^9, 3.7642908919733143`*^9}, {
   3.764290988459484*^9, 3.7642909895202856`*^9}, 3.7642916178573933`*^9, 
   3.7642946900651903`*^9, 3.764304233178358*^9, 3.764315634831588*^9, 
   3.7643178571376925`*^9, 3.7643199679870043`*^9, 3.7646643825688667`*^9, 
   3.7646644254533424`*^9, {3.7646670587823772`*^9, 3.7646670614031816`*^9}, {
   3.7646689741957426`*^9, 3.7646689743361425`*^9}, 3.7648879733065042`*^9, 
   3.7648880095453677`*^9, 3.764888905544944*^9, {3.7648904306286244`*^9, 
   3.764890430784625*^9}, 3.764890639856192*^9, 3.7648920316777287`*^9, 
   3.7648920799130135`*^9, {3.7649026496400437`*^9, 3.764902649811644*^9}, 
   3.765060795861064*^9, 3.765170874688287*^9, 3.7651709275255795`*^9, 
   3.7651715934707565`*^9, 3.765171678553306*^9, 3.7651720873988247`*^9, 
   3.7652588609279366`*^9, 3.7652589119400263`*^9, {3.7652678534549417`*^9, 
   3.765267853720142*^9}, 3.766219677048067*^9, 3.766219733644967*^9, 
   3.7662202150930123`*^9, 3.7662231492289677`*^9, 3.7662232546071525`*^9, 
   3.7664261773697233`*^9, {3.7664771999234896`*^9, 3.766477221467128*^9}, {
   3.7664774867923937`*^9, 3.7664775002552176`*^9}, {3.7688458990388994`*^9, 
   3.7688459132349243`*^9}, 3.7688464502450686`*^9, 3.7688469138338833`*^9, 
   3.7919252574896*^9, 3.7919253465779333`*^9, {3.791925415764722*^9, 
   3.7919254377907343`*^9}, {3.791925604735676*^9, 3.791925624980929*^9}, 
   3.791925707745304*^9, 3.791925763091635*^9, {3.791925911291008*^9, 
   3.7919259140403547`*^9}, {3.7919260222877755`*^9, 3.7919260262243795`*^9}, 
   3.7919263244810195`*^9, 3.7919272129150743`*^9, 3.7919273025813866`*^9, 
   3.79194113621521*^9, 3.791941232926713*^9, {3.791941514157159*^9, 
   3.7919415143290224`*^9}, 3.791943103216889*^9, 3.791945596183156*^9, 
   3.7919456441249638`*^9, 3.791946082173215*^9, 3.7919462651924844`*^9, 
   3.7921427775483007`*^9, 3.7921428897561445`*^9, {3.7921430152576857`*^9, 
   3.7921430359090414`*^9}, 3.7921430673703427`*^9, {3.792143141259096*^9, 
   3.7921431417121143`*^9}, 3.792143242125839*^9, 3.792143486850278*^9, {
   3.7921450052007465`*^9, 3.792145013042673*^9}, {3.7921451058956823`*^9, 
   3.7921451214857616`*^9}, 3.7921455314668036`*^9, {3.792206627246333*^9, 
   3.792206627246333*^9}, 3.792206754231901*^9, 3.79220685052157*^9, 
   3.7922078842917633`*^9, {3.7922705977593207`*^9, 3.7922705977593207`*^9}, {
   3.7922709118099704`*^9, 3.792270911903698*^9}, 3.792271385291582*^9, 
   3.792272246914014*^9, 3.79253865659698*^9, 3.7925389383292637`*^9, {
   3.79253897772618*^9, 3.7925390027310505`*^9}, 3.792539084603735*^9, 
   3.792539165209653*^9, {3.7925532584724584`*^9, 3.792553265876953*^9}, {
   3.7925536738897276`*^9, 3.7925536950096927`*^9}, 3.792553901929451*^9, 
   3.7925547774031987`*^9, 3.7926564191426325`*^9, 3.802546784503578*^9, 
   3.8025468351166477`*^9, {3.802547157478155*^9, 3.8025471596963935`*^9}, 
   3.8025530393291664`*^9, {3.802553145023003*^9, 3.8025531542395735`*^9}, {
   3.8025532156626034`*^9, 3.802553248326777*^9}, {3.8025534886879206`*^9, 
   3.802553504246724*^9}, {3.8025797911758394`*^9, 3.8025798028293123`*^9}, {
   3.8025800334054585`*^9, 3.802580033577258*^9}, 3.802582705776685*^9, 
   3.807854574938098*^9, 3.8078546986654563`*^9, {3.8078547333297863`*^9, 
   3.8078547854564734`*^9}, 3.80785486835991*^9, 3.807855055961532*^9, 
   3.816906071203289*^9, 3.8169062277454643`*^9, {3.816906300915784*^9, 
   3.8169063034933043`*^9}, 3.8169064130613346`*^9, 3.816906495104565*^9, 
   3.816906610405632*^9, 3.816906749379136*^9, 3.816907241217867*^9, 
   3.8169118516709604`*^9, {3.8208065480383034`*^9, 3.8208065503971148`*^9}, {
   3.8208066149286785`*^9, 3.820806624051549*^9}, {3.8208067216221795`*^9, 
   3.8208067220908184`*^9}, 3.8208068322209473`*^9, 3.820807172858101*^9, {
   3.8278746045256357`*^9, 3.8278746309881845`*^9}, {3.8282860508815856`*^9, 
   3.8282860579267845`*^9}, {3.8282861859735947`*^9, 3.8282862018448706`*^9}, 
   3.828286468280572*^9, 3.828553587454216*^9, 3.8285574082753267`*^9, {
   3.8286362338967395`*^9, 3.828636255175177*^9}, 3.828637664454053*^9, 
   3.828718689983182*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571686237884`*^9, 3.848257192868057*^9}, {3.84825923472919*^9, 
   3.848259236681822*^9}, 3.848259612007312*^9, {3.8482597677280135`*^9, 
   3.848259771133461*^9}, {3.8482598468578053`*^9, 3.8482598497008877`*^9}, {
   3.848260094465921*^9, 3.8482601019797363`*^9}, {3.854761764009829*^9, 
   3.854761764009829*^9}, 3.854761812763962*^9, 3.8547619184957533`*^9, {
   3.85476213510832*^9, 3.8547621352801824`*^9}, {3.854762175741544*^9, 
   3.854762196820649*^9}, 3.854763397808587*^9, 3.854911091585896*^9, 
   3.883168549514434*^9, 3.8831685918481736`*^9, {3.8831693368284187`*^9, 
   3.8831693369690075`*^9}, 3.8831700820047045`*^9, {3.88326856715734*^9, 
   3.883268567688492*^9}, {3.956529075649271*^9, 3.956529075649271*^9}, 
   3.956529278561458*^9, 3.956529333579769*^9, 3.956529375257483*^9, {
   3.956529477764713*^9, 3.9565294832321777`*^9}, {3.95652970749885*^9, 
   3.9565297214487343`*^9}, {3.9565301959560966`*^9, 3.9565302258865724`*^9}, 
   3.956530334767271*^9, 3.9565304297655487`*^9, 3.956541561095746*^9, 
   3.9565603591403613`*^9, 3.956560485579527*^9, 3.9565605193840313`*^9, 
   3.9565608478858576`*^9, 3.956561139586401*^9, {3.956561198291339*^9, 
   3.9565612121006274`*^9}, {3.956561540646843*^9, 3.9565615472390504`*^9}, 
   3.95788785041077*^9, {3.957887890010872*^9, 3.9578879019299297`*^9}, {
   3.9578879707575006`*^9, 3.9578879764905615`*^9}, 3.957974038390552*^9, {
   3.9579740906907754`*^9, 3.957974095720843*^9}, 3.9579745491861987`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0320.png\>\"", ",", "frpConfHypergeomF4", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533955185636678*^9, 3.533955193530292*^9}, 
   3.5470089020736527`*^9, 3.5470089906974087`*^9, {3.5501987606920385`*^9, 
   3.5501987608792386`*^9}, 3.550198849300194*^9, {3.5504693214945307`*^9, 
   3.55046932160373*^9}, {3.5531142987603564`*^9, 3.55311430097556*^9}, 
   3.553114600798087*^9, 3.5531850697594075`*^9, 3.55318527036016*^9, 
   3.5531900910817485`*^9, 3.553190165072678*^9, 3.5531908750251255`*^9, {
   3.553190970122893*^9, 3.553190970310093*^9}, {3.5532137997388144`*^9, 
   3.5532138043876224`*^9}, {3.5532141363562055`*^9, 3.553214165434656*^9}, {
   3.556389606160061*^9, 3.5563896074548635`*^9}, 3.556389890454961*^9, {
   3.7325812332963877`*^9, 3.732581233717589*^9}, 3.7326535116184597`*^9, {
   3.7326591364731426`*^9, 3.732659136644743*^9}, 3.7326593484631157`*^9, 
   3.7402167509844255`*^9, 3.7402182539798756`*^9, 3.740219001927597*^9, 
   3.7407786321033087`*^9, {3.740780622260808*^9, 3.7407806224012084`*^9}, 
   3.740782321871723*^9, {3.7407957164042835`*^9, 3.740795721505492*^9}, 
   3.7411140854231243`*^9, {3.74111413420441*^9, 3.7411141344228106`*^9}, 
   3.741166727684222*^9, {3.7411668654792643`*^9, 3.741166865619664*^9}, 
   3.7414211246988482`*^9, 3.7446637267400618`*^9, 3.7446644002400446`*^9, 
   3.7446656128157234`*^9, {3.744665930744282*^9, 3.744665930884682*^9}, 
   3.7452127519526896`*^9, 3.7452127982691708`*^9, 3.7452152179426208`*^9, 
   3.7452153867901173`*^9, 3.7460520107999535`*^9, {3.7460520534036283`*^9, 
   3.74605205424603*^9}, 3.746055118879016*^9, 3.7469914856820946`*^9, {
   3.746991527770969*^9, 3.746991555866618*^9}, 3.7469916833032417`*^9, 
   3.7481112017873716`*^9, {3.7481113416104174`*^9, 3.7481113417820177`*^9}, 
   3.748112629455079*^9, 3.7481132179193125`*^9, {3.7507168447394047`*^9, 
   3.7507168472198095`*^9}, 3.7507169437995787`*^9, 3.7509079022215652`*^9, {
   3.75090794495004*^9, 3.75090794512164*^9}, 3.7509082696490107`*^9, 
   3.7513500249334583`*^9, 3.7513500920291758`*^9, {3.7513503492580276`*^9, 
   3.751350349445228*^9}, 3.7514002242042093`*^9, {3.755049692159449*^9, 
   3.7550496922998495`*^9}, {3.7550498033876443`*^9, 3.7550498039024453`*^9}, 
   3.755049981992358*^9, 3.762283566429557*^9, {3.762283611841237*^9, 
   3.7622836119660373`*^9}, 3.7622837156906195`*^9, 3.764280969439039*^9, 
   3.7642810018246965`*^9, {3.764281074411624*^9, 3.7642810945668592`*^9}, {
   3.764281227135892*^9, 3.7642812273854923`*^9}, 3.7642813042000275`*^9, 
   3.764291565768902*^9, 3.7646644254533424`*^9, {3.7646645461195545`*^9, 
   3.7646645463223543`*^9}, {3.7648874056839075`*^9, 3.7648874058399076`*^9}, 
   3.7648879733221045`*^9, {3.7648894222178516`*^9, 3.7648894224050517`*^9}, {
   3.7650602476465006`*^9, 3.765060247818101*^9}, 3.765060798138668*^9, 
   3.7650876836644077`*^9, {3.765170820041391*^9, 3.765170820322191*^9}, 
   3.765170874688287*^9, 3.7652589119400263`*^9, {3.765259071731107*^9, 
   3.7652590718091073`*^9}, {3.7662195948515224`*^9, 3.7662195957563243`*^9}, 
   3.766219677048067*^9, 3.766220217308216*^9, 3.7664771999234896`*^9, 
   3.7664773393097343`*^9, 3.766477486807994*^9, 3.766477573590946*^9, {
   3.7666119431449013`*^9, 3.7666119433165016`*^9}, {3.7673939377297125`*^9, 
   3.7673939378857126`*^9}, 3.7688458990388994`*^9, 3.768845992155463*^9, 
   3.7688461150368786`*^9, 3.7919252574896*^9, 3.791926052499424*^9, {
   3.791926095989151*^9, 3.791926096598382*^9}, 3.791941133887636*^9, 
   3.7919412657158723`*^9, {3.7919455983389053`*^9, 3.7919456033221006`*^9}, 
   3.7921427775483007`*^9, {3.792144252867916*^9, 3.7921442530085073`*^9}, 
   3.792145007731429*^9, 3.792145059016163*^9, 3.792206627246333*^9, {
   3.792208164803473*^9, 3.792208165553295*^9}, 3.7922705977593207`*^9, {
   3.7922707301029916`*^9, 3.7922707302904463`*^9}, 3.79253865659698*^9, 
   3.7925540406154003`*^9, 3.8025468380534554`*^9, {3.8025469017103243`*^9, 
   3.8025469097240615`*^9}, {3.8025516449002275`*^9, 3.802551645056441*^9}, {
   3.8025797876922874`*^9, 3.802579794206377*^9}, 3.8078544401712985`*^9, {
   3.8078545001470075`*^9, 3.807854500934877*^9}, 3.8078545785694313`*^9, 
   3.8169060743744335`*^9, 3.816906826079885*^9, 3.8169068668827724`*^9, 
   3.820806437814374*^9, {3.8208064682759457`*^9, 3.8208064684790215`*^9}, 
   3.820806553490138*^9, {3.8278746045256357`*^9, 3.8278746310038056`*^9}, 
   3.827874859287332*^9, {3.827874913149688*^9, 3.827874914102568*^9}, 
   3.828286652268653*^9, 3.8482570386857076`*^9, 3.848257074645941*^9, {
   3.84825712863323*^9, 3.8482571287582006`*^9}, 3.8547617640254436`*^9, {
   3.854761842820959*^9, 3.8547618694084587`*^9}, {3.8831685918481736`*^9, 
   3.8831686183106723`*^9}, {3.8831686600976796`*^9, 3.8831686602538943`*^9}, 
   3.9565290756648955`*^9, {3.9565292025011487`*^9, 3.956529227448423*^9}, 
   3.9565603555786777`*^9, 3.956560451712392*^9, 3.956561137649354*^9, {
   3.956561724869236*^9, 3.9565617250566645`*^9}},
 Background->GrayLevel[0.900008]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SubscriptBox["\[InvisiblePrefixScriptBase]", "1"],
     FontSize->14], 
    SubscriptBox[
     StyleBox[
      SubscriptBox[
       StyleBox["F",
        FontSize->17], 
       StyleBox["1",
        FontSize->10,
        FontSlant->"Plain"]],
      FontSize->17], 
     StyleBox["\[InvisiblePrefixScriptBase]",
      FontSize->14,
      FontSlant->"Plain"]]}], TraditionalForm]]],
 "(",
 StyleBox[" ",
  FontSize->6],
 "\[Alpha]",
 StyleBox[" ",
  FontSize->10],
 StyleBox[";",
  FontSize->14],
 " \[Gamma]",
 StyleBox[" ",
  FontSize->10],
 StyleBox[";",
  FontSize->14],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{
     StyleBox[" ",
      FontSize->8], 
     StyleBox["z",
      FontSize->13]}]], TraditionalForm]],
  FontSize->18],
 StyleBox[" ",
  FontSize->6],
 ")"
}], "Text",
 CellChangeTimes->{{3.5824915000966196`*^9, 3.5824915000966196`*^9}, {
   3.5824916032440004`*^9, 3.5824916032440004`*^9}, {3.582491668311715*^9, 
   3.582491668311715*^9}, {3.629673722761372*^9, 3.629673730826586*^9}, {
   3.6296737731494603`*^9, 3.6296738016663103`*^9}, {3.6301295823206177`*^9, 
   3.6301295823206177`*^9}, 3.630129633941108*^9, {3.63254916820891*^9, 
   3.6325491980517626`*^9}, {3.6325492349866276`*^9, 3.63254924234984*^9}, {
   3.6325492743766966`*^9, 3.632549276888301*^9}, {3.6329619039262304`*^9, 
   3.6329619379654903`*^9}, 3.633741294652232*^9, {3.6711637934061413`*^9, 
   3.671163823248994*^9}, 3.67116386672627*^9, 3.6711676417216325`*^9, {
   3.6743625517084985`*^9, 3.67436256392332*^9}, {3.675042378833744*^9, 
   3.6750423876009593`*^9}, 3.68698772003868*^9, {3.6869877654035597`*^9, 
   3.6869877678839636`*^9}, 3.6869878042476273`*^9, {3.686988219301957*^9, 
   3.686988219301957*^9}, 3.6870375495890017`*^9, {3.7096615756187935`*^9, 
   3.709661585696411*^9}, {3.7096616850217857`*^9, 3.7096616893273935`*^9}, 
   3.709661732445869*^9, 3.7096625799505606`*^9, {3.7096627317856274`*^9, 
   3.7096627317856274`*^9}, {3.7119169372200427`*^9, 3.711916962024086*^9}, {
   3.711950144289839*^9, 3.711950211603957*^9}, {3.711950314766938*^9, 
   3.7119503348129735`*^9}, {3.7119504161827164`*^9, 
   3.7119504277423368`*^9}, {3.7119504790196266`*^9, 3.7119504828884335`*^9}, 
   3.7119506827327867`*^9, {3.7326455616996984`*^9, 3.7326456756578984`*^9}, 
   3.740210188539296*^9, {3.740210227274164*^9, 3.7402102476322002`*^9}, {
   3.7402103047283*^9, 3.7402103578931932`*^9}, 3.740210757529096*^9, {
   3.7406316101931705`*^9, 3.7406316142023773`*^9}, 3.7444217570466595`*^9, {
   3.7445974660647497`*^9, 3.7445974660647497`*^9}, {3.7452071638624706`*^9, 
   3.745207220911771*^9}, {3.746990587619664*^9, 3.746990588664866*^9}, {
   3.7469906319549417`*^9, 3.7469906514081764`*^9}, {3.7469908105752563`*^9, 
   3.7469908294668894`*^9}, {3.7469911331838226`*^9, 3.746991138690632*^9}, {
   3.747188447227745*^9, 3.747188451470953*^9}, {3.747188500673439*^9, 
   3.747188511936659*^9}, 3.747188542075912*^9, {3.7471886169404435`*^9, 
   3.7471886301380663`*^9}, {3.7471892525791597`*^9, 3.7471892591935716`*^9}, 
   3.7471894078930326`*^9, {3.747203206756748*^9, 3.7472032546176324`*^9}, {
   3.753829594010942*^9, 3.7538296690314736`*^9}, {3.753829699545127*^9, 
   3.753829820117739*^9}, {3.753848069614362*^9, 3.7538480955884075`*^9}, {
   3.7538481267104626`*^9, 3.7538481267104626`*^9}, {3.764276527376436*^9, 
   3.764276652395056*^9}, 3.764276695529132*^9, {3.7914357429007196`*^9, 
   3.79143577433081*^9}, {3.800066753206977*^9, 3.800066776295285*^9}, {
   3.800066806350668*^9, 3.8000668381088424`*^9}, {3.8000671695150876`*^9, 
   3.800067212716776*^9}, {3.8067010446739044`*^9, 3.8067010446739044`*^9}, {
   3.8200295012217207`*^9, 3.8200295012217207`*^9}, {3.827873199008128*^9, 
   3.827873199008128*^9}, {3.848193531667981*^9, 3.848193531667981*^9}, {
   3.8530955499054956`*^9, 3.8530955558728085`*^9}, {3.853095598698382*^9, 
   3.8530956234425735`*^9}, {3.85309566105877*^9, 3.85309566105877*^9}, 
   3.85309686945766*^9, {3.8695302525076494`*^9, 3.869530286954235*^9}, {
   3.869530899794984*^9, 3.869530987587058*^9}, 3.869532050097499*^9, {
   3.928648407985051*^9, 3.9286484449295144`*^9}, {3.928648499416654*^9, 
   3.9286485676974573`*^9}, {3.928648602673667*^9, 3.9286486514590263`*^9}, {
   3.9286486896062975`*^9, 3.9286487005880527`*^9}, 3.928648837372279*^9, {
   3.9568196194132195`*^9, 3.956819673931671*^9}},
 FontFamily->"Times New Roman",
 FontSize->16,
 Background->RGBColor[0.690196, 0.690196, 0.866667]],

Cell[BoxData[
 RowBox[{"ap3dConfHypergeomFE1", "=", "\[IndentingNewLine]", 
  RowBox[{"AbsArgPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"3", " ", "\[Pi]"}], ",", "4"}], "}"}]}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"-", "16"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0007", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0005", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.30"}], ",", 
       RowBox[{"-", "1.77"}], ",", "2.63"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
         RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
       "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.528619442909766*^9, 3.528619451910281*^9}, {
   3.5286214386949186`*^9, 3.5286214646354027`*^9}, {3.5286222532055063`*^9, 
   3.528622288166506*^9}, 3.52866506133381*^9, 3.5286651054974875`*^9, {
   3.5286651514707685`*^9, 3.528665155292775*^9}, {3.5287006732862062`*^9, 
   3.528700705625063*^9}, {3.5287008793313684`*^9, 3.5287008818741727`*^9}, {
   3.5287009125126266`*^9, 3.5287009144938297`*^9}, {3.5289198836377797`*^9, 
   3.5289199933371725`*^9}, {3.5289200401996546`*^9, 
   3.5289200576560855`*^9}, {3.5289201204305954`*^9, 
   3.5289201283242097`*^9}, {3.5289213102134857`*^9, 3.5289213711159925`*^9}, 
   3.5289214070272555`*^9, {3.52892258770053*^9, 3.528922633018609*^9}, {
   3.528922704669535*^9, 3.5289227124695487`*^9}, {3.5289237056920934`*^9, 
   3.528923718624516*^9}, 3.5289237912270436`*^9, {3.528923835453121*^9, 
   3.5289238359055223`*^9}, {3.52892390278284*^9, 3.5289239065580463`*^9}, 
   3.5289239438421116`*^9, {3.528923987787389*^9, 3.528924004978619*^9}, {
   3.5289240667547274`*^9, 3.528924087986365*^9}, {3.5289243401296077`*^9, 
   3.528924344294815*^9}, {3.5289245120575094`*^9, 3.5289245256919336`*^9}, {
   3.5289245779988256`*^9, 3.5289246058916745`*^9}, 3.5289246438465414`*^9, {
   3.5301781945730553`*^9, 3.530178289296421*^9}, {3.530178945963975*^9, 
   3.5301789486471796`*^9}, {3.5301820319841957`*^9, 3.530182109703532*^9}, {
   3.5339560194937434`*^9, 3.5339560600070143`*^9}, {3.5339561008634863`*^9, 
   3.53395611423271*^9}, {3.5339561603307905`*^9, 3.5339561646675987`*^9}, {
   3.5339561968816547`*^9, 3.533956209845278*^9}, {3.534022431253952*^9, 
   3.5340224314567523`*^9}, 3.534022572481*^9, {3.534022607705862*^9, 
   3.534022607924262*^9}, {3.5345620477651424`*^9, 3.5345620818512025`*^9}, {
   3.534562122941674*^9, 3.5345621667933517`*^9}, {3.534648397811719*^9, 
   3.534648401118925*^9}, {3.534709801160247*^9, 3.5347098283822947`*^9}, {
   3.5347098611891527`*^9, 3.5347098619223537`*^9}, {3.534709907926834*^9, 
   3.5347099086288357`*^9}, {3.534710222192987*^9, 3.5347102332066064`*^9}, 
   3.5347103216587615`*^9, {3.5347106722693777`*^9, 3.534710675982184*^9}, 
   3.5470089462373304`*^9, {3.5470091278996496`*^9, 3.5470091547472963`*^9}, {
   3.5470094371389923`*^9, 3.547009443207403*^9}, 3.547009595901272*^9, {
   3.547009818014462*^9, 3.5470098320856867`*^9}, {3.5470099040642133`*^9, 
   3.5470099184162383`*^9}, 3.5470100544952774`*^9, 3.547010367529028*^9, 
   3.550198810721326*^9, {3.550199038434926*^9, 3.550199045018138*^9}, {
   3.5501999115110607`*^9, 3.5501999141942654`*^9}, {3.55019997380197*^9, 
   3.55019997398917*^9}, 3.5502073133024054`*^9, 3.550207620982745*^9, {
   3.550207765158199*^9, 3.550207802863465*^9}, {3.55020859692346*^9, 
   3.550208598467862*^9}, {3.5502099531430416`*^9, 3.550209992720311*^9}, {
   3.550210137301365*^9, 3.550210139516569*^9}, {3.550210537442068*^9, 
   3.5502105388148704`*^9}, 3.550210684753127*^9, {3.553114489866292*^9, 
   3.5531145040935173`*^9}, 3.5531145564784093`*^9, 3.55311478447281*^9, {
   3.553114928071062*^9, 3.553114930255066*^9}, {3.5531151718526897`*^9, 
   3.5531152734400682`*^9}, {3.5531153988286963`*^9, 
   3.5531153999830985`*^9}, {3.5531841051629133`*^9, 3.5531841089225197`*^9}, 
   3.5531844703907547`*^9, {3.5531848141373587`*^9, 3.55318482037737*^9}, {
   3.564290330120206*^9, 3.564290330120206*^9}, {3.5642910712463074`*^9, 
   3.5642910895763397`*^9}, {3.5642912437514105`*^9, 3.564291261098641*^9}, {
   3.564291324902753*^9, 3.5642913279447584`*^9}, {3.564298881313227*^9, 
   3.564298910968879*^9}, 3.5645703399765744`*^9, {3.5645709011207676`*^9, 
   3.5645709125711875`*^9}, {3.5646321047687345`*^9, 
   3.5646321068747377`*^9}, {3.564706696754722*^9, 3.564706699547127*^9}, 
   3.5647067771728635`*^9, {3.564989627219633*^9, 3.564989637609251*^9}, 
   3.565030962442968*^9, {3.565152889292653*^9, 3.565152909557089*^9}, {
   3.565152945156351*^9, 3.565152963236783*^9}, 3.565153012439269*^9, 
   3.5651530922490096`*^9, {3.565162127699024*^9, 3.5651621308992076`*^9}, 
   3.565983845442522*^9, 3.56598387845218*^9, {3.5659904751889668`*^9, 
   3.5659904837065816`*^9}, 3.56599068772374*^9, 3.5659907302338142`*^9, {
   3.5659908215943756`*^9, 3.565990858936449*^9}, 3.5659913705393476`*^9, {
   3.566162100485265*^9, 3.566162102341668*^9}, {3.567196994409768*^9, 
   3.5671969959541707`*^9}, {3.567197054189073*^9, 3.567197061021885*^9}, {
   3.567197133858413*^9, 3.5671972115621495`*^9}, {3.5671973507731943`*^9, 
   3.5671973567168045`*^9}, {3.567197396247274*^9, 3.567197485604231*^9}, 
   3.5674580328183336`*^9, {3.567570200880618*^9, 3.5675702017074194`*^9}, {
   3.5675706469946012`*^9, 3.5675706511130085`*^9}, 3.5675897096419353`*^9, 
   3.5680246296369*^9, {3.568160274924254*^9, 3.568160309037122*^9}, {
   3.568160380558855*^9, 3.5681603947860794`*^9}, {3.568160466354613*^9, 
   3.5681604854178467`*^9}, 3.568160775578356*^9, {3.568160813751623*^9, 
   3.568160822394038*^9}, 3.570075555135485*^9, 3.570075606833976*^9, {
   3.570076573068473*^9, 3.5700766101497383`*^9}, {3.570086741011756*^9, 
   3.5700867466120763`*^9}, 3.570086991324073*^9, {3.570087119755419*^9, 
   3.570087155371456*^9}, {3.5700962095128574`*^9, 3.5700962258772864`*^9}, 
   3.5700962986358137`*^9, {3.570096349835104*^9, 3.570096368445937*^9}, 
   3.5700964717345185`*^9, 3.573604781666628*^9, 3.573604883878007*^9, 
   3.573604925826481*^9, {3.57360495952254*^9, 3.57360503919188*^9}, 
   3.573605070064334*^9, {3.573605328369588*^9, 3.573605331661194*^9}, 
   3.5736054416881866`*^9, {3.5736058843701644`*^9, 3.5736059731343203`*^9}, {
   3.5736060324456244`*^9, 3.5736060387012353`*^9}, 3.573606118386175*^9, 
   3.5736062033595247`*^9, 3.573606490725857*^9, {3.573692115976136*^9, 
   3.5736921224969473`*^9}, 3.574884949276402*^9, {3.574885006013702*^9, 
   3.574885007963705*^9}, {3.57577172896203*^9, 3.5757717849022293`*^9}, {
   3.575771839158333*^9, 3.5757719145096426`*^9}, {3.575772545302722*^9, 
   3.575772560950617*^9}, 3.5757894252461996`*^9, {3.575974174332202*^9, 
   3.5759741933330355`*^9}, {3.5767311834246573`*^9, 3.576731301158064*^9}, {
   3.576734520722247*^9, 3.5767345253398547`*^9}, {3.5767345693007317`*^9, 
   3.576734571297536*^9}, 3.5767349788482513`*^9, 3.5767427797108574`*^9, {
   3.5767839288211775`*^9, 3.5767839425180016`*^9}, 3.5767840176165333`*^9, {
   3.5767965812116947`*^9, 3.576796592521714*^9}, 3.577871510016669*^9, {
   3.57787163504882*^9, 3.577871661200316*^9}, {3.5778717168644996`*^9, 
   3.577871730870301*^9}, {3.577871778560028*^9, 3.577871806259613*^9}, 
   3.5778718509931717`*^9, {3.5778726345519886`*^9, 3.5778726367521143`*^9}, {
   3.5779963658724623`*^9, 3.577996367728865*^9}, 3.578002028108985*^9, 
   3.5921826867730446`*^9, 3.592182932910277*^9, {3.592182973563948*^9, 
   3.5921829890703754`*^9}, {3.5921894432385116`*^9, 3.59218944813692*^9}, 
   3.592189480928178*^9, 3.5921896208916235`*^9, {3.5921896765369215`*^9, 
   3.5921896875193405`*^9}, {3.592189778717101*^9, 3.592189837654004*^9}, 
   3.606352358951768*^9, {3.6063524969964104`*^9, 3.6063525015360184`*^9}, {
   3.6063526625511017`*^9, 3.6063527326732244`*^9}, {3.6063527650432816`*^9, 
   3.6063527755264997`*^9}, {3.606353335280284*^9, 3.6063533646707354`*^9}, 
   3.60635353794024*^9, 3.6063545635752487`*^9, {3.6063546892490697`*^9, 
   3.6063547050674973`*^9}, {3.6063552211473227`*^9, 3.606355223690127*^9}, {
   3.6063552577605867`*^9, 3.606355272190612*^9}, {3.6063553038430676`*^9, 
   3.606355338163128*^9}, {3.606355581851156*^9, 3.606355644547666*^9}, {
   3.60636212821593*^9, 3.6063621434727573`*^9}, {3.6063647301913004`*^9, 
   3.606364732328504*^9}, 3.606367653822036*^9, {3.606423653579423*^9, 
   3.606423662861439*^9}, 3.6064237042951117`*^9, 3.6064240186796646`*^9, 
   3.6064240824057765`*^9, 3.6064352530456715`*^9, 3.625306348124917*^9, {
   3.625306422349847*^9, 3.6253064464050894`*^9}, {3.625306510552402*^9, 
   3.625306553920478*^9}, {3.625306755270032*^9, 3.6253068394009795`*^9}, 
   3.625306876669445*^9, 3.625307106474249*^9, 3.6253080361026907`*^9, 
   3.6253565393719177`*^9, 3.6253833999639544`*^9, 3.6253834309924088`*^9, 
   3.6291871583501062`*^9, {3.6291872318262353`*^9, 3.629187239704249*^9}, {
   3.6291873056923647`*^9, 3.6291873143815804`*^9}, {3.6291875784324455`*^9, 
   3.6291876127525053`*^9}, {3.629189364101582*^9, 3.629189366394786*^9}, {
   3.629232868970395*^9, 3.629232869173195*^9}, 3.629412973595767*^9, {
   3.629681734167853*^9, 3.6296817892827497`*^9}, {3.6296820677432384`*^9, 
   3.6296821134157267`*^9}, {3.6296821492957897`*^9, 3.6296821592174067`*^9}, 
   3.6296822142855034`*^9, 3.6296823447797327`*^9, {3.6296823820481987`*^9, 
   3.6296823873678074`*^9}, 3.6296824244022727`*^9, {3.629682533259264*^9, 
   3.629682571479331*^9}, {3.6296864438997335`*^9, 3.6296864498121443`*^9}, 
   3.6301301056703367`*^9, 3.630186806038844*^9, {3.630187005195995*^9, 
   3.6301870543204813`*^9}, 3.630187116294997*^9, {3.6301872101759624`*^9, 
   3.630187240518016*^9}, {3.6301879818625174`*^9, 3.630188037336215*^9}, {
   3.6301880817139006`*^9, 3.6301881292739916`*^9}, {3.630192463897605*^9, 
   3.6301924663624096`*^9}, {3.6325489266416855`*^9, 3.6325489436145153`*^9}, 
   3.632549332330798*^9, {3.6325493823600864`*^9, 3.6325493932021055`*^9}, {
   3.632549475316257*^9, 3.632549494769491*^9}, 3.6325495787244463`*^9, {
   3.63254965087018*^9, 3.6325496533193846`*^9}, {3.632549689417848*^9, 
   3.632549695548659*^9}, {3.632549725609912*^9, 3.632549731350722*^9}, 
   3.632549777632004*^9, {3.6326038339351673`*^9, 3.6326038351987696`*^9}, 
   3.6326052431856437`*^9, 3.632605279237307*^9, {3.6327896696112256`*^9, 
   3.63278967761404*^9}, 3.632789733462138*^9, 3.632789829792307*^9, 
   3.632789870211978*^9, 3.632789986728583*^9, 3.632798118478204*^9, 
   3.632798253418441*^9, {3.632805774254259*^9, 3.6328057895110865`*^9}, {
   3.6328080477542534`*^9, 3.6328080865671215`*^9}, {3.632808253050614*^9, 
   3.6328082534094143`*^9}, {3.632808331378351*^9, 3.632808360269602*^9}, {
   3.632808538526723*^9, 3.6328085720043817`*^9}, {3.632808631050485*^9, 
   3.632808642282505*^9}, {3.632808677908575*^9, 3.6328087181990533`*^9}, {
   3.6328089591882763`*^9, 3.63280900082475*^9}, {3.6328090336628075`*^9, 
   3.632809129977377*^9}, 3.632809186913084*^9, {3.632809216974337*^9, 
   3.632809236926772*^9}, 3.6328094921744204`*^9, {3.6328628083886805`*^9, 
   3.6328628144414916`*^9}, 3.632862901630045*^9, 3.6345039446897955`*^9, 
   3.634504022565132*^9, {3.634504657689049*^9, 3.6345046727742753`*^9}, {
   3.634504709243346*^9, 3.6345047653410444`*^9}, {3.634504880625247*^9, 
   3.6345049408257523`*^9}, {3.6345049821346254`*^9, 3.63450498472423*^9}, {
   3.6345052382364817`*^9, 3.634505239952485*^9}, {3.6345553893336797`*^9, 
   3.6345554050117073`*^9}, 3.6345568508334475`*^9, {3.636074809678754*^9, 
   3.6360748135943604`*^9}, {3.6360753609197226`*^9, 3.636075371137741*^9}, {
   3.6360754445046697`*^9, 3.6360754448322706`*^9}, 3.6360754780759287`*^9, {
   3.6360755150323935`*^9, 3.636075526139613*^9}, 3.6364953410960603`*^9, 
   3.636495413464587*^9, 3.636495521806778*^9, 3.636495566391656*^9, 
   3.6364955986993127`*^9, 3.63649578354646*^9, {3.636496052943333*^9, 
   3.636496059417344*^9}, {3.636496089572198*^9, 3.6364960983862133`*^9}, 
   3.6364962814213343`*^9, {3.6364969368880863`*^9, 3.636496945000101*^9}, 
   3.7255922261262445`*^9, 3.7255924668034678`*^9, 3.7255925194379597`*^9, {
   3.725594490754224*^9, 3.7255945013310423`*^9}, 3.7255952592895737`*^9, 
   3.725595809710141*^9, 3.725595872032251*^9, 3.725596154470747*^9, 
   3.7255964263948245`*^9, 3.7255994902566366`*^9, 3.7256016031495495`*^9, 
   3.7256016803852854`*^9, {3.7257699711575327`*^9, 3.7257699995651827`*^9}, 
   3.7257711688340364`*^9, 3.7257741402492557`*^9, 3.7257744781258564`*^9, 
   3.7258490150765495`*^9, {3.725852074641125*^9, 3.725852075202726*^9}, 
   3.725852252840238*^9, 3.725852386626073*^9, {3.7258526579417496`*^9, 
   3.725852658565751*^9}, 3.7258527373146887`*^9, {3.7258528441436768`*^9, 
   3.7258528480904837`*^9}, 3.726913461460272*^9, {3.7269135066691513`*^9, 
   3.7269135066847515`*^9}, 3.7269135736244693`*^9, {3.7269141963775625`*^9, 
   3.726914207671983*^9}, 3.726914350100233*^9, {3.726914421298758*^9, 
   3.7269144217511587`*^9}, 3.7269145086589117`*^9, 3.7269146264547186`*^9, 
   3.7269147176680784`*^9, {3.726914927879649*^9, 3.7269149421848745`*^9}, {
   3.726942862934918*^9, 3.726942875820541*^9}, 3.7269430613360662`*^9, 
   3.7269527172550287`*^9, {3.732581313558529*^9, 3.732581414007105*^9}, {
   3.7326583984946456`*^9, 3.732658428493498*^9}, {3.732658557942526*^9, 
   3.732658586022575*^9}, {3.732659178499616*^9, 3.732659189263635*^9}, 
   3.732662539865631*^9, {3.7402178619119854`*^9, 3.740217868385997*^9}, {
   3.7402181435784817`*^9, 3.740218149693692*^9}, {3.740218205900591*^9, 
   3.7402182074137936`*^9}, {3.740218302823561*^9, 3.740218347018439*^9}, {
   3.740218658655794*^9, 3.7402186693574123`*^9}, {3.7402192940381107`*^9, 
   3.7402193007617226`*^9}, {3.740220269338224*^9, 3.7402202697282248`*^9}, {
   3.740220328462328*^9, 3.740220338337145*^9}, {3.74062349322491*^9, 
   3.7406234962357154`*^9}, {3.740778595583645*^9, 3.74077859848525*^9}, {
   3.740778651650143*^9, 3.7407786648009663`*^9}, {3.7407788761441393`*^9, 
   3.7407788989669795`*^9}, {3.740779013450781*^9, 3.740779023996399*^9}, {
   3.7407791542866287`*^9, 3.7407791747070646`*^9}, {3.740779219900344*^9, 
   3.740779220196744*^9}, {3.740779424588303*^9, 3.7407794273807077`*^9}, {
   3.7407794683775797`*^9, 3.7407794818404036`*^9}, {3.7407796849131613`*^9, 
   3.7407797216824255`*^9}, {3.7407798321070204`*^9, 3.7407798775031*^9}, {
   3.7407800627346253`*^9, 3.740780110221109*^9}, {3.740780271946593*^9, 
   3.7407802910098267`*^9}, 3.740780521968232*^9, {3.740780648765255*^9, 
   3.7407806521660604`*^9}, {3.740780740587016*^9, 3.7407807443622227`*^9}, {
   3.7407824497451477`*^9, 3.740782452974354*^9}, {3.740783174738423*^9, 
   3.740783181930035*^9}, 3.740784309105423*^9, 3.7407843782021475`*^9, 
   3.740784798230516*^9, 3.740792141493194*^9, {3.740795745950735*^9, 
   3.7407958089592457`*^9}, 3.7407962456820135`*^9, 3.740796278894471*^9, {
   3.7407966335298944`*^9, 3.740796667288354*^9}, {3.740796726833658*^9, 
   3.740796732012867*^9}, {3.7407968196070213`*^9, 3.740796823959429*^9}, {
   3.741114044270252*^9, 3.741114047499458*^9}, 3.741114172876878*^9, {
   3.741114214840952*^9, 3.7411142149657516`*^9}, {3.7411143056643114`*^9, 
   3.7411143086907167`*^9}, {3.7411143683764215`*^9, 
   3.7411143879700556`*^9}, {3.7411144249889207`*^9, 
   3.7411144431785526`*^9}, {3.7411667545006695`*^9, 3.741166765233488*^9}, 
   3.74189270181349*^9, 3.74466368597719*^9, 3.7446641759896507`*^9, 
   3.7446656127845235`*^9, 3.744665651924992*^9, 3.744742913131895*^9, {
   3.7447489853929644`*^9, 3.744748987545768*^9}, 3.744875554021535*^9, {
   3.7452126977581944`*^9, 3.7452126994273973`*^9}, {3.7452128151796007`*^9, 
   3.74521282638042*^9}, {3.7452129967795196`*^9, 3.745213042097599*^9}, {
   3.7452130797560654`*^9, 3.745213081565668*^9}, {3.7452131350581627`*^9, 
   3.74521318497825*^9}, {3.7452132378155427`*^9, 3.745213240966748*^9}, {
   3.7452136012649813`*^9, 3.745213631029834*^9}, {3.745213734582815*^9, 
   3.7452137373908205`*^9}, {3.7452153530628586`*^9, 3.7452153600672708`*^9}, 
   3.7452154080997553`*^9, {3.745215674051823*^9, 3.7452156741454234`*^9}, {
   3.7452158387569127`*^9, 3.745215838975313*^9}, {3.745216206574359*^9, 
   3.745216245761627*^9}, 3.745220787875206*^9, 3.746051986744711*^9, {
   3.7460521008589115`*^9, 3.746052131778166*^9}, {3.7460521666286273`*^9, 
   3.7460524545427327`*^9}, 3.746052540857684*^9, {3.746053417769227*^9, 
   3.7460534259280415`*^9}, 3.746054345117657*^9, 3.7460546304265585`*^9, {
   3.7460742014929237`*^9, 3.746074240758193*^9}, 3.746991621012333*^9, {
   3.746994997701064*^9, 3.746995027793517*^9}, {3.7469953201784315`*^9, 
   3.7469954400490417`*^9}, {3.7469954827307167`*^9, 3.74699550728516*^9}, 
   3.7469955396084166`*^9, {3.7470008008733025`*^9, 3.74700080527251*^9}, {
   3.7470008733666296`*^9, 3.747000875893834*^9}, {3.747000949837964*^9, 
   3.747000952287168*^9}, 3.7470264752655973`*^9, {3.747028003559884*^9, 
   3.7470280096126947`*^9}, {3.7481111476864767`*^9, 3.748111150276081*^9}, 
   3.748111262440278*^9, 3.7481114647570333`*^9, 3.7481114993578944`*^9, 
   3.7481117436231236`*^9, 3.7481117783019843`*^9, 3.7481118211240597`*^9, 
   3.7481119089054136`*^9, 3.748112016779603*^9, 3.7481126540251226`*^9, {
   3.748112759746508*^9, 3.7481127604173093`*^9}, {3.748112809635396*^9, 
   3.748112816156207*^9}, {3.748112846591861*^9, 3.7481128812083216`*^9}, 
   3.7481129454960346`*^9, 3.748113095849098*^9, 3.7481148409525647`*^9, 
   3.7481523665185213`*^9, 3.749668417688261*^9, 3.7507168750970583`*^9, {
   3.7507169896168594`*^9, 3.750716992861665*^9}, {3.750717108551468*^9, 
   3.7507172392640977`*^9}, {3.7507172898861866`*^9, 3.75071732030624*^9}, {
   3.750717367402723*^9, 3.7507173891803613`*^9}, {3.7507175430902314`*^9, 
   3.750717551592246*^9}, {3.750717698907706*^9, 3.7507177368313723`*^9}, {
   3.750717804535491*^9, 3.7507178507895727`*^9}, {3.750717899056057*^9, 
   3.750717922424898*^9}, {3.750718034791896*^9, 3.7507180483015194`*^9}, {
   3.7507198746355276`*^9, 3.7507198747915277`*^9}, 3.7507206603917084`*^9, 
   3.750743995100903*^9, {3.750744115267914*^9, 3.7507441173583174`*^9}, 
   3.751183154782548*^9, 3.7511832007870283`*^9, 3.7511889477875257`*^9, 
   3.7511898686887436`*^9, {3.751190067027492*^9, 3.751190067214692*^9}, {
   3.7511904339557366`*^9, 3.7511904342209373`*^9}, 3.751343678313509*^9, {
   3.751343737328412*^9, 3.7513437454248266`*^9}, {3.7513439903028574`*^9, 
   3.7513440021900787`*^9}, 3.7513440559165726`*^9, {3.751344356866702*^9, 
   3.751344358754305*^9}, {3.7513453951733255`*^9, 3.7513454022313385`*^9}, 
   3.751345479623074*^9, 3.751345663578597*^9, 3.7513458060536475`*^9, {
   3.7513462322931957`*^9, 3.751346244788818*^9}, 3.751347972101852*^9, {
   3.7513564574799557`*^9, 3.751356461379963*^9}, 3.7513572038244677`*^9, 
   3.7550499818675575`*^9, 3.755050081270932*^9, 3.755050162094674*^9, {
   3.7550503792938557`*^9, 3.755050383552663*^9}, {3.755050657769945*^9, 
   3.7550507162700477`*^9}, 3.7550507776249557`*^9, {3.7550508327710524`*^9, 
   3.7550509174012012`*^9}, {3.75506116943268*^9, 3.75506120939995*^9}, 
   3.755061263641245*^9, {3.755061304045316*^9, 3.755061332296966*^9}, {
   3.791837454079505*^9, 3.7918374672326627`*^9}, {3.7918375293898745`*^9, 
   3.791837639613963*^9}, {3.7918376716532726`*^9, 3.7918377406682825`*^9}, {
   3.7918378367550473`*^9, 3.7918378492208977`*^9}, {3.791837885353021*^9, 
   3.791837927093199*^9}, {3.7918379571642485`*^9, 3.791837983314344*^9}, {
   3.7918382715699883`*^9, 3.791838307577134*^9}, {3.791838449356269*^9, 
   3.7918384679143763`*^9}, {3.791838600615634*^9, 3.7918386391222763`*^9}, {
   3.7918387136916265`*^9, 3.791838717518922*^9}, {3.7918387964402494`*^9, 
   3.7918388962605457`*^9}, {3.7918390063752236`*^9, 3.791839009499524*^9}, {
   3.7918390718129854`*^9, 3.791839081279473*^9}, 3.791926694308837*^9, {
   3.7919269047590957`*^9, 3.7919269312528725`*^9}, {3.791941159803388*^9, 
   3.791941185000529*^9}, {3.7919414976767054`*^9, 3.7919415013477135`*^9}, {
   3.7919418976905293`*^9, 3.7919419070633483`*^9}, {3.79194194144582*^9, 
   3.7919419457417145`*^9}, {3.791944532323326*^9, 3.7919445402901945`*^9}, 
   3.791945575110017*^9, {3.7919456228331137`*^9, 3.7919456251919384`*^9}, {
   3.7919457477646008`*^9, 3.791945947970544*^9}, {3.7919459941783795`*^9, 
   3.7919459979274817`*^9}, 3.791946210705377*^9, 3.791947743925529*^9, {
   3.792142687080438*^9, 3.7921427322260327`*^9}, {3.7921428660273533`*^9, 
   3.792142869089161*^9}, {3.792142945399186*^9, 3.7921429898730664`*^9}, {
   3.7921430613873816`*^9, 3.792143077961583*^9}, {3.7921431184519978`*^9, 
   3.7921431238725896`*^9}, 3.792143155349477*^9, 3.792143211601818*^9, {
   3.7921432698380313`*^9, 3.7921432757897153`*^9}, 3.7921434567671947`*^9, 
   3.792144982440548*^9, 3.7921450272892933`*^9, {3.792145072528581*^9, 
   3.792145079042717*^9}, 3.79214511625261*^9, 3.792145176425829*^9, {
   3.792145498912012*^9, 3.792145499115088*^9}, 3.792145594592448*^9, {
   3.7921456423624225`*^9, 3.7921456449087653`*^9}, {3.792184449093946*^9, 
   3.792184475478321*^9}, {3.792184553584795*^9, 3.792184576954283*^9}, 
   3.79218461517962*^9, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, {
   3.792206718240422*^9, 3.792206731424799*^9}, 3.792206845007283*^9, {
   3.7922070074375753`*^9, 3.7922070321039267`*^9}, 3.7922073048830905`*^9, {
   3.792207471952895*^9, 3.7922074981029654`*^9}, 3.792207861765847*^9, {
   3.7922106379018235`*^9, 3.7922106451501083`*^9}, {3.792270597712449*^9, 
   3.792270597712449*^9}, {3.792270891033639*^9, 3.7922708912054386`*^9}, 
   3.7922709722175446`*^9, 3.792271039389139*^9, 3.792271363687356*^9, {
   3.792272235885374*^9, 3.792272236072836*^9}, {3.7922725073824296`*^9, 
   3.7922725105379333`*^9}, {3.7922725499817567`*^9, 3.792272575631919*^9}, {
   3.7923819877656794`*^9, 3.7923819927489023`*^9}, 3.7925386565345564`*^9, {
   3.7925388649840345`*^9, 3.7925389122384624`*^9}, {3.792538977710556*^9, 
   3.7925389836310034`*^9}, 3.792539073871907*^9, 3.792539144948824*^9, 
   3.7925391995140295`*^9, {3.7925392495646725`*^9, 3.7925392522827845`*^9}, {
   3.792553223558854*^9, 3.792553236758835*^9}, 3.7925532712350616`*^9, 
   3.792553308132576*^9, {3.7925533452331324`*^9, 3.7925534413978987`*^9}, {
   3.792553882028*^9, 3.7925538868705435`*^9}, 3.792554765327935*^9, 
   3.7926557610118475`*^9, {3.8025467409044847`*^9, 3.802546764242728*^9}, 
   3.802547143215903*^9, {3.8025527321047087`*^9, 3.8025527867480636`*^9}, 
   3.802552818615567*^9, {3.8025528666667347`*^9, 3.802552957988966*^9}, 
   3.802553005837062*^9, 3.802553077929443*^9, {3.8025798749373145`*^9, 
   3.8025798774367256`*^9}, 3.8025799386730447`*^9, {3.8025800226579857`*^9, 
   3.8025800228142033`*^9}, 3.802585141722986*^9, 3.8078545320706625`*^9, {
   3.8078546051822667`*^9, 3.8078546730877852`*^9}, {3.8078547090317235`*^9, 
   3.8078547719695177`*^9}, 3.8078548203562016`*^9, 3.8078549040505514`*^9, {
   3.807855037674405*^9, 3.807855037962635*^9}, 3.816906009920802*^9, {
   3.8169060910892124`*^9, 3.8169061174267793`*^9}, {3.8169061971268187`*^9, 
   3.81690620022064*^9}, {3.8169062907775416`*^9, 3.8169063139595995`*^9}, {
   3.816906347529848*^9, 3.816906358371046*^9}, {3.8169064463660016`*^9, 
   3.8169064751248894`*^9}, {3.8169065717896967`*^9, 
   3.8169065738517113`*^9}, {3.8169066667673993`*^9, 3.816906727987401*^9}, 
   3.816906887955981*^9, {3.8169072179264603`*^9, 3.816907218176386*^9}, {
   3.8208064885993166`*^9, 3.820806493191882*^9}, {3.820806571985753*^9, 
   3.820806591262437*^9}, {3.820806643218884*^9, 3.820806644468581*^9}, {
   3.820806710234253*^9, 3.8208067108747253`*^9}, 3.820806825550688*^9, 
   3.820806870305712*^9, {3.8208070329068413`*^9, 3.8208070358748503`*^9}, 
   3.8208071291340075`*^9, {3.827874604478779*^9, 3.8278746309413214`*^9}, {
   3.828285976508387*^9, 3.8282860378689904`*^9}, {3.828286069189767*^9, 
   3.8282860750946317`*^9}, {3.8282862454440393`*^9, 3.828286274874611*^9}, 
   3.8282864569082403`*^9, 3.8282865303597565`*^9, {3.828288390273615*^9, 
   3.8282884014897327`*^9}, 3.8286362223683195`*^9, 3.8288490034020543`*^9, {
   3.8482570386076126`*^9, 3.8482570386232243`*^9}, {3.8482571403492136`*^9, 
   3.8482571748254557`*^9}, 3.8482572580401783`*^9, {3.8482592159992356`*^9, 
   3.8482592163897705`*^9}, 3.8482592584954834`*^9, 3.848259312904552*^9, {
   3.848259470368842*^9, 3.8482594998619113`*^9}, {3.8482597067661886`*^9, 
   3.848259717341818*^9}, {3.8482598723142166`*^9, 3.848259905868791*^9}, {
   3.8482604837349753`*^9, 3.8482604978097763`*^9}, {3.8547617638223734`*^9, 
   3.8547617638379946`*^9}, {3.8547617944089394`*^9, 3.8547617956430206`*^9}, 
   3.8547619113724337`*^9, {3.854762164384845*^9, 3.8547621866921015`*^9}, 
   3.8549110836125603`*^9, 3.8831684291204414`*^9, 3.8831685486083903`*^9, 
   3.883168591770075*^9, 3.8831689414842877`*^9, 3.8831690014857616`*^9, 
   3.8831706667954407`*^9, 3.8831708703093653`*^9, 3.956529049280467*^9, 
   3.9565290970348783`*^9, {3.9565292776866674`*^9, 3.9565293066954803`*^9}, {
   3.9565293420934258`*^9, 3.9565293429526005`*^9}, {3.9565293996423855`*^9, 
   3.9565294227776165`*^9}, 3.956529535867911*^9, 3.956529572578045*^9, {
   3.9565296812237678`*^9, 3.9565296814268775`*^9}, {3.956530125035204*^9, 
   3.9565301364388113`*^9}, 3.956530440138101*^9, 3.9565415554720664`*^9, 
   3.95682015942578*^9, 3.9568202218798723`*^9, {3.956820519694255*^9, 
   3.9568205318476887`*^9}, {3.9568207012767563`*^9, 3.9568207013860283`*^9}, 
   3.9568214979911413`*^9, 3.9568215735984077`*^9, {3.9568218855252786`*^9, 
   3.9568218984752913`*^9}, {3.9568220136982517`*^9, 3.956822019431281*^9}, 
   3.956822211761152*^9, 3.9568229500273046`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0330.png\>\"", ",", "ap3dConfHypergeomFE1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955147213811*^9, 3.533955206041514*^9, 3.5470088906700325`*^9, 
   3.5470089487489347`*^9, {3.5501987437036085`*^9, 3.5501987438440084`*^9}, 
   3.550198813591731*^9, {3.5504692939604816`*^9, 3.550469294069682*^9}, 
   3.553114267872302*^9, 3.5531143193679924`*^9, 3.5531145595360146`*^9, 
   3.5531850944854507`*^9, {3.5531852419837103`*^9, 3.5531852422489104`*^9}, 
   3.5531900792725277`*^9, 3.5531901503774524`*^9, 3.55319089444716*^9, 
   3.553190949265656*^9, {3.55321378571439*^9, 3.5532137858547897`*^9}, 
   3.553213822249654*^9, {3.5532141187749743`*^9, 3.553214146340223*^9}, {
   3.5563895716216006`*^9, 3.556389571762001*^9}, 3.5563898724213285`*^9, {
   3.7325812172595596`*^9, 3.7325812177743607`*^9}, 3.7326535308532934`*^9, {
   3.732659113743902*^9, 3.732659113899903*^9}, 3.732659206220865*^9, 
   3.740216750922025*^9, 3.7402182214850187`*^9, 3.740218987201172*^9, 
   3.740778600201253*^9, {3.740780597784365*^9, 3.740780598018366*^9}, 
   3.7407822969116793`*^9, {3.7407956919590406`*^9, 3.740795692161841*^9}, 
   3.7407957432831306`*^9, 3.741114049309061*^9, {3.7411141070915623`*^9, 
   3.7411141072631626`*^9}, 3.741166751692664*^9, 3.7411668366036134`*^9, {
   3.741421168425725*^9, 3.7414211686285257`*^9}, 3.7446636889255953`*^9, 
   3.744664374468799*^9, 3.7446656127845235`*^9, {3.7446659070166407`*^9, 
   3.7446659071882405`*^9}, 3.7452127094426146`*^9, {3.7452127690503197`*^9, 
   3.7452127718427243`*^9}, 3.745215203949396*^9, 3.745215406290152*^9, 
   3.746051989225116*^9, {3.746052022125573*^9, 3.7460520228275747`*^9}, 
   3.746055103278989*^9, 3.746991472593672*^9, 3.7469915089417357`*^9, 
   3.7469915389717884`*^9, 3.746991632774753*^9, 3.748111159012097*^9, {
   3.7481113177579756`*^9, 3.748111317945176*^9}, 3.7481126514667177`*^9, {
   3.748113195470874*^9, 3.748113195689274*^9}, {3.7507167568800507`*^9, 
   3.7507167594852552`*^9}, 3.7507168842542744`*^9, {3.750907902190365*^9, 
   3.750907924545204*^9}, 3.7509082695866103`*^9, 3.7513500248866577`*^9, 
   3.7513500919979753`*^9, {3.7513503196023755`*^9, 3.7513503197739754`*^9}, {
   3.7550497169166927`*^9, 3.7550497426723375`*^9}, 3.7550499818831577`*^9, {
   3.791837399326764*^9, 3.791837403919399*^9}, 3.7918374397704163`*^9, 
   3.7919411562417016`*^9, 3.7919412497352705`*^9, 3.7919455775000772`*^9, 
   3.79194561547548*^9, 3.7921427775170593`*^9, {3.7921442289360805`*^9, 
   3.7921442290922937`*^9}, 3.792144984877466*^9, {3.79214503848981*^9, 
   3.7921450386459846`*^9}, 3.7922066272150636`*^9, {3.7922081247973256`*^9, 
   3.792208125375308*^9}, 3.792270597728077*^9, {3.792270704359085*^9, 
   3.792270704452841*^9}, 3.792538656550113*^9, {3.7925539995157557`*^9, 
   3.7925540001562295`*^9}, 3.8025468009840703`*^9, {3.802546874435505*^9, 
   3.8025468749822507`*^9}, 3.8025469230959077`*^9, 3.8025516256547904`*^9, {
   3.8025798621278696`*^9, 3.802579872625392*^9}, {3.807854454103038*^9, 
   3.807854466154855*^9}, 3.807854538815669*^9, 3.8169060154038906`*^9, {
   3.81690681059914*^9, 3.8169068368429813`*^9}, {3.8208063901537895`*^9, 
   3.820806402244675*^9}, 3.820806503673809*^9, {3.827874604494393*^9, 
   3.8278746309413214`*^9}, {3.8278748592560916`*^9, 3.8278748863590775`*^9}, 
   3.82828663244518*^9, 3.8482570386232243`*^9, {3.8482570745991116`*^9, 
   3.848257085752733*^9}, 3.8547617638536158`*^9, {3.854761829152297*^9, 
   3.854761851225196*^9}, {3.883168591785688*^9, 3.883168637915431*^9}, 
   3.9565290755867867`*^9, {3.9565292024699354`*^9, 3.9565292106242757`*^9}, 
   3.9568202218954945`*^9, 3.956820306781824*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"adpConfHypergeomFE1", "=", "\[IndentingNewLine]", 
  RowBox[{"ArgDensityPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "10"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "16"}], ",", "90"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
           RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", "None"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "210"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.732482892728856*^9, 3.7324829563457675`*^9}, {
   3.7324830851923943`*^9, 3.7324830882811995`*^9}, {3.732483262424306*^9, 
   3.732483272377123*^9}, 3.7326584415195208`*^9, {3.7326584750439796`*^9, 
   3.7326584764479823`*^9}, 3.732658701981179*^9, {3.732658872349078*^9, 
   3.732658872567479*^9}, 3.7326592186228867`*^9, 3.7326593083866453`*^9, 
   3.7326626660310535`*^9, {3.740218157446906*^9, 3.740218181533348*^9}, 
   3.7402182257126255`*^9, 3.7402183634452677`*^9, {3.740218493186303*^9, 
   3.7402184934047036`*^9}, 3.740218637580157*^9, {3.7402186807610326`*^9, 
   3.7402186901834493`*^9}, 3.740219272556873*^9, 3.7406235115861425`*^9, {
   3.740778603524059*^9, 3.740778607080865*^9}, {3.740778656564152*^9, 
   3.740778658529755*^9}, {3.740778688559808*^9, 3.7407786898078103`*^9}, {
   3.7407792259843545`*^9, 3.7407792441895866`*^9}, {3.7407793822810287`*^9, 
   3.740779417427891*^9}, {3.7407794646959734`*^9, 3.7407794857872105`*^9}, 
   3.740780774189475*^9, 3.7407824622407703`*^9, {3.740783008707331*^9, 
   3.7407830693134375`*^9}, 3.7407921769832563`*^9, 3.740795739929125*^9, 
   3.740795830549684*^9, {3.741114053755069*^9, 3.741114056173073*^9}, 
   3.741114177042085*^9, {3.741114217851757*^9, 3.7411142179765573`*^9}, 
   3.741114298004698*^9, 3.7411143910588613`*^9, {3.7411144222121162`*^9, 
   3.741114422383716*^9}, 3.7411667475274568`*^9, 3.741166782284318*^9, 
   3.741202200838129*^9, 3.7418928330565205`*^9, 3.744663694463605*^9, 
   3.7446641788132553`*^9, 3.7446656127845235`*^9, 3.7446656519405923`*^9, 
   3.744742916766701*^9, 3.7447489900885725`*^9, 3.745212714450224*^9, {
   3.7452134334710865`*^9, 3.745213472377555*^9}, {3.74521352657205*^9, 
   3.7452135499564915`*^9}, {3.745213645116658*^9, 3.74521367446031*^9}, 
   3.7452137501360426`*^9, 3.745215372484893*^9, 3.745215403544547*^9, {
   3.745215676563428*^9, 3.745215676657028*^9}, {3.745215841159317*^9, 
   3.7452158501293325`*^9}, 3.745220796377221*^9, 3.746051992891122*^9, {
   3.7460525179568443`*^9, 3.746052527363661*^9}, {3.7460525613717203`*^9, 
   3.7460526080470023`*^9}, {3.746052647827072*^9, 3.746052665392703*^9}, 
   3.7460527306476173`*^9, {3.7460534548348923`*^9, 3.746053478047733*^9}, {
   3.7460536390400157`*^9, 3.7460536607708535`*^9}, {3.7460537995066986`*^9, 
   3.7460538460103807`*^9}, 3.746054532895187*^9, 3.7460546210509415`*^9, {
   3.746055005030016*^9, 3.7460550460736885`*^9}, 3.7460615185886574`*^9, {
   3.746069839136873*^9, 3.7460698629425144`*^9}, {3.746073417607147*^9, 
   3.7460734321307726`*^9}, 3.7460741921641073`*^9, 3.7469916409491673`*^9, {
   3.7469955617292557`*^9, 3.746995578218485*^9}, 3.7469956382941904`*^9, {
   3.7469959147934766`*^9, 3.746995920768287*^9}, {3.7469959729191785`*^9, 
   3.746995986631603*^9}, 3.746998736928876*^9, 3.746999808962759*^9, 
   3.747000762809235*^9, {3.7470280162427063`*^9, 3.7470280188011107`*^9}, 
   3.7481111741597233`*^9, 3.74811125768227*^9, {3.7481113758212776`*^9, 
   3.748111454039815*^9}, 3.7481116828922167`*^9, 3.74811178123479*^9, 
   3.7481120097751913`*^9, 3.7481126483779125`*^9, 3.7481127678585224`*^9, 
   3.7481129482884398`*^9, 3.748113174738437*^9, {3.748114852964586*^9, 
   3.7481148546805887`*^9}, 3.7481523715885305`*^9, 3.748156676743692*^9, 
   3.7496684226178694`*^9, 3.7507168950182934`*^9, 3.7507174232196207`*^9, 
   3.7507179880698137`*^9, 3.7507180637455463`*^9, {3.750718172664938*^9, 
   3.7507181919309716`*^9}, {3.750718281381529*^9, 3.7507183044383693`*^9}, {
   3.7507198773499327`*^9, 3.7507198774903326`*^9}, 3.750720697925374*^9, 
   3.7507439988761096`*^9, {3.750744109105903*^9, 3.7507441115707073`*^9}, 
   3.75090826960221*^9, 3.750908324873107*^9, 3.750911281940936*^9, 
   3.7509118911532063`*^9, 3.7509120959347663`*^9, {3.750923612368995*^9, 
   3.750923612524996*^9}, {3.7509248608167896`*^9, 3.750924875777216*^9}, {
   3.7509256243805313`*^9, 3.750925624567732*^9}, 3.7513499450613174`*^9, 
   3.751350024902258*^9, 3.751350205378975*^9, {3.7513571187651176`*^9, 
   3.751357119545119*^9}, 3.751357214526087*^9, {3.7513577496226263`*^9, 
   3.7513577498410273`*^9}, {3.751405366281531*^9, 3.751405378480752*^9}, {
   3.7514055458066463`*^9, 3.751405557849867*^9}, {3.751405638626809*^9, 
   3.7514056388764095`*^9}, 3.755049981945558*^9, 3.755050081707733*^9, 
   3.7550501621258745`*^9, {3.755050400759494*^9, 3.7550504035050983`*^9}, 
   3.7550509310980253`*^9, {3.7550512422873716`*^9, 3.7550512668106146`*^9}, {
   3.755051312409495*^9, 3.755051312877496*^9}, {3.755051771595695*^9, 
   3.755051771751695*^9}, {3.7550518885491004`*^9, 3.7550519085639353`*^9}, 
   3.7551379658536453`*^9, {3.755138016132534*^9, 3.755138075287838*^9}, {
   3.7551381761264153`*^9, 3.755138212599279*^9}, {3.75513827588859*^9, 
   3.755138303656639*^9}, {3.7551383744339633`*^9, 3.7551383747147636`*^9}, {
   3.755138574254714*^9, 3.75513859464395*^9}, 3.755138673611289*^9, {
   3.755139946626726*^9, 3.7551399654559593`*^9}, {3.7551413576185923`*^9, 
   3.755141379583431*^9}, 3.7551422855775647`*^9, {3.7551424248350105`*^9, 
   3.7551424403258376`*^9}, 3.7551475815781126`*^9, 3.7552236306473618`*^9, 
   3.7552237351007524`*^9, 3.7552257200630403`*^9, {3.755227559021696*^9, 
   3.755227559177696*^9}, {3.755227954092391*^9, 3.7552279570407963`*^9}, 
   3.7642903613991814`*^9, {3.7642905329386835`*^9, 3.7642905870551786`*^9}, 
   3.7642906182396336`*^9, {3.764290672449729*^9, 3.7642906894693584`*^9}, 
   3.764290721075014*^9, {3.76429075314867*^9, 3.764290753289071*^9}, {
   3.7642908794620924`*^9, 3.7642908959981213`*^9}, 3.764291593614951*^9, 
   3.76429466703955*^9, 3.7643042218683386`*^9, 3.764315617343957*^9, 
   3.76431783317605*^9, 3.7643199388461533`*^9, 3.7643853579378877`*^9, 
   3.764664382553267*^9, 3.7646644254065423`*^9, {3.7646670199227085`*^9, 
   3.7646670350235357`*^9}, {3.7646689626829224`*^9, 3.7646689628545227`*^9}, 
   3.764887973228504*^9, 3.764888008734166*^9, 3.7648888932053223`*^9, {
   3.7648903774637313`*^9, 3.764890377635331*^9}, 3.7648904488962564`*^9, 
   3.764890628343372*^9, {3.7648920077004867`*^9, 3.764892008121687*^9}, 
   3.764892076278207*^9, {3.7649026437276335`*^9, 3.7649026438212337`*^9}, 
   3.76506077650143*^9, 3.765170874625887*^9, 3.7651709275099792`*^9, 
   3.7651715756087255`*^9, 3.765171666619285*^9, 3.7651717371314087`*^9, 
   3.765171875909253*^9, 3.7652588601167355`*^9, 3.7652589118932266`*^9, {
   3.765267833767707*^9, 3.7652678340173073`*^9}, 3.766219677016867*^9, 
   3.766219733629367*^9, 3.7662201958113785`*^9, {3.7662231334417396`*^9, 
   3.7662231361717443`*^9}, 3.7662232485855417`*^9, {3.766426144952866*^9, 
   3.766426157042887*^9}, {3.76647719987669*^9, 3.7664772214515276`*^9}, {
   3.7664774867767935`*^9, 3.7664775002396173`*^9}, {3.7688458990076995`*^9, 
   3.7688459132037244`*^9}, 3.7688464394654493`*^9, 3.7688469041774664`*^9, 
   3.791925257427122*^9, 3.791925346562312*^9, {3.791925415077385*^9, 
   3.791925432292034*^9}, {3.79192558767724*^9, 3.7919255902703776`*^9}, {
   3.7919257453302054`*^9, 3.791925757202401*^9}, {3.791925937519228*^9, 
   3.7919259408152847`*^9}, {3.7919259926311307`*^9, 3.791925997395666*^9}, 
   3.791926263855747*^9, {3.7919264890844517`*^9, 3.791926490037352*^9}, 
   3.791927284210745*^9, 3.7919411532580585`*^9, 3.791941223803928*^9, {
   3.7919415060341063`*^9, 3.7919415061903205`*^9}, 3.7919455800307994`*^9, 
   3.7919456362986813`*^9, {3.791945689832918*^9, 3.7919457217551537`*^9}, 
   3.7919460775336857`*^9, 3.7919462165008616`*^9, {3.7919462528203726`*^9, 
   3.7919462530703335`*^9}, 3.7921427775170593`*^9, 3.7921428783057747`*^9, {
   3.792143003807266*^9, 3.7921430251928267`*^9}, 3.792143064074258*^9, {
   3.7921431277154303`*^9, 3.792143128543357*^9}, {3.7921434609849415`*^9, 
   3.79214346590565*^9}, 3.7921449885797224`*^9, 3.792145025274151*^9, {
   3.7921450954762783`*^9, 3.7921451181897235`*^9}, {3.7921455056604123`*^9, 
   3.7921455095657372`*^9}, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, 
   3.7922067460150957`*^9, 3.7922068475379333`*^9, {3.792207866280402*^9, 
   3.792207873684909*^9}, {3.792270597728077*^9, 3.792270597728077*^9}, {
   3.792270895657544*^9, 3.792270895782504*^9}, {3.792271368045697*^9, 
   3.7922713738255787`*^9}, {3.7922722199672675`*^9, 3.792272227824782*^9}, 
   3.792538656565729*^9, 3.792538924313737*^9, {3.792538977710556*^9, 
   3.7925389876925745`*^9}, 3.792539078730129*^9, 3.7925391498539133`*^9, {
   3.7925532490372567`*^9, 3.792553269157399*^9}, {3.7925536620956464`*^9, 
   3.792553667672454*^9}, 3.7925537022735977`*^9, {3.792553890557179*^9, 
   3.7925538937751665`*^9}, {3.7925546404577494`*^9, 3.7925546465187893`*^9}, 
   3.7925547575953875`*^9, 3.7926551481604743`*^9, 3.802546774584007*^9, 
   3.802546806014125*^9, {3.8025471515108232`*^9, 3.802547153432208*^9}, {
   3.8025530095393133`*^9, 3.802553026457199*^9}, {3.8025532045714674`*^9, 
   3.802553229409363*^9}, 3.802553261038468*^9, 3.802553454664689*^9, {
   3.8025798431792006`*^9, 3.8025798457723475`*^9}, {3.8025800272037663`*^9, 
   3.802580027344387*^9}, {3.802582660552966*^9, 3.8025826638022027`*^9}, 
   3.8078545445533037`*^9, 3.8078546876419163`*^9, {3.807854721465523*^9, 
   3.8078547489939494`*^9}, 3.8078547791373887`*^9, {3.807855042242198*^9, 
   3.8078550464639173`*^9}, 3.816906024932904*^9, 3.816906211796054*^9, {
   3.8169062938236933`*^9, 3.816906310679119*^9}, 3.8169063942376285`*^9, 
   3.8169064881374598`*^9, 3.816906605547397*^9, {3.81690722223795*^9, 
   3.81690722739299*^9}, {3.816911790459921*^9, 3.816911790662994*^9}, {
   3.8208065113126163`*^9, 3.820806513952616*^9}, 3.8208066006040044`*^9, {
   3.8208066387668133`*^9, 3.820806640141487*^9}, {3.8208067180917654`*^9, 
   3.82080671859165*^9}, {3.8208068079142385`*^9, 3.820806816990216*^9}, 
   3.820807138147498*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.828286123457013*^9, {3.8282861747106113`*^9, 3.8282861989236813`*^9}, {
   3.828286440365247*^9, 3.8282864529248*^9}, {3.828553556846962*^9, 
   3.828553562587772*^9}, {3.828557128894436*^9, 3.8285571389096537`*^9}, {
   3.8285573314607916`*^9, 3.8285573321159925`*^9}, 3.828557376529271*^9, {
   3.8286360368995934`*^9, 3.828636050206417*^9}, 3.8286362099974976`*^9, 
   3.8286376533312335`*^9, 3.828718698781597*^9, {3.848257038638844*^9, 
   3.848257038638844*^9}, {3.8482571592822495`*^9, 3.8482571791525536`*^9}, 
   3.8482592259343624`*^9, {3.848259521700473*^9, 3.8482595244186172`*^9}, 
   3.848259575968937*^9, {3.848259744967764*^9, 3.848259748545044*^9}, {
   3.848259837688095*^9, 3.848259841812119*^9}, 3.848260108181464*^9, {
   3.8547617638692365`*^9, 3.8547617638848314`*^9}, 3.854761804515937*^9, 
   3.854761915152796*^9, {3.854762106815795*^9, 3.854762106987621*^9}, {
   3.8547621715706553`*^9, 3.854762191347271*^9}, {3.854762692983657*^9, 
   3.8547626933116884`*^9}, 3.8549110693034267`*^9, 3.883168548842718*^9, 
   3.883168591801283*^9, {3.8831693422177663`*^9, 3.883169342373979*^9}, 
   3.883170089065553*^9, {3.9565290756024103`*^9, 3.9565290756024103`*^9}, 
   3.956529277905364*^9, {3.9565293329237075`*^9, 3.956529358527069*^9}, 
   3.956529465626936*^9, {3.95652968441055*^9, 3.956529687425434*^9}, 
   3.956530150357442*^9, 3.956530343390212*^9, 3.9565304268131027`*^9, 
   3.956541558143319*^9, 3.9568201596444836`*^9, 3.9568202219111166`*^9, 
   3.9568205644806557`*^9, {3.9568207044634285`*^9, 3.9568207046040287`*^9}, 
   3.956821752822033*^9, 3.9568220305380154`*^9, 3.956822249877204*^9, 
   3.956822328811802*^9, 3.9568224484552164`*^9, 3.956822953901391*^9, {
   3.9568252043358383`*^9, 3.9568252044608088`*^9}, 3.9569065626233997`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0340.png\>\"", ",", "adpConfHypergeomFE1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955159803033*^9, 3.5339552034519095`*^9, 3.547008893618438*^9, 
   3.547008956314948*^9, {3.5501987477128153`*^9, 3.5501987478844156`*^9}, 
   3.5501988226865473`*^9, {3.550469306627704*^9, 3.5504693067681046`*^9}, 
   3.553114272723911*^9, 3.553114315530386*^9, 3.553114569972433*^9, 
   3.55318508843264*^9, {3.553185247131719*^9, 3.5531852473969193`*^9}, 
   3.5531900821741323`*^9, 3.55319015471426*^9, 3.5531908900479517`*^9, 
   3.5531909541796646`*^9, {3.553213790019997*^9, 3.5532138179752464`*^9}, {
   3.553214122440981*^9, 3.5532141511450315`*^9}, {3.556389578501213*^9, 
   3.556389578672813*^9}, 3.5563898772885375`*^9, {3.7325812073847427`*^9, 
   3.7325812080243435`*^9}, 3.7326535267504864`*^9, {3.732659119968313*^9, 
   3.732659120171114*^9}, {3.7326593137530546`*^9, 3.7326593214438686`*^9}, 
   3.740216750953225*^9, 3.740218228489431*^9, 3.740218990196377*^9, 
   3.74077860982647*^9, {3.740780605007178*^9, 3.7407806051787777`*^9}, 
   3.7407823021064887`*^9, {3.740795700305055*^9, 3.740795700539056*^9}, 
   3.7407957379479213`*^9, 3.7411140595270786`*^9, {3.7411141143767753`*^9, 
   3.741114114532776*^9}, 3.7411667457334538`*^9, {3.7411668447156277`*^9, 
   3.741166844871628*^9}, 3.74142115986131*^9, 3.744663700313615*^9, 
   3.744664379024007*^9, 3.7446656127845235`*^9, {3.7446659116810484`*^9, 
   3.744665911868249*^9}, 3.7452127175858293`*^9, {3.74521278093754*^9, 
   3.7452127811247406`*^9}, 3.7452152075218024`*^9, 3.7452154016881437`*^9, 
   3.7460519949503255`*^9, {3.7460520308459883`*^9, 3.74605203162599*^9}, 
   3.746055107834197*^9, 3.746991475479677*^9, {3.746991513918144*^9, 
   3.7469915424973946`*^9}, 3.746991645816376*^9, 3.748111177404529*^9, {
   3.748111322703184*^9, 3.748111322999585*^9}, 3.748112646147109*^9, {
   3.748113203645288*^9, 3.748113203988488*^9}, {3.7507167757248836`*^9, 
   3.7507167790164895`*^9}, 3.750716899963502*^9, {3.750907902190365*^9, 
   3.7509079301456137`*^9}, 3.75090826960221*^9, 3.751350024902258*^9, 
   3.7513500920135756`*^9, {3.7513503300387936`*^9, 3.751350330210394*^9}, 
   3.751400149651678*^9, {3.755049707478676*^9, 3.755049707634676*^9}, {
   3.755049765697978*^9, 3.75504976657158*^9}, 3.755049981945558*^9, 
   3.762283545821921*^9, 3.7622835936204047`*^9, 3.762283681510959*^9, 
   3.764280933902177*^9, 3.7642809906238766`*^9, {3.764281052961586*^9, 
   3.7642810835844398`*^9}, 3.7642811989934425`*^9, 3.764281290331603*^9, 
   3.764291454634307*^9, 3.7642915558472843`*^9, 3.7646644254065423`*^9, {
   3.7646645227819133`*^9, 3.7646645229067135`*^9}, {3.7648873755758543`*^9, 
   3.7648873757318544`*^9}, 3.764887973244104*^9, 3.7648894055102224`*^9, 
   3.765060231344472*^9, 3.765060779434235*^9, 3.7650876619491696`*^9, {
   3.7651708015085583`*^9, 3.7651708016333585`*^9}, 3.7651708746414866`*^9, 
   3.7652589118932266`*^9, {3.7652590299074335`*^9, 3.7652590301102343`*^9}, {
   3.7662195543382516`*^9, 3.766219578331094*^9}, 3.766219677016867*^9, 
   3.7662201983853827`*^9, 3.76647719987669*^9, 3.7664773392785344`*^9, 
   3.7664774867767935`*^9, 3.766477573559746*^9, 3.7666119106500444`*^9, {
   3.767393914938072*^9, 3.7673939150940723`*^9}, 3.7688458990076995`*^9, 
   3.768845992124263*^9, {3.7688460972060475`*^9, 3.768846097424448*^9}, 
   3.791925257442734*^9, {3.791926042673618*^9, 3.7919260678864145`*^9}, 
   3.7919411511491823`*^9, 3.7919412536874685`*^9, 3.7919455822489567`*^9, 
   3.791945613460332*^9, 3.7921427775327096`*^9, {3.7921442341379757`*^9, 
   3.7921442343566737`*^9}, 3.79214499129782*^9, {3.7921450432386465`*^9, 
   3.7921450433948555`*^9}, 3.7922066272150636`*^9, {3.7922081370131783`*^9, 
   3.7922081377629976`*^9}, 3.792270597728077*^9, {3.7922707124977846`*^9, 
   3.7922707126696568`*^9}, 3.792538656565729*^9, 3.792554019510995*^9, 
   3.802546808544753*^9, {3.8025468814650974`*^9, 3.802546882324236*^9}, 
   3.8025469199403934`*^9, 3.8025516303411865`*^9, {3.8025798413202734`*^9, 
   3.8025798500994525`*^9}, {3.80785445090362*^9, 3.8078544763037367`*^9}, 
   3.8078545477278557`*^9, 3.8169060294318476`*^9, 3.816906816785185*^9, 
   3.816906856635206*^9, 3.820806416772484*^9, 3.820806449655319*^9, 
   3.820806517936056*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.8278748592717104`*^9, 3.8278748912173123`*^9, 3.828286639443576*^9, 
   3.848257038638844*^9, 3.848257074614698*^9, 3.848257111481027*^9, 
   3.854761763900452*^9, {3.8547618323859158`*^9, 3.854761855958494*^9}, {
   3.883168591801283*^9, 3.88316864422643*^9}, 3.9565290756180315`*^9, {
   3.9565292024855556`*^9, 3.9565292145296135`*^9}, 3.9568202219111166`*^9, 
   3.956820306781824*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"rp3dConfHypergeomFE1", "=", "\[IndentingNewLine]", 
  RowBox[{"RePlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"3", " ", "\[Pi]"}], ",", "4"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.30"}], ",", 
       RowBox[{"-", "1.77"}], ",", "2.63"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", "30"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
         RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
       "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221349871864`*^9}, {3.533956562109496*^9, 3.533956663650075*^9}, 
   3.5339567557838364`*^9, 3.5347099882825756`*^9, 3.5347102657482634`*^9, {
   3.5347103008951254`*^9, 3.5347103043427315`*^9}, {3.535593994727907*^9, 
   3.535594052120408*^9}, {3.535594118654525*^9, 3.535594142257366*^9}, {
   3.53559417306742*^9, 3.5355941818346357`*^9}, {3.535594253173561*^9, 
   3.535594273141596*^9}, {3.535594308943659*^9, 3.535594311580064*^9}, {
   3.5355943417349167`*^9, 3.5355943446677217`*^9}, 3.5355944944279847`*^9, 
   3.5364644113098073`*^9, 3.547008961306957*^9, 3.547009174886932*^9, 
   3.5470100939009466`*^9, 3.5470101792522974`*^9, {3.547010219671968*^9, 
   3.5470102336495924`*^9}, {3.547010378308647*^9, 3.5470103791978483`*^9}, {
   3.5470106361019*^9, 3.547010661077544*^9}, 3.5501988290669584`*^9, 
   3.550199059994164*^9, 3.550199923226681*^9, {3.5501999833959866`*^9, 
   3.5501999880135946`*^9}, 3.5502073242848244`*^9, 3.5502076305611625`*^9, 
   3.5502077527405767`*^9, 3.550207824360303*^9, {3.5502086208227015`*^9, 
   3.5502086232251062`*^9}, 3.5502087333612995`*^9, {3.550210050393613*^9, 
   3.5502100620780334`*^9}, 3.5503471093742733`*^9, {3.5508011543922625`*^9, 
   3.5508011573094673`*^9}, 3.550801274574874*^9, 3.550828826075177*^9, 
   3.5531145222051487`*^9, 3.5531145764308443`*^9, 3.5531151448958426`*^9, {
   3.553115181758707*^9, 3.5531152194327736`*^9}, 3.5531152549228363`*^9, {
   3.553115444209176*^9, 3.5531154457847786`*^9}, 3.5531154834276447`*^9, 
   3.553184120965741*^9, 3.5531844553835287`*^9, 3.5531849288443604`*^9, {
   3.5531850323193417`*^9, 3.553185039214554*^9}, {3.5534455197643785`*^9, 
   3.5534455226191835`*^9}, {3.564290330151406*^9, 3.564290330151406*^9}, {
   3.564291249632621*^9, 3.5642913088503246`*^9}, {3.5642913587860126`*^9, 
   3.5642913874744625`*^9}, 3.5645701739454827`*^9, 3.56457022934118*^9, {
   3.5645704548083763`*^9, 3.564570523245696*^9}, 3.564632298359475*^9, 
   3.5672835710783267`*^9, 3.5672836098287945`*^9, 3.5672836500924654`*^9, 
   3.5672837096845703`*^9, {3.5672837599322586`*^9, 3.567283785797104*^9}, {
   3.567283815998757*^9, 3.567283882470474*^9}, 3.5672839294421563`*^9, 
   3.567283963200616*^9, 3.567749299701456*^9, 3.567802782394025*^9, 
   3.5678028822498007`*^9, {3.5681600327494287`*^9, 3.5681600592382755`*^9}, {
   3.568160109142763*^9, 3.5681601122315683`*^9}, 3.5681601467388287`*^9, {
   3.568160184319295*^9, 3.56816020424053*^9}, {3.568160517132702*^9, 
   3.568160596162441*^9}, 3.5681606610273547`*^9, {3.568160946421071*^9, 
   3.568160966030306*^9}, {3.5681705219146996`*^9, 3.5681705242703037`*^9}, 
   3.5681941899017687`*^9, 3.568194240352257*^9, 3.5700755677715073`*^9, 
   3.570075613354788*^9, 3.5700766540950155`*^9, {3.570086887572139*^9, 
   3.5700868877641497`*^9}, {3.570087003107747*^9, 3.570087005763899*^9}, {
   3.570087078020032*^9, 3.5700870989962316`*^9}, 3.5700872221102734`*^9, {
   3.57009623935571*^9, 3.570096282536586*^9}, 3.5736048119306808`*^9, 
   3.5736048904456186`*^9, 3.573604940833707*^9, {3.573605077677148*^9, 
   3.573605125865632*^9}, {3.5736051592964907`*^9, 3.573605161948496*^9}, {
   3.573605211119782*^9, 3.5736052136937866`*^9}, {3.5736052478578463`*^9, 
   3.5736052497922497`*^9}, 3.5736058726857443`*^9, 3.573605926771039*^9, {
   3.573605956925892*^9, 3.5736059886719475`*^9}, 3.573606090758527*^9, {
   3.5736061269973907`*^9, 3.57360615517104*^9}, {3.5736066713897743`*^9, 
   3.573606699345023*^9}, 3.573615836289501*^9, 3.57361605569005*^9, 
   3.5736161124242954`*^9, {3.5736161436740828`*^9, 3.5736161737138004`*^9}, 
   3.5736162263498116`*^9, {3.5736162577736087`*^9, 3.573616267602171*^9}, {
   3.573616444274276*^9, 3.5736164466824136`*^9}, {3.574885927166521*^9, 
   3.5748859637953854`*^9}, {3.5748860508435383`*^9, 
   3.5748860521695404`*^9}, {3.5748861157240524`*^9, 3.574886117252855*^9}, 
   3.57577235924708*^9, 3.5757724099589806`*^9, 3.575772445279001*^9, {
   3.5757724785189023`*^9, 3.5757724925687056`*^9}, {3.575772607702291*^9, 
   3.575772651454794*^9}, {3.5759741600893764`*^9, 3.575974161493379*^9}, {
   3.575974199510646*^9, 3.5759742220370855`*^9}, 3.576873240797937*^9, {
   3.5768733189384737`*^9, 3.576873344428919*^9}, {3.576873425346261*^9, 
   3.5768734529895096`*^9}, {3.576873485281566*^9, 3.5768734895091734`*^9}, {
   3.576873525514037*^9, 3.576873525701237*^9}, {3.577055332882147*^9, 
   3.5770553361425524`*^9}, 3.577871528638734*^9, {3.5778716843606405`*^9, 
   3.577871704824811*^9}, 3.5778717538886175`*^9, {3.5778718288889074`*^9, 
   3.577871876976658*^9}, {3.5778719113366227`*^9, 3.577871931008748*^9}, 
   3.577996382595691*^9, 3.5779973953859024`*^9, 3.577997497659682*^9, {
   3.592182738830336*^9, 3.592182738830336*^9}, 3.592182940881891*^9, 
   3.592183011815215*^9, {3.5921894364524994`*^9, 3.592189460086541*^9}, {
   3.592189491785797*^9, 3.592189494235001*^9}, {3.5921895481018953`*^9, 
   3.592189608177601*^9}, 3.592189794161128*^9, 3.5921898423808126`*^9, 
   3.5993883891423397`*^9, {3.5993886376195765`*^9, 3.5993886707696347`*^9}, 
   3.5993887338093452`*^9, 3.599388787067839*^9, 3.5993898053488283`*^9, 
   3.599450646030573*^9, 3.6063523737093935`*^9, {3.6063536327884064`*^9, 
   3.606353657155649*^9}, {3.6063536884961042`*^9, 3.606353715281351*^9}, {
   3.6063541082884493`*^9, 3.606354110690853*^9}, {3.606354174463765*^9, 
   3.6063541934333982`*^9}, 3.606354233681469*^9, {3.606354327624834*^9, 
   3.6063543393872547`*^9}, {3.6063554596717415`*^9, 3.606355469234558*^9}, {
   3.6063556589152913`*^9, 3.6063556888517437`*^9}, {3.6063559489462013`*^9, 
   3.60635597109824*^9}, {3.606356372177745*^9, 3.606356383128964*^9}, {
   3.6063564284002438`*^9, 3.606356435435856*^9}, 3.606356488460349*^9, {
   3.606356550096057*^9, 3.606356592091331*^9}, 3.606362300175032*^9, 
   3.606364095238985*^9, 3.6063646120054927`*^9, {3.606424049973319*^9, 
   3.606424053639326*^9}, 3.6064240927485943`*^9, 3.6064350337292786`*^9, 
   3.6253066892819157`*^9, 3.625306727517583*^9, {3.6253071403575087`*^9, 
   3.625307143961115*^9}, 3.6253071830235834`*^9, 3.625307214270438*^9, 
   3.62530768864248*^9, {3.625307721074937*^9, 3.6253077378137665`*^9}, {
   3.6253078152835026`*^9, 3.625307818465908*^9}, 3.6253078603831816`*^9, 
   3.625308042795102*^9, {3.625308091591988*^9, 3.6253080991112013`*^9}, {
   3.625383389886337*^9, 3.625383390822338*^9}, 3.6253834238787966`*^9, 
   3.6291871861181545`*^9, 3.629187255195076*^9, {3.629187298329152*^9, 
   3.629187319170789*^9}, 3.629187721281896*^9, {3.629187761576767*^9, 
   3.629187773105187*^9}, 3.629187853476528*^9, {3.629189386050821*^9, 
   3.6291893870960226`*^9}, 3.6294129792897773`*^9, {3.629681940821416*^9, 
   3.629681967825063*^9}, 3.6296830652981987`*^9, {3.629683828638739*^9, 
   3.629683873535618*^9}, 3.6296840724983673`*^9, 3.629684659074998*^9, {
   3.6296848918274064`*^9, 3.629684894619811*^9}, 3.630130105717137*^9, 
   3.6301868115768538`*^9, 3.6301913486360464`*^9, {3.6301914399118066`*^9, 
   3.630191440754208*^9}, {3.6301915173347425`*^9, 3.630191517662343*^9}, {
   3.630191564462425*^9, 3.6301915646184254`*^9}, 3.6301916235085287`*^9, 
   3.6301916648486013`*^9, {3.6301916949722548`*^9, 3.630191743254339*^9}, 
   3.630192498482866*^9, 3.630224013755659*^9, 3.6325489583565407`*^9, 
   3.6325493465892234`*^9, 3.6325495969920783`*^9, 3.6325497909544272`*^9, {
   3.6325499065150375`*^9, 3.6325499323798833`*^9}, {3.6326039905906425`*^9, 
   3.6326039969398537`*^9}, {3.6326052476784515`*^9, 3.6326052678180866`*^9}, 
   3.632789691264064*^9, {3.632789738937748*^9, 3.632789739811349*^9}, {
   3.632789771198604*^9, 3.63278978590943*^9}, 3.632789880617196*^9, 
   3.6327899977890024`*^9, 3.63279813902344*^9, 3.632798262731657*^9, 
   3.632807713384465*^9, 3.6328077532581353`*^9, {3.632813931449418*^9, 
   3.6328140063139496`*^9}, {3.632814038262806*^9, 3.632814038481206*^9}, {
   3.6328142150367174`*^9, 3.632814235581953*^9}, {3.632862829136717*^9, 
   3.6328628333643246`*^9}, 3.632863060297923*^9, 3.6328903848425245`*^9, 
   3.6345039605706234`*^9, 3.6345039979950895`*^9, 3.634505028388706*^9, {
   3.634505073659986*^9, 3.634505094844823*^9}, {3.6345051346835*^9, 
   3.6345051909059987`*^9}, {3.634505248002099*^9, 3.6345052831177607`*^9}, 
   3.6345058717026*^9, {3.6345559035261827`*^9, 3.6345559061157875`*^9}, {
   3.634555945349856*^9, 3.634555948313861*^9}, 3.634556202246708*^9, {
   3.6360748453404164`*^9, 3.6360748476336203`*^9}, 3.636075402244196*^9, 
   3.6360755387756352`*^9, 3.6360756646834564`*^9, 3.636076028008095*^9, 
   3.6360760583769555`*^9, {3.6360761965931983`*^9, 3.6360762071856165`*^9}, 
   3.6364953485684733`*^9, 3.6364953884889436`*^9, 3.636495515816367*^9, 
   3.6364955598396444`*^9, 3.63649577777445*^9, {3.6364958118137093`*^9, 
   3.636495860766596*^9}, 3.636495993039228*^9, 3.636496147385899*^9, {
   3.636496214996418*^9, 3.636496253372485*^9}, 3.6364964311815977`*^9, {
   3.6364969697417445`*^9, 3.6364969814261646`*^9}, {3.636762383421364*^9, 
   3.6367623872745705`*^9}, 3.725592441562623*^9, 3.7255925278151746`*^9, 
   3.7255944795378036`*^9, {3.72559451145546*^9, 3.7255945146846657`*^9}, 
   3.7255953568521447`*^9, 3.725595801020926*^9, 3.725595862875035*^9, 
   3.725596145750332*^9, 3.72559634416708*^9, 3.7255964017623816`*^9, {
   3.725600882543482*^9, 3.725600909469129*^9}, 3.725601380552758*^9, 
   3.725771260842998*^9, {3.725774253989055*^9, 3.725774282505905*^9}, {
   3.725774385294486*^9, 3.725774424243362*^9}, {3.7257804563043575`*^9, 
   3.7257804693615804`*^9}, 3.7258490252477674`*^9, 3.7258521016447725`*^9, 
   3.725852258877449*^9, 3.725852363803233*^9, 3.7258524000108967`*^9, 
   3.725852749623111*^9, {3.7258530098159676`*^9, 3.7258530484884357`*^9}, {
   3.7258533935578427`*^9, 3.7258534235566955`*^9}, {3.725853537717696*^9, 
   3.725853546578511*^9}, 3.726913461460272*^9, {3.7269135067003517`*^9, 
   3.726913506715952*^9}, 3.726913573655669*^9, 3.7269142247852125`*^9, {
   3.726914355279442*^9, 3.726914372969873*^9}, 3.7269144359471836`*^9, 
   3.7269145160221243`*^9, 3.726914654581568*^9, 3.726914723206088*^9, {
   3.7269151216475897`*^9, 3.726915129884404*^9}, 3.726915517287485*^9, {
   3.726942972603111*^9, 3.7269429731335115`*^9}, 3.726952629442474*^9, 
   3.7269527024818025`*^9, {3.7325814358471437`*^9, 3.732581510446475*^9}, 
   3.7325815475277395`*^9, {3.7326584462775297`*^9, 3.732658472844376*^9}, {
   3.732658943126403*^9, 3.732658966682444*^9}, 3.7326593293998823`*^9, 
   3.732668442777998*^9, {3.7402181611597123`*^9, 3.740218186072956*^9}, 
   3.740218232124237*^9, {3.7402183905893154`*^9, 3.7402183918841176`*^9}, 
   3.740218439771809*^9, 3.7402184717362657`*^9, {3.740218744752345*^9, 
   3.740218755048363*^9}, {3.7402188877977967`*^9, 3.740218953427112*^9}, {
   3.7402206710333304`*^9, 3.740220709690198*^9}, 3.740623517482953*^9, {
   3.740778612338074*^9, 3.740778614194477*^9}, {3.740778697514224*^9, 
   3.740778713769452*^9}, {3.7407792507571983`*^9, 3.740779281707652*^9}, {
   3.7407793154973116`*^9, 3.7407793317681403`*^9}, {3.74077962170185*^9, 
   3.740779646209493*^9}, 3.7407805331690516`*^9, 3.7407805721691203`*^9, 
   3.7407807771378803`*^9, 3.7407824673731785`*^9, 3.740784298882004*^9, 
   3.740784367336528*^9, 3.7407845511906676`*^9, 3.7407847911139035`*^9, 
   3.740785320891444*^9, {3.740792222878537*^9, 3.74079222451654*^9}, 
   3.740795734391115*^9, 3.7407958434197063`*^9, 3.7407962499408207`*^9, 
   3.740796287817687*^9, 3.7407968561734858`*^9, 3.7407968980127587`*^9, {
   3.7411140633022857`*^9, 3.741114065189889*^9}, 3.7411141817688937`*^9, {
   3.7411142451362047`*^9, 3.7411142815778685`*^9}, {3.7411143643984146`*^9, 
   3.741114394927668*^9}, 3.741114449028563*^9, 3.741165053951681*^9, 
   3.7411667429098487`*^9, 3.741166800005949*^9, 3.741167002587905*^9, 
   3.7418927044966946`*^9, 3.744663705024823*^9, 3.744664181730461*^9, 
   3.7446656128001237`*^9, 3.7446656519405923`*^9, 3.7447503917826357`*^9, 
   3.744875558139942*^9, 3.745212724418641*^9, 3.7452130520192165`*^9, 
   3.7452134415987005`*^9, {3.7452134772759633`*^9, 3.745213477884364*^9}, 
   3.745213581842947*^9, 3.745213760572461*^9, {3.7452137926617174`*^9, 
   3.7452138142521553`*^9}, {3.7452138718318567`*^9, 3.745213901846309*^9}, 
   3.74521397072043*^9, {3.7452140044788895`*^9, 3.745214017692113*^9}, {
   3.745215374934097*^9, 3.745215398848939*^9}, 3.745215733004327*^9, {
   3.745215869754167*^9, 3.74521587134537*^9}, {3.7452159052910295`*^9, 
   3.7452159092066364`*^9}, {3.745215982604765*^9, 3.7452159998115954`*^9}, 
   3.7452162565100465`*^9, 3.74605199750873*^9, {3.7460524917799983`*^9, 
   3.7460525007812138`*^9}, 3.7460544899795113`*^9, 3.74605461420253*^9, {
   3.746054731577136*^9, 3.746054777706417*^9}, {3.7460548234768972`*^9, 
   3.7460548417133293`*^9}, 3.746054911461052*^9, 3.7469916527895885`*^9, 
   3.746995583616094*^9, 3.7469956167661524`*^9, {3.7469957258615446`*^9, 
   3.7469957275151477`*^9}, {3.746995760977206*^9, 3.746995762147208*^9}, {
   3.7469958133464985`*^9, 3.746995836512539*^9}, 3.746995880816617*^9, {
   3.7469959276946993`*^9, 3.746995931984707*^9}, {3.7470008112785206`*^9, 
   3.7470008135717244`*^9}, {3.7470008798094406`*^9, 3.747000881369444*^9}, {
   3.747027563106309*^9, 3.74702756362111*^9}, {3.747028030906732*^9, 
   3.747028033511936*^9}, 3.7481111814917364`*^9, 3.7481112473238516`*^9, 
   3.748111472572647*^9, 3.748111511900316*^9, 3.748111751157937*^9, 
   3.7481117965072165`*^9, 3.748111837706889*^9, 3.7481119389198666`*^9, 
   3.748112002271578*^9, 3.7481126431207037`*^9, 3.7481127702141266`*^9, 
   3.748112890599538*^9, 3.748112975042486*^9, {3.748113023496172*^9, 
   3.748113025196574*^9}, 3.748113104850314*^9, 3.7481148783458304`*^9, 
   3.748152378124942*^9, 3.748156761576641*^9, 3.749668426627076*^9, 
   3.7507169093079185`*^9, {3.750717434654441*^9, 3.7507174520016713`*^9}, 
   3.7507179985374317`*^9, 3.7507180693303566`*^9, 3.750718107222823*^9, {
   3.750718237732652*^9, 3.7507182378574524`*^9}, 3.750718351924853*^9, {
   3.750719888347952*^9, 3.75071989302796*^9}, 3.75072066733372*^9, 
   3.750724214763152*^9, 3.7507255977531834`*^9, 3.7507440011381135`*^9, {
   3.7507441014618897`*^9, 3.7507441048314953`*^9}, 3.7511831548137474`*^9, 
   3.7511832008026285`*^9, {3.751189420749557*^9, 3.7511894221223593`*^9}, {
   3.751189545112975*^9, 3.7511895500581837`*^9}, {3.751191026389179*^9, 
   3.751191036263996*^9}, {3.7511922279880896`*^9, 3.75119225077973*^9}, {
   3.7512741081272516`*^9, 3.7512741083924522`*^9}, 3.751343680793913*^9, {
   3.7513437352380085`*^9, 3.751343748076831*^9}, {3.751343859991428*^9, 
   3.7513438704746466`*^9}, 3.751343972284826*^9, {3.751344206045637*^9, 
   3.751344228946477*^9}, {3.751345479654274*^9, 3.751345479669874*^9}, 
   3.7513458163340654`*^9, {3.7513459501355004`*^9, 3.751345950946702*^9}, 
   3.751346259250044*^9, {3.75134772036421*^9, 3.751347750955864*^9}, {
   3.7513478386904173`*^9, 3.7513478502656384`*^9}, {3.7513480264523478`*^9, 
   3.7513480387451687`*^9}, {3.751356659578311*^9, 3.7513566652723207`*^9}, {
   3.7513584868487215`*^9, 3.751358487051522*^9}, {3.7513587764620385`*^9, 
   3.7513587766960387`*^9}, 3.751359217521613*^9, 3.755049981961158*^9, 
   3.755050081910534*^9, 3.7550501621414747`*^9, {3.7550504076079054`*^9, 
   3.7550504105563107`*^9}, 3.755050934296031*^9, 3.7550519317455764`*^9, {
   3.7550519933656845`*^9, 3.7550521232671127`*^9}, 3.7550521578835735`*^9, 
   3.755061383808256*^9, 3.755137961376438*^9, {3.7551380194709396`*^9, 
   3.755138043448182*^9}, 3.7551380790006447`*^9, {3.755138180494423*^9, 
   3.7551382149704833`*^9}, 3.7551383199274673`*^9, {3.7551384479880924`*^9, 
   3.755138485646559*^9}, {3.7551385328522415`*^9, 3.755138535301446*^9}, {
   3.7551388552780085`*^9, 3.755138867898431*^9}, {3.755138899379286*^9, 
   3.755138900923689*^9}, {3.755141473017996*^9, 3.7551414735015965`*^9}, 
   3.7551423127060127`*^9, 3.755143428371771*^9, {3.7551475899709272`*^9, 
   3.7551475974589405`*^9}, {3.755147763630432*^9, 3.755147798215693*^9}, 
   3.7552236306629615`*^9, 3.7552237351007524`*^9, {3.7552274948275833`*^9, 
   3.7552275018475957`*^9}, 3.7642903579671755`*^9, {3.7642905351382875`*^9, 
   3.764290614448827*^9}, 3.764290670343725*^9, {3.7642907227754173`*^9, 
   3.7642907831007233`*^9}, {3.764290822865193*^9, 3.7642908322408094`*^9}, 
   3.7642909401461987`*^9, {3.76429097484066*^9, 3.764290976041862*^9}, 
   3.764291199136257*^9, {3.7642913149984617`*^9, 3.7642913174008656`*^9}, 
   3.7642916029593673`*^9, 3.764302351074251*^9, 3.7643023945203276`*^9, 
   3.764304227843149*^9, 3.7643178515372825`*^9, 3.76432045498466*^9, 
   3.764370158357931*^9, 3.7643729553032446`*^9, {3.764374606185746*^9, 
   3.764374606466547*^9}, 3.7643849800828085`*^9, 3.764385335676648*^9, {
   3.7646681230006466`*^9, 3.764668147102689*^9}, {3.764668200189582*^9, 
   3.764668201515584*^9}, {3.764668246396863*^9, 3.764668249766469*^9}, 
   3.764668283384528*^9, 3.7646685415805817`*^9, 3.764887973275304*^9, 
   3.764888009139767*^9, 3.7648889009273357`*^9, {3.764890388914151*^9, 
   3.7648904010509725`*^9}, {3.764890438990239*^9, 3.764890439130639*^9}, 
   3.7648906343181825`*^9, 3.76489671665236*^9, 3.7650607837398424`*^9, 
   3.7651708746570864`*^9, 3.7651709275255795`*^9, {3.7651715865911446`*^9, 
   3.7651716002099686`*^9}, {3.765172130556101*^9, 3.7651721436133237`*^9}, 
   3.765258860522336*^9, 3.7652589119088264`*^9, 3.765267845342927*^9, 
   3.766219677032467*^9, 3.766219733644967*^9, 3.766220205062195*^9, 
   3.766224732047748*^9, {3.766371669949203*^9, 3.766371670120803*^9}, {
   3.7664771998922896`*^9, 3.7664772214515276`*^9}, {3.7664774867767935`*^9, 
   3.7664775002396173`*^9}, {3.768845899023299*^9, 3.768845913219324*^9}, {
   3.7688464421018543`*^9, 3.7688464430066557`*^9}, {3.768846907500272*^9, 
   3.768846908498674*^9}, {3.7756127056776414`*^9, 3.7756127085636463`*^9}, 
   3.7919252574583597`*^9, 3.791925346562312*^9, 3.7919254153117027`*^9, {
   3.7919255247077045`*^9, 3.791925531253033*^9}, 3.791925598002926*^9, {
   3.791925817141368*^9, 3.791925857178751*^9}, {3.7919259309425774`*^9, 
   3.791925933801317*^9}, {3.7919260057136*^9, 3.791926009212773*^9}, {
   3.79192660049582*^9, 3.7919266190539074`*^9}, {3.7919271891237907`*^9, 
   3.7919272245842*^9}, {3.7919274867894063`*^9, 3.791927489554371*^9}, {
   3.791927538745885*^9, 3.791927604824026*^9}, {3.7919283206321373`*^9, 
   3.791928328770767*^9}, 3.7919283681131506`*^9, 3.791941147556281*^9, 
   3.791941226943779*^9, {3.791943064803152*^9, 3.791943072441972*^9}, 
   3.7919455853419733`*^9, 3.7919456390636563`*^9, 3.7919457301594105`*^9, {
   3.7919460176571693`*^9, 3.791946064630477*^9}, 3.7919462776270447`*^9, {
   3.7919463420805435`*^9, 3.7919463444393888`*^9}, {3.791948507232851*^9, 
   3.7919485077639413`*^9}, 3.7921427775327096`*^9, 3.7921428813674984`*^9, {
   3.7921430077438335`*^9, 3.7921430285982695`*^9}, {3.792143075102886*^9, 
   3.792143196527261*^9}, 3.7921432320813465`*^9, {3.7921435108289423`*^9, 
   3.7921435112507515`*^9}, {3.792144994000306*^9, 3.7921450236495314`*^9}, 
   3.7921450984755683`*^9, {3.792145135779237*^9, 3.7921451459487057`*^9}, 
   3.7921451813309965`*^9, {3.7921455405896435`*^9, 3.792145540823963*^9}, {
   3.792184495223648*^9, 3.7921844998788123`*^9}, {3.792184623771303*^9, 
   3.7921846334096813`*^9}, {3.792206627230712*^9, 3.792206627230712*^9}, 
   3.7922067487800713`*^9, {3.792206857551155*^9, 3.7922068652212453`*^9}, 
   3.79220731139717*^9, 3.7922074804352627`*^9, {3.792207911722797*^9, 
   3.792207920220762*^9}, 3.7922106315283227`*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709234165945`*^9, 3.7922709273375435`*^9}, 
   3.7922709952589617`*^9, 3.792271044919084*^9, {3.7922714000850353`*^9, 
   3.7922714133162184`*^9}, {3.79227225780206*^9, 3.7922722845301075`*^9}, 
   3.7922726379453006`*^9, 3.792538656581356*^9, 3.792538928359619*^9, {
   3.79253897772618*^9, 3.7925389929881973`*^9}, 3.792539105239499*^9, 
   3.7925391544309196`*^9, {3.7925392146979003`*^9, 3.7925392318501225`*^9}, {
   3.792553251880274*^9, 3.7925533135219245`*^9}, {3.792553558651388*^9, 
   3.7925535983294907`*^9}, 3.7925536300406995`*^9, 3.792553977661547*^9, 
   3.7934110765855913`*^9, 3.802546778036353*^9, 3.8025468148870387`*^9, 
   3.802552822458405*^9, {3.8025530544662237`*^9, 3.8025530844279113`*^9}, {
   3.802553133713169*^9, 3.8025531354783773`*^9}, {3.8025532097421217`*^9, 
   3.8025532578048534`*^9}, {3.802553588023881*^9, 3.802553607941058*^9}, {
   3.8025798334471254`*^9, 3.802579836009097*^9}, 3.8025799428439727`*^9, 
   3.8025826954822035`*^9, 3.807854554258397*^9, 3.807854690828374*^9, {
   3.8078547263903584`*^9, 3.8078547526052713`*^9}, {3.8078547973826*^9, 
   3.8078548259492536`*^9}, 3.807854857290492*^9, {3.807855065442194*^9, 
   3.8078550755771074`*^9}, 3.816906042506902*^9, 3.8169062174197626`*^9, {
   3.8169062961825204`*^9, 3.8169063081953278`*^9}, 3.8169064017358685`*^9, 
   3.8169064565355053`*^9, {3.816906506133236*^9, 3.816906533095647*^9}, 
   3.8169065818185563`*^9, 3.816906741702897*^9, 3.8169069030617733`*^9, 
   3.816911863808765*^9, {3.820806523044219*^9, 3.820806525543599*^9}, {
   3.820806605337228*^9, 3.820806634720892*^9}, {3.820806728870463*^9, 
   3.8208067606910887`*^9}, 3.8208068514664154`*^9, 3.8208068887857084`*^9, {
   3.820806986417849*^9, 3.820806992557019*^9}, 3.820807050543249*^9, 
   3.8208071575179443`*^9, {3.827874604494393*^9, 3.8278746309725633`*^9}, 
   3.828286126815601*^9, 3.828286178522227*^9, {3.8282862114207487`*^9, 
   3.828286249083788*^9}, 3.8282862800765343`*^9, {3.828286322644653*^9, 
   3.828286322972701*^9}, {3.828286357931463*^9, 3.828286378520382*^9}, 
   3.828286413949597*^9, 3.8282865511517544`*^9, 3.828849014384474*^9, {
   3.8482570386544743`*^9, 3.8482570386544743`*^9}, {3.848257162547103*^9, 
   3.8482572050995564`*^9}, 3.8482572474489293`*^9, 3.8482592289492965`*^9, 
   3.8482592632131195`*^9, 3.8482593480525*^9, {3.8482596406568003`*^9, 
   3.848259662354802*^9}, {3.8482598575520773`*^9, 3.848259863863089*^9}, {
   3.848259935769012*^9, 3.848259938174694*^9}, {3.848260033511561*^9, 
   3.8482600702372885`*^9}, {3.848260636230188*^9, 3.848260666894863*^9}, 
   3.8482606989966545`*^9, 3.8482607541243086`*^9, {3.8547617639317226`*^9, 
   3.854761763947344*^9}, 3.854761807093421*^9, {3.854761939287712*^9, 
   3.854761948035654*^9}, {3.854762215597452*^9, 3.8547622692588873`*^9}, {
   3.8547623089584866`*^9, 3.854762311739122*^9}, {3.8547623431746674`*^9, 
   3.854762363654195*^9}, 3.854763519987254*^9, 3.8831684261211495`*^9, 
   3.883168549077005*^9, 3.8831685918169317`*^9, {3.883169007296896*^9, 
   3.88316901865359*^9}, 3.883169538507764*^9, 3.8831706590004115`*^9, 
   3.883170863795307*^9, {3.9565290756180315`*^9, 3.9565290756180315`*^9}, 
   3.9565292781396837`*^9, {3.9565293331424026`*^9, 3.9565293645100403`*^9}, 
   3.9565294692042217`*^9, 3.956529507929509*^9, {3.9565295473808737`*^9, 
   3.9565295677979517`*^9}, {3.9565297430061445`*^9, 
   3.9565297484892626`*^9}, {3.956529847778465*^9, 3.956529900063098*^9}, {
   3.9565301658693733`*^9, 3.956530172289773*^9}, 3.9565304532600217`*^9, 
   3.9568201598631525`*^9, 3.9568202219267387`*^9, 3.956820567698649*^9, {
   3.956820711789831*^9, 3.956820717600977*^9}, 3.956821498241086*^9, 
   3.9568215738326893`*^9, {3.956821662343169*^9, 3.9568216646864047`*^9}, {
   3.956821728499555*^9, 3.9568217556181965`*^9}, 3.9568220349276447`*^9, 
   3.95682222307096*^9, 3.9568229579941854`*^9, {3.9568252148178043`*^9, 
   3.9568252149427238`*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0350.png\>\"", ",", "rp3dConfHypergeomFE1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.5339551667918453`*^9, 3.5339552009091053`*^9, 3.5470088969568434`*^9, 
   3.5470089640057616`*^9, {3.5501987513788223`*^9, 3.550198751410022*^9}, 
   3.5501988321245637`*^9, {3.5504693115261126`*^9, 3.550469311666513*^9}, 
   3.5531142779343195`*^9, 3.5531143119735794`*^9, 3.5531145798316503`*^9, 
   3.55318508241103*^9, {3.55318525330933*^9, 3.5531852534809303`*^9}, 
   3.553190085153738*^9, 3.553190157912266*^9, 3.553190885227544*^9, {
   3.553190960606876*^9, 3.5531909607628765`*^9}, {3.5532137942008047`*^9, 
   3.553213813825639*^9}, {3.55321412771379*^9, 3.553214156714241*^9}, {
   3.556389588766031*^9, 3.5563895889376307`*^9}, 3.5563898811573443`*^9, {
   3.7325812234839706`*^9, 3.7325812239051714`*^9}, 3.7326535205260754`*^9, {
   3.7326591250071225`*^9, 3.7326591252255225`*^9}, 3.732659348416316*^9, 
   3.7402167509688253`*^9, 3.740218234479841*^9, 3.740218993768783*^9, 
   3.740778618671685*^9, {3.7407806106543875`*^9, 3.740780610810388*^9}, {
   3.740782307394898*^9, 3.7407823078160987`*^9}, {3.7407957072626677`*^9, 
   3.740795732191511*^9}, 3.7411140683254943`*^9, {3.7411141195091844`*^9, 
   3.7411141197119846`*^9}, 3.7411667406790447`*^9, {3.7411668525936413`*^9, 
   3.7411668526872416`*^9}, {3.7414211411412773`*^9, 3.7414211413128777`*^9}, 
   3.7446637082540293`*^9, {3.744664383891216*^9, 3.7446643841564164`*^9}, 
   3.7446656128001237`*^9, {3.744665919325062*^9, 3.7446659194654617`*^9}, 
   3.745212728256248*^9, {3.7452127863195496`*^9, 3.7452127865379505`*^9}, 
   3.745215210719808*^9, 3.7452153969769354`*^9, 3.7460519999891343`*^9, {
   3.7460520390048027`*^9, 3.746052039628804*^9}, 3.7460551110166025`*^9, 
   3.7469914786308823`*^9, {3.7469915178025513`*^9, 3.746991547068203*^9}, 
   3.7469916572823963`*^9, 3.7481111850173426`*^9, {3.7481113291771955`*^9, 
   3.748111329348796*^9}, 3.7481126410927*^9, 3.7481132104469*^9, {
   3.750716795334118*^9, 3.7507167978769226`*^9}, 3.750716914752328*^9, 
   3.750907902205965*^9, {3.7509079354808235`*^9, 3.750907935777224*^9}, 
   3.7509082696178102`*^9, 3.751350024917858*^9, 3.7513500920135756`*^9, {
   3.751350335186803*^9, 3.7513503353740034`*^9}, 3.7514001537856855`*^9, {
   3.7550497020342665`*^9, 3.755049702159066*^9}, {3.755049780455604*^9, 
   3.7550497817660065`*^9}, 3.755049981961158*^9, 3.7622835534347343`*^9, 
   3.7622835983940134`*^9, 3.7622836925245786`*^9, 3.7642809470685997`*^9, 
   3.764280993650282*^9, {3.764281062056402*^9, 3.7642810876404467`*^9}, 
   3.7642812103970623`*^9, {3.7642812957916126`*^9, 3.764281295994413*^9}, 
   3.7642914608743176`*^9, 3.7642915591544905`*^9, 3.764664425437742*^9, {
   3.7646645337331324`*^9, 3.7646645339047327`*^9}, {3.7648873895846786`*^9, 
   3.764887389771879*^9}, 3.764887973275304*^9, 3.764889411126232*^9, 
   3.765060236898082*^9, 3.7650607861422467`*^9, {3.765087671387186*^9, 
   3.7650876715275865`*^9}, {3.7651708114457755`*^9, 3.765170811664176*^9}, 
   3.7651708746570864`*^9, 3.765258911924426*^9, {3.765259045601061*^9, 
   3.7652590457882614`*^9}, {3.766219554353852*^9, 3.766219582964302*^9}, 
   3.766219677032467*^9, 3.7662202070277977`*^9, 3.7664771998922896`*^9, 
   3.7664773392785344`*^9, 3.7664774867923937`*^9, 3.766477573575346*^9, 
   3.766611931678881*^9, {3.7673939264508924`*^9, 3.767393926622493*^9}, 
   3.768845899023299*^9, 3.768845992139863*^9, 3.7688461046784606`*^9, 
   3.791925257473979*^9, 3.7919260459384813`*^9, {3.791926076384407*^9, 
   3.791926077056122*^9}, 3.7919411447288256`*^9, 3.7919412585144467`*^9, {
   3.791945587700791*^9, 3.7919456092894487`*^9}, 3.7921427775327096`*^9, {
   3.7921442396836076`*^9, 3.7921442398866467`*^9}, 3.7921449966246824`*^9, {
   3.7921450490810156`*^9, 3.792145049205987*^9}, 3.792206627230712*^9, {
   3.792208145964188*^9, 3.7922081471983175`*^9}, 3.7922705977436914`*^9, {
   3.7922707178871346`*^9, 3.792270718027725*^9}, 3.792538656581356*^9, 
   3.792554025353397*^9, 3.8025468178550973`*^9, {3.8025468885259333`*^9, 
   3.802546916941086*^9}, 3.8025516349182377`*^9, {3.8025798245429773`*^9, 
   3.8025798309477167`*^9}, 3.8078544471885157`*^9, {3.807854484527757*^9, 
   3.8078544851420836`*^9}, 3.8078545576323867`*^9, 3.8169060469746084`*^9, 
   3.8169068200344243`*^9, 3.816906860056246*^9, 3.8208064231928377`*^9, 
   3.82080645710668*^9, 3.8208065296052046`*^9, {3.827874604510014*^9, 
   3.8278746309725633`*^9}, 3.8278748592717104`*^9, 3.827874904026807*^9, 
   3.828286644676685*^9, 3.8482570386544743`*^9, 3.8482570746303196`*^9, 
   3.8482571201821003`*^9, 3.854761763962966*^9, {3.8547618360100236`*^9, 
   3.8547618598794146`*^9}, {3.883168591832553*^9, 3.8831686183106723`*^9}, {
   3.883168650240633*^9, 3.883168650334363*^9}, 3.9565290756336536`*^9, {
   3.9565292024855556`*^9, 3.9565292194190598`*^9}, 3.956820221942359*^9, 
   3.956820306797447*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ip3dConfHypergeomFE1", "=", "\[IndentingNewLine]", 
  RowBox[{"ImPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"3", " ", "\[Pi]"}], ",", "4"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.30"}], ",", 
       RowBox[{"-", "1.77"}], ",", "2.63"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", "30"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
         RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
       "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221546276207`*^9}, {3.533956568630308*^9, 3.533956665834079*^9}, 
   3.533956762975449*^9, 3.534709995286988*^9, 3.5347102702566714`*^9, {
   3.534710307587537*^9, 3.5347103104111423`*^9}, {3.5355943645733566`*^9, 
   3.535594376788178*^9}, 3.535594491198779*^9, 3.5364644067701993`*^9, 
   3.5470089687325697`*^9, 3.5470091814857435`*^9, 3.547010097738553*^9, 
   3.5470101745878887`*^9, {3.5470102237747755`*^9, 3.547010237268799*^9}, {
   3.547010380711051*^9, 3.5470103817718525`*^9}, {3.5470104851844344`*^9, 
   3.547010496198054*^9}, {3.5470106544943323`*^9, 3.5470106643379498`*^9}, 
   3.5501988381617746`*^9, 3.5501990644401717`*^9, 3.5501999267834873`*^9, 
   3.55019999637521*^9, 3.5502073267184286`*^9, 3.5502076353347707`*^9, 
   3.5502077484661694`*^9, 3.550207835311522*^9, 3.5502086336303244`*^9, 
   3.550208731848097*^9, 3.550210071001249*^9, 3.550347114335082*^9, {
   3.550801163206278*^9, 3.550801166139083*^9}, 3.550801269660865*^9, 
   3.550828851690422*^9, 3.5531145252783546`*^9, 3.5531145863212614`*^9, 
   3.55311514895185*^9, {3.5531151847383127`*^9, 3.553115215641967*^9}, 
   3.553115260164445*^9, {3.5531154473135815`*^9, 3.553115448514784*^9}, 
   3.5531154849408474`*^9, 3.553184125130948*^9, 3.5531844635735426`*^9, 
   3.553184932650767*^9, {3.5531850286689353`*^9, 3.5531850425373597`*^9}, {
   3.5534455293427954`*^9, 3.553445530746798*^9}, {3.5534883365952864`*^9, 
   3.553488340932094*^9}, 3.553543103023369*^9, {3.5642903301670055`*^9, 
   3.5642903301670055`*^9}, {3.564291253782228*^9, 3.564291279803074*^9}, {
   3.564291310691128*^9, 3.5642913116739297`*^9}, 3.5642913605800157`*^9, 
   3.5642913913588696`*^9, 3.5645701775490894`*^9, 3.5645702349415903`*^9, {
   3.5645704646519933`*^9, 3.5645704806576214`*^9}, {3.564632162083235*^9, 
   3.5646321622704353`*^9}, {3.5672835744635324`*^9, 3.567283599189576*^9}, 
   3.567283658984481*^9, 3.567283712648576*^9, {3.5672837757506866`*^9, 
   3.5672838367779937`*^9}, 3.567283936711769*^9, 3.5672839671942225`*^9, 
   3.567749304927465*^9, 3.567802786200432*^9, 3.5678028867426085`*^9, 
   3.568197679377499*^9, 3.5681977398588057`*^9, {3.568197770497259*^9, 
   3.568197789934893*^9}, 3.568197954873983*^9, 3.570075573527918*^9, 
   3.5700756161159925`*^9, 3.5700766576674213`*^9, {3.570086891428359*^9, 
   3.5700868916123695`*^9}, {3.570087021291787*^9, 3.5700870234839125`*^9}, {
   3.570087084260389*^9, 3.5700871039165125`*^9}, 3.5700872267835407`*^9, {
   3.5700962429593163`*^9, 3.570096251367731*^9}, 3.5700963382910833`*^9, 
   3.573604824020702*^9, 3.573604898479633*^9, 3.5736049445153136`*^9, {
   3.5736050810779533`*^9, 3.5736051059131975`*^9}, 3.573605138158454*^9, 
   3.5736051863625383`*^9, {3.573605233568221*^9, 3.5736052565938616`*^9}, 
   3.573605861250924*^9, 3.5736059303122454`*^9, 3.5736059609350986`*^9, {
   3.573605994537558*^9, 3.5736059957855597`*^9}, 3.573606094143733*^9, 
   3.5736061630646544`*^9, {3.5736066875826025`*^9, 3.5736067019502277`*^9}, 
   3.573615827794015*^9, 3.573616064212538*^9, {3.5736161174245815`*^9, 
   3.573616176377953*^9}, 3.573616231172087*^9, 3.573616275574627*^9, {
   3.5736164520657215`*^9, 3.5736164539218273`*^9}, {3.574885930536127*^9, 
   3.574885961158981*^9}, {3.5748860538543434`*^9, 3.574886055414346*^9}, {
   3.57488610316603*^9, 3.574886104788433*^9}, 3.575772368950635*^9, 
   3.575772414543243*^9, {3.5757724483991795`*^9, 3.575772496190913*^9}, {
   3.575772614086656*^9, 3.5757726286944914`*^9}, 3.5757726590812297`*^9, {
   3.5759741411197433`*^9, 3.5759741561581697`*^9}, {3.5759742021002502`*^9, 
   3.5759742157346745`*^9}, 3.5768732485823507`*^9, {3.5768733225420804`*^9, 
   3.576873346644123*^9}, {3.5768734557819147`*^9, 3.576873461850325*^9}, {
   3.5768734924263787`*^9, 3.57687352147363*^9}, {3.5770554598819695`*^9, 
   3.577055463204776*^9}, 3.5778715362491693`*^9, {3.5778716912240334`*^9, 
   3.577871702816696*^9}, 3.5778717565767713`*^9, {3.5778718371413794`*^9, 
   3.577871932399828*^9}, 3.5779963889137025`*^9, {3.5779971639186645`*^9, 
   3.577997164261865*^9}, 3.577997327712983*^9, {3.5779973707690587`*^9, 
   3.577997383857482*^9}, 3.577997501216488*^9, {3.592182738845936*^9, 
   3.592182738861536*^9}, 3.592182944360697*^9, 3.5921830186012273`*^9, 
   3.592189432880093*^9, 3.592189463674547*^9, {3.592189504297019*^9, 
   3.592189506559023*^9}, 3.592189562375921*^9, {3.592189594262377*^9, 
   3.5921896106424055`*^9}, 3.5921897904795218`*^9, 3.592189846156019*^9, 
   3.592355462843272*^9, 3.59938841163758*^9, {3.599388677087646*^9, 
   3.599388684560059*^9}, 3.5993887418121595`*^9, 3.5993887919038477`*^9, 
   3.599389809202035*^9, 3.5994506393849616`*^9, 3.606352380183405*^9, {
   3.6063536387788167`*^9, 3.606353654363244*^9}, {3.606353693441313*^9, 
   3.6063537178865557`*^9}, 3.606354117960466*^9, {3.6063541792997737`*^9, 
   3.606354199065008*^9}, 3.606354347452469*^9, {3.606355491121396*^9, 
   3.606355500497013*^9}, {3.6063556639697*^9, 3.606355691815749*^9}, {
   3.606355951598206*^9, 3.606355974249446*^9}, 3.6063566362550087`*^9, 
   3.6063623067270436`*^9, 3.6063641073134065`*^9, 3.6063646163423004`*^9, {
   3.606424064606145*^9, 3.606424095525399*^9}, 3.606435037067684*^9, 
   3.6253066976903305`*^9, 3.6253067308559885`*^9, {3.625307148703523*^9, 
   3.6253071524163303`*^9}, 3.6253071875163918`*^9, 3.6253072177180443`*^9, {
   3.625307746315781*^9, 3.625307759903405*^9}, {3.625307823676317*^9, 
   3.625307828637126*^9}, 3.62530786493839*^9, 3.625308047693511*^9, {
   3.6253081020908065`*^9, 3.6253081157564306`*^9}, {3.6253833845823274`*^9, 
   3.6253833858459296`*^9}, 3.6253834204935904`*^9, 3.6291871979741755`*^9, 
   3.6291872594694834`*^9, {3.6291872945851455`*^9, 3.6291873218851933`*^9}, 
   3.6291877401579294`*^9, 3.6291877836352053`*^9, 3.6291878504345226`*^9, 
   3.629188085136935*^9, {3.6291893908088293`*^9, 3.62918939137043*^9}, 
   3.629412984390986*^9, {3.6296819408526163`*^9, 3.629681967825063*^9}, 
   3.6296830686522045`*^9, {3.6296838311971436`*^9, 3.629683868200409*^9}, 
   3.629684076866375*^9, 3.6296853116949444`*^9, 3.6301301057327366`*^9, 
   3.630186815320861*^9, 3.630191351912052*^9, {3.630191442251811*^9, 
   3.630191443047412*^9}, {3.6301915674264307`*^9, 3.630191567582431*^9}, 
   3.630191627034135*^9, 3.6301916686862087`*^9, {3.630191698872261*^9, 
   3.630191748199548*^9}, 3.6301925032876744`*^9, 3.6302240261576805`*^9, 
   3.6325489666245556`*^9, 3.6325493494752283`*^9, 3.632549601344486*^9, 
   3.6325497935128317`*^9, {3.6325499103370447`*^9, 3.632549935952289*^9}, {
   3.6326052493632545`*^9, 3.6326052629040785`*^9}, 3.63278969455567*^9, {
   3.632789742073353*^9, 3.632789791213439*^9}, 3.632789884486003*^9, 
   3.63279000237541*^9, 3.632798142408646*^9, 3.6327982664912643`*^9, 
   3.6328077266600885`*^9, 3.6328077568617415`*^9, {3.6328139368782277`*^9, 
   3.6328140112279577`*^9}, {3.632814042646413*^9, 3.6328140428492136`*^9}, {
   3.6328142255199356`*^9, 3.6328142422743645`*^9}, {3.6328628377011323`*^9, 
   3.6328628382471333`*^9}, 3.632863071561143*^9, 3.6328903827053213`*^9, {
   3.63450396414303*^9, 3.634503989945475*^9}, 3.634505031134311*^9, {
   3.6345050814287996`*^9, 3.6345050826300015`*^9}, {3.634505119567073*^9, 
   3.6345051390203075`*^9}, {3.63450518026678*^9, 3.6345051946500053`*^9}, {
   3.634505252089306*^9, 3.634505279467354*^9}, {3.6345559523854685`*^9, 
   3.634555955614674*^9}, 3.634556221122741*^9, {3.6360748556676345`*^9, 
   3.636074857804838*^9}, 3.6360754056294017`*^9, 3.6360755416304407`*^9, {
   3.636075572097294*^9, 3.6360755749364986`*^9}, 3.6360756677410617`*^9, 
   3.6360760229536858`*^9, {3.6360760624173627`*^9, 3.6360760925254154`*^9}, 
   3.6360761236318703`*^9, {3.636495351875679*^9, 3.636495380361329*^9}, 
   3.636495512727562*^9, 3.6364955557680373`*^9, 3.636495774451644*^9, {
   3.636495808288103*^9, 3.6364958628569994`*^9}, 3.636495995379232*^9, 
   3.6364961521595078`*^9, 3.6364963213886046`*^9, 3.636496426595189*^9, 
   3.636496986184173*^9, {3.6367624760855265`*^9, 3.636762479361532*^9}, 
   3.7255924293790016`*^9, 3.7255925317463818`*^9, 3.7255944743117948`*^9, {
   3.725594518943473*^9, 3.7255945214862776`*^9}, 3.7255953603777514`*^9, 
   3.7255957972769194`*^9, {3.7255958312537794`*^9, 3.7255958481174088`*^9}, {
   3.725596058390178*^9, 3.7255960649109898`*^9}, 3.7255963371938677`*^9, 
   3.72559640661399*^9, {3.725601386418369*^9, 3.7256014341076527`*^9}, 
   3.7257712704994154`*^9, 3.725774257093461*^9, 3.72577429072712*^9, {
   3.725774416443348*^9, 3.7257744278937683`*^9}, 3.725779901988584*^9, 
   3.72578045202995*^9, 3.7258490308793774`*^9, 3.7258521063247805`*^9, 
   3.725852262605855*^9, 3.725852360558427*^9, 3.7258524069529085`*^9, 
   3.725852753257917*^9, 3.725853436567118*^9, {3.7258534847400026`*^9, 
   3.7258535107140484`*^9}, {3.725853667353924*^9, 3.7258536787419434`*^9}, 
   3.726913461475872*^9, {3.726913506715952*^9, 3.7269135067315516`*^9}, 
   3.726913573655669*^9, 3.7269142285136194`*^9, {3.7269143657158604`*^9, 
   3.7269143772130804`*^9}, 3.726914441095193*^9, 3.7269145189861298`*^9, 
   3.726914651929563*^9, 3.7269147274648952`*^9, 3.726915143191228*^9, {
   3.7269151750932837`*^9, 3.7269151752336836`*^9}, {3.7269155027638597`*^9, 
   3.726915507599868*^9}, {3.726942965317898*^9, 3.7269429659418993`*^9}, 
   3.7269527321998544`*^9, {3.732581567667375*^9, 3.732581616495461*^9}, {
   3.732658450427137*^9, 3.732658468772769*^9}, {3.732658950832816*^9, 
   3.7326589718928533`*^9}, 3.7326593484319158`*^9, 3.7326684474112062`*^9, {
   3.740218164622918*^9, 3.740218189130562*^9}, 3.7402182402830515`*^9, {
   3.7402183944893227`*^9, 3.7402184164385605`*^9}, 3.740218476010673*^9, 
   3.740218965392333*^9, 3.7402207306098347`*^9, 3.740623523847764*^9, {
   3.7407786224156923`*^9, 3.7407786244124956`*^9}, {3.740778719260662*^9, 
   3.7407787320526843`*^9}, {3.7407792555464067`*^9, 3.7407793011608863`*^9}, 
   3.7407793394121532`*^9, {3.740779664601926*^9, 3.7407796776747484`*^9}, 
   3.7407805414526663`*^9, 3.740780576287527*^9, 3.7407807802890854`*^9, 
   3.74078247376919*^9, {3.7407839511537724`*^9, 3.7407839979846582`*^9}, 
   3.7407842696709504`*^9, {3.740784331289063*^9, 3.7407843341800685`*^9}, {
   3.740784465266109*^9, 3.7407844673429127`*^9}, 3.740784531285632*^9, 
   3.74078474467282*^9, {3.740785226216671*^9, 3.740785234380486*^9}, {
   3.74079231722311*^9, 3.740792318034312*^9}, 3.740795728899905*^9, 
   3.740795848146515*^9, 3.740796253029626*^9, 3.7407962960389013`*^9, 
   3.7407968627566967`*^9, 3.7407969034103684`*^9, {3.7411140723503017`*^9, 
   3.7411140740039043`*^9}, 3.7411141862149014`*^9, {3.7411142414077983`*^9, 
   3.7411142788634644`*^9}, {3.741114361278409*^9, 3.741114362464011*^9}, 
   3.741114397938473*^9, 3.7411144525385695`*^9, 3.741165060176092*^9, 
   3.741166736872638*^9, 3.7411668048419576`*^9, 3.741167005957511*^9, 
   3.741892706493498*^9, 3.7446637127156367`*^9, 3.744664185162467*^9, 
   3.7446656128001237`*^9, 3.7446656519561925`*^9, 3.7447503942786407`*^9, 
   3.7448755599807453`*^9, 3.7452127385678663`*^9, 3.7452130555136228`*^9, 
   3.7452134456391077`*^9, {3.7452134806767693`*^9, 3.7452134813007703`*^9}, 
   3.745213585493354*^9, 3.745213767873274*^9, {3.7452137983869276`*^9, 
   3.7452138193377643`*^9}, {3.745213904810314*^9, 3.7452139139363303`*^9}, {
   3.745213949395193*^9, 3.7452139495823927`*^9}, {3.745213986975659*^9, 
   3.74521402177932*^9}, {3.7452153772273006`*^9, 3.7452153940753307`*^9}, {
   3.7452158730613728`*^9, 3.745215903824627*^9}, {3.7452159530895133`*^9, 
   3.7452159792039595`*^9}, 3.745216259770452*^9, 3.7460520035615406`*^9, {
   3.746054453943448*^9, 3.7460544574378543`*^9}, 3.746054497295924*^9, 
   3.746054597682101*^9, {3.7460547541659756`*^9, 3.7460547746800117`*^9}, 
   3.7460548541777515`*^9, 3.746054960086337*^9, 3.746991665534811*^9, 
   3.746995590370906*^9, 3.7469956213057604`*^9, {3.746995729995552*^9, 
   3.746995731243554*^9}, {3.7469957645028124`*^9, 3.746995765407614*^9}, {
   3.746995818198107*^9, 3.7469958661213913`*^9}, {3.7469959375383167`*^9, 
   3.746995941453923*^9}, {3.747000815490528*^9, 3.7470008173313313`*^9}, {
   3.7470008849886503`*^9, 3.7470008863926525`*^9}, {3.7470275513438883`*^9, 
   3.7470275518742895`*^9}, {3.7470280525595703`*^9, 3.7470280552115746`*^9}, 
   3.7481111897753506`*^9, 3.7481112427842436`*^9, 3.748111476535054*^9, 
   3.7481115164555244`*^9, 3.7481117566959467`*^9, 3.7481117914684076`*^9, 
   3.7481118423556967`*^9, 3.7481119434438744`*^9, 3.7481119960783668`*^9, 
   3.7481126379102945`*^9, 3.7481127727725315`*^9, 3.748112894015944*^9, 
   3.7481129700816774`*^9, {3.748113028800181*^9, 3.748113030016983*^9}, 
   3.7481131110123253`*^9, 3.748114875740626*^9, 3.748152382102949*^9, 
   3.748156767894652*^9, 3.749668431509885*^9, 3.7507169249859457`*^9, {
   3.7507174668996973`*^9, 3.750717469458102*^9}, 3.750718004418642*^9, 
   3.750718074774766*^9, 3.7507181111072297`*^9, {3.7507182219610243`*^9, 
   3.7507182332866445`*^9}, 3.7507183577748632`*^9, {3.750719884635145*^9, 
   3.750719897083967*^9}, 3.750720673464531*^9, 3.7507242419383993`*^9, 
   3.7507256027451925`*^9, 3.750744003618518*^9, {3.750744093771076*^9, 
   3.7507440965790815`*^9}, 3.7511831548293476`*^9, 3.7511832008026285`*^9, {
   3.751189424649564*^9, 3.7511894256479654`*^9}, 3.7511895614618044`*^9, {
   3.7511910305075865`*^9, 3.7511910391500015`*^9}, {3.751192237613307*^9, 
   3.751192254305336*^9}, 3.751230212036337*^9, {3.751274116442066*^9, 
   3.7512741166136665`*^9}, 3.751343682541116*^9, {3.751343733085205*^9, 
   3.7513437501204348`*^9}, 3.751344238166094*^9, 3.75134430452861*^9, {
   3.751345479669874*^9, 3.7513454796854744`*^9}, 3.751345820748873*^9, {
   3.7513459524443045`*^9, 3.7513459532399063`*^9}, 3.751346262260849*^9, {
   3.751348105092086*^9, 3.7513481245765195`*^9}, {3.7513566618091145`*^9, 
   3.751356668220726*^9}, {3.751358491060729*^9, 3.7513584912323294`*^9}, {
   3.75135877156363*^9, 3.75135877173523*^9}, 3.751359211999203*^9, 
   3.755049981976758*^9, 3.7550500821133337`*^9, 3.7550501621414747`*^9, {
   3.755050416297121*^9, 3.7550504199943275`*^9}, 3.7550509388668385`*^9, 
   3.7550519367687855`*^9, {3.755051997187691*^9, 3.755052060695403*^9}, 
   3.7550521337191315`*^9, 3.7550521647007856`*^9, 3.7550613876302633`*^9, 
   3.7551379564936295`*^9, {3.755138024930949*^9, 3.7551380411237783`*^9}, 
   3.755138082682251*^9, {3.7551381845348296`*^9, 3.7551382172792873`*^9}, 
   3.7551383234530735`*^9, {3.755138441217681*^9, 3.7551385276106324`*^9}, {
   3.755138882422056*^9, 3.755138897273282*^9}, {3.7551414688371882`*^9, 
   3.7551414693363895`*^9}, 3.755142317557621*^9, 3.755143433067379*^9, {
   3.7551476031529503`*^9, 3.7551476133397684`*^9}, 3.7551478086989117`*^9, 
   3.7552236306785617`*^9, 3.7552237351007524`*^9, {3.7552275045464*^9, 
   3.7552275077132063`*^9}, 3.7642903539579687`*^9, 3.76429053655789*^9, {
   3.7642905687251463`*^9, 3.7642906105332203`*^9}, 3.764290668502922*^9, {
   3.7642907246006203`*^9, 3.764290784832326*^9}, {3.7642908265935993`*^9, 
   3.7642908360628157`*^9}, 3.7642909449510074`*^9, {3.764290981189871*^9, 
   3.764290981876272*^9}, 3.7642912047834673`*^9, {3.764291319491269*^9, 
   3.764291321378873*^9}, 3.764291611398982*^9, 3.7643023539758563`*^9, 
   3.7643023976559334`*^9, 3.764304230323553*^9, 3.7643178534248857`*^9, 
   3.7643204595866685`*^9, 3.764370162398338*^9, 3.764372959000451*^9, {
   3.7643746106161537`*^9, 3.7643746108813543`*^9}, 3.764384946199549*^9, 
   3.764385323602227*^9, 3.7646681264950523`*^9, 3.764668209284398*^9, {
   3.7646682425904565`*^9, 3.7646682533076754`*^9}, 3.764668288563737*^9, 
   3.764668544731787*^9, 3.764887973290904*^9, 3.7648880093425674`*^9, 
   3.7648889030021396`*^9, {3.7648903950293617`*^9, 3.7648904044205785`*^9}, {
   3.764890442796646*^9, 3.7648904429526463`*^9}, 3.7648906360965853`*^9, 
   3.7648967215975685`*^9, 3.765060789137452*^9, 3.7651708746726866`*^9, 
   3.7651709275255795`*^9, {3.765171589180749*^9, 3.765171597479964*^9}, {
   3.765172134970908*^9, 3.765172146390128*^9}, 3.7652588607251368`*^9, 
   3.765258911924426*^9, 3.7652678488217335`*^9, 3.766219677032467*^9, 
   3.766219733644967*^9, 3.766220209789003*^9, 3.766224738350159*^9, {
   3.766371673365609*^9, 3.7663716735372095`*^9}, {3.7664771999078894`*^9, 
   3.766477221467128*^9}, {3.7664774867923937`*^9, 3.7664775002552176`*^9}, {
   3.768845899023299*^9, 3.768845913219324*^9}, {3.768846446688262*^9, 
   3.7688464478114643`*^9}, {3.7688469105734777`*^9, 3.768846911556279*^9}, {
   3.7756127125728536`*^9, 3.775612713805256*^9}, 3.791925257473979*^9, 
   3.7919253465779333`*^9, 3.791925415545993*^9, 3.791925538329486*^9, 
   3.791925601252158*^9, {3.7919258208123755`*^9, 3.791925846181349*^9}, {
   3.7919258965132446`*^9, 3.791925926459304*^9}, {3.791926014071001*^9, 
   3.7919260175701747`*^9}, 3.7919266484290524`*^9, {3.7919272055886946`*^9, 
   3.791927235331627*^9}, {3.7919276582332497`*^9, 3.7919277101428995`*^9}, {
   3.7919283378467164`*^9, 3.7919283439703007`*^9}, 3.791928389264398*^9, 
   3.7919411413389997`*^9, 3.791941230396061*^9, 3.7919430979993715`*^9, 
   3.7919455907781906`*^9, 3.7919456413443985`*^9, 3.791945710086*^9, {
   3.791946022624746*^9, 3.791946071628796*^9}, 3.7919462750182886`*^9, {
   3.7919463468763237`*^9, 3.791946348454059*^9}, {3.7919485149966345`*^9, 
   3.7919485152934113`*^9}, 3.7921427775327096`*^9, 3.7921428844917583`*^9, {
   3.792143012102148*^9, 3.7921430326754313`*^9}, {3.7921430729159*^9, 
   3.7921430957230043`*^9}, {3.792143137525601*^9, 3.7921431788751917`*^9}, 
   3.792143236720871*^9, {3.7921435062050405`*^9, 3.7921435066268454`*^9}, {
   3.792144999623945*^9, 3.792145021384448*^9}, {3.7921451021622267`*^9, 
   3.7921451511037264`*^9}, 3.792145185720539*^9, {3.7921455447136655`*^9, 
   3.792145545432212*^9}, {3.792184507470749*^9, 3.7921845096108675`*^9}, 
   3.792184641720213*^9, {3.792206627246333*^9, 3.792206627246333*^9}, 
   3.792206751388796*^9, {3.792206853864559*^9, 3.7922068746252704`*^9}, 
   3.7922073162553945`*^9, 3.7922074838563423`*^9, {3.792207902303128*^9, 
   3.7922079240167284`*^9}, 3.792210628560286*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709171055946`*^9, 3.7922709214014473`*^9}, 
   3.7922710012262707`*^9, 3.7922710487775407`*^9, {3.7922714048807282`*^9, 
   3.792271416690432*^9}, {3.7922722543810005`*^9, 3.7922722888259625`*^9}, 
   3.7922726333057737`*^9, 3.792538656581356*^9, 3.79253893338968*^9, {
   3.79253897772618*^9, 3.792538997607256*^9}, {3.7925390932423153`*^9, 
   3.7925390962103596`*^9}, 3.792539159820304*^9, 3.792539240269972*^9, {
   3.7925532546452465`*^9, 3.7925533205046535`*^9}, {3.792553601937978*^9, 
   3.7925536273538704`*^9}, 3.79255397433422*^9, 3.7934110830440025`*^9, 
   3.8025467812543383`*^9, 3.8025468240567527`*^9, 3.8025528269104867`*^9, 
   3.802553052279233*^9, 3.802553090613947*^9, {3.802553138758854*^9, 
   3.802553139914831*^9}, {3.8025532126007967`*^9, 3.802553250295064*^9}, {
   3.802553594834815*^9, 3.8025536101749134`*^9}, {3.8025798116085243`*^9, 
   3.8025798132175207`*^9}, 3.802579945624563*^9, 3.802582701183984*^9, 
   3.807854563419881*^9, 3.807854694546463*^9, {3.8078547295149803`*^9, 
   3.8078547561408234`*^9}, {3.8078547919860497`*^9, 3.8078548304791474`*^9}, 
   3.8078548606684666`*^9, 3.807855083466024*^9, 3.816906053582398*^9, 
   3.8169062224342117`*^9, {3.8169062988381157`*^9, 3.8169063060864477`*^9}, 
   3.8169064065628595`*^9, 3.816906461050069*^9, {3.8169064993379393`*^9, 
   3.8169065035244703`*^9}, 3.8169065362667856`*^9, 3.8169065845523252`*^9, 
   3.816906745967521*^9, 3.816906908810424*^9, 3.816911860153344*^9, {
   3.8208065344321394`*^9, 3.8208065372752233`*^9}, {3.8208066098049192`*^9, 
   3.820806629253437*^9}, {3.8208067246527057`*^9, 3.820806757035666*^9}, 
   3.820806846764411*^9, 3.820806898986417*^9, {3.8208069817158995`*^9, 
   3.8208069962436466`*^9}, 3.8208070567761927`*^9, 3.8208071646412573`*^9, {
   3.827874604510014*^9, 3.8278746309881845`*^9}, 3.8282861305022345`*^9, {
   3.8282861822244864`*^9, 3.8282862225431395`*^9}, 3.8282862526298304`*^9, 
   3.8282862842161703`*^9, 3.828286431179902*^9, 3.8282865552758007`*^9, 
   3.8288490182376804`*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571656713667`*^9, 3.8482572003506775`*^9}, 3.848257241247275*^9, 
   3.848259231776729*^9, 3.848259267571465*^9, 3.848259344803232*^9, 
   3.848259673414655*^9, {3.848259861051252*^9, 3.848259867143531*^9}, {
   3.848259941470792*^9, 3.8482599439389577`*^9}, 3.8482600898263903`*^9, 
   3.848260640619811*^9, 3.8482608256478395`*^9, {3.8482609065250673`*^9, 
   3.848260907681044*^9}, {3.8547617639785867`*^9, 3.8547617639785867`*^9}, 
   3.854761809702217*^9, {3.854761942224519*^9, 3.8547619519097843`*^9}, {
   3.8547622351085224`*^9, 3.854762249654128*^9}, 3.854762371152464*^9, 
   3.8547635232989454`*^9, 3.8831684232624483`*^9, 3.8831685493113613`*^9, 
   3.883168591832553*^9, {3.883169010827317*^9, 3.883169014857577*^9}, 
   3.883169424066017*^9, {3.8831694760850053`*^9, 3.8831694856764994`*^9}, 
   3.883170656625969*^9, 3.8831708592182693`*^9, {3.9565290756336536`*^9, 
   3.9565290756336536`*^9}, 3.956529278342761*^9, 3.9565293333611*^9, {
   3.956529367509301*^9, 3.9565293704148693`*^9}, 3.9565294729845495`*^9, 
   3.9565295110113583`*^9, {3.956529552879578*^9, 3.956529563252109*^9}, 
   3.9565298355156817`*^9, 3.9565299092171383`*^9, {3.95653017492978*^9, 
   3.9565301806784286`*^9}, 3.956530444152749*^9, 3.9568201600818815`*^9, 
   3.956820221942359*^9, 3.956820570541728*^9, {3.956820725036728*^9, 
   3.956820732222542*^9}, 3.956821498444167*^9, 3.956821574035771*^9, {
   3.9568216691228685`*^9, 3.956821670966181*^9}, {3.9568217221103945`*^9, 
   3.956821726406296*^9}, 3.956821763819358*^9, 3.9568220393953114`*^9, 
   3.956822225679756*^9, 3.9568229608685093`*^9, {3.956825212084016*^9, 
   3.956825212224614*^9}}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0360.png\>\"", ",", "ip3dConfHypergeomFE1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.5339551753718605`*^9, 3.5339551977422996`*^9}, 
   3.5470088994684477`*^9, 3.5470089727417765`*^9, {3.5501987561524305`*^9, 
   3.55019875626163*^9}, 3.5501988411413794`*^9, {3.550469316159321*^9, 
   3.550469316393321*^9}, {3.5531142826767282`*^9, 3.5531142878403373`*^9}, 
   3.553114589410067*^9, 3.5531850735502143`*^9, 3.5531852580361385`*^9, 
   3.553190088148943*^9, 3.5531901617342725`*^9, 3.553190880875136*^9, {
   3.553190965255684*^9, 3.5531909657236853`*^9}, {3.553213796837209*^9, 
   3.5532138090832305`*^9}, {3.553214132081798*^9, 3.5532141604270477`*^9}, {
   3.55638959965485*^9, 3.5563895998420506`*^9}, 3.5563898856657524`*^9, {
   3.732581228351179*^9, 3.73258122874118*^9}, 3.7326535161424675`*^9, {
   3.732659131075533*^9, 3.7326591312627335`*^9}, 3.7326593484475155`*^9, 
   3.7402167509844255`*^9, 3.740218243403057*^9, 3.74021899790279*^9, 
   3.740778626643299*^9, {3.740780616519998*^9, 3.7407806166603985`*^9}, 
   3.7407823179717164`*^9, {3.740795712629077*^9, 3.7407957267315016`*^9}, 
   3.7411140764375086`*^9, {3.741114125515195*^9, 3.741114125671195*^9}, 
   3.741166734985035*^9, {3.741166859442054*^9, 3.7411668600660543`*^9}, {
   3.741421137522071*^9, 3.741421137662471*^9}, 3.7446637165064435`*^9, 
   3.7446643950296354`*^9, 3.7446656128001237`*^9, {3.7446659247070713`*^9, 
   3.7446659248786716`*^9}, 3.7452127427798734`*^9, {3.7452127929651613`*^9, 
   3.745212793152362*^9}, 3.7452152142298145`*^9, 3.7452153921565275`*^9, 
   3.7460520052775435`*^9, {3.746052046134015*^9, 3.746052046851617*^9}, 
   3.74605511521301*^9, 3.7469914820784883`*^9, {3.746991523184561*^9, 
   3.74699155112421*^9}, 3.746991670152419*^9, 3.748111192864156*^9, {
   3.748111336868009*^9, 3.7481113370708094`*^9}, 3.748112636022691*^9, 
   3.748113214284507*^9, {3.7507168278133755`*^9, 3.7507168307305803`*^9}, 
   3.7507169297439537`*^9, 3.7509079022215652`*^9, {3.750907940301232*^9, 
   3.7509079404728317`*^9}, 3.7509082696334105`*^9, 3.751350024917858*^9, 
   3.7513500920291758`*^9, {3.7513503405844126`*^9, 3.751350340787213*^9}, 
   3.7514002188533993`*^9, {3.7550496972606583`*^9, 3.7550496974946585`*^9}, {
   3.75504978959722*^9, 3.7550497905488214`*^9}, 3.755049981976758*^9, 
   3.762283559846346*^9, {3.762283605102025*^9, 3.762283605258025*^9}, 
   3.7622837044741993`*^9, 3.764280957785819*^9, 3.7642809971446877`*^9, {
   3.7642810687488136`*^9, 3.764281091244053*^9}, {3.764281218056676*^9, 
   3.764281218197076*^9}, 3.764281300721221*^9, 3.76429146773833*^9, 
   3.7642915623056955`*^9, 3.7646644254533424`*^9, {3.764664539785943*^9, 
   3.7646645399731436`*^9}, {3.7648873980398936`*^9, 3.7648873981958942`*^9}, 
   3.764887973290904*^9, {3.764889416149441*^9, 3.7648894163366413`*^9}, {
   3.7650602413440895`*^9, 3.76506024151569*^9}, 3.765060791461856*^9, 
   3.765087677377597*^9, {3.765170815548583*^9, 3.7651708157513833`*^9}, 
   3.7651708746726866`*^9, 3.765258911924426*^9, {3.765259059017085*^9, 
   3.765259059188685*^9}, 3.766219554353852*^9, {3.766219588096711*^9, 
   3.766219588315111*^9}, 3.766219677048067*^9, 3.7662202121290073`*^9, 
   3.7664771999078894`*^9, 3.766477339294134*^9, 3.7664774867923937`*^9, 
   3.766477573575346*^9, {3.76661193684249*^9, 3.7666119369516907`*^9}, {
   3.767393932285303*^9, 3.7673939324413033`*^9}, 3.7688458990388994`*^9, 
   3.768845992139863*^9, 3.7688461103100705`*^9, 3.7919252574896*^9, 
   3.791926049453236*^9, {3.7919260861008263`*^9, 3.791926086913168*^9}, 
   3.791941139339487*^9, 3.7919412617480307`*^9, {3.791945592480884*^9, 
   3.7919456060870748`*^9}, 3.7921427775483007`*^9, {3.7921442451353717`*^9, 
   3.792144245338449*^9}, 3.792145001857826*^9, {3.792145054236045*^9, 
   3.7921450544235*^9}, 3.792206627246333*^9, {3.792208155180749*^9, 
   3.7922081559774384`*^9}, 3.7922705977593207`*^9, {3.7922707237138777`*^9, 
   3.792270723791984*^9}, 3.79253865659698*^9, 3.792554032117412*^9, 
   3.8025468267904854`*^9, {3.802546894868189*^9, 3.802546913582498*^9}, 
   3.8025516394640093`*^9, {3.8025798091715994`*^9, 3.802579817638352*^9}, 
   3.8078544431792603`*^9, {3.8078544925433044`*^9, 3.8078544933671336`*^9}, 
   3.807854566519637*^9, 3.816906057737702*^9, 3.816906822971233*^9, 
   3.8169068639616127`*^9, 3.8208064318782806`*^9, {3.8208064621211166`*^9, 
   3.820806462214844*^9}, 3.820806541039958*^9, {3.8278746045256357`*^9, 
   3.8278746309881845`*^9}, 3.827874859287332*^9, {3.827874908775693*^9, 
   3.827874908963181*^9}, 3.828286648410184*^9, 3.8482570386700907`*^9, 
   3.8482570746303196`*^9, 3.848257124337367*^9, 3.854761763994209*^9, {
   3.8547618395248256`*^9, 3.854761864503364*^9}, {3.883168591832553*^9, 
   3.8831686183106723`*^9}, {3.883168654880164*^9, 3.8831686550051346`*^9}, 
   3.956529075649271*^9, {3.9565292024855556`*^9, 3.95652922354312*^9}, 
   3.956820221942359*^9, 3.956820306797447*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"frpConfHypergeomFE1", "=", "\[IndentingNewLine]", 
  RowBox[{"FundamentalRegionPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{"2.4", ",", "0.7", ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "10"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"320", ",", "720"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "16"}], ",", "90"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
           RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", "None"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "210"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.530344234110747*^9, 3.530344269600809*^9, {3.53395684314399*^9, 
   3.5339568911608744`*^9}, {3.533956924529333*^9, 3.533956959972595*^9}, {
   3.533957001359468*^9, 3.5339570248843093`*^9}, {3.5346482317806273`*^9, 
   3.5346482369130363`*^9}, {3.5346484132401457`*^9, 3.534648422927763*^9}, {
   3.534648600908476*^9, 3.534648602874079*^9}, 3.534710001277398*^9, {
   3.534710275763481*^9, 3.5347102880095024`*^9}, {3.534710723484267*^9, 
   3.5347107275246744`*^9}, {3.534710781017168*^9, 3.534710781219969*^9}, {
   3.5347108477228856`*^9, 3.5347108501564903`*^9}, {3.536464399328986*^9, 
   3.5364644013413897`*^9}, 3.5470089850033984`*^9, {3.547009186867753*^9, 
   3.547009193606965*^9}, {3.5470101014513597`*^9, 3.5470101345858183`*^9}, 
   3.5470103852662587`*^9, 3.5501988466325893`*^9, 3.550199068246578*^9, {
   3.5502084668036313`*^9, 3.5502084670064316`*^9}, 3.550208582867835*^9, 
   3.550210551794093*^9, 3.5502106958603463`*^9, {3.550798929203307*^9, 
   3.5507989293125067`*^9}, 3.5531145282735596`*^9, 3.55311459660168*^9, 
   3.553115153538258*^9, 3.553115190603923*^9, 3.553115426549945*^9, 
   3.5531841290621552`*^9, 3.553184841780607*^9, 3.553185595402331*^9, {
   3.5642903301826057`*^9, 3.5642903301826057`*^9}, {3.564291282969879*^9, 
   3.56429128880429*^9}, 3.564291394822076*^9, 3.5645701814958963`*^9, 
   3.564570242882004*^9, {3.564570442328354*^9, 3.5645704448087587`*^9}, 
   3.5646312482712297`*^9, 3.564632058343053*^9, {3.5646323584975805`*^9, 
   3.5646323647687917`*^9}, 3.564706563514888*^9, {3.5647069832336254`*^9, 
   3.564706991033639*^9}, {3.564989542386684*^9, 3.56498954572509*^9}, {
   3.5651175773891916`*^9, 3.565117582833601*^9}, {3.567283577864339*^9, 
   3.5672835875051556`*^9}, {3.5672836659264936`*^9, 
   3.5672836766593122`*^9}, {3.567283716548582*^9, 3.567283718576586*^9}, 
   3.567283973247033*^9, 3.56728425586953*^9, {3.5672842997836075`*^9, 
   3.567284320703244*^9}, 3.5672843556005054`*^9, 3.5677493102314744`*^9, 
   3.56780279067764*^9, 3.567802890923416*^9, {3.567802966739549*^9, 
   3.5678029668955493`*^9}, 3.5681976926063223`*^9, 3.5681977453968153`*^9, {
   3.568197813974536*^9, 3.568197826126957*^9}, {3.5681978838782587`*^9, 
   3.568197918401119*^9}, 3.5700755786291265`*^9, {3.5700756190487976`*^9, 
   3.5700756257724094`*^9}, {3.570086895267579*^9, 3.570086895443589*^9}, 
   3.570087027747156*^9, 3.5700870928118777`*^9, 3.5700872352950277`*^9, {
   3.570096246297722*^9, 3.5700962494177275`*^9}, 3.570606665466712*^9, 
   3.573604837639526*^9, 3.5736049030816407`*^9, 3.5736049498193226`*^9, {
   3.5736050854147615`*^9, 3.573605109750804*^9}, 3.5736051427448616`*^9, {
   3.5736052053321714`*^9, 3.573605205519372*^9}, {3.573605408179328*^9, 
   3.573605433950573*^9}, 3.5736058570857162`*^9, 3.5736059335570507`*^9, 
   3.573605964039504*^9, 3.5736059994827666`*^9, 3.5736060984805403`*^9, {
   3.573606625978094*^9, 3.5736066285832987`*^9}, 3.5736158211856375`*^9, 
   3.5736160693318305`*^9, 3.5736161223258615`*^9, {3.573616182105281*^9, 
   3.573616182321293*^9}, 3.573616236132371*^9, 3.5736164232410727`*^9, {
   3.573692298777257*^9, 3.5736923146424847`*^9}, {3.574885935637336*^9, 
   3.5748859559173717`*^9}, {3.574886059891554*^9, 3.574886060063154*^9}, 
   3.5748861763301587`*^9, 3.57488628534315*^9, 3.575772379966265*^9, {
   3.5757724207015953`*^9, 3.5757725117098007`*^9}, {3.575772591741378*^9, 
   3.5757725927734375`*^9}, {3.575772672229982*^9, 3.5757726811024895`*^9}, 
   3.5757893795025835`*^9, {3.5759741275789194`*^9, 3.5759741492005577`*^9}, 
   3.5759742049082556`*^9, 3.576873260313571*^9, {3.5768733266760874`*^9, 
   3.5768733636481524`*^9}, {3.576961566809566*^9, 3.576961566965566*^9}, 
   3.5778715430075555`*^9, {3.577871696168316*^9, 3.5778716991834884`*^9}, {
   3.577871760471994*^9, 3.5778717880315704`*^9}, 3.5778726548461494`*^9, 
   3.577996394467312*^9, {3.577996527223545*^9, 3.5779965332763557`*^9}, 
   3.5780020367826004`*^9, {3.592182738877136*^9, 3.592182738877136*^9}, 
   3.592182948245104*^9, 3.592183023967637*^9, {3.5921894148308616`*^9, 
   3.5921894250800796`*^9}, 3.592189468058155*^9, 3.59218951063063*^9, {
   3.5921897614790707`*^9, 3.5921897687174835`*^9}, {3.5921898718180647`*^9, 
   3.5921898746416693`*^9}, 3.592190089781647*^9, 3.599383290830182*^9, 
   3.606352387733818*^9, {3.6063536447692275`*^9, 3.6063536521324406`*^9}, {
   3.6063536981837215`*^9, 3.606353720959761*^9}, {3.6063540035186653`*^9, 
   3.60635401782389*^9}, {3.606354435187023*^9, 3.606354443579838*^9}, {
   3.606355512883435*^9, 3.6063555243806553`*^9}, {3.606355667978907*^9, 
   3.606355694748554*^9}, {3.6063559545934114`*^9, 3.60635597637105*^9}, 
   3.6063566455526247`*^9, 3.606364112430215*^9, {3.606364199790369*^9, 
   3.606364203237975*^9}, 3.6063646197275066`*^9, 3.606367676083275*^9, {
   3.625306705256344*^9, 3.6253067345531955`*^9}, {3.6253071577203393`*^9, 
   3.625307191275998*^9}, {3.6253072256584587`*^9, 3.625307230572467*^9}, 
   3.625307268620934*^9, {3.625307476549307*^9, 3.6253074769705076`*^9}, {
   3.6253081892637596`*^9, 3.6253082416486516`*^9}, 3.6253530322619123`*^9, 
   3.6253833808227205`*^9, 3.6253834171083846`*^9, 3.6291872118269997`*^9, {
   3.629187263494291*^9, 3.629187284616728*^9}, 3.6291873266120014`*^9, 
   3.629187811262854*^9, 3.629187845489314*^9, 3.6291893763632035`*^9, {
   3.6292328386751413`*^9, 3.6292328506403627`*^9}, 3.6294129869649906`*^9, {
   3.629681940868216*^9, 3.629681967840663*^9}, {3.629683072302611*^9, 
   3.629683104204667*^9}, 3.6296834256744313`*^9, 3.62968375522501*^9, 
   3.6296908987102036`*^9, 3.630130105748337*^9, 3.6301868181132655`*^9, {
   3.630191355032058*^9, 3.6301913594624653`*^9}, 3.6301916306065416`*^9, {
   3.6301917699615865`*^9, 3.63019186320295*^9}, {3.630192661908753*^9, 
   3.6301926650911584`*^9}, {3.6301964589726305`*^9, 3.6301964616870356`*^9}, 
   3.630397911894512*^9, 3.631494715345451*^9, {3.631494897830179*^9, 
   3.6314948980173793`*^9}, 3.6325489741749687`*^9, 3.632549352439234*^9, 
   3.632549606008894*^9, {3.6325498031224484`*^9, 3.6325498272824984`*^9}, 
   3.6325498689969716`*^9, 3.632603972588211*^9, {3.6326052512664576`*^9, 
   3.63260525814607*^9}, 3.6326054984956923`*^9, 3.632789700000079*^9, 
   3.632789744647358*^9, {3.632789801166257*^9, 3.632789811633875*^9}, 
   3.6327900076794195`*^9, {3.6327981115517917`*^9, 3.632798133781831*^9}, 
   3.632798223201188*^9, {3.6328077370497065`*^9, 3.632807759903747*^9}, 
   3.6328139472210455`*^9, 3.632814030665592*^9, {3.6328142522895823`*^9, 
   3.6328142524611826`*^9}, {3.632862843129942*^9, 3.632862843800743*^9}, 
   3.63286308115516*^9, 3.6328903786025143`*^9, {3.634503967294235*^9, 
   3.6345039716310434`*^9}, {3.634505033567916*^9, 3.6345050472023396`*^9}, {
   3.6345052904809732`*^9, 3.6345052910893745`*^9}, {3.634505400581773*^9, 
   3.634505441906245*^9}, {3.634505494244337*^9, 3.6345055070207596`*^9}, {
   3.6345055797168875`*^9, 3.6345055799040875`*^9}, 3.6345562254439487`*^9, {
   3.6345563039276867`*^9, 3.6345563048948884`*^9}, 3.634556840334629*^9, {
   3.636074869723259*^9, 3.6360748731240654`*^9}, 3.6360754084218063`*^9, {
   3.6360755439392443`*^9, 3.636075558915271*^9}, {3.636075874067024*^9, 
   3.6360758917886553`*^9}, {3.6364953559316864`*^9, 3.636495366508505*^9}, {
   3.6364954773934994`*^9, 3.636495502852744*^9}, {3.636495534396*^9, 
   3.6364955371572046`*^9}, {3.6364955872176924`*^9, 3.63649567827066*^9}, 
   3.636495724504749*^9, {3.636495894244254*^9, 3.6364959362083282`*^9}, {
   3.6364963754739*^9, 3.636496380231908*^9}, {3.636497028007847*^9, 
   3.6364970357610607`*^9}, {3.6367624922783546`*^9, 
   3.6367624954763603`*^9}, {3.6367923982578783`*^9, 3.636792403624288*^9}, 
   3.725592414137775*^9, 3.72559253645759*^9, {3.725595004057525*^9, 
   3.725595014041543*^9}, 3.7255952212879066`*^9, 3.7255953656817603`*^9, 
   3.7255956160982013`*^9, {3.725595650901862*^9, 3.7255956517442636`*^9}, {
   3.725595707529962*^9, 3.7255957181379805`*^9}, {3.7255957501492367`*^9, 
   3.7255957539400434`*^9}, {3.7255961085130663`*^9, 3.72559611623508*^9}, 
   3.725596322436242*^9, 3.7255964148976045`*^9, {3.7257712777690277`*^9, 
   3.7257712801558323`*^9}, 3.725773155528726*^9, 3.725774260463067*^9, {
   3.7257742995099354`*^9, 3.7257743102739544`*^9}, 3.725774372830064*^9, 
   3.7257745020094986`*^9, 3.7258490354189854`*^9, 3.72585211170679*^9, 
   3.7258523136023445`*^9, 3.725852357064021*^9, 3.725852412709319*^9, 
   3.725852690077806*^9, {3.7258529112549944`*^9, 3.725852914297*^9}, 
   3.725866558776852*^9, 3.726913461475872*^9, {3.7269135067471514`*^9, 
   3.7269135067471514`*^9}, 3.7269135736712694`*^9, 3.7269142332092276`*^9, 
   3.726914379943085*^9, {3.72691444512*^9, 3.72691444551*^9}, 
   3.726914522230935*^9, {3.7269150197170105`*^9, 3.726915029623028*^9}, 
   3.7269154806118207`*^9, 3.7269429541638784`*^9, 3.726943055174056*^9, 
   3.7269527416378713`*^9, {3.7325816271502795`*^9, 3.73258171281003*^9}, {
   3.732658455138345*^9, 3.7326584615967565`*^9}, 3.7326589054523363`*^9, 
   3.7326593484475155`*^9, 3.732665438975348*^9, {3.7402181674777236`*^9, 
   3.740218192921368*^9}, 3.7402182516554713`*^9, 3.7402183778596935`*^9, {
   3.7402184897074966`*^9, 3.7402184899102974`*^9}, 3.740218703693073*^9, 
   3.740219316174549*^9, 3.740220725664626*^9, 3.7406235299785748`*^9, 
   3.7407786300441055`*^9, {3.7407787374658937`*^9, 3.7407787515059185`*^9}, 
   3.7407792597116137`*^9, {3.740779291410869*^9, 3.74077929150447*^9}, {
   3.7407794435579367`*^9, 3.7407794537603545`*^9}, {3.740779489359617*^9, 
   3.7407794895936174`*^9}, {3.740779670623536*^9, 3.7407796794843516`*^9}, 
   3.740780547224676*^9, 3.740780580078334*^9, {3.7407807829566903`*^9, 
   3.740780802675125*^9}, 3.7407824785895987`*^9, {3.740783120387927*^9, 
   3.7407831238823338`*^9}, 3.740784281084571*^9, 3.7407843527561016`*^9, 
   3.7407847831226892`*^9, 3.740792340872752*^9, 3.740795723424296*^9, 
   3.7407958523585224`*^9, 3.7407962560248313`*^9, 3.740796299814108*^9, 
   3.740796868840708*^9, 3.7407969075287757`*^9, {3.7411140798071146`*^9, 
   3.7411140827087193`*^9}, 3.7411141905985093`*^9, {3.7411142267125726`*^9, 
   3.7411142268685727`*^9}, {3.741114330047154*^9, 3.7411143512943916`*^9}, {
   3.741114411151696*^9, 3.741114418093709*^9}, 3.7411667320210295`*^9, 
   3.7411668087419643`*^9, 3.741202221929366*^9, 3.741892837970529*^9, 
   3.7446637237292566`*^9, 3.744664188516473*^9, 3.7446656128157234`*^9, 
   3.7446656519561925`*^9, 3.744742920198707*^9, 3.744748993426978*^9, 
   3.744875562242749*^9, 3.7452127485518837`*^9, {3.7452134494767146`*^9, 
   3.7452134887263837`*^9}, 3.7452135890501595`*^9, 3.7452136909027386`*^9, {
   3.745213776375289*^9, 3.745213824891374*^9}, {3.7452153796921053`*^9, 
   3.7452153895513225`*^9}, {3.745215679480633*^9, 3.7452156795430326`*^9}, {
   3.7452158443729224`*^9, 3.7452158470717273`*^9}, 3.745216263249258*^9, 
   3.745220775675985*^9, 3.74605200870955*^9, {3.746054459278658*^9, 
   3.746054461899462*^9}, {3.746054502833934*^9, 3.7460545099319468`*^9}, {
   3.7460545513812194`*^9, 3.746054580834071*^9}, 3.746054715181507*^9, {
   3.746055056728507*^9, 3.746055078334545*^9}, {3.7460696676769714`*^9, 
   3.746069675196185*^9}, {3.746069717519059*^9, 3.7460697568623285`*^9}, {
   3.746069787937583*^9, 3.74606981489443*^9}, 3.746073742165717*^9, 
   3.7460738199942536`*^9, 3.74607396574531*^9, {3.7460739981621666`*^9, 
   3.7460740214218073`*^9}, {3.7460741612292533`*^9, 3.7460741660964613`*^9}, 
   3.7460742930026846`*^9, 3.7469916783892336`*^9, {3.746995596376917*^9, 
   3.7469956449086018`*^9}, 3.746995874717006*^9, {3.746995951484741*^9, 
   3.7469959562115493`*^9}, {3.7469960042752333`*^9, 
   3.7469960100160437`*^9}, {3.7470008209349375`*^9, 3.747000823181341*^9}, {
   3.747000889419058*^9, 3.7470008910414605`*^9}, {3.7470280589399815`*^9, 
   3.7470280614983854`*^9}, {3.748111197232164*^9, 3.7481112317394247`*^9}, 
   3.74811147967066*^9, 3.7481115205271316`*^9, 3.748111692642234*^9, 
   3.7481117874748*^9, 3.748112631498683*^9, 3.748112775284136*^9, 
   3.7481129517516456`*^9, {3.748113151322796*^9, 3.7481131579684076`*^9}, 
   3.7481148652730074`*^9, 3.748152386065356*^9, 3.7481567738382626`*^9, 
   3.749668436049493*^9, 3.75071693891677*^9, 3.7507175127325783`*^9, 
   3.7507180095666513`*^9, 3.7507180789087734`*^9, 3.7507182048633947`*^9, 
   3.7507183299756145`*^9, {3.750719880875539*^9, 3.750719881031539*^9}, 
   3.750720705694188*^9, 3.7507440057557216`*^9, {3.750744086719864*^9, 
   3.750744089496669*^9}, 3.7509082696490107`*^9, 3.7509083249043074`*^9, 
   3.750911286246544*^9, 3.7509118911532063`*^9, 3.7509121115503936`*^9, {
   3.750923632836231*^9, 3.750923632961032*^9}, 3.750925073460763*^9, 
   3.750927718913814*^9, 3.7513499450769176`*^9, 3.7513500249334583`*^9, 
   3.751350205394575*^9, {3.751357124693128*^9, 3.751357125535529*^9}, 
   3.7513572227785015`*^9, {3.7513577543338346`*^9, 3.7513577545366354`*^9}, {
   3.7514075994397964`*^9, 3.7514076315758533`*^9}, 3.755049981992358*^9, 
   3.7550500823161345`*^9, 3.7550501621414747`*^9, {3.755050424627536*^9, 
   3.75505042743554*^9}, 3.7550509452316504`*^9, {3.7550519417295938`*^9, 
   3.755051975534853*^9}, 3.755137950815219*^9, {3.755138029314557*^9, 
   3.755138038986574*^9}, 3.755138086785058*^9, {3.755138188762437*^9, 
   3.7551382198688917`*^9}, 3.755138327743081*^9, {3.7551385822731285`*^9, 
   3.7551385983567567`*^9}, {3.7551386797264996`*^9, 3.755138682924505*^9}, {
   3.755138886446863*^9, 3.7551388934044757`*^9}, 3.75514146393878*^9, 
   3.7551414955444355`*^9, 3.755142322019229*^9, 3.755143438106188*^9, 
   3.755147618487777*^9, 3.7552236306785617`*^9, 3.755223735116352*^9, {
   3.755225733931464*^9, 3.7552257365054693`*^9}, {3.755227512081214*^9, 
   3.755227512237214*^9}, 3.7552279693180175`*^9, 3.7642903496367607`*^9, 
   3.7642905384454937`*^9, {3.764290573888756*^9, 3.7642906052136106`*^9}, 
   3.764290664977316*^9, {3.7642906962553706`*^9, 3.7642907377670436`*^9}, 
   3.7642907697626996`*^9, {3.7642908862013044`*^9, 3.7642908919733143`*^9}, {
   3.764290988459484*^9, 3.7642909895202856`*^9}, 3.7642916178573933`*^9, 
   3.7642946900651903`*^9, 3.764304233178358*^9, 3.764315634831588*^9, 
   3.7643178571376925`*^9, 3.7643199679870043`*^9, 3.7646643825688667`*^9, 
   3.7646644254533424`*^9, {3.7646670587823772`*^9, 3.7646670614031816`*^9}, {
   3.7646689741957426`*^9, 3.7646689743361425`*^9}, 3.7648879733065042`*^9, 
   3.7648880095453677`*^9, 3.764888905544944*^9, {3.7648904306286244`*^9, 
   3.764890430784625*^9}, 3.764890639856192*^9, 3.7648920316777287`*^9, 
   3.7648920799130135`*^9, {3.7649026496400437`*^9, 3.764902649811644*^9}, 
   3.765060795861064*^9, 3.765170874688287*^9, 3.7651709275255795`*^9, 
   3.7651715934707565`*^9, 3.765171678553306*^9, 3.7651720873988247`*^9, 
   3.7652588609279366`*^9, 3.7652589119400263`*^9, {3.7652678534549417`*^9, 
   3.765267853720142*^9}, 3.766219677048067*^9, 3.766219733644967*^9, 
   3.7662202150930123`*^9, 3.7662231492289677`*^9, 3.7662232546071525`*^9, 
   3.7664261773697233`*^9, {3.7664771999234896`*^9, 3.766477221467128*^9}, {
   3.7664774867923937`*^9, 3.7664775002552176`*^9}, {3.7688458990388994`*^9, 
   3.7688459132349243`*^9}, 3.7688464502450686`*^9, 3.7688469138338833`*^9, 
   3.7919252574896*^9, 3.7919253465779333`*^9, {3.791925415764722*^9, 
   3.7919254377907343`*^9}, {3.791925604735676*^9, 3.791925624980929*^9}, 
   3.791925707745304*^9, 3.791925763091635*^9, {3.791925911291008*^9, 
   3.7919259140403547`*^9}, {3.7919260222877755`*^9, 3.7919260262243795`*^9}, 
   3.7919263244810195`*^9, 3.7919272129150743`*^9, 3.7919273025813866`*^9, 
   3.79194113621521*^9, 3.791941232926713*^9, {3.791941514157159*^9, 
   3.7919415143290224`*^9}, 3.791943103216889*^9, 3.791945596183156*^9, 
   3.7919456441249638`*^9, 3.791946082173215*^9, 3.7919462651924844`*^9, 
   3.7921427775483007`*^9, 3.7921428897561445`*^9, {3.7921430152576857`*^9, 
   3.7921430359090414`*^9}, 3.7921430673703427`*^9, {3.792143141259096*^9, 
   3.7921431417121143`*^9}, 3.792143242125839*^9, 3.792143486850278*^9, {
   3.7921450052007465`*^9, 3.792145013042673*^9}, {3.7921451058956823`*^9, 
   3.7921451214857616`*^9}, 3.7921455314668036`*^9, {3.792206627246333*^9, 
   3.792206627246333*^9}, 3.792206754231901*^9, 3.79220685052157*^9, 
   3.7922078842917633`*^9, {3.7922705977593207`*^9, 3.7922705977593207`*^9}, {
   3.7922709118099704`*^9, 3.792270911903698*^9}, 3.792271385291582*^9, 
   3.792272246914014*^9, 3.79253865659698*^9, 3.7925389383292637`*^9, {
   3.79253897772618*^9, 3.7925390027310505`*^9}, 3.792539084603735*^9, 
   3.792539165209653*^9, {3.7925532584724584`*^9, 3.792553265876953*^9}, {
   3.7925536738897276`*^9, 3.7925536950096927`*^9}, 3.792553901929451*^9, 
   3.7925547774031987`*^9, 3.7926564191426325`*^9, 3.802546784503578*^9, 
   3.8025468351166477`*^9, {3.802547157478155*^9, 3.8025471596963935`*^9}, 
   3.8025530393291664`*^9, {3.802553145023003*^9, 3.8025531542395735`*^9}, {
   3.8025532156626034`*^9, 3.802553248326777*^9}, {3.8025534886879206`*^9, 
   3.802553504246724*^9}, {3.8025797911758394`*^9, 3.8025798028293123`*^9}, {
   3.8025800334054585`*^9, 3.802580033577258*^9}, 3.802582705776685*^9, 
   3.807854574938098*^9, 3.8078546986654563`*^9, {3.8078547333297863`*^9, 
   3.8078547854564734`*^9}, 3.80785486835991*^9, 3.807855055961532*^9, 
   3.816906071203289*^9, 3.8169062277454643`*^9, {3.816906300915784*^9, 
   3.8169063034933043`*^9}, 3.8169064130613346`*^9, 3.816906495104565*^9, 
   3.816906610405632*^9, 3.816906749379136*^9, 3.816907241217867*^9, 
   3.8169118516709604`*^9, {3.8208065480383034`*^9, 3.8208065503971148`*^9}, {
   3.8208066149286785`*^9, 3.820806624051549*^9}, {3.8208067216221795`*^9, 
   3.8208067220908184`*^9}, 3.8208068322209473`*^9, 3.820807172858101*^9, {
   3.8278746045256357`*^9, 3.8278746309881845`*^9}, {3.8282860508815856`*^9, 
   3.8282860579267845`*^9}, {3.8282861859735947`*^9, 3.8282862018448706`*^9}, 
   3.828286468280572*^9, 3.828553587454216*^9, 3.8285574082753267`*^9, {
   3.8286362338967395`*^9, 3.828636255175177*^9}, 3.828637664454053*^9, 
   3.828718689983182*^9, {3.8482570386700907`*^9, 3.8482570386700907`*^9}, {
   3.8482571686237884`*^9, 3.848257192868057*^9}, {3.84825923472919*^9, 
   3.848259236681822*^9}, 3.848259612007312*^9, {3.8482597677280135`*^9, 
   3.848259771133461*^9}, {3.8482598468578053`*^9, 3.8482598497008877`*^9}, {
   3.848260094465921*^9, 3.8482601019797363`*^9}, {3.854761764009829*^9, 
   3.854761764009829*^9}, 3.854761812763962*^9, 3.8547619184957533`*^9, {
   3.85476213510832*^9, 3.8547621352801824`*^9}, {3.854762175741544*^9, 
   3.854762196820649*^9}, 3.854763397808587*^9, 3.854911091585896*^9, 
   3.883168549514434*^9, 3.8831685918481736`*^9, {3.8831693368284187`*^9, 
   3.8831693369690075`*^9}, 3.8831700820047045`*^9, {3.88326856715734*^9, 
   3.883268567688492*^9}, {3.956529075649271*^9, 3.956529075649271*^9}, 
   3.956529278561458*^9, 3.956529333579769*^9, 3.956529375257483*^9, {
   3.956529477764713*^9, 3.9565294832321777`*^9}, {3.95652970749885*^9, 
   3.9565297214487343`*^9}, {3.9565301959560966`*^9, 3.9565302258865724`*^9}, 
   3.956530334767271*^9, 3.9565304297655487`*^9, 3.956541561095746*^9, 
   3.9568201603005805`*^9, 3.956820221957981*^9, 3.956820573525411*^9, {
   3.9568207357373276`*^9, 3.9568207362840824`*^9}, 3.956821766287566*^9, {
   3.9568221233443604`*^9, 3.956822127608987*^9}, 3.9568223337169027`*^9, 
   3.9568224544069495`*^9, 3.9568229638521557`*^9, {3.9568252088347836`*^9, 
   3.9568252089753404`*^9}, 3.9569065581400766`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0370.png\>\"", ",", "frpConfHypergeomFE1", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.533955185636678*^9, 3.533955193530292*^9}, 
   3.5470089020736527`*^9, 3.5470089906974087`*^9, {3.5501987606920385`*^9, 
   3.5501987608792386`*^9}, 3.550198849300194*^9, {3.5504693214945307`*^9, 
   3.55046932160373*^9}, {3.5531142987603564`*^9, 3.55311430097556*^9}, 
   3.553114600798087*^9, 3.5531850697594075`*^9, 3.55318527036016*^9, 
   3.5531900910817485`*^9, 3.553190165072678*^9, 3.5531908750251255`*^9, {
   3.553190970122893*^9, 3.553190970310093*^9}, {3.5532137997388144`*^9, 
   3.5532138043876224`*^9}, {3.5532141363562055`*^9, 3.553214165434656*^9}, {
   3.556389606160061*^9, 3.5563896074548635`*^9}, 3.556389890454961*^9, {
   3.7325812332963877`*^9, 3.732581233717589*^9}, 3.7326535116184597`*^9, {
   3.7326591364731426`*^9, 3.732659136644743*^9}, 3.7326593484631157`*^9, 
   3.7402167509844255`*^9, 3.7402182539798756`*^9, 3.740219001927597*^9, 
   3.7407786321033087`*^9, {3.740780622260808*^9, 3.7407806224012084`*^9}, 
   3.740782321871723*^9, {3.7407957164042835`*^9, 3.740795721505492*^9}, 
   3.7411140854231243`*^9, {3.74111413420441*^9, 3.7411141344228106`*^9}, 
   3.741166727684222*^9, {3.7411668654792643`*^9, 3.741166865619664*^9}, 
   3.7414211246988482`*^9, 3.7446637267400618`*^9, 3.7446644002400446`*^9, 
   3.7446656128157234`*^9, {3.744665930744282*^9, 3.744665930884682*^9}, 
   3.7452127519526896`*^9, 3.7452127982691708`*^9, 3.7452152179426208`*^9, 
   3.7452153867901173`*^9, 3.7460520107999535`*^9, {3.7460520534036283`*^9, 
   3.74605205424603*^9}, 3.746055118879016*^9, 3.7469914856820946`*^9, {
   3.746991527770969*^9, 3.746991555866618*^9}, 3.7469916833032417`*^9, 
   3.7481112017873716`*^9, {3.7481113416104174`*^9, 3.7481113417820177`*^9}, 
   3.748112629455079*^9, 3.7481132179193125`*^9, {3.7507168447394047`*^9, 
   3.7507168472198095`*^9}, 3.7507169437995787`*^9, 3.7509079022215652`*^9, {
   3.75090794495004*^9, 3.75090794512164*^9}, 3.7509082696490107`*^9, 
   3.7513500249334583`*^9, 3.7513500920291758`*^9, {3.7513503492580276`*^9, 
   3.751350349445228*^9}, 3.7514002242042093`*^9, {3.755049692159449*^9, 
   3.7550496922998495`*^9}, {3.7550498033876443`*^9, 3.7550498039024453`*^9}, 
   3.755049981992358*^9, 3.762283566429557*^9, {3.762283611841237*^9, 
   3.7622836119660373`*^9}, 3.7622837156906195`*^9, 3.764280969439039*^9, 
   3.7642810018246965`*^9, {3.764281074411624*^9, 3.7642810945668592`*^9}, {
   3.764281227135892*^9, 3.7642812273854923`*^9}, 3.7642813042000275`*^9, 
   3.764291565768902*^9, 3.7646644254533424`*^9, {3.7646645461195545`*^9, 
   3.7646645463223543`*^9}, {3.7648874056839075`*^9, 3.7648874058399076`*^9}, 
   3.7648879733221045`*^9, {3.7648894222178516`*^9, 3.7648894224050517`*^9}, {
   3.7650602476465006`*^9, 3.765060247818101*^9}, 3.765060798138668*^9, 
   3.7650876836644077`*^9, {3.765170820041391*^9, 3.765170820322191*^9}, 
   3.765170874688287*^9, 3.7652589119400263`*^9, {3.765259071731107*^9, 
   3.7652590718091073`*^9}, {3.7662195948515224`*^9, 3.7662195957563243`*^9}, 
   3.766219677048067*^9, 3.766220217308216*^9, 3.7664771999234896`*^9, 
   3.7664773393097343`*^9, 3.766477486807994*^9, 3.766477573590946*^9, {
   3.7666119431449013`*^9, 3.7666119433165016`*^9}, {3.7673939377297125`*^9, 
   3.7673939378857126`*^9}, 3.7688458990388994`*^9, 3.768845992155463*^9, 
   3.7688461150368786`*^9, 3.7919252574896*^9, 3.791926052499424*^9, {
   3.791926095989151*^9, 3.791926096598382*^9}, 3.791941133887636*^9, 
   3.7919412657158723`*^9, {3.7919455983389053`*^9, 3.7919456033221006`*^9}, 
   3.7921427775483007`*^9, {3.792144252867916*^9, 3.7921442530085073`*^9}, 
   3.792145007731429*^9, 3.792145059016163*^9, 3.792206627246333*^9, {
   3.792208164803473*^9, 3.792208165553295*^9}, 3.7922705977593207`*^9, {
   3.7922707301029916`*^9, 3.7922707302904463`*^9}, 3.79253865659698*^9, 
   3.7925540406154003`*^9, 3.8025468380534554`*^9, {3.8025469017103243`*^9, 
   3.8025469097240615`*^9}, {3.8025516449002275`*^9, 3.802551645056441*^9}, {
   3.8025797876922874`*^9, 3.802579794206377*^9}, 3.8078544401712985`*^9, {
   3.8078545001470075`*^9, 3.807854500934877*^9}, 3.8078545785694313`*^9, 
   3.8169060743744335`*^9, 3.816906826079885*^9, 3.8169068668827724`*^9, 
   3.820806437814374*^9, {3.8208064682759457`*^9, 3.8208064684790215`*^9}, 
   3.820806553490138*^9, {3.8278746045256357`*^9, 3.8278746310038056`*^9}, 
   3.827874859287332*^9, {3.827874913149688*^9, 3.827874914102568*^9}, 
   3.828286652268653*^9, 3.8482570386857076`*^9, 3.848257074645941*^9, {
   3.84825712863323*^9, 3.8482571287582006`*^9}, 3.8547617640254436`*^9, {
   3.854761842820959*^9, 3.8547618694084587`*^9}, {3.8831685918481736`*^9, 
   3.8831686183106723`*^9}, {3.8831686600976796`*^9, 3.8831686602538943`*^9}, 
   3.9565290756648955`*^9, {3.9565292025011487`*^9, 3.956529227448423*^9}, 
   3.956820221957981*^9, 3.956820306797447*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ap3dConfHypergeomFE2", "=", "\[IndentingNewLine]", 
  RowBox[{"AbsArgPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"3", " ", "\[Pi]"}], ",", "4"}], "}"}]}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"-", "8"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0007", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0005", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.30"}], ",", 
       RowBox[{"-", "1.77"}], ",", "2.63"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
         RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
       "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.528619442909766*^9, 3.528619451910281*^9}, {
   3.5286214386949186`*^9, 3.5286214646354027`*^9}, {3.5286222532055063`*^9, 
   3.528622288166506*^9}, 3.52866506133381*^9, 3.5286651054974875`*^9, {
   3.5286651514707685`*^9, 3.528665155292775*^9}, {3.5287006732862062`*^9, 
   3.528700705625063*^9}, {3.5287008793313684`*^9, 3.5287008818741727`*^9}, {
   3.5287009125126266`*^9, 3.5287009144938297`*^9}, {3.5289198836377797`*^9, 
   3.5289199933371725`*^9}, {3.5289200401996546`*^9, 
   3.5289200576560855`*^9}, {3.5289201204305954`*^9, 
   3.5289201283242097`*^9}, {3.5289213102134857`*^9, 3.5289213711159925`*^9}, 
   3.5289214070272555`*^9, {3.52892258770053*^9, 3.528922633018609*^9}, {
   3.528922704669535*^9, 3.5289227124695487`*^9}, {3.5289237056920934`*^9, 
   3.528923718624516*^9}, 3.5289237912270436`*^9, {3.528923835453121*^9, 
   3.5289238359055223`*^9}, {3.52892390278284*^9, 3.5289239065580463`*^9}, 
   3.5289239438421116`*^9, {3.528923987787389*^9, 3.528924004978619*^9}, {
   3.5289240667547274`*^9, 3.528924087986365*^9}, {3.5289243401296077`*^9, 
   3.528924344294815*^9}, {3.5289245120575094`*^9, 3.5289245256919336`*^9}, {
   3.5289245779988256`*^9, 3.5289246058916745`*^9}, 3.5289246438465414`*^9, {
   3.5301781945730553`*^9, 3.530178289296421*^9}, {3.530178945963975*^9, 
   3.5301789486471796`*^9}, {3.5301820319841957`*^9, 3.530182109703532*^9}, {
   3.5339560194937434`*^9, 3.5339560600070143`*^9}, {3.5339561008634863`*^9, 
   3.53395611423271*^9}, {3.5339561603307905`*^9, 3.5339561646675987`*^9}, {
   3.5339561968816547`*^9, 3.533956209845278*^9}, {3.534022431253952*^9, 
   3.5340224314567523`*^9}, 3.534022572481*^9, {3.534022607705862*^9, 
   3.534022607924262*^9}, {3.5345620477651424`*^9, 3.5345620818512025`*^9}, {
   3.534562122941674*^9, 3.5345621667933517`*^9}, {3.534648397811719*^9, 
   3.534648401118925*^9}, {3.534709801160247*^9, 3.5347098283822947`*^9}, {
   3.5347098611891527`*^9, 3.5347098619223537`*^9}, {3.534709907926834*^9, 
   3.5347099086288357`*^9}, {3.534710222192987*^9, 3.5347102332066064`*^9}, 
   3.5347103216587615`*^9, {3.5347106722693777`*^9, 3.534710675982184*^9}, 
   3.5470089462373304`*^9, {3.5470091278996496`*^9, 3.5470091547472963`*^9}, {
   3.5470094371389923`*^9, 3.547009443207403*^9}, 3.547009595901272*^9, {
   3.547009818014462*^9, 3.5470098320856867`*^9}, {3.5470099040642133`*^9, 
   3.5470099184162383`*^9}, 3.5470100544952774`*^9, 3.547010367529028*^9, 
   3.550198810721326*^9, {3.550199038434926*^9, 3.550199045018138*^9}, {
   3.5501999115110607`*^9, 3.5501999141942654`*^9}, {3.55019997380197*^9, 
   3.55019997398917*^9}, 3.5502073133024054`*^9, 3.550207620982745*^9, {
   3.550207765158199*^9, 3.550207802863465*^9}, {3.55020859692346*^9, 
   3.550208598467862*^9}, {3.5502099531430416`*^9, 3.550209992720311*^9}, {
   3.550210137301365*^9, 3.550210139516569*^9}, {3.550210537442068*^9, 
   3.5502105388148704`*^9}, 3.550210684753127*^9, {3.553114489866292*^9, 
   3.5531145040935173`*^9}, 3.5531145564784093`*^9, 3.55311478447281*^9, {
   3.553114928071062*^9, 3.553114930255066*^9}, {3.5531151718526897`*^9, 
   3.5531152734400682`*^9}, {3.5531153988286963`*^9, 
   3.5531153999830985`*^9}, {3.5531841051629133`*^9, 3.5531841089225197`*^9}, 
   3.5531844703907547`*^9, {3.5531848141373587`*^9, 3.55318482037737*^9}, {
   3.564290330120206*^9, 3.564290330120206*^9}, {3.5642910712463074`*^9, 
   3.5642910895763397`*^9}, {3.5642912437514105`*^9, 3.564291261098641*^9}, {
   3.564291324902753*^9, 3.5642913279447584`*^9}, {3.564298881313227*^9, 
   3.564298910968879*^9}, 3.5645703399765744`*^9, {3.5645709011207676`*^9, 
   3.5645709125711875`*^9}, {3.5646321047687345`*^9, 
   3.5646321068747377`*^9}, {3.564706696754722*^9, 3.564706699547127*^9}, 
   3.5647067771728635`*^9, {3.564989627219633*^9, 3.564989637609251*^9}, 
   3.565030962442968*^9, {3.565152889292653*^9, 3.565152909557089*^9}, {
   3.565152945156351*^9, 3.565152963236783*^9}, 3.565153012439269*^9, 
   3.5651530922490096`*^9, {3.565162127699024*^9, 3.5651621308992076`*^9}, 
   3.565983845442522*^9, 3.56598387845218*^9, {3.5659904751889668`*^9, 
   3.5659904837065816`*^9}, 3.56599068772374*^9, 3.5659907302338142`*^9, {
   3.5659908215943756`*^9, 3.565990858936449*^9}, 3.5659913705393476`*^9, {
   3.566162100485265*^9, 3.566162102341668*^9}, {3.567196994409768*^9, 
   3.5671969959541707`*^9}, {3.567197054189073*^9, 3.567197061021885*^9}, {
   3.567197133858413*^9, 3.5671972115621495`*^9}, {3.5671973507731943`*^9, 
   3.5671973567168045`*^9}, {3.567197396247274*^9, 3.567197485604231*^9}, 
   3.5674580328183336`*^9, {3.567570200880618*^9, 3.5675702017074194`*^9}, {
   3.5675706469946012`*^9, 3.5675706511130085`*^9}, 3.5675897096419353`*^9, 
   3.5680246296369*^9, {3.568160274924254*^9, 3.568160309037122*^9}, {
   3.568160380558855*^9, 3.5681603947860794`*^9}, {3.568160466354613*^9, 
   3.5681604854178467`*^9}, 3.568160775578356*^9, {3.568160813751623*^9, 
   3.568160822394038*^9}, 3.570075555135485*^9, 3.570075606833976*^9, {
   3.570076573068473*^9, 3.5700766101497383`*^9}, {3.570086741011756*^9, 
   3.5700867466120763`*^9}, 3.570086991324073*^9, {3.570087119755419*^9, 
   3.570087155371456*^9}, {3.5700962095128574`*^9, 3.5700962258772864`*^9}, 
   3.5700962986358137`*^9, {3.570096349835104*^9, 3.570096368445937*^9}, 
   3.5700964717345185`*^9, 3.573604781666628*^9, 3.573604883878007*^9, 
   3.573604925826481*^9, {3.57360495952254*^9, 3.57360503919188*^9}, 
   3.573605070064334*^9, {3.573605328369588*^9, 3.573605331661194*^9}, 
   3.5736054416881866`*^9, {3.5736058843701644`*^9, 3.5736059731343203`*^9}, {
   3.5736060324456244`*^9, 3.5736060387012353`*^9}, 3.573606118386175*^9, 
   3.5736062033595247`*^9, 3.573606490725857*^9, {3.573692115976136*^9, 
   3.5736921224969473`*^9}, 3.574884949276402*^9, {3.574885006013702*^9, 
   3.574885007963705*^9}, {3.57577172896203*^9, 3.5757717849022293`*^9}, {
   3.575771839158333*^9, 3.5757719145096426`*^9}, {3.575772545302722*^9, 
   3.575772560950617*^9}, 3.5757894252461996`*^9, {3.575974174332202*^9, 
   3.5759741933330355`*^9}, {3.5767311834246573`*^9, 3.576731301158064*^9}, {
   3.576734520722247*^9, 3.5767345253398547`*^9}, {3.5767345693007317`*^9, 
   3.576734571297536*^9}, 3.5767349788482513`*^9, 3.5767427797108574`*^9, {
   3.5767839288211775`*^9, 3.5767839425180016`*^9}, 3.5767840176165333`*^9, {
   3.5767965812116947`*^9, 3.576796592521714*^9}, 3.577871510016669*^9, {
   3.57787163504882*^9, 3.577871661200316*^9}, {3.5778717168644996`*^9, 
   3.577871730870301*^9}, {3.577871778560028*^9, 3.577871806259613*^9}, 
   3.5778718509931717`*^9, {3.5778726345519886`*^9, 3.5778726367521143`*^9}, {
   3.5779963658724623`*^9, 3.577996367728865*^9}, 3.578002028108985*^9, 
   3.5921826867730446`*^9, 3.592182932910277*^9, {3.592182973563948*^9, 
   3.5921829890703754`*^9}, {3.5921894432385116`*^9, 3.59218944813692*^9}, 
   3.592189480928178*^9, 3.5921896208916235`*^9, {3.5921896765369215`*^9, 
   3.5921896875193405`*^9}, {3.592189778717101*^9, 3.592189837654004*^9}, 
   3.606352358951768*^9, {3.6063524969964104`*^9, 3.6063525015360184`*^9}, {
   3.6063526625511017`*^9, 3.6063527326732244`*^9}, {3.6063527650432816`*^9, 
   3.6063527755264997`*^9}, {3.606353335280284*^9, 3.6063533646707354`*^9}, 
   3.60635353794024*^9, 3.6063545635752487`*^9, {3.6063546892490697`*^9, 
   3.6063547050674973`*^9}, {3.6063552211473227`*^9, 3.606355223690127*^9}, {
   3.6063552577605867`*^9, 3.606355272190612*^9}, {3.6063553038430676`*^9, 
   3.606355338163128*^9}, {3.606355581851156*^9, 3.606355644547666*^9}, {
   3.60636212821593*^9, 3.6063621434727573`*^9}, {3.6063647301913004`*^9, 
   3.606364732328504*^9}, 3.606367653822036*^9, {3.606423653579423*^9, 
   3.606423662861439*^9}, 3.6064237042951117`*^9, 3.6064240186796646`*^9, 
   3.6064240824057765`*^9, 3.6064352530456715`*^9, 3.625306348124917*^9, {
   3.625306422349847*^9, 3.6253064464050894`*^9}, {3.625306510552402*^9, 
   3.625306553920478*^9}, {3.625306755270032*^9, 3.6253068394009795`*^9}, 
   3.625306876669445*^9, 3.625307106474249*^9, 3.6253080361026907`*^9, 
   3.6253565393719177`*^9, 3.6253833999639544`*^9, 3.6253834309924088`*^9, 
   3.6291871583501062`*^9, {3.6291872318262353`*^9, 3.629187239704249*^9}, {
   3.6291873056923647`*^9, 3.6291873143815804`*^9}, {3.6291875784324455`*^9, 
   3.6291876127525053`*^9}, {3.629189364101582*^9, 3.629189366394786*^9}, {
   3.629232868970395*^9, 3.629232869173195*^9}, 3.629412973595767*^9, {
   3.629681734167853*^9, 3.6296817892827497`*^9}, {3.6296820677432384`*^9, 
   3.6296821134157267`*^9}, {3.6296821492957897`*^9, 3.6296821592174067`*^9}, 
   3.6296822142855034`*^9, 3.6296823447797327`*^9, {3.6296823820481987`*^9, 
   3.6296823873678074`*^9}, 3.6296824244022727`*^9, {3.629682533259264*^9, 
   3.629682571479331*^9}, {3.6296864438997335`*^9, 3.6296864498121443`*^9}, 
   3.6301301056703367`*^9, 3.630186806038844*^9, {3.630187005195995*^9, 
   3.6301870543204813`*^9}, 3.630187116294997*^9, {3.6301872101759624`*^9, 
   3.630187240518016*^9}, {3.6301879818625174`*^9, 3.630188037336215*^9}, {
   3.6301880817139006`*^9, 3.6301881292739916`*^9}, {3.630192463897605*^9, 
   3.6301924663624096`*^9}, {3.6325489266416855`*^9, 3.6325489436145153`*^9}, 
   3.632549332330798*^9, {3.6325493823600864`*^9, 3.6325493932021055`*^9}, {
   3.632549475316257*^9, 3.632549494769491*^9}, 3.6325495787244463`*^9, {
   3.63254965087018*^9, 3.6325496533193846`*^9}, {3.632549689417848*^9, 
   3.632549695548659*^9}, {3.632549725609912*^9, 3.632549731350722*^9}, 
   3.632549777632004*^9, {3.6326038339351673`*^9, 3.6326038351987696`*^9}, 
   3.6326052431856437`*^9, 3.632605279237307*^9, {3.6327896696112256`*^9, 
   3.63278967761404*^9}, 3.632789733462138*^9, 3.632789829792307*^9, 
   3.632789870211978*^9, 3.632789986728583*^9, 3.632798118478204*^9, 
   3.632798253418441*^9, {3.632805774254259*^9, 3.6328057895110865`*^9}, {
   3.6328080477542534`*^9, 3.6328080865671215`*^9}, {3.632808253050614*^9, 
   3.6328082534094143`*^9}, {3.632808331378351*^9, 3.632808360269602*^9}, {
   3.632808538526723*^9, 3.6328085720043817`*^9}, {3.632808631050485*^9, 
   3.632808642282505*^9}, {3.632808677908575*^9, 3.6328087181990533`*^9}, {
   3.6328089591882763`*^9, 3.63280900082475*^9}, {3.6328090336628075`*^9, 
   3.632809129977377*^9}, 3.632809186913084*^9, {3.632809216974337*^9, 
   3.632809236926772*^9}, 3.6328094921744204`*^9, {3.6328628083886805`*^9, 
   3.6328628144414916`*^9}, 3.632862901630045*^9, 3.6345039446897955`*^9, 
   3.634504022565132*^9, {3.634504657689049*^9, 3.6345046727742753`*^9}, {
   3.634504709243346*^9, 3.6345047653410444`*^9}, {3.634504880625247*^9, 
   3.6345049408257523`*^9}, {3.6345049821346254`*^9, 3.63450498472423*^9}, {
   3.6345052382364817`*^9, 3.634505239952485*^9}, {3.6345553893336797`*^9, 
   3.6345554050117073`*^9}, 3.6345568508334475`*^9, {3.636074809678754*^9, 
   3.6360748135943604`*^9}, {3.6360753609197226`*^9, 3.636075371137741*^9}, {
   3.6360754445046697`*^9, 3.6360754448322706`*^9}, 3.6360754780759287`*^9, {
   3.6360755150323935`*^9, 3.636075526139613*^9}, 3.6364953410960603`*^9, 
   3.636495413464587*^9, 3.636495521806778*^9, 3.636495566391656*^9, 
   3.6364955986993127`*^9, 3.63649578354646*^9, {3.636496052943333*^9, 
   3.636496059417344*^9}, {3.636496089572198*^9, 3.6364960983862133`*^9}, 
   3.6364962814213343`*^9, {3.6364969368880863`*^9, 3.636496945000101*^9}, 
   3.7255922261262445`*^9, 3.7255924668034678`*^9, 3.7255925194379597`*^9, {
   3.725594490754224*^9, 3.7255945013310423`*^9}, 3.7255952592895737`*^9, 
   3.725595809710141*^9, 3.725595872032251*^9, 3.725596154470747*^9, 
   3.7255964263948245`*^9, 3.7255994902566366`*^9, 3.7256016031495495`*^9, 
   3.7256016803852854`*^9, {3.7257699711575327`*^9, 3.7257699995651827`*^9}, 
   3.7257711688340364`*^9, 3.7257741402492557`*^9, 3.7257744781258564`*^9, 
   3.7258490150765495`*^9, {3.725852074641125*^9, 3.725852075202726*^9}, 
   3.725852252840238*^9, 3.725852386626073*^9, {3.7258526579417496`*^9, 
   3.725852658565751*^9}, 3.7258527373146887`*^9, {3.7258528441436768`*^9, 
   3.7258528480904837`*^9}, 3.726913461460272*^9, {3.7269135066691513`*^9, 
   3.7269135066847515`*^9}, 3.7269135736244693`*^9, {3.7269141963775625`*^9, 
   3.726914207671983*^9}, 3.726914350100233*^9, {3.726914421298758*^9, 
   3.7269144217511587`*^9}, 3.7269145086589117`*^9, 3.7269146264547186`*^9, 
   3.7269147176680784`*^9, {3.726914927879649*^9, 3.7269149421848745`*^9}, {
   3.726942862934918*^9, 3.726942875820541*^9}, 3.7269430613360662`*^9, 
   3.7269527172550287`*^9, {3.732581313558529*^9, 3.732581414007105*^9}, {
   3.7326583984946456`*^9, 3.732658428493498*^9}, {3.732658557942526*^9, 
   3.732658586022575*^9}, {3.732659178499616*^9, 3.732659189263635*^9}, 
   3.732662539865631*^9, {3.7402178619119854`*^9, 3.740217868385997*^9}, {
   3.7402181435784817`*^9, 3.740218149693692*^9}, {3.740218205900591*^9, 
   3.7402182074137936`*^9}, {3.740218302823561*^9, 3.740218347018439*^9}, {
   3.740218658655794*^9, 3.7402186693574123`*^9}, {3.7402192940381107`*^9, 
   3.7402193007617226`*^9}, {3.740220269338224*^9, 3.7402202697282248`*^9}, {
   3.740220328462328*^9, 3.740220338337145*^9}, {3.74062349322491*^9, 
   3.7406234962357154`*^9}, {3.740778595583645*^9, 3.74077859848525*^9}, {
   3.740778651650143*^9, 3.7407786648009663`*^9}, {3.7407788761441393`*^9, 
   3.7407788989669795`*^9}, {3.740779013450781*^9, 3.740779023996399*^9}, {
   3.7407791542866287`*^9, 3.7407791747070646`*^9}, {3.740779219900344*^9, 
   3.740779220196744*^9}, {3.740779424588303*^9, 3.7407794273807077`*^9}, {
   3.7407794683775797`*^9, 3.7407794818404036`*^9}, {3.7407796849131613`*^9, 
   3.7407797216824255`*^9}, {3.7407798321070204`*^9, 3.7407798775031*^9}, {
   3.7407800627346253`*^9, 3.740780110221109*^9}, {3.740780271946593*^9, 
   3.7407802910098267`*^9}, 3.740780521968232*^9, {3.740780648765255*^9, 
   3.7407806521660604`*^9}, {3.740780740587016*^9, 3.7407807443622227`*^9}, {
   3.7407824497451477`*^9, 3.740782452974354*^9}, {3.740783174738423*^9, 
   3.740783181930035*^9}, 3.740784309105423*^9, 3.7407843782021475`*^9, 
   3.740784798230516*^9, 3.740792141493194*^9, {3.740795745950735*^9, 
   3.7407958089592457`*^9}, 3.7407962456820135`*^9, 3.740796278894471*^9, {
   3.7407966335298944`*^9, 3.740796667288354*^9}, {3.740796726833658*^9, 
   3.740796732012867*^9}, {3.7407968196070213`*^9, 3.740796823959429*^9}, {
   3.741114044270252*^9, 3.741114047499458*^9}, 3.741114172876878*^9, {
   3.741114214840952*^9, 3.7411142149657516`*^9}, {3.7411143056643114`*^9, 
   3.7411143086907167`*^9}, {3.7411143683764215`*^9, 
   3.7411143879700556`*^9}, {3.7411144249889207`*^9, 
   3.7411144431785526`*^9}, {3.7411667545006695`*^9, 3.741166765233488*^9}, 
   3.74189270181349*^9, 3.74466368597719*^9, 3.7446641759896507`*^9, 
   3.7446656127845235`*^9, 3.744665651924992*^9, 3.744742913131895*^9, {
   3.7447489853929644`*^9, 3.744748987545768*^9}, 3.744875554021535*^9, {
   3.7452126977581944`*^9, 3.7452126994273973`*^9}, {3.7452128151796007`*^9, 
   3.74521282638042*^9}, {3.7452129967795196`*^9, 3.745213042097599*^9}, {
   3.7452130797560654`*^9, 3.745213081565668*^9}, {3.7452131350581627`*^9, 
   3.74521318497825*^9}, {3.7452132378155427`*^9, 3.745213240966748*^9}, {
   3.7452136012649813`*^9, 3.745213631029834*^9}, {3.745213734582815*^9, 
   3.7452137373908205`*^9}, {3.7452153530628586`*^9, 3.7452153600672708`*^9}, 
   3.7452154080997553`*^9, {3.745215674051823*^9, 3.7452156741454234`*^9}, {
   3.7452158387569127`*^9, 3.745215838975313*^9}, {3.745216206574359*^9, 
   3.745216245761627*^9}, 3.745220787875206*^9, 3.746051986744711*^9, {
   3.7460521008589115`*^9, 3.746052131778166*^9}, {3.7460521666286273`*^9, 
   3.7460524545427327`*^9}, 3.746052540857684*^9, {3.746053417769227*^9, 
   3.7460534259280415`*^9}, 3.746054345117657*^9, 3.7460546304265585`*^9, {
   3.7460742014929237`*^9, 3.746074240758193*^9}, 3.746991621012333*^9, {
   3.746994997701064*^9, 3.746995027793517*^9}, {3.7469953201784315`*^9, 
   3.7469954400490417`*^9}, {3.7469954827307167`*^9, 3.74699550728516*^9}, 
   3.7469955396084166`*^9, {3.7470008008733025`*^9, 3.74700080527251*^9}, {
   3.7470008733666296`*^9, 3.747000875893834*^9}, {3.747000949837964*^9, 
   3.747000952287168*^9}, 3.7470264752655973`*^9, {3.747028003559884*^9, 
   3.7470280096126947`*^9}, {3.7481111476864767`*^9, 3.748111150276081*^9}, 
   3.748111262440278*^9, 3.7481114647570333`*^9, 3.7481114993578944`*^9, 
   3.7481117436231236`*^9, 3.7481117783019843`*^9, 3.7481118211240597`*^9, 
   3.7481119089054136`*^9, 3.748112016779603*^9, 3.7481126540251226`*^9, {
   3.748112759746508*^9, 3.7481127604173093`*^9}, {3.748112809635396*^9, 
   3.748112816156207*^9}, {3.748112846591861*^9, 3.7481128812083216`*^9}, 
   3.7481129454960346`*^9, 3.748113095849098*^9, 3.7481148409525647`*^9, 
   3.7481523665185213`*^9, 3.749668417688261*^9, 3.7507168750970583`*^9, {
   3.7507169896168594`*^9, 3.750716992861665*^9}, {3.750717108551468*^9, 
   3.7507172392640977`*^9}, {3.7507172898861866`*^9, 3.75071732030624*^9}, {
   3.750717367402723*^9, 3.7507173891803613`*^9}, {3.7507175430902314`*^9, 
   3.750717551592246*^9}, {3.750717698907706*^9, 3.7507177368313723`*^9}, {
   3.750717804535491*^9, 3.7507178507895727`*^9}, {3.750717899056057*^9, 
   3.750717922424898*^9}, {3.750718034791896*^9, 3.7507180483015194`*^9}, {
   3.7507198746355276`*^9, 3.7507198747915277`*^9}, 3.7507206603917084`*^9, 
   3.750743995100903*^9, {3.750744115267914*^9, 3.7507441173583174`*^9}, 
   3.751183154782548*^9, 3.7511832007870283`*^9, 3.7511889477875257`*^9, 
   3.7511898686887436`*^9, {3.751190067027492*^9, 3.751190067214692*^9}, {
   3.7511904339557366`*^9, 3.7511904342209373`*^9}, 3.751343678313509*^9, {
   3.751343737328412*^9, 3.7513437454248266`*^9}, {3.7513439903028574`*^9, 
   3.7513440021900787`*^9}, 3.7513440559165726`*^9, {3.751344356866702*^9, 
   3.751344358754305*^9}, {3.7513453951733255`*^9, 3.7513454022313385`*^9}, 
   3.751345479623074*^9, 3.751345663578597*^9, 3.7513458060536475`*^9, {
   3.7513462322931957`*^9, 3.751346244788818*^9}, 3.751347972101852*^9, {
   3.7513564574799557`*^9, 3.751356461379963*^9}, 3.7513572038244677`*^9, 
   3.7550499818675575`*^9, 3.755050081270932*^9, 3.755050162094674*^9, {
   3.7550503792938557`*^9, 3.755050383552663*^9}, {3.755050657769945*^9, 
   3.7550507162700477`*^9}, 3.7550507776249557`*^9, {3.7550508327710524`*^9, 
   3.7550509174012012`*^9}, {3.75506116943268*^9, 3.75506120939995*^9}, 
   3.755061263641245*^9, {3.755061304045316*^9, 3.755061332296966*^9}, {
   3.791837454079505*^9, 3.7918374672326627`*^9}, {3.7918375293898745`*^9, 
   3.791837639613963*^9}, {3.7918376716532726`*^9, 3.7918377406682825`*^9}, {
   3.7918378367550473`*^9, 3.7918378492208977`*^9}, {3.791837885353021*^9, 
   3.791837927093199*^9}, {3.7918379571642485`*^9, 3.791837983314344*^9}, {
   3.7918382715699883`*^9, 3.791838307577134*^9}, {3.791838449356269*^9, 
   3.7918384679143763`*^9}, {3.791838600615634*^9, 3.7918386391222763`*^9}, {
   3.7918387136916265`*^9, 3.791838717518922*^9}, {3.7918387964402494`*^9, 
   3.7918388962605457`*^9}, {3.7918390063752236`*^9, 3.791839009499524*^9}, {
   3.7918390718129854`*^9, 3.791839081279473*^9}, 3.791926694308837*^9, {
   3.7919269047590957`*^9, 3.7919269312528725`*^9}, {3.791941159803388*^9, 
   3.791941185000529*^9}, {3.7919414976767054`*^9, 3.7919415013477135`*^9}, {
   3.7919418976905293`*^9, 3.7919419070633483`*^9}, {3.79194194144582*^9, 
   3.7919419457417145`*^9}, {3.791944532323326*^9, 3.7919445402901945`*^9}, 
   3.791945575110017*^9, {3.7919456228331137`*^9, 3.7919456251919384`*^9}, {
   3.7919457477646008`*^9, 3.791945947970544*^9}, {3.7919459941783795`*^9, 
   3.7919459979274817`*^9}, 3.791946210705377*^9, 3.791947743925529*^9, {
   3.792142687080438*^9, 3.7921427322260327`*^9}, {3.7921428660273533`*^9, 
   3.792142869089161*^9}, {3.792142945399186*^9, 3.7921429898730664`*^9}, {
   3.7921430613873816`*^9, 3.792143077961583*^9}, {3.7921431184519978`*^9, 
   3.7921431238725896`*^9}, 3.792143155349477*^9, 3.792143211601818*^9, {
   3.7921432698380313`*^9, 3.7921432757897153`*^9}, 3.7921434567671947`*^9, 
   3.792144982440548*^9, 3.7921450272892933`*^9, {3.792145072528581*^9, 
   3.792145079042717*^9}, 3.79214511625261*^9, 3.792145176425829*^9, {
   3.792145498912012*^9, 3.792145499115088*^9}, 3.792145594592448*^9, {
   3.7921456423624225`*^9, 3.7921456449087653`*^9}, {3.792184449093946*^9, 
   3.792184475478321*^9}, {3.792184553584795*^9, 3.792184576954283*^9}, 
   3.79218461517962*^9, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, {
   3.792206718240422*^9, 3.792206731424799*^9}, 3.792206845007283*^9, {
   3.7922070074375753`*^9, 3.7922070321039267`*^9}, 3.7922073048830905`*^9, {
   3.792207471952895*^9, 3.7922074981029654`*^9}, 3.792207861765847*^9, {
   3.7922106379018235`*^9, 3.7922106451501083`*^9}, {3.792270597712449*^9, 
   3.792270597712449*^9}, {3.792270891033639*^9, 3.7922708912054386`*^9}, 
   3.7922709722175446`*^9, 3.792271039389139*^9, 3.792271363687356*^9, {
   3.792272235885374*^9, 3.792272236072836*^9}, {3.7922725073824296`*^9, 
   3.7922725105379333`*^9}, {3.7922725499817567`*^9, 3.792272575631919*^9}, {
   3.7923819877656794`*^9, 3.7923819927489023`*^9}, 3.7925386565345564`*^9, {
   3.7925388649840345`*^9, 3.7925389122384624`*^9}, {3.792538977710556*^9, 
   3.7925389836310034`*^9}, 3.792539073871907*^9, 3.792539144948824*^9, 
   3.7925391995140295`*^9, {3.7925392495646725`*^9, 3.7925392522827845`*^9}, {
   3.792553223558854*^9, 3.792553236758835*^9}, 3.7925532712350616`*^9, 
   3.792553308132576*^9, {3.7925533452331324`*^9, 3.7925534413978987`*^9}, {
   3.792553882028*^9, 3.7925538868705435`*^9}, 3.792554765327935*^9, 
   3.7926557610118475`*^9, {3.8025467409044847`*^9, 3.802546764242728*^9}, 
   3.802547143215903*^9, {3.8025527321047087`*^9, 3.8025527867480636`*^9}, 
   3.802552818615567*^9, {3.8025528666667347`*^9, 3.802552957988966*^9}, 
   3.802553005837062*^9, 3.802553077929443*^9, {3.8025798749373145`*^9, 
   3.8025798774367256`*^9}, 3.8025799386730447`*^9, {3.8025800226579857`*^9, 
   3.8025800228142033`*^9}, 3.802585141722986*^9, 3.8078545320706625`*^9, {
   3.8078546051822667`*^9, 3.8078546730877852`*^9}, {3.8078547090317235`*^9, 
   3.8078547719695177`*^9}, 3.8078548203562016`*^9, 3.8078549040505514`*^9, {
   3.807855037674405*^9, 3.807855037962635*^9}, 3.816906009920802*^9, {
   3.8169060910892124`*^9, 3.8169061174267793`*^9}, {3.8169061971268187`*^9, 
   3.81690620022064*^9}, {3.8169062907775416`*^9, 3.8169063139595995`*^9}, {
   3.816906347529848*^9, 3.816906358371046*^9}, {3.8169064463660016`*^9, 
   3.8169064751248894`*^9}, {3.8169065717896967`*^9, 
   3.8169065738517113`*^9}, {3.8169066667673993`*^9, 3.816906727987401*^9}, 
   3.816906887955981*^9, {3.8169072179264603`*^9, 3.816907218176386*^9}, {
   3.8208064885993166`*^9, 3.820806493191882*^9}, {3.820806571985753*^9, 
   3.820806591262437*^9}, {3.820806643218884*^9, 3.820806644468581*^9}, {
   3.820806710234253*^9, 3.8208067108747253`*^9}, 3.820806825550688*^9, 
   3.820806870305712*^9, {3.8208070329068413`*^9, 3.8208070358748503`*^9}, 
   3.8208071291340075`*^9, {3.827874604478779*^9, 3.8278746309413214`*^9}, {
   3.828285976508387*^9, 3.8282860378689904`*^9}, {3.828286069189767*^9, 
   3.8282860750946317`*^9}, {3.8282862454440393`*^9, 3.828286274874611*^9}, 
   3.8282864569082403`*^9, 3.8282865303597565`*^9, {3.828288390273615*^9, 
   3.8282884014897327`*^9}, 3.8286362223683195`*^9, 3.8288490034020543`*^9, {
   3.8482570386076126`*^9, 3.8482570386232243`*^9}, {3.8482571403492136`*^9, 
   3.8482571748254557`*^9}, 3.8482572580401783`*^9, {3.8482592159992356`*^9, 
   3.8482592163897705`*^9}, 3.8482592584954834`*^9, 3.848259312904552*^9, {
   3.848259470368842*^9, 3.8482594998619113`*^9}, {3.8482597067661886`*^9, 
   3.848259717341818*^9}, {3.8482598723142166`*^9, 3.848259905868791*^9}, {
   3.8482604837349753`*^9, 3.8482604978097763`*^9}, {3.8547617638223734`*^9, 
   3.8547617638379946`*^9}, {3.8547617944089394`*^9, 3.8547617956430206`*^9}, 
   3.8547619113724337`*^9, {3.854762164384845*^9, 3.8547621866921015`*^9}, 
   3.8549110836125603`*^9, 3.8831684291204414`*^9, 3.8831685486083903`*^9, 
   3.883168591770075*^9, 3.8831689414842877`*^9, 3.8831690014857616`*^9, 
   3.8831706667954407`*^9, 3.8831708703093653`*^9, 3.956529049280467*^9, 
   3.9565290970348783`*^9, {3.9565292776866674`*^9, 3.9565293066954803`*^9}, {
   3.9565293420934258`*^9, 3.9565293429526005`*^9}, {3.9565293996423855`*^9, 
   3.9565294227776165`*^9}, 3.956529535867911*^9, 3.956529572578045*^9, {
   3.9565296812237678`*^9, 3.9565296814268775`*^9}, {3.956530125035204*^9, 
   3.9565301364388113`*^9}, 3.956530440138101*^9, 3.9565415554720664`*^9, {
   3.956546654988694*^9, 3.956546660393709*^9}, 3.9565469377505007`*^9, 
   3.9565471139747667`*^9, {3.9565471759133606`*^9, 3.9565471791939087`*^9}, 
   3.9568201605036573`*^9, 3.956820221973601*^9, 3.9568205860224404`*^9, 
   3.9568207539518156`*^9, {3.9568213211937327`*^9, 3.956821332800353*^9}, 
   3.956821498662866*^9, 3.95682157423888*^9, 3.956822059609357*^9, 
   3.956822230131841*^9, 3.9568229715066385`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0380.png\>\"", ",", "ap3dConfHypergeomFE2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955147213811*^9, 3.533955206041514*^9, 3.5470088906700325`*^9, 
   3.5470089487489347`*^9, {3.5501987437036085`*^9, 3.5501987438440084`*^9}, 
   3.550198813591731*^9, {3.5504692939604816`*^9, 3.550469294069682*^9}, 
   3.553114267872302*^9, 3.5531143193679924`*^9, 3.5531145595360146`*^9, 
   3.5531850944854507`*^9, {3.5531852419837103`*^9, 3.5531852422489104`*^9}, 
   3.5531900792725277`*^9, 3.5531901503774524`*^9, 3.55319089444716*^9, 
   3.553190949265656*^9, {3.55321378571439*^9, 3.5532137858547897`*^9}, 
   3.553213822249654*^9, {3.5532141187749743`*^9, 3.553214146340223*^9}, {
   3.5563895716216006`*^9, 3.556389571762001*^9}, 3.5563898724213285`*^9, {
   3.7325812172595596`*^9, 3.7325812177743607`*^9}, 3.7326535308532934`*^9, {
   3.732659113743902*^9, 3.732659113899903*^9}, 3.732659206220865*^9, 
   3.740216750922025*^9, 3.7402182214850187`*^9, 3.740218987201172*^9, 
   3.740778600201253*^9, {3.740780597784365*^9, 3.740780598018366*^9}, 
   3.7407822969116793`*^9, {3.7407956919590406`*^9, 3.740795692161841*^9}, 
   3.7407957432831306`*^9, 3.741114049309061*^9, {3.7411141070915623`*^9, 
   3.7411141072631626`*^9}, 3.741166751692664*^9, 3.7411668366036134`*^9, {
   3.741421168425725*^9, 3.7414211686285257`*^9}, 3.7446636889255953`*^9, 
   3.744664374468799*^9, 3.7446656127845235`*^9, {3.7446659070166407`*^9, 
   3.7446659071882405`*^9}, 3.7452127094426146`*^9, {3.7452127690503197`*^9, 
   3.7452127718427243`*^9}, 3.745215203949396*^9, 3.745215406290152*^9, 
   3.746051989225116*^9, {3.746052022125573*^9, 3.7460520228275747`*^9}, 
   3.746055103278989*^9, 3.746991472593672*^9, 3.7469915089417357`*^9, 
   3.7469915389717884`*^9, 3.746991632774753*^9, 3.748111159012097*^9, {
   3.7481113177579756`*^9, 3.748111317945176*^9}, 3.7481126514667177`*^9, {
   3.748113195470874*^9, 3.748113195689274*^9}, {3.7507167568800507`*^9, 
   3.7507167594852552`*^9}, 3.7507168842542744`*^9, {3.750907902190365*^9, 
   3.750907924545204*^9}, 3.7509082695866103`*^9, 3.7513500248866577`*^9, 
   3.7513500919979753`*^9, {3.7513503196023755`*^9, 3.7513503197739754`*^9}, {
   3.7550497169166927`*^9, 3.7550497426723375`*^9}, 3.7550499818831577`*^9, {
   3.791837399326764*^9, 3.791837403919399*^9}, 3.7918374397704163`*^9, 
   3.7919411562417016`*^9, 3.7919412497352705`*^9, 3.7919455775000772`*^9, 
   3.79194561547548*^9, 3.7921427775170593`*^9, {3.7921442289360805`*^9, 
   3.7921442290922937`*^9}, 3.792144984877466*^9, {3.79214503848981*^9, 
   3.7921450386459846`*^9}, 3.7922066272150636`*^9, {3.7922081247973256`*^9, 
   3.792208125375308*^9}, 3.792270597728077*^9, {3.792270704359085*^9, 
   3.792270704452841*^9}, 3.792538656550113*^9, {3.7925539995157557`*^9, 
   3.7925540001562295`*^9}, 3.8025468009840703`*^9, {3.802546874435505*^9, 
   3.8025468749822507`*^9}, 3.8025469230959077`*^9, 3.8025516256547904`*^9, {
   3.8025798621278696`*^9, 3.802579872625392*^9}, {3.807854454103038*^9, 
   3.807854466154855*^9}, 3.807854538815669*^9, 3.8169060154038906`*^9, {
   3.81690681059914*^9, 3.8169068368429813`*^9}, {3.8208063901537895`*^9, 
   3.820806402244675*^9}, 3.820806503673809*^9, {3.827874604494393*^9, 
   3.8278746309413214`*^9}, {3.8278748592560916`*^9, 3.8278748863590775`*^9}, 
   3.82828663244518*^9, 3.8482570386232243`*^9, {3.8482570745991116`*^9, 
   3.848257085752733*^9}, 3.8547617638536158`*^9, {3.854761829152297*^9, 
   3.854761851225196*^9}, {3.883168591785688*^9, 3.883168637915431*^9}, 
   3.9565290755867867`*^9, {3.9565292024699354`*^9, 3.9565292106242757`*^9}, 
   3.95654665337973*^9, 3.956546684981656*^9, 3.956820221973601*^9, 
   3.9568203068130665`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"adpConfHypergeomFE2", "=", "\[IndentingNewLine]", 
  RowBox[{"ArgDensityPlot", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"ContoursColorAbsMax", "\[Rule]", "2000"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"AbsContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Log\>\"", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "8"}], ",", "70"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ArgContours", "\[Rule]", "8"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\""}], "}"}]}], ",", 
    RowBox[{"RotateLabel", "\[Rule]", "False"}], ",", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0008", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
           RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", "None"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "11"}], ")"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", "9"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "210"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.732482892728856*^9, 3.7324829563457675`*^9}, {
   3.7324830851923943`*^9, 3.7324830882811995`*^9}, {3.732483262424306*^9, 
   3.732483272377123*^9}, 3.7326584415195208`*^9, {3.7326584750439796`*^9, 
   3.7326584764479823`*^9}, 3.732658701981179*^9, {3.732658872349078*^9, 
   3.732658872567479*^9}, 3.7326592186228867`*^9, 3.7326593083866453`*^9, 
   3.7326626660310535`*^9, {3.740218157446906*^9, 3.740218181533348*^9}, 
   3.7402182257126255`*^9, 3.7402183634452677`*^9, {3.740218493186303*^9, 
   3.7402184934047036`*^9}, 3.740218637580157*^9, {3.7402186807610326`*^9, 
   3.7402186901834493`*^9}, 3.740219272556873*^9, 3.7406235115861425`*^9, {
   3.740778603524059*^9, 3.740778607080865*^9}, {3.740778656564152*^9, 
   3.740778658529755*^9}, {3.740778688559808*^9, 3.7407786898078103`*^9}, {
   3.7407792259843545`*^9, 3.7407792441895866`*^9}, {3.7407793822810287`*^9, 
   3.740779417427891*^9}, {3.7407794646959734`*^9, 3.7407794857872105`*^9}, 
   3.740780774189475*^9, 3.7407824622407703`*^9, {3.740783008707331*^9, 
   3.7407830693134375`*^9}, 3.7407921769832563`*^9, 3.740795739929125*^9, 
   3.740795830549684*^9, {3.741114053755069*^9, 3.741114056173073*^9}, 
   3.741114177042085*^9, {3.741114217851757*^9, 3.7411142179765573`*^9}, 
   3.741114298004698*^9, 3.7411143910588613`*^9, {3.7411144222121162`*^9, 
   3.741114422383716*^9}, 3.7411667475274568`*^9, 3.741166782284318*^9, 
   3.741202200838129*^9, 3.7418928330565205`*^9, 3.744663694463605*^9, 
   3.7446641788132553`*^9, 3.7446656127845235`*^9, 3.7446656519405923`*^9, 
   3.744742916766701*^9, 3.7447489900885725`*^9, 3.745212714450224*^9, {
   3.7452134334710865`*^9, 3.745213472377555*^9}, {3.74521352657205*^9, 
   3.7452135499564915`*^9}, {3.745213645116658*^9, 3.74521367446031*^9}, 
   3.7452137501360426`*^9, 3.745215372484893*^9, 3.745215403544547*^9, {
   3.745215676563428*^9, 3.745215676657028*^9}, {3.745215841159317*^9, 
   3.7452158501293325`*^9}, 3.745220796377221*^9, 3.746051992891122*^9, {
   3.7460525179568443`*^9, 3.746052527363661*^9}, {3.7460525613717203`*^9, 
   3.7460526080470023`*^9}, {3.746052647827072*^9, 3.746052665392703*^9}, 
   3.7460527306476173`*^9, {3.7460534548348923`*^9, 3.746053478047733*^9}, {
   3.7460536390400157`*^9, 3.7460536607708535`*^9}, {3.7460537995066986`*^9, 
   3.7460538460103807`*^9}, 3.746054532895187*^9, 3.7460546210509415`*^9, {
   3.746055005030016*^9, 3.7460550460736885`*^9}, 3.7460615185886574`*^9, {
   3.746069839136873*^9, 3.7460698629425144`*^9}, {3.746073417607147*^9, 
   3.7460734321307726`*^9}, 3.7460741921641073`*^9, 3.7469916409491673`*^9, {
   3.7469955617292557`*^9, 3.746995578218485*^9}, 3.7469956382941904`*^9, {
   3.7469959147934766`*^9, 3.746995920768287*^9}, {3.7469959729191785`*^9, 
   3.746995986631603*^9}, 3.746998736928876*^9, 3.746999808962759*^9, 
   3.747000762809235*^9, {3.7470280162427063`*^9, 3.7470280188011107`*^9}, 
   3.7481111741597233`*^9, 3.74811125768227*^9, {3.7481113758212776`*^9, 
   3.748111454039815*^9}, 3.7481116828922167`*^9, 3.74811178123479*^9, 
   3.7481120097751913`*^9, 3.7481126483779125`*^9, 3.7481127678585224`*^9, 
   3.7481129482884398`*^9, 3.748113174738437*^9, {3.748114852964586*^9, 
   3.7481148546805887`*^9}, 3.7481523715885305`*^9, 3.748156676743692*^9, 
   3.7496684226178694`*^9, 3.7507168950182934`*^9, 3.7507174232196207`*^9, 
   3.7507179880698137`*^9, 3.7507180637455463`*^9, {3.750718172664938*^9, 
   3.7507181919309716`*^9}, {3.750718281381529*^9, 3.7507183044383693`*^9}, {
   3.7507198773499327`*^9, 3.7507198774903326`*^9}, 3.750720697925374*^9, 
   3.7507439988761096`*^9, {3.750744109105903*^9, 3.7507441115707073`*^9}, 
   3.75090826960221*^9, 3.750908324873107*^9, 3.750911281940936*^9, 
   3.7509118911532063`*^9, 3.7509120959347663`*^9, {3.750923612368995*^9, 
   3.750923612524996*^9}, {3.7509248608167896`*^9, 3.750924875777216*^9}, {
   3.7509256243805313`*^9, 3.750925624567732*^9}, 3.7513499450613174`*^9, 
   3.751350024902258*^9, 3.751350205378975*^9, {3.7513571187651176`*^9, 
   3.751357119545119*^9}, 3.751357214526087*^9, {3.7513577496226263`*^9, 
   3.7513577498410273`*^9}, {3.751405366281531*^9, 3.751405378480752*^9}, {
   3.7514055458066463`*^9, 3.751405557849867*^9}, {3.751405638626809*^9, 
   3.7514056388764095`*^9}, 3.755049981945558*^9, 3.755050081707733*^9, 
   3.7550501621258745`*^9, {3.755050400759494*^9, 3.7550504035050983`*^9}, 
   3.7550509310980253`*^9, {3.7550512422873716`*^9, 3.7550512668106146`*^9}, {
   3.755051312409495*^9, 3.755051312877496*^9}, {3.755051771595695*^9, 
   3.755051771751695*^9}, {3.7550518885491004`*^9, 3.7550519085639353`*^9}, 
   3.7551379658536453`*^9, {3.755138016132534*^9, 3.755138075287838*^9}, {
   3.7551381761264153`*^9, 3.755138212599279*^9}, {3.75513827588859*^9, 
   3.755138303656639*^9}, {3.7551383744339633`*^9, 3.7551383747147636`*^9}, {
   3.755138574254714*^9, 3.75513859464395*^9}, 3.755138673611289*^9, {
   3.755139946626726*^9, 3.7551399654559593`*^9}, {3.7551413576185923`*^9, 
   3.755141379583431*^9}, 3.7551422855775647`*^9, {3.7551424248350105`*^9, 
   3.7551424403258376`*^9}, 3.7551475815781126`*^9, 3.7552236306473618`*^9, 
   3.7552237351007524`*^9, 3.7552257200630403`*^9, {3.755227559021696*^9, 
   3.755227559177696*^9}, {3.755227954092391*^9, 3.7552279570407963`*^9}, 
   3.7642903613991814`*^9, {3.7642905329386835`*^9, 3.7642905870551786`*^9}, 
   3.7642906182396336`*^9, {3.764290672449729*^9, 3.7642906894693584`*^9}, 
   3.764290721075014*^9, {3.76429075314867*^9, 3.764290753289071*^9}, {
   3.7642908794620924`*^9, 3.7642908959981213`*^9}, 3.764291593614951*^9, 
   3.76429466703955*^9, 3.7643042218683386`*^9, 3.764315617343957*^9, 
   3.76431783317605*^9, 3.7643199388461533`*^9, 3.7643853579378877`*^9, 
   3.764664382553267*^9, 3.7646644254065423`*^9, {3.7646670199227085`*^9, 
   3.7646670350235357`*^9}, {3.7646689626829224`*^9, 3.7646689628545227`*^9}, 
   3.764887973228504*^9, 3.764888008734166*^9, 3.7648888932053223`*^9, {
   3.7648903774637313`*^9, 3.764890377635331*^9}, 3.7648904488962564`*^9, 
   3.764890628343372*^9, {3.7648920077004867`*^9, 3.764892008121687*^9}, 
   3.764892076278207*^9, {3.7649026437276335`*^9, 3.7649026438212337`*^9}, 
   3.76506077650143*^9, 3.765170874625887*^9, 3.7651709275099792`*^9, 
   3.7651715756087255`*^9, 3.765171666619285*^9, 3.7651717371314087`*^9, 
   3.765171875909253*^9, 3.7652588601167355`*^9, 3.7652589118932266`*^9, {
   3.765267833767707*^9, 3.7652678340173073`*^9}, 3.766219677016867*^9, 
   3.766219733629367*^9, 3.7662201958113785`*^9, {3.7662231334417396`*^9, 
   3.7662231361717443`*^9}, 3.7662232485855417`*^9, {3.766426144952866*^9, 
   3.766426157042887*^9}, {3.76647719987669*^9, 3.7664772214515276`*^9}, {
   3.7664774867767935`*^9, 3.7664775002396173`*^9}, {3.7688458990076995`*^9, 
   3.7688459132037244`*^9}, 3.7688464394654493`*^9, 3.7688469041774664`*^9, 
   3.791925257427122*^9, 3.791925346562312*^9, {3.791925415077385*^9, 
   3.791925432292034*^9}, {3.79192558767724*^9, 3.7919255902703776`*^9}, {
   3.7919257453302054`*^9, 3.791925757202401*^9}, {3.791925937519228*^9, 
   3.7919259408152847`*^9}, {3.7919259926311307`*^9, 3.791925997395666*^9}, 
   3.791926263855747*^9, {3.7919264890844517`*^9, 3.791926490037352*^9}, 
   3.791927284210745*^9, 3.7919411532580585`*^9, 3.791941223803928*^9, {
   3.7919415060341063`*^9, 3.7919415061903205`*^9}, 3.7919455800307994`*^9, 
   3.7919456362986813`*^9, {3.791945689832918*^9, 3.7919457217551537`*^9}, 
   3.7919460775336857`*^9, 3.7919462165008616`*^9, {3.7919462528203726`*^9, 
   3.7919462530703335`*^9}, 3.7921427775170593`*^9, 3.7921428783057747`*^9, {
   3.792143003807266*^9, 3.7921430251928267`*^9}, 3.792143064074258*^9, {
   3.7921431277154303`*^9, 3.792143128543357*^9}, {3.7921434609849415`*^9, 
   3.79214346590565*^9}, 3.7921449885797224`*^9, 3.792145025274151*^9, {
   3.7921450954762783`*^9, 3.7921451181897235`*^9}, {3.7921455056604123`*^9, 
   3.7921455095657372`*^9}, {3.7922066272150636`*^9, 3.7922066272150636`*^9}, 
   3.7922067460150957`*^9, 3.7922068475379333`*^9, {3.792207866280402*^9, 
   3.792207873684909*^9}, {3.792270597728077*^9, 3.792270597728077*^9}, {
   3.792270895657544*^9, 3.792270895782504*^9}, {3.792271368045697*^9, 
   3.7922713738255787`*^9}, {3.7922722199672675`*^9, 3.792272227824782*^9}, 
   3.792538656565729*^9, 3.792538924313737*^9, {3.792538977710556*^9, 
   3.7925389876925745`*^9}, 3.792539078730129*^9, 3.7925391498539133`*^9, {
   3.7925532490372567`*^9, 3.792553269157399*^9}, {3.7925536620956464`*^9, 
   3.792553667672454*^9}, 3.7925537022735977`*^9, {3.792553890557179*^9, 
   3.7925538937751665`*^9}, {3.7925546404577494`*^9, 3.7925546465187893`*^9}, 
   3.7925547575953875`*^9, 3.7926551481604743`*^9, 3.802546774584007*^9, 
   3.802546806014125*^9, {3.8025471515108232`*^9, 3.802547153432208*^9}, {
   3.8025530095393133`*^9, 3.802553026457199*^9}, {3.8025532045714674`*^9, 
   3.802553229409363*^9}, 3.802553261038468*^9, 3.802553454664689*^9, {
   3.8025798431792006`*^9, 3.8025798457723475`*^9}, {3.8025800272037663`*^9, 
   3.802580027344387*^9}, {3.802582660552966*^9, 3.8025826638022027`*^9}, 
   3.8078545445533037`*^9, 3.8078546876419163`*^9, {3.807854721465523*^9, 
   3.8078547489939494`*^9}, 3.8078547791373887`*^9, {3.807855042242198*^9, 
   3.8078550464639173`*^9}, 3.816906024932904*^9, 3.816906211796054*^9, {
   3.8169062938236933`*^9, 3.816906310679119*^9}, 3.8169063942376285`*^9, 
   3.8169064881374598`*^9, 3.816906605547397*^9, {3.81690722223795*^9, 
   3.81690722739299*^9}, {3.816911790459921*^9, 3.816911790662994*^9}, {
   3.8208065113126163`*^9, 3.820806513952616*^9}, 3.8208066006040044`*^9, {
   3.8208066387668133`*^9, 3.820806640141487*^9}, {3.8208067180917654`*^9, 
   3.82080671859165*^9}, {3.8208068079142385`*^9, 3.820806816990216*^9}, 
   3.820807138147498*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.828286123457013*^9, {3.8282861747106113`*^9, 3.8282861989236813`*^9}, {
   3.828286440365247*^9, 3.8282864529248*^9}, {3.828553556846962*^9, 
   3.828553562587772*^9}, {3.828557128894436*^9, 3.8285571389096537`*^9}, {
   3.8285573314607916`*^9, 3.8285573321159925`*^9}, 3.828557376529271*^9, {
   3.8286360368995934`*^9, 3.828636050206417*^9}, 3.8286362099974976`*^9, 
   3.8286376533312335`*^9, 3.828718698781597*^9, {3.848257038638844*^9, 
   3.848257038638844*^9}, {3.8482571592822495`*^9, 3.8482571791525536`*^9}, 
   3.8482592259343624`*^9, {3.848259521700473*^9, 3.8482595244186172`*^9}, 
   3.848259575968937*^9, {3.848259744967764*^9, 3.848259748545044*^9}, {
   3.848259837688095*^9, 3.848259841812119*^9}, 3.848260108181464*^9, {
   3.8547617638692365`*^9, 3.8547617638848314`*^9}, 3.854761804515937*^9, 
   3.854761915152796*^9, {3.854762106815795*^9, 3.854762106987621*^9}, {
   3.8547621715706553`*^9, 3.854762191347271*^9}, {3.854762692983657*^9, 
   3.8547626933116884`*^9}, 3.8549110693034267`*^9, 3.883168548842718*^9, 
   3.883168591801283*^9, {3.8831693422177663`*^9, 3.883169342373979*^9}, 
   3.883170089065553*^9, {3.9565290756024103`*^9, 3.9565290756024103`*^9}, 
   3.956529277905364*^9, {3.9565293329237075`*^9, 3.956529358527069*^9}, 
   3.956529465626936*^9, {3.95652968441055*^9, 3.956529687425434*^9}, 
   3.956530150357442*^9, 3.956530343390212*^9, 3.9565304268131027`*^9, 
   3.956541558143319*^9, {3.956546649786872*^9, 3.956546668048131*^9}, {
   3.9565469418589067`*^9, 3.95654694610791*^9}, 3.956547118942315*^9, 
   3.956547186832667*^9, {3.9565482187887077`*^9, 3.956548219210427*^9}, 
   3.9568201607223616`*^9, 3.956820221973601*^9, 3.9568205889280415`*^9, 
   3.956820757482239*^9, 3.9568213450786924`*^9, 3.9568220623118396`*^9, 
   3.956822244362871*^9, 3.9568223369036546`*^9, 3.9568224586716013`*^9, 
   3.956822968772874*^9, 3.9569391135962825`*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0390.png\>\"", ",", "adpConfHypergeomFE2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.533955159803033*^9, 3.5339552034519095`*^9, 3.547008893618438*^9, 
   3.547008956314948*^9, {3.5501987477128153`*^9, 3.5501987478844156`*^9}, 
   3.5501988226865473`*^9, {3.550469306627704*^9, 3.5504693067681046`*^9}, 
   3.553114272723911*^9, 3.553114315530386*^9, 3.553114569972433*^9, 
   3.55318508843264*^9, {3.553185247131719*^9, 3.5531852473969193`*^9}, 
   3.5531900821741323`*^9, 3.55319015471426*^9, 3.5531908900479517`*^9, 
   3.5531909541796646`*^9, {3.553213790019997*^9, 3.5532138179752464`*^9}, {
   3.553214122440981*^9, 3.5532141511450315`*^9}, {3.556389578501213*^9, 
   3.556389578672813*^9}, 3.5563898772885375`*^9, {3.7325812073847427`*^9, 
   3.7325812080243435`*^9}, 3.7326535267504864`*^9, {3.732659119968313*^9, 
   3.732659120171114*^9}, {3.7326593137530546`*^9, 3.7326593214438686`*^9}, 
   3.740216750953225*^9, 3.740218228489431*^9, 3.740218990196377*^9, 
   3.74077860982647*^9, {3.740780605007178*^9, 3.7407806051787777`*^9}, 
   3.7407823021064887`*^9, {3.740795700305055*^9, 3.740795700539056*^9}, 
   3.7407957379479213`*^9, 3.7411140595270786`*^9, {3.7411141143767753`*^9, 
   3.741114114532776*^9}, 3.7411667457334538`*^9, {3.7411668447156277`*^9, 
   3.741166844871628*^9}, 3.74142115986131*^9, 3.744663700313615*^9, 
   3.744664379024007*^9, 3.7446656127845235`*^9, {3.7446659116810484`*^9, 
   3.744665911868249*^9}, 3.7452127175858293`*^9, {3.74521278093754*^9, 
   3.7452127811247406`*^9}, 3.7452152075218024`*^9, 3.7452154016881437`*^9, 
   3.7460519949503255`*^9, {3.7460520308459883`*^9, 3.74605203162599*^9}, 
   3.746055107834197*^9, 3.746991475479677*^9, {3.746991513918144*^9, 
   3.7469915424973946`*^9}, 3.746991645816376*^9, 3.748111177404529*^9, {
   3.748111322703184*^9, 3.748111322999585*^9}, 3.748112646147109*^9, {
   3.748113203645288*^9, 3.748113203988488*^9}, {3.7507167757248836`*^9, 
   3.7507167790164895`*^9}, 3.750716899963502*^9, {3.750907902190365*^9, 
   3.7509079301456137`*^9}, 3.75090826960221*^9, 3.751350024902258*^9, 
   3.7513500920135756`*^9, {3.7513503300387936`*^9, 3.751350330210394*^9}, 
   3.751400149651678*^9, {3.755049707478676*^9, 3.755049707634676*^9}, {
   3.755049765697978*^9, 3.75504976657158*^9}, 3.755049981945558*^9, 
   3.762283545821921*^9, 3.7622835936204047`*^9, 3.762283681510959*^9, 
   3.764280933902177*^9, 3.7642809906238766`*^9, {3.764281052961586*^9, 
   3.7642810835844398`*^9}, 3.7642811989934425`*^9, 3.764281290331603*^9, 
   3.764291454634307*^9, 3.7642915558472843`*^9, 3.7646644254065423`*^9, {
   3.7646645227819133`*^9, 3.7646645229067135`*^9}, {3.7648873755758543`*^9, 
   3.7648873757318544`*^9}, 3.764887973244104*^9, 3.7648894055102224`*^9, 
   3.765060231344472*^9, 3.765060779434235*^9, 3.7650876619491696`*^9, {
   3.7651708015085583`*^9, 3.7651708016333585`*^9}, 3.7651708746414866`*^9, 
   3.7652589118932266`*^9, {3.7652590299074335`*^9, 3.7652590301102343`*^9}, {
   3.7662195543382516`*^9, 3.766219578331094*^9}, 3.766219677016867*^9, 
   3.7662201983853827`*^9, 3.76647719987669*^9, 3.7664773392785344`*^9, 
   3.7664774867767935`*^9, 3.766477573559746*^9, 3.7666119106500444`*^9, {
   3.767393914938072*^9, 3.7673939150940723`*^9}, 3.7688458990076995`*^9, 
   3.768845992124263*^9, {3.7688460972060475`*^9, 3.768846097424448*^9}, 
   3.791925257442734*^9, {3.791926042673618*^9, 3.7919260678864145`*^9}, 
   3.7919411511491823`*^9, 3.7919412536874685`*^9, 3.7919455822489567`*^9, 
   3.791945613460332*^9, 3.7921427775327096`*^9, {3.7921442341379757`*^9, 
   3.7921442343566737`*^9}, 3.79214499129782*^9, {3.7921450432386465`*^9, 
   3.7921450433948555`*^9}, 3.7922066272150636`*^9, {3.7922081370131783`*^9, 
   3.7922081377629976`*^9}, 3.792270597728077*^9, {3.7922707124977846`*^9, 
   3.7922707126696568`*^9}, 3.792538656565729*^9, 3.792554019510995*^9, 
   3.802546808544753*^9, {3.8025468814650974`*^9, 3.802546882324236*^9}, 
   3.8025469199403934`*^9, 3.8025516303411865`*^9, {3.8025798413202734`*^9, 
   3.8025798500994525`*^9}, {3.80785445090362*^9, 3.8078544763037367`*^9}, 
   3.8078545477278557`*^9, 3.8169060294318476`*^9, 3.816906816785185*^9, 
   3.816906856635206*^9, 3.820806416772484*^9, 3.820806449655319*^9, 
   3.820806517936056*^9, {3.827874604494393*^9, 3.8278746309569407`*^9}, 
   3.8278748592717104`*^9, 3.8278748912173123`*^9, 3.828286639443576*^9, 
   3.848257038638844*^9, 3.848257074614698*^9, 3.848257111481027*^9, 
   3.854761763900452*^9, {3.8547618323859158`*^9, 3.854761855958494*^9}, {
   3.883168591801283*^9, 3.88316864422643*^9}, 3.9565290756180315`*^9, {
   3.9565292024855556`*^9, 3.9565292145296135`*^9}, 3.9565466482091475`*^9, 
   3.9565466883246565`*^9, 3.9568202219892225`*^9, 3.9568203068130665`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"rp3dConfHypergeomFE2", "=", "\[IndentingNewLine]", 
  RowBox[{"RePlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2000"}], ",", "2000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"3", " ", "\[Pi]"}], ",", "4"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.30"}], ",", 
       RowBox[{"-", "1.77"}], ",", "2.63"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"128", ",", "2"}], "}"}], ",", "24"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
         RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
       "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221349871864`*^9}, {3.533956562109496*^9, 3.533956663650075*^9}, 
   3.5339567557838364`*^9, 3.5347099882825756`*^9, 3.5347102657482634`*^9, {
   3.5347103008951254`*^9, 3.5347103043427315`*^9}, {3.535593994727907*^9, 
   3.535594052120408*^9}, {3.535594118654525*^9, 3.535594142257366*^9}, {
   3.53559417306742*^9, 3.5355941818346357`*^9}, {3.535594253173561*^9, 
   3.535594273141596*^9}, {3.535594308943659*^9, 3.535594311580064*^9}, {
   3.5355943417349167`*^9, 3.5355943446677217`*^9}, 3.5355944944279847`*^9, 
   3.5364644113098073`*^9, 3.547008961306957*^9, 3.547009174886932*^9, 
   3.5470100939009466`*^9, 3.5470101792522974`*^9, {3.547010219671968*^9, 
   3.5470102336495924`*^9}, {3.547010378308647*^9, 3.5470103791978483`*^9}, {
   3.5470106361019*^9, 3.547010661077544*^9}, 3.5501988290669584`*^9, 
   3.550199059994164*^9, 3.550199923226681*^9, {3.5501999833959866`*^9, 
   3.5501999880135946`*^9}, 3.5502073242848244`*^9, 3.5502076305611625`*^9, 
   3.5502077527405767`*^9, 3.550207824360303*^9, {3.5502086208227015`*^9, 
   3.5502086232251062`*^9}, 3.5502087333612995`*^9, {3.550210050393613*^9, 
   3.5502100620780334`*^9}, 3.5503471093742733`*^9, {3.5508011543922625`*^9, 
   3.5508011573094673`*^9}, 3.550801274574874*^9, 3.550828826075177*^9, 
   3.5531145222051487`*^9, 3.5531145764308443`*^9, 3.5531151448958426`*^9, {
   3.553115181758707*^9, 3.5531152194327736`*^9}, 3.5531152549228363`*^9, {
   3.553115444209176*^9, 3.5531154457847786`*^9}, 3.5531154834276447`*^9, 
   3.553184120965741*^9, 3.5531844553835287`*^9, 3.5531849288443604`*^9, {
   3.5531850323193417`*^9, 3.553185039214554*^9}, {3.5534455197643785`*^9, 
   3.5534455226191835`*^9}, {3.564290330151406*^9, 3.564290330151406*^9}, {
   3.564291249632621*^9, 3.5642913088503246`*^9}, {3.5642913587860126`*^9, 
   3.5642913874744625`*^9}, 3.5645701739454827`*^9, 3.56457022934118*^9, {
   3.5645704548083763`*^9, 3.564570523245696*^9}, 3.564632298359475*^9, 
   3.5672835710783267`*^9, 3.5672836098287945`*^9, 3.5672836500924654`*^9, 
   3.5672837096845703`*^9, {3.5672837599322586`*^9, 3.567283785797104*^9}, {
   3.567283815998757*^9, 3.567283882470474*^9}, 3.5672839294421563`*^9, 
   3.567283963200616*^9, 3.567749299701456*^9, 3.567802782394025*^9, 
   3.5678028822498007`*^9, {3.5681600327494287`*^9, 3.5681600592382755`*^9}, {
   3.568160109142763*^9, 3.5681601122315683`*^9}, 3.5681601467388287`*^9, {
   3.568160184319295*^9, 3.56816020424053*^9}, {3.568160517132702*^9, 
   3.568160596162441*^9}, 3.5681606610273547`*^9, {3.568160946421071*^9, 
   3.568160966030306*^9}, {3.5681705219146996`*^9, 3.5681705242703037`*^9}, 
   3.5681941899017687`*^9, 3.568194240352257*^9, 3.5700755677715073`*^9, 
   3.570075613354788*^9, 3.5700766540950155`*^9, {3.570086887572139*^9, 
   3.5700868877641497`*^9}, {3.570087003107747*^9, 3.570087005763899*^9}, {
   3.570087078020032*^9, 3.5700870989962316`*^9}, 3.5700872221102734`*^9, {
   3.57009623935571*^9, 3.570096282536586*^9}, 3.5736048119306808`*^9, 
   3.5736048904456186`*^9, 3.573604940833707*^9, {3.573605077677148*^9, 
   3.573605125865632*^9}, {3.5736051592964907`*^9, 3.573605161948496*^9}, {
   3.573605211119782*^9, 3.5736052136937866`*^9}, {3.5736052478578463`*^9, 
   3.5736052497922497`*^9}, 3.5736058726857443`*^9, 3.573605926771039*^9, {
   3.573605956925892*^9, 3.5736059886719475`*^9}, 3.573606090758527*^9, {
   3.5736061269973907`*^9, 3.57360615517104*^9}, {3.5736066713897743`*^9, 
   3.573606699345023*^9}, 3.573615836289501*^9, 3.57361605569005*^9, 
   3.5736161124242954`*^9, {3.5736161436740828`*^9, 3.5736161737138004`*^9}, 
   3.5736162263498116`*^9, {3.5736162577736087`*^9, 3.573616267602171*^9}, {
   3.573616444274276*^9, 3.5736164466824136`*^9}, {3.574885927166521*^9, 
   3.5748859637953854`*^9}, {3.5748860508435383`*^9, 
   3.5748860521695404`*^9}, {3.5748861157240524`*^9, 3.574886117252855*^9}, 
   3.57577235924708*^9, 3.5757724099589806`*^9, 3.575772445279001*^9, {
   3.5757724785189023`*^9, 3.5757724925687056`*^9}, {3.575772607702291*^9, 
   3.575772651454794*^9}, {3.5759741600893764`*^9, 3.575974161493379*^9}, {
   3.575974199510646*^9, 3.5759742220370855`*^9}, 3.576873240797937*^9, {
   3.5768733189384737`*^9, 3.576873344428919*^9}, {3.576873425346261*^9, 
   3.5768734529895096`*^9}, {3.576873485281566*^9, 3.5768734895091734`*^9}, {
   3.576873525514037*^9, 3.576873525701237*^9}, {3.577055332882147*^9, 
   3.5770553361425524`*^9}, 3.577871528638734*^9, {3.5778716843606405`*^9, 
   3.577871704824811*^9}, 3.5778717538886175`*^9, {3.5778718288889074`*^9, 
   3.577871876976658*^9}, {3.5778719113366227`*^9, 3.577871931008748*^9}, 
   3.577996382595691*^9, 3.5779973953859024`*^9, 3.577997497659682*^9, {
   3.592182738830336*^9, 3.592182738830336*^9}, 3.592182940881891*^9, 
   3.592183011815215*^9, {3.5921894364524994`*^9, 3.592189460086541*^9}, {
   3.592189491785797*^9, 3.592189494235001*^9}, {3.5921895481018953`*^9, 
   3.592189608177601*^9}, 3.592189794161128*^9, 3.5921898423808126`*^9, 
   3.5993883891423397`*^9, {3.5993886376195765`*^9, 3.5993886707696347`*^9}, 
   3.5993887338093452`*^9, 3.599388787067839*^9, 3.5993898053488283`*^9, 
   3.599450646030573*^9, 3.6063523737093935`*^9, {3.6063536327884064`*^9, 
   3.606353657155649*^9}, {3.6063536884961042`*^9, 3.606353715281351*^9}, {
   3.6063541082884493`*^9, 3.606354110690853*^9}, {3.606354174463765*^9, 
   3.6063541934333982`*^9}, 3.606354233681469*^9, {3.606354327624834*^9, 
   3.6063543393872547`*^9}, {3.6063554596717415`*^9, 3.606355469234558*^9}, {
   3.6063556589152913`*^9, 3.6063556888517437`*^9}, {3.6063559489462013`*^9, 
   3.60635597109824*^9}, {3.606356372177745*^9, 3.606356383128964*^9}, {
   3.6063564284002438`*^9, 3.606356435435856*^9}, 3.606356488460349*^9, {
   3.606356550096057*^9, 3.606356592091331*^9}, 3.606362300175032*^9, 
   3.606364095238985*^9, 3.6063646120054927`*^9, {3.606424049973319*^9, 
   3.606424053639326*^9}, 3.6064240927485943`*^9, 3.6064350337292786`*^9, 
   3.6253066892819157`*^9, 3.625306727517583*^9, {3.6253071403575087`*^9, 
   3.625307143961115*^9}, 3.6253071830235834`*^9, 3.625307214270438*^9, 
   3.62530768864248*^9, {3.625307721074937*^9, 3.6253077378137665`*^9}, {
   3.6253078152835026`*^9, 3.625307818465908*^9}, 3.6253078603831816`*^9, 
   3.625308042795102*^9, {3.625308091591988*^9, 3.6253080991112013`*^9}, {
   3.625383389886337*^9, 3.625383390822338*^9}, 3.6253834238787966`*^9, 
   3.6291871861181545`*^9, 3.629187255195076*^9, {3.629187298329152*^9, 
   3.629187319170789*^9}, 3.629187721281896*^9, {3.629187761576767*^9, 
   3.629187773105187*^9}, 3.629187853476528*^9, {3.629189386050821*^9, 
   3.6291893870960226`*^9}, 3.6294129792897773`*^9, {3.629681940821416*^9, 
   3.629681967825063*^9}, 3.6296830652981987`*^9, {3.629683828638739*^9, 
   3.629683873535618*^9}, 3.6296840724983673`*^9, 3.629684659074998*^9, {
   3.6296848918274064`*^9, 3.629684894619811*^9}, 3.630130105717137*^9, 
   3.6301868115768538`*^9, 3.6301913486360464`*^9, {3.6301914399118066`*^9, 
   3.630191440754208*^9}, {3.6301915173347425`*^9, 3.630191517662343*^9}, {
   3.630191564462425*^9, 3.6301915646184254`*^9}, 3.6301916235085287`*^9, 
   3.6301916648486013`*^9, {3.6301916949722548`*^9, 3.630191743254339*^9}, 
   3.630192498482866*^9, 3.630224013755659*^9, 3.6325489583565407`*^9, 
   3.6325493465892234`*^9, 3.6325495969920783`*^9, 3.6325497909544272`*^9, {
   3.6325499065150375`*^9, 3.6325499323798833`*^9}, {3.6326039905906425`*^9, 
   3.6326039969398537`*^9}, {3.6326052476784515`*^9, 3.6326052678180866`*^9}, 
   3.632789691264064*^9, {3.632789738937748*^9, 3.632789739811349*^9}, {
   3.632789771198604*^9, 3.63278978590943*^9}, 3.632789880617196*^9, 
   3.6327899977890024`*^9, 3.63279813902344*^9, 3.632798262731657*^9, 
   3.632807713384465*^9, 3.6328077532581353`*^9, {3.632813931449418*^9, 
   3.6328140063139496`*^9}, {3.632814038262806*^9, 3.632814038481206*^9}, {
   3.6328142150367174`*^9, 3.632814235581953*^9}, {3.632862829136717*^9, 
   3.6328628333643246`*^9}, 3.632863060297923*^9, 3.6328903848425245`*^9, 
   3.6345039605706234`*^9, 3.6345039979950895`*^9, 3.634505028388706*^9, {
   3.634505073659986*^9, 3.634505094844823*^9}, {3.6345051346835*^9, 
   3.6345051909059987`*^9}, {3.634505248002099*^9, 3.6345052831177607`*^9}, 
   3.6345058717026*^9, {3.6345559035261827`*^9, 3.6345559061157875`*^9}, {
   3.634555945349856*^9, 3.634555948313861*^9}, 3.634556202246708*^9, {
   3.6360748453404164`*^9, 3.6360748476336203`*^9}, 3.636075402244196*^9, 
   3.6360755387756352`*^9, 3.6360756646834564`*^9, 3.636076028008095*^9, 
   3.6360760583769555`*^9, {3.6360761965931983`*^9, 3.6360762071856165`*^9}, 
   3.6364953485684733`*^9, 3.6364953884889436`*^9, 3.636495515816367*^9, 
   3.6364955598396444`*^9, 3.63649577777445*^9, {3.6364958118137093`*^9, 
   3.636495860766596*^9}, 3.636495993039228*^9, 3.636496147385899*^9, {
   3.636496214996418*^9, 3.636496253372485*^9}, 3.6364964311815977`*^9, {
   3.6364969697417445`*^9, 3.6364969814261646`*^9}, {3.636762383421364*^9, 
   3.6367623872745705`*^9}, 3.725592441562623*^9, 3.7255925278151746`*^9, 
   3.7255944795378036`*^9, {3.72559451145546*^9, 3.7255945146846657`*^9}, 
   3.7255953568521447`*^9, 3.725595801020926*^9, 3.725595862875035*^9, 
   3.725596145750332*^9, 3.72559634416708*^9, 3.7255964017623816`*^9, {
   3.725600882543482*^9, 3.725600909469129*^9}, 3.725601380552758*^9, 
   3.725771260842998*^9, {3.725774253989055*^9, 3.725774282505905*^9}, {
   3.725774385294486*^9, 3.725774424243362*^9}, {3.7257804563043575`*^9, 
   3.7257804693615804`*^9}, 3.7258490252477674`*^9, 3.7258521016447725`*^9, 
   3.725852258877449*^9, 3.725852363803233*^9, 3.7258524000108967`*^9, 
   3.725852749623111*^9, {3.7258530098159676`*^9, 3.7258530484884357`*^9}, {
   3.7258533935578427`*^9, 3.7258534235566955`*^9}, {3.725853537717696*^9, 
   3.725853546578511*^9}, 3.726913461460272*^9, {3.7269135067003517`*^9, 
   3.726913506715952*^9}, 3.726913573655669*^9, 3.7269142247852125`*^9, {
   3.726914355279442*^9, 3.726914372969873*^9}, 3.7269144359471836`*^9, 
   3.7269145160221243`*^9, 3.726914654581568*^9, 3.726914723206088*^9, {
   3.7269151216475897`*^9, 3.726915129884404*^9}, 3.726915517287485*^9, {
   3.726942972603111*^9, 3.7269429731335115`*^9}, 3.726952629442474*^9, 
   3.7269527024818025`*^9, {3.7325814358471437`*^9, 3.732581510446475*^9}, 
   3.7325815475277395`*^9, {3.7326584462775297`*^9, 3.732658472844376*^9}, {
   3.732658943126403*^9, 3.732658966682444*^9}, 3.7326593293998823`*^9, 
   3.732668442777998*^9, {3.7402181611597123`*^9, 3.740218186072956*^9}, 
   3.740218232124237*^9, {3.7402183905893154`*^9, 3.7402183918841176`*^9}, 
   3.740218439771809*^9, 3.7402184717362657`*^9, {3.740218744752345*^9, 
   3.740218755048363*^9}, {3.7402188877977967`*^9, 3.740218953427112*^9}, {
   3.7402206710333304`*^9, 3.740220709690198*^9}, 3.740623517482953*^9, {
   3.740778612338074*^9, 3.740778614194477*^9}, {3.740778697514224*^9, 
   3.740778713769452*^9}, {3.7407792507571983`*^9, 3.740779281707652*^9}, {
   3.7407793154973116`*^9, 3.7407793317681403`*^9}, {3.74077962170185*^9, 
   3.740779646209493*^9}, 3.7407805331690516`*^9, 3.7407805721691203`*^9, 
   3.7407807771378803`*^9, 3.7407824673731785`*^9, 3.740784298882004*^9, 
   3.740784367336528*^9, 3.7407845511906676`*^9, 3.7407847911139035`*^9, 
   3.740785320891444*^9, {3.740792222878537*^9, 3.74079222451654*^9}, 
   3.740795734391115*^9, 3.7407958434197063`*^9, 3.7407962499408207`*^9, 
   3.740796287817687*^9, 3.7407968561734858`*^9, 3.7407968980127587`*^9, {
   3.7411140633022857`*^9, 3.741114065189889*^9}, 3.7411141817688937`*^9, {
   3.7411142451362047`*^9, 3.7411142815778685`*^9}, {3.7411143643984146`*^9, 
   3.741114394927668*^9}, 3.741114449028563*^9, 3.741165053951681*^9, 
   3.7411667429098487`*^9, 3.741166800005949*^9, 3.741167002587905*^9, 
   3.7418927044966946`*^9, 3.744663705024823*^9, 3.744664181730461*^9, 
   3.7446656128001237`*^9, 3.7446656519405923`*^9, 3.7447503917826357`*^9, 
   3.744875558139942*^9, 3.745212724418641*^9, 3.7452130520192165`*^9, 
   3.7452134415987005`*^9, {3.7452134772759633`*^9, 3.745213477884364*^9}, 
   3.745213581842947*^9, 3.745213760572461*^9, {3.7452137926617174`*^9, 
   3.7452138142521553`*^9}, {3.7452138718318567`*^9, 3.745213901846309*^9}, 
   3.74521397072043*^9, {3.7452140044788895`*^9, 3.745214017692113*^9}, {
   3.745215374934097*^9, 3.745215398848939*^9}, 3.745215733004327*^9, {
   3.745215869754167*^9, 3.74521587134537*^9}, {3.7452159052910295`*^9, 
   3.7452159092066364`*^9}, {3.745215982604765*^9, 3.7452159998115954`*^9}, 
   3.7452162565100465`*^9, 3.74605199750873*^9, {3.7460524917799983`*^9, 
   3.7460525007812138`*^9}, 3.7460544899795113`*^9, 3.74605461420253*^9, {
   3.746054731577136*^9, 3.746054777706417*^9}, {3.7460548234768972`*^9, 
   3.7460548417133293`*^9}, 3.746054911461052*^9, 3.7469916527895885`*^9, 
   3.746995583616094*^9, 3.7469956167661524`*^9, {3.7469957258615446`*^9, 
   3.7469957275151477`*^9}, {3.746995760977206*^9, 3.746995762147208*^9}, {
   3.7469958133464985`*^9, 3.746995836512539*^9}, 3.746995880816617*^9, {
   3.7469959276946993`*^9, 3.746995931984707*^9}, {3.7470008112785206`*^9, 
   3.7470008135717244`*^9}, {3.7470008798094406`*^9, 3.747000881369444*^9}, {
   3.747027563106309*^9, 3.74702756362111*^9}, {3.747028030906732*^9, 
   3.747028033511936*^9}, 3.7481111814917364`*^9, 3.7481112473238516`*^9, 
   3.748111472572647*^9, 3.748111511900316*^9, 3.748111751157937*^9, 
   3.7481117965072165`*^9, 3.748111837706889*^9, 3.7481119389198666`*^9, 
   3.748112002271578*^9, 3.7481126431207037`*^9, 3.7481127702141266`*^9, 
   3.748112890599538*^9, 3.748112975042486*^9, {3.748113023496172*^9, 
   3.748113025196574*^9}, 3.748113104850314*^9, 3.7481148783458304`*^9, 
   3.748152378124942*^9, 3.748156761576641*^9, 3.749668426627076*^9, 
   3.7507169093079185`*^9, {3.750717434654441*^9, 3.7507174520016713`*^9}, 
   3.7507179985374317`*^9, 3.7507180693303566`*^9, 3.750718107222823*^9, {
   3.750718237732652*^9, 3.7507182378574524`*^9}, 3.750718351924853*^9, {
   3.750719888347952*^9, 3.75071989302796*^9}, 3.75072066733372*^9, 
   3.750724214763152*^9, 3.7507255977531834`*^9, 3.7507440011381135`*^9, {
   3.7507441014618897`*^9, 3.7507441048314953`*^9}, 3.7511831548137474`*^9, 
   3.7511832008026285`*^9, {3.751189420749557*^9, 3.7511894221223593`*^9}, {
   3.751189545112975*^9, 3.7511895500581837`*^9}, {3.751191026389179*^9, 
   3.751191036263996*^9}, {3.7511922279880896`*^9, 3.75119225077973*^9}, {
   3.7512741081272516`*^9, 3.7512741083924522`*^9}, 3.751343680793913*^9, {
   3.7513437352380085`*^9, 3.751343748076831*^9}, {3.751343859991428*^9, 
   3.7513438704746466`*^9}, 3.751343972284826*^9, {3.751344206045637*^9, 
   3.751344228946477*^9}, {3.751345479654274*^9, 3.751345479669874*^9}, 
   3.7513458163340654`*^9, {3.7513459501355004`*^9, 3.751345950946702*^9}, 
   3.751346259250044*^9, {3.75134772036421*^9, 3.751347750955864*^9}, {
   3.7513478386904173`*^9, 3.7513478502656384`*^9}, {3.7513480264523478`*^9, 
   3.7513480387451687`*^9}, {3.751356659578311*^9, 3.7513566652723207`*^9}, {
   3.7513584868487215`*^9, 3.751358487051522*^9}, {3.7513587764620385`*^9, 
   3.7513587766960387`*^9}, 3.751359217521613*^9, 3.755049981961158*^9, 
   3.755050081910534*^9, 3.7550501621414747`*^9, {3.7550504076079054`*^9, 
   3.7550504105563107`*^9}, 3.755050934296031*^9, 3.7550519317455764`*^9, {
   3.7550519933656845`*^9, 3.7550521232671127`*^9}, 3.7550521578835735`*^9, 
   3.755061383808256*^9, 3.755137961376438*^9, {3.7551380194709396`*^9, 
   3.755138043448182*^9}, 3.7551380790006447`*^9, {3.755138180494423*^9, 
   3.7551382149704833`*^9}, 3.7551383199274673`*^9, {3.7551384479880924`*^9, 
   3.755138485646559*^9}, {3.7551385328522415`*^9, 3.755138535301446*^9}, {
   3.7551388552780085`*^9, 3.755138867898431*^9}, {3.755138899379286*^9, 
   3.755138900923689*^9}, {3.755141473017996*^9, 3.7551414735015965`*^9}, 
   3.7551423127060127`*^9, 3.755143428371771*^9, {3.7551475899709272`*^9, 
   3.7551475974589405`*^9}, {3.755147763630432*^9, 3.755147798215693*^9}, 
   3.7552236306629615`*^9, 3.7552237351007524`*^9, {3.7552274948275833`*^9, 
   3.7552275018475957`*^9}, 3.7642903579671755`*^9, {3.7642905351382875`*^9, 
   3.764290614448827*^9}, 3.764290670343725*^9, {3.7642907227754173`*^9, 
   3.7642907831007233`*^9}, {3.764290822865193*^9, 3.7642908322408094`*^9}, 
   3.7642909401461987`*^9, {3.76429097484066*^9, 3.764290976041862*^9}, 
   3.764291199136257*^9, {3.7642913149984617`*^9, 3.7642913174008656`*^9}, 
   3.7642916029593673`*^9, 3.764302351074251*^9, 3.7643023945203276`*^9, 
   3.764304227843149*^9, 3.7643178515372825`*^9, 3.76432045498466*^9, 
   3.764370158357931*^9, 3.7643729553032446`*^9, {3.764374606185746*^9, 
   3.764374606466547*^9}, 3.7643849800828085`*^9, 3.764385335676648*^9, {
   3.7646681230006466`*^9, 3.764668147102689*^9}, {3.764668200189582*^9, 
   3.764668201515584*^9}, {3.764668246396863*^9, 3.764668249766469*^9}, 
   3.764668283384528*^9, 3.7646685415805817`*^9, 3.764887973275304*^9, 
   3.764888009139767*^9, 3.7648889009273357`*^9, {3.764890388914151*^9, 
   3.7648904010509725`*^9}, {3.764890438990239*^9, 3.764890439130639*^9}, 
   3.7648906343181825`*^9, 3.76489671665236*^9, 3.7650607837398424`*^9, 
   3.7651708746570864`*^9, 3.7651709275255795`*^9, {3.7651715865911446`*^9, 
   3.7651716002099686`*^9}, {3.765172130556101*^9, 3.7651721436133237`*^9}, 
   3.765258860522336*^9, 3.7652589119088264`*^9, 3.765267845342927*^9, 
   3.766219677032467*^9, 3.766219733644967*^9, 3.766220205062195*^9, 
   3.766224732047748*^9, {3.766371669949203*^9, 3.766371670120803*^9}, {
   3.7664771998922896`*^9, 3.7664772214515276`*^9}, {3.7664774867767935`*^9, 
   3.7664775002396173`*^9}, {3.768845899023299*^9, 3.768845913219324*^9}, {
   3.7688464421018543`*^9, 3.7688464430066557`*^9}, {3.768846907500272*^9, 
   3.768846908498674*^9}, {3.7756127056776414`*^9, 3.7756127085636463`*^9}, 
   3.7919252574583597`*^9, 3.791925346562312*^9, 3.7919254153117027`*^9, {
   3.7919255247077045`*^9, 3.791925531253033*^9}, 3.791925598002926*^9, {
   3.791925817141368*^9, 3.791925857178751*^9}, {3.7919259309425774`*^9, 
   3.791925933801317*^9}, {3.7919260057136*^9, 3.791926009212773*^9}, {
   3.79192660049582*^9, 3.7919266190539074`*^9}, {3.7919271891237907`*^9, 
   3.7919272245842*^9}, {3.7919274867894063`*^9, 3.791927489554371*^9}, {
   3.791927538745885*^9, 3.791927604824026*^9}, {3.7919283206321373`*^9, 
   3.791928328770767*^9}, 3.7919283681131506`*^9, 3.791941147556281*^9, 
   3.791941226943779*^9, {3.791943064803152*^9, 3.791943072441972*^9}, 
   3.7919455853419733`*^9, 3.7919456390636563`*^9, 3.7919457301594105`*^9, {
   3.7919460176571693`*^9, 3.791946064630477*^9}, 3.7919462776270447`*^9, {
   3.7919463420805435`*^9, 3.7919463444393888`*^9}, {3.791948507232851*^9, 
   3.7919485077639413`*^9}, 3.7921427775327096`*^9, 3.7921428813674984`*^9, {
   3.7921430077438335`*^9, 3.7921430285982695`*^9}, {3.792143075102886*^9, 
   3.792143196527261*^9}, 3.7921432320813465`*^9, {3.7921435108289423`*^9, 
   3.7921435112507515`*^9}, {3.792144994000306*^9, 3.7921450236495314`*^9}, 
   3.7921450984755683`*^9, {3.792145135779237*^9, 3.7921451459487057`*^9}, 
   3.7921451813309965`*^9, {3.7921455405896435`*^9, 3.792145540823963*^9}, {
   3.792184495223648*^9, 3.7921844998788123`*^9}, {3.792184623771303*^9, 
   3.7921846334096813`*^9}, {3.792206627230712*^9, 3.792206627230712*^9}, 
   3.7922067487800713`*^9, {3.792206857551155*^9, 3.7922068652212453`*^9}, 
   3.79220731139717*^9, 3.7922074804352627`*^9, {3.792207911722797*^9, 
   3.792207920220762*^9}, 3.7922106315283227`*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709234165945`*^9, 3.7922709273375435`*^9}, 
   3.7922709952589617`*^9, 3.792271044919084*^9, {3.7922714000850353`*^9, 
   3.7922714133162184`*^9}, {3.79227225780206*^9, 3.7922722845301075`*^9}, 
   3.7922726379453006`*^9, 3.792538656581356*^9, 3.792538928359619*^9, {
   3.79253897772618*^9, 3.7925389929881973`*^9}, 3.792539105239499*^9, 
   3.7925391544309196`*^9, {3.7925392146979003`*^9, 3.7925392318501225`*^9}, {
   3.792553251880274*^9, 3.7925533135219245`*^9}, {3.792553558651388*^9, 
   3.7925535983294907`*^9}, 3.7925536300406995`*^9, 3.792553977661547*^9, 
   3.7934110765855913`*^9, 3.802546778036353*^9, 3.8025468148870387`*^9, 
   3.802552822458405*^9, {3.8025530544662237`*^9, 3.8025530844279113`*^9}, {
   3.802553133713169*^9, 3.8025531354783773`*^9}, {3.8025532097421217`*^9, 
   3.8025532578048534`*^9}, {3.802553588023881*^9, 3.802553607941058*^9}, {
   3.8025798334471254`*^9, 3.802579836009097*^9}, 3.8025799428439727`*^9, 
   3.8025826954822035`*^9, 3.807854554258397*^9, 3.807854690828374*^9, {
   3.8078547263903584`*^9, 3.8078547526052713`*^9}, {3.8078547973826*^9, 
   3.8078548259492536`*^9}, 3.807854857290492*^9, {3.807855065442194*^9, 
   3.8078550755771074`*^9}, 3.816906042506902*^9, 3.8169062174197626`*^9, {
   3.8169062961825204`*^9, 3.8169063081953278`*^9}, 3.8169064017358685`*^9, 
   3.8169064565355053`*^9, {3.816906506133236*^9, 3.816906533095647*^9}, 
   3.8169065818185563`*^9, 3.816906741702897*^9, 3.8169069030617733`*^9, 
   3.816911863808765*^9, {3.820806523044219*^9, 3.820806525543599*^9}, {
   3.820806605337228*^9, 3.820806634720892*^9}, {3.820806728870463*^9, 
   3.8208067606910887`*^9}, 3.8208068514664154`*^9, 3.8208068887857084`*^9, {
   3.820806986417849*^9, 3.820806992557019*^9}, 3.820807050543249*^9, 
   3.8208071575179443`*^9, {3.827874604494393*^9, 3.8278746309725633`*^9}, 
   3.828286126815601*^9, 3.828286178522227*^9, {3.8282862114207487`*^9, 
   3.828286249083788*^9}, 3.8282862800765343`*^9, {3.828286322644653*^9, 
   3.828286322972701*^9}, {3.828286357931463*^9, 3.828286378520382*^9}, 
   3.828286413949597*^9, 3.8282865511517544`*^9, 3.828849014384474*^9, {
   3.8482570386544743`*^9, 3.8482570386544743`*^9}, {3.848257162547103*^9, 
   3.8482572050995564`*^9}, 3.8482572474489293`*^9, 3.8482592289492965`*^9, 
   3.8482592632131195`*^9, 3.8482593480525*^9, {3.8482596406568003`*^9, 
   3.848259662354802*^9}, {3.8482598575520773`*^9, 3.848259863863089*^9}, {
   3.848259935769012*^9, 3.848259938174694*^9}, {3.848260033511561*^9, 
   3.8482600702372885`*^9}, {3.848260636230188*^9, 3.848260666894863*^9}, 
   3.8482606989966545`*^9, 3.8482607541243086`*^9, {3.8547617639317226`*^9, 
   3.854761763947344*^9}, 3.854761807093421*^9, {3.854761939287712*^9, 
   3.854761948035654*^9}, {3.854762215597452*^9, 3.8547622692588873`*^9}, {
   3.8547623089584866`*^9, 3.854762311739122*^9}, {3.8547623431746674`*^9, 
   3.854762363654195*^9}, 3.854763519987254*^9, 3.8831684261211495`*^9, 
   3.883168549077005*^9, 3.8831685918169317`*^9, {3.883169007296896*^9, 
   3.88316901865359*^9}, 3.883169538507764*^9, 3.8831706590004115`*^9, 
   3.883170863795307*^9, {3.9565290756180315`*^9, 3.9565290756180315`*^9}, 
   3.9565292781396837`*^9, {3.9565293331424026`*^9, 3.9565293645100403`*^9}, 
   3.9565294692042217`*^9, 3.956529507929509*^9, {3.9565295473808737`*^9, 
   3.9565295677979517`*^9}, {3.9565297430061445`*^9, 
   3.9565297484892626`*^9}, {3.956529847778465*^9, 3.956529900063098*^9}, {
   3.9565301658693733`*^9, 3.956530172289773*^9}, 3.9565304532600217`*^9, {
   3.956546645162876*^9, 3.956546671516094*^9}, {3.956547099525032*^9, 
   3.9565471318611584`*^9}, {3.9565471656188617`*^9, 
   3.9565471910504293`*^9}, {3.9565482301141186`*^9, 
   3.9565482547333107`*^9}, {3.956555971195315*^9, 3.9565559740540113`*^9}, 
   3.9568201609254336`*^9, 3.9568202219892225`*^9, 3.9568205920678988`*^9, {
   3.9568207686046295`*^9, 3.956820784007287*^9}, {3.956821357013421*^9, 
   3.95682136054381*^9}, 3.956821498865943*^9, 3.9568215744575844`*^9, 
   3.956822064951847*^9, 3.9568222332404814`*^9, 3.956822975193245*^9}],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<240_0400.png\>\"", ",", "rp3dConfHypergeomFE2", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "400"}]}], "]"}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{
  3.5339551667918453`*^9, 3.5339552009091053`*^9, 3.5470088969568434`*^9, 
   3.5470089640057616`*^9, {3.5501987513788223`*^9, 3.550198751410022*^9}, 
   3.5501988321245637`*^9, {3.5504693115261126`*^9, 3.550469311666513*^9}, 
   3.5531142779343195`*^9, 3.5531143119735794`*^9, 3.5531145798316503`*^9, 
   3.55318508241103*^9, {3.55318525330933*^9, 3.5531852534809303`*^9}, 
   3.553190085153738*^9, 3.553190157912266*^9, 3.553190885227544*^9, {
   3.553190960606876*^9, 3.5531909607628765`*^9}, {3.5532137942008047`*^9, 
   3.553213813825639*^9}, {3.55321412771379*^9, 3.553214156714241*^9}, {
   3.556389588766031*^9, 3.5563895889376307`*^9}, 3.5563898811573443`*^9, {
   3.7325812234839706`*^9, 3.7325812239051714`*^9}, 3.7326535205260754`*^9, {
   3.7326591250071225`*^9, 3.7326591252255225`*^9}, 3.732659348416316*^9, 
   3.7402167509688253`*^9, 3.740218234479841*^9, 3.740218993768783*^9, 
   3.740778618671685*^9, {3.7407806106543875`*^9, 3.740780610810388*^9}, {
   3.740782307394898*^9, 3.7407823078160987`*^9}, {3.7407957072626677`*^9, 
   3.740795732191511*^9}, 3.7411140683254943`*^9, {3.7411141195091844`*^9, 
   3.7411141197119846`*^9}, 3.7411667406790447`*^9, {3.7411668525936413`*^9, 
   3.7411668526872416`*^9}, {3.7414211411412773`*^9, 3.7414211413128777`*^9}, 
   3.7446637082540293`*^9, {3.744664383891216*^9, 3.7446643841564164`*^9}, 
   3.7446656128001237`*^9, {3.744665919325062*^9, 3.7446659194654617`*^9}, 
   3.745212728256248*^9, {3.7452127863195496`*^9, 3.7452127865379505`*^9}, 
   3.745215210719808*^9, 3.7452153969769354`*^9, 3.7460519999891343`*^9, {
   3.7460520390048027`*^9, 3.746052039628804*^9}, 3.7460551110166025`*^9, 
   3.7469914786308823`*^9, {3.7469915178025513`*^9, 3.746991547068203*^9}, 
   3.7469916572823963`*^9, 3.7481111850173426`*^9, {3.7481113291771955`*^9, 
   3.748111329348796*^9}, 3.7481126410927*^9, 3.7481132104469*^9, {
   3.750716795334118*^9, 3.7507167978769226`*^9}, 3.750716914752328*^9, 
   3.750907902205965*^9, {3.7509079354808235`*^9, 3.750907935777224*^9}, 
   3.7509082696178102`*^9, 3.751350024917858*^9, 3.7513500920135756`*^9, {
   3.751350335186803*^9, 3.7513503353740034`*^9}, 3.7514001537856855`*^9, {
   3.7550497020342665`*^9, 3.755049702159066*^9}, {3.755049780455604*^9, 
   3.7550497817660065`*^9}, 3.755049981961158*^9, 3.7622835534347343`*^9, 
   3.7622835983940134`*^9, 3.7622836925245786`*^9, 3.7642809470685997`*^9, 
   3.764280993650282*^9, {3.764281062056402*^9, 3.7642810876404467`*^9}, 
   3.7642812103970623`*^9, {3.7642812957916126`*^9, 3.764281295994413*^9}, 
   3.7642914608743176`*^9, 3.7642915591544905`*^9, 3.764664425437742*^9, {
   3.7646645337331324`*^9, 3.7646645339047327`*^9}, {3.7648873895846786`*^9, 
   3.764887389771879*^9}, 3.764887973275304*^9, 3.764889411126232*^9, 
   3.765060236898082*^9, 3.7650607861422467`*^9, {3.765087671387186*^9, 
   3.7650876715275865`*^9}, {3.7651708114457755`*^9, 3.765170811664176*^9}, 
   3.7651708746570864`*^9, 3.765258911924426*^9, {3.765259045601061*^9, 
   3.7652590457882614`*^9}, {3.766219554353852*^9, 3.766219582964302*^9}, 
   3.766219677032467*^9, 3.7662202070277977`*^9, 3.7664771998922896`*^9, 
   3.7664773392785344`*^9, 3.7664774867923937`*^9, 3.766477573575346*^9, 
   3.766611931678881*^9, {3.7673939264508924`*^9, 3.767393926622493*^9}, 
   3.768845899023299*^9, 3.768845992139863*^9, 3.7688461046784606`*^9, 
   3.791925257473979*^9, 3.7919260459384813`*^9, {3.791926076384407*^9, 
   3.791926077056122*^9}, 3.7919411447288256`*^9, 3.7919412585144467`*^9, {
   3.791945587700791*^9, 3.7919456092894487`*^9}, 3.7921427775327096`*^9, {
   3.7921442396836076`*^9, 3.7921442398866467`*^9}, 3.7921449966246824`*^9, {
   3.7921450490810156`*^9, 3.792145049205987*^9}, 3.792206627230712*^9, {
   3.792208145964188*^9, 3.7922081471983175`*^9}, 3.7922705977436914`*^9, {
   3.7922707178871346`*^9, 3.792270718027725*^9}, 3.792538656581356*^9, 
   3.792554025353397*^9, 3.8025468178550973`*^9, {3.8025468885259333`*^9, 
   3.802546916941086*^9}, 3.8025516349182377`*^9, {3.8025798245429773`*^9, 
   3.8025798309477167`*^9}, 3.8078544471885157`*^9, {3.807854484527757*^9, 
   3.8078544851420836`*^9}, 3.8078545576323867`*^9, 3.8169060469746084`*^9, 
   3.8169068200344243`*^9, 3.816906860056246*^9, 3.8208064231928377`*^9, 
   3.82080645710668*^9, 3.8208065296052046`*^9, {3.827874604510014*^9, 
   3.8278746309725633`*^9}, 3.8278748592717104`*^9, 3.827874904026807*^9, 
   3.828286644676685*^9, 3.8482570386544743`*^9, 3.8482570746303196`*^9, 
   3.8482571201821003`*^9, 3.854761763962966*^9, {3.8547618360100236`*^9, 
   3.8547618598794146`*^9}, {3.883168591832553*^9, 3.8831686183106723`*^9}, {
   3.883168650240633*^9, 3.883168650334363*^9}, 3.9565290756336536`*^9, {
   3.9565292024855556`*^9, 3.9565292194190598`*^9}, 3.9565466431633916`*^9, {
   3.956546692776702*^9, 3.9565466929485703`*^9}, 3.9568202219892225`*^9, 
   3.9568202987211885`*^9},
 Background->GrayLevel[0.900008]],

Cell[BoxData[
 RowBox[{"ip3dConfHypergeomFE2", "=", "\[IndentingNewLine]", 
  RowBox[{"ImPlot3D", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Exp", "[", 
     RowBox[{
      RowBox[{"-", "2.4"}], ",", 
      RowBox[{"-", "0.7"}], ",", "z"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "\[Pi]", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2000"}], ",", "2000"}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"280", ",", "630"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
    RowBox[{"BoxRatios", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"3", " ", "\[Pi]"}], ",", "4"}], "}"}]}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.30"}], ",", 
       RowBox[{"-", "1.77"}], ",", "2.63"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Linear\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ReContours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Logarithm\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"128", ",", "2"}], "}"}], ",", "24"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ClippingPlane", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Re(z)\>\"", ",", "\"\<Im(z)\>\"", ",", "None"}], "}"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ContoursThickness", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.0009", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.0006", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Ticks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[Pi]"}], ",", 
         RowBox[{"3", " ", "\[Pi]"}], ",", "\[Pi]"}], "]"}], ",", 
       "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"FontSize", "\[Rule]", "10"}], ")"}]}], ",", 
    RowBox[{"TicksStyle", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.528535250407896*^9, 3.528535461772667*^9}, {
   3.528535505998745*^9, 3.528535506622746*^9}, {3.528593875220598*^9, 
   3.528593992798005*^9}, {3.5285940247468605`*^9, 3.52859412669304*^9}, {
   3.5285947016184196`*^9, 3.528594820459429*^9}, {3.5285948555906906`*^9, 
   3.528594936508033*^9}, {3.5285949979721403`*^9, 3.5285950379706106`*^9}, {
   3.528595075348276*^9, 3.528595214656521*^9}, {3.528595415491274*^9, 
   3.528595436442111*^9}, {3.528595716743403*^9, 3.5285958153043756`*^9}, {
   3.5285958613244567`*^9, 3.528595921665363*^9}, {3.528595966640242*^9, 
   3.5285960360447636`*^9}, {3.5285960777748375`*^9, 3.52859607930364*^9}, 
   3.528601840446159*^9, {3.5286066000129185`*^9, 3.528606611666139*^9}, {
   3.528607446049205*^9, 3.528607484815273*^9}, {3.5286179259540014`*^9, 
   3.528617959704932*^9}, {3.5286180519432077`*^9, 3.528618114140765*^9}, {
   3.5286181589773293`*^9, 3.528618194373354*^9}, 3.5286184556132965`*^9, 
   3.528618488088154*^9, {3.5286185781783066`*^9, 3.528618632754428*^9}, {
   3.52861872387864*^9, 3.5286187241576557`*^9}, {3.528618774981563*^9, 
   3.5286187752255774`*^9}, 3.5286189682036147`*^9, {3.528619009909*^9, 
   3.5286190120061197`*^9}, {3.5286190946578474`*^9, 
   3.5286191087146516`*^9}, {3.528619315707491*^9, 3.5286193447571526`*^9}, {
   3.528619463711956*^9, 3.5286194669911437`*^9}, {3.528620371183861*^9, 
   3.5286203951202297`*^9}, {3.5286209033112965`*^9, 3.528620919879244*^9}, 
   3.5286223512961164`*^9, {3.528623076495596*^9, 3.528623144708497*^9}, 
   3.5286232820913553`*^9, {3.528623566762637*^9, 3.5286235731130004`*^9}, {
   3.5286236053088417`*^9, 3.5286236085530276`*^9}, 3.528626247984015*^9, {
   3.528626781520552*^9, 3.528626784780958*^9}, {3.528661232733884*^9, 
   3.5286612707043505`*^9}, {3.528661336349266*^9, 3.5286613382992697`*^9}, {
   3.5286616800490694`*^9, 3.5286616810942717`*^9}, {3.5286827129700146`*^9, 
   3.528682768849313*^9}, {3.5286828313742228`*^9, 3.5286828366158323`*^9}, {
   3.5286833231086864`*^9, 3.5286833368835106`*^9}, {3.528683775181881*^9, 
   3.528683778255086*^9}, 3.528684083048422*^9, 3.528684715052332*^9, {
   3.528706369980212*^9, 3.5287063706354136`*^9}, {3.5287064276379137`*^9, 
   3.5287064386203327`*^9}, {3.5287065073540535`*^9, 3.5287065081652555`*^9}, 
   3.528707673144101*^9, {3.528708068183595*^9, 3.528708111286471*^9}, {
   3.5287082010178285`*^9, 3.5287082238406687`*^9}, {3.5287082804063683`*^9, 
   3.528708301076404*^9}, {3.5287084115557985`*^9, 3.5287084710231028`*^9}, {
   3.5287085276668024`*^9, 3.5287085444056315`*^9}, {3.5287088804302216`*^9, 
   3.5287089564959555`*^9}, {3.5287090576777334`*^9, 3.528709075929765*^9}, {
   3.5287091381114745`*^9, 3.5287092213376207`*^9}, {3.528709302254963*^9, 
   3.52870930643577*^9}, 3.5287093483374434`*^9, {3.5287094348707952`*^9, 
   3.5287094416100073`*^9}, {3.5287096881996403`*^9, 
   3.5287097234713025`*^9}, {3.528709914119237*^9, 3.528709931045267*^9}, {
   3.5287100656891036`*^9, 3.5287100685751085`*^9}, {3.5287101152191906`*^9, 
   3.5287101538136587`*^9}, {3.5287102067289515`*^9, 
   3.5287102325157967`*^9}, {3.528710322746355*^9, 3.528710347503598*^9}, {
   3.528710446891373*^9, 3.528710449543378*^9}, {3.528710495969059*^9, 
   3.5287104985118637`*^9}, {3.5287106328436995`*^9, 
   3.5287107211554546`*^9}, {3.528710818671226*^9, 3.528710845066472*^9}, {
   3.528710922161808*^9, 3.5287109421142426`*^9}, {3.5287116677183175`*^9, 
   3.5287116774527345`*^9}, {3.5287142000481653`*^9, 3.52871420831618*^9}, {
   3.528714318421173*^9, 3.5287143224615803`*^9}, {3.5287144033105226`*^9, 
   3.5287144322641735`*^9}, 3.5287144792826557`*^9, {3.5287146752346*^9, 
   3.5287146792126074`*^9}, {3.5287149707147193`*^9, 3.5287149896531525`*^9}, 
   3.528715023552012*^9, {3.528715174326277*^9, 3.528715224137164*^9}, 
   3.528715277972859*^9, {3.5289617234523983`*^9, 3.5289617346844177`*^9}, {
   3.528961871106657*^9, 3.528961873306261*^9}, {3.5289619986992817`*^9, 
   3.528962044656962*^9}, {3.5289622185504675`*^9, 3.5289622378009014`*^9}, {
   3.530407560119783*^9, 3.5304076741091833`*^9}, {3.5304080298386087`*^9, 
   3.5304080325218134`*^9}, {3.5304220760502825`*^9, 
   3.5304221546276207`*^9}, {3.533956568630308*^9, 3.533956665834079*^9}, 
   3.533956762975449*^9, 3.534709995286988*^9, 3.5347102702566714`*^9, {
   3.534710307587537*^9, 3.5347103104111423`*^9}, {3.5355943645733566`*^9, 
   3.535594376788178*^9}, 3.535594491198779*^9, 3.5364644067701993`*^9, 
   3.5470089687325697`*^9, 3.5470091814857435`*^9, 3.547010097738553*^9, 
   3.5470101745878887`*^9, {3.5470102237747755`*^9, 3.547010237268799*^9}, {
   3.547010380711051*^9, 3.5470103817718525`*^9}, {3.5470104851844344`*^9, 
   3.547010496198054*^9}, {3.5470106544943323`*^9, 3.5470106643379498`*^9}, 
   3.5501988381617746`*^9, 3.5501990644401717`*^9, 3.5501999267834873`*^9, 
   3.55019999637521*^9, 3.5502073267184286`*^9, 3.5502076353347707`*^9, 
   3.5502077484661694`*^9, 3.550207835311522*^9, 3.5502086336303244`*^9, 
   3.550208731848097*^9, 3.550210071001249*^9, 3.550347114335082*^9, {
   3.550801163206278*^9, 3.550801166139083*^9}, 3.550801269660865*^9, 
   3.550828851690422*^9, 3.5531145252783546`*^9, 3.5531145863212614`*^9, 
   3.55311514895185*^9, {3.5531151847383127`*^9, 3.553115215641967*^9}, 
   3.553115260164445*^9, {3.5531154473135815`*^9, 3.553115448514784*^9}, 
   3.5531154849408474`*^9, 3.553184125130948*^9, 3.5531844635735426`*^9, 
   3.553184932650767*^9, {3.5531850286689353`*^9, 3.5531850425373597`*^9}, {
   3.5534455293427954`*^9, 3.553445530746798*^9}, {3.5534883365952864`*^9, 
   3.553488340932094*^9}, 3.553543103023369*^9, {3.5642903301670055`*^9, 
   3.5642903301670055`*^9}, {3.564291253782228*^9, 3.564291279803074*^9}, {
   3.564291310691128*^9, 3.5642913116739297`*^9}, 3.5642913605800157`*^9, 
   3.5642913913588696`*^9, 3.5645701775490894`*^9, 3.5645702349415903`*^9, {
   3.5645704646519933`*^9, 3.5645704806576214`*^9}, {3.564632162083235*^9, 
   3.5646321622704353`*^9}, {3.5672835744635324`*^9, 3.567283599189576*^9}, 
   3.567283658984481*^9, 3.567283712648576*^9, {3.5672837757506866`*^9, 
   3.5672838367779937`*^9}, 3.567283936711769*^9, 3.5672839671942225`*^9, 
   3.567749304927465*^9, 3.567802786200432*^9, 3.5678028867426085`*^9, 
   3.568197679377499*^9, 3.5681977398588057`*^9, {3.568197770497259*^9, 
   3.568197789934893*^9}, 3.568197954873983*^9, 3.570075573527918*^9, 
   3.5700756161159925`*^9, 3.5700766576674213`*^9, {3.570086891428359*^9, 
   3.5700868916123695`*^9}, {3.570087021291787*^9, 3.5700870234839125`*^9}, {
   3.570087084260389*^9, 3.5700871039165125`*^9}, 3.5700872267835407`*^9, {
   3.5700962429593163`*^9, 3.570096251367731*^9}, 3.5700963382910833`*^9, 
   3.573604824020702*^9, 3.573604898479633*^9, 3.5736049445153136`*^9, {
   3.5736050810779533`*^9, 3.5736051059131975`*^9}, 3.573605138158454*^9, 
   3.5736051863625383`*^9, {3.573605233568221*^9, 3.5736052565938616`*^9}, 
   3.573605861250924*^9, 3.5736059303122454`*^9, 3.5736059609350986`*^9, {
   3.573605994537558*^9, 3.5736059957855597`*^9}, 3.573606094143733*^9, 
   3.5736061630646544`*^9, {3.5736066875826025`*^9, 3.5736067019502277`*^9}, 
   3.573615827794015*^9, 3.573616064212538*^9, {3.5736161174245815`*^9, 
   3.573616176377953*^9}, 3.573616231172087*^9, 3.573616275574627*^9, {
   3.5736164520657215`*^9, 3.5736164539218273`*^9}, {3.574885930536127*^9, 
   3.574885961158981*^9}, {3.5748860538543434`*^9, 3.574886055414346*^9}, {
   3.57488610316603*^9, 3.574886104788433*^9}, 3.575772368950635*^9, 
   3.575772414543243*^9, {3.5757724483991795`*^9, 3.575772496190913*^9}, {
   3.575772614086656*^9, 3.5757726286944914`*^9}, 3.5757726590812297`*^9, {
   3.5759741411197433`*^9, 3.5759741561581697`*^9}, {3.5759742021002502`*^9, 
   3.5759742157346745`*^9}, 3.5768732485823507`*^9, {3.5768733225420804`*^9, 
   3.576873346644123*^9}, {3.5768734557819147`*^9, 3.576873461850325*^9}, {
   3.5768734924263787`*^9, 3.57687352147363*^9}, {3.5770554598819695`*^9, 
   3.577055463204776*^9}, 3.5778715362491693`*^9, {3.5778716912240334`*^9, 
   3.577871702816696*^9}, 3.5778717565767713`*^9, {3.5778718371413794`*^9, 
   3.577871932399828*^9}, 3.5779963889137025`*^9, {3.5779971639186645`*^9, 
   3.577997164261865*^9}, 3.577997327712983*^9, {3.5779973707690587`*^9, 
   3.577997383857482*^9}, 3.577997501216488*^9, {3.592182738845936*^9, 
   3.592182738861536*^9}, 3.592182944360697*^9, 3.5921830186012273`*^9, 
   3.592189432880093*^9, 3.592189463674547*^9, {3.592189504297019*^9, 
   3.592189506559023*^9}, 3.592189562375921*^9, {3.592189594262377*^9, 
   3.5921896106424055`*^9}, 3.5921897904795218`*^9, 3.592189846156019*^9, 
   3.592355462843272*^9, 3.59938841163758*^9, {3.599388677087646*^9, 
   3.599388684560059*^9}, 3.5993887418121595`*^9, 3.5993887919038477`*^9, 
   3.599389809202035*^9, 3.5994506393849616`*^9, 3.606352380183405*^9, {
   3.6063536387788167`*^9, 3.606353654363244*^9}, {3.606353693441313*^9, 
   3.6063537178865557`*^9}, 3.606354117960466*^9, {3.6063541792997737`*^9, 
   3.606354199065008*^9}, 3.606354347452469*^9, {3.606355491121396*^9, 
   3.606355500497013*^9}, {3.6063556639697*^9, 3.606355691815749*^9}, {
   3.606355951598206*^9, 3.606355974249446*^9}, 3.6063566362550087`*^9, 
   3.6063623067270436`*^9, 3.6063641073134065`*^9, 3.6063646163423004`*^9, {
   3.606424064606145*^9, 3.606424095525399*^9}, 3.606435037067684*^9, 
   3.6253066976903305`*^9, 3.6253067308559885`*^9, {3.625307148703523*^9, 
   3.6253071524163303`*^9}, 3.6253071875163918`*^9, 3.6253072177180443`*^9, {
   3.625307746315781*^9, 3.625307759903405*^9}, {3.625307823676317*^9, 
   3.625307828637126*^9}, 3.62530786493839*^9, 3.625308047693511*^9, {
   3.6253081020908065`*^9, 3.6253081157564306`*^9}, {3.6253833845823274`*^9, 
   3.6253833858459296`*^9}, 3.6253834204935904`*^9, 3.6291871979741755`*^9, 
   3.6291872594694834`*^9, {3.6291872945851455`*^9, 3.6291873218851933`*^9}, 
   3.6291877401579294`*^9, 3.6291877836352053`*^9, 3.6291878504345226`*^9, 
   3.629188085136935*^9, {3.6291893908088293`*^9, 3.62918939137043*^9}, 
   3.629412984390986*^9, {3.6296819408526163`*^9, 3.629681967825063*^9}, 
   3.6296830686522045`*^9, {3.6296838311971436`*^9, 3.629683868200409*^9}, 
   3.629684076866375*^9, 3.6296853116949444`*^9, 3.6301301057327366`*^9, 
   3.630186815320861*^9, 3.630191351912052*^9, {3.630191442251811*^9, 
   3.630191443047412*^9}, {3.6301915674264307`*^9, 3.630191567582431*^9}, 
   3.630191627034135*^9, 3.6301916686862087`*^9, {3.630191698872261*^9, 
   3.630191748199548*^9}, 3.6301925032876744`*^9, 3.6302240261576805`*^9, 
   3.6325489666245556`*^9, 3.6325493494752283`*^9, 3.632549601344486*^9, 
   3.6325497935128317`*^9, {3.6325499103370447`*^9, 3.632549935952289*^9}, {
   3.6326052493632545`*^9, 3.6326052629040785`*^9}, 3.63278969455567*^9, {
   3.632789742073353*^9, 3.632789791213439*^9}, 3.632789884486003*^9, 
   3.63279000237541*^9, 3.632798142408646*^9, 3.6327982664912643`*^9, 
   3.6328077266600885`*^9, 3.6328077568617415`*^9, {3.6328139368782277`*^9, 
   3.6328140112279577`*^9}, {3.632814042646413*^9, 3.6328140428492136`*^9}, {
   3.6328142255199356`*^9, 3.6328142422743645`*^9}, {3.6328628377011323`*^9, 
   3.6328628382471333`*^9}, 3.632863071561143*^9, 3.6328903827053213`*^9, {
   3.63450396414303*^9, 3.634503989945475*^9}, 3.634505031134311*^9, {
   3.6345050814287996`*^9, 3.6345050826300015`*^9}, {3.634505119567073*^9, 
   3.6345051390203075`*^9}, {3.63450518026678*^9, 3.6345051946500053`*^9}, {
   3.634505252089306*^9, 3.634505279467354*^9}, {3.6345559523854685`*^9, 
   3.634555955614674*^9}, 3.634556221122741*^9, {3.6360748556676345`*^9, 
   3.636074857804838*^9}, 3.6360754056294017`*^9, 3.6360755416304407`*^9, {
   3.636075572097294*^9, 3.6360755749364986`*^9}, 3.6360756677410617`*^9, 
   3.6360760229536858`*^9, {3.6360760624173627`*^9, 3.6360760925254154`*^9}, 
   3.6360761236318703`*^9, {3.636495351875679*^9, 3.636495380361329*^9}, 
   3.636495512727562*^9, 3.6364955557680373`*^9, 3.636495774451644*^9, {
   3.636495808288103*^9, 3.6364958628569994`*^9}, 3.636495995379232*^9, 
   3.6364961521595078`*^9, 3.6364963213886046`*^9, 3.636496426595189*^9, 
   3.636496986184173*^9, {3.6367624760855265`*^9, 3.636762479361532*^9}, 
   3.7255924293790016`*^9, 3.7255925317463818`*^9, 3.7255944743117948`*^9, {
   3.725594518943473*^9, 3.7255945214862776`*^9}, 3.7255953603777514`*^9, 
   3.7255957972769194`*^9, {3.7255958312537794`*^9, 3.7255958481174088`*^9}, {
   3.725596058390178*^9, 3.7255960649109898`*^9}, 3.7255963371938677`*^9, 
   3.72559640661399*^9, {3.725601386418369*^9, 3.7256014341076527`*^9}, 
   3.7257712704994154`*^9, 3.725774257093461*^9, 3.72577429072712*^9, {
   3.725774416443348*^9, 3.7257744278937683`*^9}, 3.725779901988584*^9, 
   3.72578045202995*^9, 3.7258490308793774`*^9, 3.7258521063247805`*^9, 
   3.725852262605855*^9, 3.725852360558427*^9, 3.7258524069529085`*^9, 
   3.725852753257917*^9, 3.725853436567118*^9, {3.7258534847400026`*^9, 
   3.7258535107140484`*^9}, {3.725853667353924*^9, 3.7258536787419434`*^9}, 
   3.726913461475872*^9, {3.726913506715952*^9, 3.7269135067315516`*^9}, 
   3.726913573655669*^9, 3.7269142285136194`*^9, {3.7269143657158604`*^9, 
   3.7269143772130804`*^9}, 3.726914441095193*^9, 3.7269145189861298`*^9, 
   3.726914651929563*^9, 3.7269147274648952`*^9, 3.726915143191228*^9, {
   3.7269151750932837`*^9, 3.7269151752336836`*^9}, {3.7269155027638597`*^9, 
   3.726915507599868*^9}, {3.726942965317898*^9, 3.7269429659418993`*^9}, 
   3.7269527321998544`*^9, {3.732581567667375*^9, 3.732581616495461*^9}, {
   3.732658450427137*^9, 3.732658468772769*^9}, {3.732658950832816*^9, 
   3.7326589718928533`*^9}, 3.7326593484319158`*^9, 3.7326684474112062`*^9, {
   3.740218164622918*^9, 3.740218189130562*^9}, 3.7402182402830515`*^9, {
   3.7402183944893227`*^9, 3.7402184164385605`*^9}, 3.740218476010673*^9, 
   3.740218965392333*^9, 3.7402207306098347`*^9, 3.740623523847764*^9, {
   3.7407786224156923`*^9, 3.7407786244124956`*^9}, {3.740778719260662*^9, 
   3.7407787320526843`*^9}, {3.7407792555464067`*^9, 3.7407793011608863`*^9}, 
   3.7407793394121532`*^9, {3.740779664601926*^9, 3.7407796776747484`*^9}, 
   3.7407805414526663`*^9, 3.740780576287527*^9, 3.7407807802890854`*^9, 
   3.74078247376919*^9, {3.7407839511537724`*^9, 3.7407839979846582`*^9}, 
   3.7407842696709504`*^9, {3.740784331289063*^9, 3.7407843341800685`*^9}, {
   3.740784465266109*^9, 3.7407844673429127`*^9}, 3.740784531285632*^9, 
   3.74078474467282*^9, {3.740785226216671*^9, 3.740785234380486*^9}, {
   3.74079231722311*^9, 3.740792318034312*^9}, 3.740795728899905*^9, 
   3.740795848146515*^9, 3.740796253029626*^9, 3.7407962960389013`*^9, 
   3.7407968627566967`*^9, 3.7407969034103684`*^9, {3.7411140723503017`*^9, 
   3.7411140740039043`*^9}, 3.7411141862149014`*^9, {3.7411142414077983`*^9, 
   3.7411142788634644`*^9}, {3.741114361278409*^9, 3.741114362464011*^9}, 
   3.741114397938473*^9, 3.7411144525385695`*^9, 3.741165060176092*^9, 
   3.741166736872638*^9, 3.7411668048419576`*^9, 3.741167005957511*^9, 
   3.741892706493498*^9, 3.7446637127156367`*^9, 3.744664185162467*^9, 
   3.7446656128001237`*^9, 3.7446656519561925`*^9, 3.7447503942786407`*^9, 
   3.7448755599807453`*^9, 3.7452127385678663`*^9, 3.7452130555136228`*^9, 
   3.7452134456391077`*^9, {3.7452134806767693`*^9, 3.7452134813007703`*^9}, 
   3.745213585493354*^9, 3.745213767873274*^9, {3.7452137983869276`*^9, 
   3.7452138193377643`*^9}, {3.745213904810314*^9, 3.7452139139363303`*^9}, {
   3.745213949395193*^9, 3.7452139495823927`*^9}, {3.745213986975659*^9, 
   3.74521402177932*^9}, {3.7452153772273006`*^9, 3.7452153940753307`*^9}, {
   3.7452158730613728`*^9, 3.745215903824627*^9}, {3.7452159530895133`*^9, 
   3.7452159792039595`*^9}, 3.745216259770452*^9, 3.7460520035615406`*^9, {
   3.746054453943448*^9, 3.7460544574378543`*^9}, 3.746054497295924*^9, 
   3.746054597682101*^9, {3.7460547541659756`*^9, 3.7460547746800117`*^9}, 
   3.7460548541777515`*^9, 3.746054960086337*^9, 3.746991665534811*^9, 
   3.746995590370906*^9, 3.7469956213057604`*^9, {3.746995729995552*^9, 
   3.746995731243554*^9}, {3.7469957645028124`*^9, 3.746995765407614*^9}, {
   3.746995818198107*^9, 3.7469958661213913`*^9}, {3.7469959375383167`*^9, 
   3.746995941453923*^9}, {3.747000815490528*^9, 3.7470008173313313`*^9}, {
   3.7470008849886503`*^9, 3.7470008863926525`*^9}, {3.7470275513438883`*^9, 
   3.7470275518742895`*^9}, {3.7470280525595703`*^9, 3.7470280552115746`*^9}, 
   3.7481111897753506`*^9, 3.7481112427842436`*^9, 3.748111476535054*^9, 
   3.7481115164555244`*^9, 3.7481117566959467`*^9, 3.7481117914684076`*^9, 
   3.7481118423556967`*^9, 3.7481119434438744`*^9, 3.7481119960783668`*^9, 
   3.7481126379102945`*^9, 3.7481127727725315`*^9, 3.748112894015944*^9, 
   3.7481129700816774`*^9, {3.748113028800181*^9, 3.748113030016983*^9}, 
   3.7481131110123253`*^9, 3.748114875740626*^9, 3.748152382102949*^9, 
   3.748156767894652*^9, 3.749668431509885*^9, 3.7507169249859457`*^9, {
   3.7507174668996973`*^9, 3.750717469458102*^9}, 3.750718004418642*^9, 
   3.750718074774766*^9, 3.7507181111072297`*^9, {3.7507182219610243`*^9, 
   3.7507182332866445`*^9}, 3.7507183577748632`*^9, {3.750719884635145*^9, 
   3.750719897083967*^9}, 3.750720673464531*^9, 3.7507242419383993`*^9, 
   3.7507256027451925`*^9, 3.750744003618518*^9, {3.750744093771076*^9, 
   3.7507440965790815`*^9}, 3.7511831548293476`*^9, 3.7511832008026285`*^9, {
   3.751189424649564*^9, 3.7511894256479654`*^9}, 3.7511895614618044`*^9, {
   3.7511910305075865`*^9, 3.7511910391500015`*^9}, {3.751192237613307*^9, 
   3.751192254305336*^9}, 3.751230212036337*^9, {3.751274116442066*^9, 
   3.7512741166136665`*^9}, 3.751343682541116*^9, {3.751343733085205*^9, 
   3.7513437501204348`*^9}, 3.751344238166094*^9, 3.75134430452861*^9, {
   3.751345479669874*^9, 3.7513454796854744`*^9}, 3.751345820748873*^9, {
   3.7513459524443045`*^9, 3.7513459532399063`*^9}, 3.751346262260849*^9, {
   3.751348105092086*^9, 3.7513481245765195`*^9}, {3.7513566618091145`*^9, 
   3.751356668220726*^9}, {3.751358491060729*^9, 3.7513584912323294`*^9}, {
   3.75135877156363*^9, 3.75135877173523*^9}, 3.751359211999203*^9, 
   3.755049981976758*^9, 3.7550500821133337`*^9, 3.7550501621414747`*^9, {
   3.755050416297121*^9, 3.7550504199943275`*^9}, 3.7550509388668385`*^9, 
   3.7550519367687855`*^9, {3.755051997187691*^9, 3.755052060695403*^9}, 
   3.7550521337191315`*^9, 3.7550521647007856`*^9, 3.7550613876302633`*^9, 
   3.7551379564936295`*^9, {3.755138024930949*^9, 3.7551380411237783`*^9}, 
   3.755138082682251*^9, {3.7551381845348296`*^9, 3.7551382172792873`*^9}, 
   3.7551383234530735`*^9, {3.755138441217681*^9, 3.7551385276106324`*^9}, {
   3.755138882422056*^9, 3.755138897273282*^9}, {3.7551414688371882`*^9, 
   3.7551414693363895`*^9}, 3.755142317557621*^9, 3.755143433067379*^9, {
   3.7551476031529503`*^9, 3.7551476133397684`*^9}, 3.7551478086989117`*^9, 
   3.7552236306785617`*^9, 3.7552237351007524`*^9, {3.7552275045464*^9, 
   3.7552275077132063`*^9}, 3.7642903539579687`*^9, 3.76429053655789*^9, {
   3.7642905687251463`*^9, 3.7642906105332203`*^9}, 3.764290668502922*^9, {
   3.7642907246006203`*^9, 3.764290784832326*^9}, {3.7642908265935993`*^9, 
   3.7642908360628157`*^9}, 3.7642909449510074`*^9, {3.764290981189871*^9, 
   3.764290981876272*^9}, 3.7642912047834673`*^9, {3.764291319491269*^9, 
   3.764291321378873*^9}, 3.764291611398982*^9, 3.7643023539758563`*^9, 
   3.7643023976559334`*^9, 3.764304230323553*^9, 3.7643178534248857`*^9, 
   3.7643204595866685`*^9, 3.764370162398338*^9, 3.764372959000451*^9, {
   3.7643746106161537`*^9, 3.7643746108813543`*^9}, 3.764384946199549*^9, 
   3.764385323602227*^9, 3.7646681264950523`*^9, 3.764668209284398*^9, {
   3.7646682425904565`*^9, 3.7646682533076754`*^9}, 3.764668288563737*^9, 
   3.764668544731787*^9, 3.764887973290904*^9, 3.7648880093425674`*^9, 
   3.7648889030021396`*^9, {3.7648903950293617`*^9, 3.7648904044205785`*^9}, {
   3.764890442796646*^9, 3.7648904429526463`*^9}, 3.7648906360965853`*^9, 
   3.7648967215975685`*^9, 3.765060789137452*^9, 3.7651708746726866`*^9, 
   3.7651709275255795`*^9, {3.765171589180749*^9, 3.765171597479964*^9}, {
   3.765172134970908*^9, 3.765172146390128*^9}, 3.7652588607251368`*^9, 
   3.765258911924426*^9, 3.7652678488217335`*^9, 3.766219677032467*^9, 
   3.766219733644967*^9, 3.766220209789003*^9, 3.766224738350159*^9, {
   3.766371673365609*^9, 3.7663716735372095`*^9}, {3.7664771999078894`*^9, 
   3.766477221467128*^9}, {3.7664774867923937`*^9, 3.7664775002552176`*^9}, {
   3.768845899023299*^9, 3.768845913219324*^9}, {3.768846446688262*^9, 
   3.7688464478114643`*^9}, {3.7688469105734777`*^9, 3.768846911556279*^9}, {
   3.7756127125728536`*^9, 3.775612713805256*^9}, 3.791925257473979*^9, 
   3.7919253465779333`*^9, 3.791925415545993*^9, 3.791925538329486*^9, 
   3.791925601252158*^9, {3.7919258208123755`*^9, 3.791925846181349*^9}, {
   3.7919258965132446`*^9, 3.791925926459304*^9}, {3.791926014071001*^9, 
   3.7919260175701747`*^9}, 3.7919266484290524`*^9, {3.7919272055886946`*^9, 
   3.791927235331627*^9}, {3.7919276582332497`*^9, 3.7919277101428995`*^9}, {
   3.7919283378467164`*^9, 3.7919283439703007`*^9}, 3.791928389264398*^9, 
   3.7919411413389997`*^9, 3.791941230396061*^9, 3.7919430979993715`*^9, 
   3.7919455907781906`*^9, 3.7919456413443985`*^9, 3.791945710086*^9, {
   3.791946022624746*^9, 3.791946071628796*^9}, 3.7919462750182886`*^9, {
   3.7919463468763237`*^9, 3.791946348454059*^9}, {3.7919485149966345`*^9, 
   3.7919485152934113`*^9}, 3.7921427775327096`*^9, 3.7921428844917583`*^9, {
   3.792143012102148*^9, 3.7921430326754313`*^9}, {3.7921430729159*^9, 
   3.7921430957230043`*^9}, {3.792143137525601*^9, 3.7921431788751917`*^9}, 
   3.792143236720871*^9, {3.7921435062050405`*^9, 3.7921435066268454`*^9}, {
   3.792144999623945*^9, 3.792145021384448*^9}, {3.7921451021622267`*^9, 
   3.7921451511037264`*^9}, 3.792145185720539*^9, {3.7921455447136655`*^9, 
   3.792145545432212*^9}, {3.792184507470749*^9, 3.7921845096108675`*^9}, 
   3.792184641720213*^9, {3.792206627246333*^9, 3.792206627246333*^9}, 
   3.792206751388796*^9, {3.792206853864559*^9, 3.7922068746252704`*^9}, 
   3.7922073162553945`*^9, 3.7922074838563423`*^9, {3.792207902303128*^9, 
   3.7922079240167284`*^9}, 3.792210628560286*^9, {3.7922705977436914`*^9, 
   3.7922705977436914`*^9}, {3.7922709171055946`*^9, 3.7922709214014473`*^9}, 
   3.7922710012262707`*^9, 3.7922710487775407`*^9, {3.7922714048807282`*^9, 
   3.792271416690432*^9}, {3.7922722543810005`*^9, 3.7922722888259625`*^9}, 
   3.7922726333057737`*^9, 3.792538656581356*^9, 3.79253893338968*^9, {
   3.79253897772618*^9, 3.792538997607256*^9}, {3.7925390932423153`*^9, 
   3.7925390962103596`*^9}, 3.792539159820304*^9, 3.792539240269972*^9, {
   3.7925532546452465`*^9, 3.7925533205046535`*^9}, {3.792553601937978*^9, 